/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.utility;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;

public class EndOfServiceWaiter
implements ServiceStateChangeListener {
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final String name;
    private Service service;

    public EndOfServiceWaiter(Service service) {
        this(service.getName(), service);
    }

    public EndOfServiceWaiter(String name, Service service) {
        this.name = name;
        this.service = service;
        service.registerServiceListener((ServiceStateChangeListener)this);
    }

    public synchronized void waitForServiceToStop(long timeout) throws InterruptedException, TimeoutException {
        this.service.waitForServiceToStop(timeout);
        if (!this.finished.get()) {
            this.wait(timeout);
            if (!this.finished.get()) {
                throw new TimeoutException(String.valueOf(this.name) + " did not finish after " + timeout + " milliseconds");
            }
        }
    }

    public synchronized void stateChanged(Service service) {
        if (service.isInState(Service.STATE.STOPPED)) {
            this.finished.set(true);
            this.notify();
        }
    }
}

