/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.util.Time;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.actions.RenewingAction;
import org.apache.slider.server.appmaster.state.AppState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsDelegationTokenManager {
    private final QueueAccess queue;
    private RenewingAction<RenewAction> renewingAction;
    private UserGroupInformation remoteUser;
    private UserGroupInformation currentUser;
    private static final Logger log = LoggerFactory.getLogger(FsDelegationTokenManager.class);
    private long renewInterval;
    private RenewAction renewAction;
    private String tokenName;

    public FsDelegationTokenManager(QueueAccess queue) throws IOException {
        this.queue = queue;
        this.currentUser = UserGroupInformation.getCurrentUser();
    }

    private void createRemoteUser(Configuration configuration) throws IOException {
        Configuration loginConfig = new Configuration(configuration);
        loginConfig.set("hadoop.security.authentication", "kerberos");
        this.remoteUser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SecurityUtil.getServerPrincipal((String)loginConfig.get("dfs.namenode.kerberos.principal"), (String)InetAddress.getLocalHost().getCanonicalHostName()), (String)loginConfig.get("dfs.namenode.keytab.file"));
        log.info("Created remote user {}.  UGI reports current user is {}", (Object)this.remoteUser, (Object)UserGroupInformation.getCurrentUser());
    }

    public void acquireDelegationToken(Configuration configuration) throws IOException, InterruptedException {
        if (this.remoteUser == null) {
            this.createRemoteUser(configuration);
        }
        if (SliderUtils.isHadoopClusterSecure(configuration) && this.renewingAction == null) {
            this.renewInterval = configuration.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L);
            this.renewAction = new RenewAction("HDFS renew", configuration);
            Token<?> token = this.renewAction.getToken();
            this.currentUser.addToken(token.getService(), token);
            log.info("HDFS delegation token {} acquired and set as credential for current user", token);
            this.renewingAction = new RenewingAction<RenewAction>(this.renewAction, (int)this.renewInterval, (int)this.renewInterval, TimeUnit.MILLISECONDS, this.getRenewingLimit());
            log.info("queuing HDFS delegation token renewal interval of {} milliseconds", (Object)this.renewInterval);
            this.queue(this.renewingAction);
        }
    }

    public void cancelDelegationToken(Configuration configuration) throws IOException, InterruptedException {
        this.queue.removeRenewingAction(this.getRenewingActionName());
        if (this.renewAction != null) {
            this.renewAction.getToken().cancel(configuration);
        }
        log.info("Renewing action {} removed and HDFS delegation token renewal cancelled", (Object)this.getRenewingActionName());
    }

    protected int getRenewingLimit() {
        return 0;
    }

    protected void queue(RenewingAction<RenewAction> action) {
        this.queue.renewing(this.getRenewingActionName(), action);
    }

    protected String getRenewingActionName() {
        if (this.tokenName == null) {
            this.tokenName = "HDFS renewing token " + UUID.randomUUID();
        }
        return this.tokenName;
    }

    protected FileSystem getRemoteFileSystemForRenewal(Configuration config) throws IOException {
        return FileSystem.get((Configuration)config);
    }

    class RenewAction
    extends AsyncAction {
        Configuration configuration;
        Token<?> token;
        private long tokenExpiryTime;
        private final FileSystem fs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RenewAction(String name, Configuration configuration) throws IOException, InterruptedException {
            super(name);
            this.configuration = configuration;
            FileSystem fileSystem = this.fs = this.getFileSystem();
            synchronized (fileSystem) {
                this.token = (Token)FsDelegationTokenManager.this.remoteUser.doAs(new PrivilegedExceptionAction<Token<?>>(){

                    @Override
                    public Token<?> run() throws Exception {
                        log.info("Obtaining HDFS delgation token with user {}", (Object)FsDelegationTokenManager.this.remoteUser.getShortUserName());
                        Token token = RenewAction.this.fs.getDelegationToken(FsDelegationTokenManager.this.remoteUser.getShortUserName());
                        RenewAction.this.tokenExpiryTime = RenewAction.this.getTokenExpiryTime(token);
                        log.info("Initial delegation token obtained with expiry time of {}", (Object)RenewAction.this.getPrintableExpirationTime(RenewAction.this.tokenExpiryTime));
                        return token;
                    }
                });
            }
            log.info("Initial request returned delegation token {}", this.token);
        }

        private long getTokenExpiryTime(Token token) throws IOException {
            AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
            return id.getMaxDate();
        }

        protected FileSystem getFileSystem() throws IOException, InterruptedException {
            return (FileSystem)FsDelegationTokenManager.this.remoteUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    Configuration config = new Configuration(RenewAction.this.configuration);
                    config.setBoolean("fs.hdfs.impl.disable.cache", true);
                    return FsDelegationTokenManager.this.getRemoteFileSystemForRenewal(config);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
            if (this.fs != null) {
                FileSystem fileSystem = this.fs;
                synchronized (fileSystem) {
                    try {
                        ((Long)FsDelegationTokenManager.this.remoteUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                            @Override
                            public Long run() throws Exception {
                                long expires = RenewAction.this.token.renew(RenewAction.this.fs.getConf());
                                log.info("HDFS delegation token renewed.  Renewal cycle ends at {}", (Object)RenewAction.this.getPrintableExpirationTime(expires));
                                return expires;
                            }
                        })).longValue();
                        long calculatedInterval = this.tokenExpiryTime - Time.now();
                        if (calculatedInterval < FsDelegationTokenManager.this.renewInterval) {
                            log.info("Interval of {} less than renew interval.  Getting new token", (Object)calculatedInterval);
                            this.getNewToken();
                        } else {
                            this.updateRenewalTime(FsDelegationTokenManager.this.renewInterval);
                        }
                    }
                    catch (IOException ie) {
                        log.info("Exception raised by renew", (Throwable)ie);
                        this.getNewToken();
                    }
                }
            }
        }

        private String getPrintableExpirationTime(long expires) {
            Date d = new Date(expires);
            return DateFormat.getDateTimeInstance().format(d);
        }

        private void getNewToken() throws InterruptedException, IOException {
            try {
                Text service = this.token.getService();
                Token[] tokens = (Token[])FsDelegationTokenManager.this.remoteUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<?>[]>(){

                    @Override
                    public Token<?>[] run() throws Exception {
                        return RenewAction.this.fs.addDelegationTokens(FsDelegationTokenManager.this.remoteUser.getShortUserName(), null);
                    }
                });
                if (tokens.length == 0) {
                    throw new IOException("addDelegationTokens returned no tokens");
                }
                this.token = this.findMatchingToken(service, tokens);
                FsDelegationTokenManager.this.currentUser.addToken(this.token.getService(), this.token);
                this.tokenExpiryTime = this.getTokenExpiryTime(this.token);
                log.info("Expired HDFS delegation token replaced and added as credential to current user.  Token expires at {}", (Object)this.getPrintableExpirationTime(this.tokenExpiryTime));
                this.updateRenewalTime(FsDelegationTokenManager.this.renewInterval);
            }
            catch (IOException ie2) {
                throw new IOException("Can't get new delegation token ", ie2);
            }
        }

        private void updateRenewalTime(long interval) {
            long delay = interval - interval / 10L;
            FsDelegationTokenManager.this.renewingAction.updateInterval(delay, TimeUnit.MILLISECONDS);
            log.info("Token renewal set for {} ms from now", (Object)delay);
        }

        private Token<?> findMatchingToken(Text service, Token<?>[] tokens) {
            Token<?> token = null;
            int i = 0;
            while (token == null && i < tokens.length) {
                if (tokens[i].getService().equals((Object)service)) {
                    token = tokens[i];
                }
                ++i;
            }
            return token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Token<?> getToken() {
            FileSystem fileSystem = this.fs;
            synchronized (fileSystem) {
                return this.token;
            }
        }
    }
}

