/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.operations.CancelSingleRequest;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.apache.slider.server.appmaster.state.RoleHostnamePair;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutstandingRequest
extends RoleHostnamePair {
    protected static final Logger log = LoggerFactory.getLogger(OutstandingRequest.class);
    public final NodeInstance node;
    public final List<NodeInstance> nodes = new ArrayList<NodeInstance>(1);
    public String label;
    private AMRMClient.ContainerRequest issuedRequest;
    private long requestedTimeMillis;
    private long escalationTimeoutMillis;
    private boolean escalated;
    private boolean mayEscalate;
    private int priority = -1;
    private boolean antiAffine = false;

    public OutstandingRequest(int roleId, NodeInstance node) {
        super(roleId, node != null ? node.hostname : null);
        this.node = node;
        this.nodes.add(node);
    }

    public OutstandingRequest(int roleId, String hostname) {
        super(roleId, hostname);
        this.node = null;
    }

    public OutstandingRequest(int roleId, List<NodeInstance> nodes) {
        super(roleId, nodes.get((int)0).hostname);
        this.node = null;
        this.antiAffine = true;
        this.nodes.addAll(nodes);
    }

    public boolean isLocated() {
        return this.node != null;
    }

    public long getRequestedTimeMillis() {
        return this.requestedTimeMillis;
    }

    public long getEscalationTimeoutMillis() {
        return this.escalationTimeoutMillis;
    }

    public boolean isEscalated() {
        return this.escalated;
    }

    public boolean mayEscalate() {
        return this.mayEscalate;
    }

    public AMRMClient.ContainerRequest getIssuedRequest() {
        return this.issuedRequest;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isAntiAffine() {
        return this.antiAffine;
    }

    public void setAntiAffine(boolean antiAffine) {
        this.antiAffine = antiAffine;
    }

    public synchronized AMRMClient.ContainerRequest buildContainerRequest(Resource resource, RoleStatus role, long time) {
        String nodeLabels;
        boolean relaxLocality;
        String[] hosts;
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"null `resource` arg");
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"null `role` arg");
        this.label = role.getLabelExpression();
        this.requestedTimeMillis = time;
        this.escalationTimeoutMillis = time + role.getPlacementTimeoutSeconds() * 1000L;
        boolean strictPlacement = role.isStrictPlacement();
        NodeInstance target = this.node;
        if (this.isAntiAffine()) {
            int size = this.nodes.size();
            log.info("Creating anti-affine request across {} nodes; first node = {}", (Object)size, (Object)this.hostname);
            hosts = new String[size];
            StringBuilder builder = new StringBuilder(size * 16);
            int c = 0;
            for (NodeInstance nodeInstance : this.nodes) {
                hosts[c++] = nodeInstance.hostname;
                builder.append(nodeInstance.hostname).append(" ");
            }
            log.debug("Full host list: [ {}]", (Object)builder);
            this.escalated = false;
            this.mayEscalate = false;
            relaxLocality = false;
            nodeLabels = null;
        } else if (target != null) {
            hosts = new String[]{target.hostname};
            relaxLocality = false;
            log.info("Submitting request for container on {}", (Object)hosts[0]);
            this.escalated = false;
            this.mayEscalate = !strictPlacement;
            nodeLabels = null;
        } else {
            hosts = null;
            relaxLocality = true;
            this.escalated = true;
            this.mayEscalate = false;
            nodeLabels = this.label;
        }
        Priority pri = ContainerPriority.createPriority(this.roleId, !relaxLocality);
        this.priority = pri.getPriority();
        this.issuedRequest = new AMRMClient.ContainerRequest(resource, hosts, null, pri, relaxLocality, nodeLabels);
        this.validate();
        return this.issuedRequest;
    }

    public synchronized AMRMClient.ContainerRequest escalate() {
        Preconditions.checkNotNull((Object)this.issuedRequest, (Object)("cannot escalate if request not issued " + this));
        this.escalated = true;
        Priority pri = ContainerPriority.createPriority(this.roleId, false);
        this.priority = pri.getPriority();
        List issuedRequestNodes = this.issuedRequest.getNodes();
        String[] nodes = SliderUtils.isUnset(this.label) && issuedRequestNodes != null ? issuedRequestNodes.toArray(new String[issuedRequestNodes.size()]) : null;
        this.issuedRequest = new AMRMClient.ContainerRequest(this.issuedRequest.getCapability(), nodes, null, pri, true, this.label);
        this.validate();
        return this.issuedRequest;
    }

    public void completed() {
        if (this.node != null) {
            this.node.getOrCreate(this.roleId).requestCompleted();
        }
    }

    public synchronized boolean shouldEscalate(long time) {
        return this.mayEscalate && !this.escalated && this.issuedRequest != null && this.escalationTimeoutMillis < time;
    }

    public synchronized boolean resourceRequirementsMatch(Resource resource) {
        return this.issuedRequest != null && Resources.fitsIn((Resource)this.issuedRequest.getCapability(), (Resource)resource);
    }

    @Override
    public String toString() {
        boolean requestHasLocation = ContainerPriority.hasLocation(this.getPriority());
        StringBuilder sb = new StringBuilder("OutstandingRequest{");
        sb.append("roleId=").append(this.roleId);
        if (this.hostname != null) {
            sb.append(", hostname='").append(this.hostname).append('\'');
        }
        sb.append(", node=").append(this.node);
        sb.append(", hasLocation=").append(requestHasLocation);
        sb.append(", requestedTimeMillis=").append(this.requestedTimeMillis);
        sb.append(", mayEscalate=").append(this.mayEscalate);
        sb.append(", escalated=").append(this.escalated);
        sb.append(", escalationTimeoutMillis=").append(this.escalationTimeoutMillis);
        sb.append(", issuedRequest=").append(this.issuedRequest != null ? SliderUtils.requestToString(this.issuedRequest) : "(null)");
        sb.append('}');
        return sb.toString();
    }

    public CancelSingleRequest createCancelOperation() {
        Preconditions.checkState((this.issuedRequest != null ? 1 : 0) != 0, (Object)"No issued request to cancel");
        return new CancelSingleRequest(this.issuedRequest);
    }

    public void validate() throws InvalidContainerRequestException {
        Preconditions.checkNotNull((Object)this.issuedRequest, (Object)"request has not yet been built up");
        AMRMClient.ContainerRequest containerRequest = this.issuedRequest;
        String exp = containerRequest.getNodeLabelExpression();
        if (exp == null || exp.isEmpty()) {
            return;
        }
        if (exp.contains("&&") || exp.contains("||")) {
            throw new InvalidContainerRequestException("Cannot specify more than two node labels in a single node label expression: " + this);
        }
        if (containerRequest.getRacks() != null && !containerRequest.getRacks().isEmpty() || containerRequest.getNodes() != null && !containerRequest.getNodes().isEmpty()) {
            throw new InvalidContainerRequestException("Cannot specify node label with rack and node: " + this);
        }
        boolean hasLocation = ContainerPriority.hasLocation(this.priority);
        if (containerRequest.getRelaxLocality() != !hasLocation) {
            throw new InvalidContainerRequestException("relax location flag doesn't match container priority: " + this);
        }
    }

    public RoleHostnamePair getIndex() {
        return new RoleHostnamePair(this.roleId, this.hostname);
    }
}

