/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.monkey;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.slider.server.appmaster.actions.ActionKillContainer;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.monkey.ChaosTarget;
import org.apache.slider.server.appmaster.operations.RMOperationHandler;
import org.apache.slider.server.appmaster.state.AppState;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosKillContainer
implements ChaosTarget {
    protected static final Logger log = LoggerFactory.getLogger(ChaosKillContainer.class);
    public static final int DELAY = 100;
    private final AppState appState;
    private final QueueAccess queues;
    private final Random random = new Random();
    private final RMOperationHandler operationHandler;

    public ChaosKillContainer(AppState appState, QueueAccess queues, RMOperationHandler operationHandler) {
        Preconditions.checkNotNull((Object)appState);
        Preconditions.checkNotNull((Object)queues);
        this.appState = appState;
        this.queues = queues;
        this.operationHandler = operationHandler;
    }

    @Override
    public void chaosAction() {
        List<RoleInstance> liveContainers = this.appState.cloneLiveContainerInfoList();
        ListIterator<RoleInstance> containers = liveContainers.listIterator();
        while (containers.hasNext()) {
            RoleInstance instance = containers.next();
            if (!"slider-appmaster".equals(instance.role)) continue;
            containers.remove();
        }
        int size = liveContainers.size();
        if (size > 0) {
            int target = this.random.nextInt(size);
            RoleInstance roleInstance = liveContainers.get(target);
            log.info("Killing {}", (Object)roleInstance);
            this.queues.schedule(new ActionKillContainer(roleInstance.getId(), 100L, TimeUnit.MILLISECONDS, this.operationHandler));
        }
    }
}

