/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.slideram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.AbstractLauncher;
import org.apache.slider.core.launch.JavaCommandLineBuilder;
import org.apache.slider.providers.AbstractClientProvider;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderAMClientProvider
extends AbstractClientProvider
implements SliderKeys {
    protected static final Logger log = LoggerFactory.getLogger(SliderAMClientProvider.class);
    protected static final String NAME = "SliderAM";
    public static final String INSTANCE_RESOURCE_BASE = "/org/apache/slider/providers/slideram/instance/";
    public static final String INTERNAL_JSON = "/org/apache/slider/providers/slideram/instance/internal.json";
    public static final String APPCONF_JSON = "/org/apache/slider/providers/slideram/instance/appconf.json";
    public static final String RESOURCES_JSON = "/org/apache/slider/providers/slideram/instance/resources.json";
    public static final List<ProviderRole> ROLES = new ArrayList<ProviderRole>();
    public static final int KEY_AM = 0;
    public static final ProviderRole APPMASTER = new ProviderRole("slider-appmaster", 0, 16, 3, 0L, "");

    static {
        ROLES.add(APPMASTER);
    }

    public SliderAMClientProvider(Configuration conf) {
        super(conf);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<ProviderRole> getRoles() {
        return ROLES;
    }

    @Override
    public void preflightValidateClusterConfiguration(SliderFileSystem sliderFileSystem, String clustername, Configuration configuration, AggregateConf instanceDefinition, Path clusterDirPath, Path generatedConfDirPath, boolean secure) throws SliderException, IOException {
        super.preflightValidateClusterConfiguration(sliderFileSystem, clustername, configuration, instanceDefinition, clusterDirPath, generatedConfDirPath, secure);
        String dataPath = instanceDefinition.getInternalOperations().getGlobalOptions().getMandatoryOption("internal.data.dir.path");
        Path path = new Path(dataPath);
        sliderFileSystem.verifyDirectoryWriteAccess(path);
        Path historyPath = new Path(clusterDirPath, "history");
        sliderFileSystem.verifyDirectoryWriteAccess(historyPath);
    }

    @Override
    public void validateInstanceDefinition(AggregateConf instanceDefinition, SliderFileSystem fs) throws SliderException {
        super.validateInstanceDefinition(instanceDefinition, fs);
        Map<String, Map<String, String>> instanceMap = instanceDefinition.getResources().components;
        for (Map.Entry<String, Map<String, String>> entry : instanceMap.entrySet()) {
            MapOperations mapOperations = new MapOperations(entry);
            int instances = mapOperations.getOptionInt("yarn.component.instances", 0);
            if (instances >= 0) continue;
            throw new BadClusterStateException("Component %s has negative instance count: %d", mapOperations.name, instances);
        }
    }

    @Override
    public void prepareAMAndConfigForLaunch(SliderFileSystem fileSystem, Configuration serviceConf, AbstractLauncher launcher, AggregateConf instanceDescription, Path snapshotConfDirPath, Path generatedConfDirPath, Configuration clientConfExtras, String libdir, Path tempPath, boolean miniClusterTestRun) throws IOException, SliderException {
        HashMap<String, LocalResource> providerResources = new HashMap<String, LocalResource>();
        ProviderUtils.addProviderJar(providerResources, this, "slider.jar", fileSystem, tempPath, libdir, miniClusterTestRun);
        String libDirProp = System.getProperty("slider.libdir");
        log.info("Loading all dependencies for AM.");
        Path dependencyLibTarGzip = fileSystem.getDependencyTarGzip();
        if (fileSystem.isFile(dependencyLibTarGzip)) {
            SliderUtils.putAmTarGzipAndUpdate(providerResources, fileSystem);
        } else {
            ProviderUtils.addAllDependencyJars(providerResources, fileSystem, tempPath, libdir, libDirProp);
        }
        this.addKeytabResourceIfNecessary(fileSystem, instanceDescription, providerResources);
        launcher.addLocalResources(providerResources);
        launcher.copyEnvVars(instanceDescription.getInternalOperations().getOrAddComponent("slider-appmaster"));
    }

    protected void addKeytabResourceIfNecessary(SliderFileSystem fileSystem, AggregateConf instanceDescription, Map<String, LocalResource> providerResources) throws IOException, BadConfigException {
        String keytabPathOnHost;
        if (UserGroupInformation.isSecurityEnabled() && SliderUtils.isUnset(keytabPathOnHost = instanceDescription.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.keytab.local.path"))) {
            String amKeytabName = instanceDescription.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.login.keytab.name");
            String keytabDir = instanceDescription.getAppConfOperations().getComponent("slider-appmaster").get("slider.hdfs.keytab.dir");
            Path keytabPath = fileSystem.buildKeytabPath(keytabDir, amKeytabName, instanceDescription.getName());
            if (fileSystem.getFileSystem().exists(keytabPath)) {
                LocalResource keytabRes = fileSystem.createAmResource(keytabPath, LocalResourceType.FILE);
                providerResources.put("keytabs/" + amKeytabName, keytabRes);
            } else {
                log.warn("No keytab file was found at {}.", (Object)keytabPath);
                if (this.getConf().getBoolean("slider.am.login.keytab.required", false)) {
                    throw new BadConfigException("No keytab file was found at %s.", keytabPath);
                }
                log.warn("The AM will be started without a kerberos authenticated identity. The application is therefore not guaranteed to remain operational beyond 24 hours.");
            }
        }
    }

    public void prepareAMResourceRequirements(MapOperations sliderAM, Resource capability) {
        capability.setMemory(sliderAM.getOptionInt("yarn.memory", capability.getMemory()));
        capability.setVirtualCores(sliderAM.getOptionInt("yarn.vcores", capability.getVirtualCores()));
    }

    public void addJVMOptions(AggregateConf aggregateConf, JavaCommandLineBuilder cmdLine) throws BadConfigException {
        MapOperations sliderAM = aggregateConf.getAppConfOperations().getMandatoryComponent("slider-appmaster");
        cmdLine.forceIPv4().headless();
        String heap = sliderAM.getOption("jvm.heapsize", "256M");
        cmdLine.setJVMHeap(heap);
        String jvmopts = sliderAM.getOption("jvm.opts", "");
        if (SliderUtils.isSet(jvmopts)) {
            cmdLine.add(jvmopts);
        }
    }

    @Override
    public void prepareInstanceConfiguration(AggregateConf aggregateConf) throws SliderException, IOException {
        this.mergeTemplates(aggregateConf, INTERNAL_JSON, RESOURCES_JSON, APPCONF_JSON);
    }
}

