/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.retrieve;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.slider.client.rest.BaseRestClient;
import org.apache.slider.core.restclient.HttpVerb;
import org.apache.slider.core.restclient.UgiJerseyBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMWebClient {
    private final BaseRestClient restClient;
    private static final Logger log = LoggerFactory.getLogger(AMWebClient.class);

    public AMWebClient(Configuration conf) {
        UgiJerseyBinding binding = new UgiJerseyBinding(conf);
        this.restClient = new BaseRestClient(binding.createJerseyClient());
    }

    private static URLConnectionClientHandler getUrlConnectionClientHandler() {
        return new URLConnectionClientHandler(new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (connection.getResponseCode() == 302) {
                    String redirectScheme;
                    String redirectLocation = connection.getHeaderField("Location");
                    String originalScheme = url.getProtocol();
                    if (!originalScheme.equals(redirectScheme = URI.create(redirectLocation).getScheme())) {
                        log.info("Protocol change during redirect. Redirecting {} to URL {}", (Object)url, (Object)redirectLocation);
                        URL redirectURL = new URL(redirectLocation);
                        connection = (HttpURLConnection)redirectURL.openConnection();
                    }
                }
                if (connection instanceof HttpsURLConnection) {
                    log.debug("Attempting to configure HTTPS connection using client configuration");
                    try {
                        HttpsURLConnection c = (HttpsURLConnection)connection;
                        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, new Configuration());
                        factory.init();
                        SSLSocketFactory sf = factory.createSSLSocketFactory();
                        HostnameVerifier hv = factory.getHostnameVerifier();
                        c.setSSLSocketFactory(sf);
                        c.setHostnameVerifier(hv);
                    }
                    catch (Exception exception) {
                        log.info("Unable to configure HTTPS connection from configuration.  Using JDK properties.");
                    }
                }
                return connection;
            }
        });
    }

    public WebResource resource(String url) {
        return this.restClient.resource(url);
    }

    public BaseRestClient getRestClient() {
        return this.restClient;
    }

    public <T> T exec(HttpVerb method, WebResource resource, Class<T> c) throws IOException {
        return this.restClient.exec(method, resource, c);
    }

    public <T> T exec(HttpVerb method, WebResource resource, GenericType<T> t) throws IOException {
        return this.restClient.exec(method, resource, t);
    }

    public <T> T get(WebResource resource, Class<T> c) throws IOException {
        return this.restClient.get(resource, c);
    }
}

