/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.apache.storm.shade.org.jboss.netty.handler.ssl.JettyNpnSslEngine;
import org.apache.storm.shade.org.jboss.netty.handler.ssl.SslBufferPool;
import org.apache.storm.shade.org.jboss.netty.handler.ssl.SslContext;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLogger;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdkSslContext
extends SslContext {
    private static final InternalLogger logger;
    static final String PROTOCOL = "TLS";
    static final String[] PROTOCOLS;
    static final List<String> DEFAULT_CIPHERS;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;

    private static void addIfSupported(String[] supported, List<String> enabled, String ... names) {
        block0: for (String n : names) {
            for (String s : supported) {
                if (!n.equals(s)) continue;
                enabled.add(s);
                continue block0;
            }
        }
    }

    JdkSslContext(SslBufferPool bufferPool, Iterable<String> ciphers) {
        super(bufferPool);
        this.cipherSuites = JdkSslContext.toCipherSuiteArray(ciphers);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
    }

    public abstract SSLContext context();

    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionContext().getSessionCacheSize();
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionContext().getSessionTimeout();
    }

    @Override
    public final SSLEngine newEngine() {
        SSLEngine engine = this.context().createSSLEngine();
        engine.setEnabledCipherSuites(this.cipherSuites);
        engine.setEnabledProtocols(PROTOCOLS);
        engine.setUseClientMode(this.isClient());
        return this.wrapEngine(engine);
    }

    @Override
    public final SSLEngine newEngine(String peerHost, int peerPort) {
        SSLEngine engine = this.context().createSSLEngine(peerHost, peerPort);
        engine.setEnabledCipherSuites(this.cipherSuites);
        engine.setEnabledProtocols(PROTOCOLS);
        engine.setUseClientMode(this.isClient());
        return this.wrapEngine(engine);
    }

    private SSLEngine wrapEngine(SSLEngine engine) {
        if (this.nextProtocols().isEmpty()) {
            return engine;
        }
        return new JettyNpnSslEngine(engine, this.nextProtocols(), this.isServer());
    }

    private static String[] toCipherSuiteArray(Iterable<String> ciphers) {
        if (ciphers == null) {
            return DEFAULT_CIPHERS.toArray(new String[DEFAULT_CIPHERS.size()]);
        }
        ArrayList<String> newCiphers = new ArrayList<String>();
        for (String c : ciphers) {
            if (c == null) break;
            newCiphers.add(c);
        }
        return newCiphers.toArray(new String[newCiphers.size()]);
    }

    static {
        SSLContext context;
        logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
        try {
            context = SSLContext.getInstance(PROTOCOL);
            context.init(null, null, null);
        }
        catch (Exception e) {
            throw new Error("failed to initialize the default SSL context", e);
        }
        SSLEngine engine = context.createSSLEngine();
        String[] supportedProtocols = engine.getSupportedProtocols();
        ArrayList<String> protocols = new ArrayList<String>();
        JdkSslContext.addIfSupported(supportedProtocols, protocols, "TLSv1.2", "TLSv1.1", "TLSv1");
        PROTOCOLS = !protocols.isEmpty() ? protocols.toArray(new String[protocols.size()]) : engine.getEnabledProtocols();
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        ArrayList<String> ciphers = new ArrayList<String>();
        JdkSslContext.addIfSupported(supportedCiphers, ciphers, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA");
        DEFAULT_CIPHERS = !ciphers.isEmpty() ? Collections.unmodifiableList(ciphers) : Collections.unmodifiableList(Arrays.asList(engine.getEnabledCipherSuites()));
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): " + Arrays.asList(PROTOCOLS));
            logger.debug("Default cipher suites (JDK): " + DEFAULT_CIPHERS);
        }
    }
}

