/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.nimbus.TopoCache;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.LeaderListenerCallback;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderListenerCallbackFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderListenerCallbackFactory.class);
    private final Map<String, Object> conf;
    private final CuratorFramework zk;
    private final BlobStore blobStore;
    private final TopoCache tc;
    private final IStormClusterState clusterState;
    private final List<ACL> acls;
    private final StormMetricsRegistry metricsRegistry;

    public LeaderListenerCallbackFactory(Map<String, Object> conf, CuratorFramework zk, BlobStore blobStore, TopoCache tc, IStormClusterState clusterState, List<ACL> acls, StormMetricsRegistry metricsRegistry) {
        this.conf = conf;
        this.zk = zk;
        this.blobStore = blobStore;
        this.tc = tc;
        this.clusterState = clusterState;
        this.acls = acls;
        this.metricsRegistry = metricsRegistry;
    }

    public LeaderLatchListener create(ILeaderElector elector) throws UnknownHostException {
        final LeaderListenerCallback callback = new LeaderListenerCallback(this.conf, this.zk, this.blobStore, elector, this.tc, this.clusterState, this.acls, this.metricsRegistry);
        final String hostName = InetAddress.getLocalHost().getCanonicalHostName();
        return new LeaderLatchListener(){

            public void isLeader() {
                callback.leaderCallBack();
                LOG.info("{} gained leadership.", (Object)hostName);
            }

            public void notLeader() {
                LOG.info("{} lost leadership.", (Object)hostName);
                callback.notLeaderCallback();
            }
        };
    }
}

