/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import org.apache.storm.shade.org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperServerCnxnFactory.class);
    int port;
    NIOServerCnxnFactory factory;

    public ZookeeperServerCnxnFactory(int port, int maxClientCnxns) {
        int max;
        if (port <= 0) {
            this.port = 2000;
            max = 65535;
        } else {
            this.port = port;
            max = port;
        }
        try {
            this.factory = new NIOServerCnxnFactory();
        }
        catch (IOException e) {
            this.port = 0;
            this.factory = null;
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        while (this.port <= max) {
            try {
                this.factory.configure(new InetSocketAddress(this.port), maxClientCnxns);
                LOG.debug("Zookeeper server successfully binded at port " + this.port);
                break;
            }
            catch (BindException e) {
            }
            catch (IOException e2) {
                this.port = 0;
                this.factory = null;
                e2.printStackTrace();
                throw new RuntimeException(e2.getMessage());
            }
            ++this.port;
        }
        if (this.port > max) {
            this.port = 0;
            this.factory = null;
            LOG.error("Failed to find a port for Zookeeper");
            throw new RuntimeException("No port is available to launch an inprocess zookeeper.");
        }
    }

    public int port() {
        return this.port;
    }

    public NIOServerCnxnFactory factory() {
        return this.factory;
    }
}

