/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling.sorter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.IExecSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecSorterByProximity
implements IExecSorter {
    private static final Logger LOG = LoggerFactory.getLogger(ExecSorterByProximity.class);
    protected TopologyDetails topologyDetails;

    public ExecSorterByProximity(TopologyDetails topologyDetails) {
        this.topologyDetails = topologyDetails;
    }

    @Override
    public List<ExecutorDetails> sortExecutors(Set<ExecutorDetails> unassignedExecutors) {
        Map<String, Component> componentMap = this.topologyDetails.getUserTopolgyComponents();
        LinkedHashSet<ExecutorDetails> orderedExecutorSet = new LinkedHashSet<ExecutorDetails>();
        HashMap<String, Queue<ExecutorDetails>> compToExecsToSchedule = new HashMap<String, Queue<ExecutorDetails>>();
        for (Component component : componentMap.values()) {
            compToExecsToSchedule.put(component.getId(), new LinkedList());
            for (ExecutorDetails exec : component.getExecs()) {
                if (!unassignedExecutors.contains(exec)) continue;
                ((Queue)compToExecsToSchedule.get(component.getId())).add(exec);
            }
        }
        List<Component> sortedComponents = this.topologicalSortComponents(componentMap);
        for (Component currComp : sortedComponents) {
            int numExecs = ((Queue)compToExecsToSchedule.get(currComp.getId())).size();
            for (int i = 0; i < numExecs; ++i) {
                orderedExecutorSet.addAll(this.takeExecutors(currComp, componentMap, compToExecsToSchedule));
            }
        }
        orderedExecutorSet.addAll(unassignedExecutors);
        return new LinkedList<ExecutorDetails>(orderedExecutorSet);
    }

    private List<Component> topologicalSortComponents(Map<String, Component> componentMap) {
        int i;
        LinkedHashSet<Component> sortedComponentsSet = new LinkedHashSet<Component>();
        boolean[] visited = new boolean[componentMap.size()];
        int[] inDegree = new int[componentMap.size()];
        ArrayList<String> componentIds = new ArrayList<String>(componentMap.keySet());
        HashMap compIdToIndex = new HashMap();
        for (i = 0; i < componentIds.size(); ++i) {
            compIdToIndex.put(componentIds.get(i), i);
        }
        for (i = 0; i < inDegree.length; ++i) {
            String compId = (String)componentIds.get(i);
            Component comp = componentMap.get(compId);
            for (String childId : comp.getChildren()) {
                int n = (Integer)compIdToIndex.get(childId);
                inDegree[n] = inDegree[n] + 1;
            }
        }
        block3: for (int t = 0; t < inDegree.length; ++t) {
            for (int i2 = 0; i2 < inDegree.length; ++i2) {
                if (inDegree[i2] != 0 || visited[i2]) continue;
                String compId = (String)componentIds.get(i2);
                Component comp = componentMap.get(compId);
                sortedComponentsSet.add(comp);
                visited[i2] = true;
                for (String childId : comp.getChildren()) {
                    int n = (Integer)compIdToIndex.get(childId);
                    inDegree[n] = inDegree[n] - 1;
                }
                continue block3;
            }
        }
        if (sortedComponentsSet.size() != componentMap.size()) {
            String unvisitedComponentIds = componentMap.entrySet().stream().filter(x -> !sortedComponentsSet.contains(x.getValue())).map(x -> (String)x.getKey()).collect(Collectors.joining(","));
            LOG.warn("topologicalSortComponents for topology {} detected possible loop(s) involving components {}, appending them to the end of the sorted component list", (Object)this.topologyDetails.getId(), (Object)unvisitedComponentIds);
            sortedComponentsSet.addAll(componentMap.values());
        }
        return new ArrayList<Component>(sortedComponentsSet);
    }

    private List<ExecutorDetails> takeExecutors(Component currComp, Map<String, Component> componentMap, Map<String, Queue<ExecutorDetails>> compToExecsToSchedule) {
        ArrayList<ExecutorDetails> execsScheduled = new ArrayList<ExecutorDetails>();
        Queue<ExecutorDetails> currQueue = compToExecsToSchedule.get(currComp.getId());
        int currUnscheduledNumExecs = currQueue.size();
        if (currUnscheduledNumExecs == 0) {
            return execsScheduled;
        }
        execsScheduled.add(currQueue.poll());
        Set<String> sortedChildren = this.getSortedChildren(currComp, componentMap);
        for (String childId : sortedChildren) {
            Component childComponent = componentMap.get(childId);
            Queue<ExecutorDetails> childQueue = compToExecsToSchedule.get(childId);
            int childUnscheduledNumExecs = childQueue.size();
            if (childUnscheduledNumExecs == 0) continue;
            int numExecsToTake = 1;
            if (this.hasShuffleGroupingFromParentToChild(currComp, childComponent)) {
                numExecsToTake = Math.max(1, childUnscheduledNumExecs / currUnscheduledNumExecs);
            }
            for (int i = 0; i < numExecsToTake; ++i) {
                execsScheduled.addAll(this.takeExecutors(childComponent, componentMap, compToExecsToSchedule));
            }
        }
        return execsScheduled;
    }

    private Set<String> getSortedChildren(Component component, Map<String, Component> componentMap) {
        Set<String> children = component.getChildren();
        TreeSet<String> sortedChildren = new TreeSet<String>((o1, o2) -> {
            Component child1 = (Component)componentMap.get(o1);
            Component child2 = (Component)componentMap.get(o2);
            boolean child1IsShuffle = this.hasShuffleGroupingFromParentToChild(component, child1);
            boolean child2IsShuffle = this.hasShuffleGroupingFromParentToChild(component, child2);
            if (child1IsShuffle && child2IsShuffle) {
                return o1.compareTo((String)o2);
            }
            if (child1IsShuffle) {
                return 1;
            }
            return -1;
        });
        sortedChildren.addAll(children);
        return sortedChildren;
    }

    private boolean hasShuffleGroupingFromParentToChild(Component parent, Component child) {
        for (Map.Entry<GlobalStreamId, Grouping> inputEntry : child.getInputs().entrySet()) {
            GlobalStreamId globalStreamId = inputEntry.getKey();
            Grouping grouping = inputEntry.getValue();
            if (!globalStreamId.get_componentId().equals(parent.getId()) || !inputEntry.getValue().is_set_local_or_shuffle() && !grouping.is_set_shuffle()) continue;
            return true;
        }
        return false;
    }
}

