/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling.sorter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.strategies.scheduling.ConstraintSolverConfig;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.IExecSorter;

public class ExecSorterByConstraintSeverity
implements IExecSorter {
    private final ConstraintSolverConfig constraintSolverConfig;
    private final Map<String, Set<ExecutorDetails>> compToExecs;

    public ExecSorterByConstraintSeverity(Cluster cluster, TopologyDetails topologyDetails) {
        this.constraintSolverConfig = new ConstraintSolverConfig(topologyDetails);
        this.compToExecs = new HashMap<String, Set<ExecutorDetails>>();
        topologyDetails.getExecutorToComponent().forEach((exec, comp) -> this.compToExecs.computeIfAbsent((String)comp, k -> new HashSet()).add(exec));
    }

    @Override
    public List<ExecutorDetails> sortExecutors(Set<ExecutorDetails> unassignedExecutors) {
        List<ExecutorDetails> sortedExecs = this.getSortedExecs().stream().filter(unassignedExecutors::contains).collect(Collectors.toList());
        return sortedExecs;
    }

    private ArrayList<ExecutorDetails> getSortedExecs() {
        ArrayList<ExecutorDetails> retList = new ArrayList<ExecutorDetails>();
        HashMap compConstraintCountMap = new HashMap();
        this.constraintSolverConfig.getIncompatibleComponentSets().forEach((comp, incompatibleComponents) -> {
            double constraintCnt = incompatibleComponents.size();
            if (this.constraintSolverConfig.getMaxNodeCoLocationCnts().containsKey(comp)) {
                constraintCnt += (double)(this.compToExecs.size() / this.constraintSolverConfig.getMaxNodeCoLocationCnts().get(comp));
            }
            compConstraintCountMap.put(comp, constraintCnt);
        });
        NavigableMap sortedCompConstraintCountMap = this.sortByValues(compConstraintCountMap);
        for (String comp2 : sortedCompConstraintCountMap.keySet()) {
            retList.addAll((Collection<ExecutorDetails>)this.compToExecs.get(comp2));
        }
        return retList;
    }

    protected <K extends Comparable<K>, V extends Comparable<V>> NavigableMap<K, V> sortByValues(Map<K, V> map) {
        Comparator valueComparator = (k1, k2) -> {
            int compare = ((Comparable)map.get(k2)).compareTo(map.get(k1));
            if (compare == 0) {
                return k2.compareTo(k1);
            }
            return compare;
        };
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }
}

