/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.SchedulingSearcherState;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.ExecSorterByConnectionCount;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.ExecSorterByProximity;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.IExecSorter;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.INodeSorter;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.NodeSorterHostProximity;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceAwareStrategy
implements IStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceAwareStrategy.class);
    protected final boolean sortNodesForEachExecutor;
    protected final NodeSortType nodeSortType;
    protected Map<String, Object> config;
    protected Cluster cluster;
    protected TopologyDetails topologyDetails;
    protected RasNodes nodes;
    private Map<String, List<String>> networkTopography;
    private Map<String, List<RasNode>> hostnameToNodes;
    protected String topoName;
    protected Map<String, Set<ExecutorDetails>> compToExecs;
    protected Map<ExecutorDetails, String> execToComp;
    protected boolean orderExecutorsByProximity;
    private long maxSchedulingTimeMs;
    Set<ExecutorDetails> unassignedExecutors;
    private int maxStateSearch;
    protected SchedulingSearcherState searcherState;
    protected IExecSorter execSorter;
    protected INodeSorter nodeSorter;

    public BaseResourceAwareStrategy() {
        this(true, NodeSortType.COMMON);
    }

    public BaseResourceAwareStrategy(boolean sortNodesForEachExecutor, NodeSortType nodeSortType) {
        this.sortNodesForEachExecutor = sortNodesForEachExecutor;
        this.nodeSortType = nodeSortType;
    }

    @Override
    public void prepare(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public SchedulingResult schedule(Cluster cluster, TopologyDetails td) {
        this.prepareForScheduling(cluster, td);
        SchedulingResult earlyResult = this.checkSchedulingFeasibility();
        if (earlyResult != null) {
            return earlyResult;
        }
        LOG.debug("Topology {} {} Number of ExecutorsNeedScheduling: {}", new Object[]{this.topoName, this.topologyDetails.getId(), this.unassignedExecutors.size()});
        List<ExecutorDetails> orderedExecutors = this.execSorter.sortExecutors(this.unassignedExecutors);
        Iterable<String> sortedNodes = null;
        if (!this.sortNodesForEachExecutor) {
            this.nodeSorter.prepare(null);
            sortedNodes = this.nodeSorter.sortAllNodes();
        }
        return this.scheduleExecutorsOnNodes(orderedExecutors, sortedNodes);
    }

    protected void prepareForScheduling(Cluster cluster, TopologyDetails topologyDetails) {
        this.cluster = cluster;
        this.topologyDetails = topologyDetails;
        this.nodes = new RasNodes(cluster);
        this.networkTopography = cluster.getNetworkTopography();
        this.hostnameToNodes = this.nodes.getHostnameToNodes();
        this.topoName = topologyDetails.getName();
        this.execToComp = topologyDetails.getExecutorToComponent();
        this.compToExecs = topologyDetails.getComponentToExecutors();
        Map<String, Object> topoConf = topologyDetails.getConf();
        this.orderExecutorsByProximity = BaseResourceAwareStrategy.isOrderByProximity(topoConf);
        this.maxSchedulingTimeMs = BaseResourceAwareStrategy.computeMaxSchedulingTimeMs(topoConf);
        this.unassignedExecutors = Collections.unmodifiableSet(new HashSet<ExecutorDetails>(cluster.getUnassignedExecutors(topologyDetails)));
        int confMaxStateSearch = BaseResourceAwareStrategy.getMaxStateSearchFromTopoConf(topologyDetails.getConf());
        int daemonMaxStateSearch = ObjectReader.getInt((Object)cluster.getConf().get("resource.aware.scheduler.constraint.max.state.search"));
        this.maxStateSearch = Math.min(daemonMaxStateSearch, confMaxStateSearch);
        LOG.debug("The max state search configured by topology {} is {}", (Object)topologyDetails.getId(), (Object)confMaxStateSearch);
        LOG.debug("The max state search that will be used by topology {} is {}", (Object)topologyDetails.getId(), (Object)this.maxStateSearch);
        this.searcherState = this.createSearcherState();
        this.setNodeSorter(new NodeSorterHostProximity(cluster, topologyDetails, this.nodeSortType));
        this.setExecSorter(this.orderExecutorsByProximity ? new ExecSorterByProximity(topologyDetails) : new ExecSorterByConnectionCount(topologyDetails));
        this.logClusterInfo();
    }

    protected void setExecSorter(IExecSorter execSorter) {
        this.execSorter = execSorter;
    }

    protected void setNodeSorter(INodeSorter nodeSorter) {
        this.nodeSorter = nodeSorter;
    }

    private static long computeMaxSchedulingTimeMs(Map<String, Object> topoConf) {
        int daemonMaxTimeSec = ObjectReader.getInt((Object)topoConf.get("scheduling.timeout.seconds.per.topology"), (Integer)60);
        int confMaxTimeSec = ObjectReader.getInt((Object)topoConf.get("topology.ras.constraint.max.time.secs"), (Integer)daemonMaxTimeSec);
        return confMaxTimeSec >= daemonMaxTimeSec ? (long)daemonMaxTimeSec * 1000L - 200L : (long)confMaxTimeSec * 1000L;
    }

    public static int getMaxStateSearchFromTopoConf(Map<String, Object> topoConf) {
        int confMaxStateSearch = topoConf.containsKey("topology.ras.constraint.max.state.search") ? ObjectReader.getInt((Object)topoConf.get("topology.ras.constraint.max.state.search")) : 10000;
        return confMaxStateSearch;
    }

    public static boolean isOrderByProximity(Map<String, Object> topoConf) {
        return ObjectReader.getBoolean((Object)topoConf.get("topology.ras.order.executors.by.proximity.needs"), (boolean)false);
    }

    private SchedulingSearcherState createSearcherState() {
        HashMap<WorkerSlot, Map<String, Integer>> workerCompCnts = new HashMap<WorkerSlot, Map<String, Integer>>();
        HashMap<RasNode, Map<String, Integer>> nodeCompCnts = new HashMap<RasNode, Map<String, Integer>>();
        SchedulerAssignment existingAssignment = this.cluster.getAssignmentById(this.topologyDetails.getId());
        if (existingAssignment != null) {
            existingAssignment.getExecutorToSlot().forEach((exec, ws) -> {
                String compId = this.execToComp.get(exec);
                RasNode node = this.nodes.getNodeById(ws.getNodeId());
                Map compCnts = nodeCompCnts.computeIfAbsent(node, k -> new HashMap());
                compCnts.put(compId, compCnts.getOrDefault(compId, 0) + 1);
                compCnts = workerCompCnts.computeIfAbsent((WorkerSlot)ws, k -> new HashMap());
                compCnts.put(compId, compCnts.getOrDefault(compId, 0) + 1);
            });
        }
        LinkedList<ExecutorDetails> unassignedAckers = new LinkedList<ExecutorDetails>();
        if (this.compToExecs.containsKey("__acker")) {
            for (ExecutorDetails acker : this.compToExecs.get("__acker")) {
                if (!this.unassignedExecutors.contains(acker)) continue;
                unassignedAckers.add(acker);
            }
        }
        return new SchedulingSearcherState(workerCompCnts, nodeCompCnts, this.maxStateSearch, this.maxSchedulingTimeMs, new ArrayList<ExecutorDetails>(this.unassignedExecutors), unassignedAckers, this.topologyDetails, this.execToComp);
    }

    protected SchedulingResult checkSchedulingFeasibility() {
        if (this.unassignedExecutors.isEmpty()) {
            return SchedulingResult.success("Fully Scheduled by " + this.getClass().getSimpleName());
        }
        if (this.nodes.getNodes().size() <= 0) {
            String err = "No available nodes to schedule tasks on!";
            LOG.warn("Topology {}:{}", (Object)this.topoName, (Object)err);
            return SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, err);
        }
        if (!this.topologyDetails.hasSpouts()) {
            String err = "Cannot find a Spout!";
            LOG.error("Topology {}:{}", (Object)this.topoName, (Object)err);
            return SchedulingResult.failure(SchedulingStatus.FAIL_INVALID_TOPOLOGY, err);
        }
        int execCnt = this.unassignedExecutors.size();
        if (execCnt >= this.maxStateSearch) {
            String err = String.format("Unassignerd Executor count (%d) is greater than searchable state count %d", execCnt, this.maxStateSearch);
            LOG.error("Topology {}:{}", (Object)this.topoName, (Object)err);
            return SchedulingResult.failure(SchedulingStatus.FAIL_OTHER, err);
        }
        return null;
    }

    protected boolean isExecAssignmentToWorkerValid(ExecutorDetails exec, WorkerSlot worker) {
        RasNode node = this.nodes.getNodeById(worker.getNodeId());
        if (!node.wouldFit(worker, exec, this.topologyDetails)) {
            LOG.trace("Topology {}, executor {} would not fit in resources available on worker {}", new Object[]{this.topoName, exec, worker});
            return false;
        }
        return true;
    }

    private void logClusterInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cluster:");
            for (Map.Entry<String, List<String>> clusterEntry : this.networkTopography.entrySet()) {
                String rackId = clusterEntry.getKey();
                LOG.debug("Rack: {}", (Object)rackId);
                for (String nodeHostname : clusterEntry.getValue()) {
                    for (RasNode node : this.hostnameToNodes(nodeHostname)) {
                        LOG.debug("-> Node: {} {}", (Object)node.getHostname(), (Object)node.getId());
                        LOG.debug("--> Avail Resources: {Mem {}, CPU {} Slots: {}}", new Object[]{node.getAvailableMemoryResources(), node.getAvailableCpuResources(), node.totalSlotsFree()});
                        LOG.debug("--> Total Resources: {Mem {}, CPU {} Slots: {}}", new Object[]{node.getTotalMemoryResources(), node.getTotalCpuResources(), node.totalSlots()});
                    }
                }
            }
        }
    }

    public List<RasNode> hostnameToNodes(String hostname) {
        return this.hostnameToNodes.getOrDefault(hostname, Collections.emptyList());
    }

    public RasNode idToNode(String id) {
        RasNode ret = this.nodes.getNodeById(id);
        if (ret == null) {
            LOG.error("Cannot find Node with Id: {}", (Object)id);
        }
        return ret;
    }

    protected SchedulingResult scheduleExecutorsOnNodes(List<ExecutorDetails> orderedExecutors, Iterable<String> sortedNodesIter) {
        orderedExecutors.removeAll(this.searcherState.getUnassignedAckers());
        orderedExecutors.addAll(this.searcherState.getUnassignedAckers());
        LOG.debug("For topology: {}, we have sorted execs: {} and unassigned ackers: {}", new Object[]{this.topoName, orderedExecutors, this.searcherState.getUnassignedAckers()});
        long startTimeMilli = Time.currentTimeMillis();
        this.searcherState.setSortedExecs(orderedExecutors);
        int maxExecCnt = this.searcherState.getExecSize();
        int progressIdx = -1;
        int[] progressIdxForExec = new int[maxExecCnt];
        RasNode[] nodeForExec = new RasNode[maxExecCnt];
        WorkerSlot[] workerSlotForExec = new WorkerSlot[maxExecCnt];
        for (int i = 0; i < maxExecCnt; ++i) {
            progressIdxForExec[i] = -1;
        }
        LOG.debug("scheduleExecutorsOnNodes: will assign {} executors for topo {}, sortNodesForEachExecutor={}", new Object[]{maxExecCnt, this.topoName, this.sortNodesForEachExecutor});
        int loopCnt = 0;
        while (true) {
            block13: {
                LOG.debug("scheduleExecutorsOnNodes: loopCnt={}, execIndex={}, topo={}", new Object[]{loopCnt, this.searcherState.getExecIndex(), this.topoName});
                if (this.searcherState.areSearchLimitsExceeded()) {
                    LOG.warn("Limits exceeded, backtrackCnt={}, loopCnt={}, topo={}", new Object[]{this.searcherState.getNumBacktrack(), loopCnt, this.topoName});
                    return this.searcherState.createSchedulingResult(false, this.getClass().getSimpleName());
                }
                if (Thread.currentThread().isInterrupted()) {
                    return this.searcherState.createSchedulingResult(false, this.getClass().getSimpleName());
                }
                int execIndex = this.searcherState.getExecIndex();
                ExecutorDetails exec = this.searcherState.currentExec();
                if (this.searcherState.getBoundAckers().contains(exec)) {
                    if (this.searcherState.areAllExecsScheduled()) {
                        LOG.info("scheduleExecutorsOnNodes: Done at loopCnt={} in {}ms, state.elapsedtime={}, backtrackCnt={}, topo={}", new Object[]{loopCnt, Time.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.startTimeMillis, this.searcherState.getNumBacktrack(), this.topoName});
                        return this.searcherState.createSchedulingResult(true, this.getClass().getSimpleName());
                    }
                    this.searcherState = this.searcherState.nextExecutor();
                } else {
                    String comp = this.execToComp.get(exec);
                    if (sortedNodesIter == null || this.sortNodesForEachExecutor && this.searcherState.isExecCompDifferentFromPrior()) {
                        progressIdx = -1;
                        this.nodeSorter.prepare(exec);
                        sortedNodesIter = this.nodeSorter.sortAllNodes();
                    }
                    for (String nodeId : sortedNodesIter) {
                        RasNode node = this.nodes.getNodeById(nodeId);
                        if (!node.couldEverFit(exec, this.topologyDetails)) continue;
                        for (WorkerSlot workerSlot : node.getSlotsAvailableToScheduleOn()) {
                            if (++progressIdx <= progressIdxForExec[execIndex]) continue;
                            int n = execIndex;
                            progressIdxForExec[n] = progressIdxForExec[n] + 1;
                            if (!this.isExecAssignmentToWorkerValid(exec, workerSlot)) {
                                LOG.debug("Failed to assign exec={}, comp={}, topo={} to worker={} on node=({}, availCpu={}, availMem={}).", new Object[]{exec, comp, this.topoName, workerSlot, node.getId(), node.getAvailableCpuResources(), node.getAvailableMemoryResources()});
                                continue;
                            }
                            this.searcherState.incStatesSearched();
                            this.searcherState.assignCurrentExecutor(this.execToComp, node, workerSlot);
                            int numBoundAckerAssigned = this.assignBoundAckersForNewWorkerSlot(exec, node, workerSlot);
                            if (numBoundAckerAssigned > 0) {
                                this.searcherState.getExecsWithBoundAckers().add(exec);
                            }
                            if (this.searcherState.areAllExecsScheduled()) {
                                LOG.info("scheduleExecutorsOnNodes: Done at loopCnt={} in {}ms, state.elapsedtime={}, backtrackCnt={}, topo={}", new Object[]{loopCnt, System.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.startTimeMillis, this.searcherState.getNumBacktrack(), this.topoName});
                                return this.searcherState.createSchedulingResult(true, this.getClass().getSimpleName());
                            }
                            this.searcherState = this.searcherState.nextExecutor();
                            nodeForExec[execIndex] = node;
                            workerSlotForExec[execIndex] = workerSlot;
                            LOG.debug("scheduleExecutorsOnNodes: Assigned execId={}, comp={} to node={}/cpu={}/mem={}, slot-ordinal={} at loopCnt={}, topo={}", new Object[]{execIndex, comp, nodeId, node.getAvailableCpuResources(), node.getAvailableMemoryResources(), progressIdx, loopCnt, this.topoName});
                            break block13;
                        }
                    }
                    sortedNodesIter = null;
                    LOG.debug("scheduleExecutorsOnNodes: Failed to schedule execId={}, comp={} at loopCnt={}, topo={}", new Object[]{execIndex, comp, loopCnt, this.topoName});
                    if (execIndex == 0) break;
                    this.searcherState.backtrack(this.execToComp, nodeForExec[execIndex - 1], workerSlotForExec[execIndex - 1]);
                    progressIdxForExec[execIndex] = -1;
                }
            }
            ++loopCnt;
        }
        boolean success = this.searcherState.areAllExecsScheduled();
        LOG.info("scheduleExecutorsOnNodes: Scheduled={} in {} milliseconds, state.elapsedtime={}, backtrackCnt={}, topo={}", new Object[]{success, System.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.startTimeMillis, this.searcherState.getNumBacktrack(), this.topoName});
        return this.searcherState.createSchedulingResult(success, this.getClass().getSimpleName());
    }

    private int assignBoundAckersForNewWorkerSlot(ExecutorDetails exec, RasNode node, WorkerSlot workerSlot) {
        int numOfAckersToBind = this.searcherState.getNumOfAckersToBind(exec, workerSlot);
        if (numOfAckersToBind > 0) {
            for (int i = 0; i < numOfAckersToBind; ++i) {
                if (!this.isExecAssignmentToWorkerValid(this.searcherState.peekUnassignedAckers(), workerSlot)) {
                    LOG.debug("Assigned {} of {} ackers on workerSlot={} with the executor={} for topology={}", new Object[]{i, numOfAckersToBind, workerSlot, exec, this.topoName});
                    return i;
                }
                try {
                    this.searcherState.assignSingleBoundAcker(node, workerSlot);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Exception happens when assigning {} of {} ackers on workerSlot={} for topology={}", new Object[]{i + 1, numOfAckersToBind, workerSlot, this.topoName, e});
                    return i;
                }
            }
        }
        LOG.debug("Assigned {} ackers on workerSlot={} with the executor={} for topology={}", new Object[]{numOfAckersToBind, workerSlot, exec, this.topoName});
        return numOfAckersToBind;
    }

    public static enum NodeSortType {
        GENERIC_RAS,
        DEFAULT_RAS,
        COMMON;

    }
}

