/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.ComponentType;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyDetails {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyDetails.class);
    private final String topologyId;
    private final Map<String, Object> topologyConf;
    private final StormTopology topology;
    private final Map<ExecutorDetails, String> executorToComponent;
    private final int numWorkers;
    private final int launchTime;
    private final String owner;
    private final String topoName;
    private Map<ExecutorDetails, NormalizedResourceRequest> resourceList;
    private Double topologyWorkerMaxHeapSize;
    private Integer topologyPriority;
    private Map<String, Component> userTopologyComponentsMap;

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers, String owner) {
        this(topologyId, topologyConf, topology, numWorkers, null, 0, owner);
    }

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers, Map<ExecutorDetails, String> executorToComponents, String owner) {
        this(topologyId, topologyConf, topology, numWorkers, executorToComponents, 0, owner);
    }

    public TopologyDetails(String topologyId, Map<String, Object> topologyConf, StormTopology topology, int numWorkers, Map<ExecutorDetails, String> executorToComponents, int launchTime, String owner) {
        this.owner = owner;
        this.topologyId = topologyId;
        this.topologyConf = topologyConf;
        this.topology = topology;
        this.numWorkers = numWorkers;
        this.executorToComponent = new HashMap<ExecutorDetails, String>(0);
        if (executorToComponents != null) {
            this.executorToComponent.putAll(executorToComponents);
        }
        if (topology != null) {
            this.initResourceList();
        }
        this.initConfigs();
        this.launchTime = launchTime;
        this.topoName = (String)topologyConf.get("topology.name");
    }

    public String getId() {
        return this.topologyId;
    }

    public String getName() {
        return this.topoName;
    }

    public Map<String, Object> getConf() {
        return this.topologyConf;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public StormTopology getTopology() {
        return this.topology;
    }

    public Map<ExecutorDetails, String> getExecutorToComponent() {
        return this.executorToComponent;
    }

    public Map<ExecutorDetails, String> selectExecutorToComponent(Collection<ExecutorDetails> executors) {
        HashMap<ExecutorDetails, String> ret = new HashMap<ExecutorDetails, String>(executors.size());
        for (ExecutorDetails executor : executors) {
            String compId = this.executorToComponent.get(executor);
            if (compId == null) continue;
            ret.put(executor, compId);
        }
        return ret;
    }

    public Map<String, Set<ExecutorDetails>> getComponentToExecutors() {
        HashMap<String, Set<ExecutorDetails>> ret = new HashMap<String, Set<ExecutorDetails>>();
        Map<ExecutorDetails, String> execToComp = this.getExecutorToComponent();
        if (execToComp != null) {
            execToComp.forEach((exec, comp) -> ret.computeIfAbsent((String)comp, k -> new HashSet()).add(exec));
        }
        return ret;
    }

    public Set<ExecutorDetails> getExecutors() {
        return this.executorToComponent.keySet();
    }

    private void initResourceList() {
        NormalizedResourceRequest topologyResources;
        this.resourceList = new HashMap<ExecutorDetails, NormalizedResourceRequest>();
        if (this.topology.get_bolts() != null) {
            for (Map.Entry bolt : this.topology.get_bolts().entrySet()) {
                topologyResources = new NormalizedResourceRequest(((Bolt)bolt.getValue()).get_common(), this.topologyConf, (String)bolt.getKey());
                for (Map.Entry<ExecutorDetails, String> anExecutorToComponent : this.executorToComponent.entrySet()) {
                    if (!((String)bolt.getKey()).equals(anExecutorToComponent.getValue())) continue;
                    this.resourceList.put(anExecutorToComponent.getKey(), topologyResources);
                }
            }
        }
        if (this.topology.get_spouts() != null) {
            for (Map.Entry spout : this.topology.get_spouts().entrySet()) {
                topologyResources = new NormalizedResourceRequest(((SpoutSpec)spout.getValue()).get_common(), this.topologyConf, (String)spout.getKey());
                for (Map.Entry<ExecutorDetails, String> anExecutorToComponent : this.executorToComponent.entrySet()) {
                    if (!((String)spout.getKey()).equals(anExecutorToComponent.getValue())) continue;
                    this.resourceList.put(anExecutorToComponent.getKey(), topologyResources);
                }
            }
        } else {
            LOG.warn("Topology " + this.topologyId + " does not seem to have any spouts!");
        }
        for (ExecutorDetails exec : this.getExecutors()) {
            if (this.resourceList.containsKey(exec)) continue;
            LOG.debug("Scheduling component: {} executor: {} with resource requirement as {} {}", new Object[]{this.getExecutorToComponent().get(exec), exec, this.topologyConf.get("topology.component.resources.onheap.memory.mb"), this.resourceList.get(exec)});
            this.addDefaultResforExec(exec);
        }
    }

    private List<ExecutorDetails> componentToExecs(String comp) {
        ArrayList<ExecutorDetails> execs = new ArrayList<ExecutorDetails>();
        for (Map.Entry<ExecutorDetails, String> entry : this.executorToComponent.entrySet()) {
            if (!entry.getValue().equals(comp)) continue;
            execs.add(entry.getKey());
        }
        return execs;
    }

    private Set<String> getInputsTo(ComponentCommon comp) {
        HashSet<String> ret = new HashSet<String>();
        for (GlobalStreamId globalId : comp.get_inputs().keySet()) {
            ret.add(globalId.get_componentId());
        }
        return ret;
    }

    public Map<String, Component> getUserTopolgyComponents() {
        if (this.userTopologyComponentsMap == null) {
            this.userTopologyComponentsMap = this.computeComponentMap(this.topology);
        }
        return this.userTopologyComponentsMap;
    }

    private Map<String, Component> computeComponentMap(StormTopology topology) {
        Component comp;
        String compId;
        HashMap<String, Component> ret = new HashMap<String, Component>();
        Map spouts = topology.get_spouts();
        Map bolts = topology.get_bolts();
        if (spouts != null) {
            for (Map.Entry entry : spouts.entrySet()) {
                compId = (String)entry.getKey();
                SpoutSpec spout = (SpoutSpec)entry.getValue();
                if (Utils.isSystemId((String)compId)) continue;
                comp = new Component(ComponentType.SPOUT, compId, this.componentToExecs(compId), spout.get_common().get_inputs());
                ret.put(compId, comp);
            }
        }
        if (bolts != null) {
            for (Map.Entry entry : bolts.entrySet()) {
                compId = (String)entry.getKey();
                Bolt bolt = (Bolt)entry.getValue();
                if (Utils.isSystemId((String)compId)) continue;
                comp = new Component(ComponentType.BOLT, compId, this.componentToExecs(compId), bolt.get_common().get_inputs());
                ret.put(compId, comp);
            }
        }
        if (spouts != null) {
            for (Map.Entry entry : spouts.entrySet()) {
                Component spout = (Component)ret.get(entry.getKey());
                for (String parentId : this.getInputsTo(((SpoutSpec)entry.getValue()).get_common())) {
                    ((Component)ret.get(parentId)).addChild(spout);
                }
            }
        }
        if (bolts != null) {
            for (Map.Entry entry : bolts.entrySet()) {
                Component bolt = (Component)ret.get(entry.getKey());
                for (String parentId : this.getInputsTo(((Bolt)entry.getValue()).get_common())) {
                    ((Component)ret.get(parentId)).addChild(bolt);
                }
            }
        }
        return ret;
    }

    public boolean hasSpouts() {
        Map spouts = this.topology.get_spouts();
        if (spouts == null) {
            return false;
        }
        for (String compId : spouts.keySet()) {
            if (Utils.isSystemId((String)compId)) continue;
            return true;
        }
        return false;
    }

    public String getComponentFromExecutor(ExecutorDetails exec) {
        return this.executorToComponent.get(exec);
    }

    public Double getOnHeapMemoryRequirement(ExecutorDetails exec) {
        Double ret = null;
        if (this.hasExecInTopo(exec)) {
            ret = this.resourceList.get(exec).getOnHeapMemoryMb();
        }
        return ret;
    }

    public Double getOffHeapMemoryRequirement(ExecutorDetails exec) {
        Double ret = null;
        if (this.hasExecInTopo(exec)) {
            ret = this.resourceList.get(exec).getOffHeapMemoryMb();
        }
        return ret;
    }

    public Double getTotalMemReqTask(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.getOffHeapMemoryRequirement(exec) + this.getOnHeapMemoryRequirement(exec);
        }
        return null;
    }

    public Set<SharedMemory> getSharedMemoryRequests(Collection<ExecutorDetails> executors) {
        Map compToSharedName;
        HashSet<String> components = new HashSet<String>();
        for (ExecutorDetails exec : executors) {
            String component = this.executorToComponent.get(exec);
            if (component == null) continue;
            components.add(component);
        }
        HashSet<SharedMemory> ret = new HashSet<SharedMemory>();
        if (this.topology != null && (compToSharedName = this.topology.get_component_to_shared_memory()) != null) {
            for (String component : components) {
                Set sharedNames = (Set)compToSharedName.get(component);
                if (sharedNames == null) continue;
                for (String name : sharedNames) {
                    ret.add((SharedMemory)this.topology.get_shared_memory().get(name));
                }
            }
        }
        return ret;
    }

    public NormalizedResourceRequest getTotalResources(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.resourceList.get(exec);
        }
        return null;
    }

    public NormalizedResourceRequest getApproximateTotalResources() {
        NormalizedResourceRequest ret = new NormalizedResourceRequest();
        for (NormalizedResourceRequest resources : this.resourceList.values()) {
            ret.add(resources);
        }
        return ret;
    }

    public NormalizedResourceRequest getApproximateResources(Set<ExecutorDetails> execs) {
        NormalizedResourceRequest ret = new NormalizedResourceRequest();
        execs.stream().filter(x -> this.hasExecInTopo((ExecutorDetails)x)).forEach(x -> ret.add(this.resourceList.get(x)));
        return ret;
    }

    public Double getTotalCpuReqTask(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.resourceList.get(exec).getTotalCpu();
        }
        return null;
    }

    public double getTotalRequestedMemOnHeap() {
        return this.getRequestedSharedOnHeap() + this.getRequestedNonSharedOnHeap();
    }

    public double getRequestedSharedOnHeap() {
        double ret = 0.0;
        if (this.topology.is_set_shared_memory()) {
            for (SharedMemory req : this.topology.get_shared_memory().values()) {
                ret += req.get_on_heap();
            }
        }
        return ret;
    }

    public double getRequestedNonSharedOnHeap() {
        double totalMemOnHeap = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double execMem = this.getOnHeapMemoryRequirement(exec);
            if (execMem == null) continue;
            totalMemOnHeap += execMem.doubleValue();
        }
        return totalMemOnHeap;
    }

    public double getTotalRequestedMemOffHeap() {
        return this.getRequestedNonSharedOffHeap() + this.getRequestedSharedOffHeap();
    }

    public double getRequestedNonSharedOffHeap() {
        double totalMemOffHeap = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double execMem = this.getOffHeapMemoryRequirement(exec);
            if (execMem == null) continue;
            totalMemOffHeap += execMem.doubleValue();
        }
        return totalMemOffHeap;
    }

    public double getRequestedSharedOffHeap() {
        double ret = 0.0;
        if (this.topology.is_set_shared_memory()) {
            for (SharedMemory req : this.topology.get_shared_memory().values()) {
                ret += req.get_off_heap_worker() + req.get_off_heap_node();
            }
        }
        return ret;
    }

    public double getTotalRequestedCpu() {
        double totalCpu = 0.0;
        for (ExecutorDetails exec : this.getExecutors()) {
            Double execCpu = this.getTotalCpuReqTask(exec);
            if (execCpu == null) continue;
            totalCpu += execCpu.doubleValue();
        }
        return totalCpu;
    }

    public Map<String, Double> getTotalRequestedGenericResources() {
        Map<String, Double> map = this.getApproximateTotalResources().toNormalizedMap();
        NormalizedResourceRequest.removeNonGenericResources(map);
        return map;
    }

    public NormalizedResourceRequest getTaskResourceReqList(ExecutorDetails exec) {
        if (this.hasExecInTopo(exec)) {
            return this.resourceList.get(exec);
        }
        return null;
    }

    public boolean hasExecInTopo(ExecutorDetails exec) {
        return this.resourceList != null && this.resourceList.containsKey(exec);
    }

    public void addResourcesForExec(ExecutorDetails exec, NormalizedResourceRequest resourceList) {
        if (this.hasExecInTopo(exec)) {
            LOG.warn("Executor {} already exists...ResourceList: {}", (Object)exec, (Object)this.getTaskResourceReqList(exec));
            return;
        }
        this.resourceList.put(exec, resourceList);
    }

    private void addDefaultResforExec(ExecutorDetails exec) {
        String componentId = this.getExecutorToComponent().get(exec);
        this.addResourcesForExec(exec, new NormalizedResourceRequest(this.topologyConf, componentId));
    }

    private void initConfigs() {
        this.topologyWorkerMaxHeapSize = ObjectReader.getDouble((Object)this.topologyConf.get("topology.worker.max.heap.size.mb"), null);
        this.topologyPriority = ObjectReader.getInt((Object)this.topologyConf.get("topology.priority"), null);
        assert (this.topologyWorkerMaxHeapSize != null);
        assert (this.topologyPriority != null);
    }

    public Double getTopologyWorkerMaxHeapSize() {
        return this.topologyWorkerMaxHeapSize;
    }

    public String getTopologySubmitter() {
        return this.owner;
    }

    public int getTopologyPriority() {
        return this.topologyPriority;
    }

    public int getLaunchTime() {
        return this.launchTime;
    }

    public int getUpTime() {
        return Time.currentTimeSecs() - this.launchTime;
    }

    public String toString() {
        return "Name: " + this.getName() + " id: " + this.getId() + " Priority: " + this.getTopologyPriority() + " Uptime: " + this.getUpTime() + " CPU: " + this.getTotalRequestedCpu() + " Memory: " + (this.getTotalRequestedMemOffHeap() + this.getTotalRequestedMemOnHeap());
    }

    public int hashCode() {
        return this.topologyId.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TopologyDetails)) {
            return false;
        }
        return this.topologyId.equals(((TopologyDetails)o).getId());
    }
}

