/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.storm.DaemonConfig;
import org.apache.storm.daemon.nimbus.TopologyResources;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.networktopography.DefaultRackDNSToSwitchMapping;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.INimbus;
import org.apache.storm.scheduler.ISchedulingState;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SchedulerAssignmentImpl;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.SupervisorResources;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.normalization.NormalizedResources;
import org.apache.storm.scheduler.resource.normalization.ResourceMetrics;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster
implements ISchedulingState {
    private static final Logger LOG = LoggerFactory.getLogger(Cluster.class);
    private final Map<String, SupervisorDetails> supervisors = new HashMap<String, SupervisorDetails>();
    private final Map<String, List<String>> networkTopography = new HashMap<String, List<String>>();
    private final Map<String, SchedulerAssignmentImpl> assignments = new HashMap<String, SchedulerAssignmentImpl>();
    private final Map<String, String> status = new HashMap<String, String>();
    private final Map<String, List<String>> hostToId = new HashMap<String, List<String>>();
    private final Map<String, Object> conf;
    private final Topologies topologies;
    private final Map<String, Map<WorkerSlot, NormalizedResourceRequest>> nodeToScheduledResourcesCache;
    private final Map<String, Map<String, Double>> nodeToScheduledOffHeapNodeMemoryCache;
    private final Map<String, Set<WorkerSlot>> nodeToUsedSlotsCache;
    private final Map<String, NormalizedResourceRequest> totalResourcesPerNodeCache = new HashMap<String, NormalizedResourceRequest>();
    private final double totalCpuResource;
    private final double totalMemoryResource;
    private final Map<String, Double> totalGenericResources;
    private final ResourceMetrics resourceMetrics;
    private SchedulerAssignmentImpl assignment;
    private Set<String> blackListedHosts = new HashSet<String>();
    private List<String> greyListedSupervisors = new ArrayList<String>();
    private INimbus inimbus;
    private double minWorkerCpu = 0.0;
    private final Map<String, Boolean> topoSharedOffHeapMemoryNodeFlag = new HashMap<String, Boolean>();
    private final Map<String, Map<String, Map<String, Collection<ExecutorDetails>>>> topoIdToNodeIdToSlotIdToExecutors = new HashMap<String, Map<String, Map<String, Collection<ExecutorDetails>>>>();

    private static <K, V> Map<K, V> makeMap(String key) {
        return new HashMap();
    }

    private static <K> Set<K> makeSet(String key) {
        return new HashSet();
    }

    public Cluster(INimbus nimbus, ResourceMetrics resourceMetrics, Map<String, SupervisorDetails> supervisors, Map<String, ? extends SchedulerAssignment> assignments, Topologies topologies, Map<String, Object> conf) {
        this(nimbus, resourceMetrics, supervisors, assignments, topologies, conf, null, null, null, null, Double.NaN, Double.NaN, null);
    }

    public Cluster(Cluster src) {
        this(src.inimbus, src.resourceMetrics, src.supervisors, src.assignments, src.topologies, new HashMap<String, Object>(src.conf), src.status, src.blackListedHosts, src.greyListedSupervisors, src.networkTopography, src.totalCpuResource, src.totalMemoryResource, src.totalGenericResources);
    }

    @VisibleForTesting
    public Cluster(Cluster src, Topologies topologies) {
        this(src.inimbus, src.resourceMetrics, src.supervisors, src.assignments, topologies, new HashMap<String, Object>(src.conf), src.status, src.blackListedHosts, src.greyListedSupervisors, src.networkTopography, src.totalCpuResource, src.totalMemoryResource, src.totalGenericResources);
    }

    /*
     * WARNING - void declaration
     */
    private Cluster(INimbus nimbus, ResourceMetrics resourceMetrics, Map<String, SupervisorDetails> supervisors, Map<String, ? extends SchedulerAssignment> assignments, Topologies topologies, Map<String, Object> conf, Map<String, String> status, Set<String> blackListedHosts, List<String> greyListedSupervisors, Map<String, List<String>> networkTopography, double totalCpuResource, double totalMemoryResource, Map<String, Double> totalGenericResources) {
        this.inimbus = nimbus;
        this.resourceMetrics = resourceMetrics;
        this.supervisors.putAll(supervisors);
        this.nodeToScheduledResourcesCache = new HashMap<String, Map<WorkerSlot, NormalizedResourceRequest>>(this.supervisors.size());
        this.nodeToScheduledOffHeapNodeMemoryCache = new HashMap<String, Map<String, Double>>();
        this.nodeToUsedSlotsCache = new HashMap<String, Set<WorkerSlot>>(this.supervisors.size());
        for (Map.Entry<String, SupervisorDetails> entry : supervisors.entrySet()) {
            String nodeId = entry.getKey();
            SupervisorDetails supervisor = entry.getValue();
            String host = supervisor.getHost();
            List ids = this.hostToId.computeIfAbsent(host, k -> new ArrayList());
            ids.add(nodeId);
        }
        this.conf = conf;
        this.topologies = topologies;
        this.minWorkerCpu = ObjectReader.getDouble((Object)conf.get(DaemonConfig.STORM_WORKER_MIN_CPU_PCORE_PERCENT), (Double)0.0);
        this.totalCpuResource = Double.isNaN(totalCpuResource) ? this.computeClusterCpuResource() : totalCpuResource;
        this.totalMemoryResource = Double.isNaN(totalMemoryResource) ? this.computeClusterMemoryResource() : totalMemoryResource;
        this.totalGenericResources = totalGenericResources == null ? this.computeClusterGenericResources() : totalGenericResources;
        ArrayList<String> supervisorHostNames = new ArrayList<String>();
        for (SupervisorDetails s : supervisors.values()) {
            supervisorHostNames.add(s.getHost());
        }
        if (networkTopography == null || networkTopography.isEmpty()) {
            void var17_19;
            String string = (String)conf.get("storm.network.topography.plugin");
            if (string == null || string.isEmpty()) {
                String string2 = DefaultRackDNSToSwitchMapping.class.getName();
            }
            DNSToSwitchMapping topographyMapper = (DNSToSwitchMapping)ReflectionUtils.newInstance((String)var17_19);
            Map resolvedSuperVisors = topographyMapper.resolve(supervisorHostNames);
            for (Map.Entry entry : resolvedSuperVisors.entrySet()) {
                String hostName = (String)entry.getKey();
                String rack = (String)entry.getValue();
                List nodesForRack = this.networkTopography.computeIfAbsent(rack, k -> new ArrayList());
                nodesForRack.add(hostName);
            }
        } else {
            this.networkTopography.putAll(networkTopography);
        }
        if (status != null) {
            this.status.putAll(status);
        }
        if (blackListedHosts != null) {
            this.blackListedHosts.addAll(blackListedHosts);
        }
        if (greyListedSupervisors != null) {
            this.greyListedSupervisors.addAll(greyListedSupervisors);
        }
        this.setAssignments(assignments, true);
    }

    public static double getAssignedMemoryForSlot(Map<String, Object> topConf) {
        double totalWorkerMemory = 0.0;
        Integer topologyWorkerDefaultMemoryAllocation = 768;
        List topologyWorkerGcChildopts = ConfigUtils.getValueAsList((String)"topology.worker.gc.childopts", topConf);
        List workerGcChildopts = ConfigUtils.getValueAsList((String)"worker.gc.childopts", topConf);
        Double memGcChildopts = null;
        memGcChildopts = Utils.parseJvmHeapMemByChildOpts((List)topologyWorkerGcChildopts, null);
        if (memGcChildopts == null) {
            memGcChildopts = Utils.parseJvmHeapMemByChildOpts((List)workerGcChildopts, null);
        }
        List topologyWorkerChildopts = ConfigUtils.getValueAsList((String)"topology.worker.childopts", topConf);
        Double memTopologyWorkerChildopts = Utils.parseJvmHeapMemByChildOpts((List)topologyWorkerChildopts, null);
        List workerChildopts = ConfigUtils.getValueAsList((String)"worker.childopts", topConf);
        Double memWorkerChildopts = Utils.parseJvmHeapMemByChildOpts((List)workerChildopts, null);
        if (memGcChildopts != null) {
            totalWorkerMemory += memGcChildopts.doubleValue();
        } else if (memTopologyWorkerChildopts != null) {
            totalWorkerMemory += memTopologyWorkerChildopts.doubleValue();
        } else if (memWorkerChildopts != null) {
            totalWorkerMemory += memWorkerChildopts.doubleValue();
        } else {
            Object workerHeapMemoryMb = topConf.get("worker.heap.memory.mb");
            totalWorkerMemory += (double)ObjectReader.getInt((Object)workerHeapMemoryMb, (Integer)topologyWorkerDefaultMemoryAllocation).intValue();
        }
        List topoWorkerLwChildopts = ConfigUtils.getValueAsList((String)"topology.worker.logwriter.childopts", topConf);
        if (topoWorkerLwChildopts != null) {
            totalWorkerMemory += Utils.parseJvmHeapMemByChildOpts((List)topoWorkerLwChildopts, (Double)0.0).doubleValue();
        }
        return totalWorkerMemory;
    }

    protected void assertValidTopologyForModification(String topologyId) {
    }

    @Override
    public Topologies getTopologies() {
        return this.topologies;
    }

    @Override
    public Set<String> getBlacklistedHosts() {
        return this.blackListedHosts;
    }

    public void setBlacklistedHosts(Set<String> hosts) {
        if (hosts == this.blackListedHosts) {
            return;
        }
        this.blackListedHosts.clear();
        this.blackListedHosts.addAll(hosts);
    }

    public void blacklistHost(String host) {
        this.blackListedHosts.add(host);
    }

    @Override
    public boolean isBlackListed(String supervisorId) {
        return this.blackListedHosts.contains(this.getHost(supervisorId));
    }

    @Override
    public boolean isBlacklistedHost(String host) {
        return this.blackListedHosts.contains(host);
    }

    @Override
    public String getHost(String supervisorId) {
        return this.inimbus.getHostName(this.supervisors, supervisorId);
    }

    @Override
    public List<TopologyDetails> needsSchedulingTopologies() {
        ArrayList<TopologyDetails> ret = new ArrayList<TopologyDetails>();
        for (TopologyDetails topology : this.getTopologies()) {
            if (!this.needsScheduling(topology)) continue;
            ret.add(topology);
        }
        return ret;
    }

    @Override
    public boolean needsScheduling(TopologyDetails topology) {
        int assignedNumWorkers;
        int desiredNumWorkers = topology.getNumWorkers();
        return desiredNumWorkers > (assignedNumWorkers = this.getAssignedNumWorkers(topology)) || this.getUnassignedExecutors(topology).size() > 0;
    }

    @Override
    public boolean needsSchedulingRas(TopologyDetails topology) {
        return this.getUnassignedExecutors(topology).size() > 0;
    }

    @Override
    public Map<ExecutorDetails, String> getNeedsSchedulingExecutorToComponents(TopologyDetails topology) {
        HashSet<ExecutorDetails> allExecutors = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.assignments.get(topology.getId());
        if (assignment != null) {
            allExecutors.removeAll(assignment.getExecutors());
        }
        return topology.selectExecutorToComponent(allExecutors);
    }

    @Override
    public Map<String, List<ExecutorDetails>> getNeedsSchedulingComponentToExecutors(TopologyDetails topology) {
        Map<ExecutorDetails, String> executorToComponents = this.getNeedsSchedulingExecutorToComponents(topology);
        HashMap<String, List<ExecutorDetails>> componentToExecutors = new HashMap<String, List<ExecutorDetails>>();
        for (Map.Entry<ExecutorDetails, String> entry : executorToComponents.entrySet()) {
            ExecutorDetails executor = entry.getKey();
            String component = entry.getValue();
            if (!componentToExecutors.containsKey(component)) {
                componentToExecutors.put(component, new ArrayList());
            }
            ((List)componentToExecutors.get(component)).add(executor);
        }
        return componentToExecutors;
    }

    @Override
    public Set<Integer> getUsedPorts(SupervisorDetails supervisor) {
        return this.nodeToUsedSlotsCache.computeIfAbsent(supervisor.getId(), Cluster::makeSet).stream().map(WorkerSlot::getPort).collect(Collectors.toSet());
    }

    @Override
    public Set<Integer> getAvailablePorts(SupervisorDetails supervisor) {
        Set<Integer> usedPorts = this.getUsedPorts(supervisor);
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getAssignablePorts(supervisor));
        ret.removeAll(usedPorts);
        return ret;
    }

    @Override
    public Set<Integer> getAssignablePorts(SupervisorDetails supervisor) {
        if (this.isBlackListed(supervisor.getId())) {
            return Collections.emptySet();
        }
        return supervisor.getAllPorts();
    }

    @Override
    public List<WorkerSlot> getNonBlacklistedAvailableSlots(List<String> blacklistedSupervisorIds) {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            if (this.isBlackListed(supervisor.getId()) || blacklistedSupervisorIds.contains(supervisor.getId())) continue;
            slots.addAll(this.getAvailableSlots(supervisor));
        }
        return slots;
    }

    @Override
    public List<WorkerSlot> getAvailableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAvailableSlots(supervisor));
        }
        return slots;
    }

    @Override
    public List<WorkerSlot> getAvailableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAvailablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), (Number)port));
        }
        return slots;
    }

    @Override
    public List<WorkerSlot> getAssignableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAssignablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), (Number)port));
        }
        return slots;
    }

    @Override
    public List<WorkerSlot> getAssignableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAssignableSlots(supervisor));
        }
        return slots;
    }

    @Override
    public Collection<ExecutorDetails> getUnassignedExecutors(TopologyDetails topology) {
        if (topology == null) {
            return new ArrayList<ExecutorDetails>(0);
        }
        HashSet<ExecutorDetails> ret = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.getAssignmentById(topology.getId());
        if (assignment != null) {
            Set<ExecutorDetails> assignedExecutors = assignment.getExecutors();
            ret.removeAll(assignedExecutors);
        }
        return ret;
    }

    @Override
    public int getAssignedNumWorkers(TopologyDetails topology) {
        SchedulerAssignment assignment;
        SchedulerAssignment schedulerAssignment = assignment = topology != null ? this.getAssignmentById(topology.getId()) : null;
        if (assignment == null) {
            return 0;
        }
        HashSet<WorkerSlot> slots = new HashSet<WorkerSlot>();
        slots.addAll(assignment.getExecutorToSlot().values());
        return slots.size();
    }

    @Override
    public NormalizedResourceOffer getAvailableResources(SupervisorDetails sd) {
        NormalizedResourceOffer ret = new NormalizedResourceOffer(sd.getTotalResources());
        for (SchedulerAssignment schedulerAssignment : this.assignments.values()) {
            for (Map.Entry<WorkerSlot, WorkerResources> entry : schedulerAssignment.getScheduledResources().entrySet()) {
                if (!sd.getId().equals(entry.getKey().getNodeId())) continue;
                ret.remove(entry.getValue(), this.getResourceMetrics());
            }
        }
        return ret;
    }

    private void addResource(Map<String, Double> resourceMap, String resourceName, Double valueToBeAdded) {
        if (!resourceMap.containsKey(resourceName)) {
            resourceMap.put(resourceName, 0.0);
        }
        Double currentPresent = resourceMap.get(resourceName);
        resourceMap.put(resourceName, currentPresent + valueToBeAdded);
    }

    private WorkerResources calculateWorkerResources(TopologyDetails td, Collection<ExecutorDetails> executors) {
        NormalizedResourceRequest totalResources = new NormalizedResourceRequest();
        HashMap<String, Double> sharedTotalResources = new HashMap();
        for (ExecutorDetails exec : executors) {
            NormalizedResourceRequest allResources = td.getTotalResources(exec);
            if (allResources == null) continue;
            totalResources.add(allResources);
        }
        for (SharedMemory shared : td.getSharedMemoryRequests(executors)) {
            totalResources.addOffHeap(shared.get_off_heap_worker());
            totalResources.addOnHeap(shared.get_on_heap());
            this.addResource(sharedTotalResources, "offheap.memory.mb", shared.get_off_heap_worker());
            this.addResource(sharedTotalResources, "onheap.memory.mb", shared.get_on_heap());
        }
        sharedTotalResources = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(sharedTotalResources);
        Map<String, Double> totalResourcesMap = totalResources.toNormalizedMap();
        Double cpu = totalResources.getTotalCpu();
        if (cpu < this.minWorkerCpu) {
            cpu = this.minWorkerCpu;
            totalResourcesMap.put("cpu.pcore.percent", cpu);
        }
        WorkerResources ret = new WorkerResources();
        ret.set_resources(totalResourcesMap);
        ret.set_shared_resources(sharedTotalResources);
        ret.set_cpu(cpu.doubleValue());
        ret.set_mem_off_heap(totalResources.getOffHeapMemoryMb());
        ret.set_mem_on_heap(totalResources.getOnHeapMemoryMb());
        ret.set_shared_mem_off_heap(sharedTotalResources.getOrDefault("offheap.memory.mb", 0.0).doubleValue());
        ret.set_shared_mem_on_heap(sharedTotalResources.getOrDefault("onheap.memory.mb", 0.0).doubleValue());
        return ret;
    }

    @Override
    public boolean wouldFit(WorkerSlot ws, ExecutorDetails exec, TopologyDetails td, NormalizedResourceOffer resourcesAvailable, double maxHeap) {
        double cpuAvailable;
        NormalizedResourceRequest requestedResources = td.getTotalResources(exec);
        if (!resourcesAvailable.couldFit(this.minWorkerCpu, requestedResources)) {
            return false;
        }
        double currentTotal = 0.0;
        double currentCpuTotal = 0.0;
        HashSet<ExecutorDetails> wouldBeAssigned = new HashSet<ExecutorDetails>();
        wouldBeAssigned.add(exec);
        SchedulerAssignmentImpl assignment = this.assignments.get(td.getId());
        if (assignment != null) {
            Collection<ExecutorDetails> currentlyAssigned = assignment.getSlotToExecutors().get(ws);
            if (currentlyAssigned != null) {
                wouldBeAssigned.addAll(currentlyAssigned);
                WorkerResources wrCurrent = this.calculateWorkerResources(td, currentlyAssigned);
                currentTotal = wrCurrent.get_mem_off_heap() + wrCurrent.get_mem_on_heap();
                currentCpuTotal = wrCurrent.get_cpu();
            }
            currentTotal += this.calculateSharedOffHeapNodeMemory(ws.getNodeId(), td);
        }
        WorkerResources wrAfter = this.calculateWorkerResources(td, wouldBeAssigned);
        double afterTotal = wrAfter.get_mem_off_heap() + wrAfter.get_mem_on_heap();
        afterTotal += this.calculateSharedOffHeapNodeMemory(ws.getNodeId(), td, exec);
        double afterOnHeap = wrAfter.get_mem_on_heap();
        double afterCpuTotal = wrAfter.get_cpu();
        double cpuAdded = afterCpuTotal - currentCpuTotal;
        if (cpuAdded > (cpuAvailable = resourcesAvailable.getTotalCpu())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Could not schedule {}:{} on {} not enough CPU {} > {}", new Object[]{td.getName(), exec, ws, cpuAdded, cpuAvailable});
            }
            return false;
        }
        double memoryAdded = afterTotal - currentTotal;
        double memoryAvailable = resourcesAvailable.getTotalMemoryMb();
        if (memoryAdded > memoryAvailable) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Could not schedule {}:{} on {} not enough Mem {} > {}", new Object[]{td.getName(), exec, ws, memoryAdded, memoryAvailable});
            }
            return false;
        }
        if (afterOnHeap > maxHeap) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Could not schedule {}:{} on {} HEAP would be too large {} > {}", new Object[]{td.getName(), exec, ws, afterOnHeap, maxHeap});
            }
            return false;
        }
        return true;
    }

    public void assign(WorkerSlot slot, String topologyId, Collection<ExecutorDetails> executors) {
        this.assertValidTopologyForModification(topologyId);
        if (this.isSlotOccupied(slot)) {
            throw new RuntimeException("slot: [" + slot.getNodeId() + ", " + slot.getPort() + "] is already occupied.");
        }
        Collection executorDetails = this.topoIdToNodeIdToSlotIdToExecutors.computeIfAbsent(topologyId, Cluster::makeMap).computeIfAbsent(slot.getNodeId(), Cluster::makeMap).computeIfAbsent(slot.getId(), Cluster::makeSet);
        executorDetails.clear();
        executorDetails.addAll(executors);
        TopologyDetails td = this.topologies.getById(topologyId);
        if (td == null) {
            throw new IllegalArgumentException("Trying to schedule for topo " + topologyId + " but that is not a known topology " + this.topologies.getAllIds());
        }
        WorkerResources resources = this.calculateWorkerResources(td, executors);
        SchedulerAssignmentImpl assignment = this.assignments.get(topologyId);
        if (assignment == null) {
            assignment = new SchedulerAssignmentImpl(topologyId);
            this.assignments.put(topologyId, assignment);
        } else {
            for (ExecutorDetails executor : executors) {
                if (!assignment.isExecutorAssigned(executor)) continue;
                throw new RuntimeException("Attempting to assign executor: " + executor + " of topology: " + topologyId + " to workerslot: " + slot + ". The executor is already assigned to workerslot: " + assignment.getExecutorToSlot().get(executor) + ". The executor must unassigned before it can be assigned to another slot!");
            }
        }
        assignment.assign(slot, executors, resources);
        String nodeId = slot.getNodeId();
        double sharedOffHeapNodeMemory = this.calculateSharedOffHeapNodeMemory(nodeId, td);
        assignment.setTotalSharedOffHeapNodeMemory(nodeId, sharedOffHeapNodeMemory);
        this.updateCachesForWorkerSlot(slot, resources, topologyId, sharedOffHeapNodeMemory);
        this.totalResourcesPerNodeCache.remove(slot.getNodeId());
    }

    public void assign(SchedulerAssignment assignment, boolean ignoreSingleExceptions) {
        String id = assignment.getTopologyId();
        this.assertValidTopologyForModification(id);
        Map<WorkerSlot, Collection<ExecutorDetails>> slotToExecs = assignment.getSlotToExecutors();
        for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : slotToExecs.entrySet()) {
            try {
                this.assign(entry.getKey(), id, entry.getValue());
            }
            catch (RuntimeException e) {
                if (ignoreSingleExceptions) continue;
                throw e;
            }
        }
    }

    private void initializeTopoSharedOffHeapNodeMemoryFlag(TopologyDetails td) {
        String topoId = td.getId();
        this.topoSharedOffHeapMemoryNodeFlag.put(topoId, false);
        StormTopology topology = td.getTopology();
        if (topology == null) {
            return;
        }
        if (topology.is_set_shared_memory()) {
            for (SharedMemory sharedMemory : topology.get_shared_memory().values()) {
                double val = sharedMemory.get_off_heap_node();
                if (!(val > 0.0)) continue;
                this.topoSharedOffHeapMemoryNodeFlag.put(topoId, true);
                return;
            }
        }
    }

    private double calculateSharedOffHeapNodeMemory(String nodeId, TopologyDetails td) {
        return this.calculateSharedOffHeapNodeMemory(nodeId, td, null);
    }

    private double calculateSharedOffHeapNodeMemory(String nodeId, TopologyDetails td, ExecutorDetails extra) {
        String topoId = td.getId();
        if (!this.topoSharedOffHeapMemoryNodeFlag.containsKey(topoId)) {
            this.initializeTopoSharedOffHeapNodeMemoryFlag(td);
        }
        if (!this.topoSharedOffHeapMemoryNodeFlag.get(topoId).booleanValue()) {
            return 0.0;
        }
        HashSet<ExecutorDetails> executorsOnNode = new HashSet<ExecutorDetails>();
        this.topoIdToNodeIdToSlotIdToExecutors.computeIfAbsent(td.getId(), Cluster::makeMap).computeIfAbsent(nodeId, Cluster::makeMap).forEach((k, v) -> executorsOnNode.addAll((Collection<ExecutorDetails>)v));
        if (extra != null) {
            executorsOnNode.add(extra);
        }
        double memorySharedWithinNode = 0.0;
        for (SharedMemory shared : td.getSharedMemoryRequests(executorsOnNode)) {
            memorySharedWithinNode += shared.get_off_heap_node();
        }
        return memorySharedWithinNode;
    }

    public void freeSlot(WorkerSlot slot) {
        String nodeId = slot.getNodeId();
        for (SchedulerAssignmentImpl assignment : this.assignments.values()) {
            if (!assignment.isSlotOccupied(slot)) continue;
            String topologyId = assignment.getTopologyId();
            this.assertValidTopologyForModification(topologyId);
            assignment.unassignBySlot(slot);
            this.topoIdToNodeIdToSlotIdToExecutors.computeIfAbsent(topologyId, Cluster::makeMap).computeIfAbsent(nodeId, Cluster::makeMap).computeIfAbsent(slot.getId(), Cluster::makeSet).clear();
            TopologyDetails td = this.topologies.getById(topologyId);
            assignment.setTotalSharedOffHeapNodeMemory(nodeId, this.calculateSharedOffHeapNodeMemory(nodeId, td));
            this.nodeToScheduledResourcesCache.computeIfAbsent(nodeId, Cluster::makeMap).put(slot, new NormalizedResourceRequest());
            this.nodeToUsedSlotsCache.computeIfAbsent(nodeId, Cluster::makeSet).remove(slot);
        }
        this.totalResourcesPerNodeCache.remove(nodeId);
    }

    public void freeSlots(Collection<WorkerSlot> slots) {
        if (slots != null) {
            for (WorkerSlot slot : slots) {
                this.freeSlot(slot);
            }
        }
    }

    @Override
    public boolean isSlotOccupied(WorkerSlot slot) {
        return this.nodeToUsedSlotsCache.computeIfAbsent(slot.getNodeId(), Cluster::makeSet).contains(slot);
    }

    @Override
    public SchedulerAssignment getAssignmentById(String topologyId) {
        if (this.assignments.containsKey(topologyId)) {
            return this.assignments.get(topologyId);
        }
        return null;
    }

    @Override
    public Collection<WorkerSlot> getUsedSlotsByTopologyId(String topologyId) {
        SchedulerAssignmentImpl assignment = this.assignments.get(topologyId);
        if (assignment == null) {
            return Collections.emptySet();
        }
        return assignment.getSlots();
    }

    @Override
    public SupervisorDetails getSupervisorById(String nodeId) {
        return this.supervisors.get(nodeId);
    }

    @Override
    public Collection<WorkerSlot> getUsedSlots() {
        return this.nodeToUsedSlotsCache.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public List<SupervisorDetails> getSupervisorsByHost(String host) {
        List<String> nodeIds = this.hostToId.get(host);
        ArrayList<SupervisorDetails> ret = new ArrayList<SupervisorDetails>();
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                ret.add(this.getSupervisorById(nodeId));
            }
        }
        return ret;
    }

    @Override
    public Map<String, SchedulerAssignment> getAssignments() {
        return new HashMap<String, SchedulerAssignment>(this.assignments);
    }

    public void setAssignments(Map<String, ? extends SchedulerAssignment> newAssignments, boolean ignoreSingleExceptions) {
        if (newAssignments == this.assignments) {
            return;
        }
        for (SchedulerAssignment schedulerAssignment : newAssignments.values()) {
            this.assertValidTopologyForModification(schedulerAssignment.getTopologyId());
        }
        for (SchedulerAssignment schedulerAssignment : this.assignments.values()) {
            this.assertValidTopologyForModification(schedulerAssignment.getTopologyId());
        }
        this.assignments.clear();
        this.totalResourcesPerNodeCache.clear();
        this.nodeToScheduledResourcesCache.values().forEach(Map::clear);
        this.nodeToUsedSlotsCache.values().forEach(Set::clear);
        for (SchedulerAssignment schedulerAssignment : newAssignments.values()) {
            this.assign(schedulerAssignment, ignoreSingleExceptions);
        }
    }

    @Override
    public Map<String, SupervisorDetails> getSupervisors() {
        return this.supervisors;
    }

    @Override
    public NormalizedResourceOffer getNonBlacklistedClusterAvailableResources(Collection<String> blacklistedSupervisorIds) {
        NormalizedResourceOffer available = new NormalizedResourceOffer();
        for (SupervisorDetails sup : this.supervisors.values()) {
            if (this.isBlackListed(sup.getId()) || blacklistedSupervisorIds.contains(sup.getId())) continue;
            available.add(sup.getTotalResources());
            available.remove(this.getAllScheduledResourcesForNode(sup.getId()), this.getResourceMetrics());
        }
        return available;
    }

    @Override
    public double getClusterTotalCpuResource() {
        return this.totalCpuResource;
    }

    private double computeClusterCpuResource() {
        return this.supervisors.values().stream().mapToDouble(SupervisorDetails::getTotalCpu).sum();
    }

    @Override
    public double getClusterTotalMemoryResource() {
        return this.totalMemoryResource;
    }

    private double computeClusterMemoryResource() {
        return this.supervisors.values().stream().mapToDouble(SupervisorDetails::getTotalMemory).sum();
    }

    @Override
    public Map<String, Double> getClusterTotalGenericResources() {
        return this.totalGenericResources;
    }

    private Map<String, Double> computeClusterGenericResources() {
        return this.supervisors.values().stream().map(sup -> sup.getTotalGenericResources().entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Double::sum));
    }

    @Override
    public Map<String, List<String>> getNetworkTopography() {
        return this.networkTopography;
    }

    @VisibleForTesting
    public void setNetworkTopography(Map<String, List<String>> networkTopography) {
        this.networkTopography.clear();
        this.networkTopography.putAll(networkTopography);
    }

    public void setStatus(TopologyDetails td, String statusMessage) {
        this.setStatus(td.getId(), statusMessage);
    }

    public void setStatus(String topologyId, String statusMessage) {
        this.assertValidTopologyForModification(topologyId);
        LOG.info("STATUS - {} {}", (Object)topologyId, (Object)statusMessage);
        this.status.put(topologyId, statusMessage);
    }

    public void setStatusIfAbsent(String topologyId, String statusMessage) {
        this.assertValidTopologyForModification(topologyId);
        this.status.putIfAbsent(topologyId, statusMessage);
    }

    @Override
    public Map<String, String> getStatusMap() {
        return this.status;
    }

    public void setStatusMap(Map<String, String> statusMap) {
        if (statusMap == this.status) {
            return;
        }
        for (String topologyId : statusMap.keySet()) {
            this.assertValidTopologyForModification(topologyId);
        }
        for (String topologyId : this.status.keySet()) {
            this.assertValidTopologyForModification(topologyId);
        }
        this.status.clear();
        this.status.putAll(statusMap);
    }

    public String getStatus(String topoId) {
        return this.status.get(topoId);
    }

    @Override
    public Map<String, TopologyResources> getTopologyResourcesMap() {
        HashMap<String, TopologyResources> ret = new HashMap<String, TopologyResources>(this.assignments.size());
        for (TopologyDetails td : this.topologies.getTopologies()) {
            String topoId = td.getId();
            SchedulerAssignmentImpl assignment = this.assignments.get(topoId);
            ret.put(topoId, new TopologyResources(td, assignment));
        }
        return ret;
    }

    @Override
    public Map<String, SupervisorResources> getSupervisorsResourcesMap() {
        HashMap<String, SupervisorResources> ret = new HashMap<String, SupervisorResources>();
        for (SupervisorDetails sd : this.supervisors.values()) {
            ret.put(sd.getId(), new SupervisorResources(sd.getTotalMemory(), sd.getTotalCpu(), sd.getTotalGenericResources(), 0.0, 0.0, new HashMap<String, Double>()));
        }
        for (SchedulerAssignmentImpl assignment : this.assignments.values()) {
            for (Map.Entry<WorkerSlot, WorkerResources> entry : assignment.getScheduledResources().entrySet()) {
                String id = entry.getKey().getNodeId();
                SupervisorResources sr = (SupervisorResources)ret.get(id);
                if (sr == null) {
                    sr = new SupervisorResources(0.0, 0.0, new HashMap<String, Double>(), 0.0, 0.0, new HashMap<String, Double>());
                }
                sr = sr.add(entry.getValue());
                ret.put(id, sr);
            }
            Map<String, Double> nodeIdToSharedOffHeap = assignment.getNodeIdToTotalSharedOffHeapNodeMemory();
            if (nodeIdToSharedOffHeap == null) continue;
            for (Map.Entry<String, Double> entry : nodeIdToSharedOffHeap.entrySet()) {
                String id = entry.getKey();
                SupervisorResources sr = (SupervisorResources)ret.get(id);
                if (sr == null) {
                    sr = new SupervisorResources(0.0, 0.0, new HashMap<String, Double>(), 0.0, 0.0, new HashMap<String, Double>());
                }
                sr = sr.addMem(entry.getValue());
                ret.put(id, sr);
            }
        }
        return ret;
    }

    @Override
    public Map<String, Map<WorkerSlot, WorkerResources>> getWorkerResourcesMap() {
        HashMap<String, Map<WorkerSlot, WorkerResources>> ret = new HashMap<String, Map<WorkerSlot, WorkerResources>>();
        for (Map.Entry<String, SchedulerAssignmentImpl> entry : this.assignments.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getScheduledResources());
        }
        return ret;
    }

    @Override
    public WorkerResources getWorkerResources(WorkerSlot ws) {
        SchedulerAssignmentImpl assignment;
        WorkerResources ret = null;
        Iterator<SchedulerAssignmentImpl> iterator = this.assignments.values().iterator();
        while (iterator.hasNext() && (ret = (assignment = iterator.next()).getScheduledResources().get(ws)) == null) {
        }
        return ret;
    }

    private void updateCachesForWorkerSlot(WorkerSlot workerSlot, WorkerResources workerResources, String topologyId, Double sharedOffHeapNodeMemory) {
        String nodeId = workerSlot.getNodeId();
        NormalizedResourceRequest normalizedResourceRequest = new NormalizedResourceRequest();
        normalizedResourceRequest.add(workerResources);
        this.nodeToScheduledResourcesCache.computeIfAbsent(nodeId, Cluster::makeMap).put(workerSlot, normalizedResourceRequest);
        this.nodeToScheduledOffHeapNodeMemoryCache.computeIfAbsent(nodeId, Cluster::makeMap).put(topologyId, sharedOffHeapNodeMemory);
        this.nodeToUsedSlotsCache.computeIfAbsent(nodeId, Cluster::makeSet).add(workerSlot);
    }

    public ResourceMetrics getResourceMetrics() {
        return this.resourceMetrics;
    }

    @Override
    public NormalizedResourceRequest getAllScheduledResourcesForNode(String nodeId) {
        return this.totalResourcesPerNodeCache.computeIfAbsent(nodeId, nid -> {
            NormalizedResourceRequest totalScheduledResources = new NormalizedResourceRequest();
            for (NormalizedResourceRequest req : this.nodeToScheduledResourcesCache.computeIfAbsent(nodeId, Cluster::makeMap).values()) {
                totalScheduledResources.add(req);
            }
            for (Double offHeapNodeMemory : this.nodeToScheduledOffHeapNodeMemoryCache.computeIfAbsent((String)nid, Cluster::makeMap).values()) {
                totalScheduledResources.addOffHeap(offHeapNodeMemory);
            }
            return totalScheduledResources;
        });
    }

    @Override
    public double getScheduledMemoryForNode(String nodeId) {
        return this.getAllScheduledResourcesForNode(nodeId).getTotalMemoryMb();
    }

    @Override
    public double getScheduledCpuForNode(String nodeId) {
        return this.getAllScheduledResourcesForNode(nodeId).getTotalCpu();
    }

    public INimbus getINimbus() {
        return this.inimbus;
    }

    @Override
    public Map<String, Object> getConf() {
        return this.conf;
    }

    public void unassign(String topoId) {
        this.assertValidTopologyForModification(topoId);
        this.freeSlots(this.getUsedSlotsByTopologyId(topoId));
    }

    public void updateFrom(Cluster other) {
        for (SchedulerAssignment assignment : other.getAssignments().values()) {
            this.assertValidTopologyForModification(assignment.getTopologyId());
        }
        this.setAssignments(other.getAssignments(), false);
        this.setStatusMap(other.getStatusMap());
    }

    public double getMinWorkerCpu() {
        return this.minWorkerCpu;
    }

    public List<String> getGreyListedSupervisors() {
        return this.greyListedSupervisors;
    }

    public void setGreyListedSupervisors(Set<String> greyListedSupervisors) {
        this.greyListedSupervisors.clear();
        this.greyListedSupervisors.addAll(greyListedSupervisors);
    }
}

