/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.IServer;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.pacemaker.IServerMessageHandler;
import org.apache.storm.pacemaker.codec.ThriftNettyServerCodec;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.shade.io.netty.bootstrap.ServerBootstrap;
import org.apache.storm.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelFuture;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelOption;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.WriteBufferWaterMark;
import org.apache.storm.shade.io.netty.channel.group.ChannelGroup;
import org.apache.storm.shade.io.netty.channel.group.DefaultChannelGroup;
import org.apache.storm.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.storm.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.storm.shade.io.netty.util.concurrent.EventExecutor;
import org.apache.storm.shade.io.netty.util.concurrent.GlobalEventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PacemakerServer
implements ISaslServer {
    private static final int FIVE_MB_IN_BYTES = 0x500000;
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerServer.class);
    private final IServerMessageHandler handler;
    private String secret;
    private final String topologyName;
    private volatile ChannelGroup allChannels = new DefaultChannelGroup("storm-server", (EventExecutor)GlobalEventExecutor.INSTANCE);
    private final ChannelGroup authenticatedChannels = new DefaultChannelGroup("authenticated-pacemaker-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
    private final ThriftNettyServerCodec.AuthMethod authMethod;
    private final EventLoopGroup bossEventLoopGroup;
    private final EventLoopGroup workerEventLoopGroup;

    PacemakerServer(IServerMessageHandler handler, Map<String, Object> config) {
        String auth;
        int port = (Integer)config.get("pacemaker.port");
        this.handler = handler;
        this.topologyName = "pacemaker_server";
        switch (auth = (String)config.get("pacemaker.auth.method")) {
            case "DIGEST": {
                this.authMethod = ThriftNettyServerCodec.AuthMethod.DIGEST;
                this.secret = ClientAuthUtils.makeDigestPayload(config, (String)"PacemakerDigest");
                if (this.secret != null) break;
                LOG.error("Can't start pacemaker server without digest secret.");
                throw new RuntimeException("Can't start pacemaker server without digest secret.");
            }
            case "KERBEROS": {
                this.authMethod = ThriftNettyServerCodec.AuthMethod.KERBEROS;
                break;
            }
            case "NONE": {
                this.authMethod = ThriftNettyServerCodec.AuthMethod.NONE;
                break;
            }
            default: {
                LOG.error("Can't start pacemaker server without proper PACEMAKER_AUTH_METHOD.");
                throw new RuntimeException("Can't start pacemaker server without proper PACEMAKER_AUTH_METHOD.");
            }
        }
        NettyRenameThreadFactory bossFactory = new NettyRenameThreadFactory("server-boss");
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory("server-worker");
        this.bossEventLoopGroup = new NioEventLoopGroup(1, (ThreadFactory)bossFactory);
        int maxWorkers = (Integer)config.get("pacemaker.max.threads");
        this.workerEventLoopGroup = new NioEventLoopGroup(maxWorkers > 0 ? maxWorkers : 0, (ThreadFactory)workerFactory);
        LOG.info("Create Netty Server " + this.name() + ", buffer_size: " + 0x500000 + ", maxWorkers: " + maxWorkers);
        int thriftMessageMaxSize = (Integer)config.get("pacemaker.thrift.message.size.max");
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.bossEventLoopGroup, this.workerEventLoopGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)0x500000).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ThriftNettyServerCodec((IServer)this, config, this.authMethod, thriftMessageMaxSize));
        try {
            ChannelFuture channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
            this.allChannels.add((Object)channelFuture.channel());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Bound server to port: {}", (Object)Integer.toString(port));
    }

    public void channelActive(Channel c) {
        this.allChannels.add((Object)c);
    }

    public void cleanPipeline(Channel channel) {
        boolean authenticated = this.authenticatedChannels.contains((Object)channel);
        if (!authenticated) {
            if (channel.pipeline().get("sasl-handler") != null) {
                channel.pipeline().remove("sasl-handler");
            } else if (channel.pipeline().get("kerberos-handler") != null) {
                channel.pipeline().remove("kerberos-handler");
            }
        }
    }

    public void received(Object mesg, String remote, Channel channel) throws InterruptedException {
        this.cleanPipeline(channel);
        boolean authenticated = this.authMethod == ThriftNettyServerCodec.AuthMethod.NONE || this.authenticatedChannels.contains((Object)channel);
        HBMessage m = (HBMessage)mesg;
        LOG.debug("received message. Passing to handler. {} : {} : {}", new Object[]{this.handler.toString(), m.toString(), channel.toString()});
        HBMessage response = this.handler.handleMessage(m, authenticated);
        if (response != null) {
            LOG.debug("Got Response from handler: {}", (Object)response);
            channel.writeAndFlush((Object)response, channel.voidPromise());
        } else {
            LOG.info("Got null response from handler handling message: {}", (Object)m);
        }
    }

    public String name() {
        return this.topologyName;
    }

    public String secretKey() {
        return this.secret;
    }

    public void authenticated(Channel c) {
        LOG.debug("Pacemaker server authenticated channel: {}", (Object)c.toString());
        this.authenticatedChannels.add((Object)c);
    }
}

