/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.rocksdb.KeyType;
import org.apache.storm.metricstore.rocksdb.ReadOnlyStringMetadataCache;
import org.apache.storm.metricstore.rocksdb.RocksDbKey;
import org.apache.storm.metricstore.rocksdb.RocksDbMetricsWriter;
import org.apache.storm.metricstore.rocksdb.RocksDbValue;
import org.apache.storm.metricstore.rocksdb.StringMetadata;
import org.apache.storm.metricstore.rocksdb.WritableStringMetadataCache;
import org.apache.storm.utils.LruMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMetadataCache
implements LruMap.CacheEvictionCallback<String, StringMetadata>,
WritableStringMetadataCache,
ReadOnlyStringMetadataCache {
    private static final Logger LOG = LoggerFactory.getLogger(StringMetadataCache.class);
    private static StringMetadataCache instance = null;
    private Map<String, StringMetadata> lruStringCache;
    private Map<Integer, String> hashToString = new ConcurrentHashMap<Integer, String>();
    private RocksDbMetricsWriter dbWriter;

    private StringMetadataCache(RocksDbMetricsWriter dbWriter, int capacity) {
        this.lruStringCache = Collections.synchronizedMap(new LruMap(capacity, this));
        this.dbWriter = dbWriter;
    }

    static void init(RocksDbMetricsWriter dbWriter, int capacity) throws MetricException {
        if (instance != null) {
            throw new MetricException("StringMetadataCache already created");
        }
        instance = new StringMetadataCache(dbWriter, capacity);
    }

    static WritableStringMetadataCache getWritableStringMetadataCache() throws MetricException {
        if (instance != null) {
            return instance;
        }
        throw new MetricException("StringMetadataCache was not initialized");
    }

    static ReadOnlyStringMetadataCache getReadOnlyStringMetadataCache() throws MetricException {
        if (instance != null) {
            return instance;
        }
        throw new MetricException("StringMetadataCache was not initialized");
    }

    static void cleanUp() {
        instance = null;
    }

    @Override
    public StringMetadata get(String s) {
        return this.lruStringCache.get(s);
    }

    @Override
    public void put(String s, StringMetadata stringMetadata, boolean newEntry) throws MetricException {
        if (this.dbWriter.isShutdown()) {
            throw new MetricException("Shutting down");
        }
        try {
            if (newEntry) {
                this.writeMetadataToDisk(s, stringMetadata);
            }
            this.lruStringCache.put(s, stringMetadata);
            this.hashToString.put(stringMetadata.getStringId(), s);
        }
        catch (Exception e) {
            throw new MetricException("Failed to save string in metadata cache", e);
        }
    }

    @Override
    public void evictionCallback(String key, StringMetadata val) {
        this.writeMetadataToDisk(key, val);
    }

    private void writeMetadataToDisk(String key, StringMetadata val) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} to RocksDB", (Object)key);
        }
        this.hashToString.remove(val.getStringId());
        RocksDbValue rval = new RocksDbValue(val.getLastTimestamp(), key);
        for (KeyType type : val.getMetadataTypes()) {
            RocksDbKey rkey = new RocksDbKey(type, val.getStringId());
            this.dbWriter.handleEvictedMetadata(rkey, rval);
        }
    }

    @Override
    public boolean contains(Integer stringId) {
        return this.hashToString.containsKey(stringId);
    }

    @Override
    public String getMetadataString(Integer stringId) {
        return this.hashToString.get(stringId);
    }

    @Override
    public Set<Map.Entry<String, StringMetadata>> entrySet() {
        return this.lruStringCache.entrySet();
    }
}

