/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.daemon.supervisor.IAdvancedFSOps;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.localizer.LocallyCachedBlob;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.WrappedAuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResource
extends LocallyCachedBlob {
    @VisibleForTesting
    static final String CURRENT_BLOB_SUFFIX = ".current";
    @VisibleForTesting
    static final String BLOB_VERSION_SUFFIX = ".version";
    @VisibleForTesting
    static final String FILECACHE = "filecache";
    @VisibleForTesting
    static final String USERCACHE = "usercache";
    @VisibleForTesting
    static final String FILESDIR = "files";
    @VisibleForTesting
    static final String ARCHIVESDIR = "archives";
    private static final Logger LOG = LoggerFactory.getLogger(LocalizedResource.class);
    private static final String TO_UNCOMPRESS = "_tmp_";
    private static final Pattern VERSION_FILE_PATTERN = Pattern.compile("^(.+)\\.(\\d+)$");
    private final Path baseDir;
    private final Path versionFilePath;
    private final Path symlinkPath;
    private final boolean shouldUncompress;
    private final IAdvancedFSOps fsOps;
    private final String user;
    private final Map<String, Object> conf;
    private final boolean symLinksDisabled;
    private long size = -1L;

    LocalizedResource(String key, Path localBaseDir, boolean shouldUncompress, IAdvancedFSOps fsOps, Map<String, Object> conf, String user, StormMetricsRegistry metricRegistry) {
        super(key + (shouldUncompress ? " archive" : " file"), key, metricRegistry);
        Path base = LocalizedResource.getLocalUserFileCacheDir(localBaseDir, user);
        this.baseDir = shouldUncompress ? LocalizedResource.getCacheDirForArchives(base) : LocalizedResource.getCacheDirForFiles(base);
        this.conf = conf;
        this.symLinksDisabled = (Boolean)conf.getOrDefault("storm.disable.symlinks", false);
        this.user = user;
        this.fsOps = fsOps;
        this.versionFilePath = LocalizedResource.constructVersionFileName(this.baseDir, key);
        this.symlinkPath = LocalizedResource.constructBlobCurrentSymlinkName(this.baseDir, key);
        this.shouldUncompress = shouldUncompress;
        this.setSize();
    }

    private static Path constructVersionFileName(Path baseDir, String key) {
        return baseDir.resolve(key + BLOB_VERSION_SUFFIX);
    }

    @VisibleForTesting
    static long localVersionOfBlob(Path versionFile) {
        long currentVersion = -1L;
        if (Files.exists(versionFile, new LinkOption[0]) && !Files.isDirectory(versionFile, new LinkOption[0])) {
            try (BufferedReader br = new BufferedReader(new FileReader(versionFile.toFile()));){
                String line = br.readLine();
                currentVersion = Long.parseLong(line);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return currentVersion;
    }

    private static Path constructBlobCurrentSymlinkName(Path baseDir, String key) {
        return baseDir.resolve(key + CURRENT_BLOB_SUFFIX);
    }

    private static Path constructBlobWithVersionFileName(Path baseDir, String key, long version) {
        return baseDir.resolve(key + "." + version);
    }

    static Collection<String> getLocalizedUsers(Path localBaseDir) throws IOException {
        Path userCacheDir = LocalizedResource.getUserCacheDir(localBaseDir);
        if (!Files.exists(userCacheDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(userCacheDir).map(p -> p.getFileName().toString()).collect(Collectors.toList());
    }

    static void completelyRemoveUnusedUser(Path localBaseDir, String user) throws IOException {
        Path localUserDir = LocalizedResource.getLocalUserDir(localBaseDir, user);
        LOG.info("completelyRemoveUnusedUser {} for directory {}", (Object)user, (Object)localUserDir);
        Path userFileCacheDir = LocalizedResource.getLocalUserFileCacheDir(localBaseDir, user);
        Files.deleteIfExists(LocalizedResource.getCacheDirForFiles(userFileCacheDir));
        Files.deleteIfExists(LocalizedResource.getCacheDirForArchives(userFileCacheDir));
        Files.deleteIfExists(userFileCacheDir);
        Files.deleteIfExists(localUserDir);
    }

    static List<String> getLocalizedArchiveKeys(Path localBaseDir, String user) throws IOException {
        Path dir = LocalizedResource.getCacheDirForArchives(LocalizedResource.getLocalUserFileCacheDir(localBaseDir, user));
        return LocalizedResource.readKeysFromDir(dir);
    }

    static List<String> getLocalizedFileKeys(Path localBaseDir, String user) throws IOException {
        Path dir = LocalizedResource.getCacheDirForFiles(LocalizedResource.getLocalUserFileCacheDir(localBaseDir, user));
        return LocalizedResource.readKeysFromDir(dir);
    }

    private static List<String> readKeysFromDir(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(dir).map(p -> p.getFileName().toString()).filter(name -> name.toLowerCase().endsWith(CURRENT_BLOB_SUFFIX)).map(key -> {
            int p = key.lastIndexOf(46);
            if (p > 0) {
                key = key.substring(0, p);
            }
            return key;
        }).collect(Collectors.toList());
    }

    private static Path getUserCacheDir(Path localBaseDir) {
        return localBaseDir.resolve(USERCACHE);
    }

    static Path getLocalUserDir(Path localBaseDir, String userName) {
        return LocalizedResource.getUserCacheDir(localBaseDir).resolve(userName);
    }

    static Path getLocalUserFileCacheDir(Path localBaseDir, String userName) {
        return LocalizedResource.getLocalUserDir(localBaseDir, userName).resolve(FILECACHE);
    }

    private static Path getCacheDirForFiles(Path dir) {
        return dir.resolve(FILESDIR);
    }

    private static Path getCacheDirForArchives(Path dir) {
        return dir.resolve(ARCHIVESDIR);
    }

    Path getCurrentSymlinkPath() {
        return this.symlinkPath;
    }

    @VisibleForTesting
    Path getFilePathWithVersion() {
        return LocalizedResource.constructBlobWithVersionFileName(this.baseDir, this.getKey(), this.getLocalVersion());
    }

    private void setSize() {
        Path withVersion = this.getFilePathWithVersion();
        this.size = ServerUtils.getDiskUsage(withVersion.toFile());
        LOG.debug("size of {} is: {}", (Object)withVersion, (Object)this.size);
    }

    @VisibleForTesting
    protected void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getLocalVersion() {
        return LocalizedResource.localVersionOfBlob(this.versionFilePath);
    }

    @Override
    public long getRemoteVersion(ClientBlobStore store) throws KeyNotFoundException, AuthorizationException {
        return ServerUtils.nimbusVersionOfBlob(this.getKey(), store);
    }

    @Override
    public long fetchUnzipToTemp(ClientBlobStore store) throws IOException, KeyNotFoundException, AuthorizationException {
        String key = this.getKey();
        ReadableBlobMeta meta = store.getBlobMeta(key);
        if (!ServerUtils.canUserReadBlob(meta, this.user, this.conf)) {
            throw new WrappedAuthorizationException(this.user + " does not have READ access to " + key);
        }
        LocallyCachedBlob.DownloadMeta downloadMeta = this.fetch(store, key, v -> {
            Path path = this.shouldUncompress ? this.tmpOutputLocation() : LocalizedResource.constructBlobWithVersionFileName(this.baseDir, this.getKey(), v);
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException e) {
                    LOG.error("Failed to create parent directory {}", (Object)parent, (Object)e);
                    throw e;
                }
            }
            return path;
        }, FileOutputStream::new);
        Path finalLocation = downloadMeta.getDownloadPath();
        if (this.shouldUncompress) {
            Path downloadFile = finalLocation;
            finalLocation = LocalizedResource.constructBlobWithVersionFileName(this.baseDir, this.getKey(), downloadMeta.getVersion());
            ServerUtils.unpack(downloadFile.toFile(), finalLocation.toFile(), this.symLinksDisabled);
            LOG.debug("Uncompressed {} to: {}", (Object)downloadFile, (Object)finalLocation);
        }
        this.setBlobPermissions(this.conf, this.user, finalLocation);
        return downloadMeta.getVersion();
    }

    @Override
    protected void commitNewVersion(long version) throws IOException {
        String key = this.getKey();
        LOG.info("Blob: {} updated to version {} from version {}", new Object[]{key, version, this.getLocalVersion()});
        Path localVersionFile = this.versionFilePath;
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(localVersionFile.toFile(), false)));){
            writer.println(version);
        }
        this.setBlobPermissions(this.conf, this.user, localVersionFile);
        Path tmpSymlink = this.tmpSymlinkLocation();
        Path targetOfSymlink = LocalizedResource.constructBlobWithVersionFileName(this.baseDir, this.getKey(), version);
        LOG.debug("Creating a symlink @{} linking to: {}", (Object)tmpSymlink, (Object)targetOfSymlink);
        Files.createSymbolicLink(tmpSymlink, targetOfSymlink, new FileAttribute[0]);
        Path currentSymLink = this.getCurrentSymlinkPath();
        Files.move(tmpSymlink, currentSymLink, StandardCopyOption.ATOMIC_MOVE);
        this.setSize();
    }

    private void setBlobPermissions(Map<String, Object> conf, String user, Path path) throws IOException {
        if (!ObjectReader.getBoolean((Object)conf.get("supervisor.run.worker.as.user"), (boolean)false)) {
            return;
        }
        String wlCommand = ObjectReader.getString((Object)conf.get("supervisor.worker.launcher"), (String)"");
        if (wlCommand.isEmpty()) {
            String stormHome = System.getProperty("storm.home");
            wlCommand = stormHome + "/bin/worker-launcher";
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(wlCommand, user, "blob", path.toString()));
        Object[] commandArray = command.toArray(new String[command.size()]);
        ShellUtils.ShellCommandExecutor shExec = new ShellUtils.ShellCommandExecutor((String[])commandArray);
        LOG.debug("Setting blob permissions, command: {}", (Object)Arrays.toString(commandArray));
        try {
            shExec.execute();
            LOG.debug("output: {}", (Object)shExec.getOutput());
        }
        catch (ShellUtils.ExitCodeException e) {
            int exitCode = shExec.getExitCode();
            LOG.warn("Exit code from worker-launcher is: {}", (Object)exitCode, (Object)e);
            LOG.debug("output: {}", (Object)shExec.getOutput());
            throw new IOException("Setting blob permissions failed (exitCode=" + exitCode + ") with output: " + shExec.getOutput(), e);
        }
    }

    private Path tmpOutputLocation() {
        return this.baseDir.resolve(Paths.get(TO_UNCOMPRESS + this.getKey(), new String[0]));
    }

    private Path tmpSymlinkLocation() {
        return this.baseDir.resolve(Paths.get(TO_UNCOMPRESS + this.getKey() + CURRENT_BLOB_SUFFIX, new String[0]));
    }

    @Override
    public void cleanupOrphanedData() throws IOException {
        Path tmpOutput = this.tmpOutputLocation();
        Files.deleteIfExists(tmpOutput);
        Path tmpSym = this.tmpSymlinkLocation();
        Files.deleteIfExists(tmpSym);
        try {
            long foundVersion;
            Path versionFile;
            Matcher m;
            String baseName = this.getKey();
            long version = this.getLocalVersion();
            Path current = this.getCurrentSymlinkPath();
            if (Files.exists(current, new LinkOption[0]) && Files.isSymbolicLink(current) && (m = VERSION_FILE_PATTERN.matcher((versionFile = Files.readSymbolicLink(current)).getFileName().toString())).matches() && (foundVersion = Long.valueOf(m.group(2)).longValue()) != version) {
                LOG.error("{} does not match the version file so fix the version file", (Object)current);
                try (PrintWriter restoreWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.versionFilePath.toFile(), false)));){
                    restoreWriter.println(foundVersion);
                }
                version = foundVersion;
            }
            long finalVersion = version;
            LOG.debug("Looking to clean up after {} in {}", (Object)this.getKey(), (Object)this.baseDir);
            try (DirectoryStream ds = this.fsOps.newDirectoryStream(this.baseDir, path -> {
                Matcher m = VERSION_FILE_PATTERN.matcher(path.getFileName().toString());
                if (m.matches()) {
                    long foundVersion = Long.valueOf(m.group(2));
                    return m.group(1).equals(baseName) && foundVersion != finalVersion;
                }
                return false;
            });){
                for (Path p : ds) {
                    LOG.info("Cleaning up old localized resource file {}", (Object)p);
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        FileUtils.deleteDirectory((File)p.toFile());
                        continue;
                    }
                    this.fsOps.deleteIfExists(p.toFile());
                }
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("Nothing to cleanup with baseDir {} even though we expected there to be something there", (Object)this.baseDir);
        }
    }

    @Override
    public void completelyRemove() throws IOException {
        Path fileWithVersion = this.getFilePathWithVersion();
        Path currentSymLink = this.getCurrentSymlinkPath();
        if (this.shouldUncompress) {
            if (Files.exists(fileWithVersion, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)fileWithVersion.toFile());
            }
        } else {
            Files.deleteIfExists(fileWithVersion);
        }
        Files.deleteIfExists(currentSymLink);
        Files.deleteIfExists(this.versionFilePath);
    }

    @Override
    public long getSizeOnDisk() {
        return this.size;
    }

    @Override
    public boolean isFullyDownloaded() {
        return Files.exists(this.getFilePathWithVersion(), new LinkOption[0]) && Files.exists(this.getCurrentSymlinkPath(), new LinkOption[0]) && Files.exists(this.versionFilePath, new LinkOption[0]);
    }

    public boolean equals(Object other) {
        if (other instanceof LocalizedResource) {
            LocalizedResource l = (LocalizedResource)other;
            return this.getKey().equals(l.getKey()) && this.shouldUncompress == l.shouldUncompress && this.baseDir.equals(l.baseDir);
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode() + Boolean.hashCode(this.shouldUncompress) + this.baseDir.hashCode();
    }

    public String toString() {
        return this.user + ":" + this.getKey();
    }
}

