/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.OnlyLatestExecutor;
import org.apache.storm.daemon.supervisor.SlotMetrics;
import org.apache.storm.daemon.supervisor.TimerDecoratedAssignment;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.localizer.AsyncLocalizer;
import org.apache.storm.localizer.BlobChangingCallback;
import org.apache.storm.localizer.GoodToGo;
import org.apache.storm.localizer.LocallyCachedBlob;
import org.apache.storm.metricstore.WorkerMetricsProcessor;
import org.apache.storm.scheduler.ISupervisor;
import org.apache.storm.utils.EnumUtil;
import org.apache.storm.utils.EquivalenceUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slot
extends Thread
implements AutoCloseable,
BlobChangingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private static final long ONE_SEC_IN_NANO = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private final AtomicReference<LocalAssignment> newAssignment = new AtomicReference();
    private final AtomicReference<Set<TopoProfileAction>> profiling = new AtomicReference(new HashSet());
    private final BlockingQueue<BlobChanging> changingBlobs = new LinkedBlockingQueue<BlobChanging>();
    private final StaticState staticState;
    private final IStormClusterState clusterState;
    private final AtomicReference<Map<Long, LocalAssignment>> cachedCurrentAssignments;
    private final OnlyLatestExecutor<Integer> metricsExec;
    private volatile boolean done = false;
    private volatile DynamicState dynamicState;

    public Slot(AsyncLocalizer localizer, Map<String, Object> conf, ContainerLauncher containerLauncher, String host, int port, LocalState localState, IStormClusterState clusterState, ISupervisor supervisor, AtomicReference<Map<Long, LocalAssignment>> cachedCurrentAssignments, OnlyLatestExecutor<Integer> metricsExec, WorkerMetricsProcessor metricsProcessor, SlotMetrics slotMetrics) throws Exception {
        super("SLOT_" + port);
        this.metricsExec = metricsExec;
        this.cachedCurrentAssignments = cachedCurrentAssignments;
        this.clusterState = clusterState;
        this.staticState = new StaticState(localizer, ObjectReader.getInt((Object)conf.get("supervisor.worker.timeout.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.worker.start.timeout.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.worker.shutdown.sleep.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.monitor.frequency.secs")) * 1000, containerLauncher, host, port, supervisor, localState, this, metricsExec, metricsProcessor, slotMetrics);
        LocalAssignment currentAssignment = null;
        Container container = null;
        LocalAssignment newAssignment = null;
        Map assignments = localState.getLocalAssignmentsMap();
        if (assignments != null && (currentAssignment = (LocalAssignment)assignments.get(port)) != null) {
            try {
                if (ClientSupervisorUtils.doRequiredTopoFilesExist(conf, (String)currentAssignment.get_topology_id())) {
                    container = containerLauncher.recoverContainer(port, currentAssignment, localState);
                } else {
                    currentAssignment = null;
                }
            }
            catch (ContainerRecoveryException e) {
                currentAssignment = null;
            }
            newAssignment = currentAssignment;
        }
        this.setNewAssignment(newAssignment);
        this.dynamicState = new DynamicState(currentAssignment, container, this.newAssignment.get(), slotMetrics);
        if (MachineState.RUNNING == this.dynamicState.state) {
            this.staticState.localizer.recoverRunningTopology(currentAssignment, port, this);
            this.saveNewAssignment(currentAssignment);
        }
        LOG.info("SLOT {}:{} Starting in state {} - assignment {}", new Object[]{this.staticState.host, this.staticState.port, this.dynamicState.state, this.dynamicState.currentAssignment});
    }

    private static DynamicState updateAssignmentIfNeeded(DynamicState dynamicState) {
        assert (EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment));
        if (dynamicState.newAssignment != null && !dynamicState.newAssignment.equals(dynamicState.currentAssignment)) {
            dynamicState = dynamicState.withCurrentAssignment(dynamicState.container, dynamicState.newAssignment);
        }
        return dynamicState;
    }

    @VisibleForTesting
    static boolean forSameTopology(LocalAssignment a, LocalAssignment b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.get_topology_id().equals(b.get_topology_id());
    }

    static DynamicState stateMachineStep(DynamicState dynamicState, StaticState staticState) throws Exception {
        LOG.debug("STATE {}", (Object)dynamicState.state);
        switch (dynamicState.state) {
            case EMPTY: {
                return Slot.handleEmpty(dynamicState, staticState);
            }
            case RUNNING: {
                return Slot.handleRunning(dynamicState, staticState);
            }
            case WAITING_FOR_WORKER_START: {
                return Slot.handleWaitingForWorkerStart(dynamicState, staticState);
            }
            case KILL_BLOB_UPDATE: {
                return Slot.handleKillBlobUpdate(dynamicState, staticState);
            }
            case KILL_AND_RELAUNCH: {
                return Slot.handleKillAndRelaunch(dynamicState, staticState);
            }
            case KILL: {
                return Slot.handleKill(dynamicState, staticState);
            }
            case WAITING_FOR_BLOB_LOCALIZATION: {
                return Slot.handleWaitingForBlobLocalization(dynamicState, staticState);
            }
            case WAITING_FOR_BLOB_UPDATE: {
                return Slot.handleWaitingForBlobUpdate(dynamicState, staticState);
            }
        }
        throw new IllegalStateException("Code not ready to handle a state of " + (Object)((Object)dynamicState.state));
    }

    private static DynamicState prepareForNewAssignmentNoWorkersRunning(DynamicState dynamicState, StaticState staticState) throws IOException {
        assert (dynamicState.container == null);
        assert (dynamicState.currentAssignment == null);
        dynamicState = Slot.drainAllChangingBlobs(dynamicState);
        if (dynamicState.newAssignment == null) {
            return dynamicState.withState(MachineState.EMPTY);
        }
        CompletableFuture<Void> pendingDownload = staticState.localizer.requestDownloadTopologyBlobs(dynamicState.newAssignment, staticState.port, staticState.changingCallback);
        return dynamicState.withPendingLocalization(dynamicState.newAssignment, pendingDownload).withState(MachineState.WAITING_FOR_BLOB_LOCALIZATION);
    }

    private static DynamicState killContainerFor(KillReason reason, DynamicState dynamicState, StaticState staticState) throws Exception {
        DynamicState next;
        assert (dynamicState.container != null);
        Boolean isDead = dynamicState.container.areAllProcessesDead();
        if (!isDead.booleanValue()) {
            if (reason == KillReason.ASSIGNMENT_CHANGED || reason == KillReason.BLOB_CHANGED) {
                staticState.supervisor.killedWorker(staticState.port);
            }
            dynamicState.container.kill();
        }
        staticState.slotMetrics.numWorkersKilledFor.get((Object)reason).mark();
        switch (reason) {
            case ASSIGNMENT_CHANGED: {
                CompletableFuture<Void> pendingDownload = null;
                if (dynamicState.newAssignment != null) {
                    pendingDownload = staticState.localizer.requestDownloadTopologyBlobs(dynamicState.newAssignment, staticState.port, staticState.changingCallback);
                }
                next = dynamicState.withState(MachineState.KILL).withPendingLocalization(dynamicState.newAssignment, pendingDownload);
                break;
            }
            case BLOB_CHANGED: {
                next = dynamicState.withState(MachineState.KILL_BLOB_UPDATE);
                break;
            }
            case PROCESS_EXIT: 
            case MEMORY_VIOLATION: 
            case HB_TIMEOUT: 
            case HB_NULL: {
                HashSet<TopoProfileAction> mod = new HashSet<TopoProfileAction>(dynamicState.profileActions);
                mod.addAll(dynamicState.pendingStopProfileActions);
                next = dynamicState.withState(MachineState.KILL_AND_RELAUNCH).withProfileActions(mod, Collections.emptySet());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown reason for killing a container");
            }
        }
        if (!isDead.booleanValue()) {
            Time.sleep((long)staticState.killSleepMs);
        }
        return next;
    }

    private static DynamicState cleanupCurrentContainer(DynamicState dynamicState, StaticState staticState, MachineState nextState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.container.areAllProcessesDead());
        dynamicState.container.cleanUp();
        dynamicState.cancelPendingBlobs();
        staticState.localizer.releaseSlotFor(dynamicState.currentAssignment, staticState.port);
        DynamicState ret = dynamicState.withCurrentAssignment(null, null);
        if (nextState != null) {
            ret = ret.withState(nextState);
        }
        return ret;
    }

    private static DynamicState drainAllChangingBlobs(DynamicState dynamicState) {
        assert (dynamicState.container == null);
        if (!dynamicState.changingBlobs.isEmpty()) {
            for (BlobChanging rc : dynamicState.changingBlobs) {
                rc.latch.countDown();
            }
            dynamicState = dynamicState.withChangingBlobs(Collections.emptySet());
        }
        dynamicState.cancelPendingBlobs();
        if (!dynamicState.pendingChangingBlobs.isEmpty()) {
            dynamicState = dynamicState.withPendingChangingBlobs(Collections.emptySet(), null);
        }
        return dynamicState;
    }

    private static DynamicState informChangedBlobs(DynamicState dynamicState, LocalAssignment assignment) {
        assert (dynamicState.container == null);
        assert (dynamicState.changingBlobs.stream().allMatch(cr -> Slot.forSameTopology(((BlobChanging)cr).assignment, assignment)));
        HashSet<Future<Void>> futures = new HashSet<Future<Void>>(dynamicState.changingBlobs.size());
        if (Slot.forSameTopology(dynamicState.pendingChangingBlobsAssignment, assignment)) {
            futures.addAll(dynamicState.pendingChangingBlobs);
        }
        for (BlobChanging rc : dynamicState.changingBlobs) {
            futures.add(rc.latch.countDown());
        }
        LOG.debug("found changing blobs {} moving them to pending...", dynamicState.changingBlobs);
        return dynamicState.withChangingBlobs(Collections.emptySet()).withPendingChangingBlobs(futures, assignment);
    }

    private static DynamicState filterChangingBlobsFor(DynamicState dynamicState, LocalAssignment assignment) {
        if (dynamicState.changingBlobs.isEmpty()) {
            return dynamicState;
        }
        HashSet<BlobChanging> savedBlobs = new HashSet<BlobChanging>(dynamicState.changingBlobs.size());
        for (BlobChanging rc : dynamicState.changingBlobs) {
            if (Slot.forSameTopology(assignment, rc.assignment)) {
                savedBlobs.add(rc);
                continue;
            }
            rc.latch.countDown();
        }
        return dynamicState.withChangingBlobs(savedBlobs);
    }

    private static DynamicState handleWaitingForBlobLocalization(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.pendingLocalization != null);
        assert (dynamicState.pendingDownload != null);
        assert (dynamicState.container == null);
        assert (dynamicState.currentAssignment == null);
        try {
            dynamicState = Slot.filterChangingBlobsFor(dynamicState, dynamicState.pendingLocalization);
            if (!dynamicState.changingBlobs.isEmpty()) {
                dynamicState = Slot.informChangedBlobs(dynamicState, dynamicState.pendingLocalization);
            }
            if (!EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.pendingLocalization)) {
                dynamicState.cancelPendingBlobs();
                staticState.localizer.releaseSlotFor(dynamicState.pendingLocalization, staticState.port);
                return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState.withPendingLocalization(null, null), staticState);
            }
            dynamicState.pendingDownload.get(1000L, TimeUnit.MILLISECONDS);
            if (!dynamicState.pendingChangingBlobs.isEmpty()) {
                LOG.info("There are pending changes, waiting for them to finish before launching container...");
                return dynamicState.withState(MachineState.WAITING_FOR_BLOB_UPDATE).withPendingLocalization(null, null);
            }
            staticState.slotMetrics.numWorkersLaunched.mark();
            Container c = staticState.containerLauncher.launchContainer(staticState.port, dynamicState.pendingLocalization, staticState.localState);
            return dynamicState.withCurrentAssignment(c, dynamicState.pendingLocalization).withState(MachineState.WAITING_FOR_WORKER_START).withPendingLocalization(null, null);
        }
        catch (TimeoutException e) {
            return dynamicState;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuthorizationException) {
                LOG.error("{}", (Object)((AuthorizationException)e.getCause()).get_msg());
            } else if (e.getCause() instanceof KeyNotFoundException) {
                LOG.error("{}", (Object)((KeyNotFoundException)e.getCause()).get_msg());
            } else {
                LOG.error("{}", (Object)e.getCause().getMessage());
            }
            dynamicState.cancelPendingBlobs();
            staticState.localizer.releaseSlotFor(dynamicState.pendingLocalization, staticState.port);
            Time.sleepSecs((long)3L);
            return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState.withPendingLocalization(null, null), staticState);
        }
    }

    private static DynamicState handleWaitingForBlobUpdate(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container == null);
        assert (dynamicState.pendingChangingBlobsAssignment != null);
        assert (!dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingDownload == null);
        assert (dynamicState.pendingLocalization == null);
        if (!EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            LOG.info("SLOT {}: Assignment Changed from {} to {}", new Object[]{staticState.port, dynamicState.currentAssignment, dynamicState.newAssignment});
            dynamicState.cancelPendingBlobs();
            if (dynamicState.currentAssignment != null) {
                staticState.localizer.releaseSlotFor(dynamicState.currentAssignment, staticState.port);
            }
            staticState.localizer.releaseSlotFor(dynamicState.pendingChangingBlobsAssignment, staticState.port);
            return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState.withCurrentAssignment(null, null), staticState);
        }
        dynamicState = Slot.filterChangingBlobsFor(dynamicState, dynamicState.pendingChangingBlobsAssignment);
        if (!dynamicState.changingBlobs.isEmpty()) {
            dynamicState = Slot.informChangedBlobs(dynamicState, dynamicState.pendingChangingBlobsAssignment);
        }
        long start = Time.nanoTime();
        try {
            for (Future<Void> pending : dynamicState.pendingChangingBlobs) {
                long now = Time.nanoTime();
                long timeLeft = ONE_SEC_IN_NANO - (now - start);
                if (timeLeft <= 0L) {
                    throw new TimeoutException();
                }
                pending.get(timeLeft, TimeUnit.NANOSECONDS);
            }
            Container c = staticState.containerLauncher.launchContainer(staticState.port, dynamicState.pendingChangingBlobsAssignment, staticState.localState);
            return dynamicState.withCurrentAssignment(c, dynamicState.pendingChangingBlobsAssignment).withState(MachineState.WAITING_FOR_WORKER_START).withPendingChangingBlobs(Collections.emptySet(), null);
        }
        catch (TimeoutException ex) {
            return dynamicState;
        }
    }

    private static DynamicState handleKill(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        if (dynamicState.container.areAllProcessesDead()) {
            LOG.info("SLOT {} all processes are dead...", (Object)staticState.port);
            return Slot.cleanupCurrentContainer(dynamicState, staticState, dynamicState.pendingLocalization == null ? MachineState.EMPTY : MachineState.WAITING_FOR_BLOB_LOCALIZATION);
        }
        LOG.info("SLOT {} force kill and wait...", (Object)staticState.port);
        dynamicState.container.forceKill();
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState;
    }

    private static DynamicState handleKillAndRelaunch(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        assert (dynamicState.pendingLocalization == null);
        assert (dynamicState.pendingDownload == null);
        if (dynamicState.container.areAllProcessesDead()) {
            if (EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
                dynamicState.container.cleanUpForRestart();
                dynamicState.container.relaunch();
                return dynamicState.withState(MachineState.WAITING_FOR_WORKER_START);
            }
            return Slot.prepareForNewAssignmentNoWorkersRunning(Slot.cleanupCurrentContainer(dynamicState, staticState, null), staticState);
        }
        if (Time.currentTimeMillis() - dynamicState.startTime > 120000L) {
            throw new RuntimeException("Not all processes in " + dynamicState.container + " exited after 120 seconds");
        }
        dynamicState.container.forceKill();
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState;
    }

    private static DynamicState handleKillBlobUpdate(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        assert (dynamicState.pendingDownload == null);
        assert (dynamicState.pendingLocalization == null);
        dynamicState = Slot.filterChangingBlobsFor(dynamicState, dynamicState.currentAssignment);
        if (dynamicState.container.areAllProcessesDead()) {
            if (EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
                dynamicState.container.cleanUp();
                dynamicState = dynamicState.withCurrentAssignment(null, dynamicState.currentAssignment);
                return Slot.informChangedBlobs(dynamicState, dynamicState.currentAssignment).withState(MachineState.WAITING_FOR_BLOB_UPDATE);
            }
            return Slot.prepareForNewAssignmentNoWorkersRunning(Slot.cleanupCurrentContainer(dynamicState, staticState, null), staticState);
        }
        if (Time.currentTimeMillis() - dynamicState.startTime > 120000L) {
            throw new RuntimeException("Not all processes in " + dynamicState.container + " exited after 120 seconds");
        }
        dynamicState.container.forceKill();
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState;
    }

    private static DynamicState handleWaitingForWorkerStart(DynamicState dynamicState, StaticState staticState) throws Exception {
        long hbFirstTimeoutMs;
        long hbTimeoutMs;
        long hbAgeMs;
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        assert (dynamicState.pendingDownload == null);
        assert (dynamicState.pendingLocalization == null);
        LSWorkerHeartbeat hb = dynamicState.container.readHeartbeat();
        if (hb != null && (hbAgeMs = (long)((Time.currentTimeSecs() - hb.get_time_secs()) * 1000)) <= (hbTimeoutMs = Slot.getHbTimeoutMs(staticState, dynamicState))) {
            return dynamicState.withState(MachineState.RUNNING);
        }
        if (!EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            LOG.info("SLOT {}: Assignment Changed from {} to {}", new Object[]{staticState.port, dynamicState.currentAssignment, dynamicState.newAssignment});
            return Slot.killContainerFor(KillReason.ASSIGNMENT_CHANGED, dynamicState, staticState);
        }
        dynamicState = Slot.updateAssignmentIfNeeded(dynamicState);
        long timeDiffms = Time.currentTimeMillis() - dynamicState.startTime;
        if (timeDiffms > (hbFirstTimeoutMs = Slot.getFirstHbTimeoutMs(staticState, dynamicState))) {
            staticState.slotMetrics.numWorkerStartTimedOut.mark();
            LOG.warn("SLOT {}: Container {} failed to launch in {} ms.", new Object[]{staticState.port, dynamicState.container, hbFirstTimeoutMs});
            return Slot.killContainerFor(KillReason.HB_TIMEOUT, dynamicState, staticState);
        }
        dynamicState = Slot.filterChangingBlobsFor(dynamicState, dynamicState.currentAssignment);
        if (!dynamicState.changingBlobs.isEmpty()) {
            return Slot.killContainerFor(KillReason.BLOB_CHANGED, dynamicState, staticState);
        }
        Time.sleep((long)1000L);
        return dynamicState;
    }

    private static DynamicState handleRunning(DynamicState dynamicState, StaticState staticState) throws Exception {
        long hbTimeoutMs;
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        assert (dynamicState.pendingDownload == null);
        assert (dynamicState.pendingLocalization == null);
        if (!EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            LOG.info("SLOT {}: Assignment Changed from {} to {}", new Object[]{staticState.port, dynamicState.currentAssignment, dynamicState.newAssignment});
            return Slot.killContainerFor(KillReason.ASSIGNMENT_CHANGED, dynamicState, staticState);
        }
        dynamicState = Slot.updateAssignmentIfNeeded(dynamicState);
        dynamicState = Slot.filterChangingBlobsFor(dynamicState, dynamicState.currentAssignment);
        if (!dynamicState.changingBlobs.isEmpty()) {
            return Slot.killContainerFor(KillReason.BLOB_CHANGED, dynamicState, staticState);
        }
        if (dynamicState.container.didMainProcessExit()) {
            LOG.warn("SLOT {}: main process has exited for topology: {}", (Object)staticState.port, (Object)dynamicState.currentAssignment.get_topology_id());
            return Slot.killContainerFor(KillReason.PROCESS_EXIT, dynamicState, staticState);
        }
        if (dynamicState.container.isMemoryLimitViolated(dynamicState.currentAssignment)) {
            LOG.warn("SLOT {}: violated memory limits for topology: {}", (Object)staticState.port, (Object)dynamicState.currentAssignment.get_topology_id());
            return Slot.killContainerFor(KillReason.MEMORY_VIOLATION, dynamicState, staticState);
        }
        LSWorkerHeartbeat hb = dynamicState.container.readHeartbeat();
        if (hb == null) {
            LOG.warn("SLOT {}: HB returned as null for topology: {}", (Object)staticState.port, (Object)dynamicState.currentAssignment.get_topology_id());
            return Slot.killContainerFor(KillReason.HB_NULL, dynamicState, staticState);
        }
        long timeDiffMs = (Time.currentTimeSecs() - hb.get_time_secs()) * 1000;
        if (timeDiffMs > (hbTimeoutMs = Slot.getHbTimeoutMs(staticState, dynamicState))) {
            LOG.warn("SLOT {}: HB is too old {} > {} for topology: {}", new Object[]{staticState.port, timeDiffMs, hbTimeoutMs, dynamicState.currentAssignment.get_topology_id()});
            return Slot.killContainerFor(KillReason.HB_TIMEOUT, dynamicState, staticState);
        }
        if (!dynamicState.profileActions.isEmpty()) {
            HashSet<TopoProfileAction> mod = new HashSet<TopoProfileAction>(dynamicState.profileActions);
            HashSet<TopoProfileAction> modPending = new HashSet<TopoProfileAction>(dynamicState.pendingStopProfileActions);
            Iterator<TopoProfileAction> iter = mod.iterator();
            while (iter.hasNext()) {
                TopoProfileAction action = iter.next();
                if (!action.topoId.equals(dynamicState.currentAssignment.get_topology_id())) {
                    iter.remove();
                    LOG.warn("Dropping {} wrong topology is running", (Object)action);
                    continue;
                }
                if (modPending.contains(action)) {
                    boolean isTimeForStop;
                    boolean bl = isTimeForStop = Time.currentTimeMillis() > action.request.get_time_stamp();
                    if (isTimeForStop) {
                        if (dynamicState.container.runProfiling(action.request, true)) {
                            LOG.debug("Stopped {} action finished", (Object)action);
                            iter.remove();
                            modPending.remove(action);
                            continue;
                        }
                        LOG.warn("Stopping {} failed, will be retried", (Object)action);
                        continue;
                    }
                    LOG.debug("Still pending {} now: {}", (Object)action, (Object)Time.currentTimeMillis());
                    continue;
                }
                if (action.request.get_action() == ProfileAction.JPROFILE_STOP) {
                    if (dynamicState.container.runProfiling(action.request, false)) {
                        modPending.add(action);
                        LOG.debug("Started {} now: {}", (Object)action, (Object)Time.currentTimeMillis());
                        continue;
                    }
                    LOG.warn("Starting {} failed, will be retried", (Object)action);
                    continue;
                }
                if (dynamicState.container.runProfiling(action.request, false)) {
                    LOG.debug("Started {} action finished", (Object)action);
                    iter.remove();
                    continue;
                }
                LOG.warn("Starting {} failed, will be retried", (Object)action);
            }
            dynamicState = dynamicState.withProfileActions(mod, modPending);
        }
        dynamicState.container.processMetrics(staticState.metricsExec, staticState.metricsProcessor);
        Time.sleep((long)staticState.monitorFreqMs);
        return dynamicState;
    }

    static DynamicState handleEmpty(DynamicState dynamicState, StaticState staticState) throws InterruptedException, IOException {
        assert (dynamicState.currentAssignment == null);
        assert (dynamicState.container == null);
        assert (dynamicState.pendingChangingBlobs.isEmpty());
        assert (dynamicState.pendingChangingBlobsAssignment == null);
        assert (dynamicState.pendingDownload == null);
        assert (dynamicState.pendingLocalization == null);
        if (!EquivalenceUtils.areLocalAssignmentsEquivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState, staticState);
        }
        dynamicState = Slot.updateAssignmentIfNeeded(dynamicState);
        if (dynamicState.profileActions != null && !dynamicState.profileActions.isEmpty()) {
            LOG.warn("Dropping {} no topology is running", dynamicState.profileActions);
            dynamicState = dynamicState.withProfileActions(Collections.emptySet(), Collections.emptySet());
        }
        dynamicState = Slot.drainAllChangingBlobs(dynamicState);
        Time.sleep((long)1000L);
        return dynamicState;
    }

    MachineState getMachineState() {
        return this.dynamicState.state;
    }

    private static long getHbTimeoutMs(StaticState staticState, DynamicState dynamicState) {
        long hbTimeoutMs = staticState.hbTimeoutMs;
        Map<String, Object> topoConf = dynamicState.container.topoConf;
        if (topoConf != null && topoConf.containsKey("topology.worker.timeout.secs")) {
            long topoHbTimeoutMs = ObjectReader.getInt((Object)topoConf.get("topology.worker.timeout.secs")) * 1000;
            hbTimeoutMs = topoHbTimeoutMs = Math.max(topoHbTimeoutMs, hbTimeoutMs);
        }
        return hbTimeoutMs;
    }

    private static long getFirstHbTimeoutMs(StaticState staticState, DynamicState dynamicState) {
        return Math.max(Slot.getHbTimeoutMs(staticState, dynamicState), staticState.firstHbTimeoutMs);
    }

    public final void setNewAssignment(LocalAssignment newAssignment) {
        this.newAssignment.set(newAssignment == null ? null : new TimerDecoratedAssignment(newAssignment, this.staticState.slotMetrics.workerLaunchDuration));
    }

    @Override
    public void blobChanging(LocalAssignment assignment, int port, LocallyCachedBlob blob, GoodToGo go) {
        assert (port == this.staticState.port) : "got a callback that is not for us " + port + " != " + this.staticState.port;
        try {
            this.changingBlobs.put(new BlobChanging(assignment, blob, go.getLatch()));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("This should not have happened, but it did (the queue is unbounded)", e);
        }
    }

    public void addProfilerActions(Set<TopoProfileAction> actions) {
        if (actions != null) {
            HashSet<TopoProfileAction> newActions;
            Set<TopoProfileAction> orig;
            do {
                orig = this.profiling.get();
                newActions = new HashSet<TopoProfileAction>(orig);
                newActions.addAll(actions);
            } while (!this.profiling.compareAndSet(orig, newActions));
            return;
        }
    }

    public String getWorkerId() {
        String workerId = null;
        Container c = this.dynamicState.container;
        if (c != null) {
            workerId = c.getWorkerId();
        }
        return workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewAssignment(LocalAssignment assignment) {
        LocalState localState = this.staticState.localState;
        synchronized (localState) {
            HashMap<Integer, LocalAssignment> assignments = this.staticState.localState.getLocalAssignmentsMap();
            if (assignments == null) {
                assignments = new HashMap<Integer, LocalAssignment>();
            }
            if (assignment == null) {
                assignments.remove(this.staticState.port);
            } else {
                assignments.put(this.staticState.port, assignment);
            }
            this.staticState.localState.setLocalAssignmentsMap(assignments);
        }
        HashMap<Long, LocalAssignment> update = null;
        Map<Long, LocalAssignment> orig = null;
        do {
            Long lport = new Long(this.staticState.port);
            orig = this.cachedCurrentAssignments.get();
            update = new HashMap<Long, LocalAssignment>(orig);
            if (assignment == null) {
                update.remove(lport);
                continue;
            }
            update.put(lport, assignment);
        } while (!this.cachedCurrentAssignments.compareAndSet(orig, update));
    }

    @Override
    public void run() {
        block12: {
            try {
                while (!this.done) {
                    HashSet<TopoProfileAction> copy;
                    Set<TopoProfileAction> orig;
                    HashSet<TopoProfileAction> origProfileActions = new HashSet<TopoProfileAction>((Collection)this.profiling.get());
                    Set<BlobChanging> changingResourcesToHandle = this.dynamicState.changingBlobs;
                    if (!this.changingBlobs.isEmpty()) {
                        changingResourcesToHandle = new HashSet<BlobChanging>(changingResourcesToHandle);
                        this.changingBlobs.drainTo(changingResourcesToHandle);
                        Iterator<BlobChanging> it = changingResourcesToHandle.iterator();
                        while (it.hasNext()) {
                            BlobChanging rc = it.next();
                            if (Slot.forSameTopology(rc.assignment, this.dynamicState.currentAssignment) || Slot.forSameTopology(rc.assignment, this.dynamicState.newAssignment)) continue;
                            rc.latch.countDown();
                            it.remove();
                        }
                    }
                    DynamicState nextState = Slot.stateMachineStep(this.dynamicState.withNewAssignment(this.newAssignment.get()).withProfileActions(origProfileActions, this.dynamicState.pendingStopProfileActions).withChangingBlobs(changingResourcesToHandle), this.staticState);
                    if (LOG.isDebugEnabled() || this.dynamicState.state != nextState.state) {
                        LOG.info("STATE {} -> {}", (Object)this.dynamicState, (Object)nextState);
                    }
                    if (nextState.currentAssignment != null && !nextState.currentAssignment.equals(this.dynamicState.currentAssignment) || this.dynamicState.currentAssignment != null && !this.dynamicState.currentAssignment.equals(nextState.currentAssignment)) {
                        LOG.info("SLOT {}: Changing current assignment from {} to {}", new Object[]{this.staticState.port, this.dynamicState.currentAssignment, nextState.currentAssignment});
                        this.saveNewAssignment(nextState.currentAssignment);
                    }
                    if (EquivalenceUtils.areLocalAssignmentsEquivalent(nextState.newAssignment, nextState.currentAssignment) && nextState.currentAssignment != null && nextState.currentAssignment.get_owner() == null && nextState.newAssignment != null && nextState.newAssignment.get_owner() != null) {
                        LOG.info("Updating assignment to save owner {}", (Object)nextState.newAssignment.get_owner());
                        this.saveNewAssignment(nextState.newAssignment);
                        nextState = nextState.withCurrentAssignment(nextState.container, nextState.newAssignment);
                    }
                    HashSet<TopoProfileAction> removed = new HashSet<TopoProfileAction>(origProfileActions);
                    removed.removeAll(this.dynamicState.profileActions);
                    removed.removeAll(this.dynamicState.pendingStopProfileActions);
                    for (TopoProfileAction action : removed) {
                        try {
                            this.clusterState.deleteTopologyProfileRequests(action.topoId, action.request);
                        }
                        catch (Exception e) {
                            LOG.error("Error trying to remove profiling request, it will be retried", (Throwable)e);
                        }
                    }
                    do {
                        orig = this.profiling.get();
                        copy = new HashSet<TopoProfileAction>(orig);
                        copy.removeAll(removed);
                    } while (!this.profiling.compareAndSet(orig, copy));
                    this.dynamicState = nextState;
                }
            }
            catch (Throwable e) {
                if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, (Throwable)e)) break block12;
                LOG.error("Error when processing event", e);
                Utils.exitProcess((int)20, (String)"Error when processing an event");
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.done = true;
        this.interrupt();
        this.join();
    }

    static class BlobChanging {
        private final LocalAssignment assignment;
        private final LocallyCachedBlob blob;
        private final GoodToGo.GoodToGoLatch latch;

        BlobChanging(LocalAssignment assignment, LocallyCachedBlob blob, GoodToGo.GoodToGoLatch latch) {
            this.assignment = assignment;
            this.blob = blob;
            this.latch = latch;
        }

        public String toString() {
            return "BLOB CHANGING " + this.blob + " " + this.assignment;
        }
    }

    static class TopoProfileAction {
        public final String topoId;
        public final ProfileRequest request;

        TopoProfileAction(String topoId, ProfileRequest request) {
            this.topoId = topoId;
            this.request = request;
        }

        public int hashCode() {
            return 37 * this.topoId.hashCode() + this.request.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof TopoProfileAction)) {
                return false;
            }
            TopoProfileAction o = (TopoProfileAction)other;
            return this.topoId.equals(o.topoId) && this.request.equals(o.request);
        }

        public String toString() {
            return "{ " + this.topoId + ": " + this.request + " }";
        }
    }

    static class DynamicState {
        public final MachineState state;
        public final LocalAssignment newAssignment;
        public final LocalAssignment currentAssignment;
        public final LocalAssignment pendingLocalization;
        public final Container container;
        public final Future<Void> pendingDownload;
        public final Set<TopoProfileAction> profileActions;
        public final Set<TopoProfileAction> pendingStopProfileActions;
        public final Set<BlobChanging> changingBlobs;
        public final LocalAssignment pendingChangingBlobsAssignment;
        public final Set<Future<Void>> pendingChangingBlobs;
        public final long startTime;
        private final SlotMetrics slotMetrics;

        DynamicState(LocalAssignment currentAssignment, Container container, LocalAssignment newAssignment, SlotMetrics slotMetrics) {
            this.currentAssignment = currentAssignment;
            this.container = container;
            if (currentAssignment == null ^ container == null) {
                throw new IllegalArgumentException("Container and current assignment must both be null, or neither can be null");
            }
            this.state = currentAssignment == null ? MachineState.EMPTY : MachineState.RUNNING;
            slotMetrics.transitionIntoState.get((Object)this.state).mark();
            this.startTime = Time.currentTimeMillis();
            this.newAssignment = newAssignment;
            this.pendingLocalization = null;
            this.pendingDownload = null;
            this.profileActions = Collections.emptySet();
            this.pendingStopProfileActions = Collections.emptySet();
            this.changingBlobs = Collections.emptySet();
            this.pendingChangingBlobsAssignment = null;
            this.pendingChangingBlobs = Collections.emptySet();
            this.slotMetrics = slotMetrics;
        }

        DynamicState(MachineState state, LocalAssignment newAssignment, Container container, LocalAssignment currentAssignment, LocalAssignment pendingLocalization, long startTime, Future<Void> pendingDownload, Set<TopoProfileAction> profileActions, Set<TopoProfileAction> pendingStopProfileActions, Set<BlobChanging> changingBlobs, Set<Future<Void>> pendingChangingBlobs, LocalAssignment pendingChaningBlobsAssignment, SlotMetrics slotMetrics) {
            assert (pendingChangingBlobs != null);
            assert (pendingChangingBlobs.isEmpty() == (pendingChaningBlobsAssignment == null));
            this.state = state;
            this.newAssignment = newAssignment;
            this.currentAssignment = currentAssignment;
            this.container = container;
            this.pendingLocalization = pendingLocalization;
            this.startTime = startTime;
            this.pendingDownload = pendingDownload;
            this.profileActions = profileActions;
            this.pendingStopProfileActions = pendingStopProfileActions;
            this.changingBlobs = changingBlobs;
            this.pendingChangingBlobs = pendingChangingBlobs;
            this.pendingChangingBlobsAssignment = pendingChaningBlobsAssignment;
            this.slotMetrics = slotMetrics;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((Object)this.state);
            sb.append(" msInState: ");
            sb.append(Time.currentTimeMillis() - this.startTime);
            if (this.container != null) {
                sb.append(" ");
                sb.append(this.container);
            }
            return sb.toString();
        }

        public DynamicState withNewAssignment(LocalAssignment newAssignment) {
            return new DynamicState(this.state, newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions, this.changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withPendingLocalization(LocalAssignment pendingLocalization, Future<Void> pendingDownload) {
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, pendingLocalization, this.startTime, pendingDownload, this.profileActions, this.pendingStopProfileActions, this.changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withPendingLocalization(Future<Void> pendingDownload) {
            return this.withPendingLocalization(this.pendingLocalization, pendingDownload);
        }

        public DynamicState withState(MachineState state) {
            long newStartTime = Time.currentTimeMillis();
            this.slotMetrics.timeSpentInState.get((Object)this.state).update(newStartTime - this.startTime, TimeUnit.MILLISECONDS);
            this.slotMetrics.transitionIntoState.get((Object)state).mark();
            LocalAssignment assignment = this.currentAssignment;
            if (MachineState.RUNNING != this.state && MachineState.RUNNING == state && this.currentAssignment instanceof TimerDecoratedAssignment) {
                ((TimerDecoratedAssignment)assignment).stopTiming();
                assignment = new LocalAssignment(this.currentAssignment);
            }
            return new DynamicState(state, this.newAssignment, this.container, assignment, this.pendingLocalization, newStartTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions, this.changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withCurrentAssignment(Container container, LocalAssignment currentAssignment) {
            return new DynamicState(this.state, this.newAssignment, container, currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions, this.changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withProfileActions(Set<TopoProfileAction> profileActions, Set<TopoProfileAction> pendingStopProfileActions) {
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, profileActions, pendingStopProfileActions, this.changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withChangingBlobs(Set<BlobChanging> changingBlobs) {
            if (changingBlobs == this.changingBlobs) {
                return this;
            }
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions, changingBlobs, this.pendingChangingBlobs, this.pendingChangingBlobsAssignment, this.slotMetrics);
        }

        public DynamicState withPendingChangingBlobs(Set<Future<Void>> pendingChangingBlobs, LocalAssignment pendingChangingBlobsAssignment) {
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions, this.changingBlobs, pendingChangingBlobs, pendingChangingBlobsAssignment, this.slotMetrics);
        }

        private void cancelPendingBlobs() {
            for (Future<Void> future : this.pendingChangingBlobs) {
                if (future.isDone()) continue;
                LOG.info("Canceling download of {}", future);
                future.cancel(true);
            }
        }
    }

    static class StaticState {
        public final AsyncLocalizer localizer;
        public final long hbTimeoutMs;
        public final long firstHbTimeoutMs;
        public final long killSleepMs;
        public final long monitorFreqMs;
        public final ContainerLauncher containerLauncher;
        public final int port;
        public final String host;
        public final ISupervisor supervisor;
        public final LocalState localState;
        public final BlobChangingCallback changingCallback;
        public final OnlyLatestExecutor<Integer> metricsExec;
        public final WorkerMetricsProcessor metricsProcessor;
        public final SlotMetrics slotMetrics;

        StaticState(AsyncLocalizer localizer, long hbTimeoutMs, long firstHbTimeoutMs, long killSleepMs, long monitorFreqMs, ContainerLauncher containerLauncher, String host, int port, ISupervisor supervisor, LocalState localState, BlobChangingCallback changingCallback, OnlyLatestExecutor<Integer> metricsExec, WorkerMetricsProcessor metricsProcessor, SlotMetrics slotMetrics) {
            this.localizer = localizer;
            this.hbTimeoutMs = hbTimeoutMs;
            this.firstHbTimeoutMs = firstHbTimeoutMs;
            this.containerLauncher = containerLauncher;
            this.killSleepMs = killSleepMs;
            this.monitorFreqMs = monitorFreqMs;
            this.host = host;
            this.port = port;
            this.supervisor = supervisor;
            this.localState = localState;
            this.changingCallback = changingCallback;
            this.metricsExec = metricsExec;
            this.metricsProcessor = metricsProcessor;
            this.slotMetrics = slotMetrics;
        }
    }

    static enum MachineState {
        EMPTY,
        RUNNING,
        WAITING_FOR_WORKER_START,
        KILL_AND_RELAUNCH,
        KILL,
        KILL_BLOB_UPDATE,
        WAITING_FOR_BLOB_LOCALIZATION,
        WAITING_FOR_BLOB_UPDATE;


        public String toString() {
            return EnumUtil.toMetricName(this);
        }
    }

    static enum KillReason {
        ASSIGNMENT_CHANGED,
        BLOB_CHANGED,
        PROCESS_EXIT,
        MEMORY_VIOLATION,
        HB_TIMEOUT,
        HB_NULL;


        public String toString() {
            return EnumUtil.toMetricName(this);
        }
    }
}

