/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.OnlyLatestExecutor;
import org.apache.storm.daemon.supervisor.Slot;
import org.apache.storm.daemon.supervisor.SlotMetrics;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.daemon.supervisor.UniFunc;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.localizer.AsyncLocalizer;
import org.apache.storm.metricstore.MetricStoreConfig;
import org.apache.storm.metricstore.WorkerMetricsProcessor;
import org.apache.storm.scheduler.ISupervisor;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadClusterState
implements Runnable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ReadClusterState.class);
    private static final long ERROR_MILLIS = 60000L;
    public static final UniFunc<Slot> DEFAULT_ON_ERROR_TIMEOUT = slot -> {
        throw new IllegalStateException("It took over 60000ms to shut down slot " + slot);
    };
    public static final UniFunc<Slot> THREAD_DUMP_ON_ERROR = slot -> {
        LOG.warn("Shutdown of slot {} appears to be stuck\n{}", slot, (Object)Utils.threadDump());
        DEFAULT_ON_ERROR_TIMEOUT.call((Slot)slot);
    };
    private static final long WARN_MILLIS = 1000L;
    public static final BiConsumer<Slot, Long> DEFAULT_ON_WARN_TIMEOUT = (slot, elapsedTimeMs) -> LOG.warn("It has taken {}ms so far and {} is still not shut down.", elapsedTimeMs, slot);
    private final Map<String, Object> superConf;
    private final IStormClusterState stormClusterState;
    private final Map<Integer, Slot> slots = new HashMap<Integer, Slot>();
    private final AtomicInteger readRetry = new AtomicInteger(0);
    private final String assignmentId;
    private final int supervisorPort;
    private final ISupervisor supervisor;
    private final AsyncLocalizer localizer;
    private final ContainerLauncher launcher;
    private final String host;
    private final LocalState localState;
    private final AtomicReference<Map<Long, LocalAssignment>> cachedAssignments;
    private final OnlyLatestExecutor<Integer> metricsExec;
    private final SlotMetrics slotMetrics;
    private WorkerMetricsProcessor metricsProcessor;

    public ReadClusterState(Supervisor supervisor) throws Exception {
        this.superConf = supervisor.getConf();
        this.stormClusterState = supervisor.getStormClusterState();
        this.assignmentId = supervisor.getAssignmentId();
        this.supervisorPort = supervisor.getThriftServerPort();
        this.supervisor = supervisor.getiSupervisor();
        this.localizer = supervisor.getAsyncLocalizer();
        this.host = supervisor.getHostName();
        this.localState = supervisor.getLocalState();
        this.cachedAssignments = supervisor.getCurrAssignment();
        this.metricsExec = new OnlyLatestExecutor(supervisor.getHeartbeatExecutor());
        this.slotMetrics = supervisor.getSlotMetrics();
        this.launcher = ContainerLauncher.make(this.superConf, this.assignmentId, this.supervisorPort, supervisor.getSharedContext(), supervisor.getMetricsRegistry(), supervisor.getContainerMemoryTracker(), supervisor.getSupervisorThriftInterface());
        this.metricsProcessor = null;
        try {
            this.metricsProcessor = MetricStoreConfig.configureMetricProcessor(this.superConf);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize metric processor", (Throwable)e);
        }
        List<Integer> ports = SupervisorUtils.getSlotsPorts(this.superConf);
        for (Integer n : ports) {
            this.slots.put(n, this.mkSlot(n));
        }
        try {
            Collection<String> detachedRunningWorkers = SupervisorUtils.supervisorWorkerIds(this.superConf);
            for (Slot slot : this.slots.values()) {
                String workerId = slot.getWorkerId();
                if (workerId == null) continue;
                detachedRunningWorkers.remove(workerId);
            }
            if (!detachedRunningWorkers.isEmpty()) {
                LOG.info("Killing detached workers {}", detachedRunningWorkers);
                supervisor.killWorkers(detachedRunningWorkers, this.launcher);
            }
        }
        catch (Exception e) {
            LOG.warn("Error trying to clean up old workers", (Throwable)e);
        }
        for (Slot slot : this.slots.values()) {
            slot.start();
        }
    }

    private Slot mkSlot(int port) throws Exception {
        return new Slot(this.localizer, this.superConf, this.launcher, this.host, port, this.localState, this.stormClusterState, this.supervisor, this.cachedAssignments, this.metricsExec, this.metricsProcessor, this.slotMetrics);
    }

    @Override
    public synchronized void run() {
        try {
            List stormIds = this.stormClusterState.assignments(null);
            Map<String, Assignment> assignmentsSnapshot = this.getAssignmentsSnapshot(this.stormClusterState);
            Map<Integer, LocalAssignment> allAssignments = this.readAssignments(assignmentsSnapshot);
            if (allAssignments == null) {
                return;
            }
            Map<String, List<ProfileRequest>> topoIdToProfilerActions = this.getProfileActions(this.stormClusterState, stormIds);
            HashSet<Integer> assignedPorts = new HashSet<Integer>();
            LOG.debug("Synchronizing supervisor");
            LOG.debug("All assignment: {}", allAssignments);
            LOG.debug("Topology Ids -> Profiler Actions {}", topoIdToProfilerActions);
            for (Integer port : allAssignments.keySet()) {
                if (!this.supervisor.confirmAssigned(port)) continue;
                assignedPorts.add(port);
            }
            HashSet<Integer> allPorts = new HashSet<Integer>(assignedPorts);
            this.supervisor.assigned(allPorts);
            allPorts.addAll(this.slots.keySet());
            HashMap<Integer, HashSet<Slot.TopoProfileAction>> filtered = new HashMap<Integer, HashSet<Slot.TopoProfileAction>>();
            for (Map.Entry<String, List<ProfileRequest>> entry : topoIdToProfilerActions.entrySet()) {
                String topoId = entry.getKey();
                if (entry.getValue() == null) continue;
                for (ProfileRequest req : entry.getValue()) {
                    NodeInfo ni = req.get_nodeInfo();
                    if (!this.host.equals(ni.get_node())) continue;
                    Long port = (Long)ni.get_port().iterator().next();
                    HashSet<Slot.TopoProfileAction> actions = (HashSet<Slot.TopoProfileAction>)filtered.get(port.intValue());
                    if (actions == null) {
                        actions = new HashSet<Slot.TopoProfileAction>();
                        filtered.put(port.intValue(), actions);
                    }
                    actions.add(new Slot.TopoProfileAction(topoId, req));
                }
            }
            for (Integer port : allPorts) {
                Slot slot = this.slots.get(port);
                if (slot == null) {
                    slot = this.mkSlot(port);
                    this.slots.put(port, slot);
                    slot.start();
                }
                slot.setNewAssignment(allAssignments.get(port));
                slot.addProfilerActions((Set)filtered.get(port));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to Sync Supervisor", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Assignment> getAssignmentsSnapshot(IStormClusterState stormClusterState) throws Exception {
        return stormClusterState.assignmentsInfo();
    }

    protected Map<String, List<ProfileRequest>> getProfileActions(IStormClusterState stormClusterState, List<String> stormIds) throws Exception {
        HashMap<String, List<ProfileRequest>> ret = new HashMap<String, List<ProfileRequest>>();
        for (String stormId : stormIds) {
            List profileRequests = stormClusterState.getTopologyProfileRequests(stormId);
            ret.put(stormId, profileRequests);
        }
        return ret;
    }

    protected Map<Integer, LocalAssignment> readAssignments(Map<String, Assignment> assignmentsSnapshot) {
        try {
            HashMap<Integer, LocalAssignment> portLocalAssignment = new HashMap<Integer, LocalAssignment>();
            for (Map.Entry<String, Assignment> assignEntry : assignmentsSnapshot.entrySet()) {
                String topoId = assignEntry.getKey();
                Assignment assignment = assignEntry.getValue();
                Map<Integer, LocalAssignment> portTasks = this.readMyExecutors(topoId, this.assignmentId, assignment);
                for (Map.Entry<Integer, LocalAssignment> entry : portTasks.entrySet()) {
                    Integer port = entry.getKey();
                    LocalAssignment la = entry.getValue();
                    if (!portLocalAssignment.containsKey(port)) {
                        portLocalAssignment.put(port, la);
                        continue;
                    }
                    throw new RuntimeException("Should not have multiple topologies assigned to one port " + port + " " + la + " " + portLocalAssignment);
                }
            }
            this.readRetry.set(0);
            return portLocalAssignment;
        }
        catch (RuntimeException e) {
            if (this.readRetry.get() > 2) {
                throw e;
            }
            this.readRetry.addAndGet(1);
            LOG.warn("{} : retrying {} of 3", (Object)e.getMessage(), (Object)this.readRetry.get());
            return null;
        }
    }

    protected Map<Integer, LocalAssignment> readMyExecutors(String topoId, String assignmentId, Assignment assignment) {
        Map executorNodePort;
        Double d;
        HashMap<Integer, LocalAssignment> portTasks = new HashMap<Integer, LocalAssignment>();
        HashMap slotsResources = new HashMap();
        Map nodeInfoWorkerResourcesMap = assignment.get_worker_resources();
        if (nodeInfoWorkerResourcesMap != null) {
            for (Map.Entry entry : nodeInfoWorkerResourcesMap.entrySet()) {
                if (!((NodeInfo)entry.getKey()).get_node().startsWith(assignmentId)) continue;
                Set ports = ((NodeInfo)entry.getKey()).get_port();
                for (Long port : ports) {
                    slotsResources.put(port, entry.getValue());
                }
            }
        }
        boolean hasShared = false;
        double amountShared = 0.0;
        if (assignment.is_set_total_shared_off_heap() && (d = (Double)assignment.get_total_shared_off_heap().get(assignmentId)) != null) {
            amountShared = d;
            hasShared = true;
        }
        if ((executorNodePort = assignment.get_executor_node_port()) != null) {
            for (Map.Entry entry : executorNodePort.entrySet()) {
                if (!((NodeInfo)entry.getValue()).get_node().startsWith(assignmentId)) continue;
                for (Long port : ((NodeInfo)entry.getValue()).get_port()) {
                    LocalAssignment localAssignment = (LocalAssignment)portTasks.get(port.intValue());
                    if (localAssignment == null) {
                        ArrayList executors = new ArrayList();
                        localAssignment = new LocalAssignment(topoId, executors);
                        if (slotsResources.containsKey(port)) {
                            localAssignment.set_resources((WorkerResources)slotsResources.get(port));
                        }
                        if (hasShared) {
                            localAssignment.set_total_node_shared(amountShared);
                        }
                        if (assignment.is_set_owner()) {
                            localAssignment.set_owner(assignment.get_owner());
                        }
                        portTasks.put(port.intValue(), localAssignment);
                    }
                    List executorInfoList = localAssignment.get_executors();
                    executorInfoList.add(new ExecutorInfo(((Long)((List)entry.getKey()).get(0)).intValue(), ((Long)((List)entry.getKey()).get(((List)entry.getKey()).size() - 1)).intValue()));
                }
            }
        }
        return portTasks;
    }

    public synchronized void shutdownAllWorkers(BiConsumer<Slot, Long> onWarnTimeout, UniFunc<Slot> onErrorTimeout) {
        for (Slot slot : this.slots.values()) {
            LOG.info("Setting {} assignment to null", (Object)slot);
            slot.setNewAssignment(null);
        }
        if (onWarnTimeout == null) {
            onWarnTimeout = DEFAULT_ON_WARN_TIMEOUT;
        }
        if (onErrorTimeout == null) {
            onErrorTimeout = DEFAULT_ON_ERROR_TIMEOUT;
        }
        long startTime = Time.currentTimeMillis();
        Exception exp = null;
        for (Slot slot : this.slots.values()) {
            LOG.info("Waiting for {} to be EMPTY, currently {}", (Object)slot, (Object)slot.getMachineState());
            try {
                while (slot.getMachineState() != Slot.MachineState.EMPTY) {
                    long timeSpentMillis = Time.currentTimeMillis() - startTime;
                    if (timeSpentMillis > 60000L) {
                        onErrorTimeout.call(slot);
                    }
                    if (timeSpentMillis > 1000L) {
                        onWarnTimeout.accept(slot, timeSpentMillis);
                    }
                    if (Time.isSimulating()) {
                        Time.advanceTime((long)100L);
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                LOG.error("Error trying to shutdown workers in {}", (Object)slot, (Object)e);
                exp = e;
            }
        }
        if (exp != null) {
            if (exp instanceof RuntimeException) {
                throw (RuntimeException)exp;
            }
            throw new RuntimeException(exp);
        }
    }

    @Override
    public void close() {
        for (Slot slot : this.slots.values()) {
            try {
                slot.close();
            }
            catch (Exception e) {
                LOG.error("Error trying to shutdown {}", (Object)slot, (Object)e);
            }
        }
    }
}

