/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.nimbus;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.DerivativeGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.storm.StormTimer;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.KeySequenceNumber;
import org.apache.storm.blobstore.LocalFsBlobStore;
import org.apache.storm.callback.DefaultWatcherCallBack;
import org.apache.storm.callback.WatcherCallBack;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.container.oci.OciUtils;
import org.apache.storm.daemon.DaemonCommon;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.nimbus.HeartbeatCache;
import org.apache.storm.daemon.nimbus.TimedWritableByteChannel;
import org.apache.storm.daemon.nimbus.TopoCache;
import org.apache.storm.daemon.nimbus.TopologyActions;
import org.apache.storm.daemon.nimbus.TopologyResources;
import org.apache.storm.daemon.nimbus.TopologyStateTransition;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.generated.AlreadyAliveException;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.BeginDownloadResult;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.BoltAggregateStats;
import org.apache.storm.generated.ClusterSummary;
import org.apache.storm.generated.CommonAggregateStats;
import org.apache.storm.generated.ComponentAggregateStats;
import org.apache.storm.generated.ComponentPageInfo;
import org.apache.storm.generated.ComponentType;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.DebugOptions;
import org.apache.storm.generated.ErrorInfo;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.ExecutorSummary;
import org.apache.storm.generated.GetInfoOptions;
import org.apache.storm.generated.IllegalStateException;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.LSTopoHistory;
import org.apache.storm.generated.ListBlobsResult;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.LogLevel;
import org.apache.storm.generated.LogLevelAction;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.NotAliveException;
import org.apache.storm.generated.NumErrorsChoice;
import org.apache.storm.generated.OwnerResourceSummary;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.RebalanceOptions;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.generated.SpecificAggregateStats;
import org.apache.storm.generated.SpoutAggregateStats;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormBase;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.SubmitOptions;
import org.apache.storm.generated.SupervisorAssignments;
import org.apache.storm.generated.SupervisorInfo;
import org.apache.storm.generated.SupervisorPageInfo;
import org.apache.storm.generated.SupervisorSummary;
import org.apache.storm.generated.SupervisorWorkerHeartbeat;
import org.apache.storm.generated.SupervisorWorkerHeartbeats;
import org.apache.storm.generated.TopologyActionOptions;
import org.apache.storm.generated.TopologyHistoryInfo;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.generated.TopologyInitialStatus;
import org.apache.storm.generated.TopologyPageInfo;
import org.apache.storm.generated.TopologyStatus;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.generated.WorkerMetricPoint;
import org.apache.storm.generated.WorkerMetrics;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.generated.WorkerSummary;
import org.apache.storm.logging.ThriftAccessLogger;
import org.apache.storm.metric.ClusterMetricsConsumerExecutor;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.metric.api.DataPoint;
import org.apache.storm.metric.api.IClusterMetricsConsumer;
import org.apache.storm.metricstore.AggLevel;
import org.apache.storm.metricstore.MetricStore;
import org.apache.storm.metricstore.MetricStoreConfig;
import org.apache.storm.nimbus.AssignmentDistributionService;
import org.apache.storm.nimbus.DefaultTopologyValidator;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.ITopologyActionNotifierPlugin;
import org.apache.storm.nimbus.ITopologyValidator;
import org.apache.storm.nimbus.IWorkerHeartbeatsRecoveryStrategy;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.nimbus.WorkerHeartbeatsRecoveryStrategyFactory;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.DefaultScheduler;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.INimbus;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SchedulerAssignmentImpl;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.SupervisorResources;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.blacklist.BlacklistScheduler;
import org.apache.storm.scheduler.multitenant.MultitenantScheduler;
import org.apache.storm.scheduler.resource.ResourceAwareScheduler;
import org.apache.storm.scheduler.resource.ResourceUtils;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.normalization.ResourceMetrics;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.NimbusPrincipal;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.ThriftServer;
import org.apache.storm.security.auth.workertoken.WorkerTokenManager;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.base.Strings;
import org.apache.storm.shade.com.google.common.collect.ImmutableMap;
import org.apache.storm.shade.com.google.common.collect.MapDifference;
import org.apache.storm.shade.com.google.common.collect.Maps;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.stats.ClientStatsUtil;
import org.apache.storm.stats.StatsUtil;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TProcessor;
import org.apache.storm.utils.BufferInputStream;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.ServerConfigUtils;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.SimpleVersion;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.TimeCacheMap;
import org.apache.storm.utils.TupleUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.VersionInfo;
import org.apache.storm.utils.WrappedAlreadyAliveException;
import org.apache.storm.utils.WrappedAuthorizationException;
import org.apache.storm.utils.WrappedIllegalStateException;
import org.apache.storm.utils.WrappedInvalidTopologyException;
import org.apache.storm.utils.WrappedNotAliveException;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.zookeeper.AclEnforcement;
import org.apache.storm.zookeeper.ClientZookeeper;
import org.apache.storm.zookeeper.Zookeeper;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nimbus
implements Nimbus.Iface,
Shutdownable,
DaemonCommon {
    @VisibleForTesting
    public static final List<ACL> ZK_ACLS = Arrays.asList((ACL)ZooDefs.Ids.CREATOR_ALL_ACL.get(0));
    public static final SimpleVersion MIN_VERSION_SUPPORT_RPC_HEARTBEAT = new SimpleVersion("2.0.0");
    private static final Logger LOG = LoggerFactory.getLogger(Nimbus.class);
    private final Meter submitTopologyWithOptsCalls;
    private final Meter submitTopologyCalls;
    private final Meter killTopologyWithOptsCalls;
    private final Meter killTopologyCalls;
    private final Meter rebalanceCalls;
    private final Meter activateCalls;
    private final Meter deactivateCalls;
    private final Meter debugCalls;
    private final Meter setWorkerProfilerCalls;
    private final Meter getComponentPendingProfileActionsCalls;
    private final Meter setLogConfigCalls;
    private final Meter uploadNewCredentialsCalls;
    private final Meter beginFileUploadCalls;
    private final Meter uploadChunkCalls;
    private final Meter finishFileUploadCalls;
    private final Meter downloadChunkCalls;
    private final Meter getNimbusConfCalls;
    private final Meter getLogConfigCalls;
    private final Meter getTopologyConfCalls;
    private final Meter getTopologyCalls;
    private final Meter getUserTopologyCalls;
    private final Meter getClusterInfoCalls;
    private final Meter getTopologySummariesCalls;
    private final Meter getTopologySummaryCalls;
    private final Meter getTopologySummaryByNameCalls;
    private final Meter getLeaderCalls;
    private final Meter isTopologyNameAllowedCalls;
    private final Meter getTopologyInfoWithOptsCalls;
    private final Meter getTopologyInfoCalls;
    private final Meter getTopologyInfoByNameCalls;
    private final Meter getTopologyInfoByNameWithOptsCalls;
    private final Meter getTopologyPageInfoCalls;
    private final Meter getSupervisorPageInfoCalls;
    private final Meter getComponentPageInfoCalls;
    private final Meter getOwnerResourceSummariesCalls;
    private final Meter shutdownCalls;
    private final Meter processWorkerMetricsCalls;
    private final Meter mkAssignmentsErrors;
    private final Meter sendAssignmentExceptions;
    private final Timer fileUploadDuration;
    private final Timer schedulingDuration;
    private final Histogram numAddedExecPerScheduling;
    private final Histogram numAddedSlotPerScheduling;
    private final Histogram numRemovedExecPerScheduling;
    private final Histogram numRemovedSlotPerScheduling;
    private final Histogram numNetExecIncreasePerScheduling;
    private final Histogram numNetSlotIncreasePerScheduling;
    private static final String STORM_VERSION = VersionInfo.getVersion();
    public static final Subject NIMBUS_SUBJECT = new Subject();
    private static final TopologyStateTransition NOOP_TRANSITION;
    private static final TopologyStateTransition INACTIVE_TRANSITION;
    private static final TopologyStateTransition ACTIVE_TRANSITION;
    private static final TopologyStateTransition REMOVE_TRANSITION;
    private static final TopologyStateTransition DO_REBALANCE_TRANSITION;
    private static final TopologyStateTransition KILL_TRANSITION;
    private static final TopologyStateTransition REBALANCE_TRANSITION;
    private static final TopologyStateTransition GAIN_LEADERSHIP_WHEN_KILLED_TRANSITION;
    private static final TopologyStateTransition GAIN_LEADERSHIP_WHEN_REBALANCING_TRANSITION;
    private static final Map<TopologyStatus, Map<TopologyActions, TopologyStateTransition>> TOPO_STATE_TRANSITIONS;
    private static final List<String> EMPTY_STRING_LIST;
    private static final Set<String> EMPTY_STRING_SET;
    private static final RotatingMap<String, Long> topologyCleanupDetected;
    private static long topologyCleanupRotationTime;
    private final Map<String, Object> conf;
    private final NavigableMap<SimpleVersion, List<String>> supervisorClasspaths;
    private final NimbusInfo nimbusHostPortInfo;
    private final INimbus inimbus;
    private final IAuthorizer impersonationAuthorizationHandler;
    private final AtomicLong submittedCount;
    private final IStormClusterState stormClusterState;
    private final Object submitLock = new Object();
    private final Object schedLock = new Object();
    private final Object credUpdateLock = new Object();
    private final HeartbeatCache heartbeatsCache;
    private final AtomicBoolean heartbeatsReadyFlag;
    private final IWorkerHeartbeatsRecoveryStrategy heartbeatsRecoveryStrategy;
    private final TimeCacheMap<String, BufferInputStream> downloaders;
    private final TimeCacheMap<String, WritableByteChannel> uploaders;
    private final BlobStore blobStore;
    private final TopoCache topoCache;
    private final TimeCacheMap<String, BufferInputStream> blobDownloaders;
    private final TimeCacheMap<String, OutputStream> blobUploaders;
    private final TimeCacheMap<String, Iterator<String>> blobListers;
    private final Utils.UptimeComputer uptime;
    private final ITopologyValidator validator;
    private final StormTimer timer;
    private final IScheduler scheduler;
    private final IScheduler underlyingScheduler;
    private final AtomicReference<Long> schedulingStartTimeNs = new AtomicReference<Object>(null);
    private final AtomicLong longestSchedulingTime = new AtomicLong();
    private final ILeaderElector leaderElector;
    private final AssignmentDistributionService assignmentsDistributer;
    private final AtomicReference<Map<String, String>> idToSchedStatus;
    private final AtomicReference<Map<String, SupervisorResources>> nodeIdToResources;
    private final AtomicReference<Map<String, TopologyResources>> idToResources;
    private final AtomicReference<Map<String, Map<WorkerSlot, WorkerResources>>> idToWorkerResources;
    private final Collection<ICredentialsRenewer> credRenewers;
    private final Object topologyHistoryLock;
    private final LocalState topologyHistoryState;
    private final Collection<INimbusCredentialPlugin> nimbusAutocredPlugins;
    private final ITopologyActionNotifierPlugin nimbusTopologyActionNotifier;
    private final List<ClusterMetricsConsumerExecutor> clusterConsumerExceutors;
    private final IGroupMappingServiceProvider groupMapper;
    private final IPrincipalToLocal principalToLocal;
    private final StormMetricsRegistry metricsRegistry;
    private final ResourceMetrics resourceMetrics;
    private final ClusterSummaryMetricSet clusterMetricSet;
    private MetricStore metricsStore;
    private IAuthorizer authorizationHandler;
    private final CuratorFramework zkClient;
    private AtomicReference<Map<String, Set<List<Integer>>>> idToExecutors;
    private WorkerTokenManager workerTokenManager;
    private boolean wasLeader = false;

    public static List<ACL> getNimbusAcls(Map<String, Object> conf) {
        List<ACL> acls = null;
        if (Utils.isZkAuthenticationConfiguredStormServer(conf)) {
            acls = ZK_ACLS;
        }
        return acls;
    }

    public Nimbus(Map<String, Object> conf, INimbus inimbus, StormMetricsRegistry metricsRegistry) throws Exception {
        this(conf, inimbus, null, null, null, null, null, metricsRegistry);
    }

    public Nimbus(Map<String, Object> conf, INimbus inimbus, IStormClusterState stormClusterState, NimbusInfo hostPortInfo, BlobStore blobStore, ILeaderElector leaderElector, IGroupMappingServiceProvider groupMapper, StormMetricsRegistry metricsRegistry) throws Exception {
        this(conf, inimbus, stormClusterState, hostPortInfo, blobStore, null, leaderElector, groupMapper, metricsRegistry);
    }

    public Nimbus(Map<String, Object> conf, INimbus inimbus, IStormClusterState stormClusterState, NimbusInfo hostPortInfo, BlobStore blobStore, TopoCache topoCache, ILeaderElector leaderElector, IGroupMappingServiceProvider groupMapper, StormMetricsRegistry metricsRegistry) throws Exception {
        this.conf = conf;
        this.metricsRegistry = metricsRegistry;
        this.resourceMetrics = new ResourceMetrics(metricsRegistry);
        this.submitTopologyWithOptsCalls = metricsRegistry.registerMeter("nimbus:num-submitTopologyWithOpts-calls");
        this.submitTopologyCalls = metricsRegistry.registerMeter("nimbus:num-submitTopology-calls");
        this.killTopologyWithOptsCalls = metricsRegistry.registerMeter("nimbus:num-killTopologyWithOpts-calls");
        this.killTopologyCalls = metricsRegistry.registerMeter("nimbus:num-killTopology-calls");
        this.rebalanceCalls = metricsRegistry.registerMeter("nimbus:num-rebalance-calls");
        this.activateCalls = metricsRegistry.registerMeter("nimbus:num-activate-calls");
        this.deactivateCalls = metricsRegistry.registerMeter("nimbus:num-deactivate-calls");
        this.debugCalls = metricsRegistry.registerMeter("nimbus:num-debug-calls");
        this.setWorkerProfilerCalls = metricsRegistry.registerMeter("nimbus:num-setWorkerProfiler-calls");
        this.getComponentPendingProfileActionsCalls = metricsRegistry.registerMeter("nimbus:num-getComponentPendingProfileActions-calls");
        this.setLogConfigCalls = metricsRegistry.registerMeter("nimbus:num-setLogConfig-calls");
        this.uploadNewCredentialsCalls = metricsRegistry.registerMeter("nimbus:num-uploadNewCredentials-calls");
        this.beginFileUploadCalls = metricsRegistry.registerMeter("nimbus:num-beginFileUpload-calls");
        this.uploadChunkCalls = metricsRegistry.registerMeter("nimbus:num-uploadChunk-calls");
        this.finishFileUploadCalls = metricsRegistry.registerMeter("nimbus:num-finishFileUpload-calls");
        this.downloadChunkCalls = metricsRegistry.registerMeter("nimbus:num-downloadChunk-calls");
        this.getNimbusConfCalls = metricsRegistry.registerMeter("nimbus:num-getNimbusConf-calls");
        this.getLogConfigCalls = metricsRegistry.registerMeter("nimbus:num-getLogConfig-calls");
        this.getTopologyConfCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyConf-calls");
        this.getTopologyCalls = metricsRegistry.registerMeter("nimbus:num-getTopology-calls");
        this.getUserTopologyCalls = metricsRegistry.registerMeter("nimbus:num-getUserTopology-calls");
        this.getClusterInfoCalls = metricsRegistry.registerMeter("nimbus:num-getClusterInfo-calls");
        this.getTopologySummariesCalls = metricsRegistry.registerMeter("nimbus:num-getTopologySummaries-calls");
        this.getTopologySummaryCalls = metricsRegistry.registerMeter("nimbus:num-getTopologySummary-calls");
        this.getTopologySummaryByNameCalls = metricsRegistry.registerMeter("nimbus:num-getTopologySummaryByName-calls");
        this.getLeaderCalls = metricsRegistry.registerMeter("nimbus:num-getLeader-calls");
        this.isTopologyNameAllowedCalls = metricsRegistry.registerMeter("nimbus:num-isTopologyNameAllowed-calls");
        this.getTopologyInfoWithOptsCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyInfoWithOpts-calls");
        this.getTopologyInfoCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyInfo-calls");
        this.getTopologyInfoByNameCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyInfoByName-calls");
        this.getTopologyInfoByNameWithOptsCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyInfoByNameWithOpts-calls");
        this.getTopologyPageInfoCalls = metricsRegistry.registerMeter("nimbus:num-getTopologyPageInfo-calls");
        this.getSupervisorPageInfoCalls = metricsRegistry.registerMeter("nimbus:num-getSupervisorPageInfo-calls");
        this.getComponentPageInfoCalls = metricsRegistry.registerMeter("nimbus:num-getComponentPageInfo-calls");
        this.getOwnerResourceSummariesCalls = metricsRegistry.registerMeter("nimbus:num-getOwnerResourceSummaries-calls");
        this.shutdownCalls = metricsRegistry.registerMeter("nimbus:num-shutdown-calls");
        this.processWorkerMetricsCalls = metricsRegistry.registerMeter("nimbus:process-worker-metric-calls");
        this.mkAssignmentsErrors = metricsRegistry.registerMeter("nimbus:mkAssignments-Errors");
        this.sendAssignmentExceptions = metricsRegistry.registerMeter("nimbus:num-send-assignment-exceptions");
        this.fileUploadDuration = metricsRegistry.registerTimer("nimbus:files-upload-duration-ms");
        this.schedulingDuration = metricsRegistry.registerTimer("nimbus:topology-scheduling-duration-ms");
        this.numAddedExecPerScheduling = metricsRegistry.registerHistogram("nimbus:num-added-executors-per-scheduling");
        this.numAddedSlotPerScheduling = metricsRegistry.registerHistogram("nimbus:num-added-slots-per-scheduling");
        this.numRemovedExecPerScheduling = metricsRegistry.registerHistogram("nimbus:num-removed-executors-per-scheduling");
        this.numRemovedSlotPerScheduling = metricsRegistry.registerHistogram("nimbus:num-removed-slots-per-scheduling");
        this.numNetExecIncreasePerScheduling = metricsRegistry.registerHistogram("nimbus:num-net-executors-increase-per-scheduling");
        this.numNetSlotIncreasePerScheduling = metricsRegistry.registerHistogram("nimbus:num-net-slots-increase-per-scheduling");
        this.metricsStore = null;
        try {
            this.metricsStore = MetricStoreConfig.configure(conf, metricsRegistry);
        }
        catch (Exception e2) {
            LOG.error("Failed to initialize metric store", (Throwable)e2);
        }
        if (hostPortInfo == null) {
            hostPortInfo = NimbusInfo.fromConf(conf);
        }
        this.nimbusHostPortInfo = hostPortInfo;
        if (inimbus != null) {
            inimbus.prepare(conf, ServerConfigUtils.masterInimbusDir(conf));
        }
        this.inimbus = inimbus;
        this.authorizationHandler = StormCommon.mkAuthorizationHandler((String)((String)conf.get("nimbus.authorizer")), conf);
        this.impersonationAuthorizationHandler = StormCommon.mkAuthorizationHandler((String)((String)conf.get("nimbus.impersonation.authorizer")), conf);
        this.submittedCount = new AtomicLong(0L);
        if (stormClusterState == null) {
            stormClusterState = Nimbus.makeStormClusterState(conf);
        }
        this.stormClusterState = stormClusterState;
        this.heartbeatsCache = new HeartbeatCache();
        this.heartbeatsReadyFlag = new AtomicBoolean(false);
        this.heartbeatsRecoveryStrategy = WorkerHeartbeatsRecoveryStrategyFactory.getStrategy(conf);
        this.downloaders = Nimbus.fileCacheMap(conf);
        this.uploaders = Nimbus.fileCacheMap(conf);
        this.blobDownloaders = Nimbus.makeBlobCacheMap(conf);
        this.blobUploaders = Nimbus.makeBlobCacheMap(conf);
        this.blobListers = Nimbus.makeBlobListCacheMap(conf);
        this.uptime = Utils.makeUptimeComputer();
        this.validator = (ITopologyValidator)ReflectionUtils.newInstance((String)((String)conf.getOrDefault("nimbus.topology.validator", DefaultTopologyValidator.class.getName())));
        this.timer = new StormTimer(null, (t, e) -> {
            LOG.error("Error while processing event", e);
            Utils.exitProcess((int)20, (String)"Error while processing event");
        });
        this.underlyingScheduler = Nimbus.makeScheduler(conf, inimbus);
        this.scheduler = Nimbus.wrapAsBlacklistScheduler(conf, this.underlyingScheduler, metricsRegistry);
        this.zkClient = Nimbus.makeZKClient(conf);
        this.idToExecutors = new AtomicReference(new HashMap());
        if (blobStore == null) {
            blobStore = ServerUtils.getNimbusBlobStore(conf, this.nimbusHostPortInfo, null);
        }
        this.blobStore = blobStore;
        if (topoCache == null) {
            topoCache = new TopoCache(blobStore, conf);
        }
        if (leaderElector == null) {
            leaderElector = Zookeeper.zkLeaderElector(conf, this.zkClient, blobStore, topoCache, stormClusterState, Nimbus.getNimbusAcls(conf), metricsRegistry);
        }
        this.leaderElector = leaderElector;
        this.blobStore.setLeaderElector(this.leaderElector);
        this.topoCache = topoCache;
        this.assignmentsDistributer = AssignmentDistributionService.getInstance(conf, this.scheduler);
        this.idToSchedStatus = new AtomicReference(new HashMap());
        this.nodeIdToResources = new AtomicReference(new HashMap());
        this.idToResources = new AtomicReference(new HashMap());
        this.idToWorkerResources = new AtomicReference(new HashMap());
        this.credRenewers = ClientAuthUtils.getCredentialRenewers(conf);
        this.topologyHistoryLock = new Object();
        this.topologyHistoryState = ServerConfigUtils.nimbusTopoHistoryState(conf);
        this.nimbusAutocredPlugins = ClientAuthUtils.getNimbusAutoCredPlugins(conf);
        this.nimbusTopologyActionNotifier = Nimbus.createTopologyActionNotifier(conf);
        this.clusterConsumerExceutors = Nimbus.makeClusterMetricsConsumerExecutors(conf);
        if (groupMapper == null) {
            groupMapper = ClientAuthUtils.getGroupMappingServiceProviderPlugin(conf);
        }
        this.groupMapper = groupMapper;
        this.principalToLocal = ClientAuthUtils.getPrincipalToLocalPlugin(conf);
        this.supervisorClasspaths = Collections.unmodifiableNavigableMap(Utils.getConfiguredClasspathVersions(conf, EMPTY_STRING_LIST));
        this.clusterMetricSet = new ClusterSummaryMetricSet(metricsRegistry);
    }

    private static StormBase make(TopologyStatus status) {
        StormBase ret = new StormBase();
        ret.set_status(status);
        ret.set_component_executors(Collections.emptyMap());
        ret.set_component_debug(Collections.emptyMap());
        return ret;
    }

    private static <T extends AutoCloseable> TimeCacheMap<String, T> fileCacheMap(Map<String, Object> conf) {
        return new TimeCacheMap(ObjectReader.getInt((Object)conf.get("nimbus.file.copy.expiration.secs"), (Integer)600).intValue(), (id, stream) -> {
            try {
                stream.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <K, V> Map<K, V> mapDiff(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> second) {
        HashMap<K, V> ret = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : second.entrySet()) {
            if (entry.getValue().equals(first.get(entry.getKey()))) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private static IScheduler wrapAsBlacklistScheduler(Map<String, Object> conf, IScheduler scheduler, StormMetricsRegistry metricsRegistry) {
        BlacklistScheduler blacklistWrappedScheduler = new BlacklistScheduler(scheduler);
        blacklistWrappedScheduler.prepare(conf, metricsRegistry);
        return blacklistWrappedScheduler;
    }

    private static IScheduler makeScheduler(Map<String, Object> conf, INimbus inimbus) {
        IScheduler scheduler;
        String schedClass = (String)conf.get("storm.scheduler");
        IScheduler iScheduler = scheduler = inimbus == null ? null : inimbus.getForcedScheduler();
        if (scheduler != null) {
            LOG.info("Using forced scheduler from INimbus {} {}", scheduler.getClass(), (Object)scheduler);
        } else if (schedClass != null) {
            LOG.info("Using custom scheduler: {}", (Object)schedClass);
            scheduler = (IScheduler)ReflectionUtils.newInstance((String)schedClass);
        } else {
            LOG.info("Using default scheduler");
            scheduler = new DefaultScheduler();
        }
        return scheduler;
    }

    private static <T extends AutoCloseable> TimeCacheMap<String, T> makeBlobCacheMap(Map<String, Object> conf) {
        return new TimeCacheMap(ObjectReader.getInt((Object)conf.get("nimbus.blobstore.expiration.secs"), (Integer)600).intValue(), (id, stream) -> {
            try {
                if (stream instanceof AtomicOutputStream) {
                    ((AtomicOutputStream)stream).cancel();
                } else {
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static TimeCacheMap<String, Iterator<String>> makeBlobListCacheMap(Map<String, Object> conf) {
        return new TimeCacheMap(ObjectReader.getInt((Object)conf.get("nimbus.blobstore.expiration.secs"), (Integer)600).intValue());
    }

    private static ITopologyActionNotifierPlugin createTopologyActionNotifier(Map<String, Object> conf) {
        String clazz = (String)conf.get("nimbus.topology.action.notifier.plugin.class");
        ITopologyActionNotifierPlugin ret = null;
        if (clazz != null && !clazz.isEmpty()) {
            ret = (ITopologyActionNotifierPlugin)ReflectionUtils.newInstance((String)clazz);
            try {
                ret.prepare(conf);
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception, Could not initialize {}", (Object)clazz, (Object)e);
                ret = null;
            }
        }
        return ret;
    }

    private static List<ClusterMetricsConsumerExecutor> makeClusterMetricsConsumerExecutors(Map<String, Object> conf) {
        Collection consumers = (Collection)conf.get("storm.cluster.metrics.consumer.register");
        ArrayList<ClusterMetricsConsumerExecutor> ret = new ArrayList<ClusterMetricsConsumerExecutor>();
        if (consumers != null) {
            for (Map consumer : consumers) {
                ret.add(new ClusterMetricsConsumerExecutor((String)consumer.get("class"), consumer.get("argument")));
            }
        }
        return ret;
    }

    private static Subject getSubject() {
        return ReqContext.context().subject();
    }

    static Map<String, Object> readTopoConf(String topoId, TopoCache tc) throws KeyNotFoundException, AuthorizationException, IOException {
        return tc.readTopoConf(topoId, Nimbus.getSubject());
    }

    static List<String> getKeyListFromId(Map<String, Object> conf, String id) {
        ArrayList<String> ret = new ArrayList<String>(3);
        ret.add(ConfigUtils.masterStormCodeKey((String)id));
        ret.add(ConfigUtils.masterStormConfKey((String)id));
        if (!ConfigUtils.isLocalMode(conf)) {
            ret.add(ConfigUtils.masterStormJarKey((String)id));
        }
        return ret;
    }

    public static int getVersionForKey(String key, NimbusInfo nimbusInfo, CuratorFramework zkClient) throws KeyNotFoundException {
        KeySequenceNumber kseq = new KeySequenceNumber(key, nimbusInfo);
        return kseq.getKeySequenceNumber(zkClient);
    }

    private static StormTopology readStormTopology(String topoId, TopoCache tc) throws KeyNotFoundException, AuthorizationException, IOException {
        return tc.readTopology(topoId, Nimbus.getSubject());
    }

    private static Map<String, Object> readTopoConfAsNimbus(String topoId, TopoCache tc) throws KeyNotFoundException, AuthorizationException, IOException {
        return tc.readTopoConf(topoId, NIMBUS_SUBJECT);
    }

    private static StormTopology readStormTopologyAsNimbus(String topoId, TopoCache tc) throws KeyNotFoundException, AuthorizationException, IOException {
        return tc.readTopology(topoId, NIMBUS_SUBJECT);
    }

    private static Map<String, Map<List<Long>, List<Object>>> computeTopoToExecToNodePort(Map<String, SchedulerAssignment> schedAssignments, List<String> assignedTopologyIds) {
        HashMap<String, Map<List<Long>, List<Object>>> ret = new HashMap<String, Map<List<Long>, List<Object>>>();
        for (Map.Entry<String, SchedulerAssignment> schedEntry : schedAssignments.entrySet()) {
            HashMap<List<Long>, List> execToNodePort = new HashMap<List<Long>, List>();
            for (Map.Entry<ExecutorDetails, WorkerSlot> execAndNodePort : schedEntry.getValue().getExecutorToSlot().entrySet()) {
                ExecutorDetails exec = execAndNodePort.getKey();
                WorkerSlot slot = execAndNodePort.getValue();
                execToNodePort.put(exec.toList(), slot.toList());
            }
            ret.put(schedEntry.getKey(), execToNodePort);
        }
        for (String id : assignedTopologyIds) {
            ret.putIfAbsent(id, null);
        }
        return ret;
    }

    private static int numUsedWorkers(SchedulerAssignment assignment) {
        if (assignment == null) {
            return 0;
        }
        return assignment.getSlots().size();
    }

    private static Map<String, Map<WorkerSlot, WorkerResources>> computeTopoToNodePortToResources(Map<String, SchedulerAssignment> schedAssignments) {
        HashMap<String, Map<WorkerSlot, WorkerResources>> ret = new HashMap<String, Map<WorkerSlot, WorkerResources>>();
        for (Map.Entry<String, SchedulerAssignment> schedEntry : schedAssignments.entrySet()) {
            ret.put(schedEntry.getKey(), schedEntry.getValue().getScheduledResources());
        }
        return ret;
    }

    private boolean auditAssignmentChanges(Map<String, Assignment> existingAssignments, Map<String, Assignment> newAssignments) {
        assert (existingAssignments != null && newAssignments != null);
        boolean anyChanged = existingAssignments.isEmpty() ^ newAssignments.isEmpty();
        long numRemovedExec = 0L;
        long numRemovedSlot = 0L;
        long numAddedExec = 0L;
        long numAddedSlot = 0L;
        if (existingAssignments.isEmpty()) {
            for (Map.Entry<String, Assignment> entry : newAssignments.entrySet()) {
                Map execToPort = entry.getValue().get_executor_node_port();
                long count = new HashSet(execToPort.values()).size();
                LOG.info("Assigning {} to {} slots", (Object)entry.getKey(), (Object)count);
                LOG.info("Assign executors: {}", execToPort.keySet());
                numAddedSlot += count;
                numAddedExec += (long)execToPort.size();
            }
        } else if (newAssignments.isEmpty()) {
            for (Map.Entry<String, Assignment> entry : existingAssignments.entrySet()) {
                Map execToPort = entry.getValue().get_executor_node_port();
                long count = new HashSet(execToPort.values()).size();
                LOG.info("Removing {} from {} slots", (Object)entry.getKey(), (Object)count);
                LOG.info("Remove executors: {}", execToPort.keySet());
                numRemovedSlot += count;
                numRemovedExec += (long)execToPort.size();
            }
        } else {
            MapDifference difference = Maps.difference(existingAssignments, newAssignments);
            anyChanged = !difference.areEqual();
            if (anyChanged) {
                long count;
                Map execToPort;
                for (Map.Entry entry : difference.entriesOnlyOnLeft().entrySet()) {
                    execToPort = ((Assignment)entry.getValue()).get_executor_node_port();
                    count = new HashSet(execToPort.values()).size();
                    LOG.info("Removing {} from {} slots", entry.getKey(), (Object)count);
                    LOG.info("Remove executors: {}", execToPort.keySet());
                    numRemovedSlot += count;
                    numRemovedExec += (long)execToPort.size();
                }
                for (Map.Entry entry : difference.entriesOnlyOnRight().entrySet()) {
                    execToPort = ((Assignment)entry.getValue()).get_executor_node_port();
                    count = new HashSet(execToPort.values()).size();
                    LOG.info("Assigning {} to {} slots", entry.getKey(), (Object)count);
                    LOG.info("Assign executors: {}", execToPort.keySet());
                    numAddedSlot += count;
                    numAddedExec += (long)execToPort.size();
                }
                for (Map.Entry entry : difference.entriesDiffering().entrySet()) {
                    Map execToSlot = ((Assignment)((MapDifference.ValueDifference)entry.getValue()).rightValue()).get_executor_node_port();
                    HashSet slots = new HashSet(execToSlot.values());
                    LOG.info("Reassigning {} to {} slots", entry.getKey(), (Object)slots.size());
                    LOG.info("Reassign executors: {}", execToSlot.keySet());
                    Map oldExecToSlot = ((Assignment)((MapDifference.ValueDifference)entry.getValue()).leftValue()).get_executor_node_port();
                    long commonExecCount = 0L;
                    HashSet commonSlots = new HashSet(execToSlot.size());
                    for (Map.Entry execEntry : execToSlot.entrySet()) {
                        if (!((NodeInfo)execEntry.getValue()).equals((NodeInfo)oldExecToSlot.get(execEntry.getKey()))) continue;
                        ++commonExecCount;
                        commonSlots.add(execEntry.getValue());
                    }
                    long commonSlotCount = commonSlots.size();
                    numRemovedSlot += (long)new HashSet(oldExecToSlot.values()).size() - commonSlotCount;
                    numRemovedExec += (long)oldExecToSlot.size() - commonExecCount;
                    numAddedSlot += (long)slots.size() - commonSlotCount;
                    numAddedExec += (long)execToSlot.size() - commonExecCount;
                }
            }
            LOG.debug("{} assignments unchanged: {}", (Object)difference.entriesInCommon().size(), difference.entriesInCommon().keySet());
        }
        this.numAddedExecPerScheduling.update(numAddedExec);
        this.numAddedSlotPerScheduling.update(numAddedSlot);
        this.numRemovedExecPerScheduling.update(numRemovedExec);
        this.numRemovedSlotPerScheduling.update(numRemovedSlot);
        this.numNetExecIncreasePerScheduling.update(numAddedExec - numRemovedExec);
        this.numNetSlotIncreasePerScheduling.update(numAddedSlot - numRemovedSlot);
        if (anyChanged) {
            LOG.info("Fragmentation after scheduling is: {} MB, {} PCore CPUs", (Object)this.fragmentedMemory(), (Object)this.fragmentedCpu());
            this.nodeIdToResources.get().forEach((id, node) -> {
                double availableCpu;
                double availableMem = node.getAvailableMem();
                if (availableMem < 0.0) {
                    LOG.warn("Memory over-scheduled on {}", id, (Object)availableMem);
                }
                if ((availableCpu = node.getAvailableCpu()) < 0.0) {
                    LOG.warn("CPU over-scheduled on {}", id, (Object)availableCpu);
                }
                LOG.info("Node Id: {} Total Mem: {}, Used Mem: {}, Available Mem: {}, Total CPU: {}, Used CPU: {}, Available CPU: {}, fragmented: {}", new Object[]{id, node.getTotalMem(), node.getUsedMem(), availableMem, node.getTotalCpu(), node.getUsedCpu(), availableCpu, this.isFragmented((SupervisorResources)node)});
            });
        }
        return anyChanged;
    }

    private static List<List<Long>> changedExecutors(Map<List<Long>, NodeInfo> map, Map<List<Long>, List<Object>> newExecToNodePort) {
        ArrayList<List> value;
        HashMap tmpSlotAssigned = map == null ? new HashMap() : Utils.reverseMap(map);
        HashMap slotAssigned = new HashMap();
        for (Map.Entry entry : tmpSlotAssigned.entrySet()) {
            NodeInfo ni = (NodeInfo)entry.getKey();
            ArrayList<String> arrayList = new ArrayList<String>(2);
            arrayList.add(ni.get_node());
            arrayList.add((String)ni.get_port_iterator().next());
            value = new ArrayList((Collection)entry.getValue());
            value.sort(Comparator.comparing(a -> (Long)a.get(0)));
            slotAssigned.put(arrayList, value);
        }
        HashMap tmpNewSlotAssigned = newExecToNodePort == null ? new HashMap() : Utils.reverseMap(newExecToNodePort);
        HashMap newSlotAssigned = new HashMap();
        for (Map.Entry entry : tmpNewSlotAssigned.entrySet()) {
            value = new ArrayList<List>((Collection)entry.getValue());
            value.sort(Comparator.comparing(a -> (Long)a.get(0)));
            newSlotAssigned.put(entry.getKey(), value);
        }
        Map diff = Nimbus.mapDiff(slotAssigned, newSlotAssigned);
        ArrayList<List<Long>> arrayList = new ArrayList<List<Long>>();
        for (List val : diff.values()) {
            arrayList.addAll(val);
        }
        return arrayList;
    }

    private static Set<WorkerSlot> newlyAddedSlots(Assignment old, Assignment current) {
        HashSet oldSlots = new HashSet(old.get_executor_node_port().values());
        HashSet niRet = new HashSet(current.get_executor_node_port().values());
        niRet.removeAll(oldSlots);
        HashSet<WorkerSlot> ret = new HashSet<WorkerSlot>();
        for (NodeInfo ni : niRet) {
            ret.add(new WorkerSlot(ni.get_node(), (Number)ni.get_port_iterator().next()));
        }
        return ret;
    }

    private static Map<String, SupervisorDetails> basicSupervisorDetailsMap(IStormClusterState state) {
        HashMap<String, SupervisorDetails> ret = new HashMap<String, SupervisorDetails>();
        for (Map.Entry entry : state.allSupervisorInfo().entrySet()) {
            String id = (String)entry.getKey();
            SupervisorInfo info = (SupervisorInfo)entry.getValue();
            ret.put(id, new SupervisorDetails(id, info.get_server_port(), info.get_hostname(), info.get_scheduler_meta(), null, info.get_resources_map()));
        }
        return ret;
    }

    private static boolean isTopologyActive(IStormClusterState state, String topoName) {
        return state.getTopoId(topoName).isPresent();
    }

    private static boolean isTopologyActiveOrActivating(IStormClusterState state, String topoName) {
        return Nimbus.isTopologyActive(state, topoName) || state.activeStorms().contains(topoName);
    }

    private static Map<String, Object> tryReadTopoConf(String topoId, TopoCache tc) throws NotAliveException, AuthorizationException, IOException {
        try {
            return Nimbus.readTopoConfAsNimbus(topoId, tc);
        }
        catch (KeyNotFoundException e) {
            if (topoId == null) {
                throw new NullPointerException();
            }
            throw new WrappedNotAliveException(topoId);
        }
    }

    private static void rotateTopologyCleanupMap(long deletionDelay) {
        if (Time.currentTimeMillis() - topologyCleanupRotationTime > deletionDelay) {
            topologyCleanupDetected.rotate();
            topologyCleanupRotationTime = Time.currentTimeMillis();
        }
    }

    private static long getTopologyCleanupDetectedTime(String topologyId) {
        Long firstDetectedForDeletion = (Long)topologyCleanupDetected.get((Object)topologyId);
        if (firstDetectedForDeletion == null) {
            firstDetectedForDeletion = Time.currentTimeMillis();
            topologyCleanupDetected.put((Object)topologyId, (Object)firstDetectedForDeletion);
        }
        return firstDetectedForDeletion;
    }

    static Set<String> getExpiredTopologyIds(Set<String> toposToClean, Map<String, Object> conf) {
        HashSet<String> idleTopologies = new HashSet<String>();
        long topologyDeletionDelay = ObjectReader.getInt((Object)conf.get("nimbus.topology.blobstore.deletion.delay.ms"), (Integer)300000).intValue();
        for (String topologyId : toposToClean) {
            if (Math.max(0L, Time.currentTimeMillis() - Nimbus.getTopologyCleanupDetectedTime(topologyId)) < topologyDeletionDelay) continue;
            idleTopologies.add(topologyId);
        }
        Nimbus.rotateTopologyCleanupMap(topologyDeletionDelay);
        return idleTopologies;
    }

    @VisibleForTesting
    public static Set<String> topoIdsToClean(IStormClusterState state, BlobStore store, Map<String, Object> conf) {
        Set<String> ret = new HashSet<String>();
        ret.addAll((Collection)Utils.OR((Object)state.heartbeatStorms(), EMPTY_STRING_LIST));
        ret.addAll((Collection)Utils.OR((Object)state.errorTopologies(), EMPTY_STRING_LIST));
        ret.addAll((Collection)Utils.OR((Object)store.storedTopoIds(), EMPTY_STRING_SET));
        ret.addAll((Collection)Utils.OR((Object)state.backpressureTopologies(), EMPTY_STRING_LIST));
        ret.addAll((Collection)Utils.OR((Object)state.idsOfTopologiesWithPrivateWorkerKeys(), EMPTY_STRING_SET));
        ret = Nimbus.getExpiredTopologyIds(ret, conf);
        ret.removeAll((Collection)Utils.OR((Object)state.activeStorms(), EMPTY_STRING_LIST));
        return ret;
    }

    private static String extractStatusStr(StormBase base) {
        TopologyStatus status;
        String ret = null;
        if (base != null && (status = base.get_status()) != null) {
            ret = status.name().toUpperCase();
        }
        return ret;
    }

    private static StormTopology normalizeTopology(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        StormTopology ret = topology.deepCopy();
        for (Object comp : StormCommon.allComponents((StormTopology)ret).values()) {
            Map mergedConf = StormCommon.componentConf(comp);
            mergedConf.put("topology.tasks", ServerUtils.getComponentParallelism(topoConf, comp));
            String jsonConf = JSONValue.toJSONString((Object)mergedConf);
            StormCommon.getComponentCommon(comp).set_json_conf(jsonConf);
        }
        return ret;
    }

    private static void addToDecorators(Set<String> decorators, List<String> conf) {
        if (conf != null) {
            decorators.addAll(conf);
        }
    }

    private static void addToSerializers(Map<String, String> ser, List<Object> conf) {
        if (conf != null) {
            for (Object o : conf) {
                if (o instanceof Map) {
                    ser.putAll((Map)o);
                    continue;
                }
                ser.put((String)o, null);
            }
        }
    }

    private static Map<String, Object> normalizeConf(Map<String, Object> conf, Map<String, Object> topoConf, StormTopology topology) {
        int workerMaxTimeoutSecs;
        int workerTimeoutSecs;
        ArrayList<Map> allConfs = new ArrayList<Map>();
        for (Object comp : StormCommon.allComponents((StormTopology)topology).values()) {
            allConfs.add(StormCommon.componentConf(comp));
        }
        HashSet<String> decorators = new HashSet<String>();
        HashMap<String, String> serializers = new HashMap<String, String>();
        for (Map c : allConfs) {
            Nimbus.addToDecorators(decorators, (List)c.get("topology.kryo.decorators"));
            Nimbus.addToSerializers(serializers, (List)c.get("topology.kryo.register"));
        }
        Nimbus.addToDecorators(decorators, (List)topoConf.getOrDefault("topology.kryo.decorators", conf.get("topology.kryo.decorators")));
        Nimbus.addToSerializers(serializers, (List)topoConf.getOrDefault("topology.kryo.register", conf.get("topology.kryo.register")));
        Map mergedConf = Utils.merge(conf, topoConf);
        HashMap<String, Object> ret = new HashMap<String, Object>(topoConf);
        ret.put("topology.kryo.register", serializers);
        ret.put("topology.kryo.decorators", new ArrayList<String>(decorators));
        ret.put("topology.acker.executors", mergedConf.get("topology.acker.executors"));
        ret.put("topology.eventlogger.executors", mergedConf.get("topology.eventlogger.executors"));
        ret.put("topology.max.task.parallelism", mergedConf.get("topology.max.task.parallelism"));
        boolean enforceNettyAuth = false;
        enforceNettyAuth = !topoConf.containsKey("storm.messaging.netty.authentication") ? (Boolean)conf.get("storm.messaging.netty.authentication") : (Boolean)topoConf.get("storm.messaging.netty.authentication") != false || (Boolean)conf.get("storm.messaging.netty.authentication") != false;
        LOG.debug("For netty authentication, topo conf is: {}, cluster conf is: {}, Enforce netty auth: {}", new Object[]{topoConf.get("storm.messaging.netty.authentication"), conf.get("storm.messaging.netty.authentication"), enforceNettyAuth});
        ret.put("storm.messaging.netty.authentication", enforceNettyAuth);
        if (!mergedConf.containsKey("topology.metrics.reporters") && mergedConf.containsKey("storm.metrics.reporters")) {
            ret.put("topology.metrics.reporters", mergedConf.get("storm.metrics.reporters"));
        }
        ret.put("storm.cgroup.hierarchy.dir", conf.get("storm.cgroup.hierarchy.dir"));
        ret.put("worker.metrics", conf.get("worker.metrics"));
        if (mergedConf.containsKey("topology.worker.timeout.secs") && (workerTimeoutSecs = ObjectReader.getInt(mergedConf.get("topology.worker.timeout.secs")).intValue()) > (workerMaxTimeoutSecs = ObjectReader.getInt(mergedConf.get("worker.max.timeout.secs")).intValue())) {
            ret.put("topology.worker.timeout.secs", workerMaxTimeoutSecs);
            String topoId = (String)mergedConf.get("storm.id");
            LOG.warn("Topology {} topology.worker.timeout.secs is too large. Reducing from {} to {}", new Object[]{topoId, workerTimeoutSecs, workerMaxTimeoutSecs});
        }
        return ret;
    }

    private static void rmBlobKey(BlobStore store, String key, IStormClusterState state) {
        try {
            store.deleteBlob(key, NIMBUS_SUBJECT);
        }
        catch (Exception e) {
            LOG.info("Exception {}", (Throwable)e);
        }
    }

    @VisibleForTesting
    public static void cleanInbox(String dirLoc, int seconds) {
        long now = Time.currentTimeMillis();
        long ms = Time.secsToMillis((int)seconds);
        File dir = new File(dirLoc);
        for (File f : dir.listFiles(file -> file.isFile() && file.lastModified() + ms <= now)) {
            if (f.delete()) {
                LOG.info("Cleaning inbox ... deleted: {}", (Object)f.getName());
                continue;
            }
            LOG.error("Cleaning inbox ... error deleting: {}", (Object)f.getName());
        }
    }

    private static ExecutorInfo toExecInfo(List<Long> exec) {
        return new ExecutorInfo(exec.get(0).intValue(), exec.get(1).intValue());
    }

    private static void validateTopologyName(String name) throws InvalidTopologyException {
        try {
            Utils.validateTopologyName((String)name);
        }
        catch (IllegalArgumentException e) {
            throw new WrappedInvalidTopologyException(e.getMessage());
        }
    }

    private static StormTopology tryReadTopology(String topoId, TopoCache tc) throws NotAliveException, AuthorizationException, IOException {
        try {
            return Nimbus.readStormTopologyAsNimbus(topoId, tc);
        }
        catch (KeyNotFoundException e) {
            throw new WrappedNotAliveException(topoId);
        }
    }

    private static void validateTopologySize(Map<String, Object> topoConf, Map<String, Object> nimbusConf, StormTopology topology) throws InvalidTopologyException {
        if (!ServerUtils.isRas(nimbusConf)) {
            int workerCount = ObjectReader.getInt((Object)topoConf.get("topology.workers"), (Integer)1);
            Integer allowedWorkers = ObjectReader.getInt((Object)nimbusConf.get("nimbus.slots.perTopology"), null);
            if (allowedWorkers != null && workerCount > allowedWorkers) {
                throw new WrappedInvalidTopologyException("Failed to submit topology. Topology requests more than " + allowedWorkers + " workers.");
            }
        }
        int executorsCount = 0;
        for (Object comp : StormCommon.allComponents((StormTopology)topology).values()) {
            executorsCount += StormCommon.numStartExecutors(comp);
        }
        Integer allowedExecutors = ObjectReader.getInt((Object)nimbusConf.get("nimbus.executors.perTopology"), null);
        if (allowedExecutors != null && executorsCount > allowedExecutors) {
            throw new WrappedInvalidTopologyException("Failed to submit topology. Topology requests more than " + allowedExecutors + " executors.");
        }
    }

    private static void setLoggerTimeouts(LogLevel level) {
        int timeoutSecs = level.get_reset_log_level_timeout_secs();
        if (timeoutSecs > 0) {
            level.set_reset_log_level_timeout_epoch(Time.currentTimeMillis() + Time.secsToMillis((int)timeoutSecs));
        } else {
            level.unset_reset_log_level_timeout_epoch();
        }
    }

    @VisibleForTesting
    public static List<String> topologiesOnSupervisor(Map<String, Assignment> assignments, String supervisorId) {
        HashSet<String> ret = new HashSet<String>();
        block0: for (Map.Entry<String, Assignment> entry : assignments.entrySet()) {
            Assignment assignment = entry.getValue();
            for (NodeInfo nodeInfo : assignment.get_executor_node_port().values()) {
                if (!supervisorId.equals(nodeInfo.get_node())) continue;
                ret.add(entry.getKey());
                continue block0;
            }
        }
        return new ArrayList<String>(ret);
    }

    private static IClusterMetricsConsumer.ClusterInfo mkClusterInfo() {
        return new IClusterMetricsConsumer.ClusterInfo(Time.currentTimeSecs());
    }

    private static List<DataPoint> extractClusterMetrics(ClusterSummary summ) {
        ArrayList<DataPoint> ret = new ArrayList<DataPoint>();
        ret.add(new DataPoint("supervisors", summ.get_supervisors_size()));
        ret.add(new DataPoint("topologies", summ.get_topologies_size()));
        int totalSlots = 0;
        int usedSlots = 0;
        for (SupervisorSummary sup : summ.get_supervisors()) {
            usedSlots += sup.get_num_used_workers();
            totalSlots += sup.get_num_workers();
        }
        ret.add(new DataPoint("slotsTotal", totalSlots));
        ret.add(new DataPoint("slotsUsed", usedSlots));
        ret.add(new DataPoint("slotsFree", totalSlots - usedSlots));
        int totalExecutors = 0;
        int totalTasks = 0;
        for (TopologySummary topo : summ.get_topologies()) {
            totalExecutors += topo.get_num_executors();
            totalTasks += topo.get_num_tasks();
        }
        ret.add(new DataPoint("executorsTotal", totalExecutors));
        ret.add(new DataPoint("tasksTotal", totalTasks));
        return ret;
    }

    private static Map<IClusterMetricsConsumer.SupervisorInfo, List<DataPoint>> extractSupervisorMetrics(ClusterSummary summ) {
        HashMap<IClusterMetricsConsumer.SupervisorInfo, List<DataPoint>> ret = new HashMap<IClusterMetricsConsumer.SupervisorInfo, List<DataPoint>>();
        for (SupervisorSummary sup : summ.get_supervisors()) {
            ArrayList<DataPoint> metrics = new ArrayList<DataPoint>();
            metrics.add(new DataPoint("slotsTotal", sup.get_num_workers()));
            metrics.add(new DataPoint("slotsUsed", sup.get_num_used_workers()));
            metrics.add(new DataPoint("totalMem", sup.get_total_resources().get("memory.mb")));
            metrics.add(new DataPoint("totalCpu", sup.get_total_resources().get("cpu.pcore.percent")));
            metrics.add(new DataPoint("usedMem", sup.get_used_mem()));
            metrics.add(new DataPoint("usedCpu", sup.get_used_cpu()));
            IClusterMetricsConsumer.SupervisorInfo info = new IClusterMetricsConsumer.SupervisorInfo(sup.get_host(), sup.get_supervisor_id(), Time.currentTimeSecs());
            ret.put(info, metrics);
        }
        return ret;
    }

    private static void setResourcesDefaultIfNotSet(Map<String, NormalizedResourceRequest> compResourcesMap, String compId, Map<String, Object> topoConf) {
        NormalizedResourceRequest resources = compResourcesMap.get(compId);
        if (resources == null) {
            compResourcesMap.put(compId, new NormalizedResourceRequest(topoConf, compId));
        }
    }

    private static void validatePortAvailable(Map<String, Object> conf) throws IOException {
        int port = ObjectReader.getInt((Object)conf.get("nimbus.thrift.port"));
        try {
            ServerSocket socket = new ServerSocket(port);
            Throwable throwable = null;
            if (socket != null) {
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    socket.close();
                }
            }
        }
        catch (BindException e) {
            LOG.error("{} is not available. Check if another process is already listening on {}", (Object)port, (Object)port);
            System.exit(0);
        }
    }

    @VisibleForTesting
    public void launchServer() throws Exception {
        try {
            IStormClusterState state = this.stormClusterState;
            NimbusInfo hpi = this.nimbusHostPortInfo;
            LOG.info("Starting Nimbus with conf {}", (Object)ConfigUtils.maskPasswords(this.conf));
            this.validator.prepare(this.conf);
            state.addNimbusHost(hpi.getHost(), new NimbusSummary(hpi.getHost(), hpi.getPort(), Time.currentTimeSecs(), false, STORM_VERSION));
            this.leaderElector.addToLeaderLockQueue();
            this.blobStore.startSyncBlobs();
            for (ClusterMetricsConsumerExecutor exec : this.clusterConsumerExceutors) {
                exec.prepare();
            }
            this.timer.scheduleRecurring(3, 5, () -> {
                try {
                    boolean isLeader = this.isLeader();
                    if (isLeader && !this.wasLeader) {
                        for (String topoId : state.activeStorms()) {
                            this.transition(topoId, TopologyActions.GAIN_LEADERSHIP, null);
                        }
                        this.clusterMetricSet.setActive(true);
                    }
                    this.wasLeader = isLeader;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            boolean doNotReassign = (Boolean)this.conf.getOrDefault("NIMBUS-DO-NOT-REASSIGN", false);
            this.timer.scheduleRecurring(0, ObjectReader.getInt((Object)this.conf.get("nimbus.monitor.freq.secs")).intValue(), () -> {
                try {
                    if (!doNotReassign) {
                        this.mkAssignments();
                    }
                    this.doCleanup();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            int jarExpSecs = ObjectReader.getInt((Object)this.conf.get("nimbus.inbox.jar.expiration.secs"));
            this.timer.scheduleRecurring(0, ObjectReader.getInt((Object)this.conf.get("nimbus.cleanup.inbox.freq.secs")).intValue(), () -> {
                try {
                    Nimbus.cleanInbox(this.getInbox(), jarExpSecs);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Integer interval = ObjectReader.getInt((Object)this.conf.get("logviewer.cleanup.interval.secs"), null);
            if (interval != null) {
                int lvCleanupAgeMins = ObjectReader.getInt((Object)this.conf.get("logviewer.cleanup.age.mins"));
                this.timer.scheduleRecurring(0, interval.intValue(), () -> {
                    try {
                        this.cleanTopologyHistory(lvCleanupAgeMins);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            this.timer.scheduleRecurring(0, ObjectReader.getInt((Object)this.conf.get("nimbus.credential.renewers.freq.secs")).intValue(), () -> {
                try {
                    this.renewCredentials();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.timer.scheduleRecurring(30, ServerConfigUtils.getLocalizerUpdateBlobInterval(this.conf) * 5, () -> {
                try {
                    this.blobStore.validateBlobUpdateTime();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.metricsRegistry.registerGauge("nimbus:total-available-memory-non-negative", () -> this.nodeIdToResources.get().values().parallelStream().mapToDouble(supervisorResources -> Math.max(supervisorResources.getAvailableMem(), 0.0)).sum());
            this.metricsRegistry.registerGauge("nimbus:available-cpu-non-negative", () -> this.nodeIdToResources.get().values().parallelStream().mapToDouble(supervisorResources -> Math.max(supervisorResources.getAvailableCpu(), 0.0)).sum());
            this.metricsRegistry.registerGauge("nimbus:total-memory", () -> this.nodeIdToResources.get().values().parallelStream().mapToDouble(SupervisorResources::getTotalMem).sum());
            this.metricsRegistry.registerGauge("nimbus:total-cpu", () -> this.nodeIdToResources.get().values().parallelStream().mapToDouble(SupervisorResources::getTotalCpu).sum());
            this.metricsRegistry.registerGauge("nimbus:longest-scheduling-time-ms", () -> {
                Long currTime = Time.nanoTime();
                Long startTime = this.schedulingStartTimeNs.get();
                return TimeUnit.NANOSECONDS.toMillis(startTime == null ? this.longestSchedulingTime.get() : Math.max(currTime - startTime, this.longestSchedulingTime.get()));
            });
            this.metricsRegistry.registerMeter("nimbus:num-launched").mark();
            this.timer.scheduleRecurring(0, ObjectReader.getInt((Object)this.conf.get("storm.cluster.metrics.consumer.publish.interval.secs")).intValue(), () -> {
                try {
                    if (this.isLeader()) {
                        this.sendClusterMetricsToExecutors();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.timer.scheduleRecurring(5, 5, (Runnable)this.clusterMetricSet);
        }
        catch (Exception e) {
            if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, (Throwable)e)) {
                throw e;
            }
            if (Utils.exceptionCauseIsInstanceOf(InterruptedIOException.class, (Throwable)e)) {
                throw e;
            }
            LOG.error("Error on initialization of nimbus", (Throwable)e);
            Utils.exitProcess((int)13, (String)"Error on initialization of nimbus");
        }
    }

    private static Nimbus launchServer(Map<String, Object> conf, INimbus inimbus) throws Exception {
        StormCommon.validateDistributedMode(conf);
        Nimbus.validatePortAvailable(conf);
        OciUtils.validateImageInDaemonConf(conf);
        StormMetricsRegistry metricsRegistry = new StormMetricsRegistry();
        Nimbus nimbus = new Nimbus(conf, inimbus, metricsRegistry);
        nimbus.launchServer();
        ThriftServer server = new ThriftServer(conf, (TProcessor)new Nimbus.Processor((Nimbus.Iface)nimbus), ThriftConnectionType.NIMBUS);
        metricsRegistry.startMetricsReporters(conf);
        Utils.addShutdownHookWithDelayedForceKill(() -> {
            metricsRegistry.stopMetricsReporters();
            nimbus.shutdown();
            server.stop();
        }, (int)10);
        if (ClientAuthUtils.areWorkerTokensEnabledServer((ThriftServer)server, conf)) {
            nimbus.initWorkerTokenManager();
        }
        LOG.info("Starting nimbus server for storm version '{}'", (Object)STORM_VERSION);
        server.serve();
        return nimbus;
    }

    public static Nimbus launch(INimbus inimbus) throws Exception {
        boolean checkAcl;
        Map conf = Utils.merge((Map)ConfigUtils.readStormConfig(), (Map)ConfigUtils.readYamlConfig((String)"storm-cluster-auth.yaml", (boolean)false));
        boolean fixupAcl = (Boolean)conf.get("storm.nimbus.zookeeper.acls.fixup");
        boolean bl = checkAcl = fixupAcl || (Boolean)conf.get("storm.nimbus.zookeeper.acls.check") != false;
        if (checkAcl) {
            AclEnforcement.verifyAcls(conf, fixupAcl);
        }
        return Nimbus.launchServer(conf, inimbus);
    }

    public static void main(String[] args) throws Exception {
        Utils.setupDefaultUncaughtExceptionHandler();
        Nimbus.launch(new StandaloneINimbus());
    }

    private static CuratorFramework makeZKClient(Map<String, Object> conf) {
        List servers = (List)conf.get("storm.zookeeper.servers");
        Object port = conf.get("storm.zookeeper.port");
        String root = (String)conf.get("storm.zookeeper.root");
        CuratorFramework ret = null;
        if (servers != null && port != null) {
            ret = ClientZookeeper.mkClient(conf, (List)servers, (Object)port, (String)root, (WatcherCallBack)new DefaultWatcherCallBack(), conf, (DaemonType)DaemonType.NIMBUS);
        }
        return ret;
    }

    private static IStormClusterState makeStormClusterState(Map<String, Object> conf) throws Exception {
        return ClusterUtils.mkStormClusterState(conf, (ClusterStateContext)new ClusterStateContext(DaemonType.NIMBUS, conf));
    }

    private static List<Integer> asIntExec(List<Long> exec) {
        ArrayList<Integer> ret = new ArrayList<Integer>(2);
        ret.add(exec.get(0).intValue());
        ret.add(exec.get(1).intValue());
        return ret;
    }

    private static Map<String, String> assignmentChangedNodes(Assignment oldAss, Assignment newAss) {
        Map oldExecutorNodePort = null;
        Map newExecutorNodePort = null;
        HashMap<String, String> allNodeHost = new HashMap<String, String>();
        if (oldAss != null) {
            oldExecutorNodePort = oldAss.get_executor_node_port();
            allNodeHost.putAll(oldAss.get_node_host());
        }
        if (newAss != null) {
            newExecutorNodePort = newAss.get_executor_node_port();
            allNodeHost.putAll(newAss.get_node_host());
        }
        if (oldAss == null || newAss == null) {
            return allNodeHost;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry entry : newExecutorNodePort.entrySet()) {
            NodeInfo newNodeInfo = (NodeInfo)entry.getValue();
            NodeInfo oldNodeInfo = (NodeInfo)oldExecutorNodePort.get(entry.getKey());
            if (null != oldNodeInfo) {
                if (oldNodeInfo.equals(newNodeInfo)) continue;
                ret.put(oldNodeInfo.get_node(), (String)allNodeHost.get(oldNodeInfo.get_node()));
                ret.put(newNodeInfo.get_node(), (String)allNodeHost.get(newNodeInfo.get_node()));
                continue;
            }
            ret.put(newNodeInfo.get_node(), (String)allNodeHost.get(newNodeInfo.get_node()));
        }
        return ret;
    }

    private static Map<String, Assignment> assignmentsForHost(Map<String, Assignment> assignmentMap, String hostname) {
        HashMap<String, Assignment> ret = new HashMap<String, Assignment>();
        assignmentMap.entrySet().stream().filter(assignmentEntry -> ((Assignment)assignmentEntry.getValue()).get_node_host().values().contains(hostname)).forEach(assignmentEntry -> ret.put((String)assignmentEntry.getKey(), (Assignment)assignmentEntry.getValue()));
        return ret;
    }

    private static Map<String, Assignment> assignmentsForNodeId(Map<String, Assignment> assignmentMap, String nodeId) {
        HashMap<String, Assignment> ret = new HashMap<String, Assignment>();
        assignmentMap.entrySet().stream().filter(assignmentEntry -> ((Assignment)assignmentEntry.getValue()).get_node_host().keySet().contains(nodeId)).forEach(assignmentEntry -> ret.put((String)assignmentEntry.getKey(), (Assignment)assignmentEntry.getValue()));
        return ret;
    }

    private static void notifySupervisorsAssignments(Map<String, Assignment> assignments, AssignmentDistributionService service, Map<String, String> nodeHost, Map<String, SupervisorDetails> supervisorDetails, StormMetricsRegistry metricsRegistry) {
        for (Map.Entry<String, String> nodeEntry : nodeHost.entrySet()) {
            try {
                String nodeId = nodeEntry.getKey();
                String hostname = nodeEntry.getValue();
                SupervisorAssignments supervisorAssignments = new SupervisorAssignments();
                supervisorAssignments.set_storm_assignment(Nimbus.assignmentsForHost(assignments, hostname));
                SupervisorDetails details = supervisorDetails.get(nodeId);
                Integer serverPort = details != null ? Integer.valueOf(details.getServerPort()) : null;
                service.addAssignmentsForNode(nodeId, nodeEntry.getValue(), serverPort, supervisorAssignments, metricsRegistry);
            }
            catch (Throwable tr1) {
                LOG.error("Exception when add assignments distribution task for node {}", (Object)nodeEntry.getKey());
            }
        }
    }

    private static void notifySupervisorsAsKilled(IStormClusterState clusterState, Assignment oldAss, AssignmentDistributionService service, StormMetricsRegistry metricsRegistry) {
        Map<String, String> nodeHost = Nimbus.assignmentChangedNodes(oldAss, null);
        Nimbus.notifySupervisorsAssignments(clusterState.assignmentsInfo(), service, nodeHost, Nimbus.basicSupervisorDetailsMap(clusterState), metricsRegistry);
    }

    Map<String, Object> getConf() {
        return this.conf;
    }

    @VisibleForTesting
    public void setAuthorizationHandler(IAuthorizer authorizationHandler) {
        this.authorizationHandler = authorizationHandler;
    }

    private IStormClusterState getStormClusterState() {
        return this.stormClusterState;
    }

    private AssignmentDistributionService getAssignmentsDistributer() {
        return this.assignmentsDistributer;
    }

    private StormMetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @VisibleForTesting
    public HeartbeatCache getHeartbeatsCache() {
        return this.heartbeatsCache;
    }

    public AtomicReference<Map<String, Set<List<Integer>>>> getIdToExecutors() {
        return this.idToExecutors;
    }

    private Set<List<Integer>> getOrUpdateExecutors(String topoId, StormBase base, Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        Set<List<Integer>> executors = this.idToExecutors.get().get(topoId);
        if (null == executors) {
            executors = new HashSet<List<Integer>>(this.computeExecutors(base, topoConf, topology));
            this.idToExecutors.getAndUpdate(new Assoc<String, Set<List<Integer>>>(topoId, executors));
        }
        return executors;
    }

    private BlobStore getBlobStore() {
        return this.blobStore;
    }

    private TopoCache getTopoCache() {
        return this.topoCache;
    }

    @VisibleForTesting
    void initWorkerTokenManager() {
        if (this.workerTokenManager == null) {
            this.workerTokenManager = new WorkerTokenManager(this.conf, this.getStormClusterState());
        }
    }

    private boolean isLeader() throws Exception {
        return this.leaderElector.isLeader();
    }

    private void assertIsLeader() throws Exception {
        if (!this.isLeader()) {
            NimbusInfo leaderAddress = this.leaderElector.getLeader();
            throw new RuntimeException("not a leader, current leader is " + leaderAddress);
        }
    }

    private String getInbox() throws IOException {
        return ServerConfigUtils.masterInbox(this.conf);
    }

    public void addSupervisor(Supervisor supervisor) {
        this.assignmentsDistributer.addLocalSupervisor(supervisor);
    }

    void delayEvent(String topoId, int delaySecs, TopologyActions event, Object args) {
        LOG.info("Delaying event {} for {} secs for {}", new Object[]{event, delaySecs, topoId});
        this.timer.schedule(delaySecs, () -> {
            try {
                this.transition(topoId, event, args, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    void doRebalance(String topoId, StormBase stormBase) throws Exception {
        RebalanceOptions rbo = stormBase.get_topology_action_options().get_rebalance_options();
        StormBase updated = new StormBase();
        updated.set_topology_action_options(null);
        updated.set_component_debug(Collections.emptyMap());
        if (rbo.is_set_num_executors()) {
            updated.set_component_executors(rbo.get_num_executors());
        }
        if (rbo.is_set_num_workers()) {
            updated.set_num_workers(rbo.get_num_workers());
        }
        this.stormClusterState.updateStorm(topoId, updated);
        this.updateBlobStore(topoId, rbo, ServerUtils.principalNameToSubject(rbo.get_principal()));
        this.idToExecutors.getAndUpdate(new Dissoc(topoId));
        this.mkAssignments(topoId);
    }

    private String toTopoId(String topoName) throws NotAliveException {
        return (String)this.stormClusterState.getTopoId(topoName).orElseThrow(() -> new WrappedNotAliveException(topoName + " is not alive"));
    }

    private void transitionName(String topoName, TopologyActions event, Object eventArg, boolean errorOnNoTransition) throws Exception {
        this.transition(this.toTopoId(topoName), event, eventArg, errorOnNoTransition);
    }

    private void transition(String topoId, TopologyActions event, Object eventArg) throws Exception {
        this.transition(topoId, event, eventArg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transition(String topoId, TopologyActions event, Object eventArg, boolean errorOnNoTransition) throws Exception {
        LOG.info("TRANSITION: {} {} {} {}", new Object[]{topoId, event, eventArg, errorOnNoTransition});
        this.assertIsLeader();
        Object object = this.submitLock;
        synchronized (object) {
            IStormClusterState clusterState = this.stormClusterState;
            StormBase base = clusterState.stormBase(topoId, null);
            if (base == null || base.get_status() == null) {
                LOG.info("Cannot apply event {} to {} because topology no longer exists", (Object)event, (Object)topoId);
            } else {
                StormBase updates;
                TopologyStatus status = base.get_status();
                TopologyStateTransition transition = TOPO_STATE_TRANSITIONS.get(status).get((Object)event);
                if (transition == null) {
                    String message = "No transition for event: " + (Object)((Object)event) + ", status: " + status + " storm-id: " + topoId;
                    if (errorOnNoTransition) {
                        throw new RuntimeException(message);
                    }
                    if (TopologyActions.GAIN_LEADERSHIP != event) {
                        LOG.info(message);
                    }
                    transition = NOOP_TRANSITION;
                }
                if ((updates = transition.transition(eventArg, this, topoId, base)) != null) {
                    clusterState.updateStorm(topoId, updates);
                }
            }
        }
    }

    private void setupStormCode(Map<String, Object> conf, String topoId, String tmpJarLocation, Map<String, Object> topoConf, StormTopology topology) throws Exception {
        Subject subject = Nimbus.getSubject();
        IStormClusterState clusterState = this.stormClusterState;
        BlobStore store = this.blobStore;
        String jarKey = ConfigUtils.masterStormJarKey((String)topoId);
        if (tmpJarLocation != null) {
            try (FileInputStream fin = new FileInputStream(tmpJarLocation);){
                store.createBlob(jarKey, (InputStream)fin, new SettableBlobMeta(BlobStoreAclHandler.DEFAULT), subject);
            }
        }
        this.topoCache.addTopoConf(topoId, subject, topoConf);
        this.topoCache.addTopology(topoId, subject, topology);
    }

    private void updateTopologyResources(String topoId, Map<String, Map<String, Double>> resourceOverrides, Subject subject) throws AuthorizationException, IOException, KeyNotFoundException {
        StormTopology topo = this.topoCache.readTopology(topoId, subject);
        topo = topo.deepCopy();
        ResourceUtils.updateStormTopologyResources(topo, resourceOverrides);
        this.topoCache.updateTopology(topoId, subject, topo);
    }

    private void updateTopologyConf(String topoId, Map<String, Object> configOverride, Subject subject) throws AuthorizationException, IOException, KeyNotFoundException {
        HashMap<String, Object> topoConf = new HashMap<String, Object>(this.topoCache.readTopoConf(topoId, subject));
        topoConf.putAll(configOverride);
        this.topoCache.updateTopoConf(topoId, subject, topoConf);
    }

    private void updateBlobStore(String topoId, RebalanceOptions rbo, Subject subject) throws AuthorizationException, IOException, KeyNotFoundException {
        String confOverride;
        Map resourceOverrides = rbo.get_topology_resources_overrides();
        if (resourceOverrides != null && !resourceOverrides.isEmpty()) {
            this.updateTopologyResources(topoId, resourceOverrides, subject);
        }
        if ((confOverride = rbo.get_topology_conf_overrides()) != null && !confOverride.isEmpty()) {
            this.updateTopologyConf(topoId, Utils.parseJson((String)confOverride), subject);
        }
    }

    private Integer getBlobReplicationCount(String key) throws Exception {
        BlobStore store = this.blobStore;
        if (store != null) {
            return store.getBlobReplication(key, NIMBUS_SUBJECT);
        }
        return null;
    }

    private void waitForDesiredCodeReplication(Map<String, Object> topoConf, String topoId) throws Exception {
        int minReplicationCount = ObjectReader.getInt((Object)topoConf.get("topology.min.replication.count"));
        int maxWaitTime = ObjectReader.getInt((Object)topoConf.get("topology.max.replication.wait.time.sec"));
        int jarCount = minReplicationCount;
        if (!ConfigUtils.isLocalMode(topoConf)) {
            jarCount = this.getBlobReplicationCount(ConfigUtils.masterStormJarKey((String)topoId));
        }
        int codeCount = this.getBlobReplicationCount(ConfigUtils.masterStormCodeKey((String)topoId));
        int confCount = this.getBlobReplicationCount(ConfigUtils.masterStormConfKey((String)topoId));
        long totalWaitTime = 0L;
        if (this.blobStore != null) {
            while (jarCount < minReplicationCount && codeCount < minReplicationCount && confCount < minReplicationCount) {
                if (maxWaitTime > 0 && totalWaitTime > (long)maxWaitTime) {
                    LOG.info("desired replication count of {} not achieved for {} but we have hit the max wait time {} so moving on with replication count for conf key = {} for code key = {} for jar key = ", new Object[]{minReplicationCount, topoId, maxWaitTime, confCount, codeCount, jarCount});
                    return;
                }
                LOG.debug("Checking if I am still the leader");
                this.assertIsLeader();
                LOG.info("WAITING... storm-id {}, {} <? {} {} {}", new Object[]{topoId, minReplicationCount, jarCount, codeCount, confCount});
                LOG.info("WAITING... {} <? {}", (Object)totalWaitTime, (Object)maxWaitTime);
                Time.sleepSecs((long)1L);
                ++totalWaitTime;
                if (!ConfigUtils.isLocalMode(topoConf)) {
                    jarCount = this.getBlobReplicationCount(ConfigUtils.masterStormJarKey((String)topoId));
                }
                codeCount = this.getBlobReplicationCount(ConfigUtils.masterStormCodeKey((String)topoId));
                confCount = this.getBlobReplicationCount(ConfigUtils.masterStormConfKey((String)topoId));
            }
        }
        LOG.info("desired replication count {} achieved for topology {}, current-replication-count for conf key = {}, current-replication-count for code key = {}, current-replication-count for jar key = {}", new Object[]{minReplicationCount, topoId, confCount, codeCount, jarCount});
    }

    private TopologyDetails readTopologyDetails(String topoId, StormBase base) throws KeyNotFoundException, AuthorizationException, IOException, InvalidTopologyException {
        assert (base != null);
        assert (topoId != null);
        Map<String, Object> topoConf = Nimbus.readTopoConfAsNimbus(topoId, this.topoCache);
        StormTopology topo = Nimbus.readStormTopologyAsNimbus(topoId, this.topoCache);
        if (!base.is_set_principal()) {
            this.fixupBase(base, topoConf);
            this.stormClusterState.updateStorm(topoId, base);
        }
        Map<List<Integer>, String> rawExecToComponent = this.computeExecutorToComponent(topoId, base, topoConf, topo);
        HashMap<ExecutorDetails, String> executorsToComponent = new HashMap<ExecutorDetails, String>();
        for (Map.Entry<List<Integer>, String> entry : rawExecToComponent.entrySet()) {
            List<Integer> execs = entry.getKey();
            ExecutorDetails execDetails = new ExecutorDetails(execs.get(0), execs.get(1));
            executorsToComponent.put(execDetails, entry.getValue());
        }
        return new TopologyDetails(topoId, topoConf, topo, base.get_num_workers(), executorsToComponent, base.get_launch_time_secs(), base.get_owner());
    }

    private void updateHeartbeatsFromZkHeartbeat(String topoId, Set<List<Integer>> allExecutors, Assignment existingAssignment) {
        LOG.debug("Updating heartbeats for {} {} (from ZK heartbeat)", (Object)topoId, allExecutors);
        IStormClusterState state = this.stormClusterState;
        Map<List<Integer>, Map<String, Object>> executorBeats = StatsUtil.convertExecutorBeats(state.executorBeats(topoId, existingAssignment.get_executor_node_port()));
        this.heartbeatsCache.updateFromZkHeartbeat(topoId, executorBeats, allExecutors, this.getTopologyHeartbeatTimeoutSecs(topoId));
    }

    private void updateAllHeartbeats(Map<String, Assignment> existingAssignments, Map<String, Set<List<Integer>>> topologyToExecutors, Set<String> zkHeartbeatTopologies) {
        for (Map.Entry<String, Assignment> entry : existingAssignments.entrySet()) {
            String topoId = entry.getKey();
            if (zkHeartbeatTopologies.contains(topoId)) {
                this.updateHeartbeatsFromZkHeartbeat(topoId, topologyToExecutors.get(topoId), entry.getValue());
                continue;
            }
            LOG.debug("Timing out old heartbeats for {}", (Object)topoId);
            this.heartbeatsCache.timeoutOldHeartbeats(topoId, this.getTopologyHeartbeatTimeoutSecs(topoId));
        }
    }

    private void updateCachedHeartbeatsFromWorker(SupervisorWorkerHeartbeat workerHeartbeat, int heartbeatTimeoutSecs) {
        this.heartbeatsCache.updateHeartbeat(workerHeartbeat, heartbeatTimeoutSecs);
    }

    private void updateCachedHeartbeatsFromSupervisor(SupervisorWorkerHeartbeats workerHeartbeats) {
        for (SupervisorWorkerHeartbeat hb : workerHeartbeats.get_worker_heartbeats()) {
            String topoId = hb.get_storm_id();
            int heartbeatTimeoutSecs = this.getTopologyHeartbeatTimeoutSecs(topoId);
            this.updateCachedHeartbeatsFromWorker(hb, heartbeatTimeoutSecs);
        }
        if (!this.heartbeatsReadyFlag.get() && !Strings.isNullOrEmpty((String)workerHeartbeats.get_supervisor_id())) {
            this.heartbeatsRecoveryStrategy.reportNodeId(workerHeartbeats.get_supervisor_id());
        }
    }

    private boolean isHeartbeatsRecovered() {
        if (this.heartbeatsReadyFlag.get()) {
            return true;
        }
        HashSet<String> allNodes = new HashSet<String>();
        for (Map.Entry assignmentEntry : this.stormClusterState.assignmentsInfo().entrySet()) {
            allNodes.addAll(((Assignment)assignmentEntry.getValue()).get_node_host().keySet());
        }
        boolean isReady = this.heartbeatsRecoveryStrategy.isReady(allNodes);
        if (isReady) {
            this.heartbeatsReadyFlag.getAndSet(true);
        }
        return isReady;
    }

    private boolean isAssignmentsRecovered() {
        return this.stormClusterState.isAssignmentsBackendSynchronized();
    }

    private Set<List<Integer>> aliveExecutors(String topoId, Set<List<Integer>> allExecutors, Assignment assignment) {
        return this.heartbeatsCache.getAliveExecutors(topoId, allExecutors, assignment, this.getTopologyLaunchHeartbeatTimeoutSec(topoId));
    }

    private List<List<Integer>> computeExecutors(StormBase base, Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        assert (base != null);
        Map compToExecutors = base.get_component_executors();
        ArrayList<List<Integer>> ret = new ArrayList<List<Integer>>();
        if (compToExecutors != null) {
            Map taskInfo = StormCommon.stormTaskInfo((StormTopology)topology, topoConf);
            HashMap compToTaskList = Utils.reverseMap((Map)taskInfo);
            for (Map.Entry entry : compToTaskList.entrySet()) {
                String compId = (String)entry.getKey();
                List tasks = (List)entry.getValue();
                tasks.sort(null);
                Integer numExecutors = (Integer)compToExecutors.get(compId);
                if (numExecutors == null) continue;
                List partitioned = Utils.partitionFixed((int)numExecutors, (Collection)tasks);
                for (List partition : partitioned) {
                    ret.add(Arrays.asList((Integer)partition.get(0), (Integer)partition.get(partition.size() - 1)));
                }
            }
        }
        return ret;
    }

    private Map<List<Integer>, String> computeExecutorToComponent(String topoId, StormBase base, Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        ArrayList<List<Integer>> executors = new ArrayList<List<Integer>>(this.getOrUpdateExecutors(topoId, base, topoConf, topology));
        Map taskToComponent = StormCommon.stormTaskInfo((StormTopology)topology, topoConf);
        HashMap<List<Integer>, String> ret = new HashMap<List<Integer>, String>();
        for (List list : executors) {
            ret.put(list, (String)taskToComponent.get(list.get(0)));
        }
        return ret;
    }

    private Map<String, Set<List<Integer>>> computeTopologyToExecutors(Map<String, StormBase> bases) throws KeyNotFoundException, AuthorizationException, InvalidTopologyException, IOException {
        HashMap<String, Set<List<Integer>>> ret = new HashMap<String, Set<List<Integer>>>();
        if (bases != null) {
            for (Map.Entry<String, StormBase> entry : bases.entrySet()) {
                String topoId = entry.getKey();
                Set<List<Integer>> executors = this.idToExecutors.get().get(topoId);
                if (executors == null) {
                    Map<String, Object> topoConf = Nimbus.readTopoConfAsNimbus(topoId, this.topoCache);
                    StormTopology topology = Nimbus.readStormTopologyAsNimbus(topoId, this.topoCache);
                    executors = this.getOrUpdateExecutors(topoId, entry.getValue(), topoConf, topology);
                }
                ret.put(topoId, executors);
            }
        }
        return ret;
    }

    private Map<String, Set<List<Integer>>> computeTopologyToAliveExecutors(Map<String, Assignment> existingAssignment, Map<String, Set<List<Integer>>> topologyToExecutors, String scratchTopologyId) {
        HashMap<String, Set<List<Integer>>> ret = new HashMap<String, Set<List<Integer>>>();
        for (Map.Entry<String, Assignment> entry : existingAssignment.entrySet()) {
            String topoId = entry.getKey();
            Assignment assignment = entry.getValue();
            Set<List<Integer>> allExecutors = topologyToExecutors.get(topoId);
            Set<List<Integer>> aliveExecutors = topoId.equals(scratchTopologyId) ? allExecutors : new HashSet<List<Integer>>(this.aliveExecutors(topoId, allExecutors, assignment));
            ret.put(topoId, aliveExecutors);
        }
        return ret;
    }

    private Map<String, Set<Long>> computeSupervisorToDeadPorts(Map<String, Assignment> existingAssignments, Map<String, Set<List<Integer>>> topologyToExecutors, Map<String, Set<List<Integer>>> topologyToAliveExecutors) {
        HashMap<String, Set<Long>> ret = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Assignment> entry : existingAssignments.entrySet()) {
            String topoId = entry.getKey();
            Assignment assignment = entry.getValue();
            Set<List<Integer>> allExecutors = topologyToExecutors.get(topoId);
            Set<List<Integer>> aliveExecutors = topologyToAliveExecutors.get(topoId);
            HashSet<List<Integer>> deadExecutors = new HashSet<List<Integer>>(allExecutors);
            deadExecutors.removeAll(aliveExecutors);
            Map execToNodePort = assignment.get_executor_node_port();
            for (Map.Entry assigned : execToNodePort.entrySet()) {
                if (!deadExecutors.contains(Nimbus.asIntExec((List)assigned.getKey()))) continue;
                NodeInfo info = (NodeInfo)assigned.getValue();
                String superId = info.get_node();
                HashSet ports = (HashSet)ret.get(superId);
                if (ports == null) {
                    ports = new HashSet();
                    ret.put(superId, ports);
                }
                ports.addAll(info.get_port());
            }
        }
        return ret;
    }

    private Map<String, SchedulerAssignmentImpl> computeTopologyToSchedulerAssignment(Map<String, Assignment> existingAssignments, Map<String, Set<List<Integer>>> topologyToAliveExecutors) {
        HashMap<String, SchedulerAssignmentImpl> ret = new HashMap<String, SchedulerAssignmentImpl>();
        for (Map.Entry<String, Assignment> entry : existingAssignments.entrySet()) {
            String topoId = entry.getKey();
            Assignment assignment = entry.getValue();
            Set<List<Integer>> aliveExecutors = topologyToAliveExecutors.get(topoId);
            Map execToNodePort = assignment.get_executor_node_port();
            Map workerToResources = assignment.get_worker_resources();
            HashMap<NodeInfo, WorkerSlot> nodePortToSlot = new HashMap<NodeInfo, WorkerSlot>();
            HashMap<WorkerSlot, WorkerResources> slotToResources = new HashMap<WorkerSlot, WorkerResources>();
            for (Map.Entry nodeAndResources : workerToResources.entrySet()) {
                NodeInfo info = (NodeInfo)nodeAndResources.getKey();
                WorkerResources resources = (WorkerResources)nodeAndResources.getValue();
                WorkerSlot slot = new WorkerSlot(info.get_node(), (Number)info.get_port_iterator().next());
                nodePortToSlot.put(info, slot);
                slotToResources.put(slot, resources);
            }
            HashMap<ExecutorDetails, WorkerSlot> execToSlot = new HashMap<ExecutorDetails, WorkerSlot>();
            for (Map.Entry execAndNodePort : execToNodePort.entrySet()) {
                List<Integer> exec = Nimbus.asIntExec((List)execAndNodePort.getKey());
                NodeInfo info = (NodeInfo)execAndNodePort.getValue();
                if (!aliveExecutors.contains(exec)) continue;
                execToSlot.put(new ExecutorDetails(exec.get(0), exec.get(1)), (WorkerSlot)nodePortToSlot.get(info));
            }
            ret.put(topoId, new SchedulerAssignmentImpl(topoId, execToSlot, slotToResources, null));
        }
        return ret;
    }

    private Map<String, SupervisorDetails> readAllSupervisorDetails(Map<String, Set<Long>> superToDeadPorts, Topologies topologies, Collection<String> missingAssignmentTopologies) {
        String superId;
        HashMap<String, SupervisorDetails> ret = new HashMap<String, SupervisorDetails>();
        IStormClusterState state = this.stormClusterState;
        Map superInfos = state.allSupervisorInfo();
        ArrayList<SupervisorDetails> superDetails = new ArrayList<SupervisorDetails>();
        for (Map.Entry entry : superInfos.entrySet()) {
            SupervisorInfo supervisorInfo = (SupervisorInfo)entry.getValue();
            superDetails.add(new SupervisorDetails((String)entry.getKey(), (Object)supervisorInfo.get_meta(), supervisorInfo.get_resources_map()));
        }
        HashMap<String, HashSet<Long>> superToPorts = new HashMap<String, HashSet<Long>>();
        for (WorkerSlot workerSlot : this.inimbus.allSlotsAvailableForScheduling(superDetails, topologies, new HashSet<String>(missingAssignmentTopologies))) {
            superId = workerSlot.getNodeId();
            HashSet<Long> ports = (HashSet<Long>)superToPorts.get(superId);
            if (ports == null) {
                ports = new HashSet<Long>();
                superToPorts.put(superId, ports);
            }
            ports.add(Long.valueOf(workerSlot.getPort()));
        }
        for (Map.Entry entry : superInfos.entrySet()) {
            superId = (String)entry.getKey();
            SupervisorInfo info = (SupervisorInfo)entry.getValue();
            String hostname = info.get_hostname();
            Set<Long> deadPorts = superToDeadPorts.get(superId);
            HashSet allPorts = (HashSet)superToPorts.get(superId);
            allPorts = allPorts == null ? new HashSet() : new HashSet(allPorts);
            if (deadPorts != null) {
                allPorts.removeAll(deadPorts);
            }
            ret.put(superId, new SupervisorDetails(superId, hostname, info.get_scheduler_meta(), allPorts, info.get_resources_map()));
        }
        return ret;
    }

    private boolean isFragmented(SupervisorResources supervisorResources) {
        double minMemory = ObjectReader.getDouble((Object)this.conf.get("topology.component.resources.onheap.memory.mb"), (Double)256.0) + ObjectReader.getDouble((Object)this.conf.get("topology.acker.resources.onheap.memory.mb"), (Double)128.0);
        double minCpu = ObjectReader.getDouble((Object)this.conf.get("topology.component.cpu.pcore.percent"), (Double)50.0) + ObjectReader.getDouble((Object)this.conf.get("topology.acker.cpu.pcore.percent"), (Double)50.0);
        return minMemory > supervisorResources.getAvailableMem() || minCpu > supervisorResources.getAvailableCpu();
    }

    private double fragmentedMemory() {
        Double res = this.nodeIdToResources.get().values().parallelStream().filter(this::isFragmented).mapToDouble(SupervisorResources::getAvailableMem).filter(x -> x > 0.0).sum();
        return res.intValue();
    }

    private int fragmentedCpu() {
        Double res = this.nodeIdToResources.get().values().parallelStream().filter(this::isFragmented).mapToDouble(SupervisorResources::getAvailableCpu).filter(x -> x > 0.0).sum();
        return res.intValue();
    }

    private Map<String, SchedulerAssignment> computeNewSchedulerAssignments(Map<String, Assignment> existingAssignments, Topologies topologies, Map<String, StormBase> bases, String scratchTopologyId) throws KeyNotFoundException, AuthorizationException, InvalidTopologyException, IOException {
        Map<String, Set<List<Integer>>> topoToExec = this.computeTopologyToExecutors(bases);
        Set<String> zkHeartbeatTopologies = topologies.getTopologies().stream().filter(topo -> !this.supportRpcHeartbeat((TopologyDetails)topo)).map(TopologyDetails::getId).collect(Collectors.toSet());
        this.updateAllHeartbeats(existingAssignments, topoToExec, zkHeartbeatTopologies);
        Map<String, Set<List<Integer>>> topoToAliveExecutors = this.computeTopologyToAliveExecutors(existingAssignments, topoToExec, scratchTopologyId);
        Map<String, Set<Long>> supervisorToDeadPorts = this.computeSupervisorToDeadPorts(existingAssignments, topoToExec, topoToAliveExecutors);
        Map<String, SchedulerAssignmentImpl> topoToSchedAssignment = this.computeTopologyToSchedulerAssignment(existingAssignments, topoToAliveExecutors);
        HashSet<String> missingAssignmentTopologies = new HashSet<String>();
        for (TopologyDetails topo2 : topologies.getTopologies()) {
            String id = topo2.getId();
            Set<List<Integer>> allExecs = topoToExec.get(id);
            Set<List<Integer>> aliveExecs = topoToAliveExecutors.get(id);
            int numDesiredWorkers = topo2.getNumWorkers();
            int numAssignedWorkers = Nimbus.numUsedWorkers(topoToSchedAssignment.get(id));
            if (allExecs != null && !allExecs.isEmpty() && allExecs.equals(aliveExecs) && numDesiredWorkers <= numAssignedWorkers) continue;
            missingAssignmentTopologies.add(id);
        }
        Map<String, SupervisorDetails> supervisors = this.readAllSupervisorDetails(supervisorToDeadPorts, topologies, missingAssignmentTopologies);
        Cluster cluster = new Cluster(this.inimbus, this.resourceMetrics, supervisors, topoToSchedAssignment, topologies, this.conf);
        cluster.setStatusMap(this.idToSchedStatus.get());
        this.schedulingStartTimeNs.set(Time.nanoTime());
        this.scheduler.schedule(topologies, cluster);
        Long startTime = this.schedulingStartTimeNs.getAndSet(null);
        long elapsedNs = Time.nanoTime() - startTime;
        this.longestSchedulingTime.accumulateAndGet(elapsedNs, Math::max);
        this.schedulingDuration.update(elapsedNs, TimeUnit.NANOSECONDS);
        LOG.debug("Scheduling took {} ms for {} topologies", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNs), (Object)topologies.getTopologies().size());
        this.idToSchedStatus.set(Utils.merge(this.idToSchedStatus.get(), cluster.getStatusMap()));
        this.nodeIdToResources.set(cluster.getSupervisorsResourcesMap());
        Map<String, TopologyResources> resources = cluster.getTopologyResourcesMap();
        this.idToResources.getAndAccumulate(resources, (orig, update) -> Utils.merge((Map)orig, (Map)update));
        HashMap workerResources = new HashMap();
        for (Map.Entry<String, Map<WorkerSlot, WorkerResources>> uglyWorkerResources : cluster.getWorkerResourcesMap().entrySet()) {
            HashMap<WorkerSlot, WorkerResources> slotToResources = new HashMap<WorkerSlot, WorkerResources>();
            for (Map.Entry<WorkerSlot, WorkerResources> uglySlotToResources : uglyWorkerResources.getValue().entrySet()) {
                WorkerResources wr = uglySlotToResources.getValue();
                slotToResources.put(uglySlotToResources.getKey(), wr);
            }
            workerResources.put(uglyWorkerResources.getKey(), slotToResources);
        }
        this.idToWorkerResources.getAndAccumulate(workerResources, (orig, update) -> Utils.merge((Map)orig, (Map)update));
        return cluster.getAssignments();
    }

    private boolean supportRpcHeartbeat(TopologyDetails topo) {
        if (this.stormClusterState.isPacemakerStateStore()) {
            return false;
        }
        if (!topo.getTopology().is_set_storm_version()) {
            return true;
        }
        String stormVersionStr = topo.getTopology().get_storm_version();
        SimpleVersion stormVersion = new SimpleVersion(stormVersionStr);
        return stormVersion.compareTo(MIN_VERSION_SUPPORT_RPC_HEARTBEAT) >= 0;
    }

    private TopologyResources getResourcesForTopology(String topoId, StormBase base) throws NotAliveException, AuthorizationException, InvalidTopologyException, IOException {
        TopologyResources ret = this.idToResources.get().get(topoId);
        if (ret == null) {
            try {
                IStormClusterState state = this.stormClusterState;
                TopologyDetails details = this.readTopologyDetails(topoId, base);
                Assignment assignment = state.assignmentInfo(topoId, null);
                ret = new TopologyResources(details, assignment);
            }
            catch (KeyNotFoundException e) {
                LOG.error("Failed to get topology details", (Throwable)e);
                ret = new TopologyResources();
            }
        }
        return ret;
    }

    private Map<WorkerSlot, WorkerResources> getWorkerResourcesForTopology(String topoId) {
        Map<WorkerSlot, WorkerResources> ret = this.idToWorkerResources.get().get(topoId);
        if (ret == null) {
            IStormClusterState state = this.stormClusterState;
            ret = new HashMap<WorkerSlot, WorkerResources>();
            Assignment assignment = state.assignmentInfo(topoId, null);
            if (assignment != null && assignment.is_set_worker_resources()) {
                for (Map.Entry entry : assignment.get_worker_resources().entrySet()) {
                    NodeInfo ni = (NodeInfo)entry.getKey();
                    WorkerSlot slot = new WorkerSlot(ni.get_node(), (Number)ni.get_port_iterator().next());
                    ret.put(slot, (WorkerResources)entry.getValue());
                }
                this.idToWorkerResources.getAndUpdate(new Assoc<String, Map<WorkerSlot, WorkerResources>>(topoId, ret));
            }
        }
        return ret;
    }

    private boolean isReadyForMKAssignments() throws Exception {
        if (this.isLeader()) {
            if (this.isHeartbeatsRecovered()) {
                if (this.isAssignmentsRecovered()) {
                    return true;
                }
                LOG.warn("waiting for assignments recovery, skipping assignments");
            }
            LOG.warn("waiting for worker heartbeats recovery, skipping assignments");
        } else {
            LOG.info("not a leader, skipping assignments");
        }
        return false;
    }

    private void mkAssignments() throws Exception {
        this.mkAssignments(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkAssignments(String scratchTopoId) throws Exception {
        try {
            Map bases;
            if (!this.isReadyForMKAssignments()) {
                return;
            }
            IStormClusterState state = this.stormClusterState;
            HashMap<String, TopologyDetails> tds = new HashMap<String, TopologyDetails>();
            Object object = this.submitLock;
            synchronized (object) {
                bases = state.topologyBases();
                Iterator it = bases.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String id = (String)entry.getKey();
                    StormBase base = (StormBase)entry.getValue();
                    try {
                        tds.put(id, this.readTopologyDetails(id, base));
                    }
                    catch (KeyNotFoundException e) {
                        it.remove();
                    }
                }
            }
            List assignedTopologyIds = state.assignments(null);
            HashMap<String, Assignment> existingAssignments = new HashMap<String, Assignment>();
            for (String id : assignedTopologyIds) {
                TopologyDetails td;
                if (id.equals(scratchTopoId)) continue;
                Assignment currentAssignment = state.assignmentInfo(id, null);
                if (!currentAssignment.is_set_owner() && (td = (TopologyDetails)tds.get(id)) != null) {
                    currentAssignment.set_owner(td.getTopologySubmitter());
                    state.setAssignment(id, currentAssignment, td.getConf());
                }
                existingAssignments.put(id, currentAssignment);
            }
            this.lockingMkAssignments(existingAssignments, bases, scratchTopoId, assignedTopologyIds, state, tds);
        }
        catch (Exception e) {
            this.mkAssignmentsErrors.mark();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void lockingMkAssignments(Map<String, Assignment> existingAssignments, Map<String, StormBase> bases, String scratchTopoId, List<String> assignedTopologyIds, IStormClusterState state, Map<String, TopologyDetails> tds) throws Exception {
        Topologies topologies = new Topologies(tds);
        Object object = this.schedLock;
        synchronized (object) {
            Assignment existingAssignment;
            Map<String, SchedulerAssignment> newSchedulerAssignments = this.computeNewSchedulerAssignments(existingAssignments, topologies, bases, scratchTopoId);
            Map<String, Map<List<Long>, List<Object>>> topologyToExecutorToNodePort = Nimbus.computeTopoToExecToNodePort(newSchedulerAssignments, assignedTopologyIds);
            Map<String, Map<WorkerSlot, WorkerResources>> newAssignedWorkerToResources = Nimbus.computeTopoToNodePortToResources(newSchedulerAssignments);
            int nowSecs = Time.currentTimeSecs();
            Map<String, SupervisorDetails> basicSupervisorDetailsMap = Nimbus.basicSupervisorDetailsMap(state);
            HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
            for (Map.Entry<String, Map<List<Long>, List<Object>>> entry : topologyToExecutorToNodePort.entrySet()) {
                void var18_25;
                String string = entry.getKey();
                Map<List<Long>, List<Object>> map = entry.getValue();
                if (map == null) {
                    HashMap hashMap = new HashMap();
                }
                HashSet<String> allNodes = new HashSet<String>();
                for (List nodePort : var18_25.values()) {
                    allNodes.add((String)nodePort.get(0));
                }
                HashMap<String, String> allNodeHost = new HashMap<String, String>();
                existingAssignment = existingAssignments.get(string);
                if (existingAssignment != null) {
                    allNodeHost.putAll(existingAssignment.get_node_host());
                }
                for (String node : allNodes) {
                    String host = this.inimbus.getHostName(basicSupervisorDetailsMap, node);
                    if (host == null) continue;
                    allNodeHost.put(node, host);
                }
                Map execNodeInfo = null;
                if (existingAssignment != null) {
                    execNodeInfo = existingAssignment.get_executor_node_port();
                }
                List<List<Long>> reassignExecutors = Nimbus.changedExecutors(execNodeInfo, (Map<List<Long>, List<Object>>)var18_25);
                HashMap<List<Long>, Long> startTimes = new HashMap<List<Long>, Long>();
                if (existingAssignment != null) {
                    startTimes.putAll(existingAssignment.get_executor_start_time_secs());
                }
                for (List<Long> id : reassignExecutors) {
                    startTimes.put(id, Long.valueOf(nowSecs));
                }
                Map<WorkerSlot, WorkerResources> workerToResources = newAssignedWorkerToResources.get(string);
                if (workerToResources == null) {
                    workerToResources = new HashMap<WorkerSlot, WorkerResources>();
                }
                Assignment newAssignment = new Assignment((String)this.conf.get("storm.local.dir"));
                HashMap justAssignedKeys = new HashMap(allNodeHost);
                justAssignedKeys.keySet().retainAll(allNodes);
                newAssignment.set_node_host(justAssignedKeys);
                HashMap execToNodeInfo = new HashMap();
                for (Map.Entry entry2 : var18_25.entrySet()) {
                    List nodePort = (List)entry2.getValue();
                    NodeInfo ni = new NodeInfo();
                    ni.set_node((String)nodePort.get(0));
                    ni.add_to_port(((Long)nodePort.get(1)).longValue());
                    execToNodeInfo.put(entry2.getKey(), ni);
                }
                newAssignment.set_executor_node_port(execToNodeInfo);
                newAssignment.set_executor_start_time_secs(startTimes);
                HashMap<NodeInfo, WorkerResources> workerResources = new HashMap<NodeInfo, WorkerResources>();
                for (Map.Entry<WorkerSlot, WorkerResources> wr : workerToResources.entrySet()) {
                    WorkerSlot nodePort = wr.getKey();
                    NodeInfo ni = new NodeInfo();
                    ni.set_node(nodePort.getNodeId());
                    ni.add_to_port((long)nodePort.getPort());
                    WorkerResources resources = wr.getValue();
                    workerResources.put(ni, resources);
                }
                newAssignment.set_worker_resources(workerResources);
                TopologyDetails topologyDetails = tds.get(string);
                newAssignment.set_owner(topologyDetails.getTopologySubmitter());
                newAssignments.put(string, newAssignment);
            }
            boolean assignmentChanged = this.auditAssignmentChanges(existingAssignments, newAssignments);
            if (assignmentChanged) {
                LOG.debug("RESETTING id->resources and id->worker-resources cache!");
                this.idToResources.set(new HashMap());
                this.idToWorkerResources.set(new HashMap());
            }
            for (Map.Entry entry : newAssignments.entrySet()) {
                String string = (String)entry.getKey();
                Assignment assignment = (Assignment)entry.getValue();
                Assignment existingAssignment2 = existingAssignments.get(string);
                TopologyDetails td = topologies.getById(string);
                if (assignment.equals(existingAssignment2)) {
                    LOG.debug("Assignment for {} hasn't changed", (Object)string);
                    continue;
                }
                LOG.info("Setting new assignment for topology id {}: {}", (Object)string, (Object)assignment);
                state.setAssignment(string, assignment, td.getConf());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry entry : newAssignments.entrySet()) {
                String topoId = (String)entry.getKey();
                Assignment assignment = (Assignment)entry.getValue();
                existingAssignment = existingAssignments.get(topoId);
                hashMap.putAll(Nimbus.assignmentChangedNodes(existingAssignment, assignment));
            }
            Nimbus.notifySupervisorsAssignments(newAssignments, this.assignmentsDistributer, hashMap, basicSupervisorDetailsMap, this.getMetricsRegistry());
            HashMap<String, Collection<WorkerSlot>> hashMap2 = new HashMap<String, Collection<WorkerSlot>>();
            for (Map.Entry entry : newAssignments.entrySet()) {
                String topoId = (String)entry.getKey();
                Assignment assignment = (Assignment)entry.getValue();
                Assignment existingAssignment3 = existingAssignments.get(topoId);
                if (existingAssignment3 == null) {
                    existingAssignment3 = new Assignment();
                    existingAssignment3.set_executor_node_port(new HashMap());
                    existingAssignment3.set_executor_start_time_secs(new HashMap());
                }
                Set<WorkerSlot> newSlots = Nimbus.newlyAddedSlots(existingAssignment3, assignment);
                hashMap2.put(topoId, newSlots);
            }
            this.inimbus.assignSlots(topologies, hashMap2);
        }
    }

    private void notifyTopologyActionListener(String topoId, String action) {
        ITopologyActionNotifierPlugin notifier = this.nimbusTopologyActionNotifier;
        if (notifier != null) {
            try {
                notifier.notify(topoId, action);
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception from Topology action notifier for storm-Id {}", (Object)topoId, (Object)e);
            }
        }
    }

    private void fixupBase(StormBase base, Map<String, Object> topoConf) {
        base.set_owner((String)topoConf.get("topology.submitter.user"));
        base.set_principal((String)topoConf.get("topology.submitter.principal"));
    }

    private int getTopologyHeartbeatTimeoutSecs(Map<String, Object> topoConf) {
        int defaultNimbusTimeout = ObjectReader.getInt((Object)this.conf.get("nimbus.task.timeout.secs"));
        if (topoConf.containsKey("topology.worker.timeout.secs")) {
            int topoTimeout = ObjectReader.getInt((Object)topoConf.get("topology.worker.timeout.secs"));
            topoTimeout = Math.max(topoTimeout, defaultNimbusTimeout);
            return topoTimeout;
        }
        return defaultNimbusTimeout;
    }

    private int getTopologyHeartbeatTimeoutSecs(String topoId) {
        try {
            Map<String, Object> topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            return this.getTopologyHeartbeatTimeoutSecs(topoConf);
        }
        catch (Exception e) {
            LOG.warn("Exception when getting heartbeat timeout.", (Object)e.getMessage());
            return ObjectReader.getInt((Object)this.conf.get("nimbus.task.timeout.secs"));
        }
    }

    private int getTopologyLaunchHeartbeatTimeoutSec(String topoId) {
        int nimbusLaunchTimeout = ObjectReader.getInt((Object)this.conf.get("nimbus.task.launch.secs"));
        int topoHeartbeatTimeoutSecs = this.getTopologyHeartbeatTimeoutSecs(topoId);
        return Math.max(nimbusLaunchTimeout, topoHeartbeatTimeoutSecs);
    }

    private void startTopology(String topoName, String topoId, TopologyStatus initStatus, String owner, String principal, Map<String, Object> topoConf, StormTopology stormTopology) throws InvalidTopologyException {
        assert (TopologyStatus.ACTIVE == initStatus || TopologyStatus.INACTIVE == initStatus);
        HashMap numExecutors = new HashMap();
        StormTopology topology = StormCommon.systemTopology(topoConf, (StormTopology)stormTopology);
        for (Map.Entry entry : StormCommon.allComponents((StormTopology)topology).entrySet()) {
            numExecutors.put(entry.getKey(), StormCommon.numStartExecutors(entry.getValue()));
        }
        LOG.info("Activating {}: {}", (Object)topoName, (Object)topoId);
        StormBase base = new StormBase();
        base.set_name(topoName);
        if (topoConf.containsKey("topology.version")) {
            base.set_topology_version(ObjectReader.getString((Object)topoConf.get("topology.version")));
        }
        base.set_launch_time_secs(Time.currentTimeSecs());
        base.set_status(initStatus);
        base.set_num_workers(ObjectReader.getInt((Object)topoConf.get("topology.workers"), (Integer)0).intValue());
        base.set_component_executors(numExecutors);
        base.set_owner(owner);
        base.set_principal(principal);
        base.set_component_debug(new HashMap());
        IStormClusterState state = this.stormClusterState;
        state.activateStorm(topoId, base, topoConf);
        this.idToExecutors.getAndUpdate(new Assoc<String, HashSet<List<Integer>>>(topoId, new HashSet<List<Integer>>(this.computeExecutors(base, topoConf, stormTopology))));
        this.notifyTopologyActionListener(topoName, "activate");
    }

    private void assertTopoActive(String topoName, boolean expectActive) throws NotAliveException, AlreadyAliveException {
        if (Nimbus.isTopologyActive(this.stormClusterState, topoName) != expectActive) {
            if (expectActive) {
                throw new WrappedNotAliveException(topoName + " is not alive");
            }
            throw new WrappedAlreadyAliveException(topoName + " is already alive");
        }
    }

    private Map<String, Object> tryReadTopoConfFromName(String topoName) throws NotAliveException, AuthorizationException, IOException {
        return Nimbus.tryReadTopoConf(this.toTopoId(topoName), this.topoCache);
    }

    private StormTopology tryReadTopologyFromName(String topoName) throws NotAliveException, AuthorizationException, IOException {
        return Nimbus.tryReadTopology(this.toTopoId(topoName), this.topoCache);
    }

    @VisibleForTesting
    public void checkAuthorization(String topoName, Map<String, Object> topoConf, String operation) throws AuthorizationException {
        this.checkAuthorization(topoName, topoConf, operation, null);
    }

    @VisibleForTesting
    public void checkAuthorization(String topoName, Map<String, Object> topoConf, String operation, ReqContext context) throws AuthorizationException {
        IAuthorizer aclHandler;
        IAuthorizer impersonationAuthorizer = this.impersonationAuthorizationHandler;
        if (context == null) {
            context = ReqContext.context();
        }
        HashMap<String, Object> checkConf = new HashMap<String, Object>();
        if (topoConf != null) {
            checkConf.putAll(topoConf);
        } else if (topoName != null) {
            checkConf.put("topology.name", topoName);
        }
        if (context.isImpersonating()) {
            LOG.info("principal: {} is trying to impersonate principal: {}", (Object)context.realPrincipal(), (Object)context.principal());
            if (impersonationAuthorizer == null) {
                LOG.warn("impersonation attempt but {} has no authorizer configured. potential security risk, please see SECURITY.MD to learn how to configure impersonation authorizer.", (Object)"nimbus.impersonation.authorizer");
            } else if (!impersonationAuthorizer.permit(context, operation, checkConf)) {
                ThriftAccessLogger.logAccess(context.requestID(), context.remoteAddress(), context.principal(), operation, topoName, "access-denied");
                throw new WrappedAuthorizationException("principal " + context.realPrincipal() + " is not authorized to impersonate principal " + context.principal() + " from host " + context.remoteAddress() + " Please see SECURITY.MD to learn how to configure impersonation acls.");
            }
        }
        if ((aclHandler = this.authorizationHandler) != null) {
            if (!aclHandler.permit(context, operation, checkConf)) {
                ThriftAccessLogger.logAccess(context.requestID(), context.remoteAddress(), context.principal(), operation, topoName, "access-denied");
                throw new WrappedAuthorizationException(operation + (topoName != null ? " on topology " + topoName : "") + " is not authorized");
            }
            ThriftAccessLogger.logAccess(context.requestID(), context.remoteAddress(), context.principal(), operation, topoName, "access-granted");
        }
    }

    private boolean isAuthorized(String operation, String topoId) throws NotAliveException, AuthorizationException, IOException {
        Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
        topoConf = Utils.merge(this.conf, topoConf);
        String topoName = (String)topoConf.get("topology.name");
        try {
            this.checkAuthorization(topoName, topoConf, operation);
            return true;
        }
        catch (AuthorizationException e) {
            return false;
        }
    }

    @VisibleForTesting
    public Set<String> filterAuthorized(String operation, Collection<String> topoIds) throws NotAliveException, AuthorizationException, IOException {
        HashSet<String> ret = new HashSet<String>();
        for (String topoId : topoIds) {
            if (!this.isAuthorized(operation, topoId)) continue;
            ret.add(topoId);
        }
        return ret;
    }

    @VisibleForTesting
    public void rmDependencyJarsInTopology(String topoId) {
        try {
            BlobStore store = this.blobStore;
            IStormClusterState state = this.stormClusterState;
            StormTopology topo = Nimbus.readStormTopologyAsNimbus(topoId, this.topoCache);
            List dependencyJars = topo.get_dependency_jars();
            LOG.info("Removing dependency jars from blobs - {}", (Object)dependencyJars);
            if (dependencyJars != null && !dependencyJars.isEmpty()) {
                for (String key : dependencyJars) {
                    Nimbus.rmBlobKey(store, key, state);
                }
            }
        }
        catch (Exception e) {
            LOG.info("Exception {}", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void rmTopologyKeys(String topoId) {
        BlobStore store = this.blobStore;
        IStormClusterState state = this.stormClusterState;
        try {
            this.topoCache.deleteTopoConf(topoId, NIMBUS_SUBJECT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.topoCache.deleteTopology(topoId, NIMBUS_SUBJECT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Nimbus.rmBlobKey(store, ConfigUtils.masterStormJarKey((String)topoId), state);
    }

    @VisibleForTesting
    public void forceDeleteTopoDistDir(String topoId) throws IOException {
        Utils.forceDelete((String)ServerConfigUtils.masterStormDistRoot(this.conf, topoId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doCleanup() throws Exception {
        Set<String> toClean;
        if (!this.isLeader()) {
            LOG.info("not a leader, skipping cleanup");
            return;
        }
        IStormClusterState state = this.stormClusterState;
        Iterator<String> iterator = this.submitLock;
        synchronized (iterator) {
            toClean = Nimbus.topoIdsToClean(state, this.blobStore, this.conf);
        }
        if (toClean != null) {
            for (String topoId : toClean) {
                LOG.info("Cleaning up {}", (Object)topoId);
                state.teardownHeartbeats(topoId);
                state.teardownTopologyErrors(topoId);
                state.removeAllPrivateWorkerKeys(topoId);
                state.removeBackpressure(topoId);
                this.rmDependencyJarsInTopology(topoId);
                this.forceDeleteTopoDistDir(topoId);
                this.rmTopologyKeys(topoId);
                this.heartbeatsCache.removeTopo(topoId);
                this.idToExecutors.getAndUpdate(new Dissoc(topoId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTopologyHistory(int mins) {
        int cutoffAgeSecs = Time.currentTimeSecs() - mins * 60;
        Object object = this.topologyHistoryLock;
        synchronized (object) {
            LocalState state = this.topologyHistoryState;
            state.filterOldTopologies((long)cutoffAgeSecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTopoToHistoryLog(String topoId, Map<String, Object> topoConf) {
        LOG.info("Adding topo to history log: {}", (Object)topoId);
        LocalState state = this.topologyHistoryState;
        List<String> users = ServerConfigUtils.getTopoLogsUsers(topoConf);
        List<String> groups = ServerConfigUtils.getTopoLogsGroups(topoConf);
        Object object = this.topologyHistoryLock;
        synchronized (object) {
            state.addTopologyHistory(new LSTopoHistory(topoId, (long)Time.currentTimeSecs(), users, groups));
        }
    }

    private Set<String> userGroups(String user) throws IOException {
        if (user == null || user.isEmpty()) {
            return Collections.emptySet();
        }
        return this.groupMapper.getGroups(user);
    }

    private boolean isUserPartOf(String user, Collection<String> groupsToCheck) throws IOException {
        HashSet<String> userGroups = new HashSet<String>(this.userGroups(user));
        userGroups.retainAll(groupsToCheck);
        return !userGroups.isEmpty();
    }

    private List<String> readTopologyHistory(String user, Collection<String> adminUsers) throws IOException {
        LocalState state = this.topologyHistoryState;
        List topoHistoryList = state.getTopoHistoryList();
        if (topoHistoryList == null || topoHistoryList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (LSTopoHistory history : topoHistoryList) {
            if (user != null && !adminUsers.contains(user) && !this.isUserPartOf(user, history.get_groups()) && !history.get_users().contains(user)) continue;
            ret.add(history.get_topology_id());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewCredentials() throws Exception {
        if (!this.isLeader()) {
            LOG.info("not a leader, skipping credential renewal.");
            return;
        }
        IStormClusterState state = this.stormClusterState;
        Collection<ICredentialsRenewer> renewers = this.credRenewers;
        Map assignedBases = state.topologyBases();
        if (assignedBases != null) {
            for (Map.Entry entry : assignedBases.entrySet()) {
                String id = (String)entry.getKey();
                String ownerPrincipal = ((StormBase)entry.getValue()).get_principal();
                Map topoConf = Collections.unmodifiableMap(Utils.merge(this.conf, Nimbus.tryReadTopoConf(id, this.topoCache)));
                Object object = this.credUpdateLock;
                synchronized (object) {
                    Credentials origCreds = state.credentials(id, null);
                    if (origCreds != null) {
                        Map origCredsMap = origCreds.get_creds();
                        HashMap<String, String> newCredsMap = new HashMap<String, String>(origCredsMap);
                        for (ICredentialsRenewer renewer : renewers) {
                            LOG.info("Renewing Creds For {} with {} owned by {}", new Object[]{id, renewer, ownerPrincipal});
                            renewer.renew(newCredsMap, topoConf, ownerPrincipal);
                        }
                        this.upsertWorkerTokensInCreds(newCredsMap, ownerPrincipal, id);
                        if (!newCredsMap.equals(origCredsMap)) {
                            state.setCredentials(id, new Credentials(newCredsMap), topoConf);
                        }
                    }
                }
            }
        }
    }

    private SupervisorSummary makeSupervisorSummary(String supervisorId, SupervisorInfo info) {
        Set<Object> blacklistedSupervisorIds = Collections.emptySet();
        if (this.scheduler instanceof BlacklistScheduler) {
            BlacklistScheduler bs = (BlacklistScheduler)this.scheduler;
            blacklistedSupervisorIds = bs.getBlacklistSupervisorIds();
        }
        LOG.debug("INFO: {} ID: {}", (Object)info, (Object)supervisorId);
        int numPorts = 0;
        if (info.is_set_meta()) {
            numPorts = info.get_meta_size();
        }
        int numUsedPorts = 0;
        if (info.is_set_used_ports()) {
            numUsedPorts = info.get_used_ports_size();
        }
        LOG.debug("NUM PORTS: {}", (Object)numPorts);
        SupervisorSummary ret = new SupervisorSummary(info.get_hostname(), (int)info.get_uptime_secs(), numPorts, numUsedPorts, supervisorId);
        ret.set_total_resources(info.get_resources_map());
        SupervisorResources resources = this.nodeIdToResources.get().get(supervisorId);
        if (resources != null && this.underlyingScheduler instanceof ResourceAwareScheduler) {
            ret.set_used_mem(resources.getUsedMem());
            ret.set_used_cpu(resources.getUsedCpu());
            ret.set_used_generic_resources(resources.getUsedGenericResources());
            if (this.isFragmented(resources)) {
                double availableCpu = resources.getAvailableCpu();
                if (availableCpu < 0.0) {
                    LOG.warn("Negative fragmented CPU on {}", (Object)supervisorId);
                }
                ret.set_fragmented_cpu(availableCpu);
                double availableMem = resources.getAvailableMem();
                if (availableMem < 0.0) {
                    LOG.warn("Negative fragmented Mem on {}", (Object)supervisorId);
                }
                ret.set_fragmented_mem(availableMem);
            }
        }
        if (info.is_set_version()) {
            ret.set_version(info.get_version());
        }
        if (blacklistedSupervisorIds.contains(supervisorId)) {
            ret.set_blacklisted(true);
        } else {
            ret.set_blacklisted(false);
        }
        return ret;
    }

    private ClusterSummary getClusterInfoImpl() throws Exception {
        IStormClusterState state = this.stormClusterState;
        Map infos = state.allSupervisorInfo();
        ArrayList<SupervisorSummary> summaries = new ArrayList<SupervisorSummary>(infos.size());
        for (Map.Entry entry : infos.entrySet()) {
            summaries.add(this.makeSupervisorSummary((String)entry.getKey(), (SupervisorInfo)entry.getValue()));
        }
        int uptime = this.uptime.upTime();
        List nimbuses = state.nimbuses();
        NimbusInfo leader = this.leaderElector.getLeader();
        for (NimbusSummary nimbusSummary : nimbuses) {
            boolean isLeader;
            nimbusSummary.set_uptime_secs(Time.deltaSecs((int)nimbusSummary.get_uptime_secs()));
            boolean bl = isLeader = leader.getHost().equals(nimbusSummary.get_host()) && leader.getPort() == nimbusSummary.get_port();
            if (isLeader && this.nimbusHostPortInfo.getHost().equals(leader.getHost()) && !this.isLeader()) {
                isLeader = false;
            }
            nimbusSummary.set_isLeader(isLeader);
        }
        List<TopologySummary> topologySummaries = this.getTopologySummariesImpl();
        ClusterSummary ret = new ClusterSummary(summaries, topologySummaries, nimbuses);
        return ret;
    }

    private List<TopologySummary> getTopologySummariesImpl() throws IOException, TException {
        IStormClusterState state = this.stormClusterState;
        ArrayList<TopologySummary> topologySummaries = new ArrayList<TopologySummary>();
        Map bases = state.topologyBases();
        for (Map.Entry entry : bases.entrySet()) {
            StormBase base = (StormBase)entry.getValue();
            if (base == null) continue;
            String topoId = (String)entry.getKey();
            TopologySummary summary = this.getTopologySummaryImpl(topoId, base);
            topologySummaries.add(summary);
        }
        return topologySummaries;
    }

    private TopologySummary getTopologySummaryImpl(String topoId, StormBase base) throws IOException, TException {
        TopologyResources resources;
        String status;
        IStormClusterState state = this.stormClusterState;
        Assignment assignment = state.assignmentInfo(topoId, null);
        int numTasks = 0;
        int numExecutors = 0;
        int numWorkers = 0;
        if (assignment != null && assignment.is_set_executor_node_port()) {
            for (List ids : assignment.get_executor_node_port().keySet()) {
                numTasks += StormCommon.executorIdToTasks((List)ids).size();
            }
            numExecutors = assignment.get_executor_node_port_size();
            numWorkers = new HashSet(assignment.get_executor_node_port().values()).size();
        }
        TopologySummary summary = new TopologySummary(topoId, base.get_name(), numTasks, numExecutors, numWorkers, Time.deltaSecs((int)base.get_launch_time_secs()), Nimbus.extractStatusStr(base));
        try {
            StormTopology topo = Nimbus.tryReadTopology(topoId, this.topoCache);
            if (topo != null && topo.is_set_storm_version()) {
                summary.set_storm_version(topo.get_storm_version());
            }
        }
        catch (NotAliveException topo) {
            // empty catch block
        }
        if (base.is_set_owner()) {
            summary.set_owner(base.get_owner());
        }
        if (base.is_set_topology_version()) {
            summary.set_topology_version(base.get_topology_version());
        }
        if ((status = this.idToSchedStatus.get().get(topoId)) != null) {
            summary.set_sched_status(status);
        }
        if ((resources = this.getResourcesForTopology(topoId, base)) != null) {
            summary.set_requested_memonheap(resources.getRequestedMemOnHeap());
            summary.set_requested_memoffheap(resources.getRequestedMemOffHeap());
            summary.set_requested_cpu(resources.getRequestedCpu());
            summary.set_requested_generic_resources(resources.getRequestedGenericResources());
            summary.set_assigned_memonheap(resources.getAssignedMemOnHeap());
            summary.set_assigned_memoffheap(resources.getAssignedMemOffHeap());
            summary.set_assigned_cpu(resources.getAssignedCpu());
            summary.set_assigned_generic_resources(resources.getAssignedGenericResources());
        }
        try {
            summary.set_replication_count(this.getBlobReplicationCount(ConfigUtils.masterStormCodeKey((String)topoId)).intValue());
        }
        catch (Exception e) {
            LOG.error("Unable to find blob entry", (Throwable)e);
        }
        return summary;
    }

    private void sendClusterMetricsToExecutors() throws Exception {
        IClusterMetricsConsumer.ClusterInfo clusterInfo = Nimbus.mkClusterInfo();
        ClusterSummary clusterSummary = this.getClusterInfoImpl();
        List<DataPoint> clusterMetrics = Nimbus.extractClusterMetrics(clusterSummary);
        Map<IClusterMetricsConsumer.SupervisorInfo, List<DataPoint>> supervisorMetrics = Nimbus.extractSupervisorMetrics(clusterSummary);
        for (ClusterMetricsConsumerExecutor consumerExecutor : this.clusterConsumerExceutors) {
            consumerExecutor.handleDataPoints(clusterInfo, clusterMetrics);
            for (Map.Entry<IClusterMetricsConsumer.SupervisorInfo, List<DataPoint>> entry : supervisorMetrics.entrySet()) {
                consumerExecutor.handleDataPoints(entry.getKey(), (Collection<DataPoint>)entry.getValue());
            }
        }
    }

    private CommonTopoInfo getCommonTopoInfo(String topoId, String operation) throws NotAliveException, AuthorizationException, IOException, InvalidTopologyException {
        CommonTopoInfo ret = new CommonTopoInfo();
        ret.topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
        ret.topoName = (String)ret.topoConf.get("topology.name");
        this.checkAuthorization(ret.topoName, ret.topoConf, operation);
        StormTopology topology = Nimbus.tryReadTopology(topoId, this.topoCache);
        ret.topology = StormCommon.systemTopology(ret.topoConf, (StormTopology)topology);
        ret.taskToComponent = StormCommon.stormTaskInfo((StormTopology)topology, ret.topoConf);
        IStormClusterState state = this.stormClusterState;
        ret.base = state.stormBase(topoId, null);
        ret.launchTimeSecs = ret.base != null && ret.base.is_set_launch_time_secs() ? ret.base.get_launch_time_secs() : 0;
        ret.assignment = state.assignmentInfo(topoId, null);
        ret.beats = ret.assignment != null ? StatsUtil.convertExecutorBeats(state.executorBeats(topoId, ret.assignment.get_executor_node_port())) : Collections.emptyMap();
        ret.allComponents = new HashSet<String>(ret.taskToComponent.values());
        return ret;
    }

    @VisibleForTesting
    public boolean awaitLeadership(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.leaderElector.awaitLeadership(timeout, timeUnit);
    }

    public void submitTopology(String name, String uploadedJarLocation, String jsonConf, StormTopology topology) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, TException {
        this.submitTopologyCalls.mark();
        this.submitTopologyWithOpts(name, uploadedJarLocation, jsonConf, topology, new SubmitOptions(TopologyInitialStatus.ACTIVE));
    }

    private void upsertWorkerTokensInCreds(Map<String, String> creds, String user, String topologyId) {
        if (this.workerTokenManager != null) {
            this.workerTokenManager.upsertWorkerTokensInCredsForTopo(creds, user, topologyId);
        }
        this.stormClusterState.removeExpiredPrivateWorkerKeys(topologyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTopologyWithOpts(String topoName, String uploadedJarLocation, String jsonConf, StormTopology topology, SubmitOptions options) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException, TException {
        try {
            SimpleVersion topoVersion;
            List cp;
            String topoVersionString;
            Map blobMap;
            this.submitTopologyWithOptsCalls.mark();
            this.assertIsLeader();
            assert (options != null);
            Nimbus.validateTopologyName(topoName);
            this.checkAuthorization(topoName, null, "submitTopology");
            this.assertTopoActive(topoName, false);
            Map<String, Object> topoConf = (Map<String, Object>)JSONValue.parse((String)jsonConf);
            try {
                ConfigValidation.validateTopoConf((Map)topoConf);
            }
            catch (IllegalArgumentException ex) {
                throw new WrappedInvalidTopologyException(ex.getMessage());
            }
            this.validator.validate(topoName, topoConf, topology);
            if (((Boolean)this.conf.getOrDefault("storm.disable.symlinks", false)).booleanValue() && (blobMap = (Map)topoConf.get("topology.blobstore.map")) != null && !blobMap.isEmpty()) {
                throw new WrappedInvalidTopologyException("symlinks are disabled so blobs are not supported but topology.blobstore.map = " + blobMap);
            }
            ServerUtils.validateTopologyWorkerMaxHeapSizeConfigs(topoConf, topology, ObjectReader.getDouble((Object)this.conf.get("topology.worker.max.heap.size.mb")));
            Utils.validateTopologyBlobStoreMap((Map)topoConf, (BlobStore)this.blobStore);
            long uniqueNum = this.submittedCount.incrementAndGet();
            String topoId = topoName + "-" + uniqueNum + "-" + Time.currentTimeSecs();
            HashMap<String, String> creds = null;
            if (options.is_set_creds()) {
                creds = options.get_creds().get_creds();
            }
            topoConf.put("storm.id", topoId);
            topoConf.put("topology.name", topoName);
            topoConf = Nimbus.normalizeConf(this.conf, topoConf, topology);
            OciUtils.adjustImageConfigForTopo(this.conf, topoConf, topoId);
            ReqContext req = ReqContext.context();
            Principal principal = req.principal();
            String submitterPrincipal = principal == null ? null : principal.toString();
            HashSet<String> topoAcl = new HashSet<String>(ObjectReader.getStrings((Object)topoConf.get("topology.users")));
            topoAcl.add(submitterPrincipal);
            String submitterUser = this.principalToLocal.toLocal(principal);
            topoAcl.add(submitterUser);
            String topologyPrincipal = (String)Utils.OR((Object)submitterPrincipal, (Object)"");
            topoConf.put("topology.submitter.principal", topologyPrincipal);
            String systemUser = System.getProperty("user.name");
            String topologyOwner = (String)Utils.OR((Object)submitterUser, (Object)systemUser);
            topoConf.put("topology.submitter.user", topologyOwner);
            topoConf.put("topology.users", new ArrayList(topoAcl));
            topoConf.put("storm.zookeeper.superACL", this.conf.get("storm.zookeeper.superACL"));
            if (!Utils.isZkAuthenticationConfiguredStormServer(this.conf)) {
                topoConf.remove("storm.zookeeper.topology.auth.scheme");
                topoConf.remove("storm.zookeeper.topology.auth.payload");
            }
            if (!((Boolean)this.conf.getOrDefault("storm.topology.classpath.beginning.enabled", false)).booleanValue()) {
                topoConf.remove("topology.classpath.beginning");
            }
            if ((topoVersionString = topology.get_storm_version()) == null) {
                topoVersionString = (String)this.conf.getOrDefault("supervisor.worker.default.version", VersionInfo.getVersion());
            }
            if ((cp = (List)Utils.getCompatibleVersion(this.supervisorClasspaths, (SimpleVersion)(topoVersion = new SimpleVersion(topoVersionString)), (String)"classpath", null)) == null) {
                throw new WrappedInvalidTopologyException("Topology submitted with storm version " + topoVersionString + " but could not find a configured compatible version to use " + this.supervisorClasspaths.keySet());
            }
            Map otherConf = Utils.getConfigFromClasspath((List)cp, this.conf);
            Map totalConfToSave = Utils.merge((Map)otherConf, topoConf);
            Map totalConf = Utils.merge(this.conf, (Map)totalConfToSave);
            topology = Nimbus.normalizeTopology(totalConf, topology);
            if (ServerUtils.isRas(this.conf)) {
                int estimatedNumWorker = ServerUtils.getEstimatedWorkerCountForRasTopo(totalConf, topology);
                Nimbus.setUpAckerExecutorConfigs(topoName, totalConfToSave, totalConf, estimatedNumWorker);
                ServerUtils.validateTopologyAckerBundleResource(totalConfToSave, topology, topoName);
                int numEventLoggerExecs = ObjectReader.getInt(totalConf.get("topology.eventlogger.executors"), (Integer)estimatedNumWorker);
                totalConfToSave.put("topology.eventlogger.executors", numEventLoggerExecs);
                LOG.debug("Config {} set to: {} for topology: {}", new Object[]{"topology.eventlogger.executors", numEventLoggerExecs, topoName});
            }
            totalConfToSave.remove("storm.local.hostname");
            IStormClusterState state = this.stormClusterState;
            if (creds == null && this.workerTokenManager != null) {
                creds = new HashMap<String, String>();
            }
            if (creds != null) {
                Map<String, Object> finalConf = Collections.unmodifiableMap(topoConf);
                for (INimbusCredentialPlugin autocred : this.nimbusAutocredPlugins) {
                    autocred.populateCredentials(creds, finalConf);
                }
                this.upsertWorkerTokensInCreds(creds, topologyPrincipal, topoId);
            }
            if (ObjectReader.getBoolean((Object)this.conf.get("supervisor.run.worker.as.user"), (boolean)false) && (submitterUser == null || submitterUser.isEmpty())) {
                throw new WrappedAuthorizationException("Could not determine the user to run this topology as.");
            }
            StormCommon.systemTopology((Map)totalConf, (StormTopology)topology);
            Nimbus.validateTopologySize(topoConf, this.conf, topology);
            if (Utils.isZkAuthenticationConfiguredStormServer(this.conf) && !Utils.isZkAuthenticationConfiguredTopology(topoConf)) {
                throw new IllegalArgumentException("The cluster is configured for zookeeper authentication, but no payload was provided.");
            }
            LOG.info("Received topology submission for {} (storm-{} JDK-{}) with conf {}", new Object[]{topoName, topoVersionString, topology.get_jdk_version(), ConfigUtils.maskPasswords(topoConf)});
            Object object = this.submitLock;
            synchronized (object) {
                this.assertTopoActive(topoName, false);
                if (creds != null) {
                    state.setCredentials(topoId, new Credentials(creds), topoConf);
                }
                LOG.info("uploadedJar {} for {}", (Object)uploadedJarLocation, (Object)topoName);
                this.setupStormCode(this.conf, topoId, uploadedJarLocation, totalConfToSave, topology);
                this.waitForDesiredCodeReplication(totalConf, topoId);
                state.setupHeatbeats(topoId, topoConf);
                state.setupErrors(topoId, topoConf);
                if (ObjectReader.getBoolean(totalConf.get("topology.backpressure.enable"), (boolean)false)) {
                    state.setupBackpressure(topoId, topoConf);
                }
                this.notifyTopologyActionListener(topoName, "submitTopology");
                TopologyStatus status = null;
                switch (options.get_initial_status()) {
                    case INACTIVE: {
                        status = TopologyStatus.INACTIVE;
                        break;
                    }
                    case ACTIVE: {
                        status = TopologyStatus.ACTIVE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Inital Status of " + options.get_initial_status() + " is not allowed.");
                    }
                }
                this.startTopology(topoName, topoId, status, topologyOwner, topologyPrincipal, totalConfToSave, topology);
            }
        }
        catch (Exception e) {
            LOG.warn("Topology submission exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static void setUpAckerExecutorConfigs(String topoName, Map<String, Object> totalConfToSave, Map<String, Object> totalConf, int estimatedNumWorker) {
        int numAckerExecs;
        int numAckerExecsPerWorker;
        if (totalConf.get("topology.acker.executors") == null) {
            numAckerExecsPerWorker = ObjectReader.getInt((Object)totalConf.get("topology.ras.acker.executors.per.worker"));
            numAckerExecs = estimatedNumWorker * numAckerExecsPerWorker;
        } else {
            numAckerExecs = ObjectReader.getInt((Object)totalConf.get("topology.acker.executors"));
            numAckerExecsPerWorker = estimatedNumWorker == 0 ? 0 : (int)Math.ceil((double)numAckerExecs / (double)estimatedNumWorker);
        }
        totalConfToSave.put("topology.ras.acker.executors.per.worker", numAckerExecsPerWorker);
        totalConfToSave.put("topology.acker.executors", numAckerExecs);
        LOG.info("Config {} set to: {} for topology: {}", new Object[]{"topology.ras.acker.executors.per.worker", numAckerExecsPerWorker, topoName});
        LOG.info("Config {} set to: {} for topology: {}", new Object[]{"topology.acker.executors", numAckerExecs, topoName});
    }

    public void killTopology(String name) throws NotAliveException, AuthorizationException, TException {
        this.killTopologyCalls.mark();
        this.killTopologyWithOpts(name, new KillOptions());
    }

    public void killTopologyWithOpts(String topoName, KillOptions options) throws NotAliveException, AuthorizationException, TException {
        this.killTopologyWithOptsCalls.mark();
        this.assertTopoActive(topoName, true);
        try {
            Map topoConf = this.tryReadTopoConfFromName(topoName);
            topoConf = Utils.merge(this.conf, topoConf);
            String operation = "killTopology";
            this.checkAuthorization(topoName, topoConf, "killTopology");
            Integer waitAmount = null;
            if (options.is_set_wait_secs()) {
                waitAmount = options.get_wait_secs();
            }
            this.transitionName(topoName, TopologyActions.KILL, waitAmount, true);
            this.notifyTopologyActionListener(topoName, "killTopology");
            this.addTopoToHistoryLog((String)topoConf.get("storm.id"), topoConf);
        }
        catch (Exception e) {
            LOG.warn("Kill topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void activate(String topoName) throws NotAliveException, AuthorizationException, TException {
        this.activateCalls.mark();
        try {
            Map topoConf = this.tryReadTopoConfFromName(topoName);
            topoConf = Utils.merge(this.conf, topoConf);
            String operation = "activate";
            this.checkAuthorization(topoName, topoConf, "activate");
            this.transitionName(topoName, TopologyActions.ACTIVATE, null, true);
            this.notifyTopologyActionListener(topoName, "activate");
        }
        catch (Exception e) {
            LOG.warn("Activate topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void deactivate(String topoName) throws NotAliveException, AuthorizationException, TException {
        this.deactivateCalls.mark();
        try {
            Map topoConf = this.tryReadTopoConfFromName(topoName);
            topoConf = Utils.merge(this.conf, topoConf);
            String operation = "deactivate";
            this.checkAuthorization(topoName, topoConf, "deactivate");
            this.transitionName(topoName, TopologyActions.INACTIVATE, null, true);
            this.notifyTopologyActionListener(topoName, "deactivate");
        }
        catch (Exception e) {
            LOG.warn("Deactivate topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void rebalance(String topoName, RebalanceOptions options) throws NotAliveException, InvalidTopologyException, AuthorizationException, TException {
        this.rebalanceCalls.mark();
        this.assertTopoActive(topoName, true);
        try {
            Subject subject;
            Map topoConf = this.tryReadTopoConfFromName(topoName);
            topoConf = Utils.merge(this.conf, topoConf);
            String operation = "rebalance";
            this.checkAuthorization(topoName, topoConf, "rebalance");
            options.set_principal(null);
            StormTopology stormTopology = this.tryReadTopologyFromName(topoName);
            TreeSet comps = new TreeSet();
            comps.addAll(stormTopology.get_spouts().keySet());
            comps.addAll(stormTopology.get_bolts().keySet());
            Map execOverrides = options.is_set_num_executors() ? options.get_num_executors() : Collections.emptyMap();
            for (Map.Entry e : execOverrides.entrySet()) {
                String comp = (String)e.getKey();
                if (!Utils.isSystemId((String)comp) && !comps.contains(comp)) {
                    throw new WrappedInvalidTopologyException(String.format("Invalid component %s for topology %s, valid values are %s", comp, topoName, String.join((CharSequence)",", comps)));
                }
                Integer value = (Integer)e.getValue();
                if (value != null && value > 0) continue;
                throw new WrappedInvalidTopologyException("Number of executors must be greater than 0");
            }
            if (options.is_set_topology_conf_overrides()) {
                Map topoConfigOverrides = Utils.parseJson((String)options.get_topology_conf_overrides());
                topoConfigOverrides.remove("topology.submitter.principal");
                topoConfigOverrides.remove("topology.submitter.user");
                topoConfigOverrides.remove("storm.zookeeper.superACL");
                topoConfigOverrides.remove("storm.zookeeper.topology.auth.scheme");
                topoConfigOverrides.remove("storm.zookeeper.topology.auth.payload");
                if (((Boolean)this.conf.getOrDefault("storm.topology.classpath.beginning.enabled", false)).booleanValue()) {
                    topoConfigOverrides.remove("topology.classpath.beginning");
                }
                topoConfigOverrides.remove("storm.local.hostname");
                options.set_topology_conf_overrides(JSONValue.toJSONString((Object)topoConfigOverrides));
            }
            if ((subject = Nimbus.getSubject()) != null) {
                options.set_principal(subject.getPrincipals().iterator().next().getName());
            }
            this.transitionName(topoName, TopologyActions.REBALANCE, options, true);
            this.notifyTopologyActionListener(topoName, "rebalance");
        }
        catch (Exception e) {
            LOG.warn("rebalance topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void setLogConfig(String topoId, LogConfig config) throws TException {
        try {
            this.setLogConfigCalls.mark();
            Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "setLogConfig");
            IStormClusterState state = this.stormClusterState;
            LogConfig mergedLogConfig = state.topologyLogConfig(topoId, null);
            if (mergedLogConfig == null) {
                mergedLogConfig = new LogConfig();
            }
            if (mergedLogConfig.is_set_named_logger_level()) {
                Map namedLoggers = mergedLogConfig.get_named_logger_level();
                for (LogLevel level : namedLoggers.values()) {
                    level.set_action(LogLevelAction.UNCHANGED);
                }
            }
            if (config.is_set_named_logger_level()) {
                for (Map.Entry entry : config.get_named_logger_level().entrySet()) {
                    LogLevel logConfig = (LogLevel)entry.getValue();
                    String loggerName = (String)entry.getKey();
                    LogLevelAction action = logConfig.get_action();
                    if (loggerName.isEmpty()) {
                        throw new RuntimeException("Named loggers need a valid name. Use ROOT for the root logger");
                    }
                    switch (action) {
                        case UPDATE: {
                            Nimbus.setLoggerTimeouts(logConfig);
                            mergedLogConfig.put_to_named_logger_level(loggerName, logConfig);
                            break;
                        }
                        case REMOVE: {
                            Map nl = mergedLogConfig.get_named_logger_level();
                            if (nl == null) break;
                            nl.remove(loggerName);
                            break;
                        }
                    }
                }
            }
            LOG.info("Setting log config for {}:{}", (Object)topoName, (Object)mergedLogConfig);
            state.setTopologyLogConfig(topoId, mergedLogConfig, topoConf);
        }
        catch (Exception e) {
            LOG.warn("set log config topology exception. (topology id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public LogConfig getLogConfig(String topoId) throws TException {
        try {
            this.getLogConfigCalls.mark();
            Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "getLogConfig");
            IStormClusterState state = this.stormClusterState;
            LogConfig logConfig = state.topologyLogConfig(topoId, null);
            if (logConfig == null) {
                logConfig = new LogConfig();
            }
            return logConfig;
        }
        catch (Exception e) {
            LOG.warn("get log conf topology exception. (topology id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String topoName, String componentId, boolean enable, double samplingPercentage) throws NotAliveException, AuthorizationException, TException {
        this.debugCalls.mark();
        try {
            IStormClusterState state = this.stormClusterState;
            String topoId = this.toTopoId(topoName);
            Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            double spct = Math.max(Math.min(samplingPercentage, 100.0), 0.0);
            this.checkAuthorization(topoName, topoConf, "debug");
            if (topoId == null) {
                throw new WrappedNotAliveException(topoName);
            }
            DebugOptions options = new DebugOptions();
            options.set_enable(enable);
            if (enable) {
                options.set_samplingpct(spct);
            }
            StormBase updates = new StormBase();
            updates.set_component_executors(Collections.emptyMap());
            boolean hasCompId = componentId != null && !componentId.isEmpty();
            String key = hasCompId ? componentId : topoId;
            updates.put_to_component_debug(key, options);
            LOG.info("Nimbus setting debug to {} for storm-name '{}' storm-id '{}' sanpling pct '{}'" + (hasCompId ? " component-id '" + componentId + "'" : ""), new Object[]{enable, topoName, topoId, spct});
            Object object = this.submitLock;
            synchronized (object) {
                state.updateStorm(topoId, updates);
            }
        }
        catch (Exception e) {
            LOG.warn("debug topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void setWorkerProfiler(String topoId, ProfileRequest profileRequest) throws TException {
        try {
            this.setWorkerProfilerCalls.mark();
            Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "setWorkerProfiler");
            IStormClusterState state = this.stormClusterState;
            state.setWorkerProfileRequest(topoId, profileRequest);
        }
        catch (Exception e) {
            LOG.warn("set worker profiler topology exception. (topology id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public List<ProfileRequest> getComponentPendingProfileActions(String id, String componentId, ProfileAction action) throws TException {
        try {
            this.getComponentPendingProfileActionsCalls.mark();
            CommonTopoInfo info = this.getCommonTopoInfo(id, "getComponentPendingProfileActions");
            HashMap<List<? extends Number>, List<Object>> exec2hostPort = new HashMap<List<? extends Number>, List<Object>>();
            if (info.assignment != null) {
                Map nodeToHost = info.assignment.get_node_host();
                for (Map.Entry entry : info.assignment.get_executor_node_port().entrySet()) {
                    NodeInfo nodeInfo = (NodeInfo)entry.getValue();
                    List<Object> hostPort = Arrays.asList(nodeToHost.get(nodeInfo.get_node()), ((Long)nodeInfo.get_port_iterator().next()).intValue());
                    exec2hostPort.put((List<? extends Number>)entry.getKey(), hostPort);
                }
            }
            List<Map<String, Object>> nodeInfos = StatsUtil.extractNodeInfosFromHbForComp(exec2hostPort, info.taskToComponent, false, componentId);
            ArrayList<ProfileRequest> ret = new ArrayList<ProfileRequest>();
            for (Map<String, Object> map : nodeInfos) {
                String niHost = (String)map.get("host");
                int niPort = (Integer)map.get("port");
                ProfileRequest newestMatch = null;
                long reqTime = -1L;
                for (ProfileRequest req : this.stormClusterState.getTopologyProfileRequests(id)) {
                    long time;
                    String expectedHost = req.get_nodeInfo().get_node();
                    int expectedPort = ((Long)req.get_nodeInfo().get_port_iterator().next()).intValue();
                    ProfileAction expectedAction = req.get_action();
                    if (!niHost.equals(expectedHost) || niPort != expectedPort || action != expectedAction || (time = req.get_time_stamp()) <= reqTime) continue;
                    reqTime = time;
                    newestMatch = req;
                }
                if (newestMatch == null) continue;
                ret.add(newestMatch);
            }
            LOG.info("Latest profile actions for topology {} component {} {}", new Object[]{id, componentId, ret});
            return ret;
        }
        catch (Exception e) {
            LOG.warn("Get comp actions topology exception. (topology id='{}')", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadNewCredentials(String topoName, Credentials credentials) throws NotAliveException, InvalidTopologyException, AuthorizationException, TException {
        try {
            this.uploadNewCredentialsCalls.mark();
            IStormClusterState state = this.stormClusterState;
            String topoId = this.toTopoId(topoName);
            if (topoId == null) {
                throw new WrappedNotAliveException(topoName + " is not alive");
            }
            Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            if (credentials == null) {
                credentials = new Credentials(Collections.emptyMap());
            }
            this.checkAuthorization(topoName, topoConf, "uploadNewCredentials");
            String realPrincipal = (String)topoConf.get("topology.submitter.principal");
            String realUser = (String)topoConf.get("topology.submitter.user");
            String expectedOwner = null;
            if (credentials.is_set_topoOwner()) {
                expectedOwner = credentials.get_topoOwner();
            } else {
                Principal p = ReqContext.context().principal();
                if (p != null) {
                    expectedOwner = p.getName();
                }
            }
            if (expectedOwner == null) {
                LOG.warn("Please check you settings. Credentials are being uploaded to {} with security disabled.", (Object)topoId);
            } else if (!realPrincipal.equals(expectedOwner) && !realUser.equals(expectedOwner)) {
                throw new AuthorizationException(topoId + " is expected to be owned by " + expectedOwner + " but is actually owned by " + realPrincipal);
            }
            Object object = this.credUpdateLock;
            synchronized (object) {
                Credentials origCreds = state.credentials(topoId, null);
                if (origCreds != null) {
                    Map mergedCreds = origCreds.get_creds();
                    mergedCreds.putAll(credentials.get_creds());
                    credentials.set_creds(mergedCreds);
                }
                state.setCredentials(topoId, credentials, topoConf);
            }
        }
        catch (Exception e) {
            LOG.warn("Upload Creds topology exception. (topology name='{}')", (Object)topoName, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public String beginCreateBlob(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException, TException {
        try {
            String sessionId = Utils.uuid();
            this.blobUploaders.put((Object)sessionId, (Object)this.blobStore.createBlob(key, meta, Nimbus.getSubject()));
            LOG.info("Created blob {} for session {}", (Object)key, (Object)sessionId);
            return sessionId;
        }
        catch (Exception e) {
            LOG.warn("begin create blob exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public String beginUpdateBlob(String key) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            String sessionId = Utils.uuid();
            this.blobUploaders.put((Object)sessionId, (Object)this.blobStore.updateBlob(key, Nimbus.getSubject()));
            LOG.info("Created upload session for {}", (Object)key);
            return sessionId;
        }
        catch (Exception e) {
            LOG.warn("begin update blob exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void uploadBlobChunk(String session, ByteBuffer chunk) throws AuthorizationException, TException {
        try {
            OutputStream os = (OutputStream)this.blobUploaders.get((Object)session);
            if (os == null) {
                throw new RuntimeException("Blob for session " + session + " does not exist (or timed out)");
            }
            byte[] array = chunk.array();
            int remaining = chunk.remaining();
            int offset = chunk.arrayOffset();
            int position = chunk.position();
            os.write(array, offset + position, remaining);
            this.blobUploaders.put((Object)session, (Object)os);
        }
        catch (Exception e) {
            LOG.warn("upload blob chunk exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void finishBlobUpload(String session) throws AuthorizationException, TException {
        try {
            OutputStream os = (OutputStream)this.blobUploaders.get((Object)session);
            if (os == null) {
                throw new RuntimeException("Blob for session " + session + " does not exist (or timed out)");
            }
            os.close();
            LOG.info("Finished uploading blob for session {}. Closing session.", (Object)session);
            this.blobUploaders.remove((Object)session);
            this.blobStore.updateLastBlobUpdateTime();
        }
        catch (Exception e) {
            LOG.warn("finish blob upload exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void cancelBlobUpload(String session) throws AuthorizationException, TException {
        try {
            AtomicOutputStream os = (AtomicOutputStream)this.blobUploaders.get((Object)session);
            if (os == null) {
                throw new RuntimeException("Blob for session " + session + " does not exist (or timed out)");
            }
            os.cancel();
            LOG.info("Canceled uploading blob for session {}. Closing session.", (Object)session);
            this.blobUploaders.remove((Object)session);
        }
        catch (Exception e) {
            LOG.warn("finish blob upload exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            return this.blobStore.getBlobMeta(key, Nimbus.getSubject());
        }
        catch (Exception e) {
            LOG.warn("get blob meta exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void setBlobMeta(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            this.blobStore.setBlobMeta(key, meta, Nimbus.getSubject());
            this.blobStore.updateLastBlobUpdateTime();
        }
        catch (Exception e) {
            LOG.warn("set blob meta exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public BeginDownloadResult beginBlobDownload(String key) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            InputStreamWithMeta is = this.blobStore.getBlob(key, Nimbus.getSubject());
            String sessionId = Utils.uuid();
            BeginDownloadResult ret = new BeginDownloadResult(is.getVersion(), sessionId);
            ret.set_data_size(is.getFileLength());
            this.blobDownloaders.put((Object)sessionId, (Object)new BufferInputStream((InputStream)is, (Integer)this.conf.getOrDefault("storm.blobstore.inputstream.buffer.size.bytes", 65536)));
            LOG.info("Created download session {} for {}", (Object)sessionId, (Object)key);
            return ret;
        }
        catch (Exception e) {
            LOG.warn("begin blob download exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer downloadBlobChunk(String session) throws AuthorizationException, TException {
        try {
            BufferInputStream is = (BufferInputStream)this.blobDownloaders.get((Object)session);
            if (is == null) {
                throw new RuntimeException("Blob for session " + session + " does not exist (or timed out)");
            }
            byte[] ret = is.read();
            if (ret.length == 0) {
                is.close();
                this.blobDownloaders.remove((Object)session);
            } else {
                this.blobDownloaders.put((Object)session, (Object)is);
            }
            LOG.debug("Sending {} bytes", (Object)ret.length);
            return ByteBuffer.wrap(ret);
        }
        catch (Exception e) {
            LOG.warn("download blob chunk exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException, IllegalStateException, TException {
        try {
            String topoName = ConfigUtils.getIdFromBlobKey((String)key);
            if (topoName != null && Nimbus.isTopologyActiveOrActivating(this.stormClusterState, topoName)) {
                String message = "Attempting to delete blob " + key + " from under active topology " + topoName;
                LOG.warn(message);
                throw new WrappedIllegalStateException(message);
            }
            this.blobStore.deleteBlob(key, Nimbus.getSubject());
            LOG.info("Deleted blob for key {}", (Object)key);
        }
        catch (Exception e) {
            LOG.warn("delete blob exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ListBlobsResult listBlobs(String session) throws TException {
        try {
            Iterator keyIt;
            if (session == null || session.isEmpty()) {
                keyIt = this.blobStore.listKeys();
                session = Utils.uuid();
            } else {
                keyIt = (Iterator)this.blobListers.get((Object)session);
            }
            if (keyIt == null) {
                throw new RuntimeException("Blob list for session " + session + " does not exist (or timed out)");
            }
            if (!keyIt.hasNext()) {
                this.blobListers.remove((Object)session);
                LOG.info("No more blobs to list for session {}", (Object)session);
                return new ListBlobsResult(Collections.emptyList(), session);
            }
            ArrayList listChunk = new ArrayList();
            for (int i = 0; i < 100 && keyIt.hasNext(); ++i) {
                listChunk.add(keyIt.next());
            }
            this.blobListers.put((Object)session, (Object)keyIt);
            LOG.info("Downloading {} entries", (Object)listChunk.size());
            return new ListBlobsResult(listChunk, session);
        }
        catch (Exception e) {
            LOG.warn("list blobs exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            return this.blobStore.getBlobReplication(key, Nimbus.getSubject());
        }
        catch (Exception e) {
            LOG.warn("get blob replication exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException, TException {
        try {
            int result = this.blobStore.updateBlobReplication(key, replication, Nimbus.getSubject());
            this.blobStore.updateLastBlobUpdateTime();
            return result;
        }
        catch (Exception e) {
            LOG.warn("update blob replication exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void createStateInZookeeper(String key) throws TException {
        try {
            IStormClusterState state = this.stormClusterState;
            BlobStore store = this.blobStore;
            NimbusInfo ni = this.nimbusHostPortInfo;
            if (store instanceof LocalFsBlobStore) {
                state.setupBlob(key, ni, Integer.valueOf(Nimbus.getVersionForKey(key, ni, this.zkClient)));
            }
            LOG.debug("Created state in zookeeper {} {} {}", new Object[]{state, store, ni});
        }
        catch (Exception e) {
            LOG.warn("Exception while creating state in zookeeper - key: " + key, (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public String beginFileUpload() throws AuthorizationException, TException {
        try {
            this.beginFileUploadCalls.mark();
            this.assertIsLeader();
            this.checkAuthorization(null, null, "fileUpload");
            String fileloc = this.getInbox() + "/stormjar-" + Utils.uuid() + ".jar";
            this.uploaders.put((Object)fileloc, (Object)new TimedWritableByteChannel(Channels.newChannel(new FileOutputStream(fileloc)), this.fileUploadDuration));
            LOG.info("Uploading file from client to {}", (Object)fileloc);
            return fileloc;
        }
        catch (Exception e) {
            LOG.warn("Begin file upload exception", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void uploadChunk(String location, ByteBuffer chunk) throws AuthorizationException, TException {
        try {
            this.uploadChunkCalls.mark();
            this.checkAuthorization(null, null, "fileUpload");
            WritableByteChannel channel = (WritableByteChannel)this.uploaders.get((Object)location);
            if (channel == null) {
                throw new RuntimeException("File for that location does not exist (or timed out)");
            }
            channel.write(chunk);
            this.uploaders.put((Object)location, (Object)channel);
        }
        catch (Exception e) {
            LOG.warn("uploadChunk exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void finishFileUpload(String location) throws AuthorizationException, TException {
        try {
            this.finishFileUploadCalls.mark();
            this.checkAuthorization(null, null, "fileUpload");
            WritableByteChannel channel = (WritableByteChannel)this.uploaders.get((Object)location);
            if (channel == null) {
                throw new RuntimeException("File for that location does not exist (or timed out)");
            }
            channel.close();
            LOG.info("Finished uploading file from client: {}", (Object)location);
            this.uploaders.remove((Object)location);
            this.blobStore.updateLastBlobUpdateTime();
        }
        catch (Exception e) {
            LOG.warn("finish file upload exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer downloadChunk(String id) throws AuthorizationException, TException {
        try {
            this.downloadChunkCalls.mark();
            this.checkAuthorization(null, null, "fileDownload");
            BufferInputStream is = (BufferInputStream)this.downloaders.get((Object)id);
            if (is == null) {
                throw new RuntimeException("Could not find input stream for id " + id);
            }
            byte[] ret = is.read();
            if (ret.length == 0) {
                is.close();
                this.downloaders.remove((Object)id);
            }
            return ByteBuffer.wrap(ret);
        }
        catch (Exception e) {
            LOG.warn("download chunk exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public String getNimbusConf() throws AuthorizationException, TException {
        try {
            this.getNimbusConfCalls.mark();
            this.checkAuthorization(null, null, "getNimbusConf");
            return JSONValue.toJSONString(this.conf);
        }
        catch (Exception e) {
            LOG.warn("get nimbus conf exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologyInfo getTopologyInfo(String id) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologyInfoCalls.mark();
            GetInfoOptions options = new GetInfoOptions();
            options.set_num_err_choice(NumErrorsChoice.ALL);
            return this.getTopologyInfoWithOptsImpl(id, options);
        }
        catch (Exception e) {
            LOG.warn("get topology ino exception. (topology id={})", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologyInfo getTopologyInfoByName(String name) throws TException {
        try {
            this.getTopologyInfoByNameCalls.mark();
            GetInfoOptions options = new GetInfoOptions();
            options.set_num_err_choice(NumErrorsChoice.ALL);
            return this.getTopologyInfoByNameImpl(name, options);
        }
        catch (Exception e) {
            LOG.warn("get topology info exception. (topology name={})", (Object)name, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    private TopologyInfo getTopologyInfoByNameImpl(String name, GetInfoOptions options) throws NotAliveException, AuthorizationException, Exception {
        IStormClusterState state = this.stormClusterState;
        String id = (String)state.getTopoId(name).orElseThrow(() -> new WrappedNotAliveException(name + " is not alive"));
        return this.getTopologyInfoWithOptsImpl(id, options);
    }

    public TopologyInfo getTopologyInfoByNameWithOpts(String name, GetInfoOptions options) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologyInfoByNameWithOptsCalls.mark();
            return this.getTopologyInfoByNameImpl(name, options);
        }
        catch (Exception e) {
            LOG.warn("get topology info withOpts by name exception. (topology name={})", (Object)name, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologyInfo getTopologyInfoWithOpts(String topoId, GetInfoOptions options) throws NotAliveException, AuthorizationException, TException {
        this.getTopologyInfoWithOptsCalls.mark();
        try {
            return this.getTopologyInfoWithOptsImpl(topoId, options);
        }
        catch (Exception e) {
            LOG.warn("Get topo info exception. (topology id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    private TopologyInfo getTopologyInfoWithOptsImpl(String topoId, GetInfoOptions options) throws NotAliveException, AuthorizationException, InvalidTopologyException, Exception {
        TopologyResources resources;
        String string;
        CommonTopoInfo common = this.getCommonTopoInfo(topoId, "getTopologyInfo");
        if (common.base == null) {
            throw new WrappedNotAliveException(topoId);
        }
        IStormClusterState state = this.stormClusterState;
        NumErrorsChoice numErrChoice = (NumErrorsChoice)Utils.OR((Object)options.get_num_err_choice(), (Object)NumErrorsChoice.ALL);
        HashMap<String, List> errors = new HashMap<String, List>();
        block5: for (String string2 : common.allComponents) {
            switch (numErrChoice) {
                case NONE: {
                    errors.put(string2, Collections.emptyList());
                    continue block5;
                }
                case ONE: {
                    ArrayList<ErrorInfo> arrayList = new ArrayList<ErrorInfo>();
                    ErrorInfo info = state.lastError(topoId, string2);
                    if (info != null) {
                        arrayList.add(info);
                    }
                    errors.put(string2, arrayList);
                    continue block5;
                }
                case ALL: {
                    errors.put(string2, state.errors(topoId, string2));
                    continue block5;
                }
            }
            LOG.warn("Got invalid NumErrorsChoice '{}'", (Object)numErrChoice);
            errors.put(string2, state.errors(topoId, string2));
        }
        ArrayList<ExecutorSummary> summaries = new ArrayList<ExecutorSummary>();
        if (common.assignment != null) {
            for (Map.Entry entry : common.assignment.get_executor_node_port().entrySet()) {
                NodeInfo ni = (NodeInfo)entry.getValue();
                ExecutorInfo execInfo = Nimbus.toExecInfo((List)entry.getKey());
                Map nodeToHost = common.assignment.get_node_host();
                Map<String, Object> heartbeat = common.beats.get(ClientStatsUtil.convertExecutor((List)((List)entry.getKey())));
                if (heartbeat == null) {
                    heartbeat = Collections.emptyMap();
                }
                ExecutorSummary summ = new ExecutorSummary(execInfo, common.taskToComponent.get(execInfo.get_task_start()), (String)nodeToHost.get(ni.get_node()), ((Long)ni.get_port_iterator().next()).intValue(), ((Integer)heartbeat.getOrDefault("uptime", 0)).intValue());
                Map ex = (Map)heartbeat.get("stats");
                if (ex != null) {
                    ExecutorStats stats = StatsUtil.thriftifyExecutorStats(ex);
                    summ.set_stats(stats);
                }
                summaries.add(summ);
            }
        }
        TopologyInfo topologyInfo = new TopologyInfo(topoId, common.topoName, Time.deltaSecs((int)common.launchTimeSecs), summaries, Nimbus.extractStatusStr(common.base), errors);
        if (common.topology.is_set_storm_version()) {
            topologyInfo.set_storm_version(common.topology.get_storm_version());
        }
        if (common.base.is_set_owner()) {
            topologyInfo.set_owner(common.base.get_owner());
        }
        if ((string = this.idToSchedStatus.get().get(topoId)) != null) {
            topologyInfo.set_sched_status(string);
        }
        if ((resources = this.getResourcesForTopology(topoId, common.base)) != null && this.underlyingScheduler instanceof ResourceAwareScheduler) {
            topologyInfo.set_requested_memonheap(resources.getRequestedMemOnHeap());
            topologyInfo.set_requested_memoffheap(resources.getRequestedMemOffHeap());
            topologyInfo.set_requested_cpu(resources.getRequestedCpu());
            topologyInfo.set_assigned_memonheap(resources.getAssignedMemOnHeap());
            topologyInfo.set_assigned_memoffheap(resources.getAssignedMemOffHeap());
            topologyInfo.set_assigned_cpu(resources.getAssignedCpu());
        }
        if (common.base.is_set_component_debug()) {
            topologyInfo.set_component_debug(common.base.get_component_debug());
        }
        topologyInfo.set_replication_count(this.getBlobReplicationCount(ConfigUtils.masterStormCodeKey((String)topoId)).intValue());
        return topologyInfo;
    }

    public TopologyPageInfo getTopologyPageInfo(String topoId, String window, boolean includeSys) throws NotAliveException, AuthorizationException, TException {
        try {
            DebugOptions debug;
            TopologyResources resources;
            String schedStatus;
            this.getTopologyPageInfoCalls.mark();
            CommonTopoInfo common = this.getCommonTopoInfo(topoId, "getTopologyPageInfo");
            String topoName = common.topoName;
            IStormClusterState state = this.stormClusterState;
            Assignment assignment = common.assignment;
            Map<List<Integer>, Map<String, Object>> beats = common.beats;
            Map<Integer, String> taskToComp = common.taskToComponent;
            StormTopology topology = common.topology;
            StormBase base = common.base;
            if (base == null) {
                throw new WrappedNotAliveException(topoId);
            }
            String owner = base.get_owner();
            Map<WorkerSlot, WorkerResources> workerToResources = this.getWorkerResourcesForTopology(topoId);
            List<WorkerSummary> workerSummaries = null;
            HashMap<List<Long>, List<Object>> exec2NodePort = new HashMap<List<Long>, List<Object>>();
            if (assignment != null) {
                Map execToNodeInfo = assignment.get_executor_node_port();
                Map nodeToHost = assignment.get_node_host();
                for (Map.Entry entry : execToNodeInfo.entrySet()) {
                    NodeInfo ni = (NodeInfo)entry.getValue();
                    List<Object> nodePort = Arrays.asList(ni.get_node(), ni.get_port_iterator().next());
                    exec2NodePort.put((List<Long>)entry.getKey(), nodePort);
                }
                workerSummaries = StatsUtil.aggWorkerStats(topoId, topoName, taskToComp, beats, exec2NodePort, nodeToHost, workerToResources, includeSys, true, null, owner);
            }
            TopologyPageInfo topoPageInfo = StatsUtil.aggTopoExecsStats(topoId, exec2NodePort, taskToComp, beats, topology, window, includeSys, state);
            if (topology.is_set_storm_version()) {
                topoPageInfo.set_storm_version(topology.get_storm_version());
            }
            Map topoConf = Utils.merge(this.conf, common.topoConf);
            this.addSpoutAggStats(topoPageInfo, topology, topoConf);
            this.addBoltAggStats(topoPageInfo, topology, topoConf, includeSys);
            if (workerSummaries != null) {
                topoPageInfo.set_workers(workerSummaries);
            }
            if (base.is_set_owner()) {
                topoPageInfo.set_owner(base.get_owner());
            }
            if (base.is_set_topology_version()) {
                topoPageInfo.set_topology_version(base.get_topology_version());
            }
            if ((schedStatus = this.idToSchedStatus.get().get(topoId)) != null) {
                topoPageInfo.set_sched_status(schedStatus);
            }
            if ((resources = this.getResourcesForTopology(topoId, base)) != null && this.underlyingScheduler instanceof ResourceAwareScheduler) {
                topoPageInfo.set_requested_memonheap(resources.getRequestedMemOnHeap());
                topoPageInfo.set_requested_memoffheap(resources.getRequestedMemOffHeap());
                topoPageInfo.set_requested_cpu(resources.getRequestedCpu());
                topoPageInfo.set_assigned_memonheap(resources.getAssignedMemOnHeap());
                topoPageInfo.set_assigned_memoffheap(resources.getAssignedMemOffHeap());
                topoPageInfo.set_assigned_cpu(resources.getAssignedCpu());
                topoPageInfo.set_requested_shared_off_heap_memory(resources.getRequestedSharedMemOffHeap());
                topoPageInfo.set_requested_regular_off_heap_memory(resources.getRequestedNonSharedMemOffHeap());
                topoPageInfo.set_requested_shared_on_heap_memory(resources.getRequestedSharedMemOnHeap());
                topoPageInfo.set_requested_regular_on_heap_memory(resources.getRequestedNonSharedMemOnHeap());
                topoPageInfo.set_assigned_shared_off_heap_memory(resources.getAssignedSharedMemOffHeap());
                topoPageInfo.set_assigned_regular_off_heap_memory(resources.getAssignedNonSharedMemOffHeap());
                topoPageInfo.set_assigned_shared_on_heap_memory(resources.getAssignedSharedMemOnHeap());
                topoPageInfo.set_assigned_regular_on_heap_memory(resources.getAssignedNonSharedMemOnHeap());
                topoPageInfo.set_assigned_generic_resources(resources.getAssignedGenericResources());
                topoPageInfo.set_requested_generic_resources(resources.getRequestedGenericResources());
            }
            int launchTimeSecs = common.launchTimeSecs;
            topoPageInfo.set_name(topoName);
            topoPageInfo.set_status(Nimbus.extractStatusStr(base));
            topoPageInfo.set_uptime_secs(Time.deltaSecs((int)launchTimeSecs));
            topoPageInfo.set_topology_conf(JSONValue.toJSONString((Object)topoConf));
            topoPageInfo.set_replication_count(this.getBlobReplicationCount(ConfigUtils.masterStormCodeKey((String)topoId)).intValue());
            if (base.is_set_component_debug() && (debug = (DebugOptions)base.get_component_debug().get(topoId)) != null) {
                topoPageInfo.set_debug_options(debug);
            }
            return topoPageInfo;
        }
        catch (Exception e) {
            LOG.warn("Get topo page info exception. (topology id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    private void addSpoutAggStats(TopologyPageInfo topoPageInfo, StormTopology topology, Map<String, Object> topoConf) {
        Map<String, NormalizedResourceRequest> spoutResources = ResourceUtils.getSpoutsResources(topology, topoConf);
        if (topoPageInfo.get_id_to_spout_agg_stats().isEmpty()) {
            for (Map.Entry entry : topology.get_spouts().entrySet()) {
                String spoutName = (String)entry.getKey();
                SpoutSpec spoutSpec = (SpoutSpec)entry.getValue();
                ComponentAggregateStats placeholderComponentStats = new ComponentAggregateStats();
                placeholderComponentStats.set_type(ComponentType.SPOUT);
                CommonAggregateStats commonStats = this.getPlaceholderCommonAggregateStats(spoutSpec);
                commonStats.set_resources_map(spoutResources.getOrDefault(spoutName, new NormalizedResourceRequest()).toNormalizedMap());
                placeholderComponentStats.set_common_stats(commonStats);
                SpoutAggregateStats spoutAggStats = new SpoutAggregateStats();
                spoutAggStats.set_complete_latency_ms(0.0);
                SpecificAggregateStats specificStats = new SpecificAggregateStats();
                specificStats.set_spout(spoutAggStats);
                placeholderComponentStats.set_specific_stats(specificStats);
                topoPageInfo.get_id_to_spout_agg_stats().put(spoutName, placeholderComponentStats);
            }
        } else {
            for (Map.Entry entry : topoPageInfo.get_id_to_spout_agg_stats().entrySet()) {
                CommonAggregateStats commonStats = ((ComponentAggregateStats)entry.getValue()).get_common_stats();
                Nimbus.setResourcesDefaultIfNotSet(spoutResources, (String)entry.getKey(), topoConf);
                commonStats.set_resources_map(spoutResources.get(entry.getKey()).toNormalizedMap());
            }
        }
    }

    private void addBoltAggStats(TopologyPageInfo topoPageInfo, StormTopology topology, Map<String, Object> topoConf, boolean includeSys) {
        Map<String, NormalizedResourceRequest> boltResources = ResourceUtils.getBoltsResources(topology, topoConf);
        if (topoPageInfo.get_id_to_bolt_agg_stats().isEmpty()) {
            for (Map.Entry entry : topology.get_bolts().entrySet()) {
                String boltName = (String)entry.getKey();
                Bolt bolt = (Bolt)entry.getValue();
                if (!includeSys && Utils.isSystemId((String)boltName) || boltName.equals("__system")) continue;
                ComponentAggregateStats placeholderComponentStats = new ComponentAggregateStats();
                placeholderComponentStats.set_type(ComponentType.BOLT);
                CommonAggregateStats commonStats = this.getPlaceholderCommonAggregateStats(bolt);
                commonStats.set_resources_map(boltResources.getOrDefault(boltName, new NormalizedResourceRequest()).toNormalizedMap());
                placeholderComponentStats.set_common_stats(commonStats);
                BoltAggregateStats boltAggStats = new BoltAggregateStats();
                boltAggStats.set_execute_latency_ms(0.0);
                boltAggStats.set_process_latency_ms(0.0);
                boltAggStats.set_executed(0L);
                boltAggStats.set_capacity(0.0);
                SpecificAggregateStats specificStats = new SpecificAggregateStats();
                specificStats.set_bolt(boltAggStats);
                placeholderComponentStats.set_specific_stats(specificStats);
                topoPageInfo.get_id_to_bolt_agg_stats().put(boltName, placeholderComponentStats);
            }
        } else {
            for (Map.Entry entry : topoPageInfo.get_id_to_bolt_agg_stats().entrySet()) {
                CommonAggregateStats commonStats = ((ComponentAggregateStats)entry.getValue()).get_common_stats();
                Nimbus.setResourcesDefaultIfNotSet(boltResources, (String)entry.getKey(), topoConf);
                commonStats.set_resources_map(boltResources.get(entry.getKey()).toNormalizedMap());
            }
        }
    }

    private CommonAggregateStats getPlaceholderCommonAggregateStats(Object component) {
        CommonAggregateStats commonStats = new CommonAggregateStats();
        int numExecutors = 0;
        try {
            numExecutors = StormCommon.numStartExecutors((Object)component);
        }
        catch (InvalidTopologyException invalidTopologyException) {
            // empty catch block
        }
        Map jsonMap = StormCommon.componentConf((Object)component);
        int numTasks = ObjectReader.getInt((Object)jsonMap.getOrDefault("topology.tasks", numExecutors));
        commonStats.set_num_executors(numExecutors);
        commonStats.set_num_tasks(numTasks);
        commonStats.set_emitted(0L);
        commonStats.set_transferred(0L);
        commonStats.set_acked(0L);
        return commonStats;
    }

    public SupervisorPageInfo getSupervisorPageInfo(String superId, String host, boolean includeSys) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getSupervisorPageInfoCalls.mark();
            IStormClusterState state = this.stormClusterState;
            Map superInfos = state.allSupervisorInfo();
            HashMap hostToSuperId = new HashMap();
            for (Map.Entry entry : superInfos.entrySet()) {
                String h = ((SupervisorInfo)entry.getValue()).get_hostname();
                ArrayList superIds = (ArrayList)hostToSuperId.get(h);
                if (superIds == null) {
                    superIds = new ArrayList();
                    hostToSuperId.put(h, superIds);
                }
                superIds.add(entry.getKey());
            }
            List<String> supervisorIds = null;
            supervisorIds = superId == null ? (List<String>)hostToSuperId.get(host) : Arrays.asList(superId);
            SupervisorPageInfo pageInfo = new SupervisorPageInfo();
            Map topoToAssignment = state.assignmentsInfo();
            for (String sid : supervisorIds) {
                SupervisorInfo info = (SupervisorInfo)superInfos.get(sid);
                LOG.info("SIDL {} SI: {} ALL: {}", new Object[]{sid, info, superInfos});
                SupervisorSummary supSum = this.makeSupervisorSummary(sid, info);
                pageInfo.add_to_supervisor_summaries(supSum);
                List<String> superTopologies = Nimbus.topologiesOnSupervisor(topoToAssignment, sid);
                Set<String> userTopologies = this.filterAuthorized("getTopology", superTopologies);
                for (String topoId : superTopologies) {
                    Map nodeToHost;
                    CommonTopoInfo common = this.getCommonTopoInfo(topoId, "getSupervisorPageInfo");
                    String topoName = common.topoName;
                    Assignment assignment = common.assignment;
                    Map<List<Integer>, Map<String, Object>> beats = common.beats;
                    Map<Integer, String> taskToComp = common.taskToComponent;
                    HashMap<List<Long>, List<Object>> exec2NodePort = new HashMap<List<Long>, List<Object>>();
                    if (assignment != null) {
                        Map execToNodeInfo = assignment.get_executor_node_port();
                        for (Map.Entry entry : execToNodeInfo.entrySet()) {
                            NodeInfo ni = (NodeInfo)entry.getValue();
                            List<Object> nodePort = Arrays.asList(ni.get_node(), ni.get_port_iterator().next());
                            exec2NodePort.put((List<Long>)entry.getKey(), nodePort);
                        }
                        nodeToHost = assignment.get_node_host();
                    } else {
                        nodeToHost = Collections.emptyMap();
                    }
                    Map<WorkerSlot, WorkerResources> workerResources = this.getWorkerResourcesForTopology(topoId);
                    boolean isAllowed = userTopologies.contains(topoId);
                    String owner = common.base == null ? null : common.base.get_owner();
                    for (WorkerSummary workerSummary : StatsUtil.aggWorkerStats(topoId, topoName, taskToComp, beats, exec2NodePort, nodeToHost, workerResources, includeSys, isAllowed, sid, owner)) {
                        pageInfo.add_to_worker_summaries(workerSummary);
                    }
                }
            }
            return pageInfo;
        }
        catch (Exception e) {
            LOG.warn("Get super page info exception. (super id='{}')", (Object)superId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ComponentPageInfo getComponentPageInfo(String topoId, String componentId, String window, boolean includeSys) throws NotAliveException, AuthorizationException, TException {
        try {
            HashMap compToTasks;
            DebugOptions debug;
            ComponentPageInfo compPageInfo;
            Map nodeToHost;
            this.getComponentPageInfoCalls.mark();
            CommonTopoInfo info = this.getCommonTopoInfo(topoId, "getComponentPageInfo");
            if (info.base == null) {
                throw new WrappedNotAliveException(topoId);
            }
            StormTopology topology = info.topology;
            Map topoConf = info.topoConf;
            topoConf = Utils.merge(this.conf, topoConf);
            Assignment assignment = info.assignment;
            HashMap exec2NodePort = new HashMap();
            HashMap exec2HostPort = new HashMap();
            if (assignment != null) {
                Map execToNodeInfo = assignment.get_executor_node_port();
                nodeToHost = assignment.get_node_host();
                for (Map.Entry entry : execToNodeInfo.entrySet()) {
                    NodeInfo ni = (NodeInfo)entry.getValue();
                    List<Object> nodePort = Arrays.asList(ni.get_node(), ni.get_port_iterator().next());
                    List<Object> hostPort = Arrays.asList(nodeToHost.get(ni.get_node()), ni.get_port_iterator().next());
                    exec2NodePort.put(entry.getKey(), nodePort);
                    exec2HostPort.put(entry.getKey(), hostPort);
                }
            } else {
                nodeToHost = Collections.emptyMap();
            }
            if ((compPageInfo = StatsUtil.aggCompExecsStats(exec2HostPort, info.taskToComponent, info.beats, window, includeSys, topoId, topology, componentId)).get_component_type() == ComponentType.SPOUT) {
                NormalizedResourceRequest spoutResources = ResourceUtils.getSpoutResources(topology, topoConf, componentId);
                if (spoutResources == null) {
                    spoutResources = new NormalizedResourceRequest(topoConf, componentId);
                }
                compPageInfo.set_resources_map(spoutResources.toNormalizedMap());
            } else {
                NormalizedResourceRequest boltResources = ResourceUtils.getBoltResources(topology, topoConf, componentId);
                if (boltResources == null) {
                    boltResources = new NormalizedResourceRequest(topoConf, componentId);
                }
                compPageInfo.set_resources_map(boltResources.toNormalizedMap());
            }
            compPageInfo.set_topology_name(info.topoName);
            compPageInfo.set_errors(this.stormClusterState.errors(topoId, componentId));
            compPageInfo.set_topology_status(Nimbus.extractStatusStr(info.base));
            if (info.base.is_set_component_debug() && (debug = (DebugOptions)info.base.get_component_debug().get(componentId)) != null) {
                compPageInfo.set_debug_options(debug);
            }
            if ((compToTasks = Utils.reverseMap(info.taskToComponent)).containsKey("__eventlogger")) {
                List tasks = (List)compToTasks.get("__eventlogger");
                tasks.sort(null);
                int taskIndex = TupleUtils.chooseTaskIndex(Collections.singletonList(componentId), (int)tasks.size());
                int taskId = (Integer)tasks.get(taskIndex);
                String host = null;
                Integer port = null;
                for (Map.Entry entry : exec2HostPort.entrySet()) {
                    int start = ((Long)((List)entry.getKey()).get(0)).intValue();
                    int end = ((Long)((List)entry.getKey()).get(1)).intValue();
                    if (taskId < start || taskId > end) continue;
                    host = (String)((List)entry.getValue()).get(0);
                    port = ((Number)((List)entry.getValue()).get(1)).intValue();
                    break;
                }
                if (host != null && port != null) {
                    compPageInfo.set_eventlog_host(host);
                    compPageInfo.set_eventlog_port(port.intValue());
                }
            }
            return compPageInfo;
        }
        catch (Exception e) {
            LOG.warn("getComponentPageInfo exception. (topo id='{}')", (Object)topoId, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public String getTopologyConf(String id) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologyConfCalls.mark();
            Map<String, Object> topoConf = Nimbus.tryReadTopoConf(id, this.topoCache);
            Map checkConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)checkConf.get("topology.name");
            this.checkAuthorization(topoName, checkConf, "getTopologyConf");
            return JSONValue.toJSONString(topoConf);
        }
        catch (Exception e) {
            LOG.warn("Get topo conf exception. (topology id='{}')", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public StormTopology getTopology(String id) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologyCalls.mark();
            Map topoConf = Nimbus.tryReadTopoConf(id, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "getTopology");
            return StormCommon.systemTopology((Map)topoConf, (StormTopology)Nimbus.tryReadTopology(id, this.topoCache));
        }
        catch (Exception e) {
            LOG.warn("Get topology exception. (topology id='{}')", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public StormTopology getUserTopology(String id) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getUserTopologyCalls.mark();
            Map topoConf = Nimbus.tryReadTopoConf(id, this.topoCache);
            topoConf = Utils.merge(this.conf, topoConf);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "getUserTopology");
            return Nimbus.tryReadTopology(id, this.topoCache);
        }
        catch (Exception e) {
            LOG.warn("Get user topology exception. (topology id='{}')", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologyHistoryInfo getTopologyHistory(String user) throws AuthorizationException, TException {
        try {
            List<String> adminUsers = this.conf.getOrDefault("nimbus.admins", Collections.emptyList());
            List<String> adminGroups = this.conf.getOrDefault("nimbus.admins.groups", Collections.emptyList());
            IStormClusterState state = this.stormClusterState;
            List assignedIds = state.assignments(null);
            HashSet<String> ret = new HashSet<String>();
            boolean isAdmin = adminUsers.contains(user);
            for (String topoId : assignedIds) {
                Map topoConf = Nimbus.tryReadTopoConf(topoId, this.topoCache);
                topoConf = Utils.merge(this.conf, topoConf);
                List<String> groups = ServerConfigUtils.getTopoLogsGroups(topoConf);
                List<String> topoLogUsers = ServerConfigUtils.getTopoLogsUsers(topoConf);
                if (user != null && !isAdmin && !this.isUserPartOf(user, groups) && !this.isUserPartOf(user, adminGroups) && !topoLogUsers.contains(user)) continue;
                ret.add(topoId);
            }
            ret.addAll(this.readTopologyHistory(user, adminUsers));
            return new TopologyHistoryInfo(new ArrayList(ret));
        }
        catch (Exception e) {
            LOG.warn("Get topology history. (user='{}')", (Object)user, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public ClusterSummary getClusterInfo() throws AuthorizationException, TException {
        try {
            this.getClusterInfoCalls.mark();
            this.checkAuthorization(null, null, "getClusterInfo");
            return this.getClusterInfoImpl();
        }
        catch (Exception e) {
            LOG.warn("Get cluster info exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public List<TopologySummary> getTopologySummaries() throws AuthorizationException, TException {
        try {
            this.getTopologySummariesCalls.mark();
            this.checkAuthorization(null, null, "getTopologySummaries");
            return this.getTopologySummariesImpl();
        }
        catch (Exception e) {
            LOG.warn("Get TopologySummary info exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologySummary getTopologySummaryByName(String name) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologySummaryByNameCalls.mark();
            this.checkAuthorization(name, null, "getTopologySummaryByName");
            IStormClusterState state = this.stormClusterState;
            String topoId = (String)state.getTopoId(name).orElseThrow(() -> new WrappedNotAliveException(name + " is not alive"));
            return this.getTopologySummaryImpl(topoId, (StormBase)state.topologyBases().get(topoId));
        }
        catch (Exception e) {
            LOG.warn("Get TopologySummaryByName info exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public TopologySummary getTopologySummary(String id) throws NotAliveException, AuthorizationException, TException {
        try {
            this.getTopologySummaryCalls.mark();
            IStormClusterState state = this.stormClusterState;
            StormBase base = (StormBase)state.topologyBases().get(id);
            if (base == null) {
                throw new WrappedNotAliveException(id + " is not alive");
            }
            this.checkAuthorization(base.get_name(), null, "getTopologySummary");
            return this.getTopologySummaryImpl(id, base);
        }
        catch (Exception e) {
            LOG.warn("Get TopologySummaryById info exception.", (Throwable)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public NimbusSummary getLeader() throws AuthorizationException, TException {
        this.getLeaderCalls.mark();
        this.checkAuthorization(null, null, "getLeader");
        List nimbuses = this.stormClusterState.nimbuses();
        NimbusInfo leader = this.leaderElector.getLeader();
        for (NimbusSummary nimbusSummary : nimbuses) {
            if (!leader.getHost().equals(nimbusSummary.get_host()) || leader.getPort() != nimbusSummary.get_port()) continue;
            nimbusSummary.set_uptime_secs(Time.deltaSecs((int)nimbusSummary.get_uptime_secs()));
            nimbusSummary.set_isLeader(true);
            return nimbusSummary;
        }
        return null;
    }

    public boolean isTopologyNameAllowed(String name) throws AuthorizationException, TException {
        this.isTopologyNameAllowedCalls.mark();
        try {
            this.checkAuthorization(name, null, "isTopologyNameAllowed");
            Nimbus.validateTopologyName(name);
            this.assertTopoActive(name, false);
            return true;
        }
        catch (AlreadyAliveException | InvalidTopologyException e) {
            return false;
        }
    }

    public List<OwnerResourceSummary> getOwnerResourceSummaries(String owner) throws AuthorizationException, TException {
        try {
            this.getOwnerResourceSummariesCalls.mark();
            this.checkAuthorization(null, null, "getOwnerResourceSummaries");
            IStormClusterState state = this.stormClusterState;
            Map topoIdToAssignments = state.assignmentsInfo();
            Map topoIdToBases = state.topologyBases();
            Map clusterSchedulerConfig = this.scheduler.config();
            HashMap ownerToBasesMap = new HashMap();
            if (owner == null) {
                for (StormBase base : topoIdToBases.values()) {
                    String string = base.get_owner();
                    if (!ownerToBasesMap.containsKey(string)) {
                        ArrayList<StormBase> stormbases = new ArrayList<StormBase>();
                        stormbases.add(base);
                        ownerToBasesMap.put(string, stormbases);
                        continue;
                    }
                    ((List)ownerToBasesMap.get(string)).add(base);
                }
                ArrayList ownersWithGuarantees = new ArrayList(clusterSchedulerConfig.keySet());
                for (String string : ownersWithGuarantees) {
                    if (ownerToBasesMap.containsKey(string)) continue;
                    ownerToBasesMap.put(string, new ArrayList());
                }
            } else {
                ArrayList<StormBase> stormbases = new ArrayList<StormBase>();
                for (StormBase stormBase : topoIdToBases.values()) {
                    if (!owner.equals(stormBase.get_owner())) continue;
                    stormbases.add(stormBase);
                }
                ownerToBasesMap.put(owner, stormbases);
            }
            ArrayList<OwnerResourceSummary> ret = new ArrayList<OwnerResourceSummary>();
            for (Map.Entry entry : ownerToBasesMap.entrySet()) {
                String theOwner = (String)entry.getKey();
                TopologyResources totalResourcesAggregate = new TopologyResources();
                int totalExecutors = 0;
                int totalWorkers = 0;
                int totalTasks = 0;
                for (StormBase base : (List)entry.getValue()) {
                    try {
                        String topoId = this.toTopoId(base.get_name());
                        TopologyResources resources = this.getResourcesForTopology(topoId, base);
                        totalResourcesAggregate = totalResourcesAggregate.add(resources);
                        Assignment ownerAssignment = (Assignment)topoIdToAssignments.get(topoId);
                        if (ownerAssignment == null || ownerAssignment.get_executor_node_port() == null) continue;
                        totalExecutors += ownerAssignment.get_executor_node_port().keySet().size();
                        totalWorkers += new HashSet(ownerAssignment.get_executor_node_port().values()).size();
                        for (List executorId : ownerAssignment.get_executor_node_port().keySet()) {
                            totalTasks += StormCommon.executorIdToTasks((List)executorId).size();
                        }
                    }
                    catch (NotAliveException e) {
                        LOG.warn("{} is not alive.", (Object)base.get_name());
                    }
                }
                double requestedTotalMemory = totalResourcesAggregate.getRequestedMemOnHeap() + totalResourcesAggregate.getRequestedMemOffHeap();
                double assignedTotalMemory = totalResourcesAggregate.getAssignedMemOnHeap() + totalResourcesAggregate.getAssignedMemOffHeap();
                OwnerResourceSummary ownerResourceSummary = new OwnerResourceSummary(theOwner);
                ownerResourceSummary.set_total_topologies(((List)entry.getValue()).size());
                ownerResourceSummary.set_total_executors(totalExecutors);
                ownerResourceSummary.set_total_workers(totalWorkers);
                ownerResourceSummary.set_total_tasks(totalTasks);
                ownerResourceSummary.set_memory_usage(assignedTotalMemory);
                ownerResourceSummary.set_cpu_usage(totalResourcesAggregate.getAssignedCpu());
                ownerResourceSummary.set_requested_on_heap_memory(totalResourcesAggregate.getRequestedMemOnHeap());
                ownerResourceSummary.set_requested_off_heap_memory(totalResourcesAggregate.getRequestedMemOffHeap());
                ownerResourceSummary.set_requested_total_memory(requestedTotalMemory);
                ownerResourceSummary.set_requested_cpu(totalResourcesAggregate.getRequestedCpu());
                ownerResourceSummary.set_assigned_on_heap_memory(totalResourcesAggregate.getAssignedMemOnHeap());
                ownerResourceSummary.set_assigned_off_heap_memory(totalResourcesAggregate.getAssignedMemOffHeap());
                if (clusterSchedulerConfig.containsKey(theOwner)) {
                    if (this.underlyingScheduler instanceof ResourceAwareScheduler) {
                        Map schedulerConfig = (Map)clusterSchedulerConfig.get(theOwner);
                        if (schedulerConfig != null) {
                            ownerResourceSummary.set_memory_guarantee(((Double)((Object)schedulerConfig.getOrDefault("memory", 0))).doubleValue());
                            ownerResourceSummary.set_cpu_guarantee(((Double)((Object)schedulerConfig.getOrDefault("cpu", 0))).doubleValue());
                            ownerResourceSummary.set_memory_guarantee_remaining(ownerResourceSummary.get_memory_guarantee() - ownerResourceSummary.get_memory_usage());
                            ownerResourceSummary.set_cpu_guarantee_remaining(ownerResourceSummary.get_cpu_guarantee() - ownerResourceSummary.get_cpu_usage());
                        }
                    } else if (this.underlyingScheduler instanceof MultitenantScheduler) {
                        ownerResourceSummary.set_isolated_node_guarantee(((Integer)((Number)clusterSchedulerConfig.getOrDefault(theOwner, 0))).intValue());
                    }
                }
                LOG.debug("{}", (Object)ownerResourceSummary.toString());
                ret.add(ownerResourceSummary);
            }
            return ret;
        }
        catch (Exception e) {
            LOG.warn("Get owner resource summaries exception. (owner = '{}')", (Object)owner);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public SupervisorAssignments getSupervisorAssignments(String nodeId) throws AuthorizationException, TException {
        this.checkAuthorization(null, null, "getSupervisorAssignments");
        try {
            if (this.isLeader() && this.isAssignmentsRecovered()) {
                SupervisorAssignments supervisorAssignments = new SupervisorAssignments();
                supervisorAssignments.set_storm_assignment(Nimbus.assignmentsForNodeId(this.stormClusterState.assignmentsInfo(), nodeId));
                return supervisorAssignments;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception when node {} fetching assignments", (Object)nodeId);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            LOG.debug("Exception when node {} fetching assignments", (Object)nodeId);
        }
        return null;
    }

    public void sendSupervisorWorkerHeartbeats(SupervisorWorkerHeartbeats heartbeats) throws AuthorizationException, TException {
        block3: {
            this.checkAuthorization(null, null, "sendSupervisorWorkerHeartbeats");
            try {
                if (this.isLeader()) {
                    this.updateCachedHeartbeatsFromSupervisor(heartbeats);
                }
            }
            catch (Exception e) {
                LOG.debug("Exception when update heartbeats for node {} heartbeats report.", (Object)heartbeats.get_supervisor_id());
                if (!(e instanceof TException)) break block3;
                throw (TException)((Object)e);
            }
        }
    }

    public void sendSupervisorWorkerHeartbeat(SupervisorWorkerHeartbeat hb) throws AuthorizationException, TException {
        String id = hb.get_storm_id();
        try {
            Map<String, Object> topoConf = Nimbus.tryReadTopoConf(id, this.topoCache);
            String topoName = (String)topoConf.get("topology.name");
            this.checkAuthorization(topoName, topoConf, "sendSupervisorWorkerHeartbeat");
            if (this.isLeader()) {
                int heartbeatTimeoutSecs = this.getTopologyHeartbeatTimeoutSecs(topoConf);
                this.updateCachedHeartbeatsFromWorker(hb, heartbeatTimeoutSecs);
            }
        }
        catch (Exception e) {
            LOG.warn("Send HB exception. (topology id='{}')", (Object)id, (Object)e);
            if (e instanceof TException) {
                throw (TException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.shutdownCalls.mark();
        try {
            LOG.info("Shutting down master");
            this.timer.close();
            this.stormClusterState.disconnect();
            this.downloaders.cleanup();
            this.uploaders.cleanup();
            this.blobDownloaders.cleanup();
            this.blobUploaders.cleanup();
            this.blobListers.cleanup();
            this.scheduler.cleanup();
            this.blobStore.shutdown();
            this.leaderElector.close();
            this.assignmentsDistributer.close();
            ITopologyActionNotifierPlugin actionNotifier = this.nimbusTopologyActionNotifier;
            if (actionNotifier != null) {
                actionNotifier.cleanup();
            }
            this.zkClient.close();
            if (this.metricsStore != null) {
                this.metricsStore.close();
            }
            this.clusterMetricSet.setActive(false);
            LOG.info("Shut down master");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isWaiting() {
        return this.timer.isTimerWaiting();
    }

    public void processWorkerMetrics(WorkerMetrics metrics) throws TException {
        this.processWorkerMetricsCalls.mark();
        this.checkAuthorization(null, null, "processWorkerMetrics");
        if (this.metricsStore == null) {
            return;
        }
        for (WorkerMetricPoint m : metrics.get_metricList().get_metrics()) {
            try {
                org.apache.storm.metricstore.Metric metric = new org.apache.storm.metricstore.Metric(m.get_metricName(), m.get_timestamp(), metrics.get_topologyId(), m.get_metricValue(), m.get_componentId(), m.get_executorId(), metrics.get_hostname(), m.get_streamId(), metrics.get_port(), AggLevel.AGG_LEVEL_NONE);
                this.metricsStore.insert(metric);
            }
            catch (Exception e) {
                LOG.error("Failed to save metric", (Throwable)e);
            }
        }
    }

    public boolean isRemoteBlobExists(String blobKey) throws AuthorizationException, TException {
        try {
            this.blobStore.getBlobMeta(blobKey, Nimbus.getSubject());
        }
        catch (KeyNotFoundException e) {
            return false;
        }
        return true;
    }

    static {
        NIMBUS_SUBJECT.getPrincipals().add((Principal)new NimbusPrincipal());
        NIMBUS_SUBJECT.setReadOnly();
        NOOP_TRANSITION = (arg, nimbus, topoId, base) -> null;
        INACTIVE_TRANSITION = (arg, nimbus, topoId, base) -> Nimbus.make(TopologyStatus.INACTIVE);
        ACTIVE_TRANSITION = (arg, nimbus, topoId, base) -> Nimbus.make(TopologyStatus.ACTIVE);
        REMOVE_TRANSITION = (args, nimbus, topoId, base) -> {
            LOG.info("Killing topology: {}", (Object)topoId);
            IStormClusterState state = nimbus.getStormClusterState();
            Assignment oldAssignment = state.assignmentInfo(topoId, null);
            state.removeStorm(topoId);
            Nimbus.notifySupervisorsAsKilled(state, oldAssignment, nimbus.getAssignmentsDistributer(), nimbus.getMetricsRegistry());
            nimbus.heartbeatsCache.removeTopo(topoId);
            nimbus.getIdToExecutors().getAndUpdate(new Dissoc(topoId));
            return null;
        };
        DO_REBALANCE_TRANSITION = (args, nimbus, topoId, base) -> {
            nimbus.doRebalance(topoId, base);
            return Nimbus.make(base.get_prev_status());
        };
        KILL_TRANSITION = (killTime, nimbus, topoId, base) -> {
            int delay = 0;
            delay = killTime != null ? ((Number)killTime).intValue() : ObjectReader.getInt((Object)Nimbus.readTopoConf(topoId, nimbus.getTopoCache()).get("topology.message.timeout.secs")).intValue();
            nimbus.delayEvent(topoId, delay, TopologyActions.REMOVE, null);
            StormBase sb = new StormBase();
            sb.set_status(TopologyStatus.KILLED);
            TopologyActionOptions tao = new TopologyActionOptions();
            KillOptions opts = new KillOptions();
            opts.set_wait_secs(delay);
            tao.set_kill_options(opts);
            sb.set_topology_action_options(tao);
            sb.set_component_executors(Collections.emptyMap());
            sb.set_component_debug(Collections.emptyMap());
            return sb;
        };
        REBALANCE_TRANSITION = (args, nimbus, topoId, base) -> {
            RebalanceOptions rbo = ((RebalanceOptions)args).deepCopy();
            int delay = 0;
            delay = rbo.is_set_wait_secs() ? rbo.get_wait_secs() : ObjectReader.getInt((Object)Nimbus.readTopoConf(topoId, nimbus.getTopoCache()).get("topology.message.timeout.secs")).intValue();
            nimbus.delayEvent(topoId, delay, TopologyActions.DO_REBALANCE, null);
            rbo.set_wait_secs(delay);
            if (!rbo.is_set_num_executors()) {
                rbo.set_num_executors(Collections.emptyMap());
            }
            StormBase sb = new StormBase();
            sb.set_status(TopologyStatus.REBALANCING);
            sb.set_prev_status(base.get_status());
            TopologyActionOptions tao = new TopologyActionOptions();
            tao.set_rebalance_options(rbo);
            sb.set_topology_action_options(tao);
            sb.set_component_executors(Collections.emptyMap());
            sb.set_component_debug(Collections.emptyMap());
            return sb;
        };
        GAIN_LEADERSHIP_WHEN_KILLED_TRANSITION = (args, nimbus, topoId, base) -> {
            int delay = base.get_topology_action_options().get_kill_options().get_wait_secs();
            nimbus.delayEvent(topoId, delay, TopologyActions.REMOVE, null);
            return null;
        };
        GAIN_LEADERSHIP_WHEN_REBALANCING_TRANSITION = (args, nimbus, topoId, base) -> {
            int delay = base.get_topology_action_options().get_rebalance_options().get_wait_secs();
            nimbus.delayEvent(topoId, delay, TopologyActions.DO_REBALANCE, null);
            return null;
        };
        TOPO_STATE_TRANSITIONS = new ImmutableMap.Builder().put((Object)TopologyStatus.ACTIVE, (Object)new ImmutableMap.Builder().put((Object)TopologyActions.INACTIVATE, (Object)INACTIVE_TRANSITION).put((Object)TopologyActions.ACTIVATE, (Object)NOOP_TRANSITION).put((Object)TopologyActions.REBALANCE, (Object)REBALANCE_TRANSITION).put((Object)TopologyActions.KILL, (Object)KILL_TRANSITION).build()).put((Object)TopologyStatus.INACTIVE, (Object)new ImmutableMap.Builder().put((Object)TopologyActions.ACTIVATE, (Object)ACTIVE_TRANSITION).put((Object)TopologyActions.INACTIVATE, (Object)NOOP_TRANSITION).put((Object)TopologyActions.REBALANCE, (Object)REBALANCE_TRANSITION).put((Object)TopologyActions.KILL, (Object)KILL_TRANSITION).build()).put((Object)TopologyStatus.KILLED, (Object)new ImmutableMap.Builder().put((Object)TopologyActions.GAIN_LEADERSHIP, (Object)GAIN_LEADERSHIP_WHEN_KILLED_TRANSITION).put((Object)TopologyActions.KILL, (Object)KILL_TRANSITION).put((Object)TopologyActions.REMOVE, (Object)REMOVE_TRANSITION).build()).put((Object)TopologyStatus.REBALANCING, (Object)new ImmutableMap.Builder().put((Object)TopologyActions.GAIN_LEADERSHIP, (Object)GAIN_LEADERSHIP_WHEN_REBALANCING_TRANSITION).put((Object)TopologyActions.KILL, (Object)KILL_TRANSITION).put((Object)TopologyActions.DO_REBALANCE, (Object)DO_REBALANCE_TRANSITION).build()).build();
        EMPTY_STRING_LIST = Collections.unmodifiableList(Collections.emptyList());
        EMPTY_STRING_SET = Collections.unmodifiableSet(Collections.emptySet());
        topologyCleanupDetected = new RotatingMap(2);
        topologyCleanupRotationTime = 0L;
    }

    private class ClusterSummaryMetricSet
    implements Runnable {
        private static final int CACHING_WINDOW = 5;
        private final ClusterSummaryMetrics clusterSummaryMetrics = new ClusterSummaryMetrics();
        private final Function<String, Histogram> registerHistogram = name -> {
            Histogram histogram = new Histogram((Reservoir)new SlidingTimeWindowReservoir(2L, TimeUnit.SECONDS));
            this.clusterSummaryMetrics.put((String)name, (Metric)histogram);
            return histogram;
        };
        private volatile boolean active = false;
        private final Histogram nimbusUptime = this.registerHistogram.apply("nimbuses:uptime-secs");
        private final Histogram supervisorsUptime = this.registerHistogram.apply("supervisors:uptime-secs");
        private final Histogram supervisorsNumWorkers = this.registerHistogram.apply("supervisors:num-workers");
        private final Histogram supervisorsNumUsedWorkers = this.registerHistogram.apply("supervisors:num-used-workers");
        private final Histogram supervisorsUsedMem = this.registerHistogram.apply("supervisors:used-mem");
        private final Histogram supervisorsUsedCpu = this.registerHistogram.apply("supervisors:used-cpu");
        private final Histogram supervisorsFragmentedMem = this.registerHistogram.apply("supervisors:fragmented-mem");
        private final Histogram supervisorsFragmentedCpu = this.registerHistogram.apply("supervisors:fragmented-cpu");
        private final Histogram topologiesNumTasks = this.registerHistogram.apply("topologies:num-tasks");
        private final Histogram topologiesNumExecutors = this.registerHistogram.apply("topologies:num-executors");
        private final Histogram topologiesNumWorker = this.registerHistogram.apply("topologies:num-workers");
        private final Histogram topologiesUptime = this.registerHistogram.apply("topologies:uptime-secs");
        private final Histogram topologiesReplicationCount = this.registerHistogram.apply("topologies:replication-count");
        private final Histogram topologiesRequestedMemOnHeap = this.registerHistogram.apply("topologies:requested-mem-on-heap");
        private final Histogram topologiesRequestedMemOffHeap = this.registerHistogram.apply("topologies:requested-mem-off-heap");
        private final Histogram topologiesRequestedCpu = this.registerHistogram.apply("topologies:requested-cpu");
        private final Histogram topologiesAssignedMemOnHeap = this.registerHistogram.apply("topologies:assigned-mem-on-heap");
        private final Histogram topologiesAssignedMemOffHeap = this.registerHistogram.apply("topologies:assigned-mem-off-heap");
        private final Histogram topologiesAssignedCpu = this.registerHistogram.apply("topologies:assigned-cpu");
        private final StormMetricsRegistry metricsRegistry;

        ClusterSummaryMetricSet(StormMetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            assert (ClusterSummary._Fields.values().length == 3 && ClusterSummary._Fields.findByName((String)"supervisors") == ClusterSummary._Fields.SUPERVISORS && ClusterSummary._Fields.findByName((String)"topologies") == ClusterSummary._Fields.TOPOLOGIES && ClusterSummary._Fields.findByName((String)"nimbuses") == ClusterSummary._Fields.NIMBUSES);
            CachedGauge<ClusterSummary> cachedSummary = new CachedGauge<ClusterSummary>(5L, TimeUnit.SECONDS){

                protected ClusterSummary loadValue() {
                    try {
                        ClusterSummary newSummary = Nimbus.this.getClusterInfoImpl();
                        LOG.debug("The new summary is {}", (Object)newSummary);
                        ClusterSummaryMetricSet.this.updateHistogram(newSummary);
                        return newSummary;
                    }
                    catch (Exception e) {
                        LOG.warn("Get cluster info exception.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            };
            this.clusterSummaryMetrics.put("cluster:num-nimbus-leaders", (Metric)new DerivativeGauge<ClusterSummary, Long>((Gauge)cachedSummary){

                protected Long transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_nimbuses().stream().filter(NimbusSummary::is_isLeader).count();
                }
            });
            this.clusterSummaryMetrics.put("cluster:num-nimbuses", (Metric)new DerivativeGauge<ClusterSummary, Integer>((Gauge)cachedSummary){

                protected Integer transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_nimbuses_size();
                }
            });
            this.clusterSummaryMetrics.put("cluster:num-supervisors", (Metric)new DerivativeGauge<ClusterSummary, Integer>((Gauge)cachedSummary){

                protected Integer transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_supervisors_size();
                }
            });
            this.clusterSummaryMetrics.put("cluster:num-topologies", (Metric)new DerivativeGauge<ClusterSummary, Integer>((Gauge)cachedSummary){

                protected Integer transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_topologies_size();
                }
            });
            this.clusterSummaryMetrics.put("cluster:num-total-workers", (Metric)new DerivativeGauge<ClusterSummary, Integer>((Gauge)cachedSummary){

                protected Integer transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_supervisors().stream().mapToInt(SupervisorSummary::get_num_workers).sum();
                }
            });
            this.clusterSummaryMetrics.put("cluster:num-total-used-workers", (Metric)new DerivativeGauge<ClusterSummary, Integer>((Gauge)cachedSummary){

                protected Integer transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_supervisors().stream().mapToInt(SupervisorSummary::get_num_used_workers).sum();
                }
            });
            this.clusterSummaryMetrics.put("cluster:total-fragmented-memory-non-negative", (Metric)new DerivativeGauge<ClusterSummary, Double>((Gauge)cachedSummary){

                protected Double transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_supervisors().stream().mapToDouble(supervisorSummary -> Math.max(supervisorSummary.get_fragmented_mem(), 0.0)).sum();
                }
            });
            this.clusterSummaryMetrics.put("cluster:total-fragmented-cpu-non-negative", (Metric)new DerivativeGauge<ClusterSummary, Double>((Gauge)cachedSummary){

                protected Double transform(ClusterSummary clusterSummary) {
                    return clusterSummary.get_supervisors().stream().mapToDouble(supervisorSummary -> Math.max(supervisorSummary.get_fragmented_cpu(), 0.0)).sum();
                }
            });
        }

        private void updateHistogram(ClusterSummary newSummary) {
            for (NimbusSummary nimbusSummary : newSummary.get_nimbuses()) {
                this.nimbusUptime.update(nimbusSummary.get_uptime_secs());
            }
            for (SupervisorSummary summary : newSummary.get_supervisors()) {
                this.supervisorsUptime.update(summary.get_uptime_secs());
                this.supervisorsNumWorkers.update(summary.get_num_workers());
                this.supervisorsNumUsedWorkers.update(summary.get_num_used_workers());
                this.supervisorsUsedMem.update(Math.round(summary.get_used_mem()));
                this.supervisorsUsedCpu.update(Math.round(summary.get_used_cpu()));
                this.supervisorsFragmentedMem.update(Math.round(summary.get_fragmented_mem()));
                this.supervisorsFragmentedCpu.update(Math.round(summary.get_fragmented_cpu()));
            }
            for (SupervisorSummary summary : newSummary.get_topologies()) {
                this.topologiesNumTasks.update(summary.get_num_tasks());
                this.topologiesNumExecutors.update(summary.get_num_executors());
                this.topologiesNumWorker.update(summary.get_num_workers());
                this.topologiesUptime.update(summary.get_uptime_secs());
                this.topologiesReplicationCount.update(summary.get_replication_count());
                this.topologiesRequestedMemOnHeap.update(Math.round(summary.get_requested_memonheap()));
                this.topologiesRequestedMemOffHeap.update(Math.round(summary.get_requested_memoffheap()));
                this.topologiesRequestedCpu.update(Math.round(summary.get_requested_cpu()));
                this.topologiesAssignedMemOnHeap.update(Math.round(summary.get_assigned_memonheap()));
                this.topologiesAssignedMemOffHeap.update(Math.round(summary.get_assigned_memoffheap()));
                this.topologiesAssignedCpu.update(Math.round(summary.get_assigned_cpu()));
            }
        }

        void setActive(boolean active) {
            if (this.active != active) {
                this.active = active;
                if (active) {
                    this.metricsRegistry.registerAll(this.clusterSummaryMetrics);
                } else {
                    this.metricsRegistry.removeAll(this.clusterSummaryMetrics);
                }
            }
        }

        @Override
        public void run() {
            try {
                this.setActive(Nimbus.this.isLeader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ClusterSummaryMetrics
    implements MetricSet {
        private static final String SUMMARY = "summary";
        private final Map<String, Metric> metrics = new HashMap<String, Metric>();

        private ClusterSummaryMetrics() {
        }

        public Metric put(String key, Metric value) {
            return this.metrics.put(MetricRegistry.name((String)SUMMARY, (String[])new String[]{key}), value);
        }

        public Map<String, Metric> getMetrics() {
            return this.metrics;
        }
    }

    private static class CommonTopoInfo {
        public Map<String, Object> topoConf;
        public String topoName;
        public StormTopology topology;
        public Map<Integer, String> taskToComponent;
        public StormBase base;
        public int launchTimeSecs;
        public Assignment assignment;
        public Map<List<Integer>, Map<String, Object>> beats;
        public HashSet<String> allComponents;

        private CommonTopoInfo() {
        }
    }

    @VisibleForTesting
    public static class StandaloneINimbus
    implements INimbus {
        @Override
        public void prepare(Map<String, Object> topoConf, String schedulerLocalDir) {
        }

        @Override
        public Collection<WorkerSlot> allSlotsAvailableForScheduling(Collection<SupervisorDetails> supervisors, Topologies topologies, Set<String> topologiesMissingAssignments) {
            HashSet<WorkerSlot> ret = new HashSet<WorkerSlot>();
            for (SupervisorDetails sd : supervisors) {
                String id = sd.getId();
                for (Number port : (Collection)sd.getMeta()) {
                    ret.add(new WorkerSlot(id, port));
                }
            }
            return ret;
        }

        @Override
        public void assignSlots(Topologies topologies, Map<String, Collection<WorkerSlot>> newSlotsByTopologyId) {
        }

        @Override
        public String getHostName(Map<String, SupervisorDetails> supervisors, String nodeId) {
            SupervisorDetails sd = supervisors.get(nodeId);
            if (sd != null) {
                return sd.getHost();
            }
            return null;
        }

        @Override
        public IScheduler getForcedScheduler() {
            return null;
        }
    }

    private static final class Dissoc<K, V>
    implements UnaryOperator<Map<K, V>> {
        private final K key;

        Dissoc(K key) {
            this.key = key;
        }

        @Override
        public Map<K, V> apply(Map<K, V> t) {
            HashMap<K, V> ret = new HashMap<K, V>(t);
            ret.remove(this.key);
            return ret;
        }
    }

    private static final class Assoc<K, V>
    implements UnaryOperator<Map<K, V>> {
        private final K key;
        private final V value;

        Assoc(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Map<K, V> apply(Map<K, V> t) {
            HashMap<K, V> ret = new HashMap<K, V>(t);
            ret.put(this.key, this.value);
            return ret;
        }
    }
}

