/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.oci;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.storm.Config;
import org.apache.storm.DaemonConfig;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.WrappedInvalidTopologyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OciUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OciUtils.class);
    private static final String OCI_IMAGE_PATTERN = "^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$";
    private static final Pattern ociImagePattern = Pattern.compile("^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$");
    private static final String ASTERISK = "*";

    public static void adjustImageConfigForTopo(Map<String, Object> conf, Map<String, Object> topoConf, String topoId) throws InvalidTopologyException {
        List<String> allowedImages = OciUtils.getAllowedImages(conf, false);
        String topoImage = (String)topoConf.get(Config.TOPOLOGY_OCI_IMAGE);
        if (allowedImages.isEmpty()) {
            if (topoImage != null) {
                LOG.warn("{} is not configured; this indicates OCI container is not supported; {} config for topology {} will be removed", new Object[]{DaemonConfig.STORM_OCI_ALLOWED_IMAGES, Config.TOPOLOGY_OCI_IMAGE, topoId});
                topoConf.remove(Config.TOPOLOGY_OCI_IMAGE);
            }
        } else if (topoImage == null) {
            String defaultImage;
            topoImage = defaultImage = (String)conf.get(DaemonConfig.STORM_OCI_IMAGE);
            topoConf.put(Config.TOPOLOGY_OCI_IMAGE, topoImage);
            LOG.info("{} is not set for topology {}; set it to the default image {} configured in {}", new Object[]{Config.TOPOLOGY_OCI_IMAGE, topoId, defaultImage, DaemonConfig.STORM_OCI_IMAGE});
        } else {
            try {
                OciUtils.validateImage(allowedImages, topoImage, Config.TOPOLOGY_OCI_IMAGE);
            }
            catch (IllegalArgumentException e) {
                throw new WrappedInvalidTopologyException(e.getMessage());
            }
        }
    }

    public static void validateImageInDaemonConf(Map<String, Object> conf) {
        List<String> allowedImages = OciUtils.getAllowedImages(conf, true);
        if (allowedImages.isEmpty()) {
            LOG.debug("{} is not configured; skip image validation", (Object)DaemonConfig.STORM_OCI_ALLOWED_IMAGES);
        } else {
            String defaultImage = (String)conf.get(DaemonConfig.STORM_OCI_IMAGE);
            OciUtils.validateImage(allowedImages, defaultImage, DaemonConfig.STORM_OCI_IMAGE);
        }
    }

    private static void validateImage(List<String> allowedImages, String imageToValidate, String imageConfigKey) {
        if (imageToValidate == null) {
            throw new IllegalArgumentException(imageConfigKey + " is null");
        }
        if (!allowedImages.contains(ASTERISK) && !allowedImages.contains(imageToValidate)) {
            throw new IllegalArgumentException(imageConfigKey + "=" + imageToValidate + " is not in the list of " + DaemonConfig.STORM_OCI_ALLOWED_IMAGES + ": " + allowedImages);
        }
        if (!ociImagePattern.matcher(imageToValidate).matches()) {
            throw new IllegalArgumentException(imageConfigKey + "=" + imageToValidate + " doesn't match the pattern " + OCI_IMAGE_PATTERN);
        }
    }

    private static List<String> getAllowedImages(Map<String, Object> conf, boolean validationEnforced) {
        List allowedImages = ObjectReader.getStrings((Object)conf.get(DaemonConfig.STORM_OCI_ALLOWED_IMAGES));
        if (validationEnforced) {
            for (String image : allowedImages) {
                if (image.equals(ASTERISK) || ociImagePattern.matcher(image).matches()) continue;
                throw new IllegalArgumentException(image + " in the list of " + DaemonConfig.STORM_OCI_ALLOWED_IMAGES + " doesn't match the pattern " + OCI_IMAGE_PATTERN + " or is not " + ASTERISK);
            }
        }
        return allowedImages;
    }
}

