/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.storm.state.KeyValueState;
import org.apache.storm.state.State;
import org.apache.storm.state.StateFactory;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.IStatefulWindowedBolt;
import org.apache.storm.topology.WindowedBoltExecutor;
import org.apache.storm.topology.base.BaseWindowedBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.windowing.DefaultEvictionContext;
import org.apache.storm.windowing.EventImpl;
import org.apache.storm.windowing.WindowLifecycleListener;
import org.apache.storm.windowing.persistence.WindowState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentWindowedBoltExecutor<T extends State>
extends WindowedBoltExecutor
implements IStatefulBolt<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentWindowedBoltExecutor.class);
    private final IStatefulWindowedBolt<T> statefulWindowedBolt;
    private transient OutputCollector outputCollector;
    private transient WindowState<Tuple> state;
    private transient boolean stateInitialized;
    private transient boolean prePrepared;
    private transient KeyValueState<String, Optional<?>> windowSystemState;

    public PersistentWindowedBoltExecutor(IStatefulWindowedBolt<T> bolt) {
        super(bolt);
        this.statefulWindowedBolt = bolt;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        List registrations = topoConf.getOrDefault("topology.state.kryo.register", new ArrayList());
        registrations.add(ConcurrentLinkedQueue.class.getName());
        registrations.add(LinkedList.class.getName());
        registrations.add(AtomicInteger.class.getName());
        registrations.add(EventImpl.class.getName());
        registrations.add(WindowState.WindowPartition.class.getName());
        registrations.add(DefaultEvictionContext.class.getName());
        topoConf.put("topology.state.kryo.register", registrations);
        this.prepare(topoConf, context, collector, this.getWindowState(topoConf, context), this.getPartitionState(topoConf, context), this.getWindowSystemState(topoConf, context));
    }

    void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector, KeyValueState<Long, WindowState.WindowPartition<Tuple>> windowState, KeyValueState<String, Deque<Long>> partitionState, KeyValueState<String, Optional<?>> windowSystemState) {
        this.outputCollector = collector;
        this.windowSystemState = windowSystemState;
        this.state = new WindowState(windowState, partitionState, windowSystemState, this::getState, this.statefulWindowedBolt.maxEventsInMemory());
        this.doPrepare(topoConf, context, new NoAckOutputCollector(collector), this.state, true);
        this.restoreWindowSystemState();
    }

    private void restoreWindowSystemState() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.windowSystemState) {
            map.put((String)entry.getKey(), (Optional<?>)entry.getValue());
        }
        this.restoreState(map);
    }

    @Override
    protected void validate(Map<String, Object> topoConf, BaseWindowedBolt.Count windowLengthCount, BaseWindowedBolt.Duration windowLengthDuration, BaseWindowedBolt.Count slidingIntervalCount, BaseWindowedBolt.Duration slidingIntervalDuration) {
        int timeout;
        if (windowLengthCount == null && windowLengthDuration == null) {
            throw new IllegalArgumentException("Window length is not specified");
        }
        int interval = this.getCheckpointIntervalMillis(topoConf);
        if (interval > (timeout = this.getTopologyTimeoutMillis(topoConf))) {
            throw new IllegalArgumentException("topology.state.checkpoint.interval.ms" + interval + " is more than " + "topology.message.timeout.secs" + " value " + timeout);
        }
    }

    private int getCheckpointIntervalMillis(Map<String, Object> topoConf) {
        int checkpointInterval = Integer.MAX_VALUE;
        if (topoConf.get("topology.state.checkpoint.interval.ms") != null) {
            checkpointInterval = ((Number)topoConf.get("topology.state.checkpoint.interval.ms")).intValue();
        }
        return checkpointInterval;
    }

    @Override
    protected void start() {
        if (this.stateInitialized) {
            super.start();
        } else {
            LOG.debug("Will invoke start after state is initialized");
        }
    }

    @Override
    public void execute(Tuple input) {
        if (!this.stateInitialized) {
            throw new IllegalStateException("execute invoked before initState with input tuple " + input);
        }
        super.execute(input);
        this.outputCollector.ack(input);
    }

    @Override
    public void initState(T state) {
        if (this.stateInitialized) {
            String msg = "initState invoked when the state is already initialized";
            LOG.warn(msg);
            throw new IllegalStateException(msg);
        }
        this.statefulWindowedBolt.initState(state);
        this.stateInitialized = true;
        this.start();
    }

    @Override
    public void prePrepare(long txid) {
        if (!this.stateInitialized) {
            String msg = "Cannot prepare before initState";
            LOG.warn(msg);
            throw new IllegalStateException(msg);
        }
        LOG.debug("Prepare streamState, txid {}", (Object)txid);
        this.statefulWindowedBolt.prePrepare(txid);
        this.state.prepareCommit(txid);
        this.prePrepared = true;
    }

    @Override
    public void preCommit(long txid) {
        if (!this.prePrepared && this.stateInitialized) {
            String msg = "preCommit before prePrepare in initialized state";
            LOG.warn(msg);
            throw new IllegalStateException(msg);
        }
        LOG.debug("Commit streamState, txid {}", (Object)txid);
        this.statefulWindowedBolt.preCommit(txid);
        this.state.commit(txid);
    }

    @Override
    public void preRollback() {
        LOG.debug("Rollback streamState, stateInitialized {}", (Object)this.stateInitialized);
        this.statefulWindowedBolt.preRollback();
        this.state.rollback(this.stateInitialized);
        if (this.stateInitialized) {
            this.restoreWindowSystemState();
        }
    }

    @Override
    protected WindowLifecycleListener<Tuple> newWindowLifecycleListener() {
        return new WindowLifecycleListener<Tuple>(){

            @Override
            public void onExpiry(List<Tuple> events) {
            }

            @Override
            public void onActivation(Supplier<Iterator<Tuple>> eventsIt, Supplier<Iterator<Tuple>> newEventsIt, Supplier<Iterator<Tuple>> expiredIt, Long timestamp) {
                PersistentWindowedBoltExecutor.this.boltExecute(eventsIt, newEventsIt, expiredIt, timestamp);
                PersistentWindowedBoltExecutor.this.state.clearIteratorPins();
            }
        };
    }

    private KeyValueState<Long, WindowState.WindowPartition<Tuple>> getWindowState(Map<String, Object> topoConf, TopologyContext context) {
        String namespace = context.getThisComponentId() + "-" + context.getThisTaskId() + "-window";
        return (KeyValueState)StateFactory.getState(namespace, topoConf, context);
    }

    private KeyValueState<String, Deque<Long>> getPartitionState(Map<String, Object> topoConf, TopologyContext context) {
        String namespace = context.getThisComponentId() + "-" + context.getThisTaskId() + "-window-partitions";
        return (KeyValueState)StateFactory.getState(namespace, topoConf, context);
    }

    private KeyValueState<String, Optional<?>> getWindowSystemState(Map<String, Object> topoConf, TopologyContext context) {
        String namespace = context.getThisComponentId() + "-" + context.getThisTaskId() + "-window-systemstate";
        return (KeyValueState)StateFactory.getState(namespace, topoConf, context);
    }

    private static class NoAckOutputCollector
    extends OutputCollector {
        NoAckOutputCollector(OutputCollector delegate) {
            super(delegate);
        }

        @Override
        public void ack(Tuple input) {
        }
    }
}

