/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.utils.Time;

public class ClientStatsUtil {
    public static final String SPOUT = "spout";
    public static final String BOLT = "bolt";
    static final String EXECUTOR_STATS = "executor-stats";
    static final String UPTIME = "uptime";
    public static final String TIME_SECS = "time-secs";
    public static final ToGlobalStreamIdTransformer TO_GSID = new ToGlobalStreamIdTransformer();
    public static final IdentityTransformer IDENTITY = new IdentityTransformer();

    public static List<Integer> convertExecutor(List<Long> executor) {
        return Lists.newArrayList((Object[])new Integer[]{executor.get(0).intValue(), executor.get(1).intValue()});
    }

    public static Map<List<Integer>, ExecutorStats> mkEmptyExecutorZkHbs(Set<List<Long>> executors) {
        HashMap<List<Integer>, ExecutorStats> ret = new HashMap<List<Integer>, ExecutorStats>();
        Iterator<List<Long>> iterator = executors.iterator();
        while (iterator.hasNext()) {
            List<Long> executor;
            List<Long> startEnd = executor = iterator.next();
            ret.put(ClientStatsUtil.convertExecutor(startEnd), null);
        }
        return ret;
    }

    public static Map<List<Integer>, ExecutorStats> convertExecutorZkHbs(Map<List<Long>, ExecutorStats> executorBeats) {
        HashMap<List<Integer>, ExecutorStats> ret = new HashMap<List<Integer>, ExecutorStats>();
        for (Map.Entry<List<Long>, ExecutorStats> entry : executorBeats.entrySet()) {
            ret.put(ClientStatsUtil.convertExecutor(entry.getKey()), entry.getValue());
        }
        return ret;
    }

    public static Map<String, Object> mkZkWorkerHb(String topoId, Map<List<Integer>, ExecutorStats> executorStats, Integer uptime) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("storm-id", topoId);
        ret.put(EXECUTOR_STATS, executorStats);
        ret.put(UPTIME, uptime);
        ret.put(TIME_SECS, Time.currentTimeSecs());
        return ret;
    }

    private static Number getByKeyOr0(Map<String, Object> m, String k) {
        if (m == null) {
            return 0;
        }
        Number n = (Number)m.get(k);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static <K, V> Map<K, V> getMapByKey(Map map, String key) {
        if (map == null) {
            return null;
        }
        return (Map)map.get(key);
    }

    public static ClusterWorkerHeartbeat thriftifyZkWorkerHb(Map<String, Object> heartbeat) {
        ClusterWorkerHeartbeat ret = new ClusterWorkerHeartbeat();
        ret.set_uptime_secs(ClientStatsUtil.getByKeyOr0(heartbeat, UPTIME).intValue());
        ret.set_storm_id((String)heartbeat.get("storm-id"));
        ret.set_time_secs(ClientStatsUtil.getByKeyOr0(heartbeat, TIME_SECS).intValue());
        HashMap<ExecutorInfo, ExecutorStats> convertedStats = new HashMap<ExecutorInfo, ExecutorStats>();
        Map executorStats = ClientStatsUtil.getMapByKey(heartbeat, EXECUTOR_STATS);
        if (executorStats != null) {
            for (Map.Entry entry : executorStats.entrySet()) {
                List executor = (List)entry.getKey();
                ExecutorStats stats = (ExecutorStats)entry.getValue();
                if (null == stats) continue;
                convertedStats.put(new ExecutorInfo((Integer)executor.get(0), (Integer)executor.get(1)), stats);
            }
        }
        ret.set_executor_stats(convertedStats);
        return ret;
    }

    public static <K1, K2> Map windowSetConverter(Map stats, KeyTransformer<K2> secKeyFunc, KeyTransformer<K1> firstKeyFunc) {
        HashMap ret = new HashMap();
        for (Map.Entry o : stats.entrySet()) {
            Map.Entry entry = o;
            K1 key1 = firstKeyFunc.transform(entry.getKey());
            HashMap subRetMap = (HashMap)ret.get(key1);
            if (subRetMap == null) {
                subRetMap = new HashMap();
            }
            ret.put(key1, subRetMap);
            Map value = (Map)entry.getValue();
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry oo;
                Map.Entry subEntry = oo = iterator.next();
                K2 key2 = secKeyFunc.transform(subEntry.getKey());
                subRetMap.put(key2, subEntry.getValue());
            }
        }
        return ret;
    }

    static class IdentityTransformer
    implements KeyTransformer<Object> {
        IdentityTransformer() {
        }

        @Override
        public Object transform(Object key) {
            return key;
        }
    }

    static class ToGlobalStreamIdTransformer
    implements KeyTransformer<GlobalStreamId> {
        ToGlobalStreamIdTransformer() {
        }

        @Override
        public GlobalStreamId transform(Object key) {
            List l;
            if (key instanceof List && (l = (List)key).size() > 1) {
                return new GlobalStreamId((String)l.get(0), (String)l.get(1));
            }
            return new GlobalStreamId("", key.toString());
        }
    }

    static interface KeyTransformer<T> {
        public T transform(Object var1);
    }
}

