/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.kerberos;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import org.apache.storm.generated.WorkerToken;
import org.apache.storm.messaging.netty.Login;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.kerberos.ClientCallbackHandler;
import org.apache.storm.security.auth.kerberos.NoOpTTrasport;
import org.apache.storm.security.auth.kerberos.ServerCallbackHandler;
import org.apache.storm.security.auth.sasl.SaslTransportPlugin;
import org.apache.storm.security.auth.sasl.SimpleSaslServerCallbackHandler;
import org.apache.storm.security.auth.workertoken.WorkerTokenAuthorizer;
import org.apache.storm.security.auth.workertoken.WorkerTokenClientCallbackHandler;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.KerberosName;
import org.apache.storm.thrift.transport.TSaslClientTransport;
import org.apache.storm.thrift.transport.TSaslServerTransport;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslTransportPlugin
extends SaslTransportPlugin {
    public static final String KERBEROS = "GSSAPI";
    private static final String DIGEST = "DIGEST-MD5";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslTransportPlugin.class);
    private static final String DISABLE_LOGIN_CACHE = "disableLoginCache";
    private static Map<LoginCacheKey, Login> loginCache = new ConcurrentHashMap<LoginCacheKey, Login>();
    private WorkerTokenAuthorizer workerTokenAuthorizer;

    @Override
    public TTransportFactory getServerTransportFactory(boolean impersonationAllowed) throws IOException {
        if (this.workerTokenAuthorizer == null) {
            this.workerTokenAuthorizer = new WorkerTokenAuthorizer(this.conf, this.type);
        }
        ServerCallbackHandler serverCallbackHandler = new ServerCallbackHandler(this.conf, impersonationAllowed);
        String jaasConfFile = ClientAuthUtils.getJaasConf(this.conf);
        Subject subject = null;
        try {
            Login login = new Login("StormServer", serverCallbackHandler, jaasConfFile);
            subject = login.getSubject();
            login.startThreadIfNeeded();
        }
        catch (LoginException ex) {
            LOG.error("Server failed to login in principal:" + ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            throw new RuntimeException("Fail to verify user principal with section \"StormServer\" in login configuration file " + jaasConfFile);
        }
        String principal = ClientAuthUtils.get(this.conf, "StormServer", "principal");
        LOG.debug("principal:" + principal);
        KerberosName serviceKerberosName = new KerberosName(principal);
        String serviceName = serviceKerberosName.getServiceName();
        String hostName = serviceKerberosName.getHostName();
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.put("javax.security.sasl.qop", "auth");
        props.put("javax.security.sasl.server.authentication", "false");
        TSaslServerTransport.Factory factory = new TSaslServerTransport.Factory();
        factory.addServerDefinition(KERBEROS, serviceName, hostName, props, (CallbackHandler)serverCallbackHandler);
        factory.addServerDefinition(DIGEST, "storm_thrift_server", hostName, null, (CallbackHandler)new SimpleSaslServerCallbackHandler(impersonationAllowed, this.workerTokenAuthorizer));
        TUGIAssumingTransportFactory wrapFactory = new TUGIAssumingTransportFactory((TTransportFactory)factory, subject);
        LOG.info("SASL GSSAPI transport factory will be used");
        return wrapFactory;
    }

    private Login mkLogin() throws IOException {
        try {
            ClientCallbackHandler clientCallbackHandler = new ClientCallbackHandler(this.conf);
            Login login = new Login("StormClient", clientCallbackHandler, ClientAuthUtils.getJaasConf(this.conf));
            login.startThreadIfNeeded();
            return login;
        }
        catch (LoginException ex) {
            LOG.error("Server failed to login in principal:" + ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws IOException, TTransportException {
        WorkerToken token = WorkerTokenClientCallbackHandler.findWorkerTokenInSubject(this.type);
        if (token != null) {
            WorkerTokenClientCallbackHandler clientCallbackHandler = new WorkerTokenClientCallbackHandler(token);
            TSaslClientTransport wrapperTransport = new TSaslClientTransport(DIGEST, null, "storm_thrift_server", serverHost, null, (CallbackHandler)clientCallbackHandler, transport);
            wrapperTransport.open();
            LOG.debug("SASL DIGEST-MD5 WorkerToken client transport has been established");
            return wrapperTransport;
        }
        return this.kerberosConnect(transport, serverHost, asUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTransport kerberosConnect(TTransport transport, String serverHost, String asUser) throws IOException {
        Login login;
        SortedMap<String, ?> authConf = ClientAuthUtils.pullConfig(this.conf, "StormClient");
        if (authConf == null) {
            throw new RuntimeException("Error in parsing the kerberos login Configuration, returned null");
        }
        boolean disableLoginCache = false;
        if (authConf.containsKey(DISABLE_LOGIN_CACHE)) {
            disableLoginCache = Boolean.valueOf((String)authConf.get(DISABLE_LOGIN_CACHE));
        }
        LoginCacheKey key = new LoginCacheKey(authConf);
        if (disableLoginCache) {
            LOG.debug("Kerberos Login Cache is disabled, attempting to contact the Kerberos Server");
            login = this.mkLogin();
            loginCache.remove(key);
        } else {
            LOG.debug("Trying to get the Kerberos Login from the Login Cache");
            login = loginCache.get(key);
            if (login == null) {
                Map<LoginCacheKey, Login> map = loginCache;
                synchronized (map) {
                    login = loginCache.get(key);
                    if (login == null) {
                        LOG.debug("Kerberos Login was not found in the Login Cache, attempting to contact the Kerberos Server");
                        login = this.mkLogin();
                        loginCache.put(key, login);
                    }
                }
            }
        }
        Subject subject = login.getSubject();
        if (subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            throw new RuntimeException("Fail to verify user principal with section \"StormClient\" in login configuration file " + ClientAuthUtils.getJaasConf(this.conf));
        }
        final String principal = StringUtils.isBlank((String)asUser) ? this.getPrincipal(subject) : asUser;
        String serviceName = ClientAuthUtils.get(this.conf, "StormClient", "serviceName");
        if (serviceName == null) {
            serviceName = "storm_thrift_server";
        }
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.put("javax.security.sasl.qop", "auth");
        props.put("javax.security.sasl.server.authentication", "false");
        LOG.debug("SASL GSSAPI client transport is being established");
        TSaslClientTransport sasalTransport = new TSaslClientTransport(KERBEROS, principal, serviceName, serverHost, props, null, transport);
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>((TTransport)sasalTransport){
                final /* synthetic */ TTransport val$sasalTransport;
                {
                    this.val$sasalTransport = tTransport;
                }

                @Override
                public Void run() {
                    try {
                        LOG.debug("do as:" + principal);
                        this.val$sasalTransport.open();
                    }
                    catch (Exception e) {
                        LOG.error("Client failed to open SaslClientTransport to interact with a server during session initiation: " + e, (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        return sasalTransport;
    }

    private String getPrincipal(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null || principals.size() < 1) {
            LOG.info("No principal found in login subject");
            return null;
        }
        return ((Principal)principals.toArray()[0]).getName();
    }

    @Override
    public boolean areWorkerTokensSupported() {
        return true;
    }

    @Override
    public void close() {
        this.workerTokenAuthorizer.close();
    }

    private class LoginCacheKey {
        private String keyString = null;

        LoginCacheKey(SortedMap<String, ?> authConf) throws IOException {
            StringBuilder stringBuilder;
            if (authConf != null) {
                stringBuilder = new StringBuilder();
                for (String configKey : authConf.keySet()) {
                    if (configKey.equals(KerberosSaslTransportPlugin.DISABLE_LOGIN_CACHE)) continue;
                    String configValue = (String)authConf.get(configKey);
                    stringBuilder.append(configKey);
                    stringBuilder.append(configValue);
                }
            } else {
                throw new IllegalArgumentException("Configuration should not be null");
            }
            this.keyString = stringBuilder.toString();
        }

        public int hashCode() {
            return this.keyString.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof LoginCacheKey && this.keyString.equals(((LoginCacheKey)obj).keyString);
        }

        public String toString() {
            return this.keyString;
        }
    }

    static class TUGIAssumingTransportFactory
    extends TTransportFactory {
        private final Subject subject;
        private final TTransportFactory wrapped;

        TUGIAssumingTransportFactory(TTransportFactory wrapped, Subject subject) {
            this.wrapped = wrapped;
            this.subject = subject;
            Set<Principal> principals = subject.getPrincipals();
            if (principals.size() > 0) {
                LOG.info("Service principal:" + ((Principal)principals.toArray()[0]).getName());
            }
        }

        public TTransport getTransport(TTransport trans) {
            try {
                return Subject.doAs(this.subject, () -> {
                    try {
                        return this.wrapped.getTransport(trans);
                    }
                    catch (Exception e) {
                        LOG.debug("Storm server failed to open transport to interact with a client during session initiation: " + e, (Throwable)e);
                        return new NoOpTTrasport(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LOG.error("Storm server experienced a PrivilegedActionException exception while creating a transport using a JAAS principal context:" + e, (Throwable)e);
                return null;
            }
        }
    }
}

