/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.ScheduledStormReporter;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteStormReporter
extends ScheduledStormReporter {
    public static final String GRAPHITE_PREFIXED_WITH = "graphite.prefixed.with";
    public static final String GRAPHITE_HOST = "graphite.host";
    public static final String GRAPHITE_PORT = "graphite.port";
    public static final String GRAPHITE_TRANSPORT = "graphite.transport";
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteStormReporter.class);

    private static String getMetricsPrefixedWith(Map<String, Object> reporterConf) {
        return ObjectReader.getString(reporterConf.get(GRAPHITE_PREFIXED_WITH), null);
    }

    private static String getMetricsTargetHost(Map<String, Object> reporterConf) {
        return ObjectReader.getString(reporterConf.get(GRAPHITE_HOST), null);
    }

    private static Integer getMetricsTargetPort(Map<String, Object> reporterConf) {
        return ObjectReader.getInt(reporterConf.get(GRAPHITE_PORT), null);
    }

    private static String getMetricsTargetTransport(Map<String, Object> reporterConf) {
        return ObjectReader.getString(reporterConf.get(GRAPHITE_TRANSPORT), "tcp");
    }

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> topoConf, Map<String, Object> reporterConf) {
        String prefix;
        StormMetricsFilter filter;
        TimeUnit rateUnit;
        LOG.debug("Preparing...");
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)metricsRegistry);
        TimeUnit durationUnit = ClientMetricsUtils.getMetricsDurationUnit(reporterConf);
        if (durationUnit != null) {
            builder.convertDurationsTo(durationUnit);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(reporterConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((filter = GraphiteStormReporter.getMetricsFilter(reporterConf)) != null) {
            builder.filter((MetricFilter)filter);
        }
        if ((prefix = GraphiteStormReporter.getMetricsPrefixedWith(reporterConf)) != null) {
            builder.prefixedWith(prefix);
        }
        this.reportingPeriod = GraphiteStormReporter.getReportPeriod(reporterConf);
        this.reportingPeriodUnit = GraphiteStormReporter.getReportPeriodUnit(reporterConf);
        String host = GraphiteStormReporter.getMetricsTargetHost(reporterConf);
        Integer port = GraphiteStormReporter.getMetricsTargetPort(reporterConf);
        String transport = GraphiteStormReporter.getMetricsTargetTransport(reporterConf);
        Object sender = null;
        sender = transport.equalsIgnoreCase("udp") ? new GraphiteUDP(host, port.intValue()) : new Graphite(host, port.intValue());
        this.reporter = builder.build((GraphiteSender)sender);
    }
}

