/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.cgroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.container.cgroup.CgroupCenter;
import org.apache.storm.container.cgroup.CgroupCoreFactory;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CGroupMetricsBase {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupMetricsBase.class);
    protected boolean enabled;
    protected CgroupCore core = null;

    public CGroupMetricsBase(Map<String, Object> conf, SubSystemType type) {
        String cgroupPath;
        String simpleName = this.getClass().getSimpleName();
        this.enabled = false;
        CgroupCenter center = CgroupCenter.getInstance();
        if (center == null) {
            LOG.warn("{} is disabled. cgroups do not appear to be enabled on this system", (Object)simpleName);
            return;
        }
        if (!center.isSubSystemEnabled(type)) {
            LOG.warn("{} is disabled. {} is not an enabled subsystem", (Object)simpleName, (Object)type);
            return;
        }
        if (null == center.getHierarchyWithSubSystem(type)) {
            LOG.warn("{} is disabled. {} is not a mounted subsystem", (Object)simpleName, (Object)type);
            return;
        }
        File cgroupFile = new File("/proc/self/cgroup");
        if (!cgroupFile.exists()) {
            LOG.warn("{} is disabled we do not appear to be a part of a CGroup", (Object)this.getClass().getSimpleName());
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(cgroupFile));){
            String line = reader.readLine();
            String[] parts = line.split(":");
            cgroupPath = parts[2];
        }
        catch (Exception e) {
            LOG.warn("{} is disabled error trying to read or parse {}", (Object)simpleName, (Object)cgroupFile);
            return;
        }
        String hierarchyDir = (String)conf.get("storm.cgroup.hierarchy.dir");
        if (StringUtils.isEmpty((String)hierarchyDir) || !new File(hierarchyDir, cgroupPath).exists()) {
            LOG.info("{} is not set or does not exist. checking {}", (Object)"storm.cgroup.hierarchy.dir", (Object)Config.STORM_OCI_CGROUP_ROOT);
            String ociCgroupRoot = (String)conf.get(Config.STORM_OCI_CGROUP_ROOT);
            hierarchyDir = ociCgroupRoot + File.separator + (Object)((Object)type);
            if (StringUtils.isEmpty((String)ociCgroupRoot) || !new File(hierarchyDir, cgroupPath).exists()) {
                LOG.info("{} is not set or does not exist", (Object)Config.STORM_OCI_CGROUP_ROOT);
                LOG.warn("{} is disabled", (Object)simpleName);
                return;
            }
        }
        this.core = CgroupCoreFactory.getInstance(type, new File(hierarchyDir, cgroupPath).getAbsolutePath());
        this.enabled = true;
        LOG.info("Metric {} is ENABLED and directory {} exists...", (Object)simpleName, (Object)hierarchyDir);
    }
}

