/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class TaskMetricRepo {
    private ConcurrentHashMap<String, Gauge> gauges = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Histogram> histograms = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Meter> meters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Timer> timers = new ConcurrentHashMap();

    public void addCounter(String name, Counter counter) {
        this.counters.put(name, counter);
    }

    public void addGauge(String name, Gauge gauge) {
        this.gauges.put(name, gauge);
    }

    public void addMeter(String name, Meter meter) {
        this.meters.put(name, meter);
    }

    public void addHistogram(String name, Histogram histogram) {
        this.histograms.put(name, histogram);
    }

    public void addTimer(String name, Timer timer) {
        this.timers.put(name, timer);
    }

    public void report(ScheduledReporter reporter, MetricFilter filter) {
        if (filter == null) {
            filter = MetricFilter.ALL;
        }
        TreeMap<String, Gauge> filteredGauges = new TreeMap<String, Gauge>();
        TreeMap<String, Gauge> filteredCounters = new TreeMap<String, Gauge>();
        TreeMap<String, Gauge> filteredHistograms = new TreeMap<String, Gauge>();
        TreeMap<String, Gauge> filteredMeters = new TreeMap<String, Gauge>();
        TreeMap<String, Gauge> filteredTimers = new TreeMap<String, Gauge>();
        for (Map.Entry<String, Gauge> entry : this.gauges.entrySet()) {
            if (!filter.matches(entry.getKey(), (Metric)entry.getValue())) continue;
            filteredGauges.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : this.counters.entrySet()) {
            if (!filter.matches(entry.getKey(), (Metric)entry.getValue())) continue;
            filteredCounters.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : this.histograms.entrySet()) {
            if (!filter.matches(entry.getKey(), (Metric)entry.getValue())) continue;
            filteredHistograms.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : this.meters.entrySet()) {
            if (!filter.matches(entry.getKey(), (Metric)entry.getValue())) continue;
            filteredMeters.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : this.timers.entrySet()) {
            if (!filter.matches(entry.getKey(), (Metric)entry.getValue())) continue;
            filteredTimers.put(entry.getKey(), entry.getValue());
        }
        reporter.report(filteredGauges, filteredCounters, filteredHistograms, filteredMeters, filteredTimers);
    }

    void degister(MetricFilter metricFilter) {
        this.gauges.entrySet().removeIf(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue()));
        this.counters.entrySet().removeIf(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue()));
        this.histograms.entrySet().removeIf(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue()));
        this.meters.entrySet().removeIf(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue()));
        this.timers.entrySet().removeIf(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue()));
    }
}

