/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.storm.grouping.Load;
import org.apache.storm.messaging.ConnectionWithStatus;
import org.apache.storm.messaging.IConnectionCallback;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.MessageBatch;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.messaging.netty.SaslUtils;
import org.apache.storm.messaging.netty.StormServerPipelineFactory;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IStatefulObject;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.shade.io.netty.bootstrap.ServerBootstrap;
import org.apache.storm.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelFuture;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelOption;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.group.ChannelGroup;
import org.apache.storm.shade.io.netty.channel.group.DefaultChannelGroup;
import org.apache.storm.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.storm.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.storm.shade.io.netty.util.concurrent.EventExecutor;
import org.apache.storm.shade.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Server
extends ConnectionWithStatus
implements IStatefulObject,
ISaslServer {
    public static final int LOAD_METRICS_TASK_ID = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private final EventLoopGroup bossEventLoopGroup;
    private final EventLoopGroup workerEventLoopGroup;
    private final ServerBootstrap bootstrap;
    private final ConcurrentHashMap<String, AtomicInteger> messagesEnqueued = new ConcurrentHashMap();
    private final AtomicInteger messagesDequeued = new AtomicInteger(0);
    private final int boundPort;
    private final Map<String, Object> topoConf;
    private final int port;
    private final ChannelGroup allChannels = new DefaultChannelGroup("storm-server", (EventExecutor)GlobalEventExecutor.INSTANCE);
    private final KryoValuesSerializer ser;
    private final IConnectionCallback cb;
    private final Supplier<Object> newConnectionResponse;
    private volatile boolean closing = false;
    private final boolean isNettyAuthRequired;

    Server(Map<String, Object> topoConf, int port, IConnectionCallback cb, Supplier<Object> newConnectionResponse) {
        this.topoConf = topoConf;
        this.isNettyAuthRequired = (Boolean)topoConf.get("storm.messaging.netty.authentication");
        this.port = port;
        this.ser = new KryoValuesSerializer(topoConf);
        this.cb = cb;
        this.newConnectionResponse = newConnectionResponse;
        int bufferSize = ObjectReader.getInt(topoConf.get("storm.messaging.netty.buffer_size"));
        int maxWorkers = ObjectReader.getInt(topoConf.get("storm.messaging.netty.server_worker_threads"));
        NettyRenameThreadFactory bossFactory = new NettyRenameThreadFactory(this.netty_name() + "-boss");
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory(this.netty_name() + "-worker");
        this.bossEventLoopGroup = new NioEventLoopGroup(1, (ThreadFactory)bossFactory);
        this.workerEventLoopGroup = new NioEventLoopGroup(maxWorkers > 0 ? maxWorkers : 0, (ThreadFactory)workerFactory);
        LOG.info("Create Netty Server " + this.netty_name() + ", buffer_size: " + bufferSize + ", maxWorkers: " + maxWorkers);
        int backlog = ObjectReader.getInt(topoConf.get("storm.messaging.netty.socket.backlog"), 500);
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossEventLoopGroup, this.workerEventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)backlog)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_RCVBUF, (Object)bufferSize).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new StormServerPipelineFactory(topoConf, this));
        try {
            ChannelFuture bindFuture = this.bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
            Channel channel = bindFuture.channel();
            this.boundPort = ((InetSocketAddress)channel.localAddress()).getPort();
            this.allChannels.add((Object)channel);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void addReceiveCount(String from, int amount) {
        AtomicInteger i = this.messagesEnqueued.get(from);
        if (i == null) {
            i = new AtomicInteger(amount);
            AtomicInteger prev = this.messagesEnqueued.putIfAbsent(from, i);
            if (prev != null) {
                prev.addAndGet(amount);
            }
        } else {
            i.addAndGet(amount);
        }
    }

    protected void enqueue(List<TaskMessage> msgs, String from) throws InterruptedException {
        if (null == msgs || msgs.isEmpty() || this.closing) {
            return;
        }
        this.addReceiveCount(from, msgs.size());
        this.cb.recv(msgs);
    }

    @Override
    public int getPort() {
        return this.boundPort;
    }

    @Override
    public void close() {
        this.allChannels.close().awaitUninterruptibly();
        this.workerEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
        this.bossEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLoadMetrics(Map<Integer, Double> taskToLoad) {
        MessageBatch mb = new MessageBatch(1);
        KryoValuesSerializer kryoValuesSerializer = this.ser;
        synchronized (kryoValuesSerializer) {
            mb.add(new TaskMessage(-1, this.ser.serialize(Collections.singletonList(taskToLoad))));
        }
        this.allChannels.writeAndFlush((Object)mb);
    }

    @Override
    public void sendBackPressureStatus(BackPressureStatus bpStatus) {
        LOG.info("Sending BackPressure status update to connected workers. BPStatus = {}", (Object)bpStatus);
        this.allChannels.writeAndFlush((Object)bpStatus);
    }

    @Override
    public Map<Integer, Load> getLoad(Collection<Integer> tasks) {
        throw new RuntimeException("Server connection cannot get load");
    }

    @Override
    public void send(Iterator<TaskMessage> msgs) {
        throw new UnsupportedOperationException("Server connection should not send any messages");
    }

    public final String netty_name() {
        return "Netty-server-localhost-" + this.port;
    }

    @Override
    public ConnectionWithStatus.Status status() {
        if (this.closing) {
            return ConnectionWithStatus.Status.Closed;
        }
        if (!this.connectionEstablished(this.allChannels)) {
            return ConnectionWithStatus.Status.Connecting;
        }
        return ConnectionWithStatus.Status.Ready;
    }

    private boolean connectionEstablished(Channel channel) {
        return channel != null && channel.isActive();
    }

    private boolean connectionEstablished(ChannelGroup allChannels) {
        boolean allEstablished = true;
        for (Channel channel : allChannels) {
            if (this.connectionEstablished(channel)) continue;
            allEstablished = false;
            break;
        }
        return allEstablished;
    }

    @Override
    public Object getState() {
        Object metrics;
        LOG.debug("Getting metrics for server on port {}", (Object)this.port);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("dequeuedMessages", this.messagesDequeued.getAndSet(0));
        HashMap<String, Integer> enqueued = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, AtomicInteger>> it = this.messagesEnqueued.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, AtomicInteger> ent = it.next();
            AtomicInteger i = ent.getValue();
            if (i.get() == 0) {
                it.remove();
                continue;
            }
            enqueued.put(ent.getKey(), i.getAndSet(0));
        }
        ret.put("enqueued", enqueued);
        if (this.cb instanceof IMetric && (metrics = ((IMetric)((Object)this.cb)).getValueAndReset()) instanceof Map) {
            ret.put("messageBytes", metrics);
        }
        return ret;
    }

    @Override
    public void channelActive(Channel c) {
        if (!this.isNettyAuthRequired) {
            this.authenticated(c);
        }
        this.allChannels.add((Object)c);
    }

    @Override
    public void received(Object message, String remote, Channel channel) throws InterruptedException {
        List msgs;
        try {
            msgs = (List)message;
        }
        catch (ClassCastException e) {
            LOG.error("Worker netty server received message other than the expected class List<TaskMessage> from remote: {}. Ignored.", (Object)remote, (Object)e);
            return;
        }
        this.enqueue(msgs, remote);
    }

    @Override
    public String name() {
        return (String)this.topoConf.get("topology.name");
    }

    @Override
    public String secretKey() {
        return SaslUtils.getSecretKey(this.topoConf);
    }

    @Override
    public void authenticated(Channel c) {
        if (this.isNettyAuthRequired) {
            LOG.debug("The channel {} is active and authenticated", (Object)c);
        } else {
            LOG.debug("The channel {} is active", (Object)c);
        }
        if (this.newConnectionResponse != null) {
            c.writeAndFlush(this.newConnectionResponse.get(), c.voidPromise());
        }
    }

    public String toString() {
        return String.format("Netty server listening on port %s", this.port);
    }
}

