/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.storm.grouping.Load;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.IConnectionCallback;
import org.apache.storm.messaging.IContext;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
implements IContext {
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);
    private final ConcurrentHashMap<String, LocalServer> registry = new ConcurrentHashMap();

    private static String getNodeKey(String nodeId, int port) {
        return nodeId + "-" + port;
    }

    private LocalServer createLocalServer(String nodeId, int port, IConnectionCallback cb) {
        LocalServer ret;
        String key = Context.getNodeKey(nodeId, port);
        LocalServer existing = this.registry.put(key, ret = new LocalServer(port, cb));
        if (existing != null) {
            LOG.info("Replacing existing server for key {}", new Object[]{existing, ret, key});
        }
        return ret;
    }

    @Override
    public void prepare(Map<String, Object> topoConf) {
    }

    @Override
    public IConnection bind(String stormId, int port, IConnectionCallback cb, Supplier<Object> newConnectionResponse) {
        return this.createLocalServer(stormId, port, cb);
    }

    @Override
    public IConnection connect(String stormId, String host, int port, AtomicBoolean[] remoteBpStatus) {
        return new LocalClient(stormId, port);
    }

    @Override
    public void term() {
    }

    private class LocalClient
    implements IConnection {
        private final LinkedBlockingQueue<TaskMessage> pendingDueToUnregisteredServer;
        private final ScheduledExecutorService pendingFlusher;
        private final int port;
        private final String registryKey;

        LocalClient(String stormId, int port) {
            this.port = port;
            this.registryKey = Context.getNodeKey(stormId, port);
            this.pendingDueToUnregisteredServer = new LinkedBlockingQueue();
            this.pendingFlusher = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("LocalClientFlusher-" + thread.getId());
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.pendingFlusher.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalClient.this.flushPending();
                    }
                    catch (Throwable t) {
                        LOG.error("Uncaught throwable in pending message flusher thread, messages may be lost", t);
                        throw new RuntimeException(t);
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }

        private void flushPending() {
            LocalServer server = (LocalServer)Context.this.registry.get(this.registryKey);
            if (server != null && !this.pendingDueToUnregisteredServer.isEmpty()) {
                ArrayList<TaskMessage> ret = new ArrayList<TaskMessage>();
                this.pendingDueToUnregisteredServer.drainTo(ret);
                server.cb.recv(ret);
            }
        }

        @Override
        public void send(Iterator<TaskMessage> msgs) {
            LocalServer server = (LocalServer)Context.this.registry.get(this.registryKey);
            if (server != null) {
                this.flushPending();
                ArrayList<TaskMessage> ret = new ArrayList<TaskMessage>();
                while (msgs.hasNext()) {
                    ret.add(msgs.next());
                }
                server.cb.recv(ret);
            } else {
                while (msgs.hasNext()) {
                    this.pendingDueToUnregisteredServer.add(msgs.next());
                }
            }
        }

        @Override
        public Map<Integer, Load> getLoad(Collection<Integer> tasks) {
            LocalServer server = (LocalServer)Context.this.registry.get(this.registryKey);
            if (server != null) {
                return server.getLoad(tasks);
            }
            return Collections.emptyMap();
        }

        @Override
        public void sendLoadMetrics(Map<Integer, Double> taskToLoad) {
            LocalServer server = (LocalServer)Context.this.registry.get(this.registryKey);
            if (server != null) {
                server.sendLoadMetrics(taskToLoad);
            }
        }

        @Override
        public void sendBackPressureStatus(BackPressureStatus bpStatus) {
            throw new RuntimeException("Local Client connection should not send BackPressure status");
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void close() {
            this.pendingFlusher.shutdown();
            try {
                this.pendingFlusher.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while awaiting flusher shutdown", e);
            }
        }
    }

    private class LocalServer
    implements IConnection {
        final ConcurrentHashMap<Integer, Double> load = new ConcurrentHashMap();
        final int port;
        final IConnectionCallback cb;

        LocalServer(int port, IConnectionCallback cb) {
            this.port = port;
            this.cb = cb;
        }

        @Override
        public void send(Iterator<TaskMessage> msgs) {
            throw new IllegalArgumentException("SHOULD NOT HAPPEN");
        }

        @Override
        public Map<Integer, Load> getLoad(Collection<Integer> tasks) {
            HashMap<Integer, Load> ret = new HashMap<Integer, Load>();
            for (Integer task : tasks) {
                Double found = this.load.get(task);
                if (found == null) continue;
                ret.put(task, new Load(true, found, 0.0));
            }
            return ret;
        }

        @Override
        public void sendLoadMetrics(Map<Integer, Double> taskToLoad) {
            this.load.putAll(taskToLoad);
        }

        @Override
        public void sendBackPressureStatus(BackPressureStatus bpStatus) {
            throw new RuntimeException("Local Server connection should not send BackPressure status");
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void close() {
        }
    }
}

