/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.storm.Config;
import org.apache.storm.ICredentialsListener;
import org.apache.storm.StormTimer;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.GrouperFactory;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.Task;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.ExecutorShutdown;
import org.apache.storm.executor.ExecutorTransfer;
import org.apache.storm.executor.bolt.BoltExecutor;
import org.apache.storm.executor.error.IReportError;
import org.apache.storm.executor.error.ReportError;
import org.apache.storm.executor.error.ReportErrorAndDie;
import org.apache.storm.executor.spout.SpoutExecutor;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.DebugOptions;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.metrics2.RateCounter;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.shade.org.jctools.queues.MpscChunkedArrayQueue;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.shade.org.json.simple.parser.ParseException;
import org.apache.storm.stats.CommonStats;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.JCQueue;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executor
implements Callable,
JCQueue.Consumer {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    protected final WorkerState workerData;
    protected final WorkerTopologyContext workerTopologyContext;
    protected final List<Long> executorId;
    protected final List<Integer> taskIds;
    protected final String componentId;
    protected final AtomicBoolean openOrPrepareWasCalled;
    protected final Map<String, Object> topoConf;
    protected final Map<String, Object> conf;
    protected final String stormId;
    protected final HashMap sharedExecutorData;
    protected final CountDownLatch workerReady;
    protected final AtomicBoolean stormActive;
    protected final AtomicReference<Map<String, DebugOptions>> stormComponentDebug;
    protected final Runnable suicideFn;
    protected final IStormClusterState stormClusterState;
    protected final Map<Integer, String> taskToComponent;
    protected final Map<Integer, Map<Integer, Map<String, IMetric>>> intervalToTaskToMetricToRegistry;
    protected final Map<String, Map<String, LoadAwareCustomStreamGrouping>> streamToComponentToGrouper;
    protected final List<LoadAwareCustomStreamGrouping> groupers;
    protected final ReportErrorAndDie reportErrorDie;
    protected final BooleanSupplier sampler;
    protected final String type;
    protected final IReportError reportError;
    protected final Random rand;
    protected final JCQueue receiveQueue;
    protected final Map<String, String> credentials;
    protected final Boolean isDebug;
    protected final Boolean hasEventLoggers;
    protected final boolean ackingEnabled;
    protected final MpscChunkedArrayQueue<AddressedTuple> pendingEmits = new MpscChunkedArrayQueue(1024, (int)Math.pow(2.0, 30.0));
    private final AddressedTuple flushTuple;
    protected ExecutorTransfer executorTransfer;
    protected ArrayList<Task> idToTask;
    protected int idToTaskBase;
    protected String hostname;
    private static final double msDurationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    private AtomicBoolean needToRefreshCreds = new AtomicBoolean(false);
    private final RateCounter reportedErrorCount;
    private final boolean enableV2MetricsDataPoints;
    private final Integer v2MetricsTickInterval;

    protected Executor(WorkerState workerData, List<Long> executorId, Map<String, String> credentials, String type) {
        this.workerData = workerData;
        this.executorId = executorId;
        this.type = type;
        this.workerTopologyContext = workerData.getWorkerTopologyContext();
        this.taskIds = StormCommon.executorIdToTasks(executorId);
        this.componentId = this.workerTopologyContext.getComponentId(this.taskIds.get(0));
        this.openOrPrepareWasCalled = new AtomicBoolean(false);
        this.topoConf = this.normalizedComponentConf(workerData.getTopologyConf(), this.workerTopologyContext, this.componentId);
        this.receiveQueue = workerData.getExecutorReceiveQueueMap().get(executorId);
        this.stormId = workerData.getTopologyId();
        this.conf = workerData.getConf();
        this.sharedExecutorData = new HashMap();
        this.workerReady = workerData.getIsWorkerActive();
        this.stormActive = workerData.getIsTopologyActive();
        this.stormComponentDebug = workerData.getStormComponentToDebug();
        this.executorTransfer = new ExecutorTransfer(workerData, this.topoConf);
        this.suicideFn = workerData.getSuicideCallback();
        try {
            this.stormClusterState = ClusterUtils.mkStormClusterState(workerData.getStateStorage(), new ClusterStateContext(DaemonType.WORKER, this.topoConf));
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
        this.intervalToTaskToMetricToRegistry = new HashMap<Integer, Map<Integer, Map<String, IMetric>>>();
        this.taskToComponent = workerData.getTaskToComponent();
        this.streamToComponentToGrouper = this.outboundComponents(this.workerTopologyContext, this.componentId, this.topoConf);
        this.groupers = this.streamToComponentToGrouper != null ? this.streamToComponentToGrouper.values().stream().filter(Objects::nonNull).flatMap(m -> m.values().stream()).collect(Collectors.toList()) : Collections.emptyList();
        this.reportError = new ReportError(this.topoConf, this.stormClusterState, this.stormId, this.componentId, this.workerTopologyContext);
        this.reportErrorDie = new ReportErrorAndDie(this.reportError, this.suicideFn);
        this.sampler = ConfigUtils.mkStatsSampler(this.topoConf);
        this.isDebug = ObjectReader.getBoolean(this.topoConf.get("topology.debug"), false);
        this.rand = new Random(Utils.secureRandomLong());
        this.credentials = credentials;
        this.hasEventLoggers = StormCommon.hasEventLoggers(this.topoConf);
        this.ackingEnabled = StormCommon.hasAckers(this.topoConf);
        try {
            this.hostname = Utils.hostname();
        }
        catch (UnknownHostException ignored) {
            this.hostname = "";
        }
        this.flushTuple = AddressedTuple.createFlushTuple(this.workerTopologyContext);
        this.reportedErrorCount = workerData.getMetricRegistry().rateCounter("__reported-error-count", this.componentId, this.taskIds.get(0));
        this.enableV2MetricsDataPoints = ObjectReader.getBoolean(this.topoConf.get("topology.enable.v2.metrics.tick"), false);
        this.v2MetricsTickInterval = ObjectReader.getInt(this.topoConf.get("topology.v2.metrics.tick.interval.seconds"), 60);
    }

    public static Executor mkExecutor(WorkerState workerState, List<Long> executorId, Map<String, String> credentials) {
        List<Integer> taskIds;
        String componentId;
        WorkerTopologyContext workerTopologyContext = workerState.getWorkerTopologyContext();
        String type = Executor.getExecutorType(workerTopologyContext, componentId = workerTopologyContext.getComponentId((taskIds = StormCommon.executorIdToTasks(executorId)).get(0)));
        Executor executor = "spout".equals(type) ? new SpoutExecutor(workerState, executorId, credentials) : new BoltExecutor(workerState, executorId, credentials);
        int minId = Integer.MAX_VALUE;
        HashMap<Integer, Task> idToTask = new HashMap<Integer, Task>();
        for (Integer taskId : taskIds) {
            minId = Math.min(minId, taskId);
            try {
                Task task = new Task(executor, taskId);
                idToTask.put(taskId, task);
            }
            catch (IOException ex) {
                throw Utils.wrapInRuntime(ex);
            }
        }
        executor.idToTaskBase = minId;
        executor.idToTask = Utils.convertToArray(idToTask, minId);
        return executor;
    }

    private static String getExecutorType(WorkerTopologyContext workerTopologyContext, String componentId) {
        StormTopology topology = workerTopologyContext.getRawTopology();
        Map<String, SpoutSpec> spouts = topology.get_spouts();
        Map<String, Bolt> bolts = topology.get_bolts();
        if (spouts.containsKey(componentId)) {
            return "spout";
        }
        if (bolts.containsKey(componentId)) {
            return "bolt";
        }
        throw new RuntimeException("Could not find " + componentId + " in " + topology);
    }

    private static List<String> retrieveAllConfigKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        Field[] fields = Config.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String fieldValue = (String)fields[i].get(null);
                ret.add(fieldValue);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    public Queue<AddressedTuple> getPendingEmits() {
        return this.pendingEmits;
    }

    public ExecutorShutdown execute() throws Exception {
        LOG.info("Loading executor tasks " + this.componentId + ":" + this.executorId);
        String handlerName = this.componentId + "-executor" + this.executorId;
        Utils.SmartThread handler = Utils.asyncLoop(this, false, this.reportErrorDie, 5, true, true, handlerName);
        LOG.info("Finished loading executor " + this.componentId + ":" + this.executorId);
        return new ExecutorShutdown(this, Lists.newArrayList((Object[])new Utils.SmartThread[]{handler}), this.idToTask, this.receiveQueue);
    }

    public abstract void tupleActionFn(int var1, TupleImpl var2) throws Exception;

    @Override
    public void accept(Object event) {
        AddressedTuple addressedTuple = (AddressedTuple)event;
        int taskId = addressedTuple.getDest();
        TupleImpl tuple = (TupleImpl)addressedTuple.getTuple();
        if (this.isDebug.booleanValue()) {
            LOG.info("Processing received TUPLE: {} for TASK: {} ", (Object)tuple, (Object)taskId);
        }
        try {
            if (taskId != -2) {
                this.tupleActionFn(taskId, tuple);
            } else {
                for (Integer t : this.taskIds) {
                    this.tupleActionFn(t, tuple);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setNeedToRefreshCreds() {
        this.needToRefreshCreds.set(true);
    }

    protected void updateExecCredsIfRequired() {
        if (this.needToRefreshCreds.get()) {
            this.needToRefreshCreds.set(false);
            LOG.info("The credentials are being updated {}.", this.executorId);
            Credentials creds = this.workerData.getCredentials();
            this.idToTask.stream().map(Task::getTaskObject).filter(taskObject -> taskObject instanceof ICredentialsListener).forEach(taskObject -> ((ICredentialsListener)taskObject).setCredentials(creds == null ? null : creds.get_creds()));
        }
    }

    @Override
    public void flush() {
    }

    public void metricsTick(Task task, TupleImpl tuple) {
        try {
            Integer interval = tuple.getInteger(0);
            int taskId = task.getTaskId();
            Map<Integer, Map<String, IMetric>> taskToMetricToRegistry = this.intervalToTaskToMetricToRegistry.get(interval);
            Map<String, IMetric> nameToRegistry = null;
            if (taskToMetricToRegistry != null) {
                nameToRegistry = taskToMetricToRegistry.get(taskId);
            }
            ArrayList<IMetricsConsumer.DataPoint> dataPoints = new ArrayList<IMetricsConsumer.DataPoint>();
            if (nameToRegistry != null) {
                for (Map.Entry<String, IMetric> entry : nameToRegistry.entrySet()) {
                    IMetric metric = entry.getValue();
                    Object value = metric.getValueAndReset();
                    if (value == null) continue;
                    IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(entry.getKey(), value);
                    dataPoints.add(dataPoint);
                }
            }
            this.addV2Metrics(taskId, dataPoints, interval);
            if (!dataPoints.isEmpty()) {
                IMetricsConsumer.TaskInfo taskInfo = new IMetricsConsumer.TaskInfo(this.hostname, this.workerTopologyContext.getThisWorkerPort(), this.componentId, taskId, Time.currentTimeSecs(), interval);
                task.sendUnanchored("__metrics", new Values(taskInfo, dataPoints), this.executorTransfer, (Queue<AddressedTuple>)this.pendingEmits);
                this.executorTransfer.flush();
            }
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    private void addV2Metrics(int taskId, List<IMetricsConsumer.DataPoint> dataPoints, int interval) {
        if (!this.enableV2MetricsDataPoints) {
            return;
        }
        if (interval != this.v2MetricsTickInterval) {
            return;
        }
        this.processGauges(taskId, dataPoints);
        this.processCounters(taskId, dataPoints);
        this.processHistograms(taskId, dataPoints);
        this.processMeters(taskId, dataPoints);
        this.processTimers(taskId, dataPoints);
    }

    private void processGauges(int taskId, List<IMetricsConsumer.DataPoint> dataPoints) {
        Map<String, Gauge> gauges = this.workerData.getMetricRegistry().getTaskGauges(taskId);
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Object v = entry.getValue().getValue();
            if (!(v instanceof Number)) continue;
            IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(entry.getKey(), v);
            dataPoints.add(dataPoint);
        }
    }

    private void processCounters(int taskId, List<IMetricsConsumer.DataPoint> dataPoints) {
        Map<String, Counter> counters = this.workerData.getMetricRegistry().getTaskCounters(taskId);
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            Long value = entry.getValue().getCount();
            IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(entry.getKey(), value);
            dataPoints.add(dataPoint);
        }
    }

    private void processHistograms(int taskId, List<IMetricsConsumer.DataPoint> dataPoints) {
        Map<String, Histogram> histograms = this.workerData.getMetricRegistry().getTaskHistograms(taskId);
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            Snapshot snapshot = entry.getValue().getSnapshot();
            this.addSnapshotDatapoints(entry.getKey(), snapshot, dataPoints);
            IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(entry.getKey() + ".count", entry.getValue().getCount());
            dataPoints.add(dataPoint);
        }
    }

    private void processMeters(int taskId, List<IMetricsConsumer.DataPoint> dataPoints) {
        Map<String, Meter> meters = this.workerData.getMetricRegistry().getTaskMeters(taskId);
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            this.addMeteredDatapoints(entry.getKey(), (Metered)entry.getValue(), dataPoints);
        }
    }

    private void processTimers(int taskId, List<IMetricsConsumer.DataPoint> dataPoints) {
        Map<String, Timer> timers = this.workerData.getMetricRegistry().getTaskTimers(taskId);
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            Snapshot snapshot = entry.getValue().getSnapshot();
            this.addSnapshotDatapoints(entry.getKey(), snapshot, dataPoints);
            this.addMeteredDatapoints(entry.getKey(), (Metered)entry.getValue(), dataPoints);
        }
    }

    private void addMeteredDatapoints(String baseName, Metered metered, List<IMetricsConsumer.DataPoint> dataPoints) {
        IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(baseName + ".count", metered.getCount());
        dataPoints.add(dataPoint);
        this.addConvertedMetric(baseName, ".m1_rate", metered.getOneMinuteRate(), dataPoints, false);
        this.addConvertedMetric(baseName, ".m5_rate", metered.getFiveMinuteRate(), dataPoints, false);
        this.addConvertedMetric(baseName, ".m15_rate", metered.getFifteenMinuteRate(), dataPoints, false);
        this.addConvertedMetric(baseName, ".mean_rate", metered.getMeanRate(), dataPoints, false);
    }

    private void addSnapshotDatapoints(String baseName, Snapshot snapshot, List<IMetricsConsumer.DataPoint> dataPoints) {
        this.addConvertedMetric(baseName, ".max", snapshot.getMax(), dataPoints, true);
        this.addConvertedMetric(baseName, ".mean", snapshot.getMean(), dataPoints, true);
        this.addConvertedMetric(baseName, ".min", snapshot.getMin(), dataPoints, true);
        this.addConvertedMetric(baseName, ".stddev", snapshot.getStdDev(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p50", snapshot.getMedian(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p75", snapshot.get75thPercentile(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p95", snapshot.get95thPercentile(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p98", snapshot.get98thPercentile(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p99", snapshot.get99thPercentile(), dataPoints, true);
        this.addConvertedMetric(baseName, ".p999", snapshot.get999thPercentile(), dataPoints, true);
    }

    private void addConvertedMetric(String baseName, String suffix, double value, List<IMetricsConsumer.DataPoint> dataPoints, boolean needConversion) {
        IMetricsConsumer.DataPoint dataPoint = new IMetricsConsumer.DataPoint(baseName + suffix, needConversion ? this.convertDuration(value) : value);
        dataPoints.add(dataPoint);
    }

    private double convertDuration(double duration) {
        return duration * msDurationFactor;
    }

    protected void setupMetrics() {
        boolean v2TickScheduled = !this.enableV2MetricsDataPoints;
        for (Integer interval : this.intervalToTaskToMetricToRegistry.keySet()) {
            this.scheduleMetricsTick(interval);
            if (interval != this.v2MetricsTickInterval) continue;
            v2TickScheduled = true;
        }
        if (!v2TickScheduled) {
            LOG.info("Scheduling v2 metrics tick for interval {}", (Object)this.v2MetricsTickInterval);
            this.scheduleMetricsTick(this.v2MetricsTickInterval);
        }
    }

    private void scheduleMetricsTick(int interval) {
        StormTimer timerTask = this.workerData.getUserTimer();
        timerTask.scheduleRecurring(interval, interval, () -> {
            TupleImpl tuple = new TupleImpl(this.workerTopologyContext, new Values(new Object[]{interval}), "__system", -1, "__metrics_tick");
            AddressedTuple metricsTickTuple = new AddressedTuple(-2, tuple);
            try {
                this.receiveQueue.publish(metricsTickTuple);
                this.receiveQueue.flush();
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupted when publishing metrics. Setting interrupt flag.");
                Thread.currentThread().interrupt();
                return;
            }
        });
    }

    protected void setupTicks(boolean isSpout) {
        Integer tickTimeSecs = ObjectReader.getInt(this.topoConf.get("topology.tick.tuple.freq.secs"), null);
        if (tickTimeSecs != null) {
            boolean enableMessageTimeout = (Boolean)this.topoConf.get("topology.enable.message.timeouts");
            boolean isAcker = "__acker".equals(this.componentId);
            if (!isAcker && Utils.isSystemId(this.componentId) || !enableMessageTimeout && isSpout || !enableMessageTimeout && isAcker) {
                LOG.info("Timeouts disabled for executor {}:{}", (Object)this.componentId, this.executorId);
            } else {
                StormTimer timerTask = this.workerData.getUserTimer();
                timerTask.scheduleRecurring(tickTimeSecs, tickTimeSecs, () -> {
                    TupleImpl tuple = new TupleImpl(this.workerTopologyContext, new Values(new Object[]{tickTimeSecs}), "__system", -1, "__tick");
                    AddressedTuple tickTuple = new AddressedTuple(-2, tuple);
                    try {
                        this.receiveQueue.publish(tickTuple);
                        this.receiveQueue.flush();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Thread interrupted when emitting tick tuple. Setting interrupt flag.");
                        Thread.currentThread().interrupt();
                        return;
                    }
                });
            }
        }
    }

    public void reflectNewLoadMapping(LoadMapping loadMapping) {
        for (LoadAwareCustomStreamGrouping g : this.groupers) {
            g.refreshLoad(loadMapping);
        }
    }

    public boolean publishFlushTuple() {
        if (this.receiveQueue.tryPublishDirect(this.flushTuple)) {
            LOG.debug("Published Flush tuple to: {} ", (Object)this.getComponentId());
            return true;
        }
        LOG.debug("RecvQ is currently full, will retry publishing Flush Tuple later to : {}", (Object)this.getComponentId());
        return false;
    }

    private Map<String, Map<String, LoadAwareCustomStreamGrouping>> outboundComponents(WorkerTopologyContext workerTopologyContext, String componentId, Map<String, Object> topoConf) {
        HashMap<String, Map<String, LoadAwareCustomStreamGrouping>> ret = new HashMap<String, Map<String, LoadAwareCustomStreamGrouping>>();
        Map<String, Map<String, Grouping>> outputGroupings = workerTopologyContext.getTargets(componentId);
        for (Map.Entry<String, Map<String, Grouping>> entry : outputGroupings.entrySet()) {
            String streamId = entry.getKey();
            Map<String, Grouping> componentGrouping = entry.getValue();
            Fields outFields = workerTopologyContext.getComponentOutputFields(componentId, streamId);
            HashMap<String, LoadAwareCustomStreamGrouping> componentGrouper = new HashMap<String, LoadAwareCustomStreamGrouping>();
            for (Map.Entry<String, Grouping> cg : componentGrouping.entrySet()) {
                String component = cg.getKey();
                Grouping grouping = cg.getValue();
                List<Integer> outTasks = workerTopologyContext.getComponentTasks(component);
                LoadAwareCustomStreamGrouping grouper = GrouperFactory.mkGrouper(workerTopologyContext, componentId, streamId, outFields, grouping, outTasks, topoConf);
                componentGrouper.put(component, grouper);
            }
            if (componentGrouper.size() <= 0) continue;
            ret.put(streamId, componentGrouper);
        }
        for (String stream : workerTopologyContext.getComponentCommon(componentId).get_streams().keySet()) {
            if (ret.containsKey(stream)) continue;
            ret.put(stream, null);
        }
        return ret;
    }

    private Map<String, Object> normalizedComponentConf(Map<String, Object> topoConf, WorkerTopologyContext topologyContext, String componentId) {
        Map componentConf;
        List<String> keysToRemove = Executor.retrieveAllConfigKeys();
        keysToRemove.remove("topology.debug");
        keysToRemove.remove("topology.max.spout.pending");
        keysToRemove.remove("topology.max.task.parallelism");
        keysToRemove.remove("topology.transactional.id");
        keysToRemove.remove("topology.tick.tuple.freq.secs");
        keysToRemove.remove("topology.sleep.spout.wait.strategy.time.ms");
        keysToRemove.remove("topology.spout.wait.strategy");
        keysToRemove.remove("topology.bolts.window.length.count");
        keysToRemove.remove("topology.bolts.window.length.duration.ms");
        keysToRemove.remove("topology.bolts.window.sliding.interval.count");
        keysToRemove.remove("topology.bolts.window.sliding.interval.duration.ms");
        keysToRemove.remove("topology.bolts.tuple.timestamp.max.lag.ms");
        keysToRemove.remove("topology.bolts.message.id.field.name");
        keysToRemove.remove("topology.state.provider");
        keysToRemove.remove("topology.state.provider.config");
        keysToRemove.remove("topology.bolts.late.tuple.stream");
        String specJsonConf = topologyContext.getComponentCommon(componentId).get_json_conf();
        if (specJsonConf != null) {
            try {
                componentConf = (Map)JSONValue.parseWithException((String)specJsonConf);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            for (String p : keysToRemove) {
                componentConf.remove(p);
            }
        } else {
            componentConf = new HashMap();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.putAll(topoConf);
        ret.putAll(componentConf);
        return ret;
    }

    public List<Long> getExecutorId() {
        return this.executorId;
    }

    public List<Integer> getTaskIds() {
        return this.taskIds;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public AtomicBoolean getOpenOrPrepareWasCalled() {
        return this.openOrPrepareWasCalled;
    }

    public Map<String, Object> getTopoConf() {
        return this.topoConf;
    }

    public String getStormId() {
        return this.stormId;
    }

    public abstract CommonStats getStats();

    public String getType() {
        return this.type;
    }

    public Boolean getIsDebug() {
        return this.isDebug;
    }

    public ExecutorTransfer getExecutorTransfer() {
        return this.executorTransfer;
    }

    public IReportError getReportError() {
        return this.reportError;
    }

    public WorkerTopologyContext getWorkerTopologyContext() {
        return this.workerTopologyContext;
    }

    public boolean samplerCheck() {
        return this.sampler.getAsBoolean();
    }

    public AtomicReference<Map<String, DebugOptions>> getStormComponentDebug() {
        return this.stormComponentDebug;
    }

    public JCQueue getReceiveQueue() {
        return this.receiveQueue;
    }

    public IStormClusterState getStormClusterState() {
        return this.stormClusterState;
    }

    public WorkerState getWorkerData() {
        return this.workerData;
    }

    public Map<String, Map<String, LoadAwareCustomStreamGrouping>> getStreamToComponentToGrouper() {
        return this.streamToComponentToGrouper;
    }

    public HashMap getSharedExecutorData() {
        return this.sharedExecutorData;
    }

    public Map<Integer, Map<Integer, Map<String, IMetric>>> getIntervalToTaskToMetricToRegistry() {
        return this.intervalToTaskToMetricToRegistry;
    }

    @VisibleForTesting
    public void setLocalExecutorTransfer(ExecutorTransfer executorTransfer) {
        this.executorTransfer = executorTransfer;
    }

    public void incrementReportedErrorCount() {
        this.reportedErrorCount.inc(1L);
    }
}

