/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.drpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.drpc.DRPCInvocationsClient;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.generated.DistributedRPCInvocations;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.thrift.TException;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.DRPCClient;
import org.apache.storm.utils.ExtendedThreadPoolExecutor;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCSpout
extends BaseRichSpout {
    public static final Logger LOG = LoggerFactory.getLogger(DRPCSpout.class);
    private static final long serialVersionUID = 2387848310969237877L;
    private static final int clientConstructionRetryIntervalSec = 120;
    private final String function;
    private final String localDrpcId;
    private SpoutOutputCollector collector;
    private List<DRPCInvocationsClient> clients = Collections.synchronizedList(new ArrayList());
    private transient ExecutorService background = null;
    private transient Map<String, CompletableFuture<Void>> futuresMap = null;

    public DRPCSpout(String function) {
        this.function = function;
        this.localDrpcId = DRPCClient.isLocalOverride() ? DRPCClient.getOverrideServiceId() : null;
    }

    public DRPCSpout(String function, ILocalDRPC drpc) {
        this.function = function;
        this.localDrpcId = drpc.getServiceId();
    }

    public String get_function() {
        return this.function;
    }

    private void reconnectAsync(DRPCInvocationsClient client) {
        String remote = client.getHost();
        CompletableFuture<Void> future = this.futuresMap.get(remote);
        if (future.isDone()) {
            LOG.warn("DRPCInvocationsClient [{}:{}] connection failed, no pending reconnection. Try reconnecting...", (Object)client.getHost(), (Object)client.getPort());
            CompletableFuture<Void> newFuture = CompletableFuture.runAsync(() -> {
                try {
                    client.reconnectClient();
                    LOG.info("Reconnected to remote {}:{}. ", (Object)client.getHost(), (Object)client.getPort());
                }
                catch (Exception e) {
                    this.collector.reportError(e);
                    LOG.warn("Failed to reconnect to remote {}:{}. ", new Object[]{client.getHost(), client.getPort(), e});
                }
            }, this.background);
            this.futuresMap.put(remote, newFuture);
        }
    }

    private void reconnectSync(DRPCInvocationsClient client) {
        try {
            LOG.info("reconnecting... ");
            client.reconnectClient();
        }
        catch (TException e2) {
            LOG.error("Failed to connect to DRPC server", (Throwable)e2);
        }
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
        if (this.localDrpcId == null) {
            this.background = new ExtendedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.futuresMap = new HashMap<String, CompletableFuture<Void>>();
            int numTasks = context.getComponentTasks(context.getThisComponentId()).size();
            int index = context.getThisTaskIndex();
            int port = ObjectReader.getInt(conf.get("drpc.invocations.port"));
            List servers = (List)conf.get("drpc.servers");
            if (servers == null || servers.isEmpty()) {
                throw new RuntimeException("No DRPC servers configured for topology");
            }
            ArrayList<DRPCClientBuilder> clientBuilders = new ArrayList<DRPCClientBuilder>();
            if (numTasks < servers.size()) {
                for (String s : servers) {
                    clientBuilders.add(new DRPCClientBuilder(s, port, conf));
                }
            } else {
                int i = index % servers.size();
                clientBuilders.add(new DRPCClientBuilder((String)servers.get(i), port, conf));
            }
            this.establishConnections(clientBuilders);
        }
    }

    protected void establishConnections(List<DRPCClientBuilder> clientBuilders) {
        int numOfClients = clientBuilders.size();
        for (int i = 0; i < numOfClients; ++i) {
            DRPCClientBuilder builder = clientBuilders.get(i);
            String server = builder.getServer();
            CompletableFuture<Void> future = CompletableFuture.runAsync(builder, this.background);
            this.futuresMap.put(server, future);
        }
    }

    @Override
    public void close() {
        for (DRPCInvocationsClient client : this.clients) {
            client.close();
        }
        if (this.background != null) {
            this.background.shutdownNow();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void nextTuple() {
        if (this.localDrpcId == null) {
            for (int i = 0; i < this.clients.size(); ++i) {
                DRPCInvocationsClient client = this.clients.get(i);
                if (!client.isConnected()) {
                    this.reconnectAsync(client);
                    continue;
                }
                try {
                    DRPCRequest req = client.fetchRequest(this.function);
                    if (req.get_request_id().length() <= 0) continue;
                    HashMap<String, Object> returnInfo = new HashMap<String, Object>();
                    returnInfo.put("id", req.get_request_id());
                    returnInfo.put("host", client.getHost());
                    returnInfo.put("port", client.getPort());
                    this.collector.emit(new Values(req.get_func_args(), JSONValue.toJSONString(returnInfo)), new DRPCMessageId(req.get_request_id(), i));
                    return;
                }
                catch (AuthorizationException aze) {
                    LOG.error("Not authorized to fetch DRPC request from DRPC server [{}:{}]", new Object[]{client.getHost(), client.getPort(), aze});
                    this.reconnectAsync(client);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Failed to fetch DRPC request from DRPC server [{}:{}]", new Object[]{client.getHost(), client.getPort(), e});
                    this.reconnectAsync(client);
                }
            }
            return;
        }
        DistributedRPCInvocations.Iface drpc = (DistributedRPCInvocations.Iface)ServiceRegistry.getService(this.localDrpcId);
        if (drpc == null) return;
        try {
            DRPCRequest req = drpc.fetchRequest(this.function);
            if (req.get_request_id().length() <= 0) return;
            HashMap<String, Object> returnInfo = new HashMap<String, Object>();
            returnInfo.put("id", req.get_request_id());
            returnInfo.put("host", this.localDrpcId);
            returnInfo.put("port", 0);
            this.collector.emit(new Values(req.get_func_args(), JSONValue.toJSONString(returnInfo)), new DRPCMessageId(req.get_request_id(), 0));
            return;
        }
        catch (AuthorizationException aze) {
            throw new RuntimeException((Throwable)((Object)aze));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void ack(Object msgId) {
    }

    @Override
    public void fail(Object msgId) {
        DRPCMessageId did = (DRPCMessageId)msgId;
        DistributedRPCInvocations.Iface client = this.localDrpcId == null ? (DistributedRPCInvocations.Iface)this.clients.get(did.index) : (DistributedRPCInvocations.Iface)ServiceRegistry.getService(this.localDrpcId);
        int maxRetries = 3;
        for (int retryCnt = 0; retryCnt < maxRetries; ++retryCnt) {
            try {
                client.failRequest(did.id);
                break;
            }
            catch (AuthorizationException aze) {
                LOG.error("Not authorized to failRequest from DRPC server", (Throwable)((Object)aze));
                throw new RuntimeException((Throwable)((Object)aze));
            }
            catch (TException tex) {
                if (retryCnt >= maxRetries) {
                    LOG.error("Failed to fail request", (Throwable)tex);
                    break;
                }
                this.reconnectSync((DRPCInvocationsClient)client);
                continue;
            }
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("args", "return-info"));
    }

    private class DRPCClientBuilder
    implements Runnable {
        private String server;
        private int port;
        private Map<String, Object> conf;

        DRPCClientBuilder(String server, int port, Map<String, Object> conf) {
            this.server = server;
            this.port = port;
            this.conf = conf;
        }

        @Override
        public void run() {
            DRPCInvocationsClient c = null;
            while (c == null) {
                try {
                    c = new DRPCInvocationsClient(this.conf, this.server, this.port);
                }
                catch (Exception e) {
                    DRPCSpout.this.collector.reportError(e);
                    LOG.error("Failed to create DRPCInvocationsClient for remote {}:{}. Retrying after {} secs.", new Object[]{this.server, this.port, 120, e});
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("DRPCInvocationsClient creation retry sleep interrupted.");
                        break;
                    }
                }
            }
            if (c != null) {
                LOG.info("Successfully created DRPCInvocationsClient for remote {}:{}.", (Object)this.server, (Object)this.port);
                DRPCSpout.this.clients.add(c);
            } else {
                LOG.warn("DRPCInvocationsClient creation retry for remote {}:{} interrupted.", (Object)this.server, (Object)this.port);
            }
        }

        public String getServer() {
            return this.server;
        }
    }

    private static class DRPCMessageId {
        String id;
        int index;

        DRPCMessageId(String id, int index) {
            this.id = id;
            this.index = index;
        }
    }
}

