/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.storm.generated.SettableBlobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreFile {
    public static final Logger LOG = LoggerFactory.getLogger(BlobStoreFile.class);
    protected static final String TMP_EXT = ".tmp";
    protected static final Pattern TMP_NAME_PATTERN = Pattern.compile("^\\d+\\.tmp$");
    protected static final String BLOBSTORE_DATA_FILE = "data";

    public abstract void delete() throws IOException;

    public abstract String getKey();

    public abstract boolean isTmp();

    public abstract SettableBlobMeta getMetadata();

    public abstract void setMetadata(SettableBlobMeta var1);

    public abstract long getModTime() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void commit() throws IOException;

    public abstract void cancel() throws IOException;

    public abstract long getFileLength() throws IOException;
}

