/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.submit.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.storm.submit.dependency.Booter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class DependencyResolver {
    private final RepositorySystem system = Booter.newRepositorySystem();
    private final RepositorySystemSession session;
    private List<RemoteRepository> remoteRepositories;
    private Proxy proxy;

    public DependencyResolver(String localRepoPath) {
        this(localRepoPath, Collections.emptyList());
    }

    public DependencyResolver(String localRepoPath, List<RemoteRepository> repositories) {
        localRepoPath = this.handleRelativePath(localRepoPath);
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
        this.remoteRepositories = new ArrayList<RemoteRepository>();
        this.remoteRepositories.add(Booter.newCentralRepository());
        this.remoteRepositories.addAll(repositories);
    }

    public void setProxy(Proxy proxyParam) {
        this.proxy = proxyParam;
        this.applyProxy();
    }

    private String handleRelativePath(String localRepoPath) {
        File repoDir = new File(localRepoPath);
        if (!repoDir.isAbsolute()) {
            String home = System.getProperty("storm.home");
            if (home == null) {
                home = ".";
            }
            localRepoPath = home + "/" + localRepoPath;
        }
        return localRepoPath;
    }

    public List<ArtifactResult> resolve(List<Dependency> dependencies) throws DependencyResolutionException, ArtifactResolutionException {
        if (dependencies.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependencies.get(0));
        for (int idx = 1; idx < dependencies.size(); ++idx) {
            collectRequest.addDependency(dependencies.get(idx));
        }
        for (RemoteRepository repository : this.remoteRepositories) {
            collectRequest.addRepository(repository);
        }
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
        return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
    }

    private void applyProxy() {
        ArrayList<RemoteRepository> appliedRepositories = new ArrayList<RemoteRepository>(this.remoteRepositories.size());
        for (RemoteRepository repository : this.remoteRepositories) {
            appliedRepositories.add(new RemoteRepository.Builder(repository).setProxy(this.proxy).build());
        }
        this.remoteRepositories = appliedRepositories;
    }
}

