/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.storm.hdfs.security.AutoHDFS;
import org.apache.storm.hdfs.security.AutoHDFSNimbus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoHDFSCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHDFSCommand.class);

    private AutoHDFSCommand() {
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("hdfs.kerberos.principal", args[1]);
        conf.put("hdfs.keytab.file", args[2]);
        AutoHDFS autoHdfs = new AutoHDFS();
        autoHdfs.prepare(conf);
        AutoHDFSNimbus autoHdfsNimbus = new AutoHDFSNimbus();
        autoHdfsNimbus.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHdfsNimbus.populateCredentials(creds, conf, args[0]);
        LOG.info("Got HDFS credentials", autoHdfs.getCredentials(creds));
        Subject s = new Subject();
        autoHdfs.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHdfsNimbus.renew(creds, conf, args[0]);
        LOG.info("renewed credentials", autoHdfs.getCredentials(creds));
    }
}

