/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashSet;
import java.util.Map;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.ExecutorSummary;
import org.apache.storm.generated.GetInfoOptions;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NumErrorsChoice;
import org.apache.storm.generated.TopologyInfo;

public class Monitor {
    private static final String WATCH_TRANSFERRED = "transferred";
    private static final String WATCH_EMITTED = "emitted";
    private int interval = 4;
    private String topology;
    private String component;
    private String stream;
    private String watch;

    private HashSet<String> getComponents(Nimbus.Iface client, String topology) throws Exception {
        HashSet<String> components = new HashSet<String>();
        GetInfoOptions getInfoOpts = new GetInfoOptions();
        getInfoOpts.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo info = client.getTopologyInfoByNameWithOpts(topology, getInfoOpts);
        for (ExecutorSummary es : info.get_executors()) {
            components.add(es.get_component_id());
        }
        return components;
    }

    public void metrics(Nimbus.Iface client) throws Exception {
        if (this.interval <= 0) {
            throw new IllegalArgumentException("poll interval must be positive");
        }
        if (this.topology == null || this.topology.isEmpty()) {
            throw new IllegalArgumentException("topology name must be something");
        }
        if (this.component == null || this.component.isEmpty()) {
            HashSet<String> components = this.getComponents(client, this.topology);
            System.out.println("Available components for " + this.topology + " :");
            System.out.println("------------------");
            for (String comp : components) {
                System.out.println(comp);
            }
            System.out.println("------------------");
            System.out.println("Please use -m to specify one component");
            return;
        }
        if (this.stream == null || this.stream.isEmpty()) {
            throw new IllegalArgumentException("stream name must be something");
        }
        if (!WATCH_TRANSFERRED.equals(this.watch) && !WATCH_EMITTED.equals(this.watch)) {
            throw new IllegalArgumentException("watch item must either be transferred or emitted");
        }
        System.out.println("topology\tcomponent\tparallelism\tstream\ttime-diff ms\t" + this.watch + "\tthroughput (Kt/s)");
        long pollMs = this.interval * 1000;
        long now = System.currentTimeMillis();
        MetricsState state = new MetricsState(now, 0L);
        Poller poller = new Poller(now, pollMs);
        while (true) {
            this.metrics(client, now, state);
            try {
                now = poller.nextPoll();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void metrics(Nimbus.Iface client, long now, MetricsState state) throws Exception {
        long totalStatted = 0L;
        int componentParallelism = 0;
        boolean streamFound = false;
        GetInfoOptions getInfoOpts = new GetInfoOptions();
        getInfoOpts.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo info = client.getTopologyInfoByNameWithOpts(this.topology, getInfoOpts);
        for (ExecutorSummary es : info.get_executors()) {
            Long stream;
            Map e2;
            Map statted;
            if (!this.component.equals(es.get_component_id())) continue;
            ++componentParallelism;
            ExecutorStats stats = es.get_stats();
            if (stats == null || (statted = WATCH_EMITTED.equals(this.watch) ? stats.get_emitted() : stats.get_transferred()) == null || (e2 = (Map)statted.get(":all-time")) == null || (stream = (Long)e2.get(this.stream)) == null) continue;
            streamFound = true;
            totalStatted += stream.longValue();
        }
        if (componentParallelism <= 0) {
            HashSet<String> components = this.getComponents(client, this.topology);
            System.out.println("Available components for " + this.topology + " :");
            System.out.println("------------------");
            for (String comp : components) {
                System.out.println(comp);
            }
            System.out.println("------------------");
            throw new IllegalArgumentException("component: " + this.component + " not found");
        }
        if (!streamFound) {
            throw new IllegalArgumentException("stream: " + this.stream + " not found");
        }
        long timeDelta = now - state.getLastTime();
        long stattedDelta = totalStatted - state.getLastStatted();
        state.setLastTime(now);
        state.setLastStatted(totalStatted);
        double throughput = stattedDelta == 0L || timeDelta == 0L ? 0.0 : (double)stattedDelta / (double)timeDelta;
        System.out.println(this.topology + "\t" + this.component + "\t" + componentParallelism + "\t" + this.stream + "\t" + timeDelta + "\t" + stattedDelta + "\t" + throughput);
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTopology(String topology) {
        this.topology = topology;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public void setWatch(String watch) {
        this.watch = watch;
    }

    private static class Poller {
        private long startTime = 0L;
        private long pollMs = 0L;

        private Poller(long startTime, long pollMs) {
            this.startTime = startTime;
            this.pollMs = pollMs;
        }

        public long nextPoll() throws InterruptedException {
            long now = System.currentTimeMillis();
            long cycle = (now - this.startTime) / this.pollMs;
            long wakeupTime = this.startTime + this.pollMs * (cycle + 1L);
            long sleepTime = wakeupTime - now;
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
            now = System.currentTimeMillis();
            return now;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getPollMs() {
            return this.pollMs;
        }

        public void setPollMs(long pollMs) {
            this.pollMs = pollMs;
        }
    }

    private static class MetricsState {
        private long lastTime = 0L;
        private long lastStatted = 0L;

        private MetricsState(long lastTime, long lastStatted) {
            this.lastTime = lastTime;
            this.lastStatted = lastStatted;
        }

        public long getLastStatted() {
            return this.lastStatted;
        }

        public void setLastStatted(long lastStatted) {
            this.lastStatted = lastStatted;
        }

        public long getLastTime() {
            return this.lastTime;
        }

        public void setLastTime(long lastTime) {
            this.lastTime = lastTime;
        }
    }
}

