/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.List;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.utils.NimbusClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTopologies {
    private static final Logger LOG = LoggerFactory.getLogger(ListTopologies.class);
    private static final String MSG_FORMAT = "%-20s %-10s %-10s %-12s %-12s %-20s %-20s\n";

    public static void main(String[] args) throws Exception {
        NimbusClient.withConfiguredClient((NimbusClient.WithNimbus)new NimbusClient.WithNimbus(){

            public void run(Nimbus.Iface nimbus) throws Exception {
                List topologies = nimbus.getTopologySummaries();
                if (topologies == null || topologies.isEmpty()) {
                    System.out.println("No topologies running.");
                } else {
                    System.out.printf(ListTopologies.MSG_FORMAT, "Topology_name", "Status", "Num_tasks", "Num_workers", "Uptime_secs", "Topology_Id", "Owner");
                    System.out.println("----------------------------------------------------------------------------------------");
                    for (TopologySummary topology : topologies) {
                        System.out.printf(ListTopologies.MSG_FORMAT, topology.get_name(), topology.get_status(), topology.get_num_tasks(), topology.get_num_workers(), topology.get_uptime_secs(), topology.get_id(), topology.get_owner());
                    }
                }
            }
        });
    }
}

