/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.command.CLI;
import org.apache.storm.utils.DRPCClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDrpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(BasicDrpcClient.class);

    private static void runAndPrint(DRPCClient drpc, String func, String arg) throws Exception {
        String result = drpc.execute(func, arg);
        System.out.println(String.format("%s \"%s\" => \"%s\"", func, arg, result));
    }

    public static void main(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("f", "function", null, CLI.AS_STRING).arg("FUNC_AND_ARGS", CLI.INTO_LIST).parse(args);
        List funcAndArgs = (List)cl.get("FUNC_AND_ARGS");
        String function = (String)cl.get("f");
        Config conf = new Config();
        try (DRPCClient drpc = DRPCClient.getConfiguredClient((Map)conf);){
            if (function == null) {
                if (funcAndArgs.size() % 2 != 0) {
                    LOG.error("If no -f is supplied arguments need to be in the form [function arg]. This has {} args", (Object)funcAndArgs.size());
                    System.exit(-1);
                }
                for (int i = 0; i < funcAndArgs.size(); i += 2) {
                    String func = (String)funcAndArgs.get(i);
                    String arg = (String)funcAndArgs.get(i + 1);
                    BasicDrpcClient.runAndPrint(drpc, func, arg);
                }
            } else {
                for (String arg : funcAndArgs) {
                    BasicDrpcClient.runAndPrint(drpc, function, arg);
                }
            }
        }
    }
}

