/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class LogRoller
extends HasThread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LogRoller.class);
    private final ReentrantLock rollLock = new ReentrantLock();
    private final AtomicBoolean rollLog = new AtomicBoolean(false);
    private final ConcurrentHashMap<WAL, Boolean> walNeedsRoll = new ConcurrentHashMap();
    private final Server server;
    protected final RegionServerServices services;
    private volatile long lastrolltime = System.currentTimeMillis();
    private final long rollperiod;
    private final int threadWakeFrequency;
    private long checkLowReplicationInterval;
    private volatile boolean running = true;

    public void addWAL(final WAL wal) {
        if (null == this.walNeedsRoll.putIfAbsent(wal, Boolean.FALSE)) {
            wal.registerWALActionsListener(new WALActionsListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void logRollRequested(boolean lowReplicas) {
                    LogRoller.this.walNeedsRoll.put(wal, Boolean.TRUE);
                    AtomicBoolean atomicBoolean = LogRoller.this.rollLog;
                    synchronized (atomicBoolean) {
                        LogRoller.this.rollLog.set(true);
                        LogRoller.this.rollLog.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRollAll() {
        for (WAL wal : this.walNeedsRoll.keySet()) {
            this.walNeedsRoll.put(wal, Boolean.TRUE);
        }
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.set(true);
            this.rollLog.notifyAll();
        }
    }

    public LogRoller(Server server, RegionServerServices services) {
        super("LogRoller");
        this.server = server;
        this.services = services;
        this.rollperiod = this.server.getConfiguration().getLong("hbase.regionserver.logroll.period", 3600000L);
        this.threadWakeFrequency = this.server.getConfiguration().getInt("hbase.server.thread.wakefrequency", 10000);
        this.checkLowReplicationInterval = this.server.getConfiguration().getLong("hbase.regionserver.hlog.check.lowreplication.interval", 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.notify();
        }
        super.interrupt();
    }

    void checkLowReplication(long now) {
        try {
            for (Map.Entry<WAL, Boolean> entry : this.walNeedsRoll.entrySet()) {
                WAL wal = entry.getKey();
                boolean needRollAlready = entry.getValue();
                if (needRollAlready || !(wal instanceof AbstractFSWAL)) continue;
                ((AbstractFSWAL)wal).checkLogLowReplication(this.checkLowReplicationInterval);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed checking low replication", e);
        }
    }

    private void abort(String reason, Throwable cause) {
        for (WAL wal : this.walNeedsRoll.keySet()) {
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.warn("Failed to shutdown wal", (Throwable)e);
            }
        }
        this.server.abort(reason, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            long now = System.currentTimeMillis();
            this.checkLowReplication(now);
            boolean periodic = false;
            if (!this.rollLog.get()) {
                boolean bl = periodic = now - this.lastrolltime > this.rollperiod;
                if (!periodic) {
                    AtomicBoolean atomicBoolean = this.rollLog;
                    synchronized (atomicBoolean) {
                        try {
                            if (!this.rollLog.get()) {
                                this.rollLog.wait(this.threadWakeFrequency);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                LOG.debug("Wal roll period {} ms elapsed", (Object)this.rollperiod);
            } else {
                LOG.debug("WAL roll requested");
            }
            this.rollLock.lock();
            try {
                this.lastrolltime = now;
                for (Map.Entry entry : this.walNeedsRoll.entrySet()) {
                    WAL wal = (WAL)entry.getKey();
                    byte[][] regionsToFlush = wal.rollWriter(periodic || (Boolean)entry.getValue() != false);
                    this.walNeedsRoll.put(wal, Boolean.FALSE);
                    if (regionsToFlush == null) continue;
                    for (byte[] r : regionsToFlush) {
                        this.scheduleFlush(r);
                    }
                }
            }
            catch (FailedLogCloseException e) {
                this.abort("Failed log close in log roller", e);
            }
            catch (ConnectException e) {
                this.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                this.abort("IOE in log roller", ex instanceof RemoteException ? ((RemoteException)((Object)ex)).unwrapRemoteException() : ex);
            }
            catch (Exception ex) {
                LOG.error("Log rolling failed", (Throwable)ex);
                this.abort("Log rolling failed", ex);
            }
            finally {
                try {
                    this.rollLog.set(false);
                }
                finally {
                    this.rollLock.unlock();
                }
            }
        }
        LOG.info("LogRoller exiting.");
    }

    private void scheduleFlush(byte[] encodedRegionName) {
        boolean scheduled = false;
        HRegion r = (HRegion)this.services.getRegion(Bytes.toString((byte[])encodedRegionName));
        FlushRequester requester = null;
        if (r != null && (requester = this.services.getFlushRequester()) != null) {
            requester.requestFlush(r, true, FlushLifeCycleTracker.DUMMY);
            scheduled = true;
        }
        if (!scheduled) {
            LOG.warn("Failed to schedule flush of {}, region={}, requester={}", new Object[]{Bytes.toString((byte[])encodedRegionName), r, requester});
        }
    }

    @VisibleForTesting
    public boolean walRollFinished() {
        for (boolean needRoll : this.walNeedsRoll.values()) {
            if (!needRoll) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.running = false;
        this.interrupt();
    }
}

