/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.WrapperAsyncFSOutput;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class AsyncFSOutputHelper {
    private AsyncFSOutputHelper() {
    }

    public static AsyncFSOutput createOutput(FileSystem fs, Path f, boolean overwrite, boolean createParent, short replication, long blockSize, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        if (fs instanceof DistributedFileSystem) {
            return FanOutOneBlockAsyncDFSOutputHelper.createOutput((DistributedFileSystem)fs, f, overwrite, createParent, replication, blockSize, eventLoopGroup, channelClass);
        }
        int bufferSize = fs.getConf().getInt("io.file.buffer.size", 4096);
        FSDataOutputStream out = createParent ? fs.create(f, overwrite, bufferSize, replication, blockSize, null) : fs.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, null);
        if (!(!fs.getConf().getBoolean("hbase.unsafe.stream.capability.enforce", true) || CommonFSUtils.hasCapability((FSDataOutputStream)out, (String)"hflush") && CommonFSUtils.hasCapability((FSDataOutputStream)out, (String)"hsync"))) {
            out.close();
            throw new CommonFSUtils.StreamLacksCapabilityException("hflush and hsync");
        }
        return new WrapperAsyncFSOutput(f, out);
    }
}

