/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.DropTableCommand;
import org.apache.hive.hcatalog.api.repl.commands.NoopCommand;
import org.apache.hive.hcatalog.messaging.DropTableMessage;

public class DropTableReplicationTask
extends ReplicationTask {
    private DropTableMessage dropTableMessage = null;

    public DropTableReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "DROP_TABLE");
        this.dropTableMessage = messageFactory.getDeserializer().getDropTableMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return false;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        return Collections.singletonList(new NoopCommand(this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dstDbName = ReplicationUtils.mapIfMapAvailable(this.dropTableMessage.getDB(), (Function<String, String>)this.dbNameMapping);
        String dstTableName = ReplicationUtils.mapIfMapAvailable(this.dropTableMessage.getTable(), (Function<String, String>)this.tableNameMapping);
        return Collections.singletonList(new DropTableCommand(dstDbName, dstTableName, true, this.event.getEventId()));
    }
}

