/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.antlr.runtime.tree.TreeWizard;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.Optimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverterPostProc;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.MaskAndFilterInfo;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PreInsertTableDesc;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TableAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.TableMask;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.parse.TaskCompilerFactory;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.InsertTableDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewForwardDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.NoOpFetchFormatter;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;

public class SemanticAnalyzer
extends BaseSemanticAnalyzer {
    public static final String DUMMY_DATABASE = "_dummy_database";
    public static final String DUMMY_TABLE = "_dummy_table";
    public static final String SUBQUERY_TAG_1 = "-subquery1";
    public static final String SUBQUERY_TAG_2 = "-subquery2";
    private static final int AUTOGEN_COLALIAS_PRFX_MAXLENGTH = 20;
    public static final String VALUES_TMP_TABLE_NAME_PREFIX = "Values__Tmp__Table__";
    static final String MATERIALIZATION_MARKER = "$MATERIALIZATION";
    private HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner;
    private HashMap<TableScanOperator, PrunedPartitionList> opToPartList;
    protected HashMap<String, TableScanOperator> topOps;
    protected LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtx;
    private List<LoadTableDesc> loadTableWork;
    private List<LoadFileDesc> loadFileWork;
    private List<ColumnStatsAutoGatherContext> columnStatsAutoGatherContexts;
    private final Map<JoinOperator, QBJoinTree> joinContext;
    private final Map<SMBMapJoinOperator, QBJoinTree> smbMapJoinContext;
    private final HashMap<TableScanOperator, Table> topToTable;
    private final Map<FileSinkOperator, Table> fsopToTable;
    private final List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting;
    private final HashMap<TableScanOperator, Map<String, String>> topToTableProps;
    private QB qb;
    private ASTNode ast;
    private int destTableId = 1;
    private UnionProcContext uCtx = null;
    List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer;
    private HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner;
    private final Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner;
    private Map<SelectOperator, Table> viewProjectToTableSchema;
    private final HashMap<String, SplitSample> nameToSplitSample;
    Map<GroupByOperator, Set<String>> groupOpToInputTables;
    Map<String, PrunedPartitionList> prunedPartitions;
    protected List<FieldSchema> resultSchema;
    protected CreateViewDesc createVwDesc;
    protected ArrayList<String> viewsExpanded;
    protected ASTNode viewSelect;
    protected final UnparseTranslator unparseTranslator;
    private final GlobalLimitCtx globalLimitCtx;
    private final String autogenColAliasPrfxLbl;
    private final boolean autogenColAliasPrfxIncludeFuncName;
    private final Map<String, ReadEntity> viewAliasToInput;
    private boolean mergeIsDirect;
    protected boolean noscan;
    protected boolean partialscan;
    protected volatile boolean disableJoinMerge = false;
    protected final boolean defaultJoinMerge;
    final Map<String, CTEClause> aliasToCTEs;
    ArrayList<String> ctesExpanded;
    boolean rootTasksResolved;
    protected TableMask tableMask;
    CreateTableDesc tableDesc;
    final CalcitePlanner.ASTSearcher astSearcher = new CalcitePlanner.ASTSearcher();
    protected BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    Map<String, Table> tabNameToTabObject;
    private final Set<Integer> ignoredTokens = Sets.newHashSet(772, 851, 1016, 703, 738, 934);
    private final CTEClause rootClause = new CTEClause(null, null);

    public SemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.opToPartPruner = new HashMap();
        this.opToPartList = new HashMap();
        this.opToSamplePruner = new HashMap();
        this.nameToSplitSample = new HashMap();
        this.topOps = new LinkedHashMap<String, TableScanOperator>();
        this.loadTableWork = new ArrayList<LoadTableDesc>();
        this.loadFileWork = new ArrayList<LoadFileDesc>();
        this.columnStatsAutoGatherContexts = new ArrayList<ColumnStatsAutoGatherContext>();
        this.opParseCtx = new LinkedHashMap();
        this.joinContext = new HashMap<JoinOperator, QBJoinTree>();
        this.smbMapJoinContext = new HashMap<SMBMapJoinOperator, QBJoinTree>();
        this.topToTable = new LinkedHashMap<TableScanOperator, Table>();
        this.fsopToTable = new HashMap<FileSinkOperator, Table>();
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting = new ArrayList<ReduceSinkOperator>();
        this.topToTableProps = new HashMap();
        this.listMapJoinOpsNoReducer = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        this.groupOpToInputTables = new HashMap<GroupByOperator, Set<String>>();
        this.prunedPartitions = new HashMap<String, PrunedPartitionList>();
        this.tabNameToTabObject = new HashMap<String, Table>();
        this.unparseTranslator = new UnparseTranslator(this.conf);
        this.autogenColAliasPrfxLbl = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL);
        this.autogenColAliasPrfxIncludeFuncName = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME);
        this.queryProperties = new QueryProperties();
        this.opToPartToSkewedPruner = new HashMap<TableScanOperator, Map<String, ExprNodeDesc>>();
        this.aliasToCTEs = new HashMap<String, CTEClause>();
        this.globalLimitCtx = new GlobalLimitCtx();
        this.viewAliasToInput = new HashMap<String, ReadEntity>();
        this.mergeIsDirect = true;
        this.partialscan = false;
        this.noscan = false;
        this.tabNameToTabObject = new HashMap<String, Table>();
        this.disableJoinMerge = this.defaultJoinMerge = false == HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MERGE_NWAY_JOINS);
    }

    @Override
    protected void reset(boolean clearPartsCache) {
        super.reset(true);
        if (clearPartsCache) {
            this.prunedPartitions.clear();
            this.mergeIsDirect = true;
        } else {
            this.mergeIsDirect = false;
        }
        this.tabNameToTabObject.clear();
        this.loadTableWork.clear();
        this.loadFileWork.clear();
        this.columnStatsAutoGatherContexts.clear();
        this.topOps.clear();
        this.destTableId = 1;
        this.idToTableNameMap.clear();
        this.qb = null;
        this.ast = null;
        this.uCtx = null;
        this.joinContext.clear();
        this.smbMapJoinContext.clear();
        this.opParseCtx.clear();
        this.groupOpToInputTables.clear();
        this.disableJoinMerge = this.defaultJoinMerge;
        this.aliasToCTEs.clear();
        this.topToTable.clear();
        this.opToPartPruner.clear();
        this.opToPartList.clear();
        this.opToPartToSkewedPruner.clear();
        this.opToSamplePruner.clear();
        this.nameToSplitSample.clear();
        this.fsopToTable.clear();
        this.resultSchema = null;
        this.createVwDesc = null;
        this.viewsExpanded = null;
        this.viewSelect = null;
        this.ctesExpanded = null;
        this.globalLimitCtx.disableOpt();
        this.viewAliasToInput.clear();
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting.clear();
        this.topToTableProps.clear();
        this.listMapJoinOpsNoReducer.clear();
        this.unparseTranslator.clear();
        this.queryProperties.clear();
        this.outputs.clear();
    }

    public void initParseCtx(ParseContext pctx) {
        this.opToPartPruner = pctx.getOpToPartPruner();
        this.opToPartList = pctx.getOpToPartList();
        this.opToSamplePruner = pctx.getOpToSamplePruner();
        this.topOps = pctx.getTopOps();
        this.loadTableWork = pctx.getLoadTableWork();
        this.loadFileWork = pctx.getLoadFileWork();
        this.ctx = pctx.getContext();
        this.destTableId = pctx.getDestTableId();
        this.idToTableNameMap = pctx.getIdToTableNameMap();
        this.uCtx = pctx.getUCtx();
        this.listMapJoinOpsNoReducer = pctx.getListMapJoinOpsNoReducer();
        this.prunedPartitions = pctx.getPrunedPartitions();
        this.tabNameToTabObject = pctx.getTabNameToTabObject();
        this.fetchTask = pctx.getFetchTask();
        this.setLineageInfo(pctx.getLineageInfo());
    }

    public ParseContext getParseContext() {
        this.copyInfoToQueryProperties(this.queryProperties);
        return new ParseContext(this.queryState, this.opToPartPruner, this.opToPartList, this.topOps, new HashSet<JoinOperator>(this.joinContext.keySet()), new HashSet<SMBMapJoinOperator>(this.smbMapJoinContext.keySet()), this.loadTableWork, this.loadFileWork, this.columnStatsAutoGatherContexts, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.prunedPartitions, this.tabNameToTabObject, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.analyzeRewrite, this.tableDesc, this.createVwDesc, this.queryProperties, this.viewProjectToTableSchema, this.acidFileSinks);
    }

    public CompilationOpContext getOpContext() {
        return this.ctx.getOpContext();
    }

    public void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias) throws SemanticException {
        this.doPhase1QBExpr(ast, qbexpr, id, alias, false);
    }

    public void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias, boolean insideView) throws SemanticException {
        assert (ast.getToken() != null);
        if (ast.getToken().getType() == 876) {
            QB qb = new QB(id, alias, true);
            qb.setInsideView(insideView);
            Phase1Ctx ctx_1 = this.initPhase1Ctx();
            this.doPhase1(ast, qb, ctx_1, null);
            qbexpr.setOpcode(QBExpr.Opcode.NULLOP);
            qbexpr.setQB(qb);
        } else {
            switch (ast.getToken().getType()) {
                case 994: {
                    qbexpr.setOpcode(QBExpr.Opcode.UNION);
                    break;
                }
                case 785: {
                    qbexpr.setOpcode(QBExpr.Opcode.INTERSECTALL);
                    break;
                }
                case 786: {
                    qbexpr.setOpcode(QBExpr.Opcode.INTERSECT);
                    break;
                }
                case 749: {
                    qbexpr.setOpcode(QBExpr.Opcode.EXCEPTALL);
                    break;
                }
                case 750: {
                    qbexpr.setOpcode(QBExpr.Opcode.EXCEPT);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SET_OPERATOR.getMsg("Type " + ast.getToken().getType()));
                }
            }
            assert (ast.getChild(0) != null);
            QBExpr qbexpr1 = new QBExpr(alias + SUBQUERY_TAG_1);
            this.doPhase1QBExpr((ASTNode)ast.getChild(0), qbexpr1, id + SUBQUERY_TAG_1, alias + SUBQUERY_TAG_1, insideView);
            qbexpr.setQBExpr1(qbexpr1);
            assert (ast.getChild(1) != null);
            QBExpr qbexpr2 = new QBExpr(alias + SUBQUERY_TAG_2);
            this.doPhase1QBExpr((ASTNode)ast.getChild(1), qbexpr2, id + SUBQUERY_TAG_2, alias + SUBQUERY_TAG_2, insideView);
            qbexpr.setQBExpr2(qbexpr2);
        }
    }

    private LinkedHashMap<String, ASTNode> doPhase1GetAggregationsFromSelect(ASTNode selExpr, QB qb, String dest) throws SemanticException {
        LinkedHashMap<String, ASTNode> aggregationTrees = new LinkedHashMap<String, ASTNode>();
        ArrayList<ASTNode> wdwFns = new ArrayList<ASTNode>();
        for (int i = 0; i < selExpr.getChildCount(); ++i) {
            ASTNode function = (ASTNode)selExpr.getChild(i);
            if (function.getType() == 901 || function.getType() == 942) {
                function = (ASTNode)function.getChild(0);
            }
            this.doPhase1GetAllAggregations(function, aggregationTrees, wdwFns);
        }
        for (ASTNode wdwFn : wdwFns) {
            WindowingSpec spec = qb.getWindowingSpec(dest);
            if (spec == null) {
                this.queryProperties.setHasWindowing(true);
                spec = new WindowingSpec();
                qb.addDestToWindowingSpec(dest, spec);
            }
            HashMap<String, ASTNode> wExprsInDest = qb.getParseInfo().getWindowingExprsForClause(dest);
            int wColIdx = spec.getWindowExpressions() == null ? 0 : spec.getWindowExpressions().size();
            WindowingSpec.WindowFunctionSpec wFnSpec = this.processWindowFunction(wdwFn, (ASTNode)wdwFn.getChild(wdwFn.getChildCount() - 1));
            if (wExprsInDest != null && wExprsInDest.containsKey(wFnSpec.getExpression().toStringTree())) continue;
            wFnSpec.setAlias(wFnSpec.getName() + "_window_" + wColIdx);
            spec.addWindowFunction(wFnSpec);
            qb.getParseInfo().addWindowingExprToClause(dest, wFnSpec.getExpression());
        }
        return aggregationTrees;
    }

    private void doPhase1GetColumnAliasesFromSelect(ASTNode selectExpr, QBParseInfo qbp) {
        for (int i = 0; i < selectExpr.getChildCount(); ++i) {
            ASTNode selExpr = (ASTNode)selectExpr.getChild(i);
            if (selExpr.getToken().getType() != 901 || selExpr.getChildCount() != 2) continue;
            String columnAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            qbp.setExprToColumnAlias((ASTNode)selExpr.getChild(0), columnAlias);
        }
    }

    private void doPhase1GetAllAggregations(ASTNode expressionTree, HashMap<String, ASTNode> aggregations, List<ASTNode> wdwFns) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 942) {
            return;
        }
        if (exprTokenType == 763 || exprTokenType == 764 || exprTokenType == 765) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(expressionTree.getChildCount() - 1).getType() == 1016) {
                wdwFns.add(expressionTree);
                this.doPhase1GetAllAggregations((ASTNode)expressionTree.getChild(expressionTree.getChildCount() - 1), aggregations, wdwFns);
                return;
            }
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if (FunctionRegistry.getFunctionInfo(functionName) == null) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
                }
                if (FunctionRegistry.impliesOrder(functionName)) {
                    throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                }
                if (FunctionRegistry.getGenericUDAFResolver(functionName) != null) {
                    if (this.containsLeadLagUDF(expressionTree)) {
                        throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                    }
                    aggregations.put(expressionTree.toStringTree(), expressionTree);
                    FunctionInfo fi = FunctionRegistry.getFunctionInfo(functionName);
                    if (!fi.isNative()) {
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)expressionTree.getChild(0));
                    }
                    return;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1GetAllAggregations((ASTNode)expressionTree.getChild(i), aggregations, wdwFns);
        }
    }

    private List<ASTNode> doPhase1GetDistinctFuncExprs(HashMap<String, ASTNode> aggregationTrees) throws SemanticException {
        ArrayList<ASTNode> exprs = new ArrayList<ASTNode>();
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            assert (value != null);
            if (value.getToken().getType() != 764) continue;
            exprs.add(value);
        }
        return exprs;
    }

    public static String generateErrorMessage(ASTNode ast, String message) {
        StringBuilder sb = new StringBuilder();
        if (ast == null) {
            sb.append(message).append(". Cannot tell the position of null AST.");
            return sb.toString();
        }
        sb.append(ast.getLine());
        sb.append(":");
        sb.append(ast.getCharPositionInLine());
        sb.append(" ");
        sb.append(message);
        sb.append(". Error encountered near token '");
        sb.append(ErrorMsg.getText(ast));
        sb.append("'");
        return sb.toString();
    }

    ASTNode getAST() {
        return this.ast;
    }

    protected void setAST(ASTNode newAST) {
        this.ast = newAST;
    }

    int[] findTabRefIdxs(ASTNode tabref) {
        assert (tabref.getType() == 977);
        int aliasIndex = 0;
        int propsIndex = -1;
        int tsampleIndex = -1;
        int ssampleIndex = -1;
        for (int index = 1; index < tabref.getChildCount(); ++index) {
            ASTNode ct = (ASTNode)tabref.getChild(index);
            if (ct.getToken().getType() == 956) {
                tsampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 972) {
                ssampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 961) {
                propsIndex = index;
                continue;
            }
            aliasIndex = index;
        }
        return new int[]{aliasIndex, propsIndex, tsampleIndex, ssampleIndex};
    }

    String findSimpleTableName(ASTNode tabref, int aliasIndex) {
        assert (tabref.getType() == 977);
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String alias = aliasIndex != 0 ? SemanticAnalyzer.unescapeIdentifier(tabref.getChild(aliasIndex).getText()) : SemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
        return alias;
    }

    private String processTable(QB qb, ASTNode tabref) throws SemanticException {
        ASTNode sampleClause;
        int[] indexes = this.findTabRefIdxs(tabref);
        int aliasIndex = indexes[0];
        int propsIndex = indexes[1];
        int tsampleIndex = indexes[2];
        int ssampleIndex = indexes[3];
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String tabIdName = SemanticAnalyzer.getUnescapedName(tableTree).toLowerCase();
        String alias = this.findSimpleTableName(tabref, aliasIndex);
        if (propsIndex >= 0) {
            Tree propsAST = tabref.getChild(propsIndex);
            HashMap<String, String> props = DDLSemanticAnalyzer.getProps((ASTNode)propsAST.getChild(0));
            if ("TRUE".equals(props.get("insideView"))) {
                qb.getAliasInsideView().add(alias.toLowerCase());
            }
            qb.setTabProps(alias, props);
        }
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(tabref.getChild(aliasIndex)));
        }
        if (tsampleIndex >= 0) {
            sampleClause = (ASTNode)tabref.getChild(tsampleIndex);
            ArrayList<ASTNode> sampleCols = new ArrayList<ASTNode>();
            if (sampleClause.getChildCount() > 2) {
                for (int i = 2; i < sampleClause.getChildCount(); ++i) {
                    sampleCols.add((ASTNode)sampleClause.getChild(i));
                }
            }
            if (sampleCols.size() > 2) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)tabref.getChild(0), ErrorMsg.SAMPLE_RESTRICTION.getMsg()));
            }
            TableSample tabSample = new TableSample(SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(0).getText()), SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(1).getText()), sampleCols);
            qb.getParseInfo().setTabSample(alias, tabSample);
            if (this.unparseTranslator.isEnabled()) {
                for (ASTNode sampleCol : sampleCols) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)sampleCol.getChild(0));
                }
            }
        } else if (ssampleIndex >= 0) {
            SplitSample sample;
            sampleClause = (ASTNode)tabref.getChild(ssampleIndex);
            Tree type = sampleClause.getChild(0);
            Tree numerator = sampleClause.getChild(1);
            String value = SemanticAnalyzer.unescapeIdentifier(numerator.getText());
            if (type.getType() == 857) {
                this.assertCombineInputFormat(numerator, "Percentage");
                Double percent = (double)Double.valueOf(value);
                if (percent < 0.0 || percent > 100.0) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, "Sampling percentage should be between 0 and 100"));
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(percent, seedNum);
            } else if (type.getType() == 898) {
                sample = new SplitSample(Integer.parseInt(value));
            } else {
                assert (type.getType() == 807);
                this.assertCombineInputFormat(numerator, "Total Length");
                long length = Integer.parseInt(value.substring(0, value.length() - 1));
                char last = value.charAt(value.length() - 1);
                if (last == 'k' || last == 'K') {
                    length <<= 10;
                } else if (last == 'm' || last == 'M') {
                    length <<= 20;
                } else if (last == 'g' || last == 'G') {
                    length <<= 30;
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(length, seedNum);
            }
            String alias_id = this.getAliasId(alias, qb);
            this.nameToSplitSample.put(alias_id, sample);
        }
        qb.setTabAlias(alias, tabIdName);
        if (qb.isInsideView()) {
            qb.getAliasInsideView().add(alias.toLowerCase());
        }
        qb.addAlias(alias);
        qb.getParseInfo().setSrcForAlias(alias, tableTree);
        if (!this.aliasToCTEs.containsKey(tabIdName)) {
            this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
            if (aliasIndex != 0) {
                this.unparseTranslator.addIdentifierTranslation((ASTNode)tabref.getChild(aliasIndex));
            }
        }
        return alias;
    }

    Map<String, SplitSample> getNameToSplitSampleMap() {
        return this.nameToSplitSample;
    }

    private static void writeAsText(String text, FSDataOutputStream out) throws IOException {
        Text to = new Text(text);
        out.write(to.getBytes(), 0, to.getLength());
    }

    private ASTNode genValuesTempTable(ASTNode originalFrom, QB qb) throws SemanticException {
        Path dataDir = null;
        if (!qb.getEncryptedTargetTablePaths().isEmpty()) {
            dataDir = this.ctx.getMRTmpPath(qb.getEncryptedTargetTablePaths().get(0).toUri());
        }
        SessionState ss = SessionState.get();
        String tableName = VALUES_TMP_TABLE_NAME_PREFIX + ss.getNextValuesTempTableSuffix();
        List fromChildren = originalFrom.getChildren();
        ASTNode virtualTableRef = (ASTNode)fromChildren.get(0);
        assert (virtualTableRef.getToken().getType() == 1012) : "Expected first child of TOK_VIRTUAL_TABLE to be TOK_VIRTUAL_TABREF but was " + virtualTableRef.getName();
        List virtualTableRefChildren = virtualTableRef.getChildren();
        ASTNode tabName = (ASTNode)virtualTableRefChildren.get(0);
        if (tabName.getToken().getType() != 693) {
            throw new SemanticException(ErrorMsg.VALUES_TABLE_CONSTRUCTOR_NOT_SUPPORTED.getMsg());
        }
        ASTNode valuesTable = (ASTNode)fromChildren.get(1);
        assert (valuesTable.getToken().getType() == 1007) : "Expected second child of TOK_VIRTUAL_TABLE to be TOK_VALUE_TABLE but was " + valuesTable.getName();
        List valuesTableChildren = valuesTable.getChildren();
        Path tablePath = null;
        FileSystem fs = null;
        FSDataOutputStream out = null;
        try {
            tablePath = dataDir == null ? Warehouse.getDnsPath(new Path(ss.getTempTableSpace(), tableName), this.conf) : Warehouse.getDnsPath(new Path(dataDir, tableName), this.conf);
            fs = tablePath.getFileSystem((Configuration)this.conf);
            fs.mkdirs(tablePath);
            Path dataFile = new Path(tablePath, "data_file");
            out = fs.create(dataFile);
            ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
            boolean firstRow = true;
            for (Node n : valuesTableChildren) {
                ASTNode valuesRow = (ASTNode)n;
                assert (valuesRow.getToken().getType() == 1008) : "Expected child of TOK_VALUE_TABLE to be TOK_VALUE_ROW but was " + valuesRow.getName();
                List valuesRowChildren = valuesRow.getChildren();
                boolean isFirst = true;
                int nextColNum = 1;
                for (Node n1 : valuesRowChildren) {
                    ASTNode value = (ASTNode)n1;
                    if (firstRow) {
                        fields.add(new FieldSchema("tmp_values_col" + nextColNum++, "string", ""));
                    }
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        SemanticAnalyzer.writeAsText("\u0001", out);
                    }
                    SemanticAnalyzer.writeAsText(this.unparseExprForValuesClause(value), out);
                }
                SemanticAnalyzer.writeAsText("\n", out);
                firstRow = false;
            }
            StorageFormat format = new StorageFormat(this.conf);
            format.processStorageFormat("TextFile");
            Table table = this.db.newTable(tableName);
            table.setSerializationLib(format.getSerde());
            table.setFields(fields);
            table.setDataLocation(tablePath);
            table.getTTable().setTemporary(true);
            table.setStoredAsSubDirectories(false);
            table.setInputFormatClass(format.getInputFormat());
            table.setOutputFormatClass(format.getOutputFormat());
            this.db.createTable(table, false);
        }
        catch (Exception e) {
            try {
                String errMsg = ErrorMsg.INSERT_CANNOT_CREATE_TEMP_FILE.getMsg() + e.getMessage();
                this.LOG.error(errMsg);
                if (fs != null && tablePath != null) {
                    try {
                        fs.delete(tablePath, false);
                    }
                    catch (IOException firstRow) {
                        // empty catch block
                    }
                }
                throw new SemanticException(errMsg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)out);
        ClassicToken t = new ClassicToken(977);
        ASTNode tabRef = new ASTNode((Token)t);
        t = new ClassicToken(976);
        ASTNode tabNameNode = new ASTNode((Token)t);
        tabRef.addChild((Tree)tabNameNode);
        t = new ClassicToken(24, tableName);
        ASTNode identifier = new ASTNode((Token)t);
        tabNameNode.addChild((Tree)identifier);
        return tabRef;
    }

    private String unparseExprForValuesClause(ASTNode expr) throws SemanticException {
        switch (expr.getToken().getType()) {
            case 340: {
                return expr.getText();
            }
            case 352: {
                return BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
            }
            case 117: {
                return "";
            }
            case 295: {
                return "TRUE";
            }
            case 337: {
                return "-" + this.unparseExprForValuesClause((ASTNode)((ArrayList)expr.getChildren()).get(0));
            }
            case 825: {
                return "\\N";
            }
        }
        throw new SemanticException("Expression of type " + expr.getText() + " not supported in insert/values");
    }

    private void assertCombineInputFormat(Tree numerator, String message) throws SemanticException {
        String inputFormat;
        String string = inputFormat = this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") ? HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVETEZINPUTFORMAT) : HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEINPUTFORMAT);
        if (!inputFormat.equals(CombineHiveInputFormat.class.getName())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, message + " sampling is not supported in " + inputFormat));
        }
    }

    private String processSubQuery(QB qb, ASTNode subq) throws SemanticException {
        if (subq.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.NO_SUBQUERY_ALIAS.getMsg(subq));
        }
        ASTNode subqref = (ASTNode)subq.getChild(0);
        String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(subqref, qbexpr, qb.getId(), alias, qb.isInsideView());
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(subq.getChild(1)));
        }
        qb.setSubqAlias(alias, qbexpr);
        qb.addAlias(alias);
        this.unparseTranslator.addIdentifierTranslation((ASTNode)subq.getChild(1));
        return alias;
    }

    private void processCTE(QB qb, ASTNode ctes) throws SemanticException {
        int numCTEs = ctes.getChildCount();
        for (int i = 0; i < numCTEs; ++i) {
            ASTNode cte = (ASTNode)ctes.getChild(i);
            ASTNode cteQry = (ASTNode)cte.getChild(0);
            String alias = SemanticAnalyzer.unescapeIdentifier(cte.getChild(1).getText());
            String qName = qb.getId() == null ? "" : qb.getId() + ":";
            if (this.aliasToCTEs.containsKey(qName = qName + alias.toLowerCase())) {
                throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(cte.getChild(1)));
            }
            this.aliasToCTEs.put(qName, new CTEClause(qName, cteQry));
        }
    }

    private CTEClause findCTEFromName(QB qb, String cteName) {
        StringBuilder qId = new StringBuilder();
        if (qb.getId() != null) {
            qId.append(qb.getId());
        }
        while (qId.length() > 0) {
            String nm = qId + ":" + cteName;
            CTEClause cte = this.aliasToCTEs.get(nm);
            if (cte != null) {
                return cte;
            }
            int lastIndex = qId.lastIndexOf(":");
            lastIndex = lastIndex < 0 ? 0 : lastIndex;
            qId.setLength(lastIndex);
        }
        return this.aliasToCTEs.get(cteName);
    }

    private void addCTEAsSubQuery(QB qb, String cteName, String cteAlias) throws SemanticException {
        cteAlias = cteAlias == null ? cteName : cteAlias;
        CTEClause cte = this.findCTEFromName(qb, cteName);
        ASTNode cteQryNode = cte.cteNode;
        QBExpr cteQBExpr = new QBExpr(cteAlias);
        this.doPhase1QBExpr(cteQryNode, cteQBExpr, qb.getId(), cteAlias);
        qb.rewriteCTEToSubq(cteAlias, cteName, cteQBExpr);
    }

    @Override
    public List<Task<? extends Serializable>> getAllRootTasks() {
        if (!this.rootTasksResolved) {
            this.rootTasks = this.toRealRootTasks(this.rootClause.asExecutionOrder());
            this.rootTasksResolved = true;
        }
        return this.rootTasks;
    }

    @Override
    public HashSet<ReadEntity> getAllInputs() {
        HashSet<ReadEntity> readEntities = new HashSet<ReadEntity>(this.getInputs());
        for (CTEClause cte : this.rootClause.asExecutionOrder()) {
            if (cte.source == null) continue;
            readEntities.addAll(cte.source.getInputs());
        }
        return readEntities;
    }

    @Override
    public HashSet<WriteEntity> getAllOutputs() {
        HashSet<WriteEntity> writeEntities = new HashSet<WriteEntity>(this.getOutputs());
        for (CTEClause cte : this.rootClause.asExecutionOrder()) {
            if (cte.source == null) continue;
            writeEntities.addAll(cte.source.getOutputs());
        }
        return writeEntities;
    }

    private List<Task<? extends Serializable>> toRealRootTasks(List<CTEClause> execution) {
        ArrayList<Task<? extends Serializable>> cteRoots = new ArrayList<Task<? extends Serializable>>();
        ArrayList<Task<Serializable>> cteLeafs = new ArrayList<Task<Serializable>>();
        List<Task<? extends Serializable>> curTopRoots = null;
        List<Task<Serializable>> curBottomLeafs = null;
        for (int i = 0; i < execution.size(); ++i) {
            List<Task<? extends Serializable>> curTasks;
            CTEClause cTEClause = execution.get(i);
            if (cTEClause.parents.isEmpty() && curTopRoots != null) {
                cteRoots.addAll(curTopRoots);
                cteLeafs.addAll(curBottomLeafs);
                curBottomLeafs = null;
                curTopRoots = null;
            }
            if ((curTasks = cTEClause.getTasks()) == null) continue;
            if (curTopRoots == null) {
                curTopRoots = curTasks;
            }
            if (curBottomLeafs != null) {
                for (Task task : curBottomLeafs) {
                    for (Task<? extends Serializable> currentRootTask : curTasks) {
                        task.addDependentTask(currentRootTask);
                    }
                }
            }
            curBottomLeafs = Task.findLeafs(curTasks);
        }
        if (curTopRoots != null) {
            cteRoots.addAll(curTopRoots);
            cteLeafs.addAll(curBottomLeafs);
        }
        if (cteRoots.isEmpty()) {
            return this.rootTasks;
        }
        for (Task task : cteLeafs) {
            for (Task mainRootTask : this.rootTasks) {
                task.addDependentTask(mainRootTask);
            }
        }
        return cteRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table materializeCTE(String cteName, CTEClause cte) throws HiveException {
        ASTNode createTable = new ASTNode((Token)new ClassicToken(713));
        ASTNode tableName = new ASTNode((Token)new ClassicToken(976));
        tableName.addChild((Tree)new ASTNode((Token)new ClassicToken(24, cteName)));
        ASTNode temporary = new ASTNode((Token)new ClassicToken(284, MATERIALIZATION_MARKER));
        createTable.addChild((Tree)tableName);
        createTable.addChild((Tree)temporary);
        createTable.addChild((Tree)cte.cteNode);
        SemanticAnalyzer analyzer = new SemanticAnalyzer(this.queryState);
        analyzer.initCtx(this.ctx);
        analyzer.init(false);
        analyzer.aliasToCTEs.putAll(this.aliasToCTEs);
        HiveOperation operation = this.queryState.getHiveOperation();
        try {
            analyzer.analyzeInternal(createTable);
        }
        finally {
            this.queryState.setCommandType(operation);
        }
        Table table = analyzer.tableDesc.toTable(this.conf);
        Path location = table.getDataLocation();
        try {
            location.getFileSystem((Configuration)this.conf).mkdirs(location);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        table.setMaterializedTable(true);
        this.LOG.info(cteName + " will be materialized into " + location);
        cte.table = table;
        cte.source = analyzer;
        this.ctx.addMaterializedTable(cteName, table);
        return table;
    }

    static boolean isJoinToken(ASTNode node) {
        return node.getToken().getType() == 802 || node.getToken().getType() == 716 || SemanticAnalyzer.isOuterJoinToken(node) || node.getToken().getType() == 806 || node.getToken().getType() == 997;
    }

    private static boolean isOuterJoinToken(ASTNode node) {
        return node.getToken().getType() == 805 || node.getToken().getType() == 894 || node.getToken().getType() == 762;
    }

    private void processJoin(QB qb, ASTNode join) throws SemanticException {
        int numChildren = join.getChildCount();
        if (numChildren != 2 && numChildren != 3 && join.getToken().getType() != 997) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(join, "Join with multiple children"));
        }
        this.queryProperties.incrementJoinCount(SemanticAnalyzer.isOuterJoinToken(join));
        for (int num = 0; num < numChildren; ++num) {
            ASTNode child = (ASTNode)join.getChild(num);
            if (child.getToken().getType() == 977) {
                this.processTable(qb, child);
                continue;
            }
            if (child.getToken().getType() == 941) {
                this.processSubQuery(qb, child);
                continue;
            }
            if (child.getToken().getType() == 875) {
                String inputAlias;
                this.queryProperties.setHasPTF(true);
                this.processPTF(qb, child);
                PTFInvocationSpec ptfInvocationSpec = qb.getPTFInvocationSpec(child);
                String string = inputAlias = ptfInvocationSpec == null ? null : ptfInvocationSpec.getFunction().getAlias();
                if (inputAlias != null) continue;
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(child, "PTF invocation in a Join must have an alias"));
            }
            if (child.getToken().getType() == 803 || child.getToken().getType() == 804) {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_WITH_JOIN.getMsg(join));
            }
            if (!SemanticAnalyzer.isJoinToken(child)) continue;
            this.processJoin(qb, child);
        }
    }

    private String processLateralView(QB qb, ASTNode lateralView) throws SemanticException {
        int numChildren = lateralView.getChildCount();
        assert (numChildren == 2);
        ASTNode next = (ASTNode)lateralView.getChild(1);
        String alias = null;
        switch (next.getToken().getType()) {
            case 977: {
                alias = this.processTable(qb, next);
                break;
            }
            case 941: {
                alias = this.processSubQuery(qb, next);
                break;
            }
            case 803: 
            case 804: {
                alias = this.processLateralView(qb, next);
                break;
            }
            default: {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(lateralView));
            }
        }
        alias = alias.toLowerCase();
        qb.getParseInfo().addLateralViewForAlias(alias, lateralView);
        qb.addAlias(alias);
        return alias;
    }

    public boolean doPhase1(ASTNode ast, QB qb, Phase1Ctx ctx_1, PlannerContext plannerCtx) throws SemanticException {
        boolean phase1Result = true;
        QBParseInfo qbp = qb.getParseInfo();
        boolean skipRecursion = false;
        if (ast.getToken() != null) {
            skipRecursion = true;
            switch (ast.getToken().getType()) {
                case 900: {
                    qb.countSelDi();
                }
                case 899: {
                    qb.countSel();
                    qbp.setSelExprForClause(ctx_1.dest, ast);
                    int posn = 0;
                    if (((ASTNode)ast.getChild(0)).getToken().getType() == 343) {
                        ParseDriver pd = new ParseDriver();
                        String queryHintStr = ast.getChild(0).getText();
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("QUERY HINT: " + queryHintStr);
                        }
                        try {
                            ASTNode hintNode = pd.parseHint(queryHintStr);
                            qbp.setHints(hintNode);
                            ++posn;
                        }
                        catch (ParseException e) {
                            throw new SemanticException("failed to parse query hint: " + e.getMessage(), e);
                        }
                    }
                    if (ast.getChild(posn).getChild(0).getType() == 988) {
                        this.queryProperties.setUsesScript(true);
                    }
                    LinkedHashMap<String, ASTNode> aggregations = this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest);
                    this.doPhase1GetColumnAliasesFromSelect(ast, qbp);
                    qbp.setAggregationExprsForClause(ctx_1.dest, aggregations);
                    qbp.setDistinctFuncExprsForClause(ctx_1.dest, this.doPhase1GetDistinctFuncExprs(aggregations));
                    break;
                }
                case 1013: {
                    qbp.setWhrExprForClause(ctx_1.dest, ast);
                    if (SubQueryUtils.findSubQueries((ASTNode)ast.getChild(0)).isEmpty()) break;
                    this.queryProperties.setFilterWithSubQuery(true);
                    break;
                }
                case 783: {
                    String currentDatabase = SessionState.get().getCurrentDatabase();
                    String tab_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), currentDatabase);
                    qbp.addInsertIntoTable(tab_name, ast);
                }
                case 734: {
                    ctx_1.dest = this.ctx.getDestNamePrefix(ast).toString() + ctx_1.nextNum;
                    ++ctx_1.nextNum;
                    boolean isTmpFileDest = false;
                    if (ast.getChildCount() > 0 && ast.getChild(0) instanceof ASTNode) {
                        ASTNode ch = (ASTNode)ast.getChild(0);
                        if (ch.getToken().getType() == 736 && ch.getChildCount() > 0 && ch.getChild(0) instanceof ASTNode) {
                            isTmpFileDest = (ch = (ASTNode)ch.getChild(0)).getToken().getType() == 986;
                        } else if (ast.getToken().getType() == 734 && ast.getChild(0).getType() == 948) {
                            String fullTableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
                            qbp.getInsertOverwriteTables().put(fullTableName, ast);
                        }
                    }
                    if (qbp.getIsSubQ() && !isTmpFileDest) {
                        throw new SemanticException(ErrorMsg.NO_INSERT_INSUBQUERY.getMsg(ast));
                    }
                    qbp.setDestForClause(ctx_1.dest, (ASTNode)ast.getChild(0));
                    this.handleInsertStatementSpecPhase1(ast, qbp, ctx_1);
                    if (qbp.getClauseNamesForDest().size() == 2) {
                        this.queryProperties.setMultiDestQuery(true);
                    }
                    if (plannerCtx != null && !this.queryProperties.hasMultiDestQuery()) {
                        plannerCtx.setInsertToken(ast, isTmpFileDest);
                        break;
                    }
                    if (plannerCtx == null || qbp.getClauseNamesForDest().size() != 2) break;
                    plannerCtx.resetToken();
                    plannerCtx.setMultiInsertToken((ASTNode)qbp.getQueryFrom().getChild(0));
                    break;
                }
                case 761: {
                    ASTNode frm;
                    int child_count = ast.getChildCount();
                    if (child_count != 1) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Multiple Children " + child_count));
                    }
                    if (!qbp.getIsSubQ()) {
                        qbp.setQueryFromExpr(ast);
                    }
                    if ((frm = (ASTNode)ast.getChild(0)).getToken().getType() == 977) {
                        this.processTable(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 1011) {
                        ASTNode newFrom = this.genValuesTempTable(frm, qb);
                        ast.setChild(0, (Tree)newFrom);
                        this.processTable(qb, newFrom);
                        break;
                    }
                    if (frm.getToken().getType() == 941) {
                        this.processSubQuery(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 803 || frm.getToken().getType() == 804) {
                        this.queryProperties.setHasLateralViews(true);
                        this.processLateralView(qb, frm);
                        break;
                    }
                    if (SemanticAnalyzer.isJoinToken(frm)) {
                        this.processJoin(qb, frm);
                        qbp.setJoinExpr(frm);
                        break;
                    }
                    if (frm.getToken().getType() != 875) break;
                    this.queryProperties.setHasPTF(true);
                    this.processPTF(qb, frm);
                    break;
                }
                case 703: {
                    this.queryProperties.setHasClusterBy(true);
                    qbp.setClusterByExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 738: {
                    this.queryProperties.setHasDistributeBy(true);
                    qbp.setDistributeByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                }
                case 934: {
                    this.queryProperties.setHasSortBy(true);
                    qbp.setSortByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_SORTBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_SORTBY_CONFLICT.getMsg()));
                }
                case 851: {
                    this.queryProperties.setHasOrderBy(true);
                    qbp.setOrderByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_ORDERBY_CONFLICT.getMsg()));
                }
                case 718: 
                case 772: 
                case 773: 
                case 897: {
                    this.queryProperties.setHasGroupBy(true);
                    if (qbp.getJoinExpr() != null) {
                        this.queryProperties.setHasJoinFollowedByGroupBy(true);
                    }
                    if (qbp.getSelForClause(ctx_1.dest).getToken().getType() == 900) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.SELECT_DISTINCT_WITH_GROUPBY.getMsg()));
                    }
                    qbp.setGroupByExprForClause(ctx_1.dest, ast);
                    skipRecursion = true;
                    if (ast.getToken().getType() == 897) {
                        qbp.getDestRollups().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() == 718) {
                        qbp.getDestCubes().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() != 773) break;
                    qbp.getDestGroupingSets().add(ctx_1.dest);
                    break;
                }
                case 775: {
                    qbp.setHavingExprForClause(ctx_1.dest, ast);
                    qbp.addAggregationExprsForClause(ctx_1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest));
                    break;
                }
                case 325: {
                    if (!qb.hasWindowingSpec(ctx_1.dest)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Query has no Cluster/Distribute By; but has a Window definition"));
                    }
                    this.handleQueryWindowClauses(qb, ctx_1, ast);
                    break;
                }
                case 809: {
                    if (ast.getChildCount() == 2) {
                        qbp.setDestLimit(ctx_1.dest, new Integer(ast.getChild(0).getText()), new Integer(ast.getChild(1).getText()));
                        break;
                    }
                    qbp.setDestLimit(ctx_1.dest, new Integer(0), new Integer(ast.getChild(0).getText()));
                    break;
                }
                case 692: {
                    String table_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0)).toLowerCase();
                    qb.setTabAlias(table_name, table_name);
                    qb.addAlias(table_name);
                    qb.getParseInfo().setIsAnalyzeCommand(true);
                    qb.getParseInfo().setNoScanAnalyzeCommand(this.noscan);
                    qb.getParseInfo().setPartialScanAnalyzeCommand(this.partialscan);
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
                    break;
                }
                case 994: {
                    if (!qbp.getIsSubQ()) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.UNION_NOTIN_SUBQ.getMsg()));
                    }
                    skipRecursion = false;
                    break;
                }
                case 782: {
                    ASTNode destination = (ASTNode)ast.getChild(0);
                    Tree tab = destination.getChild(0);
                    if (destination.getChildCount() == 2 && tab.getChildCount() == 2 && destination.getChild(1).getType() == 777) {
                        String tableName = tab.getChild(0).getChild(0).getText();
                        Tree partitions = tab.getChild(1);
                        int childCount = partitions.getChildCount();
                        HashMap<String, String> partition = new HashMap<String, String>();
                        for (int i = 0; i < childCount; ++i) {
                            String partitionName = partitions.getChild(i).getChild(0).getText();
                            Tree pvalue = partitions.getChild(i).getChild(1);
                            if (pvalue == null) break;
                            String partitionVal = SemanticAnalyzer.stripQuotes(pvalue.getText());
                            partition.put(partitionName, partitionVal);
                        }
                        if (childCount != partition.size()) {
                            throw new SemanticException(ErrorMsg.INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS.getMsg(partition.toString()));
                        }
                        Table table = null;
                        try {
                            table = this.getTableObjectByName(tableName);
                        }
                        catch (HiveException ex) {
                            throw new SemanticException(ex);
                        }
                        try {
                            Partition parMetaData = this.db.getPartition(table, partition, false);
                            if (parMetaData != null) {
                                phase1Result = false;
                                skipRecursion = true;
                                this.LOG.info("Partition already exists so insert into overwrite skipped for partition : " + parMetaData.toString());
                                break;
                            }
                        }
                        catch (HiveException e) {
                            this.LOG.info("Error while getting metadata : ", (Throwable)e);
                        }
                        SemanticAnalyzer.validatePartSpec(table, partition, (ASTNode)tab, this.conf, false);
                    }
                    skipRecursion = false;
                    break;
                }
                case 803: 
                case 804: {
                    assert (ast.getChildCount() == 1);
                    qb.getParseInfo().getDestToLateralView().put(ctx_1.dest, ast);
                    break;
                }
                case 717: {
                    this.processCTE(qb, ast);
                    break;
                }
                default: {
                    skipRecursion = false;
                }
            }
        }
        if (!skipRecursion) {
            int child_count = ast.getChildCount();
            for (int child_pos = 0; child_pos < child_count && phase1Result; ++child_pos) {
                phase1Result = phase1Result && this.doPhase1((ASTNode)ast.getChild(child_pos), qb, ctx_1, plannerCtx);
            }
        }
        return phase1Result;
    }

    private void handleInsertStatementSpecPhase1(ASTNode ast, QBParseInfo qbp, Phase1Ctx ctx_1) throws SemanticException {
        ASTNode tabColName = (ASTNode)ast.getChild(1);
        if (ast.getType() == 783 && tabColName != null && tabColName.getType() == 952) {
            ArrayList<String> targetColNames = new ArrayList<String>();
            for (Node col : tabColName.getChildren()) {
                assert (((ASTNode)col).getType() == 24) : "expected token 24 found " + ((ASTNode)col).getType();
                targetColNames.add(((ASTNode)col).getText());
            }
            String fullTableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
            qbp.setDestSchemaForClause(ctx_1.dest, targetColNames);
            HashSet<String> targetColumns = new HashSet<String>();
            targetColumns.addAll(targetColNames);
            if (targetColNames.size() != targetColumns.size()) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabColName, "Duplicate column name detected in " + fullTableName + " table schema specification"));
            }
            Table targetTable = null;
            try {
                targetTable = this.db.getTable(fullTableName, false);
            }
            catch (HiveException ex) {
                this.LOG.error("Error processing HiveParser.TOK_DESTINATION: " + ex.getMessage(), (Throwable)ex);
                throw new SemanticException(ex);
            }
            if (targetTable == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Unable to access metadata for table " + fullTableName));
            }
            for (FieldSchema f : targetTable.getCols()) {
                targetColumns.remove(f.getName());
            }
            if (!targetColumns.isEmpty()) {
                ASTNode tokTab;
                ASTNode tokPartSpec;
                ArrayList<String> dynamicPartitionColumns = new ArrayList<String>();
                if (ast.getChild(0) != null && ast.getChild(0).getType() == 948 && (tokPartSpec = (ASTNode)(tokTab = (ASTNode)ast.getChild(0)).getFirstChildWithType(855)) != null) {
                    for (Node n : tokPartSpec.getChildren()) {
                        ASTNode tokPartVal = null;
                        if (n instanceof ASTNode) {
                            tokPartVal = (ASTNode)n;
                        }
                        if (tokPartVal == null || tokPartVal.getType() != 856 || tokPartVal.getChildCount() != 1) continue;
                        assert (tokPartVal.getChild(0).getType() == 24) : "Expected column name; found tokType=" + tokPartVal.getType();
                        dynamicPartitionColumns.add(tokPartVal.getChild(0).getText());
                    }
                }
                for (String colName : dynamicPartitionColumns) {
                    targetColumns.remove(colName);
                }
                if (!targetColumns.isEmpty()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabColName, "'" + (targetColumns.size() == 1 ? targetColumns.iterator().next() : targetColumns) + "' in insert schema specification " + (targetColumns.size() == 1 ? "is" : "are") + " not found among regular columns of " + fullTableName + " nor dynamic partition columns."));
                }
            }
        }
    }

    public void getMaterializationMetadata(QB qb) throws SemanticException {
        try {
            this.gatherCTEReferences(qb, this.rootClause);
            int threshold = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_CTE_MATERIALIZE_THRESHOLD);
            for (CTEClause cte : Sets.newHashSet(this.aliasToCTEs.values())) {
                if (threshold < 0 || cte.reference < threshold) continue;
                cte.materialize = true;
            }
        }
        catch (HiveException e) {
            this.LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private void gatherCTEReferences(QBExpr qbexpr, CTEClause parent) throws HiveException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.gatherCTEReferences(qbexpr.getQB(), parent);
        } else {
            this.gatherCTEReferences(qbexpr.getQBExpr1(), parent);
            this.gatherCTEReferences(qbexpr.getQBExpr2(), parent);
        }
    }

    private void gatherCTEReferences(QB qb, CTEClause current) throws HiveException {
        for (String alias : qb.getTabAliases()) {
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            CTEClause cte = this.findCTEFromName(qb, cteName);
            if (cte == null) continue;
            if (this.ctesExpanded.contains(cteName)) {
                throw new SemanticException("Recursive cte " + cteName + " detected (cycle: " + StringUtils.join(this.ctesExpanded, " -> ") + " -> " + cteName + ").");
            }
            ++cte.reference;
            current.parents.add(cte);
            if (cte.qbExpr != null) continue;
            cte.qbExpr = new QBExpr(cteName);
            this.doPhase1QBExpr(cte.cteNode, cte.qbExpr, qb.getId(), cteName);
            this.ctesExpanded.add(cteName);
            this.gatherCTEReferences(cte.qbExpr, cte);
            this.ctesExpanded.remove(this.ctesExpanded.size() - 1);
        }
        for (String alias : qb.getSubqAliases()) {
            this.gatherCTEReferences(qb.getSubqForAlias(alias), current);
        }
    }

    public void getMetaData(QB qb) throws SemanticException {
        this.getMetaData(qb, false);
    }

    public void getMetaData(QB qb, boolean enableMaterialization) throws SemanticException {
        try {
            if (enableMaterialization) {
                this.getMaterializationMetadata(qb);
            }
            this.getMetaData(qb, null);
        }
        catch (HiveException e) {
            this.LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private void getMetaData(QBExpr qbexpr, ReadEntity parentInput) throws HiveException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.getMetaData(qbexpr.getQB(), parentInput);
        } else {
            this.getMetaData(qbexpr.getQBExpr1(), parentInput);
            this.getMetaData(qbexpr.getQBExpr2(), parentInput);
        }
    }

    private void getMetaData(QB qb, ReadEntity parentInput) throws HiveException {
        this.LOG.info("Get metadata for source tables");
        ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
        HashMap<String, ObjectPair<String, ReadEntity>> aliasToViewInfo = new HashMap<String, ObjectPair<String, ReadEntity>>();
        HashMap<String, String> sqAliasToCTEName = new HashMap<String, String>();
        for (String alias : tabAliases) {
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            Table tab = this.db.getTable(tabName, false);
            if (tab == null || tab.getDbName().equals(SessionState.get().getCurrentDatabase())) {
                Table materializedTab = this.ctx.getMaterializedTable(cteName);
                if (materializedTab == null) {
                    CTEClause cte = this.findCTEFromName(qb, cteName);
                    if (cte != null) {
                        if (!cte.materialize) {
                            this.addCTEAsSubQuery(qb, cteName, alias);
                            sqAliasToCTEName.put(alias, cteName);
                            continue;
                        }
                        tab = this.materializeCTE(cteName, cte);
                    }
                } else {
                    tab = materializedTab;
                }
            }
            if (tab == null) {
                ASTNode src = qb.getParseInfo().getSrcForAlias(alias);
                if (null != src) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(src));
                }
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(alias));
            }
            if (tab.isView()) {
                if (qb.getParseInfo().isAnalyzeCommand()) {
                    throw new SemanticException(ErrorMsg.ANALYZE_VIEW.getMsg());
                }
                String fullViewName = tab.getDbName() + "." + tab.getTableName();
                if (this.viewsExpanded.contains(fullViewName)) {
                    throw new SemanticException("Recursive view " + fullViewName + " detected (cycle: " + StringUtils.join(this.viewsExpanded, " -> ") + " -> " + fullViewName + ").");
                }
                this.replaceViewReferenceWithDefinition(qb, tab, tabName, alias);
                if (qb.isInsideView() && parentInput == null) {
                    parentInput = PlanUtils.getParentViewInfo(this.getAliasId(alias, qb), this.viewAliasToInput);
                }
                ReadEntity viewInput = new ReadEntity(tab, parentInput, !qb.isInsideView());
                viewInput = PlanUtils.addInput(this.inputs, viewInput);
                aliasToViewInfo.put(alias, new ObjectPair<String, ReadEntity>(fullViewName, viewInput));
                String aliasId = this.getAliasId(alias, qb);
                if (aliasId != null) {
                    aliasId = aliasId.replace(SUBQUERY_TAG_1, "").replace(SUBQUERY_TAG_2, "");
                }
                this.viewAliasToInput.put(aliasId, viewInput);
                continue;
            }
            if (!InputFormat.class.isAssignableFrom(tab.getInputFormatClass())) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), ErrorMsg.INVALID_INPUT_FORMAT_TYPE.getMsg()));
            }
            qb.getMetaData().setSrcForAlias(alias, tab);
            if (qb.getParseInfo().isAnalyzeCommand()) {
                QBParseInfo qbpi;
                BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)this.ast.getChild(0), true, this.noscan);
                if (ts.specType == BaseSemanticAnalyzer.TableSpec.SpecType.DYNAMIC_PARTITION) {
                    try {
                        ts.partitions = this.db.getPartitionsByNames(ts.tableHandle, ts.partSpec);
                    }
                    catch (HiveException e) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), "Cannot get partitions for " + ts.partSpec), e);
                    }
                }
                if ((qbpi = qb.getParseInfo()).isPartialScanAnalyzeCommand()) {
                    Class<? extends InputFormat> inputFormatClass = null;
                    switch (ts.specType) {
                        case TABLE_ONLY: 
                        case DYNAMIC_PARTITION: {
                            inputFormatClass = ts.tableHandle.getInputFormatClass();
                            break;
                        }
                        case STATIC_PARTITION: {
                            inputFormatClass = ts.partHandle.getInputFormatClass();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    if (!inputFormatClass.equals(RCFileInputFormat.class) && !inputFormatClass.equals(OrcInputFormat.class)) {
                        throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_NON_RCFILE.getMsg());
                    }
                }
                tab.setTableSpec(ts);
                qb.getParseInfo().addTableSpec(alias, ts);
            }
            ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(this.getAliasId(alias, qb), this.viewAliasToInput);
            if (PlanUtils.isValuesTempTable(alias)) continue;
            PlanUtils.addInput(this.inputs, new ReadEntity(tab, parentViewInfo, parentViewInfo == null), this.mergeIsDirect);
        }
        this.LOG.info("Get metadata for subqueries");
        for (String alias : qb.getSubqAliases()) {
            boolean wasView = aliasToViewInfo.containsKey(alias);
            boolean wasCTE = sqAliasToCTEName.containsKey(alias);
            ReadEntity newParentInput = null;
            if (wasView) {
                this.viewsExpanded.add((String)((ObjectPair)aliasToViewInfo.get(alias)).getFirst());
                newParentInput = (ReadEntity)((ObjectPair)aliasToViewInfo.get(alias)).getSecond();
            } else if (wasCTE) {
                this.ctesExpanded.add((String)sqAliasToCTEName.get(alias));
            }
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            this.getMetaData(qbexpr, newParentInput);
            if (wasView) {
                this.viewsExpanded.remove(this.viewsExpanded.size() - 1);
                continue;
            }
            if (!wasCTE) continue;
            this.ctesExpanded.remove(this.ctesExpanded.size() - 1);
        }
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams(this);
        StorageFormat storageFormat = new StorageFormat(this.conf);
        this.LOG.info("Get metadata for destination tables");
        QBParseInfo qbp = qb.getParseInfo();
        block20: for (String name : qbp.getClauseNamesForDest()) {
            ASTNode ast = qbp.getDestForClause(name);
            switch (ast.getToken().getType()) {
                case 948: {
                    BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, ast);
                    if (ts.tableHandle.isView() || ts.tableHandle.isMaterializedView()) {
                        throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
                    }
                    Class<? extends OutputFormat> outputFormatClass = ts.tableHandle.getOutputFormatClass();
                    if (!ts.tableHandle.isNonNative() && !HiveOutputFormat.class.isAssignableFrom(outputFormatClass)) {
                        throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg(ast, "The class is " + outputFormatClass.toString()));
                    }
                    boolean isTableWrittenTo = qb.getParseInfo().isInsertIntoTable(ts.tableHandle.getDbName(), ts.tableHandle.getTableName());
                    assert (isTableWrittenTo |= qb.getParseInfo().getInsertOverwriteTables().get(SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0), ts.tableHandle.getDbName())) != null) : "Inconsistent data structure detected: we are writing to " + ts.tableHandle + " in " + name + " but it's not in isInsertIntoTable() or getInsertOverwriteTables()";
                    boolean isAcid = AcidUtils.isAcidTable(ts.tableHandle);
                    if ((this.updating(name) || this.deleting(name)) && !isAcid) {
                        throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TABLE, ts.tableName);
                    }
                    if (ts.specType != BaseSemanticAnalyzer.TableSpec.SpecType.STATIC_PARTITION) {
                        qb.getMetaData().setDestForAlias(name, ts.tableHandle);
                        if (ts.partSpec != null && ts.partSpec.size() > 0) {
                            qb.getMetaData().setPartSpecForAlias(name, ts.partSpec);
                        }
                    } else {
                        qb.getMetaData().setDestForAlias(name, ts.partHandle);
                    }
                    if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) continue block20;
                    qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                    continue block20;
                }
                case 736: {
                    String fname = SemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
                    if (!qb.getParseInfo().getIsSubQ() && ((ASTNode)ast.getChild(0)).getToken().getType() == 986) {
                        if (qb.isCTAS() || qb.isMaterializedView()) {
                            Path location;
                            qb.setIsQuery(false);
                            this.ctx.setResDir(null);
                            this.ctx.setResFile(null);
                            if (qb.getTableDesc() != null && qb.getTableDesc().getLocation() != null) {
                                location = new Path(qb.getTableDesc().getLocation());
                            } else {
                                String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                                String[] names = Utilities.getDbTableName(tableName);
                                try {
                                    String destTableDb;
                                    Warehouse wh = new Warehouse(this.conf);
                                    String string = destTableDb = qb.getTableDesc() != null ? qb.getTableDesc().getDatabaseName() : null;
                                    if (destTableDb == null) {
                                        destTableDb = names[0];
                                    }
                                    location = wh.getDatabasePath(this.db.getDatabase(destTableDb));
                                }
                                catch (MetaException e) {
                                    throw new SemanticException(e);
                                }
                            }
                            try {
                                fname = this.ctx.getExtTmpPathRelTo(FileUtils.makeQualified(location, this.conf)).toString();
                            }
                            catch (Exception e) {
                                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Error creating temporary folder on: " + location.toString()), e);
                            }
                            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                                BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, this.ast);
                                qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                            }
                        } else {
                            qb.setIsQuery(true);
                            Path stagingPath = this.getStagingDirectoryPathname(qb);
                            fname = stagingPath.toString();
                            this.ctx.setResDir(stagingPath);
                        }
                    }
                    boolean isDfsFile = true;
                    if (ast.getChildCount() >= 2 && ast.getChild(1).getText().toLowerCase().equals("local")) {
                        isDfsFile = false;
                    }
                    qb.getMetaData().setDestForAlias(name, fname, isDfsFile);
                    CreateTableDesc directoryDesc = new CreateTableDesc();
                    boolean directoryDescIsSet = false;
                    int numCh = ast.getChildCount();
                    block21: for (int num = 1; num < numCh; ++num) {
                        ASTNode child = (ASTNode)ast.getChild(num);
                        if (child == null) continue;
                        if (storageFormat.fillStorageFormat(child)) {
                            directoryDesc.setOutputFormat(storageFormat.getOutputFormat());
                            directoryDesc.setSerName(storageFormat.getSerde());
                            directoryDescIsSet = true;
                            continue;
                        }
                        switch (child.getToken().getType()) {
                            case 964: {
                                rowFormatParams.analyzeRowFormat(child);
                                directoryDesc.setFieldDelim(rowFormatParams.fieldDelim);
                                directoryDesc.setLineDelim(rowFormatParams.lineDelim);
                                directoryDesc.setCollItemDelim(rowFormatParams.collItemDelim);
                                directoryDesc.setMapKeyDelim(rowFormatParams.mapKeyDelim);
                                directoryDesc.setFieldEscape(rowFormatParams.fieldEscape);
                                directoryDesc.setNullFormat(rowFormatParams.nullFormat);
                                directoryDescIsSet = true;
                                continue block21;
                            }
                            case 970: {
                                ASTNode serdeChild = (ASTNode)child.getChild(0);
                                storageFormat.setSerde(SemanticAnalyzer.unescapeSQLString(serdeChild.getChild(0).getText()));
                                directoryDesc.setSerName(storageFormat.getSerde());
                                if (serdeChild.getChildCount() > 1) {
                                    directoryDesc.setSerdeProps(new HashMap<String, String>());
                                    SemanticAnalyzer.readProps((ASTNode)serdeChild.getChild(1).getChild(0), directoryDesc.getSerdeProps());
                                }
                                directoryDescIsSet = true;
                            }
                        }
                    }
                    if (!directoryDescIsSet) continue block20;
                    qb.setDirectoryDesc(directoryDesc);
                    continue block20;
                }
            }
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Unknown Token Type " + ast.getToken().getType()));
        }
    }

    private boolean isPathEncrypted(Path path) throws HiveException {
        try {
            HadoopShims.HdfsEncryptionShim hdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(path.getFileSystem((Configuration)this.conf));
            if (hdfsEncryptionShim != null && hdfsEncryptionShim.isPathEncrypted(path)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to determine if " + path + " is encrypted: " + e, e);
        }
        return false;
    }

    private int comparePathKeyStrength(Path p1, Path p2) throws HiveException {
        HadoopShims.HdfsEncryptionShim hdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim();
        if (hdfsEncryptionShim != null) {
            try {
                return hdfsEncryptionShim.comparePathKeyStrength(p1, p2);
            }
            catch (Exception e) {
                throw new HiveException("Unable to compare key strength for " + p1 + " and " + p2 + " : " + e, e);
            }
        }
        return 0;
    }

    private boolean isPathReadOnly(Path path) throws HiveException {
        HiveConf conf = SessionState.get().getConf();
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            UserGroupInformation ugi = Utils.getUGI();
            FileStatus status = fs.getFileStatus(path);
            FileUtils.checkFileAccessWithImpersonation(fs, status, FsAction.WRITE, ugi.getUserName());
            return false;
        }
        catch (AccessControlException e) {
            return true;
        }
        catch (Exception e) {
            throw new HiveException("Unable to determine if " + path + " is read only: " + e, e);
        }
    }

    private Path getStrongestEncryptedTablePath(QB qb) throws HiveException {
        ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
        Path strongestPath = null;
        for (String alias : tabAliases) {
            Path tablePath;
            Table tab = qb.getMetaData().getTableForAlias(alias);
            if (tab == null || (tablePath = tab.getDataLocation()) == null || !"hdfs".equalsIgnoreCase(tablePath.toUri().getScheme()) || !this.isPathEncrypted(tablePath)) continue;
            if (strongestPath == null) {
                strongestPath = tablePath;
                continue;
            }
            if (this.comparePathKeyStrength(tablePath, strongestPath) <= 0) continue;
            strongestPath = tablePath;
        }
        return strongestPath;
    }

    private Path getStagingDirectoryPathname(QB qb) throws HiveException {
        Path stagingPath = null;
        Path tablePath = this.getStrongestEncryptedTablePath(qb);
        if (tablePath != null) {
            if (this.isPathReadOnly(tablePath)) {
                Path tmpPath = this.ctx.getMRTmpPath();
                if (this.comparePathKeyStrength(tablePath, tmpPath) < 0) {
                    throw new HiveException("Read-only encrypted tables cannot be read if the scratch directory is not encrypted (or encryption is weak)");
                }
                stagingPath = tmpPath;
            }
            if (stagingPath == null) {
                stagingPath = this.ctx.getMRTmpPath(tablePath.toUri());
            }
        } else {
            stagingPath = this.ctx.getMRTmpPath();
        }
        return stagingPath;
    }

    private void replaceViewReferenceWithDefinition(QB qb, Table tab, String tab_name, String alias) throws SemanticException {
        ASTNode viewTree;
        final ASTNodeOrigin viewOrigin = new ASTNodeOrigin("VIEW", tab.getTableName(), tab.getViewExpandedText(), alias, qb.getParseInfo().getSrcForAlias(alias));
        try {
            String viewFullyQualifiedName = tab.getCompleteName();
            String viewText = tab.getViewExpandedText();
            TableMask viewMask = new TableMask(this, this.conf, false);
            viewTree = ParseUtils.parse(viewText, this.ctx, tab.getCompleteName());
            if (!this.unparseTranslator.isEnabled() && viewMask.isEnabled() && this.analyzeRewrite == null) {
                viewTree = SemanticAnalyzer.rewriteASTWithMaskAndFilter(viewMask, viewTree, this.ctx.getViewTokenRewriteStream(viewFullyQualifiedName), this.ctx, this.db, this.tabNameToTabObject, this.ignoredTokens);
            }
            Dispatcher nodeOriginDispatcher = new Dispatcher(){

                @Override
                public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) {
                    ((ASTNode)nd).setOrigin(viewOrigin);
                    return null;
                }
            };
            DefaultGraphWalker nodeOriginTagger = new DefaultGraphWalker(nodeOriginDispatcher);
            nodeOriginTagger.startWalking(Collections.singleton(viewTree), null);
        }
        catch (ParseException e) {
            this.LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            ErrorMsg.renderOrigin(sb, viewOrigin);
            throw new SemanticException(sb.toString(), e);
        }
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(viewTree, qbexpr, qb.getId(), alias, true);
        if (!this.skipAuthorization() && !qb.isInsideView() && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED) || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            qb.rewriteViewToSubq(alias, tab_name, qbexpr, tab);
        } else {
            qb.rewriteViewToSubq(alias, tab_name, qbexpr, null);
        }
    }

    private boolean isPresent(String[] list, String elem) {
        for (String s : list) {
            if (!s.toLowerCase().equals(elem)) continue;
            return true;
        }
        return false;
    }

    private String findAlias(ASTNode columnRef, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String colName = SemanticAnalyzer.unescapeIdentifier(columnRef.getChild(0).getText().toLowerCase());
        String tabAlias = null;
        if (aliasToOpInfo != null) {
            for (Map.Entry<String, Operator> opEntry : aliasToOpInfo.entrySet()) {
                Operator op = opEntry.getValue();
                RowResolver rr = this.opParseCtx.get(op).getRowResolver();
                ColumnInfo colInfo = rr.get(null, colName);
                if (colInfo == null) continue;
                if (tabAlias == null) {
                    tabAlias = opEntry.getKey();
                    continue;
                }
                throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(columnRef.getChild(0)));
            }
        }
        if (tabAlias == null) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(columnRef.getChild(0)));
        }
        return tabAlias;
    }

    void parseJoinCondPopulateAlias(QBJoinTree joinTree, ASTNode condn, ArrayList<String> leftAliases, ArrayList<String> rightAliases, ArrayList<String> fields, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        switch (condn.getToken().getType()) {
            case 973: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(condn.getChild(0).getText().toLowerCase());
                this.unparseTranslator.addIdentifierTranslation((ASTNode)condn.getChild(0));
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (this.isPresent(joinTree.getRightAliases(), tableOrCol)) {
                    if (rightAliases.contains(tableOrCol)) break;
                    rightAliases.add(tableOrCol);
                    break;
                }
                tableOrCol = this.findAlias(condn, aliasToOpInfo);
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (!rightAliases.contains(tableOrCol)) {
                    rightAliases.add(tableOrCol);
                }
                if (joinTree.getNoSemiJoin()) break;
                joinTree.addRHSSemijoinColumns(tableOrCol, condn);
                break;
            }
            case 24: {
                if (fields != null) {
                    fields.add(SemanticAnalyzer.unescapeIdentifier(condn.getToken().getText().toLowerCase()));
                }
                this.unparseTranslator.addIdentifierTranslation(condn);
                break;
            }
            case 25: 
            case 117: 
            case 295: 
            case 340: 
            case 341: 
            case 352: 
            case 702: 
            case 939: {
                break;
            }
            case 763: {
                for (int i = 1; i < condn.getChildCount(); ++i) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(i), leftAliases, rightAliases, null, aliasToOpInfo);
                }
                break;
            }
            default: {
                if (condn.getChildCount() == 1) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                    break;
                }
                if (condn.getChildCount() == 2) {
                    ArrayList<String> fields1 = null;
                    if (!joinTree.getNoSemiJoin() && condn.getToken().getType() == 16) {
                        fields1 = new ArrayList<String>();
                        int rhssize = rightAliases.size();
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                        String rhsAlias = null;
                        if (rightAliases.size() > rhssize) {
                            rhsAlias = rightAliases.get(rightAliases.size() - 1);
                        }
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1, aliasToOpInfo);
                        if (rhsAlias == null || fields1.size() <= 0) break;
                        joinTree.addRHSSemijoinColumns(rhsAlias, condn);
                        break;
                    }
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1, aliasToOpInfo);
                    break;
                }
                throw new SemanticException(condn.toStringTree() + " encountered with " + condn.getChildCount() + " children");
            }
        }
    }

    private void populateAliases(List<String> leftAliases, List<String> rightAliases, ASTNode condn, QBJoinTree joinTree, List<String> leftSrc) throws SemanticException {
        if (leftAliases.size() != 0 && rightAliases.size() != 0) {
            joinTree.addPostJoinFilter(condn);
            return;
        }
        if (rightAliases.size() != 0) {
            assert (rightAliases.size() == 1);
            joinTree.getExpressions().get(1).add(condn);
        } else if (leftAliases.size() != 0) {
            joinTree.getExpressions().get(0).add(condn);
            for (String s : leftAliases) {
                if (leftSrc.contains(s)) continue;
                leftSrc.add(s);
            }
        } else {
            joinTree.addPostJoinFilter(condn);
        }
    }

    /*
     * WARNING - void declaration
     */
    void applyEqualityPredicateToQBJoinTree(QBJoinTree joinTree, JoinType type, List<String> leftSrc, ASTNode joinCond, ASTNode leftCondn, ASTNode rightCondn, List<String> leftCondAl1, List<String> leftCondAl2, List<String> rightCondAl1, List<String> rightCondAl2) throws SemanticException {
        if (leftCondAl1.size() != 0) {
            if (rightCondAl1.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(0).add(joinCond);
                } else {
                    if (rightCondAl1.size() != 0) {
                        QBJoinTree leftTree = joinTree.getJoinSrc();
                        ArrayList<String> leftTreeLeftSrc = new ArrayList<String>();
                        if (leftTree != null && leftTree.getNoOuterJoin()) {
                            void var16_26;
                            String leftTreeRightSource = leftTree.getRightAliases() != null && leftTree.getRightAliases().length > 0 ? leftTree.getRightAliases()[0] : null;
                            boolean leftHasRightReference = false;
                            for (String string : leftCondAl1) {
                                if (!string.equals(leftTreeRightSource)) continue;
                                leftHasRightReference = true;
                                break;
                            }
                            boolean rightHasRightReference = false;
                            for (String r : rightCondAl1) {
                                if (!r.equals(leftTreeRightSource)) continue;
                                rightHasRightReference = true;
                                break;
                            }
                            boolean bl = false;
                            if (!leftHasRightReference && !rightHasRightReference) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                                boolean bl2 = true;
                            } else if (!leftHasRightReference && rightHasRightReference && rightCondAl1.size() == 1) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl2, rightCondAl1);
                                boolean bl3 = true;
                            } else if (leftHasRightReference && !rightHasRightReference && leftCondAl1.size() == 1) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl2, leftCondAl1, rightCondAl1, rightCondAl2);
                                boolean bl4 = true;
                            }
                            if (leftTreeLeftSrc.size() == 1) {
                                leftTree.setLeftAlias((String)leftTreeLeftSrc.get(0));
                            }
                            if (var16_26 != false) {
                                return;
                            }
                        }
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                }
            } else if (rightCondAl2.size() != 0) {
                this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                boolean nullsafe = joinCond.getToken().getType() == 19;
                joinTree.getNullSafes().add(nullsafe);
            }
        } else if (leftCondAl2.size() != 0) {
            if (rightCondAl2.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(1).add(joinCond);
                } else {
                    joinTree.getFiltersForPushing().get(1).add(joinCond);
                }
            } else if (rightCondAl1.size() != 0) {
                this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                boolean nullsafe = joinCond.getToken().getType() == 19;
                joinTree.getNullSafes().add(nullsafe);
            }
        } else if (rightCondAl1.size() != 0) {
            if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                joinTree.getFilters().get(0).add(joinCond);
            } else {
                joinTree.getFiltersForPushing().get(0).add(joinCond);
            }
        } else if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
            joinTree.getFilters().get(1).add(joinCond);
        } else if (type.equals((Object)JoinType.LEFTSEMI)) {
            joinTree.getExpressions().get(0).add(leftCondn);
            joinTree.getExpressions().get(1).add(rightCondn);
            boolean nullsafe = joinCond.getToken().getType() == 19;
            joinTree.getNullSafes().add(nullsafe);
            joinTree.getFiltersForPushing().get(1).add(joinCond);
        } else {
            joinTree.getFiltersForPushing().get(1).add(joinCond);
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        JoinCond cond = joinTree.getJoinCond()[0];
        JoinType type = cond.getJoinType();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, type, aliasToOpInfo);
        ArrayList<ArrayList<ASTNode>> filters = joinTree.getFilters();
        if (type == JoinType.LEFTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getLeft(), cond.getRight(), ((ArrayList)filters.get(0)).size());
        }
        if (type == JoinType.RIGHTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getRight(), cond.getLeft(), ((ArrayList)filters.get(1)).size());
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc, JoinType type, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        switch (joinCond.getToken().getType()) {
            case 202: {
                joinTree.addPostJoinFilter(joinCond);
                break;
            }
            case 33: {
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(0), leftSrc, type, aliasToOpInfo);
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(1), leftSrc, type, aliasToOpInfo);
                break;
            }
            case 18: 
            case 19: {
                ASTNode leftCondn = (ASTNode)joinCond.getChild(0);
                ArrayList<String> leftCondAl1 = new ArrayList<String>();
                ArrayList<String> leftCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null, aliasToOpInfo);
                ASTNode rightCondn = (ASTNode)joinCond.getChild(1);
                ArrayList<String> rightCondAl1 = new ArrayList<String>();
                ArrayList<String> rightCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null, aliasToOpInfo);
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    joinTree.addPostJoinFilter(joinCond);
                    break;
                }
                this.applyEqualityPredicateToQBJoinTree(joinTree, type, leftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                break;
            }
            default: {
                int ci;
                boolean isFunction = joinCond.getType() == 763;
                int childrenBegin = isFunction ? 1 : 0;
                ArrayList leftAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                ArrayList rightAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                for (ci = 0; ci < joinCond.getChildCount() - childrenBegin; ++ci) {
                    ArrayList left = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    leftAlias.add(left);
                    rightAlias.add(arrayList);
                }
                for (ci = childrenBegin; ci < joinCond.getChildCount(); ++ci) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond.getChild(ci), (ArrayList)leftAlias.get(ci - childrenBegin), (ArrayList)rightAlias.get(ci - childrenBegin), null, aliasToOpInfo);
                }
                boolean leftAliasNull = true;
                for (ArrayList arrayList : leftAlias) {
                    if (arrayList.size() == 0) continue;
                    leftAliasNull = false;
                    break;
                }
                boolean rightAliasNull = true;
                for (ArrayList arrayList : rightAlias) {
                    if (arrayList.size() == 0) continue;
                    rightAliasNull = false;
                    break;
                }
                if (!leftAliasNull && !rightAliasNull) {
                    joinTree.addPostJoinFilter(joinCond);
                    break;
                }
                if (!leftAliasNull) {
                    if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                        joinTree.getFilters().get(0).add(joinCond);
                        break;
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                    break;
                }
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(1).add(joinCond);
                    break;
                }
                joinTree.getFiltersForPushing().get(1).add(joinCond);
            }
        }
    }

    private void extractJoinCondsFromWhereClause(QBJoinTree joinTree, QB qb, String dest, ASTNode predicate, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        switch (predicate.getType()) {
            case 33: {
                this.extractJoinCondsFromWhereClause(joinTree, qb, dest, (ASTNode)predicate.getChild(0), aliasToOpInfo);
                this.extractJoinCondsFromWhereClause(joinTree, qb, dest, (ASTNode)predicate.getChild(1), aliasToOpInfo);
                break;
            }
            case 18: 
            case 19: {
                ASTNode leftCondn = (ASTNode)predicate.getChild(0);
                ArrayList<String> leftCondAl1 = new ArrayList<String>();
                ArrayList<String> leftCondAl2 = new ArrayList<String>();
                try {
                    this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null, aliasToOpInfo);
                }
                catch (SemanticException se) {
                    return;
                }
                ASTNode rightCondn = (ASTNode)predicate.getChild(1);
                ArrayList<String> rightCondAl1 = new ArrayList<String>();
                ArrayList<String> rightCondAl2 = new ArrayList<String>();
                try {
                    this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null, aliasToOpInfo);
                }
                catch (SemanticException se) {
                    return;
                }
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    return;
                }
                if (leftCondAl1.size() == 0 && leftCondAl2.size() == 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                    return;
                }
                ArrayList<String> leftSrc = new ArrayList<String>();
                JoinCond cond = joinTree.getJoinCond()[0];
                JoinType type = cond.getJoinType();
                this.applyEqualityPredicateToQBJoinTree(joinTree, type, leftSrc, predicate, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                if (leftSrc.size() != 1) break;
                joinTree.setLeftAlias((String)leftSrc.get(0));
                break;
            }
            default: {
                return;
            }
        }
    }

    public <T extends OperatorDesc> Operator<T> putOpInsertMap(Operator<T> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.opParseCtx.put(op, ctx);
        op.augmentPlan();
        return op;
    }

    private Operator genHavingPlan(String dest, QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        ASTNode havingExpr = qb.getParseInfo().getHavingForClause(dest);
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        Map<ASTNode, String> exprToColumnAlias = qb.getParseInfo().getAllExprToColumnAlias();
        for (ASTNode astNode : exprToColumnAlias.keySet()) {
            if (inputRR.getExpression(astNode) == null) continue;
            inputRR.put("", exprToColumnAlias.get(astNode), inputRR.getExpression(astNode));
        }
        ASTNode condn = (ASTNode)havingExpr.getChild(0);
        if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
            String destClauseName = qb.getParseInfo().getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
            condn = SemanticAnalyzer.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), destClauseName), condn, !cubeRollupGrpSetPresent);
        }
        Operator output = this.genFilterPlan(condn, qb, input, aliasToOpInfo, true, false);
        output = this.putOpInsertMap(output, inputRR);
        return output;
    }

    protected static ASTNode rewriteGroupingFunctionAST(final List<ASTNode> grpByAstExprs, ASTNode targetNode, final boolean noneSet) throws SemanticException {
        final MutableBoolean visited = new MutableBoolean(false);
        final MutableBoolean found = new MutableBoolean(false);
        TreeVisitorAction action = new TreeVisitorAction(){

            public Object pre(Object t) {
                return t;
            }

            public Object post(Object t) {
                ASTNode func;
                ASTNode root = (ASTNode)t;
                if (root.getType() == 763 && root.getChildCount() == 2 && (func = (ASTNode)ParseDriver.adaptor.getChild((Object)root, 0)).getText().equals("grouping")) {
                    ASTNode c = (ASTNode)ParseDriver.adaptor.getChild((Object)root, 1);
                    visited.setValue(true);
                    for (int i = 0; i < grpByAstExprs.size(); ++i) {
                        ASTNode child1;
                        ASTNode grpByExpr = (ASTNode)grpByAstExprs.get(i);
                        if (!grpByExpr.toStringTree().equals(c.toStringTree())) continue;
                        if (noneSet) {
                            child1 = (ASTNode)ParseDriver.adaptor.create(25, String.valueOf(0));
                        } else {
                            child1 = (ASTNode)ParseDriver.adaptor.create(973, "TOK_TABLE_OR_COL");
                            ParseDriver.adaptor.addChild((Object)child1, ParseDriver.adaptor.create(24, VirtualColumn.GROUPINGID.getName()));
                        }
                        ASTNode child2 = (ASTNode)ParseDriver.adaptor.create(25, String.valueOf(IntMath.mod(-i - 1, grpByAstExprs.size())));
                        root.setChild(1, (Tree)child1);
                        root.addChild((Tree)child2);
                        found.setValue(true);
                        break;
                    }
                }
                return t;
            }
        };
        ASTNode newTargetNode = (ASTNode)new TreeVisitor(ParseDriver.adaptor).visit((Object)targetNode, action);
        if (visited.booleanValue() && !found.booleanValue()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_FUNCTION_EXPR_NOT_IN_GROUPBY.getMsg());
        }
        return newTargetNode;
    }

    private Operator genPlanForSubQueryPredicate(QB qbSQ, SubQueryUtils.ISubQueryJoinInfo subQueryPredicate) throws SemanticException {
        qbSQ.setSubQueryDef(subQueryPredicate.getSubQuery());
        Phase1Ctx ctx_1 = this.initPhase1Ctx();
        this.doPhase1(subQueryPredicate.getSubQueryAST(), qbSQ, ctx_1, null);
        this.getMetaData(qbSQ);
        Operator op = this.genPlan(qbSQ);
        return op;
    }

    private Operator genFilterPlan(ASTNode searchCond, QB qb, Operator input, Map<String, Operator> aliasToOpInfo, boolean forHavingClause, boolean forGroupByClause) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        List<ASTNode> subQueriesInOriginalTree = SubQueryUtils.findSubQueries(searchCond);
        if (subQueriesInOriginalTree.size() > 0) {
            if (qb.getSubQueryPredicateDef() != null) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(subQueriesInOriginalTree.get(0), "Nested SubQuery expressions are not supported."));
            }
            if (subQueriesInOriginalTree.size() > 1) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(subQueriesInOriginalTree.get(1), "Only 1 SubQuery expression is supported."));
            }
            ASTNode clonedSearchCond = (ASTNode)SubQueryUtils.adaptor.dupTree((Object)searchCond);
            List<ASTNode> subQueries = SubQueryUtils.findSubQueries(clonedSearchCond);
            for (int i = 0; i < subQueries.size(); ++i) {
                ASTNode subQueryAST = subQueries.get(i);
                ASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
                int sqIdx = qb.incrNumSubQueryPredicates();
                clonedSearchCond = SubQueryUtils.rewriteParentQueryWhere(clonedSearchCond, subQueryAST);
                QBSubQuery subQuery = SubQueryUtils.buildSubQuery(qb.getId(), sqIdx, subQueryAST, originalSubQueryAST, this.ctx);
                if (!forHavingClause) {
                    qb.setWhereClauseSubQueryPredicate(subQuery);
                } else {
                    qb.setHavingClauseSubQueryPredicate(subQuery);
                }
                String havingInputAlias = null;
                if (forHavingClause) {
                    havingInputAlias = "gby_sq" + sqIdx;
                    aliasToOpInfo.put(havingInputAlias, input);
                }
                subQuery.validateAndRewriteAST(inputRR, forHavingClause, havingInputAlias, aliasToOpInfo.keySet());
                QB qbSQ = new QB(subQuery.getOuterQueryId(), subQuery.getAlias(), true);
                Operator sqPlanTopOp = this.genPlanForSubQueryPredicate(qbSQ, subQuery);
                aliasToOpInfo.put(subQuery.getAlias(), sqPlanTopOp);
                RowResolver sqRR = this.opParseCtx.get(sqPlanTopOp).getRowResolver();
                if (subQuery.getOperator().getType() != QBSubQuery.SubQueryType.EXISTS && subQuery.getOperator().getType() != QBSubQuery.SubQueryType.NOT_EXISTS && sqRR.getColumnInfos().size() - subQuery.getNumOfCorrelationExprsAddedToSQSelect() > 1) {
                    throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(subQueryAST, "SubQuery can contain only 1 item in Select List."));
                }
                if (subQuery.getNotInCheck() != null) {
                    QBSubQuery.NotInCheck notInCheck = subQuery.getNotInCheck();
                    notInCheck.setSQRR(sqRR);
                    QB qbSQ_nic = new QB(subQuery.getOuterQueryId(), notInCheck.getAlias(), true);
                    Operator sqnicPlanTopOp = this.genPlanForSubQueryPredicate(qbSQ_nic, notInCheck);
                    aliasToOpInfo.put(notInCheck.getAlias(), sqnicPlanTopOp);
                    QBJoinTree joinTree_nic = this.genSQJoinTree(qb, notInCheck, input, aliasToOpInfo);
                    this.pushJoinFilters(qb, joinTree_nic, aliasToOpInfo, false);
                    input = this.genJoinOperator(qbSQ_nic, joinTree_nic, aliasToOpInfo, input);
                    inputRR = this.opParseCtx.get(input).getRowResolver();
                    if (forHavingClause) {
                        aliasToOpInfo.put(havingInputAlias, input);
                    }
                }
                subQuery.buildJoinCondition(inputRR, sqRR, forHavingClause, havingInputAlias);
                QBJoinTree joinTree = this.genSQJoinTree(qb, subQuery, input, aliasToOpInfo);
                this.pushJoinFilters(qb, joinTree, aliasToOpInfo, false);
                input = this.genJoinOperator(qbSQ, joinTree, aliasToOpInfo, input);
                searchCond = subQuery.updateOuterQueryFilter(clonedSearchCond);
            }
        }
        return this.genFilterPlan(qb, searchCond, input, forHavingClause || forGroupByClause);
    }

    private Operator genFilterPlan(QB qb, ASTNode condn, Operator input, boolean useCaching) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        ExprNodeDesc filterCond = this.genExprNodeDesc(condn, inputRR, useCaching, this.isCBOExecuted());
        if (filterCond instanceof ExprNodeConstantDesc) {
            ExprNodeConstantDesc c = (ExprNodeConstantDesc)filterCond;
            if (Boolean.TRUE.equals(c.getValue())) {
                return input;
            }
            if (ExprNodeDescUtils.isNullConstant(c)) {
                filterCond = new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, false);
            }
        }
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new FilterDesc(filterCond, false), new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Filter Plan for " + qb.getId() + " row schema: " + inputRR.toString());
        }
        return output;
    }

    private Operator genNotNullFilterForJoinSourcePlan(QB qb, Operator input, QBJoinTree joinTree, ExprNodeDesc[] joinKeys) throws SemanticException {
        if (qb == null || joinTree == null) {
            return input;
        }
        if (!joinTree.getNoOuterJoin()) {
            return input;
        }
        if (joinKeys == null || joinKeys.length == 0) {
            return input;
        }
        HashMap<Integer, ExprNodeDesc> hashes = new HashMap<Integer, ExprNodeDesc>();
        if (input instanceof FilterOperator) {
            ExprNodeDescUtils.getExprNodeColumnDesc(Arrays.asList(((FilterDesc)input.getConf()).getPredicate()), hashes);
        }
        ExprNodeGenericFuncDesc filterPred = null;
        ArrayList<Boolean> nullSafes = joinTree.getNullSafes();
        for (int i = 0; i < joinKeys.length; ++i) {
            if (((Boolean)nullSafes.get(i)).booleanValue() || joinKeys[i] instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)joinKeys[i]).getIsPartitionColOrVirtualCol() || null != hashes.get(joinKeys[i].hashCode())) continue;
            ArrayList<ExprNodeDesc> args = new ArrayList<ExprNodeDesc>();
            args.add(joinKeys[i]);
            ExprNodeGenericFuncDesc nextExpr = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("isnotnull").getGenericUDF(), args);
            filterPred = filterPred == null ? nextExpr : ExprNodeDescUtils.mergePredicates(filterPred, nextExpr);
        }
        if (filterPred == null) {
            return input;
        }
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        if (input instanceof FilterOperator) {
            FilterOperator f = (FilterOperator)input;
            ArrayList<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
            preds.add(((FilterDesc)f.getConf()).getPredicate());
            preds.add(filterPred);
            ((FilterDesc)f.getConf()).setPredicate(ExprNodeDescUtils.mergePredicates(preds));
            return input;
        }
        FilterDesc filterDesc = new FilterDesc(filterPred, false);
        filterDesc.setGenerated(true);
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Filter Plan for " + qb.getId() + " row schema: " + inputRR.toString());
        }
        return output;
    }

    Integer genColListRegex(String colRegex, String tabAlias, ASTNode sel, ArrayList<ExprNodeDesc> col_list, HashSet<ColumnInfo> excludeCols, RowResolver input, RowResolver colSrcRR, Integer pos, RowResolver output, List<String> aliases, boolean ensureUniqueCols) throws SemanticException {
        if (colSrcRR == null) {
            colSrcRR = input;
        }
        if (tabAlias != null && !colSrcRR.hasTableAlias(tabAlias)) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(sel));
        }
        Pattern regex = null;
        try {
            regex = Pattern.compile(colRegex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel, e.getMessage()));
        }
        StringBuilder replacementText = new StringBuilder();
        int matched = 0;
        if (!aliases.contains("")) {
            aliases.add("");
        }
        HashMap<ColumnInfo, ColumnInfo> inputColsProcessed = new HashMap<ColumnInfo, ColumnInfo>();
        if (colSrcRR.getNamedJoinInfo() != null) {
            LinkedHashMap<String, ColumnInfo> leftMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(0));
            LinkedHashMap<String, ColumnInfo> rightMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(1));
            LinkedHashMap<String, ColumnInfo> chosenMap = null;
            chosenMap = colSrcRR.getNamedJoinInfo().getHiveJoinType() != JoinType.RIGHTOUTER ? leftMap : rightMap;
            for (String columnName : colSrcRR.getNamedJoinInfo().getNamedColumns()) {
                for (Map.Entry entry : ((HashMap)chosenMap).entrySet()) {
                    ColumnInfo colInfo = (ColumnInfo)entry.getValue();
                    if (!columnName.equals(colInfo.getAlias())) continue;
                    String name = colInfo.getInternalName();
                    String[] tmp = colSrcRR.reverseLookup(name);
                    if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol()) continue;
                    ColumnInfo oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo);
                    if (oColInfo == null) {
                        ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
                        col_list.add(expr);
                        oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                        inputColsProcessed.put(colInfo, oColInfo);
                    }
                    if (ensureUniqueCols) {
                        if (!output.putWithCheck(tmp[0], tmp[1], null, oColInfo)) {
                            throw new CalciteSemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + oColInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                    } else {
                        output.put(tmp[0], tmp[1], oColInfo);
                    }
                    pos = pos + 1;
                    ++matched;
                    if (!this.unparseTranslator.isEnabled() && !this.tableMask.isEnabled()) continue;
                    if (replacementText.length() > 0) {
                        replacementText.append(", ");
                    }
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
                    replacementText.append(".");
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
                }
            }
        }
        for (String alias : aliases) {
            LinkedHashMap<String, ColumnInfo> fMap = colSrcRR.getFieldMap(alias);
            if (fMap == null) continue;
            for (Map.Entry entry : ((HashMap)fMap).entrySet()) {
                ColumnInfo oColInfo;
                ColumnInfo colInfo = (ColumnInfo)entry.getValue();
                if (colSrcRR.getNamedJoinInfo() != null && colSrcRR.getNamedJoinInfo().getNamedColumns().contains(colInfo.getAlias()) || excludeCols != null && excludeCols.contains(colInfo)) continue;
                String name = colInfo.getInternalName();
                String[] tmp = colSrcRR.reverseLookup(name);
                if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol() || !regex.matcher(tmp[1]).matches()) continue;
                if (input != colSrcRR) {
                    colInfo = input.get(tabAlias, tmp[1]);
                    if (colInfo == null) {
                        this.LOG.error("Cannot find colInfo for " + tabAlias + "." + tmp[1] + ", derived from [" + colSrcRR + "], in [" + input + "]");
                        throw new SemanticException(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY, tmp[1]);
                    }
                    String oldCol = null;
                    if (this.LOG.isDebugEnabled()) {
                        oldCol = name + " => " + (tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                    }
                    name = colInfo.getInternalName();
                    tmp = input.reverseLookup(name);
                    if (this.LOG.isDebugEnabled()) {
                        String newCol = name + " => " + (tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                        this.LOG.debug("Translated [" + oldCol + "] to [" + newCol + "]");
                    }
                }
                if ((oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo)) == null) {
                    ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
                    col_list.add(expr);
                    oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                    inputColsProcessed.put(colInfo, oColInfo);
                }
                if (ensureUniqueCols) {
                    if (!output.putWithCheck(tmp[0], tmp[1], null, oColInfo)) {
                        throw new CalciteSemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + oColInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                } else {
                    output.put(tmp[0], tmp[1], oColInfo);
                }
                pos = pos + 1;
                ++matched;
                if (!this.unparseTranslator.isEnabled() && !this.tableMask.isEnabled()) continue;
                if (replacementText.length() > 0) {
                    replacementText.append(", ");
                }
                replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
                replacementText.append(".");
                replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
            }
        }
        if (matched == 0) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel));
        }
        if (this.unparseTranslator.isEnabled()) {
            this.unparseTranslator.addTranslation(sel, replacementText.toString());
        } else if (this.tableMask.isEnabled()) {
            this.tableMask.addTranslation(sel, replacementText.toString());
        }
        return pos;
    }

    public static String getColumnInternalName(int pos) {
        return HiveConf.getColumnInternalName(pos);
    }

    private String getScriptProgName(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? cmd : cmd.substring(0, end);
    }

    private String getScriptArgs(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? "" : cmd.substring(end, cmd.length());
    }

    static int getPositionFromInternalName(String internalName) {
        return HiveConf.getPositionFromInternalName(internalName);
    }

    private String fetchFilesNotInLocalFilesystem(String cmd) {
        SessionState ss = SessionState.get();
        String progName = this.getScriptProgName(cmd);
        if (!ResourceDownloader.isFileUri(progName)) {
            String filePath = ss.add_resource(SessionState.ResourceType.FILE, progName, true);
            Path p = new Path(filePath);
            String fileName = p.getName();
            String scriptArgs = this.getScriptArgs(cmd);
            String finalCmd = fileName + scriptArgs;
            return finalCmd;
        }
        return cmd;
    }

    private TableDesc getTableDescFromSerDe(ASTNode child, String cols, String colTypes, boolean defaultCols) throws SemanticException {
        if (child.getType() == 903) {
            String serdeName = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
            Class<?> serdeClass = null;
            try {
                serdeClass = Class.forName(serdeName, true, Utilities.getSessionSpecifiedClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(e);
            }
            TableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, Integer.toString(9), cols, colTypes, defaultCols);
            if (child.getChildCount() == 2) {
                ASTNode prop = (ASTNode)((ASTNode)child.getChild(1)).getChild(0);
                for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
                    String key = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
                    String value = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
                    tblDesc.getProperties().setProperty(key, value);
                }
            }
            return tblDesc;
        }
        if (child.getType() == 904) {
            TableDesc tblDesc = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, defaultCols);
            int numChildRowFormat = child.getChildCount();
            block10: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 966: {
                        String fieldDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("field.delim", fieldDelim);
                        tblDesc.getProperties().setProperty("serialization.format", fieldDelim);
                        if (rowChild.getChildCount() < 2) continue block10;
                        String fieldEscape = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        tblDesc.getProperties().setProperty("escape.delim", fieldEscape);
                        continue block10;
                    }
                    case 965: {
                        tblDesc.getProperties().setProperty("colelction.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block10;
                    }
                    case 968: {
                        tblDesc.getProperties().setProperty("mapkey.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block10;
                    }
                    case 967: {
                        String lineDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("line.delim", lineDelim);
                        if (lineDelim.equals("\n") || lineDelim.equals("10")) continue block10;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    case 969: {
                        String nullFormat = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("serialization.null.format", nullFormat);
                        continue block10;
                    }
                    default: {
                        assert (false);
                        continue block10;
                    }
                }
            }
            return tblDesc;
        }
        return null;
    }

    private void failIfColAliasExists(Set<String> nameSet, String name) throws SemanticException {
        if (nameSet.contains(name)) {
            throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(name));
        }
        nameSet.add(name);
    }

    private Operator genScriptPlan(ASTNode trfm, QB qb, Operator input) throws SemanticException {
        Class<?> serde;
        int i;
        ArrayList<ColumnInfo> outputCols = new ArrayList<ColumnInfo>();
        int inputSerDeNum = 1;
        int inputRecordWriterNum = 2;
        int outputSerDeNum = 4;
        int outputRecordReaderNum = 5;
        int outputColsNum = 6;
        boolean outputColNames = false;
        boolean outputColSchemas = false;
        int execPos = 3;
        boolean defaultOutputCols = false;
        if (trfm.getChildCount() > outputColsNum) {
            ASTNode outCols = (ASTNode)trfm.getChild(outputColsNum);
            if (outCols.getType() == 650) {
                outputColNames = true;
            } else if (outCols.getType() == 951) {
                outputColSchemas = true;
            }
        }
        if (!outputColNames && !outputColSchemas) {
            String intName = SemanticAnalyzer.getColumnInternalName(0);
            ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("key");
            outputCols.add(colInfo);
            intName = SemanticAnalyzer.getColumnInternalName(1);
            colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("value");
            outputCols.add(colInfo);
            defaultOutputCols = true;
        } else {
            ASTNode collist = (ASTNode)trfm.getChild(outputColsNum);
            int ccount = collist.getChildCount();
            HashSet<String> colAliasNamesDuplicateCheck = new HashSet<String>();
            if (outputColNames) {
                for (i = 0; i < ccount; ++i) {
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)collist.getChild(i)).getText()).toLowerCase();
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            } else {
                for (i = 0; i < ccount; ++i) {
                    ASTNode child = (ASTNode)collist.getChild(i);
                    assert (child.getType() == 950);
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)child.getChild(0)).getText()).toLowerCase();
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoUtils.getTypeInfoFromTypeString(SemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1))), null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            }
        }
        RowResolver out_rwsch = new RowResolver();
        StringBuilder columns = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (i = 0; i < outputCols.size(); ++i) {
            if (i != 0) {
                columns.append(",");
                columnTypes.append(",");
            }
            columns.append(((ColumnInfo)outputCols.get(i)).getInternalName());
            columnTypes.append(((ColumnInfo)outputCols.get(i)).getType().getTypeName());
            out_rwsch.put(qb.getParseInfo().getAlias(), ((ColumnInfo)outputCols.get(i)).getAlias(), (ColumnInfo)outputCols.get(i));
        }
        StringBuilder inpColumns = new StringBuilder();
        StringBuilder inpColumnTypes = new StringBuilder();
        ArrayList<ColumnInfo> inputSchema = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        for (int i2 = 0; i2 < inputSchema.size(); ++i2) {
            if (i2 != 0) {
                inpColumns.append(",");
                inpColumnTypes.append(",");
            }
            inpColumns.append(inputSchema.get(i2).getInternalName());
            inpColumnTypes.append(inputSchema.get(i2).getType().getTypeName());
        }
        String defaultSerdeName = this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTSERDE);
        try {
            serde = Class.forName(defaultSerdeName, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
        int fieldSeparator = 9;
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESCRIPTESCAPE)) {
            fieldSeparator = 1;
        }
        TableDesc inInfo = trfm.getChild(inputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(inputSerDeNum)).getChild(0), inpColumns.toString(), inpColumnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(fieldSeparator), inpColumns.toString(), inpColumnTypes.toString(), false, true);
        TableDesc outInfo = trfm.getChild(outputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(outputSerDeNum)).getChild(0), columns.toString(), columnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(fieldSeparator), columns.toString(), columnTypes.toString(), defaultOutputCols);
        TableDesc errInfo = PlanUtils.getTableDesc(serde, Integer.toString(9), "KEY");
        Class<? extends RecordReader> outRecordReader = this.getRecordReader((ASTNode)trfm.getChild(outputRecordReaderNum));
        Class<? extends RecordWriter> inRecordWriter = this.getRecordWriter((ASTNode)trfm.getChild(inputRecordWriterNum));
        Class<? extends RecordReader> errRecordReader = this.getDefaultRecordReader();
        Operator<ScriptDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ScriptDesc(this.fetchFilesNotInLocalFilesystem(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText())), inInfo, inRecordWriter, outInfo, outRecordReader, errRecordReader, errInfo), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(new HashMap<String, ExprNodeDesc>());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY)) {
            String scriptCmd = this.getScriptProgName(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText()));
            this.getInputs().add(new ReadEntity(new Path(scriptCmd), ResourceDownloader.isFileUri(scriptCmd)));
        }
        return output;
    }

    private Class<? extends RecordReader> getRecordReader(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDREADER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private Class<? extends RecordReader> getDefaultRecordReader() throws SemanticException {
        String name = this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDREADER);
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private Class<? extends RecordWriter> getRecordWriter(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDWRITER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    protected List<Integer> getGroupingSetsForRollup(int size) {
        ArrayList<Integer> groupingSetKeys = new ArrayList<Integer>();
        for (int i = 0; i <= size; ++i) {
            groupingSetKeys.add((1 << i) - 1);
        }
        return groupingSetKeys;
    }

    protected List<Integer> getGroupingSetsForCube(int size) {
        int count = 1 << size;
        ArrayList<Integer> results = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            results.add(i);
        }
        return results;
    }

    private ObjectPair<List<ASTNode>, List<Integer>> getGroupByGroupingSetsForClause(QBParseInfo parseInfo, String dest) throws SemanticException {
        List<Object> groupingSets = new ArrayList();
        List<ASTNode> groupByExprs = this.getGroupByForClause(parseInfo, dest);
        if (parseInfo.getDestRollups().contains(dest)) {
            groupingSets = this.getGroupingSetsForRollup(groupByExprs.size());
        } else if (parseInfo.getDestCubes().contains(dest)) {
            groupingSets = this.getGroupingSetsForCube(groupByExprs.size());
        } else if (parseInfo.getDestGroupingSets().contains(dest)) {
            groupingSets = this.getGroupingSets(groupByExprs, parseInfo, dest);
        }
        return new ObjectPair<List<ASTNode>, List<Integer>>(groupByExprs, groupingSets);
    }

    protected List<Integer> getGroupingSets(List<ASTNode> groupByExpr, QBParseInfo parseInfo, String dest) throws SemanticException {
        HashMap<String, Integer> exprPos = new HashMap<String, Integer>();
        for (int i = 0; i < groupByExpr.size(); ++i) {
            ASTNode node = groupByExpr.get(i);
            exprPos.put(node.toStringTree(), i);
        }
        ASTNode root = parseInfo.getGroupByForClause(dest);
        ArrayList<Integer> result = new ArrayList<Integer>(root == null ? 0 : root.getChildCount());
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                ASTNode child = (ASTNode)root.getChild(i);
                if (child.getType() != 774) continue;
                int bitmap = IntMath.pow(2, groupByExpr.size()) - 1;
                for (int j = 0; j < child.getChildCount(); ++j) {
                    String treeAsString = child.getChild(j).toStringTree();
                    Integer pos = (Integer)exprPos.get(treeAsString);
                    if (pos == null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(j), ErrorMsg.HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY.getErrorCodedMsg()));
                    }
                    bitmap = SemanticAnalyzer.unsetBit(bitmap, groupByExpr.size() - pos - 1);
                }
                result.add(bitmap);
            }
        }
        if (this.checkForEmptyGroupingSets(result, IntMath.pow(2, groupByExpr.size()) - 1)) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_EMPTY.getMsg());
        }
        return result;
    }

    private boolean checkForEmptyGroupingSets(List<Integer> bitmaps, int groupingIdAllSet) {
        boolean ret = true;
        for (int mask : bitmaps) {
            ret &= mask == groupingIdAllSet;
        }
        return ret;
    }

    public static int setBit(int bitmap, int bitIdx) {
        return bitmap | 1 << bitIdx;
    }

    public static int unsetBit(int bitmap, int bitIdx) {
        return bitmap & ~(1 << bitIdx);
    }

    List<ASTNode> getGroupByForClause(QBParseInfo parseInfo, String dest) throws SemanticException {
        if (parseInfo.getSelForClause(dest).getToken().getType() == 900) {
            ASTNode selectExprs = parseInfo.getSelForClause(dest);
            ArrayList<ASTNode> result = new ArrayList<ASTNode>(selectExprs == null ? 0 : selectExprs.getChildCount());
            if (selectExprs != null) {
                for (int i = 0; i < selectExprs.getChildCount(); ++i) {
                    if (((ASTNode)selectExprs.getChild(i)).getToken().getType() == 343) continue;
                    ASTNode grpbyExpr = (ASTNode)selectExprs.getChild(i).getChild(0);
                    result.add(grpbyExpr);
                }
            }
            return result;
        }
        ASTNode grpByExprs = parseInfo.getGroupByForClause(dest);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(grpByExprs == null ? 0 : grpByExprs.getChildCount());
        if (grpByExprs != null) {
            for (int i = 0; i < grpByExprs.getChildCount(); ++i) {
                ASTNode grpbyExpr = (ASTNode)grpByExprs.getChild(i);
                if (grpbyExpr.getType() == 774) continue;
                result.add(grpbyExpr);
            }
        }
        return result;
    }

    static String[] getColAlias(ASTNode selExpr, String defaultName, RowResolver inputRR, boolean includeFuncName, int colNum) {
        String colAlias = null;
        String tabAlias = null;
        String[] colRef = new String[2];
        if (selExpr.getChildCount() == 2 || selExpr.getChildCount() == 3 && selExpr.getChild(2).getType() == 1016) {
            colAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        ASTNode root = (ASTNode)selExpr.getChild(0);
        if (root.getType() == 973) {
            colAlias = BaseSemanticAnalyzer.unescapeIdentifier(root.getChild(0).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        if (root.getType() == 16) {
            ASTNode col;
            String t;
            ASTNode tab = (ASTNode)root.getChild(0);
            if (tab.getType() == 973 && inputRR.hasTableAlias(t = SemanticAnalyzer.unescapeIdentifier(tab.getChild(0).getText()))) {
                tabAlias = t;
            }
            if ((col = (ASTNode)root.getChild(1)).getType() == 24) {
                colAlias = SemanticAnalyzer.unescapeIdentifier(col.getText().toLowerCase());
            }
        }
        if (includeFuncName && root.getType() == 763) {
            String expr_flattened = root.toStringTree();
            String expr_no_tok = expr_flattened.replaceAll("tok_\\S+", "");
            String expr_formatted = expr_no_tok.replaceAll("\\W", " ").trim().replaceAll("\\s+", "_");
            if (expr_formatted.length() > 20) {
                expr_formatted = expr_formatted.substring(0, 20);
            }
            colAlias = expr_formatted.concat("_" + colNum);
        }
        if (colAlias == null) {
            colAlias = defaultName + colNum;
        }
        colRef[0] = tabAlias;
        colRef[1] = colAlias;
        return colRef;
    }

    static boolean isRegex(String pattern, HiveConf conf) {
        String qIdSupport = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        if ("column".equals(qIdSupport)) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.isLetterOrDigit(pattern.charAt(i)) || pattern.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }

    private Operator<?> genSelectPlan(String dest, QB qb, Operator<?> input, Operator<?> inputForSelectStar) throws SemanticException {
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        Operator<?> op = this.genSelectPlan(dest, selExprList, qb, input, inputForSelectStar, false);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Select Plan for clause: " + dest);
        }
        return op;
    }

    private Operator<?> genSelectPlan(String dest, ASTNode selExprList, QB qb, Operator<?> input, Operator<?> inputForSelectStar, boolean outerLV) throws SemanticException {
        int startPosn;
        boolean isInTransform;
        boolean hintPresent;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("tree: " + selExprList.toStringTree());
        }
        ArrayList<ExprNodeDesc> col_list = new ArrayList<ExprNodeDesc>();
        RowResolver out_rwsch = new RowResolver();
        ASTNode trfm = null;
        Integer pos = 0;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        RowResolver starRR = null;
        if (inputForSelectStar != null && inputForSelectStar != input) {
            starRR = this.opParseCtx.get(inputForSelectStar).getRowResolver();
        }
        boolean selectStar = false;
        int posn = 0;
        boolean bl = hintPresent = selExprList.getChild(0).getType() == 343;
        if (hintPresent) {
            ++posn;
        }
        boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 988;
        if (isInTransform) {
            this.queryProperties.setUsesScript(true);
            this.globalLimitCtx.setHasTransformOrUDTF(true);
            trfm = (ASTNode)selExprList.getChild(posn).getChild(0);
        }
        boolean isUDTF = false;
        String udtfTableAlias = null;
        ArrayList<String> udtfColAliases = new ArrayList<String>();
        ASTNode udtfExpr = (ASTNode)selExprList.getChild(posn).getChild(0);
        GenericUDTF genericUDTF = null;
        int udtfExprType = udtfExpr.getType();
        if (udtfExprType == 763 || udtfExprType == 765) {
            String funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(udtfExpr, true);
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcName);
            if (fi != null) {
                genericUDTF = fi.getGenericUDTF();
            }
            boolean bl3 = isUDTF = genericUDTF != null;
            if (isUDTF) {
                this.globalLimitCtx.setHasTransformOrUDTF(true);
            }
            if (isUDTF && !fi.isNative()) {
                this.unparseTranslator.addIdentifierTranslation((ASTNode)udtfExpr.getChild(0));
            }
            if (isUDTF && (selectStar = udtfExprType == 765)) {
                this.genColListRegex(".*", null, (ASTNode)udtfExpr.getChild(0), col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
            }
        }
        if (isUDTF) {
            if (selExprList.getChildCount() > 1) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
            }
            ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
            block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                switch (selExprChild.getType()) {
                    case 24: {
                        udtfColAliases.add(SemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                        this.unparseTranslator.addIdentifierTranslation(selExprChild);
                        continue block4;
                    }
                    case 949: {
                        assert (selExprChild.getChildCount() == 1);
                        udtfTableAlias = SemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                        qb.addAlias(udtfTableAlias);
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                        continue block4;
                    }
                    default: {
                        assert (false);
                        continue block4;
                    }
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("UDTF table alias is " + udtfTableAlias);
                this.LOG.debug("UDTF col aliases are " + udtfColAliases);
            }
        }
        ASTNode exprList = isInTransform ? (ASTNode)trfm.getChild(0) : (isUDTF ? udtfExpr : selExprList);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("genSelectPlan: input = " + inputRR + " starRr = " + starRR);
        }
        int n = startPosn = isUDTF ? posn + 1 : posn;
        if (isInTransform) {
            startPosn = 0;
        }
        boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
        HashSet<String> colAliases = new HashSet<String>();
        ASTNode[] exprs = new ASTNode[exprList.getChildCount()];
        String[][] aliases = new String[exprList.getChildCount()][];
        boolean[] hasAsClauses = new boolean[exprList.getChildCount()];
        int offset = 0;
        for (int i = startPosn; i < exprList.getChildCount(); ++i) {
            ExprNodeColumnDesc colExp;
            String[] altMapping;
            ExprNodeDesc exp;
            String recommended;
            ASTNode expr;
            String colAlias;
            String tabAlias;
            boolean isWindowSpec;
            ASTNode child = (ASTNode)exprList.getChild(i);
            boolean hasAsClause = !isInTransform && child.getChildCount() == 2;
            boolean bl4 = isWindowSpec = child.getChildCount() == 3 && child.getChild(2).getType() == 1016;
            if (!(isWindowSpec || isInTransform || isUDTF || child.getChildCount() <= 2)) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
            }
            if (isInTransform || isUDTF) {
                tabAlias = null;
                colAlias = this.autogenColAliasPrfxLbl + i;
                expr = child;
            } else {
                expr = (ASTNode)child.getChild(0);
                String[] colRef = SemanticAnalyzer.getColAlias(child, this.autogenColAliasPrfxLbl, inputRR, this.autogenColAliasPrfxIncludeFuncName, i + offset);
                tabAlias = colRef[0];
                colAlias = colRef[1];
                if (hasAsClause) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                }
            }
            exprs[i] = expr;
            aliases[i] = new String[]{tabAlias, colAlias};
            hasAsClauses[i] = hasAsClause;
            colAliases.add(colAlias);
            if (expr.getType() == 651) {
                int initPos = pos;
                pos = this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                if (this.unparseTranslator.isEnabled()) {
                    offset += pos - initPos - 1;
                }
                selectStar = true;
                continue;
            }
            if (expr.getType() == 973 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), this.conf)) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                continue;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 973 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), this.conf)) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                continue;
            }
            TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, true, this.isCBOExecuted());
            tcCtx.setAllowStatefulFunctions(true);
            tcCtx.setAllowDistinctFunctions(false);
            if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
                expr = SemanticAnalyzer.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), dest), expr, !cubeRollupGrpSetPresent);
            }
            if ((recommended = this.recommendName(exp = this.genExprNodeDesc(expr, inputRR, tcCtx), colAlias)) != null && !colAliases.contains(recommended) && out_rwsch.get(null, recommended) == null) {
                colAlias = recommended;
            }
            col_list.add(exp);
            ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
            colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)exp).isSkewedCol() : false);
            out_rwsch.put(tabAlias, colAlias, colInfo);
            if (exp instanceof ExprNodeColumnDesc && (altMapping = inputRR.getAlternateMappings((colExp = (ExprNodeColumnDesc)exp).getColumn())) != null) {
                out_rwsch.put(altMapping[0], altMapping[1], colInfo);
            }
            pos = pos + 1;
        }
        selectStar = selectStar && exprList.getChildCount() == posn + 1;
        out_rwsch = this.handleInsertStatementSpec(col_list, dest, out_rwsch, inputRR, qb, selExprList);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < col_list.size(); ++i) {
            String outputCol = SemanticAnalyzer.getColumnInternalName(i);
            colExprMap.put(outputCol, col_list.get(i));
            columnNames.add(outputCol);
        }
        Operator output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(col_list, columnNames, selectStar), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(colExprMap);
        if (isInTransform) {
            output = this.genScriptPlan(trfm, qb, output);
        }
        if (isUDTF) {
            output = this.genUDTFPlan(genericUDTF, udtfTableAlias, udtfColAliases, qb, output, outerLV);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Select Plan row schema: " + out_rwsch.toString());
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public RowResolver handleInsertStatementSpec(List<ExprNodeDesc> col_list, String dest, RowResolver outputRR, RowResolver inputRR, QB qb, ASTNode selExprList) throws SemanticException {
        void var19_26;
        Partition partition;
        List<String> targetTableSchema = qb.getParseInfo().getDestSchemaForClause(dest);
        if (targetTableSchema == null) {
            return outputRR;
        }
        if (targetTableSchema.size() != col_list.size()) {
            Table target = qb.getMetaData().getDestTableForAlias(dest);
            Partition partition2 = target == null ? qb.getMetaData().getDestPartitionForAlias(dest) : null;
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(selExprList, "Expected " + targetTableSchema.size() + " columns for " + dest + (target != null ? "/" + target.getCompleteName() : (partition2 != null ? "/" + partition2.getCompleteName() : "")) + "; select produces " + col_list.size() + " columns"));
        }
        HashMap<String, ExprNodeDesc> targetCol2Projection = new HashMap<String, ExprNodeDesc>();
        HashMap<String, ColumnInfo> targetCol2ColumnInfo = new HashMap<String, ColumnInfo>();
        int colListPos = 0;
        for (String targetCol : targetTableSchema) {
            targetCol2ColumnInfo.put(targetCol, outputRR.getColumnInfos().get(colListPos));
            targetCol2Projection.put(targetCol, col_list.get(colListPos++));
        }
        Table target = qb.getMetaData().getDestTableForAlias(dest);
        Partition partition2 = partition = target == null ? qb.getMetaData().getDestPartitionForAlias(dest) : null;
        if (target == null && partition == null) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(selExprList, "No table/partition found in QB metadata for dest='" + dest + "'"));
        }
        ArrayList<Object> new_col_list = new ArrayList<Object>();
        colListPos = 0;
        List<FieldSchema> targetTableCols = target != null ? target.getCols() : partition.getCols();
        ArrayList<String> targetTableColNames = new ArrayList<String>();
        ArrayList<TypeInfo> targetTableColTypes = new ArrayList<TypeInfo>();
        for (FieldSchema fieldSchema : targetTableCols) {
            targetTableColNames.add(fieldSchema.getName());
            targetTableColTypes.add(TypeInfoUtils.getTypeInfoFromTypeString(fieldSchema.getType()));
        }
        Map<String, String> partSpec = qb.getMetaData().getPartSpecForAlias(dest);
        if (partSpec != null) {
            for (Map.Entry<String, String> entry : partSpec.entrySet()) {
                if (entry.getValue() != null) continue;
                targetTableColNames.add(entry.getKey());
                targetTableColTypes.add(TypeInfoFactory.stringTypeInfo);
            }
        }
        RowResolver rowResolver = new RowResolver();
        boolean bl = false;
        while (var19_26 < targetTableColNames.size()) {
            String f = (String)targetTableColNames.get((int)var19_26);
            if (targetCol2Projection.containsKey(f)) {
                new_col_list.add(targetCol2Projection.get(f));
                ColumnInfo ci = (ColumnInfo)targetCol2ColumnInfo.get(f);
                ci.setInternalName(SemanticAnalyzer.getColumnInternalName(colListPos));
                rowResolver.put(ci.getTabAlias(), ci.getInternalName(), ci);
            } else {
                ExprNodeConstantDesc exp = new ExprNodeConstantDesc((TypeInfo)targetTableColTypes.get((int)var19_26), null);
                new_col_list.add(exp);
                String tableAlias = null;
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(colListPos), ((ExprNodeDesc)exp).getWritableObjectInspector(), tableAlias, false);
                rowResolver.put(colInfo.getTabAlias(), colInfo.getInternalName(), colInfo);
            }
            ++colListPos;
            ++var19_26;
        }
        col_list.clear();
        col_list.addAll(new_col_list);
        return rowResolver;
    }

    String recommendName(ExprNodeDesc exp, String colAlias) {
        if (!colAlias.startsWith(this.autogenColAliasPrfxLbl)) {
            return null;
        }
        String column = ExprNodeDescUtils.recommendInputName(exp);
        if (column != null && !column.startsWith(this.autogenColAliasPrfxLbl)) {
            return column;
        }
        return null;
    }

    String getAutogenColAliasPrfxLbl() {
        return this.autogenColAliasPrfxLbl;
    }

    boolean autogenColAliasPrfxIncludeFuncName() {
        return this.autogenColAliasPrfxIncludeFuncName;
    }

    static ArrayList<TypeInfo> getTypeInfo(ArrayList<ExprNodeDesc> exprs) {
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (ExprNodeDesc expr : exprs) {
            result.add(expr.getTypeInfo());
        }
        return result;
    }

    static ArrayList<ObjectInspector> getWritableObjectInspector(ArrayList<ExprNodeDesc> exprs) {
        ArrayList<ObjectInspector> result = new ArrayList<ObjectInspector>();
        for (ExprNodeDesc expr : exprs) {
            result.add(expr.getWritableObjectInspector());
        }
        return result;
    }

    static ObjectInspector[] getStandardObjectInspector(ArrayList<TypeInfo> exprs) {
        ObjectInspector[] result = new ObjectInspector[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            result[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(exprs.get(i));
        }
        return result;
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String aggName, ArrayList<ExprNodeDesc> aggParameters, ASTNode aggTree, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        ArrayList<ObjectInspector> originalParameterTypeInfos = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
        GenericUDAFEvaluator result = FunctionRegistry.getGenericUDAFEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
        if (null == result) {
            String reason = "Looking for UDAF Evaluator\"" + aggName + "\" with parameters " + originalParameterTypeInfos;
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION_SIGNATURE.getMsg((ASTNode)aggTree.getChild(0), reason));
        }
        return result;
    }

    public static GenericUDAFInfo getGenericUDAFInfo(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, ArrayList<ExprNodeDesc> aggParameters) throws SemanticException {
        GenericUDAFInfo r = new GenericUDAFInfo();
        r.genericUDAFEvaluator = evaluator;
        ObjectInspector returnOI = null;
        try {
            ArrayList<ObjectInspector> aggOIs = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
            ObjectInspector[] aggOIArray = new ObjectInspector[aggOIs.size()];
            for (int ii = 0; ii < aggOIs.size(); ++ii) {
                aggOIArray[ii] = aggOIs.get(ii);
            }
            returnOI = r.genericUDAFEvaluator.init(emode, aggOIArray);
            r.returnType = TypeInfoUtils.getTypeInfoFromObjectInspector(returnOI);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        r.convertedParameters = aggParameters;
        return r;
    }

    public static GenericUDAFEvaluator.Mode groupByDescModeToUDAFMode(GroupByDesc.Mode mode, boolean isDistinct) {
        switch (mode) {
            case COMPLETE: {
                return GenericUDAFEvaluator.Mode.COMPLETE;
            }
            case PARTIAL1: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case PARTIAL2: {
                return GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case PARTIALS: {
                return isDistinct ? GenericUDAFEvaluator.Mode.PARTIAL1 : GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case FINAL: {
                return GenericUDAFEvaluator.Mode.FINAL;
            }
            case HASH: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case MERGEPARTIAL: {
                return isDistinct ? GenericUDAFEvaluator.Mode.COMPLETE : GenericUDAFEvaluator.Mode.FINAL;
            }
        }
        throw new RuntimeException("internal error in groupByDescModeToUDAFMode");
    }

    public static ExprNodeDesc isConstantParameterInAggregationParameters(String internalName, List<ExprNodeDesc> reduceValues) {
        ExprNodeDesc reduceValue;
        int pos;
        String[] terms = internalName.split("\\.");
        if (terms.length != 2 || reduceValues == null) {
            return null;
        }
        if (Utilities.ReduceField.VALUE.toString().equals(terms[0]) && (pos = SemanticAnalyzer.getPositionFromInternalName(terms[1])) >= 0 && pos < reduceValues.size() && (reduceValue = reduceValues.get(pos)) != null && reduceValue.getWritableObjectInspector() instanceof ConstantObjectInspector) {
            return reduceValue;
        }
        return null;
    }

    private Operator genGroupByPlanGroupByOperator(QBParseInfo parseInfo, String dest, Operator input, ReduceSinkOperator rs, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(input).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), "", false));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo oColInfo = new ColumnInfo(field, exprInfo.getType(), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, input, groupByOutputRowResolver);
            colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        String lastKeyColName = null;
        ArrayList<String> inputKeyCols = ((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames();
        if (inputKeyCols.size() > 0) {
            lastKeyColName = (String)inputKeyCols.get(inputKeyCols.size() - 1);
        }
        ArrayList<ExprNodeDesc> reduceValues = ((ReduceSinkDesc)rs.getConf()).getValueCols();
        int numDistinctUDFs = 0;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 764;
            boolean isAllColumns = value.getType() == 765;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                if (isDistinct && lastKeyColName != null) {
                    paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                }
                ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                ExprNodeDesc reduceValue = SemanticAnalyzer.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                if (reduceValue != null) {
                    expr = reduceValue;
                }
                aggParameters.add(expr);
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, null, false, -1, numDistinctUDFs > 0), new RowSchema(groupByOutputRowResolver.getColumnInfos()), input, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void addGroupingSetKey(List<ExprNodeDesc> groupByKeys, RowResolver groupByInputRowResolver, RowResolver groupByOutputRowResolver, List<String> outputColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = groupByInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(TypeInfoFactory.intTypeInfo, groupingSetColumnName, null, false);
        groupByKeys.add(inputExpr);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, TypeInfoFactory.intTypeInfo, null, true));
        colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
    }

    private void processGroupingSetReduceSinkOperator(RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<ExprNodeDesc> reduceKeys, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = reduceSinkInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(TypeInfoFactory.intTypeInfo, groupingSetColumnName, null, false);
        reduceKeys.add(inputExpr);
        outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
        String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
        ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, true);
        reduceSinkOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), colInfo);
        colExprMap.put(colInfo.getInternalName(), inputExpr);
    }

    private Operator genGroupByPlanGroupByOperator1(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, List<Integer> groupingSets, boolean groupingSetsPresent, boolean groupingSetsNeedAdditionalMRJob) throws SemanticException {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        RowResolver groupByInputRowResolver = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo oColInfo = new ColumnInfo(field, exprInfo.getType(), "", false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, reduceSinkOperatorInfo, groupByOutputRowResolver);
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            if (!groupingSetsNeedAdditionalMRJob) {
                this.addGroupingSetKey(groupByKeys, groupByInputRowResolver, groupByOutputRowResolver, outputColumnNames, colExprMap);
            } else {
                this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
            }
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        String lastKeyColName = null;
        ArrayList<ExprNodeDesc> reduceValues = null;
        if (reduceSinkOperatorInfo.getConf() instanceof ReduceSinkDesc) {
            ArrayList<String> inputKeyCols = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getOutputKeyColumnNames();
            if (inputKeyCols.size() > 0) {
                lastKeyColName = (String)inputKeyCols.get(inputKeyCols.size() - 1);
            }
            reduceValues = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getValueCols();
        }
        int numDistinctUDFs = 0;
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            boolean isDistinct = value.getType() == 764;
            boolean bl = containsDistinctAggr = containsDistinctAggr || isDistinct;
            if (isDistinct) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                    if (paraExprInfo == null) {
                        throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                    }
                    String paraExpression = paraExprInfo.getInternalName();
                    assert (paraExpression != null);
                    if (isDistinct && lastKeyColName != null) {
                        paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                    }
                    ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                    ExprNodeDesc reduceValue = SemanticAnalyzer.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                    if (reduceValue != null) {
                        expr = reduceValue;
                    }
                    aggParameters.add(expr);
                }
            } else {
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(value);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = null;
            genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != GroupByDesc.Mode.FINAL && isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, groupByMemoryUsage, memoryThreshold, groupingSets, groupingSetsPresent && groupingSetsNeedAdditionalMRJob, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), reduceSinkOperatorInfo, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void createNewGroupingKey(List<ExprNodeDesc> groupByKeys, List<String> outputColumnNames, RowResolver groupByOutputRowResolver, Map<String, ExprNodeDesc> colExprMap) {
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc(0);
        groupByKeys.add(constant);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, TypeInfoFactory.intTypeInfo, null, true));
        colExprMap.put(field, constant);
    }

    private Operator genGroupByPlanMapGroupByOperator(QB qb, String dest, List<ASTNode> grpByExprs, Operator inputOperatorInfo, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, List<Integer> groupingSetKeys, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, groupByInputRowResolver);
            if (grpByExprNode instanceof ExprNodeColumnDesc && ExprNodeDescUtils.indexOf(grpByExprNode, groupByKeys) >= 0) {
                grpByExprs.remove(i--);
                continue;
            }
            groupByKeys.add(grpByExprNode);
            String string = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(string);
            groupByOutputRowResolver.putExpression(grpbyExpr, new ColumnInfo(string, grpByExprNode.getTypeInfo(), "", false));
            colExprMap.put(string, groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
        }
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> list = parseInfo.getDistinctFuncExprsForClause(dest);
            for (ASTNode aSTNode : list) {
                for (int i = 1; i < aSTNode.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)aSTNode.getChild(i);
                    if (groupByOutputRowResolver.getExpression(parameter) != null) continue;
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, groupByInputRowResolver);
                    groupByKeys.add(distExprNode);
                    String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
                    outputColumnNames.add(field);
                    groupByOutputRowResolver.putExpression(parameter, new ColumnInfo(field, distExprNode.getTypeInfo(), "", false));
                    colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
                }
            }
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = value.getType() == 764;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean isAllColumns = value.getType() == 765;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            if (groupByOutputRowResolver.getExpression(value) == null) {
                groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            }
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        float f = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float f2 = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, f, f2, groupingSetKeys, groupingSetsPresent, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private ReduceSinkOperator genGroupByPlanReduceSinkOperator(QB qb, String dest, Operator inputOperatorInfo, List<ASTNode> grpByExprs, int numPartitionFields, boolean changeNumPartitionFields, int numReducers, boolean mapAggrDone, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        int keyLength = reduceKeys.size();
        int numOfColsRmedFromkey = grpByExprs.size() - keyLength;
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver, reduceSinkOutputRowResolver, reduceKeys, outputKeyColumnNames, colExprMap);
            if (changeNumPartitionFields) {
                ++numPartitionFields;
            }
        }
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        if (!mapAggrDone) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
        } else {
            int inputField = reduceKeys.size() + numOfColsRmedFromkey;
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                TypeInfo type = reduceSinkInputRowResolver.getColumnInfos().get(inputField).getType();
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(type, SemanticAnalyzer.getColumnInternalName(inputField), "", false);
                reduceValues.add(exprDesc);
                ++inputField;
                String outputColName = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                outputValueColumnNames.add(outputColName);
                String internalName = Utilities.ReduceField.VALUE.toString() + "." + outputColName;
                reduceSinkOutputRowResolver.putExpression(entry.getValue(), new ColumnInfo(internalName, type, null, false));
                colExprMap.put(internalName, exprDesc);
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, groupingSetsPresent ? keyLength + 1 : keyLength, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, numPartitionFields, numReducers, AcidUtils.Operation.NOT_ACID), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private ArrayList<ExprNodeDesc> getReduceKeysForReduceSink(List<ASTNode> grpByExprs, String dest, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ExprNodeDesc inputExpr = this.genExprNodeDesc(grpbyExpr, reduceSinkInputRowResolver);
            ColumnInfo prev = reduceSinkOutputRowResolver.getExpression(grpbyExpr);
            if (prev != null && this.isDeterministic(inputExpr)) {
                colExprMap.put(prev.getInternalName(), inputExpr);
                continue;
            }
            reduceKeys.add(inputExpr);
            outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, false);
            reduceSinkOutputRowResolver.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        return reduceKeys;
    }

    private boolean isDeterministic(ExprNodeDesc expr) throws SemanticException {
        try {
            return ExprNodeEvaluatorFactory.get(expr).isDeterministic();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<List<Integer>> getDistinctColIndicesForReduceSink(QBParseInfo parseInfo, String dest, List<ExprNodeDesc> reduceKeys, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<List<Integer>> distinctColIndices = new ArrayList<List<Integer>>();
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> distFuncs = parseInfo.getDistinctFuncExprsForClause(dest);
            String colName = SemanticAnalyzer.getColumnInternalName(reduceKeys.size());
            outputKeyColumnNames.add(colName);
            for (int i = 0; i < distFuncs.size(); ++i) {
                ASTNode value = distFuncs.get(i);
                int numExprs = 0;
                ArrayList<Integer> distinctIndices = new ArrayList<Integer>();
                for (int j = 1; j < value.getChildCount(); ++j) {
                    int ri;
                    ASTNode parameter = (ASTNode)value.getChild(j);
                    ExprNodeDesc expr = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                    for (ri = 0; ri < reduceKeys.size() && !reduceKeys.get(ri).getExprString().equals(expr.getExprString()); ++ri) {
                    }
                    if (ri == reduceKeys.size()) {
                        String name = SemanticAnalyzer.getColumnInternalName(numExprs);
                        String field = Utilities.ReduceField.KEY.toString() + "." + colName + ":" + i + "." + name;
                        ColumnInfo colInfo = new ColumnInfo(field, expr.getTypeInfo(), null, false);
                        reduceSinkOutputRowResolver.putExpression(parameter, colInfo);
                        colExprMap.put(field, expr);
                        reduceKeys.add(expr);
                    }
                    distinctIndices.add(ri);
                    ++numExprs;
                }
                distinctColIndices.add(distinctIndices);
            }
        }
        return distinctColIndices;
    }

    private void getReduceValuesForReduceSinkNoMapAgg(QBParseInfo parseInfo, String dest, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputValueColumnNames, ArrayList<ExprNodeDesc> reduceValues, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)value.getChild(i);
                if (reduceSinkOutputRowResolver.getExpression(parameter) != null) continue;
                ExprNodeDesc exprDesc = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                reduceValues.add(exprDesc);
                outputValueColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), null, false));
                colExprMap.put(field, exprDesc);
            }
        }
    }

    private ReduceSinkOperator genCommonGroupByPlanReduceSinkOperator(QB qb, List<String> dests, Operator inputOperatorInfo) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String dest = dests.get(0);
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        ArrayList<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        int keyLength = reduceKeys.size();
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        for (String destination : dests) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, destination, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
            ASTNode whereClause = parseInfo.getWhrForClause(destination);
            if (whereClause == null) continue;
            assert (whereClause.getChildCount() == 1);
            ASTNode predicates = (ASTNode)whereClause.getChild(0);
            Map<ASTNode, ExprNodeDesc> nodeOutputs = this.genAllExprNodeDesc(predicates, reduceSinkInputRowResolver);
            this.removeMappingForKeys(predicates, nodeOutputs, reduceKeys);
            for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
                ASTNode parameter = entry.getKey();
                ExprNodeDesc expression = entry.getValue();
                if (!(expression instanceof ExprNodeColumnDesc) || ExprNodeDescUtils.indexOf(expression, reduceValues) >= 0) continue;
                String internalName = SemanticAnalyzer.getColumnInternalName(reduceValues.size());
                String field = Utilities.ReduceField.VALUE.toString() + "." + internalName;
                reduceValues.add(expression);
                outputValueColumnNames.add(internalName);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, expression.getTypeInfo(), null, false));
                colExprMap.put(field, expression);
            }
        }
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(reduceKeys, keyLength, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, keyLength, numReducers, AcidUtils.Operation.NOT_ACID);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private void removeMappingForKeys(ASTNode predicate, Map<ASTNode, ExprNodeDesc> mapping, List<ExprNodeDesc> keys) {
        ExprNodeDesc expr = mapping.get(predicate);
        if (expr != null && ExprNodeDescUtils.indexOf(expr, keys) >= 0) {
            this.removeRecursively(predicate, mapping);
        } else {
            for (int i = 0; i < predicate.getChildCount(); ++i) {
                this.removeMappingForKeys((ASTNode)predicate.getChild(i), mapping, keys);
            }
        }
    }

    private void removeRecursively(ASTNode current, Map<ASTNode, ExprNodeDesc> mapping) {
        mapping.remove(current);
        for (int i = 0; i < current.getChildCount(); ++i) {
            this.removeRecursively((ASTNode)current.getChild(i), mapping);
        }
    }

    private Operator genGroupByPlanReduceSinkOperator2MR(QBParseInfo parseInfo, String dest, Operator groupByOperatorInfo, int numPartitionFields, int numReducers, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver2 = this.opParseCtx.get(groupByOperatorInfo).getRowResolver();
        RowResolver reduceSinkOutputRowResolver2 = new RowResolver();
        reduceSinkOutputRowResolver2.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(grpbyExpr).getType();
            ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceKeys.add(exprNodeColumnDesc);
            ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + field, typeInfo, "", false);
            reduceSinkOutputRowResolver2.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), exprNodeColumnDesc);
        }
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver2, reduceSinkOutputRowResolver2, reduceKeys, outputColumnNames, colExprMap);
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        int inputField = reduceKeys.size();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            String field = SemanticAnalyzer.getColumnInternalName(inputField);
            ASTNode t = (ASTNode)entry.getValue();
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(t).getType();
            ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceValues.add(exprDesc);
            ++inputField;
            String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
            outputColumnNames.add(col);
            reduceSinkOutputRowResolver2.putExpression(t, new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, typeInfo, "", false));
            colExprMap.put(col, exprDesc);
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, numReducers, AcidUtils.Operation.NOT_ACID), new RowSchema(reduceSinkOutputRowResolver2.getColumnInfos()), groupByOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver2);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genGroupByPlanGroupByOperator2MR(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo2, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver2 = this.opParseCtx.get(reduceSinkOperatorInfo2).getRowResolver();
        RowResolver groupByOutputRowResolver2 = new RowResolver();
        groupByOutputRowResolver2.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver2.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            String expression = exprInfo.getInternalName();
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), expression, exprInfo.getTabAlias(), exprInfo.getIsVirtualCol()));
            String string = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(string);
            ColumnInfo oColInfo = new ColumnInfo(string, exprInfo.getType(), "", false);
            groupByOutputRowResolver2.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, reduceSinkOperatorInfo2, groupByOutputRowResolver2);
            colExprMap.put(string, groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            this.addGroupingSetKey(groupByKeys, groupByInputRowResolver2, groupByOutputRowResolver2, outputColumnNames, colExprMap);
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        boolean containsDistinctAggr = false;
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            ASTNode value = (ASTNode)entry.getValue();
            ColumnInfo paraExprInfo = groupByInputRowResolver2.getExpression(value);
            if (paraExprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
            }
            String paraExpression = paraExprInfo.getInternalName();
            assert (paraExpression != null);
            aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 764;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean isStar = value.getType() == 765;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != GroupByDesc.Mode.FINAL && value.getToken().getType() == 764, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float f = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, f, null, false, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver2.getColumnInfos()), reduceSinkOperatorInfo2, new Operator[0]), groupByOutputRowResolver2);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlan1MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        int numReducers = -1;
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, grpByExprs.size(), false, numReducers, false, false);
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
        return groupByOperatorInfo;
    }

    private Operator genGroupByPlan1ReduceMultiGBY(List<String> dests, QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        Operator forwardOp;
        QBParseInfo parseInfo = qb.getParseInfo();
        ExprNodeDesc previous = null;
        Operator<FilterDesc> selectInput = input;
        ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper> whereExpressions = new ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper>();
        for (String dest : dests) {
            ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
            List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
            if (!groupingSets.isEmpty()) {
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR_MULTIGBY.getMsg());
            }
            ASTNode whereExpr = parseInfo.getWhrForClause(dest);
            if (whereExpr != null) {
                OpParseContext inputCtx = this.opParseCtx.get(input);
                RowResolver inputRR = inputCtx.getRowResolver();
                ExprNodeDesc current = this.genExprNodeDesc((ASTNode)whereExpr.getChild(0), inputRR);
                ExprNodeDesc.ExprNodeDescEqualityWrapper currentWrapped = new ExprNodeDesc.ExprNodeDescEqualityWrapper(current);
                if (whereExpressions.contains(currentWrapped)) continue;
                whereExpressions.add(currentWrapped);
                if (previous == null) {
                    previous = current;
                    continue;
                }
                GenericUDFOPOr or = new GenericUDFOPOr();
                ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(2);
                expressions.add(current);
                expressions.add(previous);
                ExprNodeGenericFuncDesc orExpr = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)or, expressions);
                previous = orExpr;
                continue;
            }
            previous = null;
            break;
        }
        if (previous != null) {
            OpParseContext inputCtx = this.opParseCtx.get(input);
            RowResolver inputRR = inputCtx.getRowResolver();
            FilterDesc orFilterDesc = new FilterDesc(previous, false);
            orFilterDesc.setGenerated(true);
            selectInput = this.putOpInsertMap(OperatorFactory.getAndMakeChild(orFilterDesc, new RowSchema(inputRR.getColumnInfos()), (Operator)input, new Operator[0]), inputRR);
        }
        Operator select = this.genSelectAllDesc(selectInput);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genCommonGroupByPlanReduceSinkOperator(qb, dests, select);
        RowResolver reduceSinkOperatorInfoRR = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        Operator curr = forwardOp = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ForwardDesc(), new RowSchema(reduceSinkOperatorInfoRR.getColumnInfos()), (Operator)reduceSinkOperatorInfo, new Operator[0]), reduceSinkOperatorInfoRR);
        for (String dest : dests) {
            curr = forwardOp;
            if (parseInfo.getWhrForClause(dest) != null) {
                ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
                curr = this.genFilterPlan((ASTNode)whereExpr.getChild(0), qb, forwardOp, aliasToOpInfo, false, true);
            }
            Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, curr, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
            curr = this.genPostGroupByBodyPlan(groupByOperatorInfo, dest, qb, aliasToOpInfo, null);
        }
        return curr;
    }

    static ArrayList<GenericUDAFEvaluator> getUDAFEvaluators(ArrayList<AggregationDesc> aggs) {
        ArrayList<GenericUDAFEvaluator> result = new ArrayList<GenericUDAFEvaluator>();
        for (int i = 0; i < aggs.size(); ++i) {
            result.add(aggs.get(i).getGenericUDAFEvaluator());
        }
        return result;
    }

    private Operator genGroupByPlan2MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest).isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, false, false);
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIAL1, genericUDAFEvaluators);
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers, false);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, false);
        return groupByOperatorInfo2;
    }

    private boolean optimizeMapAggrGroupBy(String dest, QB qb) throws SemanticException {
        List<ASTNode> grpByExprs = this.getGroupByForClause(qb.getParseInfo(), dest);
        if (grpByExprs != null && !grpByExprs.isEmpty()) {
            return false;
        }
        return qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
    }

    private static void extractColumns(Set<String> colNamesExprs, ExprNodeDesc exprNode) throws SemanticException {
        if (exprNode instanceof ExprNodeColumnDesc) {
            colNamesExprs.add(((ExprNodeColumnDesc)exprNode).getColumn());
            return;
        }
        if (exprNode instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)exprNode;
            for (ExprNodeDesc childExpr : funcDesc.getChildren()) {
                SemanticAnalyzer.extractColumns(colNamesExprs, childExpr);
            }
        }
    }

    private static boolean hasCommonElement(Set<String> set1, Set<String> set2) {
        for (String elem1 : set1) {
            if (!set2.contains(elem1)) continue;
            return true;
        }
        return false;
    }

    void checkExpressionsForGroupingSet(List<ASTNode> grpByExprs, List<ASTNode> distinctGrpByExprs, Map<String, ASTNode> aggregationTrees, RowResolver inputRowResolver) throws SemanticException {
        HashSet<String> colNamesGroupByExprs = new HashSet<String>();
        HashSet<String> colNamesGroupByDistinctExprs = new HashSet<String>();
        HashSet<String> colNamesAggregateParameters = new HashSet<String>();
        for (ASTNode aSTNode : grpByExprs) {
            SemanticAnalyzer.extractColumns(colNamesGroupByExprs, this.genExprNodeDesc(aSTNode, inputRowResolver));
        }
        if (!distinctGrpByExprs.isEmpty()) {
            for (ASTNode aSTNode : distinctGrpByExprs) {
                for (int i = 1; i < aSTNode.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)aSTNode.getChild(i);
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, inputRowResolver);
                    SemanticAnalyzer.extractColumns(colNamesGroupByDistinctExprs, distExprNode);
                }
                if (!SemanticAnalyzer.hasCommonElement(colNamesGroupByExprs, colNamesGroupByDistinctExprs)) continue;
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
            }
        }
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            ASTNode value = (ASTNode)entry.getValue();
            ArrayList aggParameters = new ArrayList();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, inputRowResolver);
                SemanticAnalyzer.extractColumns(colNamesAggregateParameters, paraExprNode);
            }
            if (!SemanticAnalyzer.hasCommonElement(colNamesGroupByExprs, colNamesAggregateParameters)) continue;
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
        }
    }

    private Operator genGroupByPlanMapAggrNoSkew(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean isDistinct;
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        boolean groupingSetsPresent = !groupingSets.isEmpty();
        int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
        if (groupingSetsPresent) {
            this.checkExpressionsForGroupingSet(grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest), parseInfo.getAggregationExprsForClause(dest), this.opParseCtx.get(inputOperatorInfo).getRowResolver());
        }
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        boolean groupingSetsNeedAdditionalMRJob = groupingSetsPresent && groupingSets.size() > newMRJobGroupingSetsThreshold;
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, GroupByDesc.Mode.HASH, genericUDAFEvaluators, groupingSets, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        boolean bl = isDistinct = !qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
        if (groupingSetsNeedAdditionalMRJob && isDistinct) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS.getMsg(errorMsg));
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), true, numReducers, true, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        if (!groupingSetsPresent || !groupingSetsNeedAdditionalMRJob) {
            return this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.MERGEPARTIAL, genericUDAFEvaluators, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        }
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size() + 1, numReducers, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, groupingSetsPresent);
    }

    private Operator genGroupByPlanMapAggr2MR(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean groupingSetsPresent;
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        boolean bl = groupingSetsPresent = !groupingSets.isEmpty();
        if (groupingSetsPresent) {
            this.checkExpressionsForGroupingSet(grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest), parseInfo.getAggregationExprsForClause(dest), this.opParseCtx.get(inputOperatorInfo).getRowResolver());
            int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
            if (groupingSets.size() > newMRJobGroupingSetsThreshold) {
                String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
            }
        }
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, GroupByDesc.Mode.HASH, genericUDAFEvaluators, groupingSets, groupingSetsPresent);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        if (!this.optimizeMapAggrGroupBy(dest, qb)) {
            List<ASTNode> distinctFuncExprs = parseInfo.getDistinctFuncExprsForClause(dest);
            ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, distinctFuncExprs.isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, true, groupingSetsPresent);
            Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, groupingSets, groupingSetsPresent, false);
            int numReducers = -1;
            if (grpByExprs.isEmpty()) {
                numReducers = 1;
            }
            Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size(), numReducers, groupingSetsPresent);
            return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, groupingSetsPresent);
        }
        assert (!groupingSetsPresent);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), false, 1, true, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, false);
    }

    private int getReducersBucketing(int totalFiles, int maxReducers) {
        int numFiles = (int)Math.ceil((double)totalFiles / (double)maxReducers);
        while (totalFiles % numFiles != 0) {
            ++numFiles;
        }
        return totalFiles / numFiles;
    }

    private Operator genBucketingSortingDest(String dest, Operator input, QB qb, TableDesc table_desc, Table dest_tab, SortBucketRSCtx ctx) throws SemanticException {
        boolean enforceBucketing = false;
        ArrayList<ExprNodeDesc> partnCols = new ArrayList();
        ArrayList<ExprNodeDesc> sortCols = new ArrayList();
        ArrayList<Object> sortOrders = new ArrayList();
        ArrayList nullSortOrders = new ArrayList();
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;
        if (dest_tab.getNumBuckets() > 0) {
            enforceBucketing = true;
            partnCols = this.updating(dest) || this.deleting(dest) ? this.getPartitionColsFromBucketColsForUpdateDelete(input, true) : this.getPartitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, true);
        }
        if (dest_tab.getSortCols() != null && dest_tab.getSortCols().size() > 0) {
            sortCols = this.getSortCols(dest, qb, dest_tab, table_desc, input, true);
            sortOrders = this.getSortOrders(dest, qb, dest_tab, input);
            if (!enforceBucketing && !dest_tab.isIndexTable()) {
                throw new SemanticException(ErrorMsg.TBL_SORTED_NOT_BUCKETED.getErrorCodedMsg(dest_tab.getCompleteName()));
            }
            if (!enforceBucketing) {
                partnCols = sortCols;
            }
            enforceBucketing = true;
        }
        if (enforceBucketing) {
            int numBuckets;
            int maxReducers = this.conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
            if (this.conf.getIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS) > 0) {
                maxReducers = this.conf.getIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS);
            }
            if ((numBuckets = dest_tab.getNumBuckets()) > maxReducers) {
                this.LOG.debug("numBuckets is {}", new Object[]{numBuckets, " and maxReducers is {}", maxReducers});
                multiFileSpray = true;
                totalFiles = numBuckets;
                if (totalFiles % maxReducers == 0) {
                    numFiles = totalFiles / maxReducers;
                } else {
                    maxReducers = this.getReducersBucketing(totalFiles, maxReducers);
                    numFiles = totalFiles / maxReducers;
                }
            } else {
                maxReducers = numBuckets;
            }
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            Iterator<Object> iterator = sortOrders.iterator();
            while (iterator.hasNext()) {
                int sortOrder = (Integer)iterator.next();
                order.append(sortOrder == 1 ? (char)'+' : '-');
                nullOrder.append(sortOrder == 1 ? (char)'a' : 'z');
            }
            input = this.genReduceSinkPlan(input, partnCols, sortCols, order.toString(), nullOrder.toString(), maxReducers, AcidUtils.isAcidTable(dest_tab) ? this.getAcidType(dest) : AcidUtils.Operation.NOT_ACID);
            this.reduceSinkOperatorsAddedByEnforceBucketingSorting.add((ReduceSinkOperator)input.getParentOperators().get(0));
            ctx.setMultiFileSpray(multiFileSpray);
            ctx.setNumFiles(numFiles);
            ctx.setTotalFiles(totalFiles);
        }
        return input;
    }

    private void genPartnCols(String dest, Operator input, QB qb, TableDesc table_desc, Table dest_tab, SortBucketRSCtx ctx) throws SemanticException {
        boolean enforceBucketing = false;
        ArrayList<ExprNodeDesc> partnColsNoConvert = new ArrayList<ExprNodeDesc>();
        if (dest_tab.getNumBuckets() > 0) {
            enforceBucketing = true;
            partnColsNoConvert = this.updating(dest) || this.deleting(dest) ? this.getPartitionColsFromBucketColsForUpdateDelete(input, false) : this.getPartitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, false);
        }
        if (dest_tab.getSortCols() != null && dest_tab.getSortCols().size() > 0) {
            if (!enforceBucketing && !dest_tab.isIndexTable()) {
                throw new SemanticException(ErrorMsg.TBL_SORTED_NOT_BUCKETED.getErrorCodedMsg(dest_tab.getCompleteName()));
            }
            if (!enforceBucketing) {
                partnColsNoConvert = this.getSortCols(dest, qb, dest_tab, table_desc, input, false);
            }
            enforceBucketing = true;
        }
        if (enforceBucketing) {
            ctx.setPartnCols(partnColsNoConvert);
        }
    }

    private void setStatsForNonNativeTable(Table tab) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getDotName(new String[]{tab.getDbName(), tab.getTableName()});
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.DROPPROPS, null, false);
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put("COLUMN_STATS_ACCURATE", null);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setDropIfExists(true);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    protected Operator genFileSinkPlan(String dest, QB qb, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        QBMetaData qbm = qb.getMetaData();
        Integer dest_type = qbm.getDestTypeForAlias(dest);
        Table dest_tab = null;
        boolean destTableIsAcid = false;
        boolean destTableIsTemporary = false;
        boolean destTableIsMaterialization = false;
        Partition dest_part = null;
        Path queryTmpdir = null;
        Path dest_path = null;
        TableDesc table_desc = null;
        int currentTableId = 0;
        boolean isLocal = false;
        SortBucketRSCtx rsCtx = new SortBucketRSCtx();
        DynamicPartitionCtx dpCtx = null;
        LoadTableDesc ltd = null;
        ListBucketingCtx lbCtx = null;
        Map<String, String> partSpec = null;
        switch (dest_type) {
            case 1: {
                boolean isNonNativeTable;
                List<FieldSchema> parts;
                dest_tab = qbm.getDestTableForAlias(dest);
                destTableIsAcid = AcidUtils.isAcidTable(dest_tab);
                destTableIsTemporary = dest_tab.isTemporary();
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INSERT_INTO_EXTERNAL_TABLES) && dest_tab.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
                    throw new SemanticException(ErrorMsg.INSERT_EXTERNAL_TABLE.getMsg(dest_tab.getTableName()));
                }
                partSpec = qbm.getPartSpecForAlias(dest);
                dest_path = dest_tab.getPath();
                if (dest_tab.isImmutable() && qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName())) {
                    try {
                        FileSystem fs = dest_path.getFileSystem((Configuration)this.conf);
                        if (!MetaStoreUtils.isDirEmpty(fs, dest_path)) {
                            this.LOG.warn("Attempted write into an immutable table : " + dest_tab.getTableName() + " : " + dest_path);
                            throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(dest_tab.getTableName()));
                        }
                    }
                    catch (IOException ioe) {
                        this.LOG.warn("Error while trying to determine if immutable table has any data : " + dest_tab.getTableName() + " : " + dest_path);
                        throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(ioe.getMessage()));
                    }
                }
                if ((parts = dest_tab.getPartitionKeys()) != null && parts.size() > 0) {
                    if (partSpec == null || partSpec.size() == 0) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.NEED_PARTITION_ERROR.getMsg()));
                    }
                    dpCtx = qbm.getDPCtx(dest);
                    if (dpCtx == null) {
                        dest_tab.validatePartColumnNames(partSpec, false);
                        dpCtx = new DynamicPartitionCtx(dest_tab, partSpec, this.conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME), this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTSPERNODE));
                        qbm.setDPCtx(dest, dpCtx);
                    }
                    if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg()));
                    }
                    if (dpCtx.getSPPath() != null) {
                        dest_path = new Path(dest_tab.getPath(), dpCtx.getSPPath());
                    }
                    if (dest_tab.getNumBuckets() > 0) {
                        dpCtx.setNumBuckets(dest_tab.getNumBuckets());
                    }
                }
                queryTmpdir = (isNonNativeTable = dest_tab.isNonNative()) ? dest_path : this.ctx.getTempDirForPath(dest_path, true);
                if (dpCtx != null) {
                    dpCtx.setRootPath(queryTmpdir);
                }
                table_desc = Utilities.getTableDesc(dest_tab);
                input = this.genBucketingSortingDest(dest, input, qb, table_desc, dest_tab, rsCtx);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getTableName());
                currentTableId = this.destTableId++;
                lbCtx = this.constructListBucketingCtx(dest_tab.getSkewedColNames(), dest_tab.getSkewedColValues(), dest_tab.getSkewedColValueLocationMaps(), dest_tab.isStoredAsSubDirectories(), this.conf);
                if (!isNonNativeTable) {
                    AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
                    if (destTableIsAcid) {
                        acidOp = this.getAcidType(table_desc.getOutputFileFormatClass(), dest);
                        this.checkAcidConstraints(qb, table_desc, dest_tab);
                    }
                    ltd = new LoadTableDesc(queryTmpdir, table_desc, dpCtx, acidOp);
                    ltd.setReplace(!qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
                    ltd.setLbCtx(lbCtx);
                    this.loadTableWork.add(ltd);
                } else {
                    this.setStatsForNonNativeTable(dest_tab);
                    boolean overwrite = !qb.getParseInfo().isInsertIntoTable(String.format("%s.%s", dest_tab.getDbName(), dest_tab.getTableName()));
                    this.createInsertDesc(dest_tab, overwrite);
                }
                WriteEntity output = null;
                if (!(dpCtx != null && dpCtx.getNumDPCols() != 0 || this.outputs.add(output = new WriteEntity(dest_tab, this.determineWriteType(ltd, isNonNativeTable, dest))))) {
                    throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getTableName()));
                }
                if (dpCtx != null && dpCtx.getNumDPCols() >= 0) {
                    if (dpCtx.getNumSPCols() == 0) {
                        output = new WriteEntity(dest_tab, this.determineWriteType(ltd, isNonNativeTable, dest), false);
                        this.outputs.add(output);
                        output.setDynamicPartitionWrite(true);
                    } else {
                        try {
                            String ppath = dpCtx.getSPPath();
                            ppath = ppath.substring(0, ppath.length() - 1);
                            DummyPartition p = new DummyPartition(dest_tab, dest_tab.getDbName() + "@" + dest_tab.getTableName() + "@" + ppath, partSpec);
                            output = new WriteEntity(p, this.getWriteType(dest), false);
                            output.setDynamicPartitionWrite(true);
                            this.outputs.add(output);
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e.getMessage(), e);
                        }
                    }
                }
                this.ctx.getLoadTableOutputMap().put(ltd, output);
                break;
            }
            case 2: {
                dest_part = qbm.getDestPartitionForAlias(dest);
                dest_tab = dest_part.getTable();
                destTableIsAcid = AcidUtils.isAcidTable(dest_tab);
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INSERT_INTO_EXTERNAL_TABLES) && dest_tab.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
                    throw new SemanticException(ErrorMsg.INSERT_EXTERNAL_TABLE.getMsg(dest_tab.getTableName()));
                }
                Path tabPath = dest_tab.getPath();
                Path partPath = dest_part.getDataLocation();
                if (dest_tab.isImmutable() && qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName())) {
                    try {
                        FileSystem fs = partPath.getFileSystem((Configuration)this.conf);
                        if (!MetaStoreUtils.isDirEmpty(fs, partPath)) {
                            this.LOG.warn("Attempted write into an immutable table partition : " + dest_tab.getTableName() + " : " + partPath);
                            throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(dest_tab.getTableName()));
                        }
                    }
                    catch (IOException ioe) {
                        this.LOG.warn("Error while trying to determine if immutable table partition has any data : " + dest_tab.getTableName() + " : " + partPath);
                        throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(ioe.getMessage()));
                    }
                }
                dest_path = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                queryTmpdir = this.ctx.getTempDirForPath(dest_path, true);
                table_desc = Utilities.getTableDesc(dest_tab);
                input = this.genBucketingSortingDest(dest, input, qb, table_desc, dest_tab, rsCtx);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getTableName());
                currentTableId = this.destTableId++;
                lbCtx = this.constructListBucketingCtx(dest_part.getSkewedColNames(), dest_part.getSkewedColValues(), dest_part.getSkewedColValueLocationMaps(), dest_part.isStoredAsSubDirectories(), this.conf);
                AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
                if (destTableIsAcid) {
                    acidOp = this.getAcidType(table_desc.getOutputFileFormatClass(), dest);
                    this.checkAcidConstraints(qb, table_desc, dest_tab);
                }
                ltd = new LoadTableDesc(queryTmpdir, table_desc, dest_part.getSpec(), acidOp);
                ltd.setReplace(!qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
                ltd.setLbCtx(lbCtx);
                this.loadTableWork.add(ltd);
                if (this.outputs.add(new WriteEntity(dest_part, this.determineWriteType(ltd, dest_tab.isNonNative(), dest)))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getTableName() + "@" + dest_part.getName()));
            }
            case 5: {
                isLocal = true;
            }
            case 3: {
                dest_path = new Path(qbm.getDestFileForAlias(dest));
                if (isLocal) {
                    queryTmpdir = this.ctx.getMRTmpPath();
                } else {
                    try {
                        Path qPath = FileUtils.makeQualified(dest_path, this.conf);
                        queryTmpdir = this.ctx.getTempDirForPath(qPath, true);
                    }
                    catch (Exception e) {
                        throw new SemanticException("Error creating temporary folder on: " + dest_path, e);
                    }
                }
                String cols = "";
                String colTypes = "";
                ArrayList<ColumnInfo> colInfos = inputRR.getColumnInfos();
                ArrayList<FieldSchema> field_schemas = null;
                CreateTableDesc tblDesc = qb.getTableDesc();
                CreateViewDesc viewDesc = qb.getViewDesc();
                if (tblDesc != null) {
                    field_schemas = new ArrayList<FieldSchema>();
                    destTableIsTemporary = tblDesc.isTemporary();
                    destTableIsMaterialization = tblDesc.isMaterialization();
                } else if (viewDesc != null) {
                    field_schemas = new ArrayList();
                    destTableIsTemporary = false;
                }
                boolean first = true;
                for (ColumnInfo colInfo : colInfos) {
                    String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
                    if (nm[1] != null) {
                        colInfo.setAlias(nm[1]);
                    }
                    String colName = colInfo.getInternalName();
                    if (field_schemas != null) {
                        FieldSchema col = new FieldSchema();
                        if (!"".equals(nm[0]) && nm[1] != null) {
                            colName = SemanticAnalyzer.unescapeIdentifier(colInfo.getAlias()).toLowerCase();
                        }
                        colName = this.fixCtasColumnName(colName);
                        col.setName(colName);
                        String typeName = colInfo.getType().getTypeName();
                        if (typeName.equals("void")) {
                            throw new SemanticException(ErrorMsg.CTAS_CREATES_VOID_TYPE.getMsg(colName));
                        }
                        col.setType(typeName);
                        field_schemas.add(col);
                    }
                    if (!first) {
                        cols = cols.concat(",");
                        colTypes = colTypes.concat(":");
                    }
                    first = false;
                    cols = cols.concat(colName);
                    String tName = colInfo.getType().getTypeName();
                    if (tName.equals("void")) {
                        colTypes = colTypes.concat("string");
                        continue;
                    }
                    colTypes = colTypes.concat(tName);
                }
                if (tblDesc != null) {
                    tblDesc.setCols(new ArrayList<FieldSchema>(field_schemas));
                } else if (viewDesc != null) {
                    viewDesc.setSchema(new ArrayList<FieldSchema>(field_schemas));
                }
                boolean isDestTempFile = true;
                if (!this.ctx.isMRTmpFileURI(dest_path.toUri().toString())) {
                    this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_path.toUri().toString());
                    currentTableId = this.destTableId++;
                    isDestTempFile = false;
                }
                boolean isDfsDir = dest_type == 3;
                this.loadFileWork.add(new LoadFileDesc(tblDesc, viewDesc, queryTmpdir, dest_path, isDfsDir, cols, colTypes));
                if (tblDesc == null) {
                    if (viewDesc != null) {
                        table_desc = PlanUtils.getTableDesc(viewDesc, cols, colTypes);
                    } else if (qb.getIsQuery()) {
                        String fileFormat;
                        if (SessionState.get().getIsUsingThriftJDBCBinarySerDe()) {
                            fileFormat = "SequenceFile";
                            HiveConf.setVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT, fileFormat);
                            table_desc = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, fileFormat, ThriftJDBCBinarySerDe.class);
                            this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
                        } else {
                            fileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                            table_desc = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, fileFormat, LazySimpleSerDe.class);
                        }
                    } else {
                        table_desc = PlanUtils.getDefaultTableDesc(qb.getDirectoryDesc(), cols, colTypes);
                    }
                } else {
                    table_desc = PlanUtils.getTableDesc(tblDesc, cols, colTypes);
                }
                if (this.outputs.add(new WriteEntity(dest_path, !isDfsDir, isDestTempFile))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_path.toUri().toString()));
            }
            default: {
                throw new SemanticException("Unknown destination type: " + dest_type);
            }
        }
        if (dest_type != 3 || !qb.getIsQuery()) {
            input = this.genConversionSelectOperator(dest, qb, input, table_desc, dpCtx);
        }
        inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ColumnInfo> vecCol = new ArrayList<ColumnInfo>();
        if (this.updating(dest) || this.deleting(dest)) {
            vecCol.add(new ColumnInfo(VirtualColumn.ROWID.getName(), VirtualColumn.ROWID.getTypeInfo(), "", true));
        } else {
            try {
                StructObjectInspector rowObjectInspector = (StructObjectInspector)table_desc.getDeserializer(this.conf).getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    vecCol.add(new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), "", false));
                }
            }
            catch (Exception e) {
                throw new SemanticException(e.getMessage(), e);
            }
        }
        RowSchema fsRS = new RowSchema(vecCol);
        boolean canBeMerged = dest_tab == null || dest_tab.getNumBuckets() <= 0 && (dest_tab.getSortCols() == null || dest_tab.getSortCols().size() <= 0);
        canBeMerged &= !destTableIsAcid;
        if (dest_type == 1 || dest_type == 2) {
            this.genPartnCols(dest, input, qb, table_desc, dest_tab, rsCtx);
        }
        FileSinkDesc fileSinkDesc = new FileSinkDesc(queryTmpdir, table_desc, this.conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT), currentTableId, rsCtx.isMultiFileSpray(), canBeMerged, rsCtx.getNumFiles(), rsCtx.getTotalFiles(), rsCtx.getPartnCols(), dpCtx, dest_path);
        boolean isHiveServerQuery = SessionState.get().isHiveServerQuery();
        fileSinkDesc.setHiveServerQuery(isHiveServerQuery);
        if (destTableIsAcid) {
            AcidUtils.Operation wt = this.updating(dest) ? AcidUtils.Operation.UPDATE : (this.deleting(dest) ? AcidUtils.Operation.DELETE : AcidUtils.Operation.INSERT);
            fileSinkDesc.setWriteType(wt);
            this.acidFileSinks.add(fileSinkDesc);
        }
        fileSinkDesc.setTemporary(destTableIsTemporary);
        fileSinkDesc.setMaterialization(destTableIsMaterialization);
        if (lbCtx != null) {
            lbCtx.processRowSkewedIndex(fsRS);
            lbCtx.calculateSkewedValueSubDirList();
        }
        fileSinkDesc.setLbCtx(lbCtx);
        fileSinkDesc.setStatsAggPrefix(fileSinkDesc.getDirName().toString());
        if (!destTableIsMaterialization && HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name())) {
            String statsTmpLoc = this.ctx.getTempDirForPath(dest_path).toString();
            fileSinkDesc.setStatsTmpDir(statsTmpLoc);
            this.LOG.debug("Set stats collection dir : " + statsTmpLoc);
        }
        if (dest_part != null) {
            try {
                String staticSpec = Warehouse.makePartPath(dest_part.getSpec());
                fileSinkDesc.setStaticSpec(staticSpec);
            }
            catch (MetaException e) {
                throw new SemanticException(e);
            }
        } else if (dpCtx != null) {
            fileSinkDesc.setStaticSpec(dpCtx.getSPPath());
        }
        if (isHiveServerQuery && null != table_desc && table_desc.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName()) && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
            fileSinkDesc.setIsUsingThriftJDBCBinarySerDe(true);
        } else {
            fileSinkDesc.setIsUsingThriftJDBCBinarySerDe(false);
        }
        Operator<FileSinkDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(fileSinkDesc, fsRS, input, new Operator[0]), inputRR);
        if (ltd != null && SessionState.get() != null) {
            SessionState.get().getLineageState().mapDirToOp(ltd.getSourcePath(), (FileSinkOperator)output);
        } else if (this.queryState.getCommandType().equals(HiveOperation.CREATETABLE_AS_SELECT.getOperationName())) {
            Path tlocation = null;
            String tName = Utilities.getDbTableName(this.tableDesc.getTableName())[1];
            try {
                Warehouse wh = new Warehouse(this.conf);
                tlocation = wh.getDefaultTablePath(this.db.getDatabase(this.tableDesc.getDatabaseName()), tName);
            }
            catch (MetaException | HiveException e) {
                throw new SemanticException(e);
            }
            SessionState.get().getLineageState().mapDirToOp(tlocation, (FileSinkOperator)output);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created FileSink Plan for clause: " + dest + "dest_path: " + dest_path + " row schema: " + inputRR.toString());
        }
        FileSinkOperator fso = (FileSinkOperator)output;
        ((FileSinkDesc)fso.getConf()).setTable(dest_tab);
        this.fsopToTable.put(fso, dest_tab);
        if (dest_tab != null && this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER) && this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSCOLAUTOGATHER) && ColumnStatsAutoGatherContext.canRunAutogatherStats(fso)) {
            if (dest_type == 1) {
                this.genAutoColumnStatsGatheringPipeline(qb, table_desc, partSpec, input, qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
            } else if (dest_type == 2) {
                this.genAutoColumnStatsGatheringPipeline(qb, table_desc, dest_part.getSpec(), input, qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
            }
        }
        return output;
    }

    private void createInsertDesc(Table table, boolean overwrite) {
        Task[] tasks = new Task[this.rootTasks.size()];
        tasks = this.rootTasks.toArray(tasks);
        PreInsertTableDesc preInsertTableDesc = new PreInsertTableDesc(table, overwrite);
        InsertTableDesc insertTableDesc = new InsertTableDesc(table, overwrite);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), preInsertTableDesc), this.conf, new Task[0]));
        TaskFactory.getAndMakeChild(new DDLWork(this.getInputs(), this.getOutputs(), insertTableDesc), this.conf, tasks);
    }

    private void genAutoColumnStatsGatheringPipeline(QB qb, TableDesc table_desc, Map<String, String> partSpec, Operator curr, boolean isInsertInto) throws SemanticException {
        String tableName = table_desc.getTableName();
        Table table = null;
        try {
            table = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage());
        }
        this.LOG.info("Generate an operator pipeline to autogather column stats for table " + tableName + " in query " + this.ctx.getCmd());
        ColumnStatsAutoGatherContext columnStatsAutoGatherContext = null;
        columnStatsAutoGatherContext = new ColumnStatsAutoGatherContext(this, this.conf, curr, table, partSpec, isInsertInto, this.ctx);
        columnStatsAutoGatherContext.insertAnalyzePipeline();
        this.columnStatsAutoGatherContexts.add(columnStatsAutoGatherContext);
    }

    String fixCtasColumnName(String colName) {
        return colName;
    }

    private void checkAcidConstraints(QB qb, TableDesc tableDesc, Table table) throws SemanticException {
        String tableName = tableDesc.getTableName();
        if (!qb.getParseInfo().isInsertIntoTable(tableName)) {
            this.LOG.debug("Couldn't find table " + tableName + " in insertIntoTable");
            throw new SemanticException(ErrorMsg.NO_INSERT_OVERWRITE_WITH_ACID.getMsg());
        }
        this.conf.set("hive.doing.acid", "true");
        if (table.getNumBuckets() < 1) {
            throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TABLE, table.getTableName());
        }
        if (table.getSortCols() != null && table.getSortCols().size() > 0) {
            throw new SemanticException(ErrorMsg.ACID_NO_SORTED_BUCKETS, table.getTableName());
        }
    }

    Operator genConversionSelectOperator(String dest, QB qb, Operator input, TableDesc table_desc, DynamicPartitionCtx dpCtx) throws SemanticException {
        int i;
        StructObjectInspector oi = null;
        try {
            Deserializer deserializer = table_desc.getDeserializerClass().newInstance();
            SerDeUtils.initializeSerDe(deserializer, this.conf, table_desc.getProperties(), null);
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        List<? extends StructField> tableFields = oi.getAllStructFieldRefs();
        boolean dynPart = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING);
        ArrayList<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int inColumnCnt = rowFields.size();
        int outColumnCnt = tableFields.size();
        if (dynPart && dpCtx != null) {
            outColumnCnt += dpCtx.getNumDPCols();
        }
        if (!this.updating(dest) && !this.deleting(dest) && inColumnCnt != outColumnCnt) {
            String reason = "Table " + dest + " has " + outColumnCnt + " columns, but query has " + inColumnCnt + " columns.";
            throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
        }
        boolean converted = false;
        int columnNumber = tableFields.size();
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        boolean isMetaDataSerDe = table_desc.getDeserializerClass().equals(MetadataTypedColumnsetSerDe.class);
        boolean isLazySimpleSerDe = table_desc.getDeserializerClass().equals(LazySimpleSerDe.class);
        if (!isMetaDataSerDe && !this.deleting(dest)) {
            if (this.updating(dest)) {
                expressions.add(new ExprNodeColumnDesc(rowFields.get(0).getType(), rowFields.get(0).getInternalName(), "", true));
            }
            for (i = 0; i < columnNumber; ++i) {
                int rowFieldsOffset = this.updating(dest) ? i + 1 : i;
                ObjectInspector tableFieldOI = tableFields.get(i).getFieldObjectInspector();
                TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(tableFieldOI);
                TypeInfo rowFieldTypeInfo = rowFields.get(rowFieldsOffset).getType();
                ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(rowFieldsOffset).getInternalName(), "", false, rowFields.get(rowFieldsOffset).isSkewedCol());
                if (!tableFieldTypeInfo.equals(rowFieldTypeInfo)) {
                    converted = true;
                    column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo);
                    if (column == null) {
                        String reason = "Cannot convert column " + i + " from " + rowFieldTypeInfo + " to " + tableFieldTypeInfo + ".";
                        throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
                    }
                }
                expressions.add(column);
            }
        }
        if (dynPart && dpCtx != null && dpCtx.getNumDPCols() > 0) {
            for (i = tableFields.size() + (this.updating(dest) ? 1 : 0); i < rowFields.size(); ++i) {
                TypeInfo rowFieldTypeInfo = rowFields.get(i).getType();
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(i).getInternalName(), "", true);
                expressions.add(column);
            }
        }
        if (converted) {
            RowResolver rowResolver = new RowResolver();
            ArrayList<String> colNames = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            for (int i2 = 0; i2 < expressions.size(); ++i2) {
                String name = SemanticAnalyzer.getColumnInternalName(i2);
                rowResolver.put("", name, new ColumnInfo(name, expressions.get(i2).getTypeInfo(), "", false));
                colNames.add(name);
                colExprMap.put(name, expressions.get(i2));
            }
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(expressions, colNames), new RowSchema(rowResolver.getColumnInfos()), (Operator)input, new Operator[0]), rowResolver);
            input.setColumnExprMap(colExprMap);
        }
        return input;
    }

    private Operator genLimitPlan(String dest, QB qb, Operator input, int offset, int limit) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        LimitDesc limitDesc = new LimitDesc(offset, limit);
        this.globalLimitCtx.setLastReduceLimitDesc(limitDesc);
        Operator<LimitDesc> limitMap = this.putOpInsertMap(OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created LimitOperator Plan for clause: " + dest + " row schema: " + inputRR.toString());
        }
        return limitMap;
    }

    /*
     * WARNING - void declaration
     */
    private Operator genUDTFPlan(GenericUDTF genericUDTF, String outputTableAlias, ArrayList<String> colAliases, QB qb, Operator input, boolean outerLV) throws SemanticException {
        void var19_24;
        int numSuppliedAliases;
        QBParseInfo qbp = qb.getParseInfo();
        if (!qbp.getDestToGroupBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
        }
        if (!qbp.getDestToDistributeBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
        }
        if (!qbp.getDestToSortBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
        }
        if (!qbp.getDestToClusterBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
        }
        if (!qbp.getAliasToLateralViews().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Table alias: " + outputTableAlias + " Col aliases: " + colAliases);
        }
        RowResolver selectRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ColumnInfo> inputCols = selectRR.getColumnInfos();
        ArrayList<String> colNames = new ArrayList<String>();
        ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
        for (int i = 0; i < inputCols.size(); ++i) {
            colNames.add(inputCols.get(i).getInternalName());
            colOIs[i] = inputCols.get(i).getObjectInspector();
        }
        StandardStructObjectInspector rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, Arrays.asList(colOIs));
        StructObjectInspector outputOI = genericUDTF.initialize(rowOI);
        int numUdtfCols = outputOI.getAllStructFieldRefs().size();
        if (colAliases.isEmpty()) {
            for (StructField structField : outputOI.getAllStructFieldRefs()) {
                colAliases.add(structField.getFieldName());
            }
        }
        if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases " + "but got " + numSuppliedAliases));
        }
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        Iterator<String> colAliasesIter = colAliases.iterator();
        for (StructField structField : outputOI.getAllStructFieldRefs()) {
            String colAlias = colAliasesIter.next();
            assert (colAlias != null);
            ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), outputTableAlias, false);
            arrayList.add(col);
        }
        RowResolver out_rwsch = new RowResolver();
        boolean bl = false;
        while (var19_24 < arrayList.size()) {
            out_rwsch.put(outputTableAlias, colAliases.get((int)var19_24), (ColumnInfo)arrayList.get((int)var19_24));
            ++var19_24;
        }
        Operator<UDTFDesc> operator = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new UDTFDesc(genericUDTF, outerLV), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        return operator;
    }

    private Operator genLimitMapRedPlan(String dest, QB qb, Operator input, int offset, int limit, boolean extraMRStep) throws SemanticException {
        Operator curr = this.genLimitPlan(dest, qb, input, offset, limit);
        if (!extraMRStep || !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_GROUPBY_LIMIT_EXTRASTEP)) {
            return curr;
        }
        curr = this.genReduceSinkPlan(dest, qb, curr, 1, false);
        return this.genLimitPlan(dest, qb, curr, offset, limit);
    }

    private ArrayList<ExprNodeDesc> getPartitionColsFromBucketCols(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, boolean convert) throws SemanticException {
        List<String> tabBucketCols = tab.getBucketCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (String bucketCol : tabBucketCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (bucketCol.equals(tabCol.getName())) {
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, tab, table_desc, input, posns, convert);
    }

    private ArrayList<ExprNodeDesc> getPartitionColsFromBucketColsForUpdateDelete(Operator input, boolean convert) throws SemanticException {
        ColumnInfo rowField = this.opParseCtx.get(input).getRowResolver().getColumnInfos().get(0);
        TypeInfo rowFieldTypeInfo = rowField.getType();
        ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowField.getInternalName(), rowField.getTabAlias(), true);
        if (convert) {
            column = ParseUtils.createConversionCast(column, TypeInfoFactory.intTypeInfo);
        }
        ArrayList<ExprNodeDesc> rlist = new ArrayList<ExprNodeDesc>(1);
        rlist.add(column);
        return rlist;
    }

    private ArrayList<ExprNodeDesc> genConvertCol(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, List<Integer> posns, boolean convert) throws SemanticException {
        StructObjectInspector oi = null;
        try {
            Deserializer deserializer = table_desc.getDeserializerClass().newInstance();
            SerDeUtils.initializeSerDe(deserializer, this.conf, table_desc.getProperties(), null);
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        List<? extends StructField> tableFields = oi.getAllStructFieldRefs();
        ArrayList<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int columnNumber = posns.size();
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        for (Integer posn : posns) {
            ObjectInspector tableFieldOI = tableFields.get(posn).getFieldObjectInspector();
            TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(tableFieldOI);
            TypeInfo rowFieldTypeInfo = rowFields.get(posn).getType();
            ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(posn).getInternalName(), rowFields.get(posn).getTabAlias(), rowFields.get(posn).getIsVirtualCol());
            if (convert && !tableFieldTypeInfo.equals(rowFieldTypeInfo) && (column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo)) == null) {
                String reason = "Cannot convert column " + posn + " from " + rowFieldTypeInfo + " to " + tableFieldTypeInfo + ".";
                throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
            }
            expressions.add(column);
        }
        return expressions;
    }

    private ArrayList<ExprNodeDesc> getSortCols(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, boolean convert) throws SemanticException {
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (Order sortCol : tabSortCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (sortCol.getCol().equals(tabCol.getName())) {
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, tab, table_desc, input, posns, convert);
    }

    private ArrayList<Integer> getSortOrders(String dest, QB qb, Table tab, Operator input) throws SemanticException {
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> orders = new ArrayList<Integer>();
        block0: for (Order sortCol : tabSortCols) {
            for (FieldSchema tabCol : tabCols) {
                if (!sortCol.getCol().equals(tabCol.getName())) continue;
                orders.add(sortCol.getOrder());
                continue block0;
            }
        }
        return orders;
    }

    private Operator genReduceSinkPlan(String dest, QB qb, Operator<?> input, int numReducers, boolean hasOrderBy) throws SemanticException {
        Operator result;
        ASTNode sortExprs;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ASTNode partitionExprs = qb.getParseInfo().getClusterByForClause(dest);
        if (partitionExprs == null) {
            partitionExprs = qb.getParseInfo().getDistributeByForClause(dest);
        }
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        if (partitionExprs != null) {
            int ccount = partitionExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)partitionExprs.getChild(i);
                partCols.add(this.genExprNodeDesc(cl, inputRR));
            }
        }
        if ((sortExprs = qb.getParseInfo().getClusterByForClause(dest)) == null) {
            sortExprs = qb.getParseInfo().getSortByForClause(dest);
        }
        if (sortExprs == null && (sortExprs = qb.getParseInfo().getOrderByForClause(dest)) != null) {
            String error;
            assert (numReducers == 1);
            if (qb.getParseInfo().getDestLimit(dest) == null && (error = HiveConf.StrictChecks.checkNoLimit(this.conf)) != null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(sortExprs, error));
            }
        }
        ArrayList<ExprNodeDesc> sortCols = new ArrayList<ExprNodeDesc>();
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        if (sortExprs != null) {
            int ccount = sortExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)sortExprs.getChild(i);
                if (cl.getType() == 978) {
                    order.append("+");
                    cl = (ASTNode)cl.getChild(0);
                    if (cl.getType() == 826) {
                        nullOrder.append("a");
                    } else if (cl.getType() == 827) {
                        nullOrder.append("z");
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + cl.getType());
                    }
                    cl = (ASTNode)cl.getChild(0);
                } else if (cl.getType() == 979) {
                    order.append("-");
                    cl = (ASTNode)cl.getChild(0);
                    if (cl.getType() == 826) {
                        nullOrder.append("a");
                    } else if (cl.getType() == 827) {
                        nullOrder.append("z");
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + cl.getType());
                    }
                    cl = (ASTNode)cl.getChild(0);
                } else {
                    order.append("+");
                    nullOrder.append("a");
                }
                ExprNodeDesc exprNode = this.genExprNodeDesc(cl, inputRR);
                sortCols.add(exprNode);
            }
        }
        if ((result = this.genReduceSinkPlan(input, partCols, sortCols, order.toString(), nullOrder.toString(), numReducers, AcidUtils.Operation.NOT_ACID, true)).getParentOperators().size() == 1 && result.getParentOperators().get(0) instanceof ReduceSinkOperator) {
            ((ReduceSinkDesc)((ReduceSinkOperator)result.getParentOperators().get(0)).getConf()).setHasOrderBy(hasOrderBy);
        }
        return result;
    }

    private Operator genReduceSinkPlan(Operator<?> input, ArrayList<ExprNodeDesc> partitionCols, ArrayList<ExprNodeDesc> sortCols, String sortOrder, String nullOrder, int numReducers, AcidUtils.Operation acidOp) throws SemanticException {
        return this.genReduceSinkPlan(input, partitionCols, sortCols, sortOrder, nullOrder, numReducers, acidOp, false);
    }

    private Operator genReduceSinkPlan(Operator<?> input, ArrayList<ExprNodeDesc> partitionCols, ArrayList<ExprNodeDesc> sortCols, String sortOrder, String nullOrder, int numReducers, AcidUtils.Operation acidOp, boolean pullConstants) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(input));
        ArrayList<ExprNodeDesc> newSortCols = new ArrayList<ExprNodeDesc>();
        StringBuilder newSortOrder = new StringBuilder();
        StringBuilder newNullOrder = new StringBuilder();
        ArrayList<ExprNodeDesc> sortColsBack = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < sortCols.size(); ++i) {
            ExprNodeDesc sortCol = sortCols.get(i);
            if (pullConstants && sortCol instanceof ExprNodeConstantDesc) continue;
            newSortCols.add(sortCol);
            newSortOrder.append(sortOrder.charAt(i));
            newNullOrder.append(nullOrder.charAt(i));
            sortColsBack.add(ExprNodeDescUtils.backtrack(sortCol, dummy, input));
        }
        RowResolver rsRR = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueColsBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> constantCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ColumnInfo> columnInfos = inputRR.getColumnInfos();
        int[] index = new int[columnInfos.size()];
        for (int i = 0; i < index.length; ++i) {
            int vindex;
            int kindex;
            ColumnInfo colInfo = columnInfos.get(i);
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            ExprNodeColumnDesc value = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc valueBack = ExprNodeDescUtils.backtrack((ExprNodeDesc)value, dummy, input);
            if (pullConstants && valueBack instanceof ExprNodeConstantDesc) {
                index[i] = Integer.MAX_VALUE;
                constantCols.add(valueBack);
                continue;
            }
            int n = kindex = valueBack == null ? -1 : ExprNodeDescUtils.indexOf(valueBack, sortColsBack);
            if (kindex >= 0) {
                index[i] = kindex;
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setTabAlias(nm[0]);
                rsRR.put(nm[0], nm[1], newColInfo);
                if (nm2 == null) continue;
                rsRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
                continue;
            }
            int n2 = vindex = valueBack == null ? -1 : ExprNodeDescUtils.indexOf(valueBack, valueColsBack);
            if (vindex >= 0) {
                index[i] = -vindex - 1;
                continue;
            }
            index[i] = -valueCols.size() - 1;
            String outputColName = SemanticAnalyzer.getColumnInternalName(valueCols.size());
            valueCols.add(value);
            valueColsBack.add(valueBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setTabAlias(nm[0]);
            rsRR.put(nm[0], nm[1], newColInfo);
            if (nm2 != null) {
                rsRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
            }
            outputColumns.add(outputColName);
        }
        dummy.setParentOperators(null);
        ReduceSinkDesc rsdesc = PlanUtils.getReduceSinkDesc(newSortCols, valueCols, outputColumns, false, -1, partitionCols, newSortOrder.toString(), newNullOrder.toString(), numReducers, acidOp);
        Operator<ReduceSinkDesc> interim = this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsdesc, new RowSchema(rsRR.getColumnInfos()), input, new Operator[0]), rsRR);
        ArrayList<String> keyColNames = rsdesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(i), sortCols.get(i));
        }
        ArrayList<String> valueColNames = rsdesc.getOutputValueColumnNames();
        for (int i = 0; i < valueColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valueColNames.get(i), valueCols.get(i));
        }
        interim.setColumnExprMap(colExprMap);
        RowResolver selectRR = new RowResolver();
        ArrayList<ExprNodeDesc> selCols = new ArrayList<ExprNodeDesc>();
        ArrayList<String> selOutputCols = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> selColExprMap = new HashMap<String, ExprNodeDesc>();
        Iterator constants = constantCols.iterator();
        for (int i = 0; i < index.length; ++i) {
            ExprNodeDesc desc;
            ColumnInfo prev = columnInfos.get(i);
            String[] nm = inputRR.reverseLookup(prev.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(prev.getInternalName());
            ColumnInfo info = new ColumnInfo(prev);
            if (index[i] == Integer.MAX_VALUE) {
                desc = (ExprNodeDesc)constants.next();
            } else {
                String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valueColNames.get(-index[i] - 1);
                desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            }
            selCols.add(desc);
            String internalName = SemanticAnalyzer.getColumnInternalName(i);
            info.setInternalName(internalName);
            selectRR.put(nm[0], nm[1], info);
            if (nm2 != null) {
                selectRR.addMappingOnly(nm2[0], nm2[1], info);
            }
            selOutputCols.add(internalName);
            selColExprMap.put(internalName, desc);
        }
        SelectDesc select = new SelectDesc(selCols, selOutputCols);
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(selectRR.getColumnInfos()), interim, new Operator[0]), selectRR);
        output.setColumnExprMap(selColExprMap);
        return output;
    }

    private Operator genJoinOperatorChildren(QBJoinTree join, Operator left, Operator[] right, HashSet<Integer> omitOpts, ExprNodeDesc[][] joinKeys) throws SemanticException {
        RowResolver outputRR = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        Operator[] rightOps = new Operator[right.length];
        boolean outputPos = false;
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<ExprNodeDesc>> exprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        HashMap<Byte, List<ExprNodeDesc>> filterMap = new HashMap<Byte, List<ExprNodeDesc>>();
        for (int pos = 0; pos < right.length; ++pos) {
            ReduceSinkOperator rs;
            Operator input;
            Operator operator = input = right[pos] == null ? left : right[pos];
            if (input == null) {
                input = left;
            }
            if ((rs = (ReduceSinkOperator)input).getNumParent() != 1) {
                throw new SemanticException("RS should have single parent");
            }
            Operator<OperatorDesc> parent = rs.getParentOperators().get(0);
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)input.getConf();
            int[] index = rs.getValueIndex();
            ArrayList<ExprNodeColumnDesc> valueDesc = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ExprNodeDesc> filterDesc = new ArrayList<ExprNodeDesc>();
            Byte tag = (byte)rsDesc.getTag();
            if (omitOpts != null && omitOpts.contains(pos)) {
                exprMap.put(tag, valueDesc);
                filterMap.put(tag, filterDesc);
                rightOps[pos] = input;
                continue;
            }
            ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
            ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
            RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
            RowResolver parentRR = this.opParseCtx.get(parent).getRowResolver();
            posToAliasMap.put(pos, new HashSet<String>(inputRR.getTableNames()));
            ArrayList<ColumnInfo> columns = parentRR.getColumnInfos();
            for (int i = 0; i < index.length; ++i) {
                ColumnInfo prev = (ColumnInfo)columns.get(i);
                String[] nm = parentRR.reverseLookup(prev.getInternalName());
                String[] nm2 = parentRR.getAlternateMappings(prev.getInternalName());
                if (outputRR.get(nm[0], nm[1]) != null) continue;
                ColumnInfo info = new ColumnInfo(prev);
                String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valColNames.get(-index[i] - 1);
                String internalName = SemanticAnalyzer.getColumnInternalName(outputColumnNames.size());
                ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
                info.setInternalName(internalName);
                colExprMap.put(internalName, desc);
                outputRR.put(nm[0], nm[1], info);
                if (nm2 != null) {
                    outputRR.addMappingOnly(nm2[0], nm2[1], info);
                }
                valueDesc.add(desc);
                outputColumnNames.add(internalName);
                reversedExprs.put(internalName, tag);
            }
            for (ASTNode cond : join.getFilters().get(tag.byteValue())) {
                filterDesc.add(this.genExprNodeDesc(cond, inputRR));
            }
            exprMap.put(tag, valueDesc);
            filterMap.put(tag, filterDesc);
            rightOps[pos] = input;
        }
        JoinCondDesc[] joinCondns = new JoinCondDesc[join.getJoinCond().length];
        for (int i = 0; i < join.getJoinCond().length; ++i) {
            JoinCond condn = join.getJoinCond()[i];
            joinCondns[i] = new JoinCondDesc(condn);
        }
        JoinDesc desc = new JoinDesc(exprMap, outputColumnNames, join.getNoOuterJoin(), joinCondns, filterMap, joinKeys);
        desc.setReversedExprs(reversedExprs);
        desc.setFilterMap(join.getFilterMap());
        if (!join.getNoOuterJoin() && join.getPostJoinFilters().size() != 0) {
            ArrayList<ExprNodeDesc> residualFilterExprs = new ArrayList<ExprNodeDesc>();
            for (ASTNode cond : join.getPostJoinFilters()) {
                residualFilterExprs.add(this.genExprNodeDesc(cond, outputRR));
            }
            desc.setResidualFilterExprs(residualFilterExprs);
            join.getPostJoinFilters().clear();
        }
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(this.getOpContext(), desc, new RowSchema(outputRR.getColumnInfos()), rightOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        if (join.getNullSafes() != null) {
            boolean[] nullsafes = new boolean[join.getNullSafes().size()];
            for (int i = 0; i < nullsafes.length; ++i) {
                nullsafes[i] = join.getNullSafes().get(i);
            }
            desc.setNullSafes(nullsafes);
        }
        return this.putOpInsertMap(joinOp, outputRR);
    }

    private ExprNodeDesc[][] genJoinKeys(QBJoinTree joinTree, Operator[] inputs) throws SemanticException {
        ExprNodeDesc[][] joinKeys = new ExprNodeDesc[inputs.length][];
        for (int i = 0; i < inputs.length; ++i) {
            RowResolver inputRR = this.opParseCtx.get(inputs[i]).getRowResolver();
            List expressions = joinTree.getExpressions().get(i);
            joinKeys[i] = new ExprNodeDesc[expressions.size()];
            for (int j = 0; j < joinKeys[i].length; ++j) {
                joinKeys[i][j] = this.genExprNodeDesc((ASTNode)expressions.get(j), inputRR, true, this.isCBOExecuted());
            }
        }
        return this.genJoinOperatorTypeCheck(joinKeys);
    }

    private Operator genJoinReduceSinkChild(QB qb, ExprNodeDesc[] joinKeys, Operator<?> child, String[] srcs, int tag) throws SemanticException {
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(child));
        RowResolver inputRR = this.opParseCtx.get(child).getRowResolver();
        RowResolver outputRR = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeysBack = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc joinKey : joinKeys) {
            reduceKeys.add(joinKey);
            reduceKeysBack.add(ExprNodeDescUtils.backtrack(joinKey, dummy, child));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceValuesBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        int[] index = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo colInfo = (ColumnInfo)columns.get(i);
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc exprBack = ExprNodeDescUtils.backtrack((ExprNodeDesc)expr, dummy, child);
            int kindex = exprBack == null ? -1 : (ExprNodeDescUtils.isConstant(exprBack) ? reduceKeysBack.indexOf(exprBack) : ExprNodeDescUtils.indexOf(exprBack, reduceKeysBack));
            if (kindex >= 0) {
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setTabAlias(nm[0]);
                outputRR.put(nm[0], nm[1], newColInfo);
                if (nm2 != null) {
                    outputRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
                }
                index[i] = kindex;
                continue;
            }
            index[i] = -reduceValues.size() - 1;
            String outputColName = SemanticAnalyzer.getColumnInternalName(reduceValues.size());
            reduceValues.add(expr);
            reduceValuesBack.add(exprBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setTabAlias(nm[0]);
            outputRR.put(nm[0], nm[1], newColInfo);
            if (nm2 != null) {
                outputRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
            }
            outputColumns.add(outputColName);
        }
        dummy.setParentOperators(null);
        int numReds = -1;
        if (reduceKeys.size() == 0) {
            numReds = 1;
            String error = HiveConf.StrictChecks.checkCartesian(this.conf);
            if (error != null) {
                throw new SemanticException(error);
            }
        }
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumns, false, tag, reduceKeys.size(), numReds, AcidUtils.Operation.NOT_ACID);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(outputRR.getColumnInfos()), child, new Operator[0]), outputRR);
        ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(i), reduceKeys.get(i));
        }
        ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
        for (int i = 0; i < valColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valColNames.get(i), reduceValues.get(i));
        }
        rsOp.setValueIndex(index);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAliases(srcs);
        return rsOp;
    }

    private Operator genJoinOperator(QB qb, QBJoinTree joinTree, Map<String, Operator> map, Operator joiningOp) throws SemanticException {
        Operator joinSrcOp;
        QBJoinTree leftChild = joinTree.getJoinSrc();
        Operator operator = joinSrcOp = joiningOp instanceof JoinOperator ? joiningOp : null;
        if (joinSrcOp == null && leftChild != null) {
            joinSrcOp = this.genJoinOperator(qb, leftChild, map, null);
        }
        if (joinSrcOp != null) {
            ArrayList<ASTNode> filter = joinTree.getFiltersForPushing().get(0);
            for (ASTNode cond : filter) {
                joinSrcOp = this.genFilterPlan(qb, cond, joinSrcOp, false);
            }
        }
        String[] baseSrc = joinTree.getBaseSrc();
        Operator[] srcOps = new Operator[baseSrc.length];
        HashSet<Integer> omitOpts = null;
        int pos = 0;
        for (String src : baseSrc) {
            if (src != null) {
                Operator srcOp = map.get(src.toLowerCase());
                ArrayList<ASTNode> fields = joinTree.getRHSSemijoinColumns(src);
                if (fields != null) {
                    if (omitOpts == null) {
                        omitOpts = new HashSet<Integer>();
                    }
                    omitOpts.add(pos);
                    srcOp = this.insertSelectForSemijoin(fields, srcOp);
                    srcOps[pos++] = this.genMapGroupByForSemijoin(qb, fields, srcOp, GroupByDesc.Mode.HASH);
                    continue;
                }
                srcOps[pos++] = srcOp;
                continue;
            }
            assert (pos == 0);
            srcOps[pos++] = joinSrcOp;
        }
        ExprNodeDesc[][] joinKeys = this.genJoinKeys(joinTree, srcOps);
        for (int i = 0; i < srcOps.length; ++i) {
            String[] srcs;
            String[] stringArray;
            if (baseSrc[i] != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = baseSrc[i];
            } else {
                stringArray = srcs = joinTree.getLeftAliases();
            }
            if (!this.isCBOExecuted()) {
                srcOps[i] = this.genNotNullFilterForJoinSourcePlan(qb, srcOps[i], joinTree, joinKeys[i]);
            }
            srcOps[i] = this.genJoinReduceSinkChild(qb, joinKeys[i], srcOps[i], srcs, joinTree.getNextTag());
        }
        JoinOperator joinOp = (JoinOperator)this.genJoinOperatorChildren(joinTree, joinSrcOp, srcOps, omitOpts, joinKeys);
        ((JoinDesc)joinOp.getConf()).setQBJoinTreeProps(joinTree);
        this.joinContext.put(joinOp, joinTree);
        if (joinTree.getPostJoinFilters().size() != 0) {
            assert (joinTree.getNoOuterJoin());
            Operator op = joinOp;
            for (ASTNode condn : joinTree.getPostJoinFilters()) {
                op = this.genFilterPlan(qb, condn, op, false);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("Generated " + op + " with post-filtering conditions after JOIN operator");
            }
            return op;
        }
        return joinOp;
    }

    private Operator insertSelectForSemijoin(ArrayList<ASTNode> fields, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        RowResolver outputRR = new RowResolver();
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode field = fields.get(i);
            ExprNodeDesc exprNode = this.genExprNodeDesc(field, inputRR);
            String colName = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(colName);
            ColumnInfo colInfo = new ColumnInfo(colName, exprNode.getTypeInfo(), "", false);
            outputRR.putExpression(field, colInfo);
            colList.add(exprNode);
            colExprMap.put(colName, exprNode);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, outputColumnNames, false), new RowSchema(outputRR.getColumnInfos()), input, new Operator[0]), outputRR);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private Operator genMapGroupByForSemijoin(QB qb, ArrayList<ASTNode> fields, Operator inputOperatorInfo, GroupByDesc.Mode mode) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        qb.getParseInfo();
        groupByOutputRowResolver.setIsExprResolver(true);
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode colName = fields.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(colName, groupByInputRowResolver);
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo colInfo2 = new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false);
            groupByOutputRowResolver.putExpression(colName, colInfo2);
            colExprMap.put(field, grpByExprNode);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, null, false, -1, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private ExprNodeDesc[][] genJoinOperatorTypeCheck(ExprNodeDesc[][] keys) throws SemanticException {
        int keyLength = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                keyLength = keys[i].length;
                continue;
            }
            assert (keyLength == keys[i].length);
        }
        for (int k = 0; k < keyLength; ++k) {
            int i;
            TypeInfo commonType = keys[0][k].getTypeInfo();
            for (i = 1; i < keys.length; ++i) {
                TypeInfo a = commonType;
                TypeInfo b = keys[i][k].getTypeInfo();
                if ((commonType = FunctionRegistry.getCommonClassForComparison(a, b)) != null) continue;
                throw new SemanticException("Cannot do equality join on different types: " + a.getTypeName() + " and " + b.getTypeName());
            }
            for (i = 0; i < keys.length; ++i) {
                if (TypeInfoUtils.isConversionRequiredForComparison(keys[i][k].getTypeInfo(), commonType)) {
                    keys[i][k] = ParseUtils.createConversionCast(keys[i][k], (PrimitiveTypeInfo)commonType);
                    continue;
                }
                keys[i][k].setTypeInfo(commonType);
            }
        }
        return keys;
    }

    private Operator genJoinPlan(QB qb, Map<String, Operator> map) throws SemanticException {
        QBJoinTree joinTree = qb.getQbJoinTree();
        Operator joinOp = this.genJoinOperator(qb, joinTree, map, null);
        return joinOp;
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, Map<String, Operator> map) throws SemanticException {
        this.pushJoinFilters(qb, joinTree, map, true);
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, Map<String, Operator> map, boolean recursively) throws SemanticException {
        if (recursively && joinTree.getJoinSrc() != null) {
            this.pushJoinFilters(qb, joinTree.getJoinSrc(), map);
        }
        ArrayList<ArrayList<ASTNode>> filters = joinTree.getFiltersForPushing();
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src);
                ArrayList<ASTNode> filter = filters.get(pos);
                for (ASTNode cond : filter) {
                    srcOp = this.genFilterPlan(qb, cond, srcOp, false);
                }
                map.put(src, srcOp);
            }
            ++pos;
        }
    }

    private List<String> getMapSideJoinTables(QB qb) {
        ArrayList<String> cols = new ArrayList<String>();
        ASTNode hints = qb.getParseInfo().getHints();
        for (int pos = 0; pos < hints.getChildCount(); ++pos) {
            ASTNode hint = (ASTNode)hints.getChild(pos);
            if (((ASTNode)hint.getChild(0)).getToken().getType() != 358) continue;
            if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEIGNOREMAPJOINHINT) && !this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                ASTNode hintTblNames = (ASTNode)hint.getChild(1);
                int numCh = hintTblNames.getChildCount();
                for (int tblPos = 0; tblPos < numCh; ++tblPos) {
                    String tblName = ((ASTNode)hintTblNames.getChild(tblPos)).getText().toLowerCase();
                    if (cols.contains(tblName)) continue;
                    cols.add(tblName);
                }
                continue;
            }
            this.queryProperties.setMapJoinRemoved(true);
        }
        return cols;
    }

    private String getModifiedAlias(QB qb, String alias) {
        return QB.getAppendedAliasFromId(qb.getId(), alias);
    }

    private QBJoinTree genUniqueJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        QBJoinTree joinTree = new QBJoinTree();
        joinTree.setNoOuterJoin(false);
        joinTree.setExpressions(new ArrayList<ArrayList<ASTNode>>());
        joinTree.setFilters(new ArrayList<ArrayList<ASTNode>>());
        joinTree.setFiltersForPushing(new ArrayList<ArrayList<ASTNode>>());
        ArrayList<String> rightAliases = new ArrayList<String>();
        ArrayList<String> leftAliases = new ArrayList<String>();
        ArrayList<String> baseSrc = new ArrayList<String>();
        ArrayList<Boolean> preserved = new ArrayList<Boolean>();
        boolean lastPreserved = false;
        int cols = -1;
        block6: for (int i = 0; i < joinParseTree.getChildCount(); ++i) {
            ASTNode child = (ASTNode)joinParseTree.getChild(i);
            switch (child.getToken().getType()) {
                case 977: {
                    String alias;
                    String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)child.getChild(0));
                    String string = alias = child.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(child.getChild(child.getChildCount() - 1).getText().toLowerCase());
                    if (i == 0) {
                        leftAliases.add(alias);
                        joinTree.setLeftAlias(alias);
                    } else {
                        rightAliases.add(alias);
                    }
                    joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
                    joinTree.setId(qb.getId());
                    baseSrc.add(alias);
                    preserved.add(lastPreserved);
                    lastPreserved = false;
                    continue block6;
                }
                case 753: {
                    if (cols == -1 && child.getChildCount() != 0) {
                        cols = child.getChildCount();
                    } else if (child.getChildCount() != cols) {
                        throw new SemanticException("Tables with different or invalid number of keys in UNIQUEJOIN");
                    }
                    ArrayList<ASTNode> expressions = new ArrayList<ASTNode>();
                    ArrayList filt = new ArrayList();
                    ArrayList filters = new ArrayList();
                    for (Node exp : child.getChildren()) {
                        expressions.add((ASTNode)exp);
                    }
                    joinTree.getExpressions().add(expressions);
                    joinTree.getFilters().add(filt);
                    joinTree.getFiltersForPushing().add(filters);
                    continue block6;
                }
                case 219: {
                    lastPreserved = true;
                    continue block6;
                }
                case 941: {
                    throw new SemanticException("Subqueries are not supported in UNIQUEJOIN");
                }
                default: {
                    throw new SemanticException("Unexpected UNIQUEJOIN structure");
                }
            }
        }
        joinTree.setBaseSrc(baseSrc.toArray(new String[0]));
        joinTree.setLeftAliases(leftAliases.toArray(new String[0]));
        joinTree.setRightAliases(rightAliases.toArray(new String[0]));
        JoinCond[] condn = new JoinCond[preserved.size()];
        for (int i = 0; i < condn.length; ++i) {
            condn[i] = new JoinCond((Boolean)preserved.get(i));
        }
        joinTree.setJoinCond(condn);
        if (qb.getParseInfo().getHints() != null && !this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            this.LOG.info("STREAMTABLE hint honored.");
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private QBJoinTree genSQJoinTree(QB qb, SubQueryUtils.ISubQueryJoinInfo subQuery, Operator joiningOp, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String[] children;
        QBJoinTree joinTree = new QBJoinTree();
        JoinCond[] condn = new JoinCond[1];
        switch (subQuery.getJoinType()) {
            case LEFTOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTOUTER);
                break;
            }
            case RIGHTOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.RIGHTOUTER);
                break;
            }
            case FULLOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.FULLOUTER);
                break;
            }
            case LEFTSEMI: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTSEMI);
                break;
            }
            default: {
                condn[0] = new JoinCond(0, 1, JoinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        if (joiningOp instanceof JoinOperator) {
            QBJoinTree leftTree = this.joinContext.get(joiningOp);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            String[] leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else {
            String alias = SemanticAnalyzer.unescapeIdentifier(SubQueryUtils.getAlias(joiningOp, aliasToOpInfo).toLowerCase());
            joinTree.setLeftAlias(alias);
            String[] leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
        }
        String rightalias = SemanticAnalyzer.unescapeIdentifier(subQuery.getAlias().toLowerCase());
        String[] rightAliases = new String[]{rightalias};
        joinTree.setRightAliases(rightAliases);
        children = joinTree.getBaseSrc();
        if (children == null) {
            children = new String[2];
        }
        children[1] = rightalias;
        joinTree.setBaseSrc(children);
        joinTree.setId(qb.getId());
        joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, rightalias), aliasToOpInfo.get(rightalias));
        if (!joinTree.getNoSemiJoin()) {
            joinTree.addRHSSemijoin(rightalias);
        }
        ArrayList<ArrayList<ASTNode>> expressions = new ArrayList<ArrayList<ASTNode>>();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        joinTree.setExpressions(expressions);
        ArrayList<Boolean> nullsafes = new ArrayList<Boolean>();
        joinTree.setNullSafes(nullsafes);
        ArrayList<ArrayList<ASTNode>> filters = new ArrayList<ArrayList<ASTNode>>();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        joinTree.setFilters(filters);
        joinTree.setFilterMap(new int[2][]);
        ArrayList<ArrayList<ASTNode>> filtersForPushing = new ArrayList<ArrayList<ASTNode>>();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        joinTree.setFiltersForPushing(filtersForPushing);
        ASTNode joinCond = subQuery.getJoinConditionAST();
        ArrayList<String> leftSrc = new ArrayList<String>();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, aliasToOpInfo);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias(leftSrc.get(0));
        }
        return joinTree;
    }

    private QBJoinTree genJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String[] children;
        String[] leftAliases;
        String alias;
        String tableName;
        boolean isJoinRightToken;
        QBJoinTree joinTree = new QBJoinTree();
        JoinCond[] condn = new JoinCond[1];
        int joinType = joinParseTree.getToken().getType();
        switch (joinParseTree.getToken().getType()) {
            case 805: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTOUTER);
                break;
            }
            case 894: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.RIGHTOUTER);
                break;
            }
            case 762: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.FULLOUTER);
                break;
            }
            case 806: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTSEMI);
                break;
            }
            default: {
                condn[0] = new JoinCond(0, 1, JoinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        ASTNode left = (ASTNode)joinParseTree.getChild(0);
        ASTNode right = (ASTNode)joinParseTree.getChild(1);
        boolean isValidLeftToken = SemanticAnalyzer.isValidJoinSide(left);
        boolean isJoinLeftToken = !isValidLeftToken && SemanticAnalyzer.isJoinToken(left);
        boolean isValidRightToken = SemanticAnalyzer.isValidJoinSide(right);
        boolean bl = isJoinRightToken = !isValidRightToken && SemanticAnalyzer.isJoinToken(right);
        if (!isValidLeftToken && !isJoinLeftToken) {
            throw new SemanticException("Invalid token on the left side of the join: " + left.getToken().getText() + "; please rewrite your query");
        }
        if (!isValidRightToken) {
            String advice = "";
            if (isJoinRightToken && !isJoinLeftToken) {
                advice = "; for example, put the nested join on the left side, or nest joins differently";
            } else if (isJoinRightToken) {
                advice = "; for example, nest joins differently";
            }
            throw new SemanticException("Invalid token on the right side of the join: " + right.getToken().getText() + "; please rewrite your query" + advice);
        }
        if (isValidLeftToken) {
            tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)left.getChild(0)).toLowerCase();
            alias = this.extractJoinAlias(left, tableName);
            joinTree.setLeftAlias(alias);
            leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
        } else if (isJoinLeftToken) {
            QBJoinTree leftTree = this.genJoinTree(qb, left, aliasToOpInfo);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else assert (false);
        if (isValidRightToken) {
            tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)right.getChild(0)).toLowerCase();
            alias = this.extractJoinAlias(right, tableName);
            String[] rightAliases = new String[]{alias};
            joinTree.setRightAliases(rightAliases);
            children = joinTree.getBaseSrc();
            if (children == null) {
                children = new String[2];
            }
            children[1] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
            if (!joinTree.getNoSemiJoin()) {
                joinTree.addRHSSemijoin(alias);
            }
        } else assert (false);
        ArrayList<ArrayList<ASTNode>> expressions = new ArrayList<ArrayList<ASTNode>>();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        joinTree.setExpressions(expressions);
        ArrayList<Boolean> nullsafes = new ArrayList<Boolean>();
        joinTree.setNullSafes(nullsafes);
        ArrayList<ArrayList<ASTNode>> filters = new ArrayList<ArrayList<ASTNode>>();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        joinTree.setFilters(filters);
        joinTree.setFilterMap(new int[2][]);
        ArrayList<ArrayList<ASTNode>> filtersForPushing = new ArrayList<ArrayList<ASTNode>>();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        joinTree.setFiltersForPushing(filtersForPushing);
        ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
        ArrayList<String> leftSrc = new ArrayList<String>();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, aliasToOpInfo);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias(leftSrc.get(0));
        }
        if (qb.getParseInfo().getHints() != null) {
            List<String> mapSideTables = this.getMapSideJoinTables(qb);
            List<String> mapAliases = joinTree.getMapAliases();
            for (String mapTbl : mapSideTables) {
                boolean mapTable = false;
                for (String leftAlias : joinTree.getLeftAliases()) {
                    if (!mapTbl.equalsIgnoreCase(leftAlias)) continue;
                    mapTable = true;
                }
                for (String rightAlias : joinTree.getRightAliases()) {
                    if (!mapTbl.equalsIgnoreCase(rightAlias)) continue;
                    mapTable = true;
                }
                if (!mapTable) continue;
                if (mapAliases == null) {
                    mapAliases = new ArrayList<String>();
                }
                mapAliases.add(mapTbl);
                joinTree.setMapSideJoin(true);
            }
            joinTree.setMapAliases(mapAliases);
            if (!this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                this.parseStreamTables(joinTree, qb);
            }
        }
        return joinTree;
    }

    private static boolean isValidJoinSide(ASTNode right) {
        return right.getToken().getType() == 977 || right.getToken().getType() == 941 || right.getToken().getType() == 875;
    }

    private String extractJoinAlias(ASTNode node, String tableName) {
        if (node.getType() == 875) {
            return SemanticAnalyzer.unescapeIdentifier(node.getChild(1).getText().toLowerCase());
        }
        if (node.getChildCount() == 1) {
            return tableName;
        }
        for (int i = node.getChildCount() - 1; i >= 1; --i) {
            if (node.getChild(i).getType() != 24) continue;
            return SemanticAnalyzer.unescapeIdentifier(node.getChild(i).getText().toLowerCase());
        }
        return tableName;
    }

    private void parseStreamTables(QBJoinTree joinTree, QB qb) {
        List<String> streamAliases = joinTree.getStreamAliases();
        for (Node hintNode : qb.getParseInfo().getHints().getChildren()) {
            ASTNode hint = (ASTNode)hintNode;
            if (hint.getChild(0).getType() != 359) continue;
            for (int i = 0; i < hint.getChild(1).getChildCount(); ++i) {
                if (streamAliases == null) {
                    streamAliases = new ArrayList<String>();
                }
                streamAliases.add(hint.getChild(1).getChild(i).getText());
            }
        }
        joinTree.setStreamAliases(streamAliases);
    }

    private void mergeJoins(QB qb, QBJoinTree node, QBJoinTree target, int pos, int[] tgtToNodeExprMap) {
        int i;
        int i2;
        int i3;
        String[] nodeRightAliases = node.getRightAliases();
        String[] trgtRightAliases = target.getRightAliases();
        String[] rightAliases = new String[nodeRightAliases.length + trgtRightAliases.length];
        for (i3 = 0; i3 < trgtRightAliases.length; ++i3) {
            rightAliases[i3] = trgtRightAliases[i3];
        }
        for (i3 = 0; i3 < nodeRightAliases.length; ++i3) {
            rightAliases[i3 + trgtRightAliases.length] = nodeRightAliases[i3];
        }
        target.setRightAliases(rightAliases);
        target.getAliasToOpInfo().putAll(node.getAliasToOpInfo());
        String[] nodeBaseSrc = node.getBaseSrc();
        String[] trgtBaseSrc = target.getBaseSrc();
        String[] baseSrc = new String[nodeBaseSrc.length + trgtBaseSrc.length - 1];
        for (i2 = 0; i2 < trgtBaseSrc.length; ++i2) {
            baseSrc[i2] = trgtBaseSrc[i2];
        }
        for (i2 = 1; i2 < nodeBaseSrc.length; ++i2) {
            baseSrc[i2 + trgtBaseSrc.length - 1] = nodeBaseSrc[i2];
        }
        target.setBaseSrc(baseSrc);
        ArrayList<ArrayList<ASTNode>> expr = target.getExpressions();
        for (int i4 = 0; i4 < nodeRightAliases.length; ++i4) {
            List nodeConds = node.getExpressions().get(i4 + 1);
            ArrayList reordereNodeConds = new ArrayList();
            for (int k = 0; k < tgtToNodeExprMap.length; ++k) {
                reordereNodeConds.add(nodeConds.get(tgtToNodeExprMap[k]));
            }
            expr.add(reordereNodeConds);
        }
        ArrayList<Boolean> nns = node.getNullSafes();
        ArrayList<Boolean> tns = target.getNullSafes();
        for (int i5 = 0; i5 < tns.size(); ++i5) {
            tns.set(i5, tns.get(i5) & nns.get(i5));
        }
        ArrayList<ArrayList<ASTNode>> filters = target.getFilters();
        for (int i6 = 0; i6 < nodeRightAliases.length; ++i6) {
            filters.add(node.getFilters().get(i6 + 1));
        }
        if (node.getFilters().get(0).size() != 0) {
            ArrayList<ASTNode> filterPos = filters.get(pos);
            filterPos.addAll((Collection<ASTNode>)node.getFilters().get(0));
        }
        int[][] nmap = node.getFilterMap();
        int[][] tmap = target.getFilterMap();
        int[][] newmap = new int[tmap.length + nmap.length - 1][];
        for (int[] mapping : nmap) {
            if (mapping == null) continue;
            for (int i7 = 0; i7 < mapping.length; i7 += 2) {
                if (pos <= 0 && mapping[i7] <= 0) continue;
                int n = i7;
                mapping[n] = mapping[n] + trgtRightAliases.length;
            }
        }
        if (nmap[0] != null) {
            if (tmap[pos] == null) {
                tmap[pos] = nmap[0];
            } else {
                int[] appended = new int[tmap[pos].length + nmap[0].length];
                System.arraycopy(tmap[pos], 0, appended, 0, tmap[pos].length);
                System.arraycopy(nmap[0], 0, appended, tmap[pos].length, nmap[0].length);
                tmap[pos] = appended;
            }
        }
        System.arraycopy(tmap, 0, newmap, 0, tmap.length);
        System.arraycopy(nmap, 1, newmap, tmap.length, nmap.length - 1);
        target.setFilterMap(newmap);
        ArrayList<ArrayList<ASTNode>> filter = target.getFiltersForPushing();
        for (int i8 = 0; i8 < nodeRightAliases.length; ++i8) {
            filter.add(node.getFiltersForPushing().get(i8 + 1));
        }
        if (node.getFiltersForPushing().get(0).size() != 0) {
            for (ASTNode nodeFilter : node.getFiltersForPushing().get(0)) {
                int fPos = ParseUtils.checkJoinFilterRefersOneAlias(target.getBaseSrc(), nodeFilter);
                if (fPos != -1) {
                    filter.get(fPos).add(nodeFilter);
                    continue;
                }
                target.addPostJoinFilter(nodeFilter);
            }
        }
        if (node.getNoOuterJoin() && target.getNoOuterJoin()) {
            target.setNoOuterJoin(true);
        } else {
            target.setNoOuterJoin(false);
        }
        if (node.getNoSemiJoin() && target.getNoSemiJoin()) {
            target.setNoSemiJoin(true);
        } else {
            target.setNoSemiJoin(false);
        }
        target.mergeRHSSemijoin(node);
        JoinCond[] nodeCondns = node.getJoinCond();
        int nodeCondnsSize = nodeCondns.length;
        JoinCond[] targetCondns = target.getJoinCond();
        int targetCondnsSize = targetCondns.length;
        JoinCond[] newCondns = new JoinCond[nodeCondnsSize + targetCondnsSize];
        for (i = 0; i < targetCondnsSize; ++i) {
            newCondns[i] = targetCondns[i];
        }
        for (i = 0; i < nodeCondnsSize; ++i) {
            JoinCond nodeCondn = nodeCondns[i];
            if (nodeCondn.getLeft() == 0) {
                nodeCondn.setLeft(pos);
            } else {
                nodeCondn.setLeft(nodeCondn.getLeft() + targetCondnsSize);
            }
            nodeCondn.setRight(nodeCondn.getRight() + targetCondnsSize);
            newCondns[targetCondnsSize + i] = nodeCondn;
        }
        target.setJoinCond(newCondns);
        if (target.isMapSideJoin()) {
            assert (node.isMapSideJoin());
            List<String> mapAliases = target.getMapAliases();
            for (String mapTbl : node.getMapAliases()) {
                if (mapAliases.contains(mapTbl)) continue;
                mapAliases.add(mapTbl);
            }
            target.setMapAliases(mapAliases);
        }
        if (node.getPostJoinFilters().size() != 0) {
            assert (node.getNoOuterJoin());
            if (target.getPostJoinFilters().size() != 0) assert (target.getNoOuterJoin());
            for (ASTNode exprPostFilter : node.getPostJoinFilters()) {
                target.addPostJoinFilter(exprPostFilter);
            }
        }
    }

    private ObjectPair<Integer, int[]> findMergePos(QBJoinTree node, QBJoinTree target) {
        int j;
        int res = -1;
        String leftAlias = node.getLeftAlias();
        if (!(leftAlias != null || node.getNoOuterJoin() && target.getNoOuterJoin())) {
            return new ObjectPair<Integer, Object>(-1, null);
        }
        ArrayList<ASTNode> nodeCondn = node.getExpressions().get(0);
        ArrayList<ASTNode> targetCondn = null;
        if (leftAlias == null || leftAlias.equals(target.getLeftAlias())) {
            targetCondn = target.getExpressions().get(0);
            res = 0;
        } else {
            for (int i = 0; i < target.getRightAliases().length; ++i) {
                if (!leftAlias.equals(target.getRightAliases()[i])) continue;
                targetCondn = target.getExpressions().get(i + 1);
                res = i + 1;
                break;
            }
        }
        if (targetCondn == null || nodeCondn.size() != targetCondn.size()) {
            return new ObjectPair<Integer, Object>(-1, null);
        }
        int[] tgtToNodeExprMap = new int[targetCondn.size()];
        boolean[] nodeFiltersMapped = new boolean[nodeCondn.size()];
        for (int i = 0; i < targetCondn.size(); ++i) {
            String tgtExprTree = targetCondn.get(i).toStringTree();
            tgtToNodeExprMap[i] = -1;
            for (j = 0; j < nodeCondn.size(); ++j) {
                if (!nodeCondn.get(j).toStringTree().equals(tgtExprTree)) continue;
                tgtToNodeExprMap[i] = j;
                nodeFiltersMapped[j] = true;
            }
            if (tgtToNodeExprMap[i] != -1) continue;
            return new ObjectPair<Integer, Object>(-1, null);
        }
        for (j = 0; j < nodeCondn.size(); ++j) {
            if (nodeFiltersMapped[j]) continue;
            return new ObjectPair<Integer, Object>(-1, null);
        }
        return new ObjectPair<Integer, int[]>(res, tgtToNodeExprMap);
    }

    boolean isCBOExecuted() {
        return false;
    }

    boolean continueJoinMerge() {
        return true;
    }

    private void mergeJoinTree(QB qb) {
        QBJoinTree tree = qb.getQbJoinTree();
        if (tree.getJoinSrc() == null) {
            return;
        }
        ArrayList<QBJoinTree> trees = new ArrayList<QBJoinTree>();
        while (tree != null) {
            trees.add(tree);
            tree = tree.getJoinSrc();
        }
        boolean mergedQBJTree = false;
        block1: for (int i = trees.size() - 1; i >= 0; --i) {
            QBJoinTree target = (QBJoinTree)trees.get(i);
            if (target == null) continue;
            JoinType prevType = null;
            boolean continueScanning = true;
            for (int j = i - 1; j >= 0 && continueScanning; --j) {
                QBJoinTree node = (QBJoinTree)trees.get(j);
                if (node == null) continue;
                JoinType currType = this.getType(node.getJoinCond());
                if (prevType != null && prevType != currType || !node.getNoOuterJoin() && node.getPostJoinFilters().size() != 0 || !target.getNoOuterJoin() && target.getPostJoinFilters().size() != 0) continue block1;
                ObjectPair<Integer, int[]> mergeDetails = this.findMergePos(node, target);
                int pos = mergeDetails.getFirst();
                if (pos >= 0) {
                    if (!(node.getNoOuterJoin() && target.getNoOuterJoin() || node.getRightAliases().length + target.getRightAliases().length + 1 <= 16)) {
                        this.LOG.info(ErrorMsg.JOINNODE_OUTERJOIN_MORETHAN_16.getErrorCodedMsg());
                        continueScanning = this.continueJoinMerge();
                        continue;
                    }
                    this.mergeJoins(qb, node, target, pos, mergeDetails.getSecond());
                    trees.set(j, null);
                    mergedQBJTree = true;
                    continue;
                }
                continueScanning = this.continueJoinMerge();
                if (prevType != null) continue;
                prevType = currType;
            }
        }
        if (trees.size() > 1 && mergedQBJTree) {
            QBJoinTree curQBJTree = null;
            QBJoinTree prevQBJTree = null;
            for (int i = trees.size() - 1; i >= 0; --i) {
                curQBJTree = (QBJoinTree)trees.get(i);
                if (curQBJTree == null) continue;
                if (prevQBJTree != null) {
                    ArrayList<String> newCurLeftAliases = new ArrayList<String>();
                    newCurLeftAliases.addAll(Arrays.asList(prevQBJTree.getLeftAliases()));
                    newCurLeftAliases.addAll(Arrays.asList(prevQBJTree.getRightAliases()));
                    curQBJTree.setLeftAliases(newCurLeftAliases.toArray(new String[newCurLeftAliases.size()]));
                }
                prevQBJTree = curQBJTree;
            }
        }
        QBJoinTree current = null;
        for (int i = 0; i < trees.size(); ++i) {
            QBJoinTree target = (QBJoinTree)trees.get(i);
            if (target == null) continue;
            if (current == null) {
                current = target;
                qb.setQbJoinTree(current);
                continue;
            }
            current.setJoinSrc(target);
            current = target;
        }
    }

    private JoinType getType(JoinCond[] conds) {
        JoinType type = conds[0].getJoinType();
        for (int k = 1; k < conds.length; ++k) {
            if (type == conds[k].getJoinType()) continue;
            return null;
        }
        return type;
    }

    private Operator genSelectAllDesc(Operator input) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new ExprNodeColumnDesc(col, true));
            columnNames.add(col.getInternalName());
            columnExprMap.put(col.getInternalName(), new ExprNodeColumnDesc(col, true));
        }
        RowResolver outputRR = inputRR.duplicate();
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames, true), outputRR.getRowSchema(), input, new Operator[0]), outputRR);
        output.setColumnExprMap(columnExprMap);
        return output;
    }

    private List<List<String>> getCommonGroupByDestGroups(QB qb, Map<String, Operator<? extends OperatorDesc>> inputs) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        ArrayList<List<String>> commonGroupByDestGroups = new ArrayList<List<String>>();
        if (ks.size() <= 1) {
            ArrayList oneList = new ArrayList(1);
            if (ks.size() == 1) {
                oneList.add(ks.first());
            }
            commonGroupByDestGroups.add(oneList);
            return commonGroupByDestGroups;
        }
        ArrayList<Operator<? extends OperatorDesc>> inputOperators = new ArrayList<Operator<? extends OperatorDesc>>(ks.size());
        ArrayList<ArrayList<ExprNodeDesc>> sprayKeyLists = new ArrayList<ArrayList<ExprNodeDesc>>(ks.size());
        ArrayList<List<ExprNodeDesc>> distinctKeyLists = new ArrayList<List<ExprNodeDesc>>(ks.size());
        for (String dest : ks) {
            Operator<? extends OperatorDesc> input = inputs.get(dest);
            RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
            List<ExprNodeDesc> distinctKeys = this.getDistinctExprs(qbp, dest, inputRR);
            ArrayList<ExprNodeDesc> sprayKeys = new ArrayList<ExprNodeDesc>();
            List<ASTNode> grpByExprs = this.getGroupByForClause(qbp, dest);
            for (ASTNode grpByExpr : grpByExprs) {
                ExprNodeDesc exprDesc = this.genExprNodeDesc(grpByExpr, inputRR);
                if (ExprNodeDescUtils.indexOf(exprDesc, sprayKeys) >= 0) continue;
                sprayKeys.add(exprDesc);
            }
            boolean found = false;
            for (int i = 0; i < sprayKeyLists.size(); ++i) {
                ArrayList<ExprNodeDesc> combinedList;
                if (!input.equals(inputOperators.get(i))) continue;
                if (distinctKeys.isEmpty()) {
                    combinedList = new ArrayList<ExprNodeDesc>();
                    this.combineExprNodeLists((List)sprayKeyLists.get(i), (List)distinctKeyLists.get(i), combinedList);
                    if (!this.matchExprLists(combinedList, sprayKeys)) {
                        continue;
                    }
                } else {
                    if (((List)distinctKeyLists.get(i)).isEmpty()) {
                        combinedList = new ArrayList();
                        this.combineExprNodeLists(sprayKeys, distinctKeys, combinedList);
                        if (!this.matchExprLists(combinedList, (List)sprayKeyLists.get(i))) continue;
                        distinctKeyLists.remove(i);
                        sprayKeyLists.remove(i);
                        distinctKeyLists.add(i, distinctKeys);
                        sprayKeyLists.add(i, sprayKeys);
                        ((List)commonGroupByDestGroups.get(i)).add(0, dest);
                        found = true;
                        break;
                    }
                    if (!this.matchExprLists((List)distinctKeyLists.get(i), distinctKeys) || !this.matchExprLists((List)sprayKeyLists.get(i), sprayKeys)) continue;
                }
                ((List)commonGroupByDestGroups.get(i)).add(dest);
                found = true;
                break;
            }
            if (found) continue;
            inputOperators.add(input);
            sprayKeyLists.add(sprayKeys);
            distinctKeyLists.add(distinctKeys);
            ArrayList<String> destGroup = new ArrayList<String>();
            destGroup.add(dest);
            commonGroupByDestGroups.add(destGroup);
        }
        return commonGroupByDestGroups;
    }

    private void combineExprNodeLists(List<ExprNodeDesc> list, List<ExprNodeDesc> list2, List<ExprNodeDesc> combinedList) {
        combinedList.addAll(list);
        for (ExprNodeDesc elem : list2) {
            if (combinedList.contains(elem)) continue;
            combinedList.add(elem);
        }
    }

    private boolean matchExprLists(List<ExprNodeDesc> list1, List<ExprNodeDesc> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (ExprNodeDesc exprNodeDesc : list1) {
            if (ExprNodeDescUtils.indexOf(exprNodeDesc, list2) >= 0) continue;
            return false;
        }
        return true;
    }

    private List<ExprNodeDesc> getDistinctExprs(QBParseInfo qbp, String dest, RowResolver inputRR) throws SemanticException {
        List<ASTNode> distinctAggExprs = qbp.getDistinctFuncExprsForClause(dest);
        ArrayList<ExprNodeDesc> distinctExprs = new ArrayList<ExprNodeDesc>();
        for (ASTNode distinctAggExpr : distinctAggExprs) {
            for (int i = 1; i < distinctAggExpr.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)distinctAggExpr.getChild(i);
                ExprNodeDesc expr = this.genExprNodeDesc(parameter, inputRR);
                if (ExprNodeDescUtils.indexOf(expr, distinctExprs) >= 0) continue;
                distinctExprs.add(expr);
            }
        }
        return distinctExprs;
    }

    private Operator genBodyPlan(QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>(qbp.getClauseNames());
        Map<String, Operator<? extends OperatorDesc>> inputs = this.createInputForDests(qb, input, ks);
        Operator curr = input;
        List<List<String>> commonGroupByDestGroups = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEMULTIGROUPBYSINGLEREDUCER)) {
            try {
                commonGroupByDestGroups = this.getCommonGroupByDestGroups(qb, inputs);
            }
            catch (SemanticException e) {
                this.LOG.error("Failed to group clauses by common spray keys.", (Throwable)e);
            }
        }
        if (commonGroupByDestGroups == null) {
            commonGroupByDestGroups = new ArrayList<List<String>>();
            commonGroupByDestGroups.add(new ArrayList<String>(ks));
        }
        if (!commonGroupByDestGroups.isEmpty()) {
            for (List<String> commonGroupByDestGroup : commonGroupByDestGroups) {
                if (commonGroupByDestGroup.isEmpty()) continue;
                String firstDest = commonGroupByDestGroup.get(0);
                input = inputs.get(firstDest);
                if (commonGroupByDestGroup.size() == 1 || qbp.getAggregationExprsForClause(firstDest).size() == 0 && this.getGroupByForClause(qbp, firstDest).size() == 0 || this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) || !this.conf.getBoolVar(HiveConf.ConfVars.HIVEMULTIGROUPBYSINGLEREDUCER)) {
                    for (String dest : commonGroupByDestGroup) {
                        curr = inputs.get(dest);
                        if (qbp.getWhrForClause(dest) != null) {
                            ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
                            curr = this.genFilterPlan((ASTNode)whereExpr.getChild(0), qb, curr, aliasToOpInfo, false, false);
                        }
                        Operator gbySource = curr;
                        if (!(qbp.getAggregationExprsForClause(dest).size() == 0 && this.getGroupByForClause(qbp, dest).size() <= 0 || qbp.getSelForClause(dest).getToken().getType() == 900 && qbp.getWindowingExprsForClause(dest) != null)) {
                            ASTNode node;
                            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(dest).size() > 1) {
                                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
                            }
                            curr = this.genSelectAllDesc(curr);
                            ASTNode selExprList = qbp.getSelForClause(dest);
                            if (selExprList.getToken().getType() == 900 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 651) {
                                curr = this.genSelectPlan(dest, qb, curr, curr);
                                RowResolver rr = this.opParseCtx.get(curr).getRowResolver();
                                qbp.setSelExprForClause(dest, SemanticAnalyzer.genSelectDIAST(rr));
                            }
                            curr = this.conf.getBoolVar(HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE) ? (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlanMapAggrNoSkew(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
                        }
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("RR before GB " + this.opParseCtx.get(gbySource).getRowResolver() + " after GB " + this.opParseCtx.get(curr).getRowResolver());
                        }
                        curr = this.genPostGroupByBodyPlan(curr, dest, qb, aliasToOpInfo, gbySource);
                    }
                    continue;
                }
                curr = this.genGroupByPlan1ReduceMultiGBY(commonGroupByDestGroup, qb, input, aliasToOpInfo);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Body Plan for Query Block " + qb.getId());
        }
        return curr;
    }

    private Map<String, Operator<? extends OperatorDesc>> createInputForDests(QB qb, Operator<? extends OperatorDesc> input, Set<String> dests) throws SemanticException {
        HashMap<String, Operator<? extends OperatorDesc>> inputs = new HashMap<String, Operator<? extends OperatorDesc>>();
        for (String dest : dests) {
            inputs.put(dest, this.genLateralViewPlanForDest(dest, qb, input));
        }
        return inputs;
    }

    private Operator genPostGroupByBodyPlan(Operator curr, String dest, QB qb, Map<String, Operator> aliasToOpInfo, Operator gbySource) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        if (qbp.getHavingForClause(dest) != null) {
            if (this.getGroupByForClause(qbp, dest).size() == 0) {
                throw new SemanticException("HAVING specified without GROUP BY");
            }
            curr = this.genHavingPlan(dest, qb, curr, aliasToOpInfo);
        }
        if (this.queryProperties.hasWindowing() && qb.getWindowingSpec(dest) != null) {
            curr = this.genWindowingPlan(qb, qb.getWindowingSpec(dest), curr);
            if ((qbp.getAggregationExprsForClause(dest).size() != 0 || this.getGroupByForClause(qbp, dest).size() > 0) && qbp.getSelForClause(dest).getToken().getType() == 900 && qbp.getWindowingExprsForClause(dest) != null) {
                curr = this.conf.getBoolVar(HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE) ? (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlanMapAggrNoSkew(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
            }
        }
        curr = this.genSelectPlan(dest, qb, curr, gbySource);
        Integer limit = qbp.getDestLimit(dest);
        Integer offset = qbp.getDestLimitOffset(dest) == null ? 0 : qbp.getDestLimitOffset(dest);
        boolean genReduceSink = false;
        boolean hasOrderBy = false;
        if (qbp.getClusterByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getDistributeByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getOrderByForClause(dest) != null) {
            genReduceSink = true;
            hasOrderBy = true;
        }
        if (qbp.getSortByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (genReduceSink) {
            int numReducers = -1;
            if (hasOrderBy) {
                numReducers = 1;
            }
            curr = this.genReduceSinkPlan(dest, qb, curr, numReducers, hasOrderBy);
        }
        if (qbp.getIsSubQ()) {
            if (limit != null) {
                curr = this.genLimitMapRedPlan(dest, qb, curr, offset, limit, !hasOrderBy);
            }
        } else {
            if (limit != null) {
                boolean extraMRStep = true;
                if (hasOrderBy || qb.getIsQuery() && qbp.getClusterByForClause(dest) == null && qbp.getSortByForClause(dest) == null) {
                    extraMRStep = false;
                }
                curr = this.genLimitMapRedPlan(dest, qb, curr, offset, limit, extraMRStep);
                qb.getParseInfo().setOuterQueryLimit(limit);
            }
            if (!this.queryState.getHiveOperation().equals((Object)HiveOperation.CREATEVIEW)) {
                curr = this.genFileSinkPlan(dest, qb, curr);
            }
        }
        return curr;
    }

    private Operator genUnionPlan(String unionalias, String leftalias, Operator leftOp, String rightalias, Operator rightOp) throws SemanticException {
        UnionDesc uDesc;
        List<Operator<OperatorDesc>> parent;
        ArrayList<Operator<? extends OperatorDesc>> child;
        Operator<? extends OperatorDesc> oldChild;
        ASTNode tabref;
        RowResolver leftRR = this.opParseCtx.get(leftOp).getRowResolver();
        RowResolver rightRR = this.opParseCtx.get(rightOp).getRowResolver();
        LinkedHashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
        LinkedHashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
        ASTNode aSTNode = tabref = this.qb.getAliases().isEmpty() ? null : this.qb.getParseInfo().getSrcForAlias(this.qb.getAliases().get(0));
        if (leftmap.size() != rightmap.size()) {
            throw new SemanticException("Schema of both sides of union should match.");
        }
        RowResolver unionoutRR = new RowResolver();
        Iterator<Map.Entry<String, ColumnInfo>> lIter = leftmap.entrySet().iterator();
        Iterator<Map.Entry<String, ColumnInfo>> rIter = rightmap.entrySet().iterator();
        while (lIter.hasNext()) {
            Map.Entry<String, ColumnInfo> lEntry = lIter.next();
            Map.Entry<String, ColumnInfo> rEntry = rIter.next();
            ColumnInfo lInfo = lEntry.getValue();
            ColumnInfo rInfo = rEntry.getValue();
            String field = lEntry.getKey();
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
            if (commonTypeInfo == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
            }
            ColumnInfo unionColInfo = new ColumnInfo(lInfo);
            unionColInfo.setType(commonTypeInfo);
            unionoutRR.put(unionalias, field, unionColInfo);
        }
        boolean isMR = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("mr");
        if (!isMR || !(leftOp instanceof UnionOperator)) {
            leftOp = this.genInputSelectForUnion(leftOp, leftmap, leftalias, unionoutRR, unionalias);
        }
        if (!isMR || !(rightOp instanceof UnionOperator)) {
            rightOp = this.genInputSelectForUnion(rightOp, rightmap, rightalias, unionoutRR, unionalias);
        }
        if (leftOp instanceof UnionOperator || leftOp instanceof SelectOperator && leftOp.getParentOperators() != null && !leftOp.getParentOperators().isEmpty() && leftOp.getParentOperators().get(0) instanceof UnionOperator && ((SelectOperator)leftOp).isIdentitySelect()) {
            if (!(leftOp instanceof UnionOperator)) {
                oldChild = leftOp;
                leftOp = leftOp.getParentOperators().get(0);
                leftOp.removeChildAndAdoptItsChildren(oldChild);
            }
            child = new ArrayList<Operator<? extends OperatorDesc>>();
            child.add(leftOp);
            rightOp.setChildOperators(child);
            parent = leftOp.getParentOperators();
            parent.add(rightOp);
            uDesc = (UnionDesc)((UnionOperator)leftOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(leftOp, unionoutRR);
        }
        if (rightOp instanceof UnionOperator || rightOp instanceof SelectOperator && rightOp.getParentOperators() != null && !rightOp.getParentOperators().isEmpty() && rightOp.getParentOperators().get(0) instanceof UnionOperator && ((SelectOperator)rightOp).isIdentitySelect()) {
            if (!(rightOp instanceof UnionOperator)) {
                oldChild = rightOp;
                rightOp = rightOp.getParentOperators().get(0);
                rightOp.removeChildAndAdoptItsChildren(oldChild);
            }
            child = new ArrayList();
            child.add(rightOp);
            leftOp.setChildOperators(child);
            parent = rightOp.getParentOperators();
            parent.add(leftOp);
            uDesc = (UnionDesc)((UnionOperator)rightOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(rightOp, unionoutRR);
        }
        Operator<UnionDesc> unionforward = OperatorFactory.getAndMakeChild(this.getOpContext(), new UnionDesc(), new RowSchema(unionoutRR.getColumnInfos()));
        ArrayList<Operator<? extends OperatorDesc>> child2 = new ArrayList<Operator<? extends OperatorDesc>>();
        child2.add(unionforward);
        rightOp.setChildOperators(child2);
        child2 = new ArrayList();
        child2.add(unionforward);
        leftOp.setChildOperators(child2);
        ArrayList<Operator<? extends OperatorDesc>> parent2 = new ArrayList<Operator<? extends OperatorDesc>>();
        parent2.add(leftOp);
        parent2.add(rightOp);
        unionforward.setParentOperators(parent2);
        return this.putOpInsertMap(unionforward, unionoutRR);
    }

    private Operator<? extends OperatorDesc> genInputSelectForUnion(Operator<? extends OperatorDesc> origInputOp, Map<String, ColumnInfo> origInputFieldMap, String origInputAlias, RowResolver unionoutRR, String unionalias) throws SemanticException {
        LinkedHashMap<String, ColumnInfo> fieldMap = unionoutRR.getFieldMap(unionalias);
        Iterator<ColumnInfo> oIter = origInputFieldMap.values().iterator();
        Iterator uIter = ((HashMap)fieldMap).values().iterator();
        ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
        boolean needsCast = false;
        while (oIter.hasNext()) {
            ColumnInfo oInfo = oIter.next();
            ColumnInfo uInfo = (ColumnInfo)uIter.next();
            ExprNodeDesc column = new ExprNodeColumnDesc(oInfo.getType(), oInfo.getInternalName(), oInfo.getTabAlias(), oInfo.getIsVirtualCol(), oInfo.isSkewedCol());
            if (!oInfo.getType().equals(uInfo.getType())) {
                needsCast = true;
                column = ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)uInfo.getType());
            }
            columns.add(column);
        }
        if (!needsCast) {
            return origInputOp;
        }
        RowResolver rowResolver = new RowResolver();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> colName = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            String name = SemanticAnalyzer.getColumnInternalName(i);
            ColumnInfo col = new ColumnInfo(name, ((ExprNodeDesc)columns.get(i)).getTypeInfo(), "", false);
            rowResolver.put(origInputAlias, name, col);
            colName.add(name);
            columnExprMap.put(name, (ExprNodeDesc)columns.get(i));
        }
        Operator<SelectDesc> newInputOp = OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(rowResolver.getColumnInfos()), columnExprMap, origInputOp, new Operator[0]);
        return this.putOpInsertMap(newInputOp, rowResolver);
    }

    private ExprNodeDesc genSamplePredicate(TableSample ts, List<String> bucketCols, boolean useBucketCols, String alias, RowResolver rwsch, QBMetaData qbm, ExprNodeDesc planExpr) throws SemanticException {
        ExprNodeConstantDesc numeratorExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getNumerator() - 1);
        ExprNodeConstantDesc denominatorExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getDenominator());
        ExprNodeConstantDesc intMaxExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, Integer.MAX_VALUE);
        ArrayList<ExprNodeDesc> args = new ArrayList<ExprNodeDesc>();
        if (planExpr != null) {
            args.add(planExpr);
        } else if (useBucketCols) {
            for (String col : bucketCols) {
                ColumnInfo ci = rwsch.get(alias, col);
                args.add(new ExprNodeColumnDesc(ci));
            }
        } else {
            for (ASTNode expr : ts.getExprs()) {
                args.add(this.genExprNodeDesc(expr, rwsch));
            }
        }
        ExprNodeDesc equalsExpr = null;
        ExprNodeGenericFuncDesc hashfnExpr = new ExprNodeGenericFuncDesc(TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFHash(), args);
        assert (hashfnExpr != null);
        this.LOG.info("hashfnExpr = " + hashfnExpr);
        ExprNodeDesc andExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("&", hashfnExpr, intMaxExpr);
        assert (andExpr != null);
        this.LOG.info("andExpr = " + andExpr);
        ExprNodeDesc modExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("%", andExpr, denominatorExpr);
        assert (modExpr != null);
        this.LOG.info("modExpr = " + modExpr);
        this.LOG.info("numeratorExpr = " + numeratorExpr);
        equalsExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("==", modExpr, numeratorExpr);
        this.LOG.info("equalsExpr = " + equalsExpr);
        assert (equalsExpr != null);
        return equalsExpr;
    }

    protected String getAliasId(String alias, QB qb) {
        return (qb.getId() == null ? alias : qb.getId() + ":" + alias).toLowerCase();
    }

    private Operator genTablePlan(String alias, QB qb) throws SemanticException {
        RowResolver rwsch;
        String alias_id = this.getAliasId(alias, qb);
        Table tab = qb.getMetaData().getSrcForAlias(alias);
        TableScanOperator top = this.topOps.get(alias_id);
        Map<String, String> properties = qb.getTabPropsForAlias(alias);
        if (top == null) {
            rwsch = new RowResolver();
            try {
                if (properties != null) {
                    for (Map.Entry<String, String> prop : properties.entrySet()) {
                        if (tab.getSerdeParam(prop.getKey()) != null) {
                            this.LOG.warn("SerDe property in input query overrides stored SerDe property");
                        }
                        tab.setSerdeParam(prop.getKey(), prop.getValue());
                    }
                }
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tab.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    ColumnInfo colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), alias, false);
                    colInfo.setSkewedCol(SemanticAnalyzer.isSkewedCol(alias, qb, fields.get(i).getFieldName()));
                    rwsch.put(alias, fields.get(i).getFieldName(), colInfo);
                }
            }
            catch (SerDeException e) {
                throw new RuntimeException(e);
            }
            for (FieldSchema part_col : tab.getPartCols()) {
                this.LOG.trace("Adding partition col: " + part_col);
                rwsch.put(alias, part_col.getName(), new ColumnInfo(part_col.getName(), TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), alias, true));
            }
            Iterator<VirtualColumn> vcs = VirtualColumn.getRegistry(this.conf).iterator();
            ArrayList<VirtualColumn> vcList = new ArrayList<VirtualColumn>();
            while (vcs.hasNext()) {
                VirtualColumn vc = vcs.next();
                rwsch.put(alias, vc.getName().toLowerCase(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden()));
                vcList.add(vc);
            }
            TableScanDesc tsDesc = new TableScanDesc(alias, vcList, tab);
            this.setupStats(tsDesc, qb.getParseInfo(), tab, alias, rwsch);
            SplitSample sample = this.nameToSplitSample.get(alias_id);
            if (sample != null && sample.getRowCount() != null) {
                tsDesc.setRowLimit(sample.getRowCount());
                this.nameToSplitSample.remove(alias_id);
            }
            top = (TableScanOperator)this.putOpInsertMap(OperatorFactory.get(this.getOpContext(), tsDesc, new RowSchema(rwsch.getColumnInfos())), rwsch);
            top.setInsideView(qb.isInsideView() || qb.getAliasInsideView().contains(alias.toLowerCase()));
            this.topOps.put(alias_id, top);
            this.topToTable.put(top, tab);
            if (properties != null) {
                this.topToTableProps.put(top, properties);
                tsDesc.setOpProps(properties);
            }
        } else {
            rwsch = this.opParseCtx.get(top).getRowResolver();
            top.setChildOperators(null);
        }
        Operator op = top;
        TableSample ts = qb.getParseInfo().getTabSample(alias);
        if (ts != null) {
            TableScanOperator tableScanOp = top;
            ((TableScanDesc)tableScanOp.getConf()).setTableSample(ts);
            int num = ts.getNumerator();
            int den = ts.getDenominator();
            ArrayList<ASTNode> sampleExprs = ts.getExprs();
            List<String> tabBucketCols = tab.getBucketCols();
            int numBuckets = tab.getNumBuckets();
            if (tabBucketCols.size() == 0 && sampleExprs.size() == 0) {
                throw new SemanticException(ErrorMsg.NON_BUCKETED_TABLE.getMsg() + " " + tab.getTableName());
            }
            if (num > den) {
                throw new SemanticException(ErrorMsg.BUCKETED_NUMERATOR_BIGGER_DENOMINATOR.getMsg() + " " + tab.getTableName());
            }
            boolean colsEqual = true;
            if (sampleExprs.size() != tabBucketCols.size() && sampleExprs.size() != 0) {
                colsEqual = false;
            }
            for (int i = 0; i < sampleExprs.size() && colsEqual; ++i) {
                boolean colFound = false;
                for (int j = 0; j < tabBucketCols.size() && !colFound && sampleExprs.get(i).getToken().getType() == 973; ++j) {
                    if (!((ASTNode)sampleExprs.get(i).getChild(0)).getText().equalsIgnoreCase(tabBucketCols.get(j))) continue;
                    colFound = true;
                }
                colsEqual = colsEqual && colFound;
            }
            ts.setInputPruning(sampleExprs == null || sampleExprs.size() == 0 || colsEqual);
            if (!(sampleExprs != null && sampleExprs.size() != 0 && !colsEqual || num != den && den % numBuckets != 0 && numBuckets % den != 0)) {
                this.LOG.info("No need for sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                FilterDesc filterDesc = new FilterDesc(samplePredicate, true, new FilterDesc.SampleDesc(ts.getNumerator(), ts.getDenominator(), tabBucketCols, true));
                filterDesc.setGenerated(true);
                op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
            } else {
                this.LOG.info("Need sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                FilterDesc filterDesc = new FilterDesc(samplePredicate, true);
                filterDesc.setGenerated(true);
                op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
            }
        } else {
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            if (testMode) {
                String tabName = tab.getTableName();
                String unSampleTblList = this.conf.getVar(HiveConf.ConfVars.HIVETESTMODENOSAMPLE);
                String[] unSampleTbls = unSampleTblList.split(",");
                boolean unsample = false;
                for (String unSampleTbl : unSampleTbls) {
                    if (!tabName.equalsIgnoreCase(unSampleTbl)) continue;
                    unsample = true;
                }
                if (!unsample) {
                    int numBuckets = tab.getNumBuckets();
                    if (numBuckets > 0) {
                        TableSample tsSample = new TableSample(1, numBuckets);
                        tsSample.setInputPruning(true);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, tab.getBucketCols(), true, alias, rwsch, qb.getMetaData(), null);
                        FilterDesc filterDesc = new FilterDesc(samplePred, true, new FilterDesc.SampleDesc(tsSample.getNumerator(), tsSample.getDenominator(), tab.getBucketCols(), true));
                        filterDesc.setGenerated(true);
                        op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
                        this.LOG.info("No need for sample filter");
                    } else {
                        int freq = this.conf.getIntVar(HiveConf.ConfVars.HIVETESTMODESAMPLEFREQ);
                        TableSample tsSample = new TableSample(1, freq);
                        tsSample.setInputPruning(false);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        this.LOG.info("Need sample filter");
                        ExprNodeDesc randFunc = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new ExprNodeConstantDesc(460476415));
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, null, false, alias, rwsch, qb.getMetaData(), randFunc);
                        FilterDesc filterDesc = new FilterDesc(samplePred, true);
                        filterDesc.setGenerated(true);
                        op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
                    }
                }
            }
        }
        Operator<TableScanDesc> output = this.putOpInsertMap(op, rwsch);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Table Plan for " + alias + " " + op.toString());
        }
        return output;
    }

    static boolean isSkewedCol(String alias, QB qb, String colName) {
        boolean isSkewedCol = false;
        List<String> skewedCols = qb.getSkewedColumnNames(alias);
        for (String skewedCol : skewedCols) {
            if (!skewedCol.equalsIgnoreCase(colName)) continue;
            isSkewedCol = true;
        }
        return isSkewedCol;
    }

    private void setupStats(TableScanDesc tsDesc, QBParseInfo qbp, Table tab, String alias, RowResolver rwsch) throws SemanticException {
        if (!qbp.isAnalyzeCommand() && qbp.getAnalyzeRewrite() == null || qbp.getAnalyzeRewrite() != null && !HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            tsDesc.setGatherStats(false);
        } else {
            if (HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name())) {
                String statsTmpLoc = this.ctx.getTempDirForPath(tab.getPath()).toString();
                this.LOG.debug("Set stats collection dir : " + statsTmpLoc);
                tsDesc.setTmpStatsDir(statsTmpLoc);
            }
            tsDesc.setGatherStats(true);
            tsDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            Iterator<VirtualColumn> vcs = VirtualColumn.getStatsRegistry(this.conf).iterator();
            ArrayList<VirtualColumn> vcList = new ArrayList<VirtualColumn>();
            while (vcs.hasNext()) {
                VirtualColumn vc = vcs.next();
                rwsch.put(alias, vc.getName(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden()));
                vcList.add(vc);
            }
            tsDesc.addVirtualCols(vcList);
            String tblName = tab.getTableName();
            String k = MetaStoreUtils.encodeTableName(tblName) + "/";
            tsDesc.setStatsAggPrefix(tab.getDbName() + "." + k);
            this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_SHARED));
            if (tab.isPartitioned()) {
                ArrayList<String> cols = new ArrayList<String>();
                if (qbp.getAnalyzeRewrite() != null) {
                    List<FieldSchema> partitionCols = tab.getPartCols();
                    for (FieldSchema fs : partitionCols) {
                        cols.add(fs.getName());
                    }
                    tsDesc.setPartColumns(cols);
                    return;
                }
                BaseSemanticAnalyzer.TableSpec tblSpec = qbp.getTableSpec(alias);
                Map<String, String> partSpec = tblSpec.getPartSpec();
                if (partSpec == null) {
                    throw new SemanticException(ErrorMsg.NEED_PARTITION_SPECIFICATION.getMsg());
                }
                cols.addAll(partSpec.keySet());
                tsDesc.setPartColumns(cols);
                List<Partition> partitions = qbp.getTableSpec().partitions;
                if (partitions != null) {
                    for (Partition partn : partitions) {
                        this.LOG.info("XXX: adding part: " + partn);
                        this.outputs.add(new WriteEntity(partn, WriteEntity.WriteType.DDL_NO_LOCK));
                    }
                }
            }
        }
    }

    private Operator genPlan(QB parent, QBExpr qbexpr) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            boolean skipAmbiguityCheck = this.viewSelect == null && parent.isTopLevelSelectStarQuery();
            return this.genPlan(qbexpr.getQB(), skipAmbiguityCheck);
        }
        if (qbexpr.getOpcode() == QBExpr.Opcode.UNION) {
            Operator qbexpr1Ops = this.genPlan(parent, qbexpr.getQBExpr1());
            Operator qbexpr2Ops = this.genPlan(parent, qbexpr.getQBExpr2());
            return this.genUnionPlan(qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
        }
        return null;
    }

    public Operator genPlan(QB qb) throws SemanticException {
        return this.genPlan(qb, false);
    }

    public Operator genPlan(QB qb, boolean skipAmbiguityCheck) throws SemanticException {
        HashMap<ASTNode, PTFInvocationSpec> ptfNodeToSpec;
        LinkedHashMap<String, Operator> aliasToOpInfo = new LinkedHashMap<String, Operator>();
        for (String alias : qb.getSubqAliases()) {
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            Operator operator = this.genPlan(qb, qbexpr);
            aliasToOpInfo.put(alias, operator);
            if (!qb.getViewToTabSchema().containsKey(alias)) continue;
            if (operator instanceof SelectOperator) {
                if (this.viewProjectToTableSchema == null) {
                    this.viewProjectToTableSchema = new LinkedHashMap<SelectOperator, Table>();
                }
                this.viewProjectToTableSchema.put((SelectOperator)operator, qb.getViewToTabSchema().get(alias));
                continue;
            }
            throw new SemanticException("View " + alias + " is corresponding to " + operator.getType().name() + ", rather than a SelectOperator.");
        }
        for (String alias : qb.getTabAliases()) {
            Operator op = this.genTablePlan(alias, qb);
            aliasToOpInfo.put(alias, op);
        }
        if (aliasToOpInfo.isEmpty()) {
            qb.getMetaData().setSrcForAlias(DUMMY_TABLE, this.getDummyTable());
            TableScanOperator op = (TableScanOperator)this.genTablePlan(DUMMY_TABLE, qb);
            ((TableScanDesc)op.getConf()).setRowLimit(1);
            qb.addAlias(DUMMY_TABLE);
            qb.setTabAlias(DUMMY_TABLE, DUMMY_TABLE);
            aliasToOpInfo.put(DUMMY_TABLE, op);
        }
        Operator srcOpInfo = null;
        Operator lastPTFOp = null;
        if (this.queryProperties.hasPTF() && (ptfNodeToSpec = qb.getPTFNodeToSpec()) != null) {
            for (Map.Entry entry : ptfNodeToSpec.entrySet()) {
                ASTNode ast = (ASTNode)entry.getKey();
                PTFInvocationSpec spec = (PTFInvocationSpec)entry.getValue();
                String inputAlias = spec.getQueryInputName();
                Operator inOp = (Operator)aliasToOpInfo.get(inputAlias);
                if (inOp == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Cannot resolve input Operator for PTF invocation"));
                }
                lastPTFOp = this.genPTFPlan(spec, inOp);
                String ptfAlias = spec.getFunction().getAlias();
                if (ptfAlias == null) continue;
                aliasToOpInfo.put(ptfAlias, lastPTFOp);
            }
        }
        this.genLateralViewPlans(aliasToOpInfo, qb);
        if (qb.getParseInfo().getJoinExpr() != null) {
            QBJoinTree joinTree;
            ASTNode joinExpr = qb.getParseInfo().getJoinExpr();
            if (joinExpr.getToken().getType() == 997) {
                joinTree = this.genUniqueJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
            } else {
                joinTree = this.genJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
                Set<String> set = qb.getParseInfo().getClauseNames();
                if (set.size() == 1 && joinTree.getNoOuterJoin()) {
                    String dest = set.iterator().next();
                    ASTNode whereClause = qb.getParseInfo().getWhrForClause(dest);
                    if (whereClause != null) {
                        this.extractJoinCondsFromWhereClause(joinTree, qb, dest, (ASTNode)whereClause.getChild(0), aliasToOpInfo);
                    }
                }
                if (!this.disableJoinMerge) {
                    this.mergeJoinTree(qb);
                }
            }
            this.pushJoinFilters(qb, qb.getQbJoinTree(), aliasToOpInfo);
            srcOpInfo = this.genJoinPlan(qb, aliasToOpInfo);
        } else {
            srcOpInfo = (Operator)aliasToOpInfo.values().iterator().next();
            srcOpInfo = lastPTFOp != null ? lastPTFOp : srcOpInfo;
        }
        Operator bodyOpInfo = this.genBodyPlan(qb, srcOpInfo, aliasToOpInfo);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Plan for Query Block " + qb.getId());
        }
        if (qb.getAlias() != null) {
            this.rewriteRRForSubQ(qb.getAlias(), bodyOpInfo, skipAmbiguityCheck);
        }
        this.setQB(qb);
        return bodyOpInfo;
    }

    private void rewriteRRForSubQ(String alias, Operator operator, boolean skipAmbiguityCheck) throws SemanticException {
        RowResolver rr = this.opParseCtx.get(operator).getRowResolver();
        RowResolver newRR = new RowResolver();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            String name = colInfo.getInternalName();
            String[] tmp = rr.reverseLookup(name);
            if ("".equals(tmp[0]) || tmp[1] == null) {
                tmp[1] = colInfo.getInternalName();
            } else if (newRR.get(alias, tmp[1]) != null) {
                if (!skipAmbiguityCheck) {
                    throw new SemanticException(ErrorMsg.AMBIGUOUS_COLUMN.getMsg(tmp[1] + " in " + alias));
                }
                tmp[1] = colInfo.getInternalName();
            }
            newRR.put(alias, tmp[1], colInfo);
        }
        this.opParseCtx.get(operator).setRowResolver(newRR);
    }

    private Table getDummyTable() throws SemanticException {
        Path dummyPath = this.createDummyFile();
        Table desc = new Table(DUMMY_DATABASE, DUMMY_TABLE);
        desc.getTTable().getSd().setLocation(dummyPath.toString());
        desc.getTTable().getSd().getSerdeInfo().setSerializationLib(NullStructSerDe.class.getName());
        desc.setInputFormatClass(NullRowsInputFormat.class);
        desc.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        return desc;
    }

    private Path createDummyFile() throws SemanticException {
        Path dummyPath = new Path(this.ctx.getMRScratchDir(), "dummy_path");
        Path dummyFile = new Path(dummyPath, "dummy_file");
        FSDataOutputStream fout = null;
        try {
            FileSystem fs = dummyFile.getFileSystem((Configuration)this.conf);
            if (fs.exists(dummyFile)) {
                Path path = dummyPath;
                return path;
            }
            fout = fs.create(dummyFile);
            fout.write(1);
            fout.close();
            IOUtils.closeStream((Closeable)fout);
        }
        catch (IOException e) {
            throw new SemanticException(e);
        }
        finally {
            IOUtils.closeStream(fout);
        }
        return dummyPath;
    }

    void genLateralViewPlans(Map<String, Operator> aliasToOpInfo, QB qb) throws SemanticException {
        Map<String, ArrayList<ASTNode>> aliasToLateralViews = qb.getParseInfo().getAliasToLateralViews();
        for (Map.Entry<String, Operator> e : aliasToOpInfo.entrySet()) {
            String alias = e.getKey();
            ArrayList<ASTNode> lateralViews = aliasToLateralViews.get(alias);
            if (lateralViews == null) continue;
            Operator op = e.getValue();
            for (ASTNode lateralViewTree : aliasToLateralViews.get(alias)) {
                Operator lateralViewJoin;
                op = lateralViewJoin = this.genLateralViewPlan(qb, op, lateralViewTree);
            }
            e.setValue(op);
        }
    }

    private Operator genLateralViewPlanForDest(String dest, QB qb, Operator op) throws SemanticException {
        ASTNode lateralViewTree = qb.getParseInfo().getDestToLateralView().get(dest);
        if (lateralViewTree != null) {
            return this.genLateralViewPlan(qb, op, lateralViewTree);
        }
        return op;
    }

    private Operator genLateralViewPlan(QB qb, Operator op, ASTNode lateralViewTree) throws SemanticException {
        RowResolver lvForwardRR = new RowResolver();
        RowResolver source = this.opParseCtx.get(op).getRowResolver();
        HashMap<String, ExprNodeDesc> lvfColExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> selColExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnInfo col : source.getColumnInfos()) {
            String[] tabCol = source.reverseLookup(col.getInternalName());
            lvForwardRR.put(tabCol[0], tabCol[1], col);
            ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(col);
            colList.add(colExpr);
            colNames.add(colExpr.getName());
            lvfColExprMap.put(col.getInternalName(), colExpr);
            selColExprMap.put(col.getInternalName(), ((ExprNodeDesc)colExpr).clone());
        }
        Operator<LateralViewForwardDesc> lvForward = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewForwardDesc(), new RowSchema(lvForwardRR.getColumnInfos()), op, new Operator[0]), lvForwardRR);
        lvForward.setColumnExprMap(lvfColExprMap);
        RowResolver allPathRR = this.opParseCtx.get(lvForward).getRowResolver();
        SelectDesc sDesc = new SelectDesc(colList, colNames, false);
        sDesc.setSelStarNoCompute(true);
        Operator<SelectDesc> allPath = this.putOpInsertMap(OperatorFactory.getAndMakeChild(sDesc, new RowSchema(allPathRR.getColumnInfos()), lvForward, new Operator[0]), allPathRR);
        allPath.setColumnExprMap(selColExprMap);
        int allColumns = allPathRR.getColumnInfos().size();
        QB blankQb = new QB(null, null, false);
        Operator<?> udtfPath = this.genSelectPlan(null, (ASTNode)lateralViewTree.getChild(0), blankQb, lvForward, null, lateralViewTree.getType() == 804);
        for (String udtfAlias : blankQb.getAliases()) {
            qb.addAlias(udtfAlias);
        }
        RowResolver udtfPathRR = this.opParseCtx.get(udtfPath).getRowResolver();
        RowResolver lateralViewRR = new RowResolver();
        ArrayList<String> outputInternalColNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        this.LVmergeRowResolvers(allPathRR, lateralViewRR, colExprMap, outputInternalColNames);
        this.LVmergeRowResolvers(udtfPathRR, lateralViewRR, colExprMap, outputInternalColNames);
        Operator<LateralViewJoinDesc> lateralViewJoin = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewJoinDesc(allColumns, outputInternalColNames), new RowSchema(lateralViewRR.getColumnInfos()), allPath, udtfPath), lateralViewRR);
        lateralViewJoin.setColumnExprMap(colExprMap);
        return lateralViewJoin;
    }

    private void LVmergeRowResolvers(RowResolver source, RowResolver dest, Map<String, ExprNodeDesc> colExprMap, ArrayList<String> outputInternalColNames) {
        for (ColumnInfo c : source.getColumnInfos()) {
            String internalName = SemanticAnalyzer.getColumnInternalName(outputInternalColNames.size());
            outputInternalColNames.add(internalName);
            ColumnInfo newCol = new ColumnInfo(internalName, c.getType(), c.getTabAlias(), c.getIsVirtualCol(), c.isHiddenVirtualCol());
            String[] tableCol = source.reverseLookup(c.getInternalName());
            String tableAlias = tableCol[0];
            String colAlias = tableCol[1];
            dest.put(tableAlias, colAlias, newCol);
            colExprMap.put(internalName, new ExprNodeColumnDesc(c));
        }
    }

    public Phase1Ctx initPhase1Ctx() {
        Phase1Ctx ctx_1 = new Phase1Ctx();
        ctx_1.nextNum = 0;
        ctx_1.dest = "reduce";
        return ctx_1;
    }

    @Override
    public void init(boolean clearPartsCache) {
        QB qb;
        this.reset(clearPartsCache);
        this.qb = qb = new QB(null, null, false);
    }

    boolean analyzeCreateTable(ASTNode child) throws SemanticException {
        if (this.ast.getToken().getType() == 713) {
            child = this.analyzeCreateTable(this.ast, this.qb, null);
            if (child == null) {
                return true;
            }
        } else {
            this.queryState.setCommandType(HiveOperation.QUERY);
        }
        return false;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.analyzeInternal(ast, new PlannerContext());
    }

    private Table getTableObjectByName(String tableName) throws HiveException {
        if (!this.tabNameToTabObject.containsKey(tableName)) {
            Table table = this.db.getTable(tableName);
            this.tabNameToTabObject.put(tableName, table);
            return table;
        }
        return this.tabNameToTabObject.get(tableName);
    }

    private static void walkASTMarkTABREF(TableMask tableMask, ASTNode ast, Set<String> cteAlias, Context ctx, Hive db, Map<String, Table> tabNameToTabObject, Set<Integer> ignoredTokens) throws SemanticException {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(ast);
        LinkedHashMap<HivePrivilegeObject, MaskAndFilterInfo> basicInfos = new LinkedHashMap<HivePrivilegeObject, MaskAndFilterInfo>();
        while (!queue.isEmpty()) {
            ASTNode astNode = (ASTNode)queue.poll();
            if (astNode.getToken().getType() == 977) {
                int aliasIndex = 0;
                StringBuffer additionalTabInfo = new StringBuffer();
                for (int index = 1; index < astNode.getChildCount(); ++index) {
                    ASTNode ct = (ASTNode)astNode.getChild(index);
                    if (ct.getToken().getType() == 956 || ct.getToken().getType() == 972 || ct.getToken().getType() == 961) {
                        additionalTabInfo.append(ctx.getTokenRewriteStream().toString(ct.getTokenStartIndex(), ct.getTokenStopIndex()));
                        continue;
                    }
                    aliasIndex = index;
                }
                ASTNode tableTree = (ASTNode)astNode.getChild(0);
                String tabIdName = SemanticAnalyzer.getUnescapedName(tableTree);
                String alias = aliasIndex != 0 ? SemanticAnalyzer.unescapeIdentifier(astNode.getChild(aliasIndex).getText()) : SemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
                if (cteAlias.contains(tabIdName)) continue;
                Object replacementText = null;
                Table table = null;
                try {
                    if (!tabNameToTabObject.containsKey(tabIdName)) {
                        table = db.getTable(tabIdName, true);
                        tabNameToTabObject.put(tabIdName, table);
                    } else {
                        table = tabNameToTabObject.get(tabIdName);
                    }
                }
                catch (HiveException e) {
                    STATIC_LOG.debug("Table " + tabIdName + " is not found in walkASTMarkTABREF.");
                    continue;
                }
                ArrayList<String> colNames = new ArrayList<String>();
                ArrayList<String> colTypes = new ArrayList<String>();
                for (FieldSchema col : table.getAllCols()) {
                    colNames.add(col.getName());
                    colTypes.add(col.getType());
                }
                basicInfos.put(new HivePrivilegeObject(table.getDbName(), table.getTableName(), colNames), new MaskAndFilterInfo(colTypes, additionalTabInfo.toString(), alias, astNode, table.isView()));
            }
            if (astNode.getChildCount() <= 0 || ignoredTokens.contains(astNode.getToken().getType())) continue;
            for (Node child : astNode.getChildren()) {
                queue.offer(child);
            }
        }
        ArrayList<HivePrivilegeObject> basicPrivObjs = new ArrayList<HivePrivilegeObject>();
        basicPrivObjs.addAll(basicInfos.keySet());
        List<HivePrivilegeObject> needRewritePrivObjs = tableMask.applyRowFilterAndColumnMasking(basicPrivObjs);
        if (needRewritePrivObjs != null && !needRewritePrivObjs.isEmpty()) {
            for (HivePrivilegeObject privObj : needRewritePrivObjs) {
                MaskAndFilterInfo info;
                String replacementText = tableMask.create(privObj, info = (MaskAndFilterInfo)basicInfos.get(privObj));
                if (replacementText == null) continue;
                if (ctx.getIsUpdateDeleteMerge()) {
                    throw new SemanticException(ErrorMsg.MASKING_FILTERING_ON_ACID_NOT_SUPPORTED, privObj.getDbname(), privObj.getObjectName());
                }
                tableMask.setNeedsRewrite(true);
                tableMask.addTranslation(info.astNode, replacementText);
            }
        }
    }

    protected static ASTNode rewriteASTWithMaskAndFilter(TableMask tableMask, ASTNode ast, TokenRewriteStream tokenRewriteStream, Context ctx, Hive db, Map<String, Table> tabNameToTabObject, Set<Integer> ignoredTokens) throws SemanticException {
        HashSet<String> cteAlias = new HashSet<String>();
        if (ast.getChildCount() > 0 && 717 == ((ASTNode)ast.getChild(0)).getToken().getType()) {
            int index;
            ASTNode cte = (ASTNode)ast.getChild(0);
            for (index = cte.getChildCount() - 1; index >= 0; --index) {
                ASTNode subq = (ASTNode)cte.getChild(index);
                String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
                if (cteAlias.contains(alias)) {
                    throw new SemanticException("Duplicate definition of " + alias);
                }
                cteAlias.add(alias);
                SemanticAnalyzer.walkASTMarkTABREF(tableMask, subq, cteAlias, ctx, db, tabNameToTabObject, ignoredTokens);
            }
            for (index = 1; index < ast.getChildCount(); ++index) {
                SemanticAnalyzer.walkASTMarkTABREF(tableMask, (ASTNode)ast.getChild(index), cteAlias, ctx, db, tabNameToTabObject, ignoredTokens);
            }
        } else {
            SemanticAnalyzer.walkASTMarkTABREF(tableMask, ast, cteAlias, ctx, db, tabNameToTabObject, ignoredTokens);
        }
        if (tableMask.needsRewrite()) {
            ASTNode rewrittenTree;
            tableMask.applyTranslations(tokenRewriteStream);
            String rewrittenQuery = tokenRewriteStream.toString(ast.getTokenStartIndex(), ast.getTokenStopIndex());
            ParseDriver pd = new ParseDriver();
            try {
                rewrittenTree = ParseUtils.parse(rewrittenQuery);
            }
            catch (ParseException e) {
                throw new SemanticException(e);
            }
            return rewrittenTree;
        }
        return ast;
    }

    /*
     * Unable to fully structure code
     */
    boolean genResolvedParseTree(ASTNode ast, PlannerContext plannerCtx) throws SemanticException {
        child = ast;
        this.ast = ast;
        this.viewsExpanded = new ArrayList<E>();
        this.ctesExpanded = new ArrayList<E>();
        if (ast.getToken().getType() == 713) {
            child = this.analyzeCreateTable(ast, this.qb, plannerCtx);
            if (child == null) {
                return false;
            }
        } else {
            this.queryState.setCommandType(HiveOperation.QUERY);
        }
        if (ast.getToken().getType() == 714 || ast.getToken().getType() == 715 || ast.getToken().getType() == 686 && ast.getChild(1).getType() == 876) {
            child = this.analyzeCreateView(ast, this.qb, plannerCtx);
            if (child == null) {
                return false;
            }
            this.viewSelect = child;
            this.viewsExpanded.add(this.createVwDesc.getViewName());
        }
        switch (ast.getToken().getType()) {
            case 907: {
                if (!SemanticAnalyzer.$assertionsDisabled && ast.getChildCount() != 1) {
                    throw new AssertionError();
                }
                if (ast.getChild(0).getType() != 989) ** GOTO lbl25
                this.setAutoCommitValue(true);
                ** GOTO lbl30
lbl25:
                // 1 sources

                if (ast.getChild(0).getType() != 756) ** GOTO lbl28
                this.setAutoCommitValue(false);
                ** GOTO lbl30
lbl28:
                // 1 sources

                if (!SemanticAnalyzer.$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected child of TOK_SET_AUTOCOMMIT: " + ast.getChild(0).getType()));
                }
            }
lbl30:
            // 5 sources

            case 706: 
            case 896: 
            case 935: {
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEZ_TEST)) {
                    throw new IllegalStateException((Object)SemanticAnalyzerFactory.getOperation(ast.getToken().getType()) + " is not supported yet.");
                }
                this.queryState.setCommandType(SemanticAnalyzerFactory.getOperation(ast.getToken().getType()));
                return false;
            }
        }
        this.tableMask = new TableMask(this, this.conf, this.ctx.isSkipTableMasking());
        ctx_1 = this.initPhase1Ctx();
        this.preProcessForInsert(child, this.qb);
        if (!this.doPhase1(child, this.qb, ctx_1, plannerCtx)) {
            return false;
        }
        this.LOG.info("Completed phase 1 of Semantic Analysis");
        this.getMetaData(this.qb, this.createVwDesc == null);
        this.LOG.info("Completed getting MetaData in Semantic Analysis");
        plannerCtx.setParseTreeAttr(child, ctx_1);
        return true;
    }

    private void preProcessForInsert(ASTNode node, QB qb) throws SemanticException {
        try {
            if (node == null || node.getToken() == null || node.getToken().getType() != 876) {
                return;
            }
            for (Node child : node.getChildren()) {
                String[] dbTab;
                Table t;
                Path tablePath;
                ASTNode n;
                if (((ASTNode)child).getToken().getType() != 782 || (n = (ASTNode)((ASTNode)child).getFirstChildWithType(783)) == null || (n = (ASTNode)n.getFirstChildWithType(948)) == null || (n = (ASTNode)n.getFirstChildWithType(976)) == null || !this.isPathEncrypted(tablePath = (t = this.db.getTable((dbTab = SemanticAnalyzer.getQualifiedTableName(n))[0], dbTab[1])).getPath())) continue;
                qb.addEncryptedTargetTablePath(tablePath);
            }
        }
        catch (Exception ex) {
            throw new SemanticException(ex);
        }
    }

    Operator genOPTree(ASTNode ast, PlannerContext plannerCtx) throws SemanticException {
        return this.genPlan(this.qb);
    }

    void analyzeInternal(ASTNode ast, PlannerContext plannerCtx) throws SemanticException {
        boolean isColumnInfoNeedForAuth;
        ASTNode tree;
        this.LOG.info("Starting Semantic Analysis");
        this.processPositionAlias(ast);
        if (!this.genResolvedParseTree(ast, plannerCtx)) {
            return;
        }
        Operator sinkOp = this.genOPTree(ast, plannerCtx);
        if (!this.unparseTranslator.isEnabled() && this.tableMask.isEnabled() && (tree = SemanticAnalyzer.rewriteASTWithMaskAndFilter(this.tableMask, ast, this.ctx.getTokenRewriteStream(), this.ctx, this.db, this.tabNameToTabObject, this.ignoredTokens)) != ast) {
            this.ctx.setSkipTableMasking(true);
            this.init(true);
            this.processPositionAlias(tree);
            this.genResolvedParseTree(tree, plannerCtx);
            if (this instanceof CalcitePlanner) {
                ((CalcitePlanner)this).resetCalciteConfiguration();
            }
            sinkOp = this.genOPTree(tree, plannerCtx);
        }
        if (this.createVwDesc != null && !this.ctx.isCboSucceeded()) {
            this.resultSchema = SemanticAnalyzer.convertRowSchemaToViewSchema(this.opParseCtx.get(sinkOp).getRowResolver());
        } else if (this.resultSchema == null) {
            this.resultSchema = SemanticAnalyzer.convertRowSchemaToResultSetSchema(this.opParseCtx.get(sinkOp).getRowResolver(), HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
        }
        this.copyInfoToQueryProperties(this.queryProperties);
        ParseContext pCtx = new ParseContext(this.queryState, this.opToPartPruner, this.opToPartList, this.topOps, new HashSet<JoinOperator>(this.joinContext.keySet()), new HashSet<SMBMapJoinOperator>(this.smbMapJoinContext.keySet()), this.loadTableWork, this.loadFileWork, this.columnStatsAutoGatherContexts, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.prunedPartitions, this.tabNameToTabObject, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.analyzeRewrite, this.tableDesc, this.createVwDesc, this.queryProperties, this.viewProjectToTableSchema, this.acidFileSinks);
        if (this.createVwDesc != null) {
            if (this.ctx.getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
                return;
            }
            if (!this.ctx.isCboSucceeded()) {
                this.saveViewDefinition();
            }
            this.validateCreateView();
            if (!this.createVwDesc.isMaterialized()) {
                this.ctx.setResDir(null);
                this.ctx.setResFile(null);
                try {
                    PlanUtils.addInputsForView(pCtx);
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                HashSet<String> postExecHooks = Sets.newHashSet(Splitter.on(",").trimResults().omitEmptyStrings().split(Strings.nullToEmpty(HiveConf.getVar(this.conf, HiveConf.ConfVars.POSTEXECHOOKS))));
                if (postExecHooks.contains("org.apache.hadoop.hive.ql.hooks.PostExecutePrinter") || postExecHooks.contains("org.apache.hadoop.hive.ql.hooks.LineageLogger") || postExecHooks.contains("org.apache.atlas.hive.hook.HiveHook")) {
                    ArrayList<Transform> transformations = new ArrayList<Transform>();
                    transformations.add(new HiveOpConverterPostProc());
                    transformations.add(new Generator());
                    for (Transform t : transformations) {
                        pCtx = t.transform(pCtx);
                    }
                    SessionState.get().getLineageState().mapDirToOp(new Path(this.createVwDesc.getViewName()), sinkOp);
                }
                return;
            }
        }
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_TABLEKEYS)) {
            TableAccessAnalyzer tableAccessAnalyzer = new TableAccessAnalyzer(pCtx);
            this.setTableAccessInfo(tableAccessAnalyzer.analyzeTableAccess());
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Before logical optimization\n" + Operator.toString(pCtx.getTopOps().values()));
        }
        Optimizer optm = new Optimizer();
        optm.setPctx(pCtx);
        optm.initialize(this.conf);
        pCtx = optm.optimize();
        if (pCtx.getColumnAccessInfo() != null) {
            this.setColumnAccessInfo(pCtx.getColumnAccessInfo());
        }
        FetchTask origFetchTask = pCtx.getFetchTask();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("After logical optimization\n" + Operator.toString(pCtx.getTopOps().values()));
        }
        boolean bl = isColumnInfoNeedForAuth = SessionState.get().isAuthorizationModeV2() && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED);
        if (isColumnInfoNeedForAuth || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            ColumnAccessAnalyzer columnAccessAnalyzer = new ColumnAccessAnalyzer(pCtx);
            this.setColumnAccessInfo(columnAccessAnalyzer.analyzeColumnAccess(this.getColumnAccessInfo()));
        }
        if (!this.ctx.getExplainLogical()) {
            TaskCompiler compiler = TaskCompilerFactory.getCompiler(this.conf, pCtx);
            compiler.init(this.queryState, this.console, this.db);
            compiler.compile(pCtx, this.rootTasks, this.inputs, this.outputs);
            this.fetchTask = pCtx.getFetchTask();
        }
        this.LOG.info("Completed plan generation");
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            this.putAccessedColumnsToReadEntity(this.inputs, this.columnAccessInfo);
        }
        if (!this.ctx.isExplainSkipExecution()) {
            this.enforceScanLimits(pCtx, origFetchTask);
        }
    }

    private void putAccessedColumnsToReadEntity(HashSet<ReadEntity> inputs, ColumnAccessInfo columnAccessInfo) {
        Map<String, List<String>> tableToColumnAccessMap = columnAccessInfo.getTableToColumnAccessMap();
        if (tableToColumnAccessMap != null && !tableToColumnAccessMap.isEmpty()) {
            for (ReadEntity entity : inputs) {
                switch (entity.getType()) {
                    case TABLE: {
                        List<String> cols = tableToColumnAccessMap.get(entity.getTable().getCompleteName());
                        if (cols == null || cols.isEmpty()) break;
                        entity.getAccessedColumns().addAll(cols);
                        break;
                    }
                    case PARTITION: {
                        List<String> cols = tableToColumnAccessMap.get(entity.getPartition().getTable().getCompleteName());
                        if (cols == null || cols.isEmpty()) break;
                        entity.getAccessedColumns().addAll(cols);
                        break;
                    }
                }
            }
        }
    }

    private void enforceScanLimits(ParseContext pCtx, FetchTask fTask) throws SemanticException {
        int scanLimit = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVELIMITTABLESCANPARTITION);
        if (scanLimit > -1) {
            if (fTask != null) {
                if (!((FetchWork)fTask.getWork()).isNotPartitioned() && ((FetchWork)fTask.getWork()).getLimit() == -1 && scanLimit < ((FetchWork)fTask.getWork()).getPartDir().size()) {
                    throw new SemanticException(ErrorMsg.PARTITION_SCAN_LIMIT_EXCEEDED, "" + ((FetchWork)fTask.getWork()).getPartDir().size(), "" + ((FetchWork)fTask.getWork()).getTblDesc().getTableName(), "" + scanLimit);
                }
            } else {
                for (Operator operator : this.topOps.values()) {
                    PrunedPartitionList parts;
                    TableScanOperator tsOp;
                    if (!(operator instanceof TableScanOperator) || ((TableScanDesc)(tsOp = (TableScanOperator)operator).getConf()).getIsMetadataOnly() || !(parts = pCtx.getPrunedPartitions(tsOp)).getSourceTable().isPartitioned() || parts.getPartitions().size() <= scanLimit) continue;
                    throw new SemanticException(ErrorMsg.PARTITION_SCAN_LIMIT_EXCEEDED, "" + parts.getPartitions().size(), "" + parts.getSourceTable().getTableName(), "" + scanLimit);
                }
            }
        }
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.resultSchema;
    }

    protected void saveViewDefinition() throws SemanticException {
        int derivedColCount;
        int explicitColCount;
        ArrayList<FieldSchema> derivedSchema = new ArrayList<FieldSchema>(this.resultSchema);
        ParseUtils.validateColumnNameUniqueness(derivedSchema);
        List<FieldSchema> imposedSchema = this.createVwDesc.getSchema();
        if (imposedSchema != null && (explicitColCount = imposedSchema.size()) != (derivedColCount = derivedSchema.size())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(this.viewSelect, ErrorMsg.VIEW_COL_MISMATCH.getMsg()));
        }
        if (this.createVwDesc.getViewOriginalText() == null) {
            String originalText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
            this.createVwDesc.setViewOriginalText(originalText);
        }
        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
        String expandedText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
        if (imposedSchema != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            int n = derivedSchema.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                FieldSchema fieldSchema = (FieldSchema)derivedSchema.get(i);
                fieldSchema = new FieldSchema(fieldSchema);
                derivedSchema.set(i, fieldSchema);
                sb.append(HiveUtils.unparseIdentifier(fieldSchema.getName(), this.conf));
                sb.append(" AS ");
                String imposedName = imposedSchema.get(i).getName();
                sb.append(HiveUtils.unparseIdentifier(imposedName, this.conf));
                fieldSchema.setName(imposedName);
                fieldSchema.setComment(imposedSchema.get(i).getComment());
            }
            sb.append(" FROM (");
            sb.append(expandedText);
            sb.append(") ");
            sb.append(HiveUtils.unparseIdentifier(this.createVwDesc.getViewName(), this.conf));
            expandedText = sb.toString();
        }
        if (this.createVwDesc.getPartColNames() != null) {
            List<String> partColNames = this.createVwDesc.getPartColNames();
            if (partColNames.size() > derivedSchema.size()) {
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
            }
            List partitionColumns = derivedSchema.subList(derivedSchema.size() - partColNames.size(), derivedSchema.size());
            Iterator<String> colNameIter = partColNames.iterator();
            Iterator schemaIter = partitionColumns.iterator();
            while (colNameIter.hasNext()) {
                String colName = colNameIter.next();
                FieldSchema fieldSchema = (FieldSchema)schemaIter.next();
                if (fieldSchema.getName().equals(colName)) continue;
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
            }
            if (partColNames.size() == derivedSchema.size()) {
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_TOTAL.getMsg());
            }
            this.createVwDesc.setPartCols(new ArrayList<FieldSchema>(partitionColumns));
            partitionColumns.clear();
        }
        this.createVwDesc.setSchema(derivedSchema);
        if (!this.createVwDesc.isMaterialized()) {
            this.createVwDesc.setViewExpandedText(expandedText);
        }
    }

    static List<FieldSchema> convertRowSchemaToViewSchema(RowResolver rr) throws SemanticException {
        List<FieldSchema> fieldSchema = SemanticAnalyzer.convertRowSchemaToResultSetSchema(rr, false);
        ParseUtils.validateColumnNameUniqueness(fieldSchema);
        return fieldSchema;
    }

    static List<FieldSchema> convertRowSchemaToResultSetSchema(RowResolver rr, boolean useTabAliasIfAvailable) {
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            if (colInfo.isHiddenVirtualCol()) continue;
            String[] qualifiedColName = rr.reverseLookup(colInfo.getInternalName());
            String colName = useTabAliasIfAvailable && qualifiedColName[0] != null && !qualifiedColName[0].isEmpty() ? qualifiedColName[0] + "." + qualifiedColName[1] : qualifiedColName[1];
            fieldSchemas.add(new FieldSchema(colName, colInfo.getType().getTypeName(), null));
        }
        return fieldSchemas;
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        return this.genExprNodeDesc(expr, input, true, false);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, RowResolver outerRR, Map<ASTNode, RelNode> subqueryToRelNode, boolean useCaching) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, useCaching, false);
        tcCtx.setOuterRR(outerRR);
        tcCtx.setSubqueryToRelNode(subqueryToRelNode);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, boolean useCaching) throws SemanticException {
        return this.genExprNodeDesc(expr, input, useCaching, false);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, boolean useCaching, boolean foldExpr) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, useCaching, foldExpr);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    public Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input);
        return this.genAllExprNodeDesc(expr, input, tcCtx);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        ExprNodeDesc cached = null;
        if (tcCtx.isUseCaching()) {
            cached = this.getExprNodeDescCached(expr, input);
        }
        if (cached == null) {
            Map<ASTNode, ExprNodeDesc> allExprs = this.genAllExprNodeDesc(expr, input, tcCtx);
            return allExprs.get(expr);
        }
        return cached;
    }

    private ExprNodeDesc getExprNodeDescCached(ASTNode expr, RowResolver input) throws SemanticException {
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                this.unparseTranslator.addCopyTranslation(expr, source);
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
        }
        return null;
    }

    public Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        Map<ASTNode, ExprNodeDesc> nodeOutputs = TypeCheckProcFactory.genExprNode(expr, tcCtx);
        ExprNodeDesc desc = nodeOutputs.get(expr);
        if (desc == null) {
            String errMsg = tcCtx.getError();
            if (errMsg == null) {
                errMsg = "Error in parsing ";
            }
            throw new SemanticException(errMsg);
        }
        if (desc instanceof ExprNodeColumnListDesc) {
            throw new SemanticException("TOK_ALLCOLREF is not supported in current context");
        }
        if (!this.unparseTranslator.isEnabled()) {
            return nodeOutputs;
        }
        HashMap<ExprNodeColumnDesc, String> nodeToText = new HashMap<ExprNodeColumnDesc, String>();
        ArrayList<ASTNode> fieldDescList = new ArrayList<ASTNode>();
        for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
            if (!(entry.getValue() instanceof ExprNodeColumnDesc)) {
                if (!(entry.getValue() instanceof ExprNodeFieldDesc)) continue;
                fieldDescList.add(entry.getKey());
                continue;
            }
            ASTNode node = entry.getKey();
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)entry.getValue();
            if (columnDesc.getTabAlias() == null || columnDesc.getTabAlias().length() == 0) continue;
            String[] tmp = input.reverseLookup(columnDesc.getColumn());
            if (tmp[0] != null && columnDesc.getTabAlias() != null && !tmp[0].equals(columnDesc.getTabAlias()) && tcCtx.getOuterRR() != null) {
                tmp = tcCtx.getOuterRR().reverseLookup(columnDesc.getColumn());
            }
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(tmp[0], this.conf));
            replacementText.append(".");
            replacementText.append(HiveUtils.unparseIdentifier(tmp[1], this.conf));
            nodeToText.put(columnDesc, replacementText.toString());
            this.unparseTranslator.addTranslation(node, replacementText.toString());
        }
        for (ASTNode node : fieldDescList) {
            Map<ASTNode, String> map = this.translateFieldDesc(node);
            for (Map.Entry<ASTNode, String> entry : map.entrySet()) {
                this.unparseTranslator.addTranslation(entry.getKey(), entry.getValue());
            }
        }
        return nodeOutputs;
    }

    private Map<ASTNode, String> translateFieldDesc(ASTNode node) {
        HashMap<ASTNode, String> map = new HashMap<ASTNode, String>();
        if (node.getType() == 16) {
            for (Node child : node.getChildren()) {
                map.putAll(this.translateFieldDesc((ASTNode)child));
            }
        } else if (node.getType() == 24) {
            map.put(node, HiveUtils.unparseIdentifier(node.getText(), this.conf));
        }
        return map;
    }

    @Override
    public void validate() throws SemanticException {
        Partition p;
        Table tbl;
        Entity.Type type;
        this.LOG.debug("validation start");
        for (ReadEntity readEntity : this.getInputs()) {
            type = readEntity.getType();
            if (type != Entity.Type.TABLE && type != Entity.Type.PARTITION) continue;
            tbl = readEntity.getTable();
            p = readEntity.getPartition();
            if (p != null) {
                tbl = p.getTable();
            }
            if (tbl == null || !AcidUtils.isAcidTable(tbl)) continue;
            this.acidInQuery = true;
            this.checkAcidTxnManager(tbl);
        }
        for (WriteEntity writeEntity : this.getOutputs()) {
            type = writeEntity.getType();
            if (type == Entity.Type.PARTITION || type == Entity.Type.DUMMYPARTITION) {
                String conflictingArchive;
                try {
                    Partition usedp = writeEntity.getPartition();
                    Table tbl2 = usedp.getTable();
                    this.LOG.debug("validated " + usedp.getName());
                    this.LOG.debug(usedp.getTable().getTableName());
                    conflictingArchive = ArchiveUtils.conflictingArchiveNameOrNull(this.db, tbl2, usedp.getSpec());
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                if (conflictingArchive != null) {
                    String message = String.format("Insert conflict with existing archive: %s", conflictingArchive);
                    throw new SemanticException(message);
                }
            }
            if (type != Entity.Type.TABLE && type != Entity.Type.PARTITION) {
                this.LOG.debug("not validating writeEntity, because entity is neither table nor partition");
                continue;
            }
            if (type == Entity.Type.PARTITION) {
                Partition inputPartition = writeEntity.getPartition();
                try {
                    p = Hive.get().getPartition(inputPartition.getTable(), inputPartition.getSpec(), false);
                    if (p != null) {
                        tbl = p.getTable();
                    }
                    tbl = inputPartition.getTable();
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
            } else {
                this.LOG.debug("Not a partition.");
                tbl = writeEntity.getTable();
            }
            if (tbl == null || !AcidUtils.isAcidTable(tbl)) continue;
            this.acidInQuery = true;
            this.checkAcidTxnManager(tbl);
        }
        boolean reworkMapredWork = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_REWORK_MAPREDWORK);
        for (Task rootTask : this.rootTasks) {
            this.validate(rootTask, reworkMapredWork);
        }
    }

    private void validate(Task<? extends Serializable> task, boolean reworkMapredWork) throws SemanticException {
        Utilities.reworkMapRedWork(task, reworkMapredWork, this.conf);
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.validate(childTask, reworkMapredWork);
        }
    }

    public RowResolver getRowResolver(Operator opt) {
        return this.opParseCtx.get(opt).getRowResolver();
    }

    private Map<String, String> addDefaultProperties(Map<String, String> tblProp) {
        Map<String, String> retValue = tblProp == null ? new HashMap<String, String>() : tblProp;
        String paraString = HiveConf.getVar(this.conf, HiveConf.ConfVars.NEWTABLEDEFAULTPARA);
        if (paraString != null && !paraString.isEmpty()) {
            for (String keyValuePair : paraString.split(",")) {
                String[] keyValue = keyValuePair.split("=", 2);
                if (keyValue.length != 2 || retValue.containsKey(keyValue[0])) continue;
                retValue.put(keyValue[0], keyValue[1]);
            }
        }
        return retValue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    ASTNode analyzeCreateTable(ASTNode ast, QB qb, PlannerContext plannerCtx) throws SemanticException {
        qualifiedTabName = SemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        dbDotTab = SemanticAnalyzer.getDotName(qualifiedTabName);
        likeTableName = null;
        cols = new ArrayList<E>();
        partCols = new ArrayList<E>();
        bucketCols = new ArrayList<E>();
        primaryKeys = new ArrayList<SQLPrimaryKey>();
        foreignKeys = new ArrayList<SQLForeignKey>();
        sortCols = new ArrayList<E>();
        numBuckets = -1;
        comment = null;
        location = null;
        tblProps /* !! */  = null;
        ifNotExists = false;
        isExt = false;
        isTemporary = false;
        isMaterialization = false;
        selectStmt = null;
        CREATE_TABLE = false;
        CTLT = true;
        CTAS = 2;
        command_type = 0;
        skewedColNames /* !! */  = new ArrayList<String>();
        skewedValues = new ArrayList<List<String>>();
        listBucketColValuesMapping = new HashMap<K, V>();
        storedAsDirs = false;
        isUserStorageFormat = false;
        rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams(this);
        storageFormat = new StorageFormat(this.conf);
        this.LOG.info("Creating table " + dbDotTab + " position=" + ast.getCharPositionInLine());
        numCh = ast.getChildCount();
        block30: for (num = 1; num < numCh; ++num) {
            child = (ASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) {
                isUserStorageFormat = true;
                continue;
            }
            switch (child.getToken().getType()) {
                case 777: {
                    ifNotExists = true;
                    continue block30;
                }
                case 115: {
                    isExt = true;
                    continue block30;
                }
                case 284: {
                    isTemporary = true;
                    isMaterialization = "$MATERIALIZATION".equals(child.getText());
                    continue block30;
                }
                case 808: {
                    if (child.getChildCount() <= 0) continue block30;
                    likeTableName = SemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(0));
                    if (likeTableName != null) {
                        if (command_type == 2) {
                            throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols.size() != 0) {
                            throw new SemanticException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    command_type = 1;
                    continue block30;
                }
                case 876: {
                    if (command_type == 1) {
                        throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols.size() != 0) {
                        throw new SemanticException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols.size() != 0 || bucketCols.size() != 0) {
                        dynPart = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING);
                        if (!dynPart) {
                            throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                        }
                        throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (isExt) {
                        throw new SemanticException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    command_type = 2;
                    if (plannerCtx != null) {
                        plannerCtx.setCTASToken(child);
                    }
                    selectStmt = child;
                    continue block30;
                }
                case 951: {
                    cols = SemanticAnalyzer.getColumns(child, true, primaryKeys, foreignKeys);
                    continue block30;
                }
                case 957: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block30;
                }
                case 960: {
                    partCols = SemanticAnalyzer.getColumns((ASTNode)child.getChild(0), false);
                    continue block30;
                }
                case 661: {
                    bucketCols = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    if (child.getChildCount() == 2) {
                        numBuckets = Integer.parseInt(child.getChild(1).getText());
                        continue block30;
                    }
                    sortCols = this.getColumnNamesOrder((ASTNode)child.getChild(1));
                    numBuckets = Integer.parseInt(child.getChild(2).getText());
                    continue block30;
                }
                case 964: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block30;
                }
                case 959: {
                    location = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    this.inputs.add(this.toReadEntity(location));
                    continue block30;
                }
                case 961: {
                    tblProps /* !! */  = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block30;
                }
                case 970: {
                    child = (ASTNode)child.getChild(0);
                    storageFormat.setSerde(SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block30;
                    SemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block30;
                }
                case 971: {
                    hiveConf = SessionState.get().getConf();
                    skewedColNames /* !! */  = this.analyzeSkewedTablDDLColNames(skewedColNames /* !! */ , child);
                    this.analyzeDDLSkewedValues(skewedValues, child);
                    storedAsDirs = this.analyzeStoredAdDirs(child);
                    continue block30;
                }
                default: {
                    throw new AssertionError((Object)("Unknown token: " + child.getToken()));
                }
            }
        }
        if (command_type == 0 || command_type == 1) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE);
        } else if (command_type == 2) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE_AS_SELECT);
        } else {
            throw new SemanticException("Unrecognized command.");
        }
        storageFormat.fillDefaultStorageFormat(isExt, false);
        if (ifNotExists) {
            try {
                table = this.getTable(qualifiedTabName, false);
                if (table != null) {
                    return null;
                }
            }
            catch (HiveException e) {
                throw new IllegalStateException("Unexpected Exception thrown: " + e.getMessage(), e);
            }
        }
        this.addDbAndTabToOutputs(qualifiedTabName, TableType.MANAGED_TABLE);
        if (isTemporary) {
            if (partCols.size() > 0) {
                throw new SemanticException("Partition columns are not supported on temporary tables");
            }
            if (location == null) {
                try {
                    path = new Path(SessionState.getTempTableSpace(this.conf), UUID.randomUUID().toString());
                    path = Warehouse.getDnsPath(path, this.conf);
                    location = path.toString();
                }
                catch (MetaException err) {
                    throw new SemanticException("Error while generating temp table path:", err);
                }
            }
        }
        switch (command_type) {
            case 0: {
                tblProps /* !! */  = this.addDefaultProperties(tblProps /* !! */ );
                crtTblDesc = new CreateTableDesc(dbDotTab, isExt, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.collItemDelim, rowFormatParams.mapKeyDelim, rowFormatParams.lineDelim, comment, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps(), tblProps /* !! */ , ifNotExists, skewedColNames /* !! */ , skewedValues, primaryKeys, foreignKeys);
                crtTblDesc.setStoredAsSubDirectories(storedAsDirs);
                crtTblDesc.setNullFormat(rowFormatParams.nullFormat);
                crtTblDesc.validate(this.conf);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblDesc), this.conf, new Task[0]));
                break;
            }
            case 1: {
                tblProps /* !! */  = this.addDefaultProperties(tblProps /* !! */ );
                if (isTemporary && (likeTable = this.getTable(likeTableName, false)) != null && likeTable.getPartCols().size() > 0) {
                    throw new SemanticException("Partition columns are not supported on temporary tables and source table in CREATE TABLE LIKE is partitioned.");
                }
                crtTblLikeDesc = new CreateTableLikeDesc(dbDotTab, isExt, isTemporary, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getSerdeProps(), tblProps /* !! */ , ifNotExists, likeTableName, isUserStorageFormat);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblLikeDesc), this.conf, new Task[0]));
                break;
            }
            case 2: {
                if (isTemporary) {
                    if (!this.ctx.isExplainSkipExecution() && !isMaterialization) {
                        dbName = qualifiedTabName[0];
                        tblName = qualifiedTabName[1];
                        ss = SessionState.get();
                        if (ss == null) {
                            throw new SemanticException("No current SessionState, cannot create temporary table " + dbName + "." + tblName);
                        }
                        tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName);
                        if (tables != null && tables.containsKey(tblName)) {
                            throw new SemanticException("Temporary table " + dbName + "." + tblName + " already exists");
                        }
                    }
                } else {
                    try {
                        dumpTable = this.db.newTable(dbDotTab);
                        if (null != this.db.getTable(dumpTable.getDbName(), dumpTable.getTableName(), false) && !this.ctx.isExplainSkipExecution()) {
                            throw new SemanticException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(dbDotTab));
                        }
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                }
                if (location == null || location.length() == 0) ** GOTO lbl201
                locPath = new Path(location);
                curFs = null;
                locStats = null;
                try {
                    curFs = locPath.getFileSystem((Configuration)this.conf);
                    if (curFs != null) {
                        locStats = curFs.getFileStatus(locPath);
                    }
                    if (locStats != null && locStats.isDir() && (lStats = curFs.listStatus(locPath)) != null && lStats.length != 0) {
                        for (FileStatus lStat : lStats) {
                            if (lStat.getPath().getName().startsWith(HiveConf.getVar(this.conf, HiveConf.ConfVars.STAGINGDIR))) continue;
                            throw new SemanticException(ErrorMsg.CTAS_LOCATION_NONEMPTY.getMsg(location));
                        }
                    }
                }
                catch (FileNotFoundException lStats) {
                }
                catch (IOException ioE) {
                    if (!this.LOG.isDebugEnabled()) ** GOTO lbl201
                    this.LOG.debug("Exception when validate folder ", (Throwable)ioE);
                }
lbl201:
                // 5 sources

                tblProps /* !! */  = this.addDefaultProperties(tblProps /* !! */ );
                this.tableDesc = new CreateTableDesc(qualifiedTabName[0], dbDotTab, isExt, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.collItemDelim, rowFormatParams.mapKeyDelim, rowFormatParams.lineDelim, comment, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps(), tblProps /* !! */ , ifNotExists, skewedColNames /* !! */ , skewedValues, true, primaryKeys, foreignKeys);
                this.tableDesc.setMaterialization(isMaterialization);
                this.tableDesc.setStoredAsSubDirectories(storedAsDirs);
                this.tableDesc.setNullFormat(rowFormatParams.nullFormat);
                qb.setTableDesc(this.tableDesc);
                return selectStmt;
            }
            default: {
                throw new SemanticException("Unrecognized command.");
            }
        }
        return null;
    }

    private void addDbAndTabToOutputs(String[] qualifiedTabName, TableType type) throws SemanticException {
        Database database = this.getDatabase(qualifiedTabName[0]);
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_SHARED));
        Table t = new Table(qualifiedTabName[0], qualifiedTabName[1]);
        t.setTableType(type);
        this.outputs.add(new WriteEntity(t, WriteEntity.WriteType.DDL_NO_LOCK));
    }

    protected ASTNode analyzeCreateView(ASTNode ast, QB qb, PlannerContext plannerCtx) throws SemanticException {
        String[] qualTabName = SemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String dbDotTable = SemanticAnalyzer.getDotName(qualTabName);
        List<FieldSchema> cols = null;
        boolean ifNotExists = false;
        boolean rewriteEnabled = false;
        boolean orReplace = false;
        boolean isAlterViewAs = false;
        String comment = null;
        ASTNode selectStmt = null;
        HashMap<String, String> tblProps = null;
        List<String> partColNames = null;
        boolean isMaterialized = ast.getToken().getType() == 715;
        String location = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams(this);
        StorageFormat storageFormat = new StorageFormat(this.conf);
        this.LOG.info("Creating view " + dbDotTable + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        block13: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) continue;
            switch (child.getToken().getType()) {
                case 777: {
                    ifNotExists = true;
                    continue block13;
                }
                case 893: {
                    rewriteEnabled = true;
                    continue block13;
                }
                case 852: {
                    orReplace = true;
                    continue block13;
                }
                case 876: {
                    if (plannerCtx != null) {
                        plannerCtx.setViewToken(child);
                    }
                    selectStmt = child;
                    continue block13;
                }
                case 952: {
                    cols = this.getColumns(child);
                    continue block13;
                }
                case 957: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block13;
                }
                case 961: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block13;
                }
                case 1010: {
                    partColNames = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    continue block13;
                }
                case 964: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block13;
                }
                case 959: {
                    location = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    this.inputs.add(this.toReadEntity(location));
                    continue block13;
                }
                case 970: {
                    child = (ASTNode)child.getChild(0);
                    storageFormat.setSerde(SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block13;
                    SemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block13;
                }
                default: {
                    assert (false);
                    continue block13;
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(false, isMaterialized);
        if (ifNotExists && orReplace) {
            throw new SemanticException("Can't combine IF NOT EXISTS and OR REPLACE.");
        }
        if (ast.getToken().getType() == 686 && ast.getChild(1).getType() == 876) {
            isAlterViewAs = true;
            orReplace = true;
        }
        this.unparseTranslator.enable();
        if (isMaterialized) {
            this.createVwDesc = new CreateViewDesc(dbDotTable, cols, comment, tblProps, partColNames, ifNotExists, orReplace, rewriteEnabled, isAlterViewAs, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps());
            this.addDbAndTabToOutputs(qualTabName, TableType.MATERIALIZED_VIEW);
            this.queryState.setCommandType(HiveOperation.CREATE_MATERIALIZED_VIEW);
        } else {
            this.createVwDesc = new CreateViewDesc(dbDotTable, cols, comment, tblProps, partColNames, ifNotExists, orReplace, isAlterViewAs, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), storageFormat.getSerde());
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), this.createVwDesc), this.conf, new Task[0]));
            this.addDbAndTabToOutputs(qualTabName, TableType.VIRTUAL_VIEW);
            this.queryState.setCommandType(HiveOperation.CREATEVIEW);
        }
        qb.setViewDesc(this.createVwDesc);
        return selectStmt;
    }

    CreateViewDesc getCreateViewDesc() {
        return this.createVwDesc;
    }

    private void validateCreateView() throws SemanticException {
        block12: {
            try {
                Table oldView = this.getTable(this.createVwDesc.getViewName(), false);
                Set<String> tableAliases = this.qb.getTabAliases();
                for (String alias : tableAliases) {
                    try {
                        Table table = this.getTableObjectByName(this.qb.getTabNameForAlias(alias));
                        if (!table.isTemporary()) continue;
                        throw new SemanticException("View definition references temporary table " + alias);
                    }
                    catch (HiveException ex) {
                        throw new SemanticException(ex);
                    }
                }
                if (this.createVwDesc.getIsAlterViewAs() && oldView == null) {
                    String viewNotExistErrorMsg = "The following view does not exist: " + this.createVwDesc.getViewName();
                    throw new SemanticException(ErrorMsg.ALTER_VIEW_AS_SELECT_NOT_EXIST.getMsg(viewNotExistErrorMsg));
                }
                if (!this.createVwDesc.getOrReplace() || oldView == null) break block12;
                if (oldView.getTableType().equals((Object)TableType.VIRTUAL_VIEW) && this.createVwDesc.isMaterialized()) {
                    throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_MATERIALIZED, oldView.getTableName());
                }
                if (oldView.getTableType().equals((Object)TableType.MATERIALIZED_VIEW) && !this.createVwDesc.isMaterialized()) {
                    throw new SemanticException(ErrorMsg.REPLACE_MATERIALIZED_WITH_VIEW, oldView.getTableName());
                }
                if (!oldView.getTableType().equals((Object)TableType.VIRTUAL_VIEW) && !oldView.getTableType().equals((Object)TableType.MATERIALIZED_VIEW)) {
                    String tableNotViewErrorMsg = "The following is an existing table, not a view: " + this.createVwDesc.getViewName();
                    throw new SemanticException(ErrorMsg.EXISTING_TABLE_IS_NOT_VIEW.getMsg(tableNotViewErrorMsg));
                }
                if (this.createVwDesc.isMaterialized()) break block12;
                String partitionViewErrorMsg = "The following view has partition, it could not be replaced: " + this.createVwDesc.getViewName();
                try {
                    if (!(this.createVwDesc.getPartCols() != null && !this.createVwDesc.getPartCols().isEmpty() && this.createVwDesc.getPartCols().equals(oldView.getPartCols()) || oldView.getPartCols().isEmpty() || this.db.getPartitions(oldView).isEmpty())) {
                        throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), e);
            }
        }
    }

    public void processPositionAlias(ASTNode ast) throws SemanticException {
        boolean isBothByPos = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS);
        boolean isGbyByPos = isBothByPos || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_GROUPBY_POSITION_ALIAS);
        boolean isObyByPos = isBothByPos || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_ORDERBY_POSITION_ALIAS);
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
        stack.push(ast);
        while (!stack.isEmpty()) {
            ASTNode next = (ASTNode)stack.pop();
            if (next.getChildCount() == 0) continue;
            ASTNode selectNode = null;
            ASTNode groupbyNode = null;
            ASTNode orderbyNode = null;
            int child_count = next.getChildCount();
            for (int child_pos = 0; child_pos < child_count; ++child_pos) {
                ASTNode node = (ASTNode)next.getChild(child_pos);
                int type = node.getToken().getType();
                if (type == 899) {
                    selectNode = node;
                    continue;
                }
                if (type == 772) {
                    groupbyNode = node;
                    continue;
                }
                if (type != 851) continue;
                orderbyNode = node;
            }
            if (selectNode != null) {
                int selectExpCnt = selectNode.getChildCount();
                if (groupbyNode != null) {
                    for (int child_pos = 0; child_pos < groupbyNode.getChildCount(); ++child_pos) {
                        ASTNode node = (ASTNode)groupbyNode.getChild(child_pos);
                        if (node.getToken().getType() != 340) continue;
                        if (isGbyByPos) {
                            int pos = Integer.parseInt(node.getText());
                            if (pos > 0 && pos <= selectExpCnt) {
                                groupbyNode.setChild(child_pos, selectNode.getChild(pos - 1).getChild(0));
                                continue;
                            }
                            throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_GROUPBY.getMsg("Position alias: " + pos + " does not exist\n" + "The Select List is indexed from 1 to " + selectExpCnt));
                        }
                        this.warn("Using constant number  " + node.getText() + " in group by. If you try to use position alias when hive.groupby.position.alias is false, the position alias will be ignored.");
                    }
                }
                if (orderbyNode != null) {
                    int child_pos;
                    boolean isAllCol = false;
                    for (child_pos = 0; child_pos < selectNode.getChildCount(); ++child_pos) {
                        ASTNode node = (ASTNode)selectNode.getChild(child_pos).getChild(0);
                        if (node == null || node.getToken().getType() != 651) continue;
                        isAllCol = true;
                    }
                    for (child_pos = 0; child_pos < orderbyNode.getChildCount(); ++child_pos) {
                        ASTNode colNode = (ASTNode)orderbyNode.getChild(child_pos).getChild(0);
                        ASTNode node = (ASTNode)colNode.getChild(0);
                        if (node == null || node.getToken().getType() != 340) continue;
                        if (isObyByPos) {
                            if (!isAllCol) {
                                int pos = Integer.parseInt(node.getText());
                                if (pos > 0 && pos <= selectExpCnt) {
                                    colNode.setChild(0, selectNode.getChild(pos - 1).getChild(0));
                                    continue;
                                }
                                throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\n" + "The Select List is indexed from 1 to " + selectExpCnt));
                            }
                            throw new SemanticException(ErrorMsg.NO_SUPPORTED_ORDERBY_ALLCOLREF_POS.getMsg());
                        }
                        this.warn("Using constant number " + node.getText() + " in order by. If you try to use position alias when hive.orderby.position.alias is false, the position alias will be ignored.");
                    }
                }
            }
            for (int i = ((ArrayList)next.getChildren()).size() - 1; i >= 0; --i) {
                stack.push((ASTNode)((ArrayList)next.getChildren()).get(i));
            }
        }
    }

    protected void processPartialScanCommand(ASTNode tree) throws SemanticException {
        this.checkPartialScan(tree);
        if (this.partialscan) {
            this.validateAnalyzePartialscan(tree);
        }
    }

    protected void processNoScanCommand(ASTNode tree) throws SemanticException {
        this.checkNoScan(tree);
        if (this.noscan) {
            this.validateAnalyzeNoscan(tree);
        }
    }

    private void validateAnalyzeNoscan(ASTNode tree) throws SemanticException {
        Table tbl;
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        try {
            tbl = this.getTableObjectByName(tableName);
        }
        catch (InvalidTableException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), e);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_NOSCAN_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private void validateAnalyzePartialscan(ASTNode tree) throws SemanticException {
        Table tbl;
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        try {
            tbl = this.getTableObjectByName(tableName);
        }
        catch (InvalidTableException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), e);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_NON_NATIVE.getMsg(tbl.getTableName()));
        }
        if (tbl.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_EXTERNAL_TABLE.getMsg(tbl.getTableName()));
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_AUTOGATHER.getMsg());
        }
    }

    private void checkNoScan(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 948 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 976 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 191) {
            this.noscan = true;
        }
    }

    private void checkPartialScan(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 948 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 976 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 211) {
            this.partialscan = true;
        }
    }

    public QB getQB() {
        return this.qb;
    }

    public void setQB(QB qb) {
        this.qb = qb;
    }

    private PTFInvocationSpec.PTFInputSpec processPTFSource(QB qb, ASTNode inputNode) throws SemanticException {
        PTFInvocationSpec.PTFInputSpec qInSpec = null;
        int type = inputNode.getType();
        switch (type) {
            case 977: {
                String alias = this.processTable(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.TABLE);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 941: {
                String alias = this.processSubQuery(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.SUBQUERY);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 875: {
                qInSpec = this.processPTFChain(qb, inputNode);
                break;
            }
            default: {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(inputNode, "Unknown input type to PTF"));
            }
        }
        qInSpec.setAstNode(inputNode);
        return qInSpec;
    }

    private PTFInvocationSpec.PartitionedTableFunctionSpec processPTFChain(QB qb, ASTNode ptf) throws SemanticException {
        ASTNode pSpecNode;
        int child_count = ptf.getChildCount();
        if (child_count < 2) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ptf, "Not enough Children " + child_count));
        }
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = new PTFInvocationSpec.PartitionedTableFunctionSpec();
        ptfSpec.setAstNode(ptf);
        ASTNode nameNode = (ASTNode)ptf.getChild(0);
        ptfSpec.setName(nameNode.getText());
        int inputIdx = 1;
        ASTNode secondChild = (ASTNode)ptf.getChild(1);
        if (secondChild.getType() == 24) {
            ptfSpec.setAlias(secondChild.getText());
            ++inputIdx;
        }
        ASTNode inputNode = (ASTNode)ptf.getChild(inputIdx);
        ptfSpec.setInput(this.processPTFSource(qb, inputNode));
        int argStartIdx = inputIdx + 1;
        int pSpecIdx = inputIdx + 1;
        ASTNode aSTNode = pSpecNode = ptf.getChildCount() > inputIdx ? (ASTNode)ptf.getChild(pSpecIdx) : null;
        if (pSpecNode != null && pSpecNode.getType() == 853) {
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(pSpecNode);
            ptfSpec.setPartitioning(partitioning);
            ++argStartIdx;
        }
        for (int i = argStartIdx; i < ptf.getChildCount(); ++i) {
            ptfSpec.addArg((ASTNode)ptf.getChild(i));
        }
        return ptfSpec;
    }

    private void processPTF(QB qb, ASTNode ptf) throws SemanticException {
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = this.processPTFChain(qb, ptf);
        if (ptfSpec.getAlias() != null) {
            qb.addAlias(ptfSpec.getAlias());
        }
        PTFInvocationSpec spec = new PTFInvocationSpec();
        spec.setFunction(ptfSpec);
        qb.addPTFNodeToSpec(ptf, spec);
    }

    private void handleQueryWindowClauses(QB qb, Phase1Ctx ctx_1, ASTNode node) throws SemanticException {
        WindowingSpec spec = qb.getWindowingSpec(ctx_1.dest);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.processQueryWindowClause(spec, (ASTNode)node.getChild(i));
        }
    }

    private PTFInvocationSpec.PartitionSpec processPartitionSpec(ASTNode node) {
        PTFInvocationSpec.PartitionSpec pSpec = new PTFInvocationSpec.PartitionSpec();
        int exprCnt = node.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            PTFInvocationSpec.PartitionExpression exprSpec = new PTFInvocationSpec.PartitionExpression();
            exprSpec.setExpression((ASTNode)node.getChild(i));
            pSpec.addExpression(exprSpec);
        }
        return pSpec;
    }

    private PTFInvocationSpec.OrderSpec processOrderSpec(ASTNode sortNode) {
        PTFInvocationSpec.OrderSpec oSpec = new PTFInvocationSpec.OrderSpec();
        int exprCnt = sortNode.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            PTFInvocationSpec.OrderExpression exprSpec = new PTFInvocationSpec.OrderExpression();
            ASTNode orderSpec = (ASTNode)sortNode.getChild(i);
            ASTNode nullOrderSpec = (ASTNode)orderSpec.getChild(0);
            exprSpec.setExpression((ASTNode)nullOrderSpec.getChild(0));
            if (orderSpec.getType() == 978) {
                exprSpec.setOrder(PTFInvocationSpec.Order.ASC);
            } else {
                exprSpec.setOrder(PTFInvocationSpec.Order.DESC);
            }
            if (nullOrderSpec.getType() == 826) {
                exprSpec.setNullOrder(PTFInvocationSpec.NullOrder.NULLS_FIRST);
            } else {
                exprSpec.setNullOrder(PTFInvocationSpec.NullOrder.NULLS_LAST);
            }
            oSpec.addExpression(exprSpec);
        }
        return oSpec;
    }

    private PTFInvocationSpec.PartitioningSpec processPTFPartitionSpec(ASTNode pSpecNode) {
        PTFInvocationSpec.PartitioningSpec partitioning = new PTFInvocationSpec.PartitioningSpec();
        ASTNode firstChild = (ASTNode)pSpecNode.getChild(0);
        int type = firstChild.getType();
        if (type == 738 || type == 703) {
            ASTNode sortNode;
            PTFInvocationSpec.PartitionSpec pSpec = this.processPartitionSpec(firstChild);
            partitioning.setPartSpec(pSpec);
            ASTNode aSTNode = sortNode = pSpecNode.getChildCount() > 1 ? (ASTNode)pSpecNode.getChild(1) : null;
            if (sortNode != null) {
                PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(sortNode);
                partitioning.setOrderSpec(oSpec);
            }
        } else if (type == 934 || type == 851) {
            ASTNode sortNode = firstChild;
            PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(sortNode);
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    private WindowingSpec.WindowFunctionSpec processWindowFunction(ASTNode node, ASTNode wsNode) throws SemanticException {
        WindowingSpec.WindowFunctionSpec wfSpec = new WindowingSpec.WindowFunctionSpec();
        switch (node.getType()) {
            case 765: {
                wfSpec.setStar(true);
                break;
            }
            case 764: {
                wfSpec.setDistinct(true);
            }
        }
        wfSpec.setExpression(node);
        ASTNode nameNode = (ASTNode)node.getChild(0);
        wfSpec.setName(nameNode.getText());
        for (int i = 1; i < node.getChildCount() - 1; ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            wfSpec.addArg(child);
        }
        if (wsNode != null) {
            WindowingSpec.WindowSpec ws = this.processWindowSpec(wsNode);
            wfSpec.setWindowSpec(ws);
        }
        return wfSpec;
    }

    private boolean containsLeadLagUDF(ASTNode expressionTree) {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 763) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if ("lag".equals(functionName = functionName.toLowerCase()) || "lead".equals(functionName)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            if (!this.containsLeadLagUDF((ASTNode)expressionTree.getChild(i))) continue;
            return true;
        }
        return false;
    }

    private void processQueryWindowClause(WindowingSpec spec, ASTNode node) throws SemanticException {
        ASTNode nameNode = (ASTNode)node.getChild(0);
        ASTNode wsNode = (ASTNode)node.getChild(1);
        if (spec.getWindowSpecs() != null && spec.getWindowSpecs().containsKey(nameNode.getText())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(nameNode, "Duplicate definition of window " + nameNode.getText() + " is not allowed"));
        }
        WindowingSpec.WindowSpec ws = this.processWindowSpec(wsNode);
        spec.addWindowSpec(nameNode.getText(), ws);
    }

    private WindowingSpec.WindowSpec processWindowSpec(ASTNode node) throws SemanticException {
        Object sourceId = null;
        Object partition = null;
        Object order = null;
        Object windowFrame = null;
        boolean hasSrcId = false;
        boolean hasPartSpec = false;
        boolean hasWF = false;
        int srcIdIdx = -1;
        int partIdx = -1;
        int wfIdx = -1;
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            int type = node.getChild(i).getType();
            switch (type) {
                case 24: {
                    hasSrcId = true;
                    srcIdIdx = i;
                    continue block5;
                }
                case 853: {
                    hasPartSpec = true;
                    partIdx = i;
                    continue block5;
                }
                case 1015: 
                case 1017: {
                    hasWF = true;
                    wfIdx = i;
                }
            }
        }
        WindowingSpec.WindowSpec ws = new WindowingSpec.WindowSpec();
        if (hasSrcId) {
            ASTNode nameNode = (ASTNode)node.getChild(srcIdIdx);
            ws.setSourceId(nameNode.getText());
        }
        if (hasPartSpec) {
            ASTNode partNode = (ASTNode)node.getChild(partIdx);
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(partNode);
            ws.setPartitioning(partitioning);
        }
        if (hasWF) {
            ASTNode wfNode = (ASTNode)node.getChild(wfIdx);
            WindowingSpec.WindowFrameSpec wfSpec = this.processWindowFrame(wfNode);
            ws.setWindowFrame(wfSpec);
        }
        return ws;
    }

    private WindowingSpec.WindowFrameSpec processWindowFrame(ASTNode node) throws SemanticException {
        int type = node.getType();
        WindowingSpec.BoundarySpec start = null;
        WindowingSpec.BoundarySpec end = null;
        start = this.processBoundary(type, (ASTNode)node.getChild(0));
        if (node.getChildCount() > 1) {
            end = this.processBoundary(type, (ASTNode)node.getChild(1));
        }
        return new WindowingSpec.WindowFrameSpec(type == 1017 ? WindowingSpec.WindowType.RANGE : WindowingSpec.WindowType.ROWS, start, end);
    }

    private WindowingSpec.BoundarySpec processBoundary(int frameType, ASTNode node) throws SemanticException {
        WindowingSpec.BoundarySpec bs = new WindowingSpec.BoundarySpec();
        int type = node.getType();
        boolean hasAmt = true;
        switch (type) {
            case 217: {
                bs.setDirection(WindowingSpec.Direction.PRECEDING);
                break;
            }
            case 125: {
                bs.setDirection(WindowingSpec.Direction.FOLLOWING);
                break;
            }
            case 73: {
                bs.setDirection(WindowingSpec.Direction.CURRENT);
                hasAmt = false;
            }
        }
        if (hasAmt) {
            ASTNode amtNode = (ASTNode)node.getChild(0);
            if (amtNode.getType() == 298) {
                bs.setAmt(Integer.MAX_VALUE);
            } else {
                int amt = Integer.parseInt(amtNode.getText());
                if (amt <= 0) {
                    throw new SemanticException("Window Frame Boundary Amount must be a positive integer, provided amount is: " + amt);
                }
                bs.setAmt(amt);
            }
        }
        return bs;
    }

    private boolean isValidGroupBySelectList(QB currQB, String clause) {
        ConstantExprCheck constantExprCheck = new ConstantExprCheck();
        AggregationExprCheck aggrExprCheck = new AggregationExprCheck(currQB.getParseInfo().getAggregationExprsForClause(clause));
        TreeWizard tw = new TreeWizard(ParseDriver.adaptor, HiveParser.tokenNames);
        ASTNode selectNode = currQB.getParseInfo().getSelForClause(clause);
        if (selectNode != null && selectNode.getType() == 900) {
            return true;
        }
        for (int i = 0; selectNode != null && i < selectNode.getChildCount(); ++i) {
            ASTNode selectExpr = (ASTNode)selectNode.getChild(i);
            if (selectExpr.getType() != 901) continue;
            constantExprCheck.reset();
            PTFTranslator.visit(selectExpr.getChild(0), constantExprCheck);
            if (constantExprCheck.isConstant()) continue;
            aggrExprCheck.reset();
            PTFTranslator.visit(selectExpr.getChild(0), aggrExprCheck);
            if (aggrExprCheck.isAggr()) continue;
            return false;
        }
        return true;
    }

    private PTFDesc translatePTFInvocationSpec(PTFInvocationSpec ptfQSpec, RowResolver inputRR) throws SemanticException {
        PTFDesc ptfDesc = null;
        PTFTranslator translator = new PTFTranslator();
        ptfDesc = translator.translate(ptfQSpec, this, this.conf, inputRR, this.unparseTranslator);
        return ptfDesc;
    }

    Operator genPTFPlan(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        ArrayList<PTFInvocationSpec> componentQueries = PTFTranslator.componentize(ptfQSpec);
        for (PTFInvocationSpec ptfSpec : componentQueries) {
            input = this.genPTFPlanForComponentQuery(ptfSpec, input);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created PTF Plan ");
        }
        return input;
    }

    void buildPTFReduceSinkDetails(PartitionedTableFunctionDef tabDef, RowResolver inputRR, ArrayList<ExprNodeDesc> partCols, ArrayList<ExprNodeDesc> orderCols, StringBuilder orderString, StringBuilder nullOrderString) throws SemanticException {
        List<PTFExpressionDef> partColList = tabDef.getPartition().getExpressions();
        for (PTFExpressionDef colDef : partColList) {
            ExprNodeDesc exprNode = colDef.getExprNode();
            if (ExprNodeDescUtils.indexOf(exprNode, partCols) >= 0) continue;
            partCols.add(exprNode);
            orderCols.add(exprNode);
            orderString.append('+');
            nullOrderString.append('a');
        }
        List<OrderExpressionDef> orderColList = tabDef.getOrder().getExpressions();
        for (int i = 0; i < orderColList.size(); ++i) {
            OrderExpressionDef colDef = orderColList.get(i);
            char orderChar = colDef.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
            char nullOrderChar = colDef.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
            int index = ExprNodeDescUtils.indexOf(colDef.getExprNode(), orderCols);
            if (index >= 0) {
                orderString.setCharAt(index, orderChar);
                nullOrderString.setCharAt(index, nullOrderChar);
                continue;
            }
            orderCols.add(colDef.getExprNode());
            orderString.append(orderChar);
            nullOrderString.append(nullOrderChar);
        }
    }

    private Operator genPTFPlanForComponentQuery(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        PTFDesc ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        PartitionedTableFunctionDef tabDef = ptfDesc.getStartOfChain();
        if (tabDef.isTransformsRawInput()) {
            RowResolver ptfMapRR = tabDef.getRawInputShape().getRr();
            ptfDesc.setMapSide(true);
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfMapRR.getColumnInfos()), (Operator)input, new Operator[0]), ptfMapRR);
            rr = this.opParseCtx.get(input).getRowResolver();
        }
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        StringBuilder orderString = new StringBuilder();
        StringBuilder nullOrderString = new StringBuilder();
        this.buildPTFReduceSinkDetails(tabDef, rr, partCols, orderCols, orderString, nullOrderString);
        input = this.genReduceSinkPlan(input, partCols, orderCols, orderString.toString(), nullOrderString.toString(), -1, AcidUtils.Operation.NOT_ACID);
        rr = this.opParseCtx.get(input).getRowResolver();
        ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), (Operator)input, new Operator[0]), ptfOpRR);
        return input;
    }

    Operator genWindowingPlan(QB qb, WindowingSpec wSpec, Operator input) throws SemanticException {
        wSpec.validateAndMakeEffective();
        if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
            String selClauseName = qb.getParseInfo().getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
            for (WindowingSpec.WindowExpressionSpec wExprSpec : wSpec.getWindowExpressions()) {
                wExprSpec.setExpression(SemanticAnalyzer.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), selClauseName), wExprSpec.getExpression(), !cubeRollupGrpSetPresent));
            }
        }
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        while (groups.hasNext()) {
            wSpec = groups.next(this.conf, this, this.unparseTranslator, rr);
            input = this.genReduceSinkPlanForWindowing(wSpec, rr, input);
            rr = this.opParseCtx.get(input).getRowResolver();
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this, this.conf, rr, this.unparseTranslator);
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), input, new Operator[0]), ptfOpRR);
            input = this.genSelectAllDesc(input);
            rr = ptfOpRR;
        }
        return input;
    }

    private Operator genReduceSinkPlanForWindowing(WindowingSpec spec, RowResolver inputRR, Operator input) throws SemanticException {
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        for (PTFInvocationSpec.PartitionExpression partCol : spec.getQueryPartitionSpec().getExpressions()) {
            ExprNodeDesc partExpr = this.genExprNodeDesc(partCol.getExpression(), inputRR);
            if (ExprNodeDescUtils.indexOf(partExpr, partCols) >= 0) continue;
            partCols.add(partExpr);
            orderCols.add(partExpr);
            order.append('+');
            nullOrder.append('a');
        }
        if (spec.getQueryOrderSpec() != null) {
            for (PTFInvocationSpec.OrderExpression orderCol : spec.getQueryOrderSpec().getExpressions()) {
                ExprNodeDesc orderExpr = this.genExprNodeDesc(orderCol.getExpression(), inputRR);
                char orderChar = orderCol.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
                char nullOrderChar = orderCol.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
                int index = ExprNodeDescUtils.indexOf(orderExpr, orderCols);
                if (index >= 0) {
                    order.setCharAt(index, orderChar);
                    nullOrder.setCharAt(index, nullOrderChar);
                    continue;
                }
                orderCols.add(this.genExprNodeDesc(orderCol.getExpression(), inputRR));
                order.append(orderChar);
                nullOrder.append(nullOrderChar);
            }
        }
        return this.genReduceSinkPlan(input, partCols, orderCols, order.toString(), nullOrder.toString(), -1, AcidUtils.Operation.NOT_ACID);
    }

    public static ArrayList<WindowingSpec.WindowExpressionSpec> parseSelect(String selectExprStr) throws SemanticException {
        ASTNode selNode = null;
        try {
            ParseDriver pd = new ParseDriver();
            selNode = pd.parseSelect(selectExprStr, null);
        }
        catch (ParseException pe) {
            throw new SemanticException(pe);
        }
        ArrayList<WindowingSpec.WindowExpressionSpec> selSpec = new ArrayList<WindowingSpec.WindowExpressionSpec>();
        int childCount = selNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ASTNode selExpr = (ASTNode)selNode.getChild(i);
            if (selExpr.getType() != 901) {
                throw new SemanticException(String.format("Only Select expressions supported in dynamic select list: %s", selectExprStr));
            }
            ASTNode expr = (ASTNode)selExpr.getChild(0);
            if (expr.getType() == 651) {
                throw new SemanticException(String.format("'%s' column not allowed in dynamic select list", selectExprStr));
            }
            ASTNode aliasNode = selExpr.getChildCount() > 1 && selExpr.getChild(1).getType() == 24 ? (ASTNode)selExpr.getChild(1) : null;
            String alias = null;
            if (aliasNode != null) {
                alias = aliasNode.getText();
            } else {
                String[] tabColAlias = SemanticAnalyzer.getColAlias(selExpr, null, null, true, -1);
                alias = tabColAlias[1];
            }
            WindowingSpec.WindowExpressionSpec exprSpec = new WindowingSpec.WindowExpressionSpec();
            exprSpec.setAlias(alias);
            exprSpec.setExpression(expr);
            selSpec.add(exprSpec);
        }
        return selSpec;
    }

    private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, Operator<? extends OperatorDesc> reduceSinkOp, RowResolver gByRR) {
        if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 973) {
            String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
            String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
            gByRR.put(tab_alias, col_alias, colInfo);
        } else if (gByExpr.getType() == 973) {
            String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
            String tab_alias = null;
            Operator<? extends OperatorDesc> parent = reduceSinkOp;
            while (parent instanceof ReduceSinkOperator || parent instanceof GroupByOperator) {
                parent = parent.getParentOperators().get(0);
            }
            RowResolver parentRR = this.opParseCtx.get(parent).getRowResolver();
            try {
                ColumnInfo pColInfo = parentRR.get(tab_alias, col_alias);
                tab_alias = pColInfo == null ? null : pColInfo.getTabAlias();
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            gByRR.put(tab_alias, col_alias, colInfo);
        }
    }

    private WriteEntity.WriteType determineWriteType(LoadTableDesc ltd, boolean isNonNativeTable, String dest) {
        if (isNonNativeTable) {
            return WriteEntity.WriteType.INSERT_OVERWRITE;
        }
        return ltd.getReplace() ? WriteEntity.WriteType.INSERT_OVERWRITE : this.getWriteType(dest);
    }

    private WriteEntity.WriteType getWriteType(String dest) {
        return this.updating(dest) ? WriteEntity.WriteType.UPDATE : (this.deleting(dest) ? WriteEntity.WriteType.DELETE : WriteEntity.WriteType.INSERT);
    }

    private boolean isAcidOutputFormat(Class<? extends OutputFormat> of) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = of.getInterfaces()) {
            if (!iface.equals(AcidOutputFormat.class)) continue;
            return true;
        }
        return false;
    }

    private AcidUtils.Operation getAcidType(String destination) {
        return this.deleting(destination) ? AcidUtils.Operation.DELETE : (this.updating(destination) ? AcidUtils.Operation.UPDATE : AcidUtils.Operation.INSERT);
    }

    private AcidUtils.Operation getAcidType(Class<? extends OutputFormat> of, String dest) {
        if (SessionState.get() == null || !SessionState.get().getTxnMgr().supportsAcid()) {
            return AcidUtils.Operation.NOT_ACID;
        }
        if (this.isAcidOutputFormat(of)) {
            return this.getAcidType(dest);
        }
        return AcidUtils.Operation.NOT_ACID;
    }

    protected boolean updating(String destination) {
        return destination.startsWith(Context.DestClausePrefix.UPDATE.toString());
    }

    protected boolean deleting(String destination) {
        return destination.startsWith(Context.DestClausePrefix.DELETE.toString());
    }

    protected void checkAcidTxnManager(Table table) throws SemanticException {
        if (SessionState.get() != null && !SessionState.get().getTxnMgr().supportsAcid()) {
            throw new SemanticException(ErrorMsg.TXNMGR_NOT_ACID, table.getDbName(), table.getTableName());
        }
    }

    public static ASTNode genSelectDIAST(RowResolver rr) {
        LinkedHashMap<String, LinkedHashMap<String, ColumnInfo>> map = rr.getRslvMap();
        ASTNode selectDI = new ASTNode((Token)new CommonToken(900, "TOK_SELECTDI"));
        for (String tabAlias : map.keySet()) {
            for (Map.Entry<String, ColumnInfo> entry : map.get(tabAlias).entrySet()) {
                selectDI.addChild((Tree)SemanticAnalyzer.buildSelExprSubTree(tabAlias, entry.getKey()));
            }
        }
        return selectDI;
    }

    private static ASTNode buildSelExprSubTree(String tableAlias, String col) {
        ASTNode selexpr = new ASTNode((Token)new CommonToken(901, "TOK_SELEXPR"));
        ASTNode tableOrCol = new ASTNode((Token)new CommonToken(973, "TOK_TABLE_OR_COL"));
        ASTNode dot = new ASTNode((Token)new CommonToken(16, "."));
        tableOrCol.addChild((Tree)new ASTNode((Token)new CommonToken(24, tableAlias)));
        dot.addChild((Tree)tableOrCol);
        dot.addChild((Tree)new ASTNode((Token)new CommonToken(24, col)));
        selexpr.addChild((Tree)dot);
        return selexpr;
    }

    private void copyInfoToQueryProperties(QueryProperties queryProperties) {
        if (this.qb != null) {
            queryProperties.setQuery(this.qb.getIsQuery());
            queryProperties.setAnalyzeCommand(this.qb.getParseInfo().isAnalyzeCommand());
            queryProperties.setPartialScanAnalyzeCommand(this.qb.getParseInfo().isPartialScanAnalyzeCommand());
            queryProperties.setNoScanAnalyzeCommand(this.qb.getParseInfo().isNoScanAnalyzeCommand());
            queryProperties.setAnalyzeRewrite(this.qb.isAnalyzeRewrite());
            queryProperties.setCTAS(this.qb.getTableDesc() != null);
            queryProperties.setHasOuterOrderBy(!this.qb.getParseInfo().getIsSubQ() && !this.qb.getParseInfo().getDestToOrderBy().isEmpty());
            queryProperties.setOuterQueryLimit(this.qb.getParseInfo().getOuterQueryLimit());
            queryProperties.setMaterializedView(this.qb.getViewDesc() != null);
        }
    }

    private void warn(String msg) {
        SessionState.getConsole().printInfo(String.format("Warning: %s", msg));
    }

    public List<LoadFileDesc> getLoadFileWork() {
        return this.loadFileWork;
    }

    public void setLoadFileWork(List<LoadFileDesc> loadFileWork) {
        this.loadFileWork = loadFileWork;
    }

    private static class AggregationExprCheck
    implements TreeWizard.ContextVisitor {
        HashMap<String, ASTNode> destAggrExprs;
        boolean isAggr = false;

        public AggregationExprCheck(HashMap<String, ASTNode> destAggrExprs) {
            this.destAggrExprs = destAggrExprs;
        }

        public void visit(Object t, Object parent, int childIndex, Map labels) {
            if (this.isAggr) {
                return;
            }
            if (this.destAggrExprs.values().contains(t)) {
                this.isAggr = true;
            }
        }

        public void reset() {
            this.isAggr = false;
        }

        protected boolean isAggr() {
            return this.isAggr;
        }
    }

    private static class ConstantExprCheck
    implements TreeWizard.ContextVisitor {
        boolean isConstant = true;

        private ConstantExprCheck() {
        }

        public void visit(Object t, Object parent, int childIndex, Map labels) {
            if (!this.isConstant) {
                return;
            }
            ASTNode node = (ASTNode)t;
            if (ParseDriver.adaptor.getType(t) == 973) {
                this.isConstant = false;
            }
        }

        public void reset() {
            this.isConstant = true;
        }

        protected boolean isConstant() {
            return this.isConstant;
        }
    }

    static class PlannerContext {
        protected ASTNode child;
        protected Phase1Ctx ctx_1;

        PlannerContext() {
        }

        void setParseTreeAttr(ASTNode child, Phase1Ctx ctx_1) {
            this.child = child;
            this.ctx_1 = ctx_1;
        }

        void setCTASToken(ASTNode child) {
        }

        void setViewToken(ASTNode child) {
        }

        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
        }

        void setMultiInsertToken(ASTNode child) {
        }

        void resetToken() {
        }
    }

    private static class SortBucketRSCtx {
        ArrayList<ExprNodeDesc> partnCols = null;
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;

        public ArrayList<ExprNodeDesc> getPartnCols() {
            return this.partnCols;
        }

        public void setPartnCols(ArrayList<ExprNodeDesc> partnCols) {
            this.partnCols = partnCols;
        }

        public boolean isMultiFileSpray() {
            return this.multiFileSpray;
        }

        public void setMultiFileSpray(boolean multiFileSpray) {
            this.multiFileSpray = multiFileSpray;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public int getTotalFiles() {
            return this.totalFiles;
        }

        public void setTotalFiles(int totalFiles) {
            this.totalFiles = totalFiles;
        }
    }

    public static class GenericUDAFInfo {
        public ArrayList<ExprNodeDesc> convertedParameters;
        public GenericUDAFEvaluator genericUDAFEvaluator;
        public TypeInfo returnType;
    }

    class CTEClause {
        String alias;
        ASTNode cteNode;
        boolean materialize;
        int reference;
        QBExpr qbExpr;
        List<CTEClause> parents = new ArrayList<CTEClause>();
        Table table;
        SemanticAnalyzer source;

        CTEClause(String alias, ASTNode cteNode) {
            this.alias = alias;
            this.cteNode = cteNode;
        }

        List<Task<? extends Serializable>> getTasks() {
            return this.source == null ? null : this.source.rootTasks;
        }

        List<CTEClause> asExecutionOrder() {
            ArrayList<CTEClause> execution = new ArrayList<CTEClause>();
            this.asExecutionOrder(new HashSet<CTEClause>(), execution);
            return execution;
        }

        void asExecutionOrder(Set<CTEClause> visited, List<CTEClause> execution) {
            for (CTEClause parent : this.parents) {
                if (!visited.add(parent)) continue;
                parent.asExecutionOrder(visited, execution);
            }
            execution.add(this);
        }

        public String toString() {
            return this.alias == null ? "<root>" : this.alias;
        }
    }

    static class Phase1Ctx {
        String dest;
        int nextNum;

        Phase1Ctx() {
        }
    }
}

