/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public class HiveWindowingFixRule
extends RelOptRule {
    public static final HiveWindowingFixRule INSTANCE = new HiveWindowingFixRule();
    private final RelFactories.ProjectFactory projectFactory = HiveRelFactories.HIVE_PROJECT_FACTORY;

    private HiveWindowingFixRule() {
        super(HiveWindowingFixRule.operand(Project.class, (RelOptRuleOperand)HiveWindowingFixRule.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveWindowingFixRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Aggregate aggregate = (Aggregate)call.rel(1);
        int groupingFields = aggregate.getGroupCount() + aggregate.getIndicatorCount();
        HashSet<String> projectExprsDigest = new HashSet<String>();
        HashMap<String, Object> windowingExprsDigestToNodes = new HashMap<String, Object>();
        for (RexNode r : project.getChildExps()) {
            if (r instanceof RexOver) {
                RexOver rexOverNode = (RexOver)r;
                for (RexNode operand : rexOverNode.getOperands()) {
                    if (!(operand instanceof RexInputRef) || ((RexInputRef)operand).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(operand.toString(), operand);
                }
                for (RexNode partitionKey : rexOverNode.getWindow().partitionKeys) {
                    if (!(partitionKey instanceof RexInputRef) || ((RexInputRef)partitionKey).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(partitionKey.toString(), partitionKey);
                }
                for (RexFieldCollation orderKey : rexOverNode.getWindow().orderKeys) {
                    if (!(orderKey.left instanceof RexInputRef) || ((RexInputRef)orderKey.left).getIndex() < groupingFields) continue;
                    windowingExprsDigestToNodes.put(((RexNode)orderKey.left).toString(), orderKey.left);
                }
                continue;
            }
            projectExprsDigest.add(r.toString());
        }
        ArrayList<Object> belowProjectExprs = new ArrayList<Object>();
        ArrayList belowProjectColumnNames = new ArrayList();
        ArrayList<RexInputRef> topProjectExprs = new ArrayList<RexInputRef>();
        int projectCount = project.getChildExps().size();
        for (int i = 0; i < projectCount; ++i) {
            belowProjectExprs.add(project.getChildExps().get(i));
            belowProjectColumnNames.add(project.getRowType().getFieldNames().get(i));
            topProjectExprs.add(RexInputRef.of((int)i, (RelDataType)project.getRowType()));
        }
        boolean windowingFix = false;
        for (Map.Entry windowingExpr : windowingExprsDigestToNodes.entrySet()) {
            if (projectExprsDigest.contains(windowingExpr.getKey())) continue;
            windowingFix = true;
            belowProjectExprs.add(windowingExpr.getValue());
            int colIndex = 0;
            String alias = "window_col_" + colIndex;
            while (belowProjectColumnNames.contains(alias)) {
                alias = "window_col_" + colIndex++;
            }
            belowProjectColumnNames.add(alias);
        }
        if (!windowingFix) {
            return;
        }
        RelNode newProjectRel = this.projectFactory.createProject((RelNode)aggregate, belowProjectExprs, belowProjectColumnNames);
        RelNode newTopProjectRel = this.projectFactory.createProject(newProjectRel, topProjectExprs, project.getRowType().getFieldNames());
        call.transformTo(newTopProjectRel);
    }
}

