/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.LineRecordReader;

public class TextRecordReader
implements RecordReader {
    private LineRecordReader.LineReader lineReader;
    private InputStream in;
    private Text row;
    private Configuration conf;

    @Override
    public void initialize(InputStream in, Configuration conf, Properties tbl) throws IOException {
        this.lineReader = new LineRecordReader.LineReader(in, conf);
        this.in = in;
        this.conf = conf;
    }

    @Override
    public Writable createRow() throws IOException {
        this.row = new Text();
        return this.row;
    }

    @Override
    public int next(Writable row) throws IOException {
        if (this.lineReader == null) {
            return -1;
        }
        int bytesConsumed = this.lineReader.readLine((Text)row);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESCRIPTESCAPE)) {
            return HiveUtils.unescapeText((Text)row);
        }
        return bytesConsumed;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

