/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.utils.CSSMin;
import j2html.utils.JSMin;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class InlineStaticResource {
    public static ContainerTag get(String path, TargetFormat format) {
        String fileString = InlineStaticResource.getFileAsString(path);
        switch (format) {
            case CSS_MIN: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(CSSMin.compress(fileString)));
            }
            case JS_MIN: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(JSMin.compressJs(fileString)));
            }
            case CSS: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(fileString));
            }
            case JS: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(fileString));
            }
        }
        throw new RuntimeException("Invalid target format");
    }

    public static String getFileAsString(String path) {
        try {
            return InlineStaticResource.readFileAsString(InlineStaticResource.class.getResource(path).getPath());
        }
        catch (Exception e1) {
            try {
                return InlineStaticResource.readFileAsString(path);
            }
            catch (Exception e2) {
                throw new RuntimeException("Couldn't find file with path='" + path + "'");
            }
        }
    }

    private static String readFileAsString(String path) throws IOException {
        int c;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(path));
        StringBuilder sb = new StringBuilder();
        while ((c = bufferedReader.read()) >= 0 && c >= 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static enum TargetFormat {
        CSS_MIN,
        CSS,
        JS_MIN,
        JS;

    }
}

