/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContainerTag
extends Tag<ContainerTag> {
    private List<DomContent> children = new ArrayList<DomContent>();

    public ContainerTag(String tagName) {
        super(tagName);
    }

    public ContainerTag with(DomContent child) {
        if (this == child) {
            throw new RuntimeException("Cannot append a tag to itself.");
        }
        if (child == null) {
            return this;
        }
        this.children.add(child);
        return this;
    }

    public ContainerTag condWith(boolean condition, DomContent child) {
        return condition ? this.with(child) : this;
    }

    public ContainerTag with(Iterable<? extends DomContent> children) {
        if (children != null) {
            for (DomContent domContent : children) {
                this.with(domContent);
            }
        }
        return this;
    }

    public ContainerTag condWith(boolean condition, Iterable<? extends DomContent> children) {
        return condition ? this.with(children) : this;
    }

    public ContainerTag with(DomContent ... children) {
        for (DomContent child : children) {
            this.with(child);
        }
        return this;
    }

    public ContainerTag condWith(boolean condition, DomContent ... children) {
        return condition ? this.with(children) : this;
    }

    public ContainerTag withText(String text) {
        return this.with((DomContent)new Text(text));
    }

    @Override
    public String render() {
        StringBuilder rendered = new StringBuilder(this.renderOpenTag());
        if (this.children != null && !this.children.isEmpty()) {
            for (DomContent child : this.children) {
                rendered.append(child.render());
            }
        }
        rendered.append(this.renderCloseTag());
        return rendered.toString();
    }

    @Override
    public void render(Appendable writer) throws IOException {
        writer.append(this.renderOpenTag());
        if (this.children != null && !this.children.isEmpty()) {
            for (DomContent child : this.children) {
                child.render(writer);
            }
        }
        writer.append(this.renderCloseTag());
    }
}

