/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.service.Service;
import org.apache.slider.server.services.workflow.ServiceTerminatingCallable;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.apache.slider.server.services.workflow.WorkflowScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCallbackService<V>
extends WorkflowScheduledExecutorService<ScheduledExecutorService> {
    protected static final Logger LOG = LoggerFactory.getLogger(WorkflowCallbackService.class);
    private final Callable<V> callback;
    private final int delay;
    private final ServiceTerminatingCallable<V> command;
    private ScheduledFuture<V> scheduledFuture;

    public WorkflowCallbackService(String name, Callable<V> callback, int delay, boolean terminate) {
        super(name);
        Preconditions.checkNotNull(callback, (Object)"Null callback argument");
        this.callback = callback;
        this.delay = delay;
        this.command = new ServiceTerminatingCallable<V>((Service)(terminate ? this : null), callback);
    }

    public ScheduledFuture<V> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected void serviceStart() throws Exception {
        LOG.debug("Notifying {} after a delay of {} millis", this.callback, (Object)this.delay);
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ServiceThreadFactory(this.getName(), true));
        this.setExecutor(executorService);
        this.scheduledFuture = executorService.schedule(this.command, (long)this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void serviceStop() throws Exception {
        super.serviceStop();
        if (this.getCallbackException() != null) {
            throw this.getCallbackException();
        }
    }

    public Exception getCallbackException() {
        return this.command.getException();
    }
}

