/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.KeystoreGenerator;
import org.apache.slider.server.services.security.SecurityStore;
import org.apache.slider.server.services.security.SecurityStoreGenerator;
import org.apache.slider.server.services.security.TruststoreGenerator;

public class StoresGenerator {
    static CertificateManager certMgr = new CertificateManager();
    private static SecurityStoreGenerator[] GENERATORS = new SecurityStoreGenerator[]{new KeystoreGenerator(certMgr), new TruststoreGenerator(certMgr)};

    public static SecurityStore[] generateSecurityStores(String hostname, String containerId, String role, AggregateConf instanceDefinition, MapOperations compOps) throws SliderException, IOException {
        ArrayList<SecurityStore> files = new ArrayList<SecurityStore>();
        SecurityStoreGenerator[] securityStoreGeneratorArray = GENERATORS;
        int n = GENERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityStore store;
            SecurityStoreGenerator generator = securityStoreGeneratorArray[n2];
            if (generator.isStoreRequested(compOps) && (store = generator.generate(hostname, containerId, instanceDefinition, compOps, role)) != null) {
                files.add(store);
            }
            ++n2;
        }
        if (files.isEmpty()) {
            throw new SliderException("Security stores were requested but none were generated. Check the AM logs and ensure passwords are configured for the components requiring the stores.");
        }
        return files.toArray(new SecurityStore[files.size()]);
    }
}

