/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.slider.server.servicemonitor.MonitorKeys;
import org.apache.slider.server.servicemonitor.MonitorUtils;
import org.apache.slider.server.servicemonitor.Probe;
import org.apache.slider.server.servicemonitor.ProbeFailedException;
import org.apache.slider.server.servicemonitor.ProbePhase;
import org.apache.slider.server.servicemonitor.ProbeReportHandler;
import org.apache.slider.server.servicemonitor.ProbeStatus;
import org.apache.slider.server.servicemonitor.ProbeWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportingLoop
implements Runnable,
ProbeReportHandler,
MonitorKeys,
Closeable {
    protected static final Logger log = LoggerFactory.getLogger(ReportingLoop.class);
    private final ProbeWorker worker;
    private final Thread workerThread;
    private final int reportInterval;
    private final int probeTimeout;
    private final int bootstrapTimeout;
    private ProbeReportHandler reporter;
    private final String name;
    private volatile boolean mustExit;

    public ReportingLoop(String name, ProbeReportHandler reporter, List<Probe> probes, List<Probe> dependencyProbes, int probeInterval, int reportInterval, int probeTimeout, int bootstrapTimeout) throws IOException {
        this(name, reporter, new ProbeWorker(probes, dependencyProbes, probeInterval, bootstrapTimeout), reportInterval, probeTimeout);
    }

    public ReportingLoop(String name, ProbeReportHandler reporter, ProbeWorker worker, int reportInterval, int probeTimeout) throws IOException {
        this.name = name;
        this.reporter = reporter;
        this.reportInterval = reportInterval;
        this.probeTimeout = probeTimeout;
        this.worker = worker;
        this.bootstrapTimeout = worker.getBootstrapTimeout();
        worker.setReportHandler(this);
        this.workerThread = new Thread((Runnable)worker, "probe thread - " + name);
        worker.init();
    }

    public int getBootstrapTimeout() {
        return this.bootstrapTimeout;
    }

    public ReportingLoop withReporter(ProbeReportHandler reporter) {
        assert (this.reporter == null) : "attempting to reassign reporter ";
        assert (reporter != null) : "new reporter is null";
        this.reporter = reporter;
        return this;
    }

    public boolean startReporting() {
        String description = "Service Monitor for " + this.name + ", probe-interval= " + MonitorUtils.millisToHumanTime(this.worker.interval) + ", report-interval=" + MonitorUtils.millisToHumanTime(this.reportInterval) + ", probe-timeout=" + this.timeoutToStr(this.probeTimeout) + ", bootstrap-timeout=" + this.timeoutToStr(this.bootstrapTimeout);
        log.info("Starting reporting to " + this.reporter + description);
        return this.reporter.commence(this.name, description);
    }

    private String timeoutToStr(int timeout) {
        return timeout >= 0 ? MonitorUtils.millisToHumanTime(timeout) : "not set";
    }

    private void startWorker() {
        log.info("Starting reporting worker thread ");
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    @Override
    public void close() {
        log.info("Stopping reporting");
        this.mustExit = true;
        if (this.worker != null) {
            this.worker.setMustExit();
            this.workerThread.interrupt();
        }
        if (this.reporter != null) {
            this.reporter.unregister();
        }
    }

    @Override
    public void probeFailure(ProbeFailedException exception) {
        this.reporter.probeFailure(exception);
    }

    @Override
    public void probeProcessStateChange(ProbePhase probePhase) {
        this.reporter.probeProcessStateChange(probePhase);
    }

    @Override
    public void probeBooted(ProbeStatus status) {
        this.reporter.probeBooted(status);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void probeResult(ProbePhase phase, ProbeStatus status) {
        this.reporter.probeResult(phase, status);
    }

    @Override
    public boolean commence(String n, String description) {
        return true;
    }

    @Override
    public void unregister() {
    }

    @Override
    public void heartbeat(ProbeStatus status) {
    }

    @Override
    public void probeTimedOut(ProbePhase currentPhase, Probe probe, ProbeStatus lastStatus, long currentTime) {
    }

    @Override
    public void liveProbeCycleCompleted() {
        this.reporter.liveProbeCycleCompleted();
    }

    void reportingLoop() {
        while (!this.mustExit) {
            try {
                boolean heartbeat;
                ProbeStatus workerStatus = this.worker.getLastStatus();
                long now = this.now();
                long lastStatusIssued = workerStatus.getTimestamp();
                long timeSinceLastStatusIssued = now - lastStatusIssued;
                ProbePhase probePhase = this.worker.getProbePhase();
                switch (probePhase) {
                    case DEPENDENCY_CHECKING: {
                        heartbeat = true;
                        break;
                    }
                    case BOOTSTRAPPING: {
                        heartbeat = this.bootstrapTimeout < 0 || timeSinceLastStatusIssued < (long)this.bootstrapTimeout;
                        break;
                    }
                    case LIVE: {
                        heartbeat = timeSinceLastStatusIssued < (long)this.probeTimeout;
                        break;
                    }
                    default: {
                        heartbeat = true;
                    }
                }
                if (heartbeat) {
                    this.reporter.heartbeat(workerStatus);
                } else {
                    this.reporter.probeTimedOut(probePhase, this.worker.getCurrentProbe(), workerStatus, now);
                }
                Thread.sleep(this.reportInterval);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    @Override
    public void run() {
        try {
            this.startWorker();
            this.reportingLoop();
        }
        catch (RuntimeException e) {
            log.warn("Failure in the reporting loop: " + e, (Throwable)e);
            throw e;
        }
    }
}

