/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.slider.server.servicemonitor.MonitorUtils;
import org.apache.slider.server.servicemonitor.Probe;
import org.apache.slider.server.servicemonitor.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortProbe
extends Probe {
    protected static final Logger log = LoggerFactory.getLogger(PortProbe.class);
    private final String host;
    private final int port;
    private final int timeout;

    public PortProbe(String host, int port, int timeout, String name, Configuration conf) throws IOException {
        super("Port probe " + name + " " + host + ":" + port + " for " + timeout + "ms", conf);
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public static PortProbe createPortProbe(Configuration conf, String hostname, int port) throws IOException {
        PortProbe portProbe = new PortProbe(hostname, port, conf.getInt("service.monitor.portprobe.connect.timeout", 1000), "", conf);
        return portProbe;
    }

    @Override
    public void init() throws IOException {
        InetAddress target;
        if (this.port >= 65536) {
            throw new IOException("Port is out of range: " + this.port);
        }
        if (this.host != null) {
            log.debug("looking up host " + this.host);
            target = InetAddress.getByName(this.host);
        } else {
            log.debug("Host is null, retrieving localhost address");
            target = InetAddress.getLocalHost();
        }
        log.info("Checking " + target + ":" + this.port);
    }

    @Override
    public ProbeStatus ping(boolean livePing) {
        ProbeStatus status = new ProbeStatus();
        InetSocketAddress sockAddr = new InetSocketAddress(this.host, this.port);
        Socket socket = new Socket();
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Connecting to " + sockAddr.toString() + " connection-timeout=" + MonitorUtils.millisToHumanTime(this.timeout));
                }
                socket.connect(sockAddr, this.timeout);
                status.succeed(this);
            }
            catch (IOException e) {
                String error = "Probe " + sockAddr + " failed: " + e;
                log.debug(error, (Throwable)e);
                status.fail(this, new IOException(error, e));
                IOUtils.closeSocket((Socket)socket);
            }
        }
        finally {
            IOUtils.closeSocket((Socket)socket);
        }
        return status;
    }
}

