/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorUtils {
    protected static final Logger log = LoggerFactory.getLogger(MonitorUtils.class);

    private MonitorUtils() {
    }

    public static String toPlural(int val) {
        return val != 1 ? "s" : "";
    }

    public static List<String> prepareArgs(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>(args.length);
        StringBuilder argsStr = new StringBuilder("Arguments: [");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            argsStr.append('\"').append(arg).append("\" ");
            if (!arg.isEmpty()) {
                argsList.add(arg);
            }
            ++n2;
        }
        argsStr.append(']');
        log.debug(argsStr.toString());
        return argsList;
    }

    public static String millisToHumanTime(long milliseconds) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        long s = Math.abs(milliseconds / 1000L);
        long m = Math.abs(milliseconds % 1000L);
        if (milliseconds > 0L) {
            formatter.format("%d.%03ds", s, m);
        } else if (milliseconds == 0L) {
            formatter.format("0", new Object[0]);
        } else {
            formatter.format("-%d.%03ds", s, m);
        }
        return sb.toString();
    }

    public static InetSocketAddress getURIAddress(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        return new InetSocketAddress(host, port);
    }

    public static InetAddress getLocalHost() {
        InetAddress localHost;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            localHost = null;
        }
        return localHost;
    }
}

